/*REXX*/
/*
 *  Command line wrapper to set up the Qt environment
 *  Generated on 22 Dec 2005 01:19:13
 */

QMAKESPEC   = 'os2-g++'
QTDIR       = 'E:\DEV\qt\trunk'

GCC_PATH        = 'u:\usr'

trace off
address 'cmd'
'@echo off'

if (RxFuncQuery('SysBootDrive')) then
    call RxFuncAdd 'SysBootDrive', 'RexxUtil', 'SysBootDrive'

/* setup the GCC environment */
/* 'call' GCC_PATH'\bin\gccenv.cmd' GCC_PATH 'VAC308'*/

call value 'QMAKESPEC', QMAKESPEC, 'OS2ENVIRONMENT'
call value 'QTDIR', QTDIR, 'OS2ENVIRONMENT'

call AddPathEnv 'PATH', QTDIR'\bin'
call AddPathEnv 'BEGINLIBPATH', QTDIR'\bin'

/*call value 'MAKESHELL', SysBootDrive()'\os2\cmd.exe', 'OS2ENVIRONMENT'*/

call AddPathEnv 'PATH','u:\moztools', 1
call AddPathEnv 'PATH','u:\make', 1
call AddPathEnv 'BEGINLIBPATH','u:\moztools', 1
call AddPathEnv 'BEGINLIBPATH','u:\make', 1

/*
 * set this to allow for direct linking with DLLs
 * without first making import libraries
 */
call AddPathEnv 'LIBRARY_PATH', SysBootDrive()'\OS2\DLL'
call AddPathEnv 'LIBRARY_PATH', SysBootDrive()'\MPTN\DLL'

parse arg args
'cmd /c' args
exit rc


/* some useful stuff */

AddPathVar: procedure expose (Globals)
    parse arg name, path, prepend, environment
    if (path == '') then return
    if (verify(path, ' +', 'M') > 0) then path = '"'path'"'
    prepend = (prepend == 1)
    os2Env = (translate(environment) == 'OS2ENVIRONMENT')
    if (os2Env) then do
        extLibPath = (translate(name) == 'BEGINLIBPATH' | translate(name) == 'ENDLIBPATH')
        if (extLibPath) then cur = SysQueryExtLibPath(left(name, 1))
        else cur = value(name,, environment)
    end
    else cur = value(name)
    l = length(path)
    p = pos(translate(path), translate(cur))
    cb = ''; ca = ''
    found = (p > 0)
    if (found) then do
        if (p > 1) then cb = substr(cur, p - 1, 1)
        if (p + l <= length(cur)) then ca = substr(cur, p + l, 1)
        found = (cb == '' | cb == ';') & (ca == '' | ca == ';')
    end
    if (found) then do
        if (\prepend) then return
        if (ca == ';') then l = l + 1
        cur = delstr(cur, p, l)
    end
    if (prepend) then do
        if (left(cur, 1) \== ';') then cur = ';'cur
        cur = path||cur
    end
    else do
        if (cur \== '' & right(cur, 1) \== ';') then cur = cur';'
        cur = cur||path
    end
    if (os2Env) then do
        if (extLibPath) then call SysSetExtLibPath cur, left(name, 1)
        else call value name, cur, environment
    end
    else call value name, cur
    return
AddPathEnv: procedure expose (Globals)
    parse arg name, path, prepend
    call AddPathVar name, path, prepend, 'OS2ENVIRONMENT'
    return

