/***************************************************************************
                          cconnectionmanager.h  -  description
                             -------------------
    begin                : Don Mai 16 2002
    copyright            : (C) 2002-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CCONNECTIONMANAGER_H
#define CCONNECTIONMANAGER_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/core/cobject.h>
#include <dclib/core/cstring.h>
#include <dclib/core/cthread.h>
#include <dclib/core/csingleton.h>

typedef enum eHubState {
	ehsNONE,
	ehsONLINE,
	ehsOFFLINE
};

class CClient;
class DCHubObject;
class CConnectionManager;
class CMessageSearchFile;
class CStringList;
class CHttp;
class DCConfigHubListUrl;
class CByteArray;
class CDCMessage;
class CMessageMyInfo;

#ifdef WIN32
template class DLL_EXPORT CSingleton<CConnectionManager>;
#endif

class DLL_EXPORT CConnectionManager : public CSingleton<CConnectionManager> {
public:
	/** */
	CConnectionManager();
	/** */
	virtual ~CConnectionManager();

	/** */
	void ConnectClient( CString hubname, CString server );

	/** send message to all connected servers */
	int SendStringToConnectedServers( CString s, CString hubname = "" );
	/** send a search string (extracted from message) to all connected servers */
	int SendSearchToConnectedServers( CMessageSearchFile *sf, CString hubhost = "" );
	/** send myinfo to all connected servers */
	int SendMyInfoToConnectedServers();
	/** 0: send -1: user offline -2: hub not ready (connection state/handshake) -3: hub offline -4: send error */
	int SendConnectionRequest( CString nick, CString hubname, CString hubhost );
	/** */
	bool SetUserTransferInfo( CString hubname, CString hubhost, CString nick, CDCMessage * msg );
	/** */
	bool IsUserOnline( CString nick, CString hubname, CString hubhost, CList<DCHubObject> * list = 0 );
	/** */
	eHubState IsHubOnline( CString hubname, CString hubhost );
	/** */
	bool IsAdmin( CString hubname, CString hubhost, CString nick = "" );
	/** */
	bool GetUserMyInfo( CString hubname, CString hubhost, CString nick, CMessageMyInfo * p );
	/** */
	CString GetHubHost( CString hubname );
	/** */
	CString GetNick( CString hubname, CString hubhost );
	
	/** */
	long GetConnectedHubCount( bool admin = FALSE );
	
	/** Returns the number of hubs which we logged into with a password */
	long GetConnectedHubPasswordCount();

	/** */
	CStringList * GetConnectedHubServerList();

	/** */
	void Connect( CString hubname, CString server, CClient * client, bool sslconnect = FALSE );

	/** callback function */
	virtual int DC_CallBack( CObject * ) { return -1; };

protected:
	/** */
	void AddHub( CClient * client );
	/** */
	void RemoveHub( CClient * client );

	/** */
	CClient * GetHub( CString hubname, CString hubhost );

	/** */
	CThread m_Thread;
	/** client list */
	CThreadList<CClient> * m_pClientList;

private:
	/** */
	CClient * GetHubObject( CString hubname, CString hubhost );
	/** */
	void UpdateMyInfo( CClient* client );
	
	/** thread callbackfunction */
	int Callback( CObject * , CObject * );

	/** */
	int SM_ClientCallBack( CObject * Sender, CObject * Object );

	/** */
	bool m_bUpdateMyinfo;

	/** */
	_CCallback * m_pCallback;
};

#endif
