/***************************************************************************
                          cmessagehandler.h  -  description
                             -------------------
    begin                : Sun Sep 30 2001
    copyright            : (C) 2001-2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CMESSAGEHANDLER_H
#define CMESSAGEHANDLER_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/dcobject.h>
#include <dclib/core/cobject.h>
#include <dclib/core/cstring.h>
#include <dclib/core/ciconv.h>

class DLL_EXPORT CMessageHandler {
public: 
	/** */
	CMessageHandler();
	/** */
	virtual ~CMessageHandler();

	/** */
	int GetContent( const CString sMessage, const CString * sData, CString & sContent );
	/** */
	eDCMessage Parse( const CString * sMessage, int & pointer, CObject *& Object );

	/** */
	CObject * ParseLock( CString sContent );
	/** */
	CObject * ParseHello( CString sContent );
	/** */
	CObject * ParseMyNick( CString sContent );
	/** */
	CObject * ParseChat( CString sContent );
	/** */
	CObject * ParseMyInfo( CString sContent );
	/** */
	CObject * ParseNickList( CString sContent );
	/** */
	CObject * ParseOpList( CString sContent );
	/** */
	CObject * ParseConnectToMe( CString sContent );
	/** */
	CObject * ParseRevConnectToMe( CString sContent );
	/** */
	CObject * ParseQuit( CString sContent );
	/** */
	CObject * ParseSearch( CString sContent );
	/** */
	CObject * ParseSearchResult( CString sContent );
	/** */
	CObject * ParseSearchResultFile( CString sContent );
	/** */
	CObject * ParseSearchResultFolder( CString sContent );
	/** */
	CObject * ParsePrivateChat( CString sContent );
	/** */
	CObject * ParseForceMove( CString sContent );
	/** */
	CObject * ParseDirection( CString sContent );
	/** */
	CObject * ParseFileLength( CString sContent );
	/** */
	CObject * ParseGet( CString sContent );
	/** */
	CObject * ParseUGetBlock( CString sContent );
	/** */
	CObject * ParseError( CString sContent );
	/** */
	CObject * ParseGetInfo( CString sContent );
	/** */
	CObject * ParseHubName( CString sContent );
	/** */
	CObject * ParseLogedIn( CString sContent );
	/** */
	CObject * ParseSupports( CString sContent );
	/** */
	CObject * ParseCapabilities( CString sContent );
	/** */
	CObject * ParseHubTopic( CString sContent );
	/** */
	CObject * ParseUserCommand( CString sContent );
	/** */
	CObject * ParseYourIP( CString sContent );
	/** */
	CObject * ParseGetZBlock( CString sContent );
	/** */
	CObject * ParseSending( CString sContent );
	/** */
	CObject * ParseADCGet( CString sContent );
	/** */
	CObject * ParseADCSnd( CString sContent );

private:
	/** CIconv object for doing text encoding */
	CIconv * m_pIconv;
};

#endif
