/*
** FAAD2 - Freeware Advanced Audio (AAC) Decoder including SBR decoding
** Copyright (C) 2003-2004 M. Bakker, Ahead Software AG, http://www.nero.com
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
** Any non-GPL usage of this software or parts of this software is strictly
** forbidden.
**
** Commercial non-GPL licensing of this software is possible.
** For more info contact Ahead Software through Mpeg4AAClicense@nero.com.
**
** $Id: iq_table.h,v 1.2 2005/04/22 13:05:10 vladest Exp $
**/

#ifndef IQ_TABLE_H__
#define IQ_TABLE_H__

#ifdef __cplusplus
extern "C" {
#endif


/* !!!DON'T CHANGE IQ_TABLE_SIZE!!! */


#ifndef FIXED_POINT

#define IQ_TABLE_SIZE 8192

#ifdef _MSC_VER
#pragma warning(disable:4305)
#pragma warning(disable:4244)
#endif

ALIGN static const real_t iq_table[IQ_TABLE_SIZE] =
{
    0,
    1,
    2.5198420997897464,
    4.3267487109222245,
    6.3496042078727974,
    8.5498797333834844,
    10.902723556992836,
    13.390518279406722,
    15.999999999999998,
    18.720754407467133,
    21.544346900318832,
    24.463780996262464,
    27.47314182127996,
    30.567350940369842,
    33.741991698453212,
    36.993181114957046,
    40.317473596635935,
    43.711787041189993,
    47.173345095760126,
    50.699631325716943,
    54.288352331898118,
    57.937407704003519,
    61.6448652744185,
    65.408940536585988,
    69.227979374755591,
    73.100443455321638,
    77.024897778591622,
    80.999999999999986,
    85.024491212518527,
    89.097187944889555,
    93.216975178615741,
    97.382800224133163,
    101.59366732596474,
    105.84863288986224,
    110.14680124343441,
    114.4873208566006,
    118.86938096020653,
    123.29220851090024,
    127.75506545836058,
    132.25724627755247,
    136.79807573413572,
    141.37690685569191,
    145.99311908523086,
    150.6461165966291,
    155.33532675434674,
    160.06019870205279,
    164.82020206673349,
    169.61482576651861,
    174.44357691188537,
    179.30597979112557,
    184.20157493201927,
    189.12991823257562,
    194.09058015449685,
    199.08314497371677,
    204.1072100829694,
    209.16238534187647,
    214.24829247050752,
    219.36456448277784,
    224.51084515641216,
    229.6867885365223,
    234.89205847013176,
    240.12632816923249,
    245.38927980018505,
    250.68060409747261,
    255.99999999999991,
    261.34717430828869,
    266.72184136106449,
    272.12372272986045,
    277.55254693037961,
    283.0080491494619,
    288.48997098659891,
    293.99806020902247,
    299.53207051947408,
    305.0917613358298,
    310.67689758182206,
    316.28724948815585,
    321.92259240337177,
    327.58270661385535,
    333.26737717243742,
    338.97639373507025,
    344.70955040510125,
    350.46664558470013,
    356.24748183302603,
    362.05186573075139,
    367.87960775058258,
    373.73052213344511,
    379.60442677002078,
    385.50114308734607,
    391.42049594019937,
    397.36231350702371,
    403.32642719014467,
    409.31267152006262,
    415.32088406360799,
    421.35090533576471,
    427.40257871497619,
    433.4757503617617,
    439.5702691404793,
    445.68598654408271,
    451.82275662172759,
    457.98043590909128,
    464.15888336127773,
    470.35796028818726,
    476.5775302922363,
    482.81745920832043,
    489.07761504591741,
    495.35786793323581,
    501.65809006331688,
    507.97815564200368,
    514.31794083769648,
    520.67732373281672,
    527.05618427690604,
    533.45440424129174,
    539.87186717525128,
    546.30845836361505,
    552.76406478574609,
    559.23857507584194,
    565.73187948450413,
    572.24386984152341,
    578.77443951983378,
    585.32348340058843,
    591.89089783931263,
    598.47658063309257,
    605.08043098876044,
    611.70234949203643,
    618.3422380775919,
    624.99999999999977,
    631.67553980553748,
    638.36876330481164,
    645.07957754617485,
    651.80789078990415,
    658.55361248311499,
    665.31665323538357,
    672.09692479505225,
    678.8943400261943,
    685.70881288621433,
    692.540258404062,
    699.38859265903977,
    706.25373276018058,
    713.13559682617972,
    720.03410396586037,
    726.94917425915435,
    733.88072873858209,
    740.82868937121543,
    747.79297904110535,
    754.77352153216191,
    761.77024151147043,
    768.78306451302956,
    775.81191692189896,
    782.85672595874246,
    789.91741966475445,
    796.99392688695798,
    804.08617726386274,
    811.19410121147098,
    818.31762990962227,
    825.45669528866563,
    832.61123001644864,
    839.78116748561604,
    846.96644180120552,
    854.16698776853514,
    861.38274088137143,
    868.61363731036977,
    875.85961389178203,
    883.12060811641959,
    890.39655811886757,
    897.68740266694181,
    904.99308115138172,
    912.31353357577188,
    919.64870054668756,
    926.99852326405619,
    934.36294351172899,
    941.74190364825859,
    949.13534659787422,
    956.54321584165211,
    963.96545540887348,
    971.40200986856541,
    978.85282432122176,
    986.31784439069588,
    993.7970162162635,
    1001.29028644485,
    1008.797602223418,
    1016.3189111915103,
    1023.8541614739464,
    1031.4033016736653,
    1038.9662808647138,
    1046.5430485853758,
    1054.1335548314366,
    1061.7377500495838,
    1069.3555851309357,
    1076.9870114046978,
    1084.6319806319441,
    1092.2904449995174,
    1099.9623571140482,
    1107.6476699960892,
    1115.3463370743607,
    1123.058312180106,
    1130.7835495415541,
    1138.5220037784854,
    1146.273629896901,
    1154.0383832837879,
    1161.816219701986,
    1169.607095285146,
    1177.4109665327808,
    1185.2277903054078,
    1193.0575238197798,
    1200.9001246442001,
    1208.7555506939248,
    1216.6237602266442,
    1224.5047118380478,
    1232.3983644574657,
    1240.3046773435874,
    1248.2236100802568,
    1256.1551225723395,
    1264.099175041662,
    1272.0557280230228,
    1280.0247423602691,
    1288.0061792024444,
    1295.9999999999995,
    1304.006166501068,
    1312.0246407478062,
    1320.0553850727929,
    1328.0983620954903,
    1336.1535347187651,
    1344.2208661254647,
    1352.3003197750522,
    1360.3918594002962,
    1368.4954490040145,
    1376.6110528558709,
    1384.7386354892244,
    1392.8781616980295,
    1401.0295965337855,
    1409.1929053025353,
    1417.3680535619119,
    1425.5550071182327,
    1433.7537320236374,
    1441.9641945732744,
    1450.1863613025282,
    1458.4201989842913,
    1466.6656746262797,
    1474.9227554683875,
    1483.1914089800841,
    1491.4716028578516,
    1499.7633050226596,
    1508.0664836174794,
    1516.3811070048375,
    1524.7071437644029,
    1533.0445626906128,
    1541.3933327903342,
    1549.7534232805581,
    1558.1248035861302,
    1566.507443337515,
    1574.9013123685909,
    1583.3063807144795,
    1591.7226186094069,
    1600.1499964845941,
    1608.58848496618,
    1617.0380548731737,
    1625.4986772154357,
    1633.9703231916887,
    1642.4529641875577,
    1650.9465717736346,
    1659.4511177035752,
    1667.9665739122186,
    1676.4929125137353,
    1685.030105799801,
    1693.5781262377957,
    1702.136946469027,
    1710.7065393069795,
    1719.2868777355877,
    1727.8779349075323,
    1736.4796841425596,
    1745.092098925825,
    1753.7151529062583,
    1762.3488198949503,
    1770.9930738635628,
    1779.6478889427597,
    1788.3132394206564,
    1796.9890997412947,
    1805.6754445031333,
    1814.3722484575621,
    1823.0794865074322,
    1831.7971337056094,
    1840.5251652535437,
    1849.2635564998579,
    1858.0122829389563,
    1866.7713202096493,
    1875.5406440937966,
    1884.3202305149687,
    1893.110055537124,
    1901.9100953633042,
    1910.7203263343454,
    1919.5407249276057,
    1928.3712677557098,
    1937.2119315653083,
    1946.0626932358525,
    1954.923529778386,
    1963.79441833435,
    1972.6753361744036,
    1981.5662606972594,
    1990.467169428533,
    1999.3780400196069,
    2008.2988502465078,
    2017.2295780087982,
    2026.1702013284819,
    2035.1206983489212,
    2044.0810473337688,
    2053.0512266659125,
    2062.0312148464309,
    2071.0209904935646,
    2080.0205323416958,
    2089.0298192403443,
    2098.0488301531714,
    2107.0775441569995,
    2116.115940440839,
    2125.1639983049317,
    2134.2216971597995,
    2143.2890165253098,
    2152.3659360297484,
    2161.4524354089031,
    2170.5484945051617,
    2179.6540932666144,
    2188.7692117461711,
    2197.8938301006888,
    2207.0279285901042,
    2216.1714875765838,
    2225.324487523676,
    2234.4869089954782,
    2243.6587326558101,
    2252.8399392673982,
    2262.0305096910702,
    2271.2304248849537,
    2280.4396659036897,
    2289.6582138976523,
    2298.8860501121762,
    2308.1231558867926,
    2317.3695126544767,
    2326.6251019409005,
    2335.8899053636933,
    2345.1639046317132,
    2354.4470815443233,
    2363.7394179906792,
    2373.0408959490205,
    2382.3514974859731,
    2391.6712047558558,
    2400.9999999999991,
    2410.3378655460651,
    2419.6847838073813,
    2429.0407372822747,
    2438.4057085534191,
    2447.7796802871858,
    2457.1626352330004,
    2466.5545562227112,
    2475.9554261699564,
    2485.3652280695474,
    2494.7839449968492,
    2504.2115601071737,
    2513.6480566351788,
    2523.0934178942675,
    2532.5476272760025,
    2542.0106682495189,
    2551.482524360948,
    2560.9631792328441,
    2570.4526165636184,
    2579.9508201269791,
    2589.4577737713744,
    2598.9734614194458,
    2608.4978670674823,
    2618.0309747848837,
    2627.5727687136259,
    2637.1232330677353,
    2646.6823521327647,
    2656.2501102652768,
    2665.8264918923328,
    2675.4114815109842,
    2685.0050636877722,
    2694.6072230582295,
    2704.2179443263894,
    2713.8372122642972,
    2723.4650117115279,
    2733.1013275747096,
    2742.7461448270483,
    2752.3994485078601,
    2762.0612237221085,
    2771.7314556399419,
    2781.4101294962406,
    2791.0972305901655,
    2800.7927442847094,
    2810.4966560062589,
    2820.2089512441521,
    2829.9296155502466,
    2839.6586345384894,
    2849.3959938844923,
    2859.1416793251065,
    2868.8956766580086,
    2878.6579717412847,
    2888.4285504930212,
    2898.2073988908974,
    2907.9945029717837,
    2917.789848831344,
    2927.5934226236377,
    2937.4052105607311,
    2947.2251989123079,
    2957.0533740052865,
    2966.8897222234368,
    2976.734230007005,
    2986.5868838523397,
    2996.4476703115197,
    3006.3165759919889,
    3016.1935875561908,
    3026.0786917212095,
    3035.9718752584108,
    3045.8731249930906,
    3055.7824278041207,
    3065.6997706236039,
    3075.625140436528,
    3085.5585242804245,
    3095.4999092450298,
    3105.4492824719491,
    3115.4066311543256,
    3125.3719425365089,
    3135.3452039137287,
    3145.3264026317715,
    3155.3155260866592,
    3165.3125617243295,
    3175.3174970403229,
    3185.3303195794679,
    3195.35101693557,
    3205.3795767511078,
    3215.4159867169251,
    3225.460234571929,
    3235.5123081027928,
    3245.5721951436558,
    3255.63988357583,
    3265.7153613275095,
    3275.7986163734795,
    3285.8896367348289,
    3295.9884104786665,
    3306.0949257178395,
    3316.2091706106517,
    3326.331133360588,
    3336.4608022160378,
    3346.5981654700231,
    3356.7432114599264,
    3366.8959285672249,
    3377.0563052172211,
    3387.2243298787821,
    3397.3999910640764,
    3407.5832773283128,
    3417.7741772694862,
    3427.9726795281199,
    3438.1787727870123,
    3448.3924457709873,
    3458.6136872466445,
    3468.8424860221107,
    3479.0788309467976,
    3489.3227109111554,
    3499.5741148464344,
    3509.8330317244445,
    3520.0994505573185,
    3530.3733603972751,
    3540.6547503363886,
    3550.9436095063534,
    3561.239927078258,
    3571.5436922623535,
    3581.8548943078308,
    3592.1735225025936,
    3602.4995661730372,
    3612.8330146838275,
    3623.1738574376814,
    3633.5220838751502,
    3643.8776834744031,
    3654.2406457510142,
    3664.6109602577494,
    3674.9886165843564,
    3685.3736043573545,
    3695.7659132398294,
    3706.1655329312248,
    3716.5724531671399,
    3726.9866637191262,
    3737.4081543944876,
    3747.8369150360782,
    3758.2729355221072,
    3768.7162057659411,
    3779.1667157159077,
    3789.6244553551055,
    3800.0894147012082,
    3810.5615838062768,
    3821.0409527565694,
    3831.5275116723533,
    3842.0212507077194,
    3852.522160050396,
    3863.0302299215673,
    3873.5454505756893,
    3884.0678123003108,
    3894.5973054158922,
    3905.1339202756285,
    3915.6776472652732,
    3926.2284768029604,
    3936.7863993390338,
    3947.3514053558706,
    3957.9234853677135,
    3968.5026299204969,
    3979.0888295916798,
    3989.6820749900776,
    4000.2823567556948,
    4010.8896655595613,
    4021.5039921035655,
    4032.1253271202945,
    4042.7536613728694,
    4053.3889856547858,
    4064.0312907897551,
    4074.6805676315448,
    4085.3368070638221,
    4095.9999999999982,
    4106.6701373830711,
    4117.347210185475,
    4128.0312094089259,
    4138.722126084268,
    4149.4199512713267,
    4160.1246760587583,
    4170.8362915638982,
    4181.5547889326181,
    4192.2801593391769,
    4203.0123939860741,
    4213.7514841039101,
    4224.4974209512384,
    4235.2501958144258,
    4246.0098000075095,
    4256.7762248720574,
    4267.549461777031,
    4278.3295021186423,
    4289.1163373202198,
    4299.9099588320714,
    4310.7103581313495,
    4321.5175267219138,
    4332.3314561342004,
    4343.152137925088,
    4353.9795636777671,
    4364.8137250016052,
    4375.6546135320223,
    4386.5022209303588,
    4397.3565388837469,
    4408.2175591049827,
    4419.0852733324018,
    4429.9596733297531,
    4440.8407508860728,
    4451.7284978155603,
    4462.6229059574571,
    4473.5239671759227,
    4484.4316733599126,
    4495.3460164230582,
    4506.2669883035496,
    4517.1945809640119,
    4528.1287863913894,
    4539.069596596828,
    4550.0170036155587,
    4560.9709995067806,
    4571.931576353546,
    4582.898726262647,
    4593.8724413645004,
    4604.8527138130348,
    4615.8395357855816,
    4626.8328994827571,
    4637.8327971283588,
    4648.8392209692511,
    4659.8521632752563,
    4670.8716163390473,
    4681.8975724760394,
    4692.9300240242837,
    4703.9689633443595,
    4715.0143828192668,
    4726.0662748543255,
    4737.1246318770682,
    4748.1894463371373,
    4759.2607107061804,
    4770.3384174777493,
    4781.4225591671993,
    4792.5131283115852,
    4803.6101174695614,
    4814.7135192212854,
    4825.8233261683154,
    4836.9395309335096,
    4848.0621261609349,
    4859.1911045157631,
    4870.3264586841779,
    4881.4681813732768,
    4892.6162653109768,
    4903.7707032459193,
    4914.931487947375,
    4926.0986122051509,
    4937.2720688294967,
    4948.4518506510112,
    4959.637950520555,
    4970.8303613091521,
    4982.0290759079044,
    4993.2340872278974,
    5004.4453882001153,
    5015.6629717753467,
    5026.8868309241007,
    5038.1169586365131,
    5049.353347922266,
    5060.5959918104927,
    5071.8448833496996,
    5083.1000156076734,
    5094.3613816713996,
    5105.6289746469747,
    5116.9027876595246,
    5128.18281385312,
    5139.4690463906918,
    5150.7614784539473,
    5162.0601032432933,
    5173.3649139777472,
    5184.6759038948594,
    5195.9930662506322,
    5207.3163943194386,
    5218.6458813939435,
    5229.9815207850224,
    5241.3233058216847,
    5252.6712298509919,
    5264.025286237983,
    5275.3854683655954,
    5286.7517696345885,
    5298.1241834634639,
    5309.5027032883945,
    5320.887322563146,
    5332.2780347589978,
    5343.6748333646756,
    5355.0777118862716,
    5366.4866638471722,
    5377.901682787985,
    5389.3227622664635,
    5400.749895857437,
    5412.1830771527357,
    5423.622299761123,
    5435.067557308219,
    5446.5188434364318,
    5457.9761518048872,
    5469.4394760893592,
    5480.9088099821975,
    5492.3841471922606,
    5503.8654814448455,
    5515.3528064816201,
    5526.846116060552,
    5538.3454039558474,
    5549.8506639578736,
    5561.3618898731029,
    5572.8790755240361,
    5584.4022147491451,
    5595.9313014027975,
    5607.4663293552012,
    5619.0072924923297,
    5630.5541847158656,
    5642.1069999431284,
    5653.665732107017,
    5665.230375155943,
    5676.8009230537655,
    5688.3773697797333,
    5699.9597093284156,
    5711.5479357096474,
    5723.1420429484588,
    5734.7420250850209,
    5746.347876174581,
    5757.9595902874016,
    5769.5771615087006,
    5781.2005839385911,
    5792.8298516920213,
    5804.4649588987149,
    5816.1058997031105,
    5827.7526682643065,
    5839.4052587559972,
    5851.0636653664196,
    5862.7278822982908,
    5874.3979037687541,
    5886.0737240093204,
    5897.7553372658094,
    5909.4427377982956,
    5921.1359198810505,
    5932.8348778024874,
    5944.5396058651031,
    5956.2500983854261,
    5967.9663496939575,
    5979.6883541351208,
    5991.4161060672022,
    6003.1495998623004,
    6014.8888299062692,
    6026.6337905986684,
    6038.3844763527022,
    6050.1408815951781,
    6061.9030007664414,
    6073.6708283203316,
    6085.4443587241267,
    6097.2235864584891,
    6109.0085060174197,
    6120.7991119081998,
    6132.595398651345,
    6144.3973607805519,
    6156.2049928426459,
    6168.0182893975361,
    6179.8372450181578,
    6191.6618542904307,
    6203.4921118132024,
    6215.3280121982016,
    6227.1695500699925,
    6239.0167200659189,
    6250.8695168360628,
    6262.7279350431891,
    6274.5919693627056,
    6286.4616144826068,
    6298.3368651034316,
    6310.2177159382172,
    6322.1041617124456,
    6333.9961971640032,
    6345.8938170431311,
    6357.7970161123785,
    6369.7057891465583,
    6381.6201309327007,
    6393.5400362700075,
    6405.4654999698032,
    6417.3965168554978,
    6429.3330817625329,
    6441.2751895383453,
    6453.2228350423138,
    6465.176013145724,
    6477.134718731716,
    6489.0989466952469,
    6501.0686919430445,
    6513.0439493935628,
    6525.0247139769417,
    6537.010980634961,
    6549.002744321001,
    6560.9999999999973,
    6573.0027426483985,
    6585.0109672541284,
    6597.0246688165371,
    6609.0438423463656,
    6621.0684828657004,
    6633.0985854079354,
    6645.134145017727,
    6657.1751567509573,
    6669.2216156746908,
    6681.2735168671343,
    6693.3308554176001,
    6705.3936264264594,
    6717.461825005108,
    6729.535446275926,
    6741.6144853722335,
    6753.6989374382601,
    6765.7887976290967,
    6777.8840611106634,
    6789.9847230596661,
    6802.0907786635626,
    6814.2022231205201,
    6826.3190516393797,
    6838.4412594396181,
    6850.5688417513074,
    6862.701793815083,
    6874.840110882099,
    6886.9837882139991,
    6899.1328210828724,
    6911.2872047712199,
    6923.4469345719199,
    6935.6120057881863,
    6947.7824137335365,
    6959.9581537317536,
    6972.1392211168532,
    6984.3256112330409,
    6996.5173194346862,
    7008.7143410862773,
    7020.9166715623942,
    7033.1243062476678,
    7045.3372405367481,
    7057.5554698342685,
    7069.7789895548103,
    7082.0077951228714,
    7094.2418819728273,
    7106.4812455489018,
    7118.7258813051285,
    7130.9757847053224,
    7143.2309512230404,
    7155.4913763415516,
    7167.7570555538041,
    7180.0279843623894,
    7192.3041582795131,
    7204.5855728269571,
    7216.8722235360519,
    7229.1641059476406,
    7241.4612156120484,
    7253.7635480890503,
    7266.0710989478375,
    7278.3838637669869,
    7290.7018381344296,
    7303.0250176474174,
    7315.3533979124932,
    7327.6869745454596,
    7340.0257431713462,
    7352.3696994243801,
    7364.7188389479543,
    7377.0731573945968,
    7389.4326504259407,
    7401.7973137126937,
    7414.1671429346061,
    7426.5421337804428,
    7438.922281947951,
    7451.3075831438346,
    7463.6980330837177,
    7476.0936274921214,
    7488.4943621024304,
    7500.9002326568652,
    7513.3112349064522,
    7525.7273646109943,
    7538.1486175390446,
    7550.5749894678729,
    7563.0064761834419,
    7575.4430734803736,
    7587.8847771619248,
    7600.3315830399597,
    7612.7834869349153,
    7625.24048467578,
    7637.7025721000637,
    7650.1697450537677,
    7662.6419993913596,
    7675.1193309757446,
    7687.6017356782404,
    7700.0892093785433,
    7712.5817479647112,
    7725.079347333125,
    7737.5820033884729,
    7750.0897120437139,
    7762.6024692200581,
    7775.1202708469355,
    7787.6431128619733,
    7800.1709912109645,
    7812.7039018478481,
    7825.2418407346768,
    7837.7848038415968,
    7850.3327871468155,
    7862.8857866365806,
    7875.4437983051539,
    7888.006818154784,
    7900.5748421956796,
    7913.1478664459901,
    7925.725886931772,
    7938.3088996869719,
    7950.8969007533951,
    7963.4898861806851,
    7976.0878520262959,
    7988.6907943554688,
    8001.2987092412086,
    8013.911592764257,
    8026.5294410130691,
    8039.1522500837891,
    8051.7800160802271,
    8064.412735113835,
    8077.0504033036796,
    8089.6930167764222,
    8102.3405716662946,
    8114.9930641150731,
    8127.6504902720571,
    8140.3128462940449,
    8152.9801283453098,
    8165.6523325975786,
    8178.3294552300049,
    8191.0114924291529,
    8203.6984403889655,
    8216.3902953107463,
    8229.0870534031419,
    8241.7887108821069,
    8254.4952639708936,
    8267.2067089000211,
    8279.9230419072574,
    8292.6442592375952,
    8305.3703571432306,
    8318.101331883543,
    8330.8371797250657,
    8343.577896941475,
    8356.3234798135582,
    8369.0739246291978,
    8381.8292276833508,
    8394.5893852780209,
    8407.3543937222421,
    8420.1242493320569,
    8432.8989484304948,
    8445.6784873475499,
    8458.4628624201578,
    8471.2520699921806,
    8484.0461064143838,
    8496.8449680444082,
    8509.6486512467636,
    8522.4571523927953,
    8535.270467860666,
    8548.0885940353437,
    8560.9115273085663,
    8573.7392640788403,
    8586.5718007514006,
    8599.4091337382069,
    8612.2512594579148,
    8625.0981743358552,
    8637.9498748040205,
    8650.8063573010386,
    8663.6676182721567,
    8676.533654169225,
    8689.4044614506638,
    8702.2800365814601,
    8715.1603760331418,
    8728.0454762837508,
    8740.9353338178389,
    8753.8299451264356,
    8766.7293067070332,
    8779.6334150635721,
    8792.5422667064158,
    8805.4558581523324,
    8818.3741859244819,
    8831.2972465523908,
    8844.2250365719356,
    8857.1575525253265,
    8870.0947909610859,
    8883.0367484340295,
    8895.9834215052524,
    8908.934806742107,
    8921.8909007181846,
    8934.8517000132997,
    8947.817201213471,
    8960.7874009109,
    8973.7622957039603,
    8986.7418821971733,
    8999.7261570011924,
    9012.7151167327884,
    9025.7087580148236,
    9038.7070774762469,
    9051.7100717520643,
    9064.7177374833282,
    9077.7300713171153,
    9090.7470699065179,
    9103.7687299106146,
    9116.7950479944648,
    9129.8260208290812,
    9142.8616450914233,
    9155.9019174643727,
    9168.9468346367157,
    9181.9963933031358,
    9195.0505901641845,
    9208.1094219262741,
    9221.1728853016557,
    9234.240977008405,
    9247.3136937704076,
    9260.3910323173386,
    9273.472989384647,
    9286.5595617135423,
    9299.6507460509747,
    9312.7465391496207,
    9325.8469377678684,
    9338.9519386698012,
    9352.0615386251757,
    9365.1757344094131,
    9378.2945228035842,
    9391.4179005943843,
    9404.5458645741273,
    9417.6784115407263,
    9430.8155382976747,
    9443.9572416540359,
    9457.1035184244265,
    9470.2543654290002,
    9483.4097794934296,
    9496.5697574488931,
    9509.7342961320664,
    9522.9033923850911,
    9536.0770430555804,
    9549.2552449965824,
    9562.4379950665825,
    9575.6252901294793,
    9588.8171270545736,
    9602.0135027165488,
    9615.2144139954635,
    9628.4198577767274,
    9641.629830951093,
    9654.844330414644,
    9668.0633530687719,
    9681.286895820167,
    9694.5149555808002,
    9707.7475292679192,
    9720.9846138040157,
    9734.2262061168276,
    9747.4723031393187,
    9760.7229018096641,
    9773.9779990712323,
    9787.2375918725811,
    9800.5016771674327,
    9813.7702519146696,
    9827.0433130783094,
    9840.3208576275028,
    9853.602882536512,
    9866.8893847846994,
    9880.1803613565116,
    9893.4758092414686,
    9906.7757254341523,
    9920.0801069341851,
    9933.3889507462245,
    9946.7022538799429,
    9960.0200133500221,
    9973.3422261761298,
    9986.6688893829159,
    9999.9999999999945,
    10013.335555061929,
    10026.675551608221,
    10040.019986683301,
    10053.368857336509,
    10066.722160622081,
    10080.079893599144,
    10093.442053331697,
    10106.808636888598,
    10120.179641343551,
    10133.555063775095,
    10146.934901266595,
    10160.31915090622,
    10173.707809786936,
    10187.100875006496,
    10200.498343667417,
    10213.900212876984,
    10227.306479747222,
    10240.717141394889,
    10254.132194941467,
    10267.551637513146,
    10280.975466240814,
    10294.40367826004,
    10307.836270711066,
    10321.273240738796,
    10334.71458549278,
    10348.160302127204,
    10361.610387800878,
    10375.064839677221,
    10388.523654924258,
    10401.986830714593,
    10415.454364225412,
    10428.926252638465,
    10442.402493140049,
    10455.883082921007,
    10469.368019176709,
    10482.85729910704,
    10496.350919916393,
    10509.848878813653,
    10523.351173012188,
    10536.857799729838,
    10550.3687561889,
    10563.884039616123,
    10577.403647242685,
    10590.927576304197,
    10604.455824040679,
    10617.988387696556,
    10631.525264520642,
    10645.066451766135,
    10658.611946690598,
    10672.161746555956,
    10685.715848628475,
    10699.274250178762,
    10712.836948481747,
    10726.403940816675,
    10739.975224467091,
    10753.550796720834,
    10767.130654870027,
    10780.714796211059,
    10794.303218044579,
    10807.895917675487,
    10821.492892412922,
    10835.094139570248,
    10848.699656465047,
    10862.309440419107,
    10875.923488758415,
    10889.541798813138,
    10903.16436791762,
    10916.791193410372,
    10930.422272634056,
    10944.05760293548,
    10957.697181665582,
    10971.341006179427,
    10984.98907383619,
    10998.641381999149,
    11012.297928035676,
    11025.958709317223,
    11039.623723219316,
    11053.292967121541,
    11066.966438407539,
    11080.64413446499,
    11094.326052685608,
    11108.012190465128,
    11121.702545203296,
    11135.397114303863,
    11149.095895174571,
    11162.798885227143,
    11176.506081877278,
    11190.217482544635,
    11203.933084652828,
    11217.652885629415,
    11231.376882905886,
    11245.105073917659,
    11258.837456104062,
    11272.574026908333,
    11286.314783777601,
    11300.059724162888,
    11313.808845519083,
    11327.562145304952,
    11341.319620983111,
    11355.081270020033,
    11368.847089886023,
    11382.617078055218,
    11396.391232005579,
    11410.169549218874,
    11423.952027180676,
    11437.738663380349,
    11451.529455311042,
    11465.324400469679,
    11479.123496356951,
    11492.926740477304,
    11506.734130338931,
    11520.545663453764,
    11534.361337337466,
    11548.181149509423,
    11562.005097492724,
    11575.83317881417,
    11589.665391004253,
    11603.501731597149,
    11617.342198130715,
    11631.186788146468,
    11645.035499189589,
    11658.888328808911,
    11672.745274556904,
    11686.606333989675,
    11700.471504666955,
    11714.340784152086,
    11728.214170012021,
    11742.091659817312,
    11755.973251142101,
    11769.858941564111,
    11783.748728664636,
    11797.642610028539,
    11811.540583244237,
    11825.442645903697,
    11839.34879560242,
    11853.259029939445,
    11867.173346517333,
    11881.091742942155,
    11895.014216823492,
    11908.940765774427,
    11922.871387411526,
    11936.806079354839,
    11950.744839227897,
    11964.687664657684,
    11978.634553274653,
    11992.585502712702,
    12006.540510609168,
    12020.499574604828,
    12034.462692343877,
    12048.429861473938,
    12062.401079646032,
    12076.376344514589,
    12090.355653737433,
    12104.339004975769,
    12118.326395894188,
    12132.317824160644,
    12146.313287446457,
    12160.312783426305,
    12174.316309778205,
    12188.323864183525,
    12202.335444326955,
    12216.351047896511,
    12230.370672583531,
    12244.394316082657,
    12258.421976091831,
    12272.453650312296,
    12286.489336448574,
    12300.529032208471,
    12314.572735303058,
    12328.620443446678,
    12342.672154356922,
    12356.727865754638,
    12370.787575363909,
    12384.851280912055,
    12398.918980129623,
    12412.990670750381,
    12427.066350511306,
    12441.146017152583,
    12455.229668417589,
    12469.317302052901,
    12483.40891580827,
    12497.50450743663,
    12511.604074694078,
    12525.707615339878,
    12539.815127136444,
    12553.926607849342,
    12568.042055247275,
    12582.161467102082,
    12596.284841188726,
    12610.41217528529,
    12624.543467172971,
    12638.678714636069,
    12652.817915461985,
    12666.961067441209,
    12681.108168367316,
    12695.259216036962,
    12709.414208249869,
    12723.573142808827,
    12737.736017519681,
    12751.902830191326,
    12766.073578635704,
    12780.248260667788,
    12794.426874105588,
    12808.609416770132,
    12822.795886485468,
    12836.986281078653,
    12851.180598379744,
    12865.378836221802,
    12879.580992440871,
    12893.787064875984,
    12907.997051369144,
    12922.210949765335,
    12936.428757912496,
    12950.650473661524,
    12964.876094866273,
    12979.105619383534,
    12993.339045073039,
    13007.576369797454,
    13021.817591422368,
    13036.062707816285,
    13050.311716850629,
    13064.564616399723,
    13078.821404340792,
    13093.082078553954,
    13107.346636922217,
    13121.615077331464,
    13135.887397670458,
    13150.163595830827,
    13164.44366970706,
    13178.727617196502,
    13193.015436199352,
    13207.307124618648,
    13221.602680360265,
    13235.902101332911,
    13250.205385448118,
    13264.512530620239,
    13278.823534766434,
    13293.138395806676,
    13307.457111663734,
    13321.779680263176,
    13336.106099533356,
    13350.436367405409,
    13364.77048181325,
    13379.108440693562,
    13393.450241985796,
    13407.795883632158,
    13422.145363577607,
    13436.498679769853,
    13450.855830159346,
    13465.216812699266,
    13479.581625345529,
    13493.950266056772,
    13508.32273279435,
    13522.699023522329,
    13537.079136207483,
    13551.463068819286,
    13565.850819329906,
    13580.2423857142,
    13594.63776594971,
    13609.036958016657,
    13623.439959897927,
    13637.846769579081,
    13652.257385048335,
    13666.67180429656,
    13681.090025317284,
    13695.512046106669,
    13709.937864663521,
    13724.367478989278,
    13738.800887088004,
    13753.238086966385,
    13767.679076633727,
    13782.123854101939,
    13796.572417385545,
    13811.024764501659,
    13825.480893469998,
    13839.94080231286,
    13854.404489055134,
    13868.871951724283,
    13883.34318835034,
    13897.818196965914,
    13912.296975606168,
    13926.779522308825,
    13941.26583511416,
    13955.755912064991,
    13970.249751206682,
    13984.747350587126,
    13999.248708256751,
    14013.753822268511,
    14028.262690677873,
    14042.775311542828,
    14057.291682923867,
    14071.811802883994,
    14086.335669488704,
    14100.863280805994,
    14115.394634906341,
    14129.92972986271,
    14144.468563750548,
    14159.01113464777,
    14173.55744063476,
    14188.107479794369,
    14202.661250211901,
    14217.218749975118,
    14231.779977174227,
    14246.344929901879,
    14260.913606253163,
    14275.486004325601,
    14290.062122219146,
    14304.641958036171,
    14319.225509881464,
    14333.812775862236,
    14348.403754088098,
    14362.998442671067,
    14377.59683972556,
    14392.198943368388,
    14406.804751718748,
    14421.414262898223,
    14436.027475030774,
    14450.64438624274,
    14465.264994662828,
    14479.889298422106,
    14494.517295654005,
    14509.148984494313,
    14523.784363081166,
    14538.423429555049,
    14553.066182058781,
    14567.712618737527,
    14582.362737738777,
    14597.016537212348,
    14611.674015310382,
    14626.33517018734,
    14640.999999999993,
    14655.668502907418,
    14670.340677071003,
    14685.016520654426,
    14699.696031823671,
    14714.379208746999,
    14729.066049594967,
    14743.756552540408,
    14758.45071575843,
    14773.148537426418,
    14787.850015724018,
    14802.555148833142,
    14817.263934937961,
    14831.976372224897,
    14846.692458882624,
    14861.41219310206,
    14876.135573076363,
    14890.862597000923,
    14905.593263073371,
    14920.327569493558,
    14935.065514463557,
    14949.807096187662,
    14964.552312872382,
    14979.301162726431,
    14994.053643960735,
    15008.809754788414,
    15023.569493424788,
    15038.332858087369,
    15053.099846995858,
    15067.870458372134,
    15082.644690440264,
    15097.422541426484,
    15112.204009559202,
    15126.989093068994,
    15141.777790188597,
    15156.570099152905,
    15171.366018198967,
    15186.165545565986,
    15200.968679495301,
    15215.775418230402,
    15230.585760016909,
    15245.399703102579,
    15260.217245737298,
    15275.038386173073,
    15289.863122664035,
    15304.691453466432,
    15319.523376838621,
    15334.358891041069,
    15349.197994336346,
    15364.040684989128,
    15378.886961266177,
    15393.736821436356,
    15408.590263770609,
    15423.447286541972,
    15438.307888025554,
    15453.172066498542,
    15468.039820240196,
    15482.91114753184,
    15497.786046656869,
    15512.664515900733,
    15527.546553550939,
    15542.432157897045,
    15557.32132723066,
    15572.214059845435,
    15587.110354037064,
    15602.010208103273,
    15616.913620343823,
    15631.820589060506,
    15646.731112557136,
    15661.645189139546,
    15676.562817115593,
    15691.483994795139,
    15706.408720490062,
    15721.336992514242,
    15736.268809183561,
    15751.204168815901,
    15766.143069731135,
    15781.085510251132,
    15796.03148869974,
    15810.981003402798,
    15825.934052688119,
    15840.890634885489,
    15855.850748326673,
    15870.814391345401,
    15885.781562277361,
    15900.752259460214,
    15915.726481233565,
    15930.704225938984,
    15945.685491919978,
    15960.670277522009,
    15975.658581092481,
    15990.65040098073,
    16005.645735538035,
    16020.644583117599,
    16035.646942074556,
    16050.652810765967,
    16065.662187550806,
    16080.675070789974,
    16095.691458846273,
    16110.711350084424,
    16125.734742871053,
    16140.761635574685,
    16155.792026565747,
    16170.825914216561,
    16185.863296901338,
    16200.904172996183,
    16215.948540879079,
    16230.996398929899,
    16246.047745530386,
    16261.102579064163,
    16276.160897916721,
    16291.22270047542,
    16306.287985129484,
    16321.356750269995,
    16336.428994289896,
    16351.504715583982,
    16366.5839125489,
    16381.666583583141,
    16396.752727087041,
    16411.842341462776,
    16426.935425114363,
    16442.031976447644,
    16457.131993870298,
    16472.235475791829,
    16487.342420623561,
    16502.452826778641,
    16517.566692672033,
    16532.684016720516,
    16547.804797342676,
    16562.929032958902,
    16578.056721991394,
    16593.18786286415,
    16608.322454002962,
    16623.460493835417,
    16638.601980790896,
    16653.746913300558,
    16668.895289797354,
    16684.047108716015,
    16699.202368493046,
    16714.361067566726,
    16729.523204377107,
    16744.688777366009,
    16759.857784977012,
    16775.030225655464,
    16790.206097848466,
    16805.385400004874,
    16820.568130575302,
    16835.754288012104,
    16850.943870769381,
    16866.136877302983,
    16881.333306070494,
    16896.53315553123,
    16911.736424146249,
    16926.943110378332,
    16942.153212691992,
    16957.366729553454,
    16972.583659430682,
    16987.804000793338,
    17003.027752112816,
    17018.254911862205,
    17033.485478516312,
    17048.719450551645,
    17063.956826446421,
    17079.197604680547,
    17094.44178373563,
    17109.689362094967,
    17124.940338243552,
    17140.194710668064,
    17155.452477856852,
    17170.713638299967,
    17185.978190489128,
    17201.246132917724,
    17216.517464080825,
    17231.792182475165,
    17247.070286599141,
    17262.351774952826,
    17277.636646037936,
    17292.924898357855,
    17308.216530417623,
    17323.511540723921,
    17338.809927785089,
    17354.111690111105,
    17369.416826213594,
    17384.725334605821,
    17400.037213802683,
    17415.352462320716,
    17430.67107867809,
    17445.993061394587,
    17461.318408991636,
    17476.647119992274,
    17491.979192921168,
    17507.314626304586,
    17522.653418670423,
    17537.995568548187,
    17553.341074468986,
    17568.689934965536,
    17584.042148572156,
    17599.397713824768,
    17614.75662926089,
    17630.118893419625,
    17645.484504841683,
    17660.853462069354,
    17676.225763646511,
    17691.601408118619,
    17706.980394032718,
    17722.362719937424,
    17737.748384382936,
    17753.137385921014,
    17768.529723104999,
    17783.92539448979,
    17799.324398631856,
    17814.726734089225,
    17830.13239942148,
    17845.541393189767,
    17860.95371395678,
    17876.369360286772,
    17891.788330745527,
    17907.210623900395,
    17922.636238320254,
    17938.065172575527,
    17953.497425238176,
    17968.932994881692,
    17984.371880081104,
    17999.814079412972,
    18015.259591455371,
    18030.708414787914,
    18046.160547991731,
    18061.615989649465,
    18077.074738345284,
    18092.536792664861,
    18108.002151195393,
    18123.470812525571,
    18138.942775245599,
    18154.418037947191,
    18169.896599223546,
    18185.37845766938,
    18200.863611880886,
    18216.352060455767,
    18231.843801993204,
    18247.338835093873,
    18262.837158359936,
    18278.338770395032,
    18293.84366980429,
    18309.351855194309,
    18324.863325173166,
    18340.378078350412,
    18355.896113337069,
    18371.417428745623,
    18386.942023190033,
    18402.469895285718,
    18418.00104364955,
    18433.53546689987,
    18449.073163656474,
    18464.614132540602,
    18480.158372174956,
    18495.705881183676,
    18511.256658192357,
    18526.810701828035,
    18542.368010719183,
    18557.928583495715,
    18573.492418788985,
    18589.059515231773,
    18604.629871458303,
    18620.203486104212,
    18635.78035780658,
    18651.360485203899,
    18666.943866936086,
    18682.53050164448,
    18698.120387971841,
    18713.713524562332,
    18729.30991006154,
    18744.909543116457,
    18760.512422375479,
    18776.118546488418,
    18791.727914106479,
    18807.340523882274,
    18822.95637446981,
    18838.575464524489,
    18854.197792703111,
    18869.823357663863,
    18885.452158066328,
    18901.08419257147,
    18916.719459841639,
    18932.357958540564,
    18947.999687333362,
    18963.644644886521,
    18979.292829867907,
    18994.944240946759,
    19010.598876793687,
    19026.256736080668,
    19041.917817481048,
    19057.582119669532,
    19073.2496413222,
    19088.920381116473,
    19104.594337731145,
    19120.271509846356,
    19135.951896143604,
    19151.635495305738,
    19167.322306016948,
    19183.012326962784,
    19198.705556830122,
    19214.401994307198,
    19230.101638083579,
    19245.804486850167,
    19261.510539299208,
    19277.219794124274,
    19292.932250020265,
    19308.647905683421,
    19324.366759811302,
    19340.088811102793,
    19355.8140582581,
    19371.542499978754,
    19387.2741349676,
    19403.008961928797,
    19418.746979567823,
    19434.488186591469,
    19450.232581707827,
    19465.980163626304,
    19481.730931057613,
    19497.484882713761,
    19513.242017308068,
    19529.002333555141,
    19544.765830170898,
    19560.532505872539,
    19576.302359378566,
    19592.075389408761,
    19607.851594684209,
    19623.630973927269,
    19639.41352586159,
    19655.199249212103,
    19670.988142705017,
    19686.780205067826,
    19702.575435029288,
    19718.373831319448,
    19734.175392669615,
    19749.980117812371,
    19765.788005481569,
    19781.599054412323,
    19797.413263341008,
    19813.230631005274,
    19829.051156144014,
    19844.874837497395,
    19860.701673806827,
    19876.531663814985,
    19892.364806265789,
    19908.201099904403,
    19924.040543477258,
    19939.883135732012,
    19955.728875417579,
    19971.577761284105,
    19987.429792082985,
    20003.284966566847,
    20019.14328348956,
    20035.004741606219,
    20050.869339673161,
    20066.737076447946,
    20082.607950689362,
    20098.481961157428,
    20114.359106613385,
    20130.239385819699,
    20146.122797540058,
    20162.009340539353,
    20177.899013583716,
    20193.791815440476,
    20209.687744878182,
    20225.586800666591,
    20241.488981576669,
    20257.394286380597,
    20273.302713851754,
    20289.214262764715,
    20305.128931895277,
    20321.046720020415,
    20336.967625918318,
    20352.891648368361,
    20368.818786151114,
    20384.749038048347,
    20400.682402843009,
    20416.618879319249,
    20432.558466262391,
    20448.501162458953,
    20464.446966696629,
    20480.395877764302,
    20496.347894452025,
    20512.303015551031,
    20528.261239853735,
    20544.22256615372,
    20560.186993245738,
    20576.15451992572,
    20592.125144990758,
    20608.098867239107,
    20624.075685470198,
    20640.055598484618,
    20656.038605084115,
    20672.024704071595,
    20688.013894251126,
    20704.006174427926,
    20720.001543408373,
    20735.999999999989,
    20752.001543011454,
    20768.006171252597,
    20784.013883534382,
    20800.024678668931,
    20816.038555469506,
    20832.055512750507,
    20848.075549327474,
    20864.098664017085,
    20880.124855637161,
    20896.154123006647,
    20912.186464945626,
    20928.221880275312,
    20944.260367818049,
    20960.301926397311,
    20976.346554837684,
    20992.394251964895,
    21008.445016605787,
    21024.498847588318,
    21040.555743741574,
    21056.615703895754,
    21072.678726882168,
    21088.744811533252,
    21104.813956682538,
    21120.886161164683,
    21136.961423815443,
    21153.039743471683,
    21169.121118971379,
    21185.205549153605,
    21201.293032858535,
    21217.383568927453,
    21233.477156202731,
    21249.573793527841,
    21265.673479747358,
    21281.776213706937,
    21297.881994253334,
    21313.990820234398,
    21330.102690499054,
    21346.21760389733,
    21362.335559280327,
    21378.456555500241,
    21394.580591410333,
    21410.707665864964,
    21426.83777771956,
    21442.970925830628,
    21459.107109055756,
    21475.246326253604,
    21491.388576283895,
    21507.533858007431,
    21523.682170286087,
    21539.833511982797,
    21555.987881961566,
    21572.145279087465,
    21588.305702226615,
    21604.469150246216,
    21620.635622014521,
    21636.805116400832,
    21652.977632275521,
    21669.153168510009,
    21685.331723976764,
    21701.513297549318,
    21717.697888102244,
    21733.885494511167,
    21750.076115652759,
    21766.269750404736,
    21782.466397645861,
    21798.666056255934,
    21814.868725115801,
    21831.074403107345,
    21847.283089113484,
    21863.494782018177,
    21879.709480706417,
    21895.927184064229,
    21912.147890978667,
    21928.371600337818,
    21944.598311030797,
    21960.828021947746,
    21977.060731979829,
    21993.296440019243,
    22009.535144959198,
    22025.77684569393,
    22042.021541118691,
    22058.269230129757,
    22074.519911624411,
    22090.773584500959,
    22107.030247658717,
    22123.289899998013,
    22139.552540420187,
    22155.818167827587,
    22172.086781123569,
    22188.358379212495,
    22204.632960999726,
    22220.910525391639,
    22237.191071295601,
    22253.474597619981,
    22269.761103274148,
    22286.050587168469,
    22302.343048214312,
    22318.638485324027,
    22334.936897410968,
    22351.23828338947,
    22367.542642174871,
    22383.849972683485,
    22400.160273832618,
    22416.473544540564,
    22432.789783726603,
    22449.108990310986,
    22465.431163214958,
    22481.75630136074,
    22498.084403671528,
    22514.415469071497,
    22530.749496485802,
    22547.086484840562,
    22563.426433062879,
    22579.769340080824,
    22596.115204823436,
    22612.464026220721,
    22628.815803203655,
    22645.170534704179,
    22661.5282196552,
    22677.888856990587,
    22694.252445645168,
    22710.618984554734,
    22726.988472656034,
    22743.360908886778,
    22759.736292185622,
    22776.114621492186,
    22792.495895747044,
    22808.880113891719,
    22825.267274868678,
    22841.657377621348,
    22858.050421094096,
    22874.446404232243,
    22890.845325982053,
    22907.247185290722,
    22923.651981106406,
    22940.059712378195,
    22956.470378056114,
    22972.883977091129,
    22989.300508435153,
    23005.719971041017,
    23022.142363862498,
    23038.567685854305,
    23054.995935972078,
    23071.427113172387,
    23087.86121641273,
    23104.298244651531,
    23120.738196848146,
    23137.181071962848,
    23153.626868956846,
    23170.075586792263,
    23186.527224432142,
    23202.981780840448,
    23219.439254982066,
    23235.899645822796,
    23252.362952329357,
    23268.829173469378,
    23285.298308211408,
    23301.770355524899,
    23318.245314380223,
    23334.723183748658,
    23351.203962602387,
    23367.687649914504,
    23384.174244659007,
    23400.663745810798,
    23417.15615234568,
    23433.651463240367,
    23450.149677472462,
    23466.650794020472,
    23483.154811863806,
    23499.661729982763,
    23516.171547358543,
    23532.684262973235,
    23549.199875809823,
    23565.718384852185,
    23582.239789085092,
    23598.764087494197,
    23615.291279066041,
    23631.821362788058,
    23648.354337648565,
    23664.890202636761,
    23681.428956742733,
    23697.970598957443,
    23714.515128272738,
    23731.062543681343,
    23747.612844176863,
    23764.166028753778,
    23780.72209640744,
    23797.281046134085,
    23813.842876930816,
    23830.407587795606,
    23846.975177727301,
    23863.545645725622,
    23880.11899079115,
    23896.695211925336,
    23913.274308130498,
    23929.856278409821,
    23946.441121767348,
    23963.028837207989,
    23979.619423737513,
    23996.212880362549,
    24012.809206090584,
    24029.408399929966,
    24046.010460889898,
    24062.615387980433,
    24079.223180212492,
    24095.833836597827,
    24112.447356149063,
    24129.063737879667,
    24145.682980803951,
    24162.305083937081,
    24178.930046295067,
    24195.557866894767,
    24212.188544753884,
    24228.822078890964,
    24245.458468325389,
    24262.097712077397,
    24278.739809168052,
    24295.384758619261,
    24312.032559453768,
    24328.683210695162,
    24345.336711367858,
    24361.993060497109,
    24378.652257108995,
    24395.314300230442,
    24411.979188889192,
    24428.646922113825,
    24445.317498933746,
    24461.990918379193,
    24478.667179481225,
    24495.346281271726,
    24512.028222783407,
    24528.713003049801,
    24545.400621105266,
    24562.091075984976,
    24578.784366724925,
    24595.480492361927,
    24612.179451933614,
    24628.881244478438,
    24645.585869035654,
    24662.293324645343,
    24679.003610348394,
    24695.716725186514,
    24712.432668202211,
    24729.151438438807,
    24745.873034940436,
    24762.597456752032,
    24779.324702919344,
    24796.054772488926,
    24812.787664508123,
    24829.5233780251,
    24846.261912088819,
    24863.003265749034,
    24879.747438056307,
    24896.494428062004,
    24913.244234818278,
    24929.996857378079,
    24946.752294795166,
    24963.510546124078,
    24980.271610420157,
    24997.035486739525,
    25013.802174139113,
    25030.571671676629,
    25047.343978410572,
    25064.119093400237,
    25080.897015705697,
    25097.677744387816,
    25114.461278508239,
    25131.2476171294,
    25148.036759314517,
    25164.828704127583,
    25181.623450633375,
    25198.42099789745,
    25215.221344986145,
    25232.024490966574,
    25248.830434906627,
    25265.639175874974,
    25282.450712941049,
    25299.265045175071,
    25316.082171648024,
    25332.902091431668,
    25349.724803598532,
    25366.550307221914,
    25383.378601375884,
    25400.209685135269,
    25417.043557575678,
    25433.880217773472,
    25450.719664805783,
    25467.561897750507,
    25484.406915686297,
    25501.254717692573,
    25518.105302849512,
    25534.958670238051,
    25551.814818939893,
    25568.67374803748,
    25585.535456614027,
    25602.399943753502,
    25619.267208540619,
    25636.137250060852,
    25653.010067400432,
    25669.885659646327,
    25686.76402588627,
    25703.645165208734,
    25720.529076702944,
    25737.415759458876,
    25754.305212567244,
    25771.197435119517,
    25788.092426207899,
    25804.990184925344,
    25821.890710365547,
    25838.794001622944,
    25855.700057792714,
    25872.608877970775,
    25889.520461253778,
    25906.434806739118,
    25923.351913524923,
    25940.271780710063,
    25957.194407394138,
    25974.11979267748,
    25991.047935661154,
    26007.978835446964,
    26024.912491137442,
    26041.848901835841,
    26058.788066646157,
    26075.729984673108,
    26092.674655022136,
    26109.622076799409,
    26126.572249111829,
    26143.525171067016,
    26160.480841773315,
    26177.43926033979,
    26194.400425876229,
    26211.364337493149,
    26228.330994301767,
    26245.30039541404,
    26262.272539942627,
    26279.247427000919,
    26296.225055703002,
    26313.205425163702,
    26330.188534498539,
    26347.174382823756,
    26364.162969256304,
    26381.154292913852,
    26398.148352914774,
    26415.145148378149,
    26432.144678423778,
    26449.146942172156,
    26466.151938744493,
    26483.159667262702,
    26500.170126849403,
    26517.183316627921,
    26534.199235722277,
    26551.217883257199,
    26568.239258358124,
    26585.263360151173,
    26602.290187763181,
    26619.319740321676,
    26636.352016954883,
    26653.387016791727,
    26670.424738961825,
    26687.465182595493,
    26704.508346823739,
    26721.554230778267,
    26738.602833591467,
    26755.65415439643,
    26772.708192326929,
    26789.764946517433,
    26806.824416103096,
    26823.886600219761,
    26840.95149800396,
    26858.019108592915,
    26875.089431124517,
    26892.162464737365,
    26909.238208570721,
    26926.316661764544,
    26943.397823459472,
    26960.481692796813,
    26977.568268918571,
    26994.657550967422,
    27011.749538086722,
    27028.844229420498,
    27045.941624113464,
    27063.041721311005,
    27080.144520159181,
    27097.250019804727,
    27114.35821939505,
    27131.469118078236,
    27148.582715003027,
    27165.699009318858,
    27182.818000175819,
    27199.939686724665,
    27217.064068116837,
    27234.191143504428,
    27251.320912040203,
    27268.453372877593,
    27285.588525170693,
    27302.726368074269,
    27319.866900743735,
    27337.010122335181,
    27354.156032005358,
    27371.304628911668,
    27388.455912212183,
    27405.609881065626,
    27422.766534631384,
    27439.925872069507,
    27457.087892540683,
    27474.252595206275,
    27491.419979228293,
    27508.5900437694,
    27525.762787992917,
    27542.93821106281,
    27560.116312143706,
    27577.297090400876,
    27594.480545000242,
    27611.666675108383,
    27628.855479892518,
    27646.046958520514,
    27663.241110160889,
    27680.437933982801,
    27697.637429156068,
    27714.839594851132,
    27732.04443023909,
    27749.251934491687,
    27766.462106781299,
    27783.674946280949,
    27800.890452164302,
    27818.108623605654,
    27835.329459779954,
    27852.55295986278,
    27869.779123030345,
    27887.007948459504,
    27904.239435327745,
    27921.473582813196,
    27938.710390094613,
    27955.949856351392,
    27973.19198076355,
    27990.436762511745,
    28007.684200777272,
    28024.934294742041,
    28042.187043588601,
    28059.442446500128,
    28076.700502660427,
    28093.961211253929,
    28111.224571465693,
    28128.490582481401,
    28145.759243487362,
    28163.030553670509,
    28180.304512218394,
    28197.581118319198,
    28214.860371161725,
    28232.14226993539,
    28249.42681383024,
    28266.71400203693,
    28284.003833746745,
    28301.296308151585,
    28318.591424443959,
    28335.889181817001,
    28353.189579464462,
    28370.492616580705,
    28387.798292360701,
    28405.106606000048,
    28422.417556694945,
    28439.731143642206,
    28457.047366039264,
    28474.366223084147,
    28491.687713975512,
    28509.011837912611,
    28526.338594095305,
    28543.667981724069,
    28560.999999999982,
    28578.334648124732,
    28595.671925300605,
    28613.011830730498,
    28630.354363617909,
    28647.699523166943,
    28665.0473085823,
    28682.397719069289,
    28699.750753833818,
    28717.10641208239,
    28734.464693022121,
    28751.825595860708,
    28769.189119806462,
    28786.55526406828,
    28803.924027855664,
    28821.295410378701,
    28838.669410848088,
    28856.046028475103,
    28873.425262471628,
    28890.80711205013,
    28908.191576423673,
    28925.578654805915,
    28942.968346411097,
    28960.360650454055,
    28977.755566150216,
    28995.153092715591,
    29012.553229366786,
    29029.955975320987,
    29047.361329795975,
    29064.769292010107,
    29082.179861182336,
    29099.593036532187,
    29117.00881727978,
    29134.427202645813,
    29151.848191851568,
    29169.271784118911,
    29186.697978670283,
    29204.126774728706,
    29221.55817151779,
    29238.992168261717,
    29256.42876418525,
    29273.867958513725,
    29291.309750473058,
    29308.754139289747,
    29326.201124190855,
    29343.65070440403,
    29361.102879157483,
    29378.557647680012,
    29396.015009200975,
    29413.474962950309,
    29430.937508158524,
    29448.402644056692,
    29465.870369876469,
    29483.340684850071,
    29500.81358821028,
    29518.289079190454,
    29535.767157024511,
    29553.247820946945,
    29570.731070192807,
    29588.216903997723,
    29605.70532159787,
    29623.19632223,
    29640.689905131429,
    29658.186069540028,
    29675.684814694236,
    29693.186139833047,
    29710.690044196028,
    29728.196527023298,
    29745.705587555527,
    29763.217225033964,
    29780.731438700397,
    29798.248227797183,
    29815.76759156723,
    29833.289529254005,
    29850.81404010153,
    29868.341123354381,
    29885.870778257693,
    29903.403004057145,
    29920.937799998974,
    29938.475165329975,
    29956.015099297485,
    29973.557601149394,
    29991.102670134147,
    30008.650305500738,
    30026.200506498706,
    30043.753272378144,
    30061.308602389683,
    30078.866495784507,
    30096.426951814352,
    30113.989969731494,
    30131.55554878875,
    30149.123688239491,
    30166.694387337629,
    30184.267645337608,
    30201.843461494434,
    30219.42183506364,
    30237.002765301309,
    30254.586251464058,
    30272.172292809046,
    30289.760888593977,
    30307.35203807709,
    30324.94574051716,
    30342.541995173502,
    30360.140801305966,
    30377.742158174944,
    30395.346065041358,
    30412.952521166666,
    30430.561525812864,
    30448.173078242475,
    30465.787177718561,
    30483.403823504719,
    30501.02301486507,
    30518.644751064272,
    30536.269031367516,
    30553.895855040515,
    30571.525221349519,
    30589.157129561307,
    30606.791578943175,
    30624.428568762964,
    30642.06809828903,
    30659.710166790261,
    30677.35477353607,
    30695.001917796391,
    30712.651598841687,
    30730.303815942945,
    30747.958568371676,
    30765.615855399912,
    30783.275676300211,
    30800.938030345646,
    30818.602916809814,
    30836.270334966837,
    30853.940284091354,
    30871.612763458521,
    30889.287772344011,
    30906.965310024025,
    30924.645375775272,
    30942.327968874983,
    30960.013088600903,
    30977.700734231294,
    30995.390905044929,
    31013.083600321101,
    31030.778819339619,
    31048.476561380798,
    31066.17682572547,
    31083.879611654978,
    31101.584918451179,
    31119.29274539644,
    31137.003091773637,
    31154.715956866155,
    31172.431339957893,
    31190.14924033326,
    31207.869657277162,
    31225.592590075023,
    31243.318038012771,
    31261.046000376838,
    31278.776476454172,
    31296.50946553221,
    31314.24496689891,
    31331.98297984272,
    31349.7235036526,
    31367.466537618013,
    31385.212081028923,
    31402.960133175795,
    31420.710693349596,
    31438.463760841791,
    31456.219334944351,
    31473.977414949743,
    31491.738000150934,
    31509.501089841389,
    31527.266683315069,
    31545.034779866437,
    31562.80537879045,
    31580.578479382562,
    31598.35408093872,
    31616.132182755369,
    31633.91278412945,
    31651.695884358396,
    31669.481482740131,
    31687.269578573076,
    31705.060171156143,
    31722.853259788735,
    31740.648843770748,
    31758.446922402567,
    31776.247494985066,
    31794.050560819614,
    31811.85611920806,
    31829.664169452753,
    31847.474710856521,
    31865.287742722685,
    31883.103264355046,
    31900.921275057899,
    31918.741774136019,
    31936.564760894671,
    31954.390234639599,
    31972.21819467704,
    31990.048640313704,
    32007.881570856793,
    32025.716985613984,
    32043.554883893445,
    32061.395265003815,
    32079.238128254223,
    32097.083472954269,
    32114.931298414049,
    32132.781603944117,
    32150.634388855524,
    32168.48965245979,
    32186.347394068915,
    32204.207612995371,
    32222.07030855212,
    32239.935480052583,
    32257.803126810672,
    32275.673248140767,
    32293.545843357719,
    32311.420911776862,
    32329.298452713996,
    32347.178465485395,
    32365.060949407813,
    32382.945903798463,
    32400.83332797504,
    32418.723221255706,
    32436.615582959093,
    32454.510412404306,
    32472.407708910916,
    32490.307471798966,
    32508.209700388961,
    32526.114394001877,
    32544.021551959166,
    32561.931173582732,
    32579.843258194956,
    32597.757805118679,
    32615.674813677211,
    32633.594283194328,
    32651.516212994258,
    32669.440602401712,
    32687.367450741847,
    32705.296757340297,
    32723.228521523146,
    32741.162742616943,
    32759.099419948703,
    32777.038552845901,
    32794.980140636464,
    32812.924182648792,
    32830.87067821173,
    32848.819626654593,
    32866.77102730715,
    32884.724879499619,
    32902.681182562686,
    32920.639935827494,
    32938.601138625643,
    32956.56479028918,
    32974.530890150607,
    32992.499437542894,
    33010.470431799447,
    33028.443872254145,
    33046.419758241311,
    33064.39808909571,
    33082.378864152583,
    33100.36208274759,
    33118.347744216881,
    33136.335847897026,
    33154.326393125062,
    33172.31937923847,
    33190.314805575174,
    33208.312671473555,
    33226.312976272442,
    33244.315719311111,
    33262.320899929284,
    33280.328517467125,
    33298.33857126526,
    33316.351060664747,
    33334.365985007091,
    33352.383343634239,
    33370.403135888591,
    33388.42536111299,
    33406.450018650721,
    33424.477107845501,
    33442.506628041512,
    33460.53857858335,
    33478.572958816083,
    33496.609768085189,
    33514.649005736617,
    33532.690671116739,
    33550.734763572356,
    33568.781282450735,
    33586.830227099563,
    33604.881596866973,
    33622.935391101528,
    33640.991609152239,
    33659.050250368542,
    33677.111314100322,
    33695.174799697881,
    33713.240706511984,
    33731.309033893805,
    33749.37978119497,
    33767.452947767531,
    33785.528532963974,
    33803.606536137209,
    33821.686956640602,
    33839.769793827938,
    33857.855047053425,
    33875.942715671707,
    33894.032799037872,
    33912.125296507431,
    33930.220207436316,
    33948.317531180888,
    33966.417267097961,
    33984.519414544746,
    34002.623972878901,
    34020.730941458511,
    34038.840319642077,
    34056.952106788536,
    34075.066302257255,
    34093.182905408015,
    34111.301915601027,
    34129.42333219693,
    34147.547154556785,
    34165.673382042078,
    34183.80201401472,
    34201.933049837033,
    34220.06648887178,
    34238.202330482141,
    34256.340574031703,
    34274.481218884495,
    34292.624264404949,
    34310.769709957938,
    34328.91755490873,
    34347.067798623029,
    34365.220440466954,
    34383.375479807051,
    34401.532916010263,
    34419.692748443973,
    34437.854976475966,
    34456.01959947445,
    34474.18661680806,
    34492.356027845817,
    34510.527831957188,
    34528.702028512052,
    34546.878616880676,
    34565.05759643377,
    34583.238966542449,
    34601.422726578232,
    34619.608875913065,
    34637.797413919296,
    34655.988339969692,
    34674.181653437423,
    34692.37735369608,
    34710.575440119668,
    34728.775912082579,
    34746.978768959649,
    34765.184010126082,
    34783.391634957537,
    34801.60164283005,
    34819.814033120063,
    34838.028805204456,
    34856.24595846048,
    34874.465492265823,
    34892.687405998557,
    34910.911699037177,
    34929.138370760564,
    34947.367420548027,
    34965.598847779271,
    34983.832651834389,
    35002.068832093908,
    35020.307387938738,
    35038.548318750189,
    35056.79162390998,
    35075.03730280025,
    35093.285354803513,
    35111.535779302685,
    35129.788575681116,
    35148.043743322516,
    35166.301281611013,
    35184.561189931141,
    35202.823467667826,
    35221.088114206388,
    35239.355128932555,
    35257.624511232447,
    35275.896260492584,
    35294.170376099886,
    35312.446857441668,
    35330.725703905628,
    35349.006914879887,
    35367.290489752944,
    35385.576427913686,
    35403.864728751418,
    35422.155391655811,
    35440.448416016967,
    35458.743801225341,
    35477.041546671804,
    35495.341651747622,
    35513.644115844436,
    35531.948938354304,
    35550.256118669655,
    35568.565656183309,
    35586.877550288496,
    35605.191800378816,
    35623.508405848268,
    35641.827366091238,
    35660.148680502505,
    35678.472348477233,
    35696.798369410979,
    35715.126742699678,
    35733.457467739659,
    35751.790543927644,
    35770.125970660738,
    35788.46374733642,
    35806.803873352568,
    35825.146348107453,
    35843.49117099971,
    35861.838341428367,
    35880.187858792851,
    35898.539722492955,
    35916.893931928862,
    35935.250486501129,
    35953.609385610718,
    35971.970628658957,
    35990.334215047558,
    36008.700144178612,
    36027.068415454596,
    36045.439028278372,
    36063.811982053165,
    36082.187276182609,
    36100.564910070694,
    36118.944883121789,
    36137.327194740654,
    36155.711844332429,
    36174.098831302617,
    36192.488155057115,
    36210.87981500219,
    36229.273810544473,
    36247.670141091003,
    36266.068806049167,
    36284.469804826738,
    36302.873136831862,
    36321.278801473069,
    36339.686798159251,
    36358.097126299683,
    36376.509785304013,
    36394.924774582258,
    36413.342093544816,
    36431.761741602444,
    36450.183718166292,
    36468.608022647859,
    36487.034654459028,
    36505.463613012063,
    36523.894897719583,
    36542.328507994578,
    36560.764443250409,
    36579.202702900831,
    36597.643286359926,
    36616.086193042182,
    36634.531422362437,
    36652.978973735895,
    36671.428846578143,
    36689.881040305125,
    36708.335554333149,
    36726.792388078902,
    36745.251540959427,
    36763.713012392138,
    36782.176801794812,
    36800.642908585593,
    36819.111332182983,
    36837.582072005869,
    36856.055127473483,
    36874.530498005421,
    36893.008183021651,
    36911.488181942506,
    36929.970494188674,
    36948.455119181206,
    36966.942056341519,
    36985.431305091392,
    37003.922864852961,
    37022.416735048733,
    37040.912915101559,
    37059.411404434657,
    37077.91220247162,
    37096.415308636388,
    37114.920722353243,
    37133.428443046862,
    37151.938470142253,
    37170.450803064785,
    37188.965441240209,
    37207.482384094597,
    37226.001631054402,
    37244.523181546429,
    37263.047034997842,
    37281.573190836149,
    37300.101648489224,
    37318.632407385296,
    37337.165466952945,
    37355.700826621112,
    37374.238485819085,
    37392.778443976509,
    37411.320700523385,
    37429.865254890057,
    37448.412106507232,
    37466.961254805974,
    37485.512699217681,
    37504.066439174116,
    37522.622474107404,
    37541.180803449992,
    37559.741426634704,
    37578.304343094693,
    37596.869552263488,
    37615.43705357494,
    37634.006846463279,
    37652.578930363044,
    37671.153304709165,
    37689.729968936896,
    37708.308922481847,
    37726.890164779965,
    37745.473695267559,
    37764.059513381275,
    37782.647618558112,
    37801.238010235415,
    37819.830687850859,
    37838.425650842495,
    37857.022898648691,
    37875.622430708172,
    37894.224246460013,
    37912.828345343616,
    37931.434726798747,
    37950.043390265506,
    37968.654335184328,
    37987.267560995999,
    38005.883067141665,
    38024.500853062775,
    38043.120918201159,
    38061.743261998963,
    38080.367883898682,
    38098.994783343158,
    38117.623959775563,
    38136.255412639417,
    38154.889141378575,
    38173.525145437234,
    38192.163424259939,
    38210.803977291551,
    38229.446803977284,
    38248.091903762703,
    38266.739276093685,
    38285.388920416466,
    38304.040836177606,
    38322.695022824002,
    38341.351479802899,
    38360.010206561863,
    38378.671202548816,
    38397.334467211993,
    38415.999999999978,
    38434.667800361683,
    38453.33786774637,
    38472.010201603611,
    38490.684801383337,
    38509.361666535784,
    38528.040796511552,
    38546.722190761553,
    38565.405848737035,
    38584.091769889594,
    38602.779953671132,
    38621.470399533908,
    38640.163106930493,
    38658.858075313794,
    38677.555304137059,
    38696.254792853862,
    38714.956540918094,
    38733.660547783991,
    38752.366812906112,
    38771.075335739348,
    38789.78611573892,
    38808.499152360368,
    38827.214445059573,
    38845.931993292739,
    38864.651796516388,
    38883.373854187383,
    38902.098165762916,
    38920.824730700486,
    38939.553548457938,
    38958.284618493431,
    38977.017940265461,
    38995.753513232834,
    39014.491336854699,
    39033.231410590517,
    39051.973733900079,
    39070.718306243485,
    39089.465127081188,
    39108.214195873945,
    39126.965512082832,
    39145.719075169261,
    39164.474884594965,
    39183.232939821988,
    39201.99324031271,
    39220.755785529815,
    39239.52057493633,
    39258.287607995589,
    39277.056884171245,
    39295.828402927284,
    39314.602163728006,
    39333.378166038019,
    39352.15640932227,
    39370.936893046004,
    39389.719616674811,
    39408.504579674584,
    39427.291781511522,
    39446.081221652174,
    39464.872899563372,
    39483.666814712291,
    39502.462966566411,
    39521.261354593538,
    39540.06197826178,
    39558.864837039568,
    39577.669930395656,
    39596.47725779911,
    39615.286818719302,
    39634.098612625923,
    39652.912638988993,
    39671.728897278823,
    39690.547386966064,
    39709.368107521652,
    39728.191058416858,
    39747.016239123259,
    39765.84364911275,
    39784.673287857528,
    39803.505154830105,
    39822.339249503319,
    39841.175571350293,
    39860.014119844491,
    39878.854894459677,
    39897.697894669909,
    39916.54311994958,
    39935.390569773372,
    39954.240243616303,
    39973.092140953675,
    39991.946261261117,
    40010.802604014549,
    40029.661168690225,
    40048.521954764678,
    40067.384961714779,
    40086.250189017679,
    40105.117636150855,
    40123.98730259209,
    40142.859187819471,
    40161.733291311379,
    40180.609612546526,
    40199.488151003912,
    40218.368906162854,
    40237.25187750296,
    40256.137064504153,
    40275.024466646668,
    40293.914083411029,
    40312.805914278084,
    40331.699958728961,
    40350.596216245103,
    40369.494686308273,
    40388.39536840051,
    40407.298262004173,
    40426.20336660192,
    40445.110681676706,
    40464.020206711793,
    40482.931941190756,
    40501.845884597446,
    40520.762036416032,
    40539.680396130985,
    40558.600963227072,
    40577.523737189367,
    40596.448717503234,
    40615.375903654342,
    40634.305295128659,
    40653.236891412453,
    40672.170691992294,
    40691.106696355047,
    40710.044903987873,
    40728.985314378238,
    40747.927927013901,
    40766.872741382918,
    40785.819756973651,
    40804.768973274746,
    40823.720389775161,
    40842.674005964131,
    40861.629821331211,
    40880.587835366234,
    40899.548047559321,
    40918.510457400931,
    40937.475064381761,
    40956.441867992849,
    40975.410867725499,
    40994.382063071331,
    41013.355453522236,
    41032.331038570417,
    41051.308817708363,
    41070.288790428858,
    41089.270956224987,
    41108.255314590111,
    41127.241865017888,
    41146.23060700229,
    41165.221540037543,
    41184.214663618193,
    41203.209977239079,
    41222.207480395307,
    41241.207172582297,
    41260.209053295752,
    41279.213122031659,
    41298.219378286303,
    41317.227821556255,
    41336.23845133838,
    41355.251267129832,
    41374.266268428037,
    41393.283454730743,
    41412.302825535953,
    41431.324380341983,
    41450.348118647416,
    41469.374039951144,
    41488.402143752326,
    41507.432429550427,
    41526.464896845187,
    41545.499545136627,
    41564.536373925075,
    41583.575382711126,
    41602.616570995662,
    41621.659938279874,
    41640.705484065205,
    41659.753207853406,
    41678.803109146495,
    41697.855187446803,
    41716.909442256911,
    41735.965873079709,
    41755.02447941836,
    41774.085260776315,
    41793.148216657297,
    41812.213346565331,
    41831.280650004708,
    41850.350126480014,
    41869.421775496106,
    41888.495596558132,
    41907.571589171515,
    41926.649752841957,
    41945.730087075463,
    41964.812591378286,
    41983.897265256979,
    42002.984108218378,
    42022.073119769593,
    42041.164299418015,
    42060.257646671307,
    42079.353161037419,
    42098.450842024591,
    42117.550689141324,
    42136.652701896404,
    42155.756879798893,
    42174.863222358137,
    42193.971729083758,
    42213.082399485655,
    42232.195233074002,
    42251.310229359246,
    42270.427387852127,
    42289.546708063644,
    42308.668189505079,
    42327.791831687995,
    42346.917634124227,
    42366.045596325886,
    42385.175717805352,
    42404.307998075295,
    42423.442436648642,
    42442.579033038608,
    42461.717786758672,
    42480.858697322597,
    42500.001764244422,
    42519.146987038446,
    42538.294365219248,
    42557.443898301688,
    42576.595585800882,
    42595.749427232236,
    42614.90542211142,
    42634.063569954378,
    42653.223870277317,
    42672.386322596729,
    42691.55092642938,
    42710.717681292292,
    42729.886586702756,
    42749.057642178363,
    42768.23084723694,
    42787.406201396603,
    42806.58370417574,
    42825.76335509299,
    42844.945153667286,
    42864.129099417805,
    42883.315191864014,
    42902.503430525649,
    42921.693814922692,
    42940.88634457541,
    42960.081019004348,
    42979.277837730297,
    42998.476800274322,
    43017.677906157769,
    43036.881154902228,
    43056.086546029583,
    43075.294079061961,
    43094.503753521763,
    43113.715568931671,
    43132.929524814601,
    43152.145620693766,
    43171.363856092619,
    43190.584230534907,
    43209.806743544621,
    43229.031394646016,
    43248.258183363621,
    43267.487109222224,
    43286.718171746885,
    43305.951370462906,
    43325.186704895881,
    43344.42417457165,
    43363.663779016322,
    43382.905517756262,
    43402.149390318104,
    43421.395396228749,
    43440.643535015348,
    43459.89380620532,
    43479.146209326354,
    43498.400743906379,
    43517.657409473606,
    43536.916205556496,
    43556.177131683784,
    43575.44018738444,
    43594.705372187724,
    43613.972685623135,
    43633.242127220445,
    43652.513696509668,
    43671.787393021099,
    43691.063216285271,
    43710.341165833001,
    43729.621241195346,
    43748.903441903625,
    43768.187767489413,
    43787.474217484552,
    43806.762791421126,
    43826.053488831501,
    43845.346309248278,
    43864.641252204325,
    43883.938317232765,
    43903.237503866971,
    43922.538811640596,
    43941.842240087513,
    43961.147788741881,
    43980.455457138101,
    43999.765244810835,
    44019.077151295001,
    44038.391176125755,
    44057.70731883854,
    44077.02557896902,
    44096.345956053141,
    44115.668449627083,
    44134.993059227287,
    44154.319784390456,
    44173.648624653535,
    44192.979579553728,
    44212.312648628489,
    44231.647831415532,
    44250.985127452805,
    44270.324536278538,
    44289.666057431183,
    44309.009690449464,
    44328.355434872348,
    44347.703290239064,
    44367.053256089079,
    44386.405331962109,
    44405.759517398139,
    44425.115811937387,
    44444.474215120332,
    44463.834726487694,
    44483.197345580462,
    44502.562071939843,
    44521.928905107328,
    44541.297844624634,
    44560.668890033732,
    44580.042040876848,
    44599.417296696454,
    44618.794657035272,
    44638.174121436256,
    44657.555689442641,
    44676.939360597877,
    44696.325134445673,
    44715.713010530002,
    44735.102988395054,
    44754.495067585296,
    44773.88924764542,
    44793.285528120374,
    44812.683908555344,
    44832.084388495779,
    44851.486967487363,
    44870.891645076015,
    44890.298420807922,
    44909.707294229491,
    44929.118264887409,
    44948.531332328566,
    44967.946496100136,
    44987.363755749502,
    45006.783110824319,
    45026.204560872473,
    45045.628105442098,
    45065.053744081561,
    45084.48147633949,
    45103.911301764747,
    45123.343219906426,
    45142.777230313885,
    45162.21333253671,
    45181.651526124733,
    45201.091810628037,
    45220.534185596924,
    45239.978650581965,
    45259.425205133957,
    45278.873848803938,
    45298.324581143192,
    45317.777401703235,
    45337.232310035848,
    45356.68930569302,
    45376.148388226997,
    45395.60955719027,
    45415.072812135557,
    45434.538152615823,
    45454.005578184282,
    45473.475088394356,
    45492.946682799746,
    45512.420360954362,
    45531.896122412363,
    45551.373966728155,
    45570.853893456362,
    45590.33590215187,
    45609.819992369776,
    45629.306163665438,
    45648.794415594442,
    45668.284747712612,
    45687.777159576006,
    45707.27165074092,
    45726.768220763894,
    45746.266869201696,
    45765.767595611323,
    45785.270399550034,
    45804.775280575297,
    45824.282238244828,
    45843.79127211657,
    45863.302381748719,
    45882.815566699683,
    45902.33082652813,
    45921.848160792935,
    45941.367569053225,
    45960.889050868354,
    45980.41260579793,
    45999.938233401757,
    46019.465933239902,
    46038.995704872657,
    46058.527547860547,
    46078.06146176433,
    46097.597446144995,
    46117.135500563774,
    46136.675624582109,
    46156.217817761702,
    46175.762079664462,
    46195.308409852543,
    46214.856807888333,
    46234.407273334444,
    46253.959805753715,
    46273.51440470924,
    46293.071069764315,
    46312.629800482478,
    46332.190596427499,
    46351.753457163381,
    46371.318382254351,
    46390.885371264863,
    46410.45442375962,
    46430.025539303526,
    46449.598717461733,
    46469.17395779962,
    46488.751259882782,
    46508.33062327707,
    46527.912047548532,
    46547.495532263471,
    46567.081076988397,
    46586.668681290059,
    46606.258344735434,
    46625.850066891719,
    46645.443847326351,
    46665.039685606986,
    46684.637581301497,
    46704.237533978005,
    46723.839543204842,
    46743.443608550573,
    46763.049729583989,
    46782.657905874104,
    46802.268136990162,
    46821.880422501628,
    46841.494761978196,
    46861.111154989776,
    46880.729601106526,
    46900.350099898795,
    46919.97265093719,
    46939.597253792526,
    46959.223908035841,
    46978.852613238392,
    46998.483368971691,
    47018.11617480743,
    47037.751030317551,
    47057.387935074221,
    47077.026888649809,
    47096.66789061694,
    47116.310940548428,
    47135.956038017328,
    47155.603182596918,
    47175.252373860698,
    47194.903611382375,
    47214.556894735892,
    47234.212223495422,
    47253.869597235338,
    47273.52901553025,
    47293.19047795498,
    47312.853984084577,
    47332.519533494306,
    47352.187125759658,
    47371.856760456343,
    47391.528437160297,
    47411.202155447652,
    47430.877914894787,
    47450.555715078299,
    47470.235555574982,
    47489.917435961863,
    47509.601355816201,
    47529.287314715453,
    47548.975312237308,
    47568.665347959672,
    47588.357421460656,
    47608.051532318605,
    47627.747680112072,
    47647.445864419846,
    47667.14608482091,
    47686.848340894474,
    47706.552632219973,
    47726.258958377046,
    47745.967318945557,
    47765.677713505589,
    47785.390141637428,
    47805.104602921601,
    47824.821096938824,
    47844.539623270044,
    47864.260181496429,
    47883.982771199349,
    47903.707391960394,
    47923.434043361369,
    47943.162724984308,
    47962.893436411439,
    47982.626177225218,
    48002.36094700831,
    48022.097745343599,
    48041.836571814172,
    48061.57742600335,
    48081.32030749465,
    48101.065215871815,
    48120.81215071879,
    48140.56111161974,
    48160.312098159047,
    48180.065109921306,
    48199.820146491307,
    48219.577207454073,
    48239.336292394844,
    48259.097400899045,
    48278.860532552339,
    48298.625686940592,
    48318.392863649875,
    48338.162062266485,
    48357.933282376915,
    48377.706523567889,
    48397.481785426316,
    48417.259067539344,
    48437.038369494308,
    48456.819690878765,
    48476.603031280487,
    48496.388390287451,
    48516.175767487839,
    48535.965162470042,
    48555.756574822684,
    48575.550004134566,
    48595.345449994718,
    48615.142911992378,
    48634.942389716991,
    48654.743882758201,
    48674.547390705877,
    48694.352913150084,
    48714.160449681112,
    48733.969999889443,
    48753.781563365759,
    48773.595139700978,
    48793.410728486211,
    48813.228329312769,
    48833.047941772187,
    48852.869565456189,
    48872.693199956717,
    48892.518844865925,
    48912.346499776155,
    48932.176164279976,
    48952.007837970152,
    48971.841520439666,
    48991.677211281676,
    49011.514910089587,
    49031.354616456978,
    49051.196329977654,
    49071.04005024561,
    49090.885776855059,
    49110.733509400408,
    49130.583247476279,
    49150.434990677488,
    49170.288738599062,
    49190.144490836232,
    49210.002246984441,
    49229.86200663932,
    49249.723769396718,
    49269.587534852675,
    49289.453302603448,
    49309.32107224549,
    49329.190843375451,
    49349.062615590192,
    49368.936388486785,
    49388.812161662492,
    49408.689934714785,
    49428.569707241324,
    49448.45147883999,
    49468.335249108866,
    49488.22101764621,
    49508.108784050521,
    49527.99854792047,
    49547.890308854934,
    49567.784066453009,
    49587.679820313977,
    49607.57757003732,
    49627.477315222721,
    49647.379055470075,
    49667.28279037946,
    49687.188519551179,
    49707.096242585707,
    49727.005959083741,
    49746.917668646165,
    49766.831370874068,
    49786.747065368734,
    49806.66475173166,
    49826.584429564515,
    49846.506098469203,
    49866.429758047794,
    49886.355407902578,
    49906.283047636032,
    49926.212676850846,
    49946.144295149883,
    49966.077902136225,
    49986.013497413151,
    50005.951080584135,
    50025.890651252834,
    50045.832209023123,
    50065.775753499074,
    50085.721284284933,
    50105.668800985164,
    50125.618303204428,
    50145.569790547575,
    50165.523262619652,
    50185.478719025901,
    50205.436159371769,
    50225.395583262893,
    50245.356990305103,
    50265.320380104429,
    50285.285752267104,
    50305.253106399534,
    50325.222442108337,
    50345.193759000336,
    50365.16705668252,
    50385.142334762102,
    50405.119592846473,
    50425.098830543218,
    50445.080047460127,
    50465.063243205179,
    50485.048417386541,
    50505.035569612577,
    50525.024699491856,
    50545.015806633128,
    50565.008890645338,
    50585.003951137631,
    50605.00098771933,
    50624.999999999971,
    50645.000987589265,
    50665.003950097132,
    50685.008887133677,
    50705.015798309192,
    50725.024683234165,
    50745.035541519283,
    50765.048372775411,
    50785.063176613621,
    50805.079952645159,
    50825.098700481489,
    50845.119419734241,
    50865.142110015244,
    50885.166770936521,
    50905.193402110279,
    50925.222003148934,
    50945.252573665071,
    50965.285113271471,
    50985.319621581119,
    51005.356098207172,
    51025.394542762981,
    51045.434954862096,
    51065.477334118244,
    51085.521680145357,
    51105.567992557546,
    51125.616270969113,
    51145.66651499454,
    51165.718724248516,
    51185.772898345916,
    51205.829036901778,
    51225.887139531362,
    51245.947205850105,
    51266.009235473619,
    51286.073228017718,
    51306.139183098399,
    51326.207100331856,
    51346.276979334456,
    51366.348819722756,
    51386.42262111351,
    51406.498383123653,
    51426.57610537031,
    51446.655787470787,
    51466.737429042587,
    51486.82102970338,
    51506.906589071048,
    51526.994106763632,
    51547.083582399391,
    51567.175015596738,
    51587.268405974297,
    51607.363753150858,
    51627.461056745415,
    51647.56031637713,
    51667.661531665362,
    51687.764702229651,
    51707.869827689727,
    51727.976907665499,
    51748.085941777055,
    51768.196929644677,
    51788.309870888836,
    51808.42476513017,
    51828.541611989524,
    51848.660411087905,
    51868.781162046515,
    51888.90386448674,
    51909.028518030143,
    51929.155122298485,
    51949.283676913685,
    51969.414181497872,
    51989.546635673345,
    52009.681039062583,
    52029.817391288263,
    52049.955691973213,
    52070.095940740481,
    52090.238137213273,
    52110.382281014987,
    52130.5283717692,
    52150.676409099666,
    52170.826392630333,
    52190.97832198532,
    52211.132196788931,
    52231.288016665654,
    52251.445781240145,
    52271.60549013727,
    52291.76714298204,
    52311.930739399664,
    52332.096279015546,
    52352.263761455244,
    52372.433186344519,
    52392.604553309284,
    52412.777861975665,
    52432.953111969946,
    52453.130302918595,
    52473.309434448267,
    52493.490506185793,
    52513.67351775818,
    52533.858468792605,
    52554.045358916446,
    52574.234187757254,
    52594.42495494274,
    52614.617660100812,
    52634.812302859558,
    52655.008882847229,
    52675.20739969227,
    52695.407853023295,
    52715.610242469098,
    52735.814567658657,
    52756.02082822111,
    52776.229023785803,
    52796.439153982225,
    52816.651218440056,
    52836.865216789171,
    52857.081148659599,
    52877.29901368155,
    52897.518811485425,
    52917.740541701773,
    52937.964203961354,
    52958.18979789508,
    52978.417323134046,
    52998.646779309529,
    53018.878166052978,
    53039.111482996006,
    53059.346729770419,
    53079.583906008193,
    53099.823011341483,
    53120.0640454026,
    53140.307007824063,
    53160.551898238533,
    53180.79871627887,
    53201.047461578091,
    53221.2981337694,
    53241.550732486176,
    53261.805257361964,
    53282.061708030487,
    53302.32008412564,
    53322.580385281493,
    53342.842611132299,
    53363.106761312469,
    53383.372835456597,
    53403.640833199453,
    53423.910754175973,
    53444.18259802126,
    53464.456364370613,
    53484.732052859479,
    53505.009663123499,
    53525.289194798468,
    53545.570647520362,
    53565.854020925333,
    53586.139314649699,
    53606.426528329954,
    53626.715661602764,
    53647.006714104959,
    53667.299685473547,
    53687.59457534572,
    53707.891383358816,
    53728.190109150361,
    53748.490752358055,
    53768.793312619753,
    53789.09778957349,
    53809.404182857485,
    53829.712492110106,
    53850.022716969899,
    53870.334857075584,
    53890.648912066055,
    53910.964881580367,
    53931.28276525774,
    53951.602562737586,
    53971.924273659461,
    53992.24789766311,
    54012.57343438844,
    54032.90088347553,
    54053.23024456462,
    54073.561517296133,
    54093.894701310644,
    54114.22979624891,
    54134.566801751855,
    54154.90571746057,
    54175.246543016314,
    54195.589278060506,
    54215.933922234755,
    54236.280475180814,
    54256.628936540626,
    54276.97930595628,
    54297.331583070045,
    54317.685767524359,
    54338.041858961828,
    54358.399857025215,
    54378.759761357462,
    54399.121571601667,
    54419.485287401105,
    54439.850908399218,
    54460.218434239614,
    54480.587864566056,
    54500.95919902248,
    54521.332437252997,
    54541.707578901878,
    54562.084623613555,
    54582.46357103264,
    54602.844420803893,
    54623.227172572246,
    54643.611825982807,
    54663.998380680838,
    54684.386836311773,
    54704.777192521207,
    54725.169448954897,
    54745.563605258772,
    54765.959661078923,
    54786.357616061614,
    54806.757469853255,
    54827.159222100439,
    54847.562872449904,
    54867.968420548583,
    54888.375866043534,
    54908.785208582012,
    54929.196447811417,
    54949.609583379322,
    54970.024614933463,
    54990.441542121727,
    55010.86036459219,
    55031.28108199306,
    55051.703693972733,
    55072.128200179759,
    55092.554600262847,
    55112.982893870874,
    55133.413080652877,
    55153.845160258061,
    55174.279132335789,
    55194.714996535586,
    55215.152752507143,
    55235.592399900306,
    55256.033938365079,
    55276.477367551655,
    55296.92268711036,
    55317.369896691685,
    55337.818995946305,
    55358.269984525024,
    55378.72286207883,
    55399.177628258869,
    55419.634282716441,
    55440.092825103013,
    55460.553255070205,
    55481.015572269804,
    55501.479776353764,
    55521.945866974187,
    55542.413843783339,
    55562.883706433655,
    55583.355454577715,
    55603.82908786826,
    55624.304605958219,
    55644.782008500639,
    55665.261295148754,
    55685.742465555952,
    55706.225519375774,
    55726.710456261928,
    55747.197275868275,
    55767.685977848843,
    55788.176561857814,
    55808.669027549528,
    55829.163374578478,
    55849.659602599328,
    55870.157711266889,
    55890.657700236145,
    55911.159569162221,
    55931.663317700411,
    55952.168945506164,
    55972.676452235086,
    55993.185837542944,
    56013.697101085651,
    56034.210242519301,
    56054.72526150012,
    56075.242157684508,
    56095.760930729011,
    56116.281580290342,
    56136.804106025367,
    56157.328507591104,
    56177.85478464474,
    56198.382936843598,
    56218.912963845185,
    56239.444865307138,
    56259.978640887268,
    56280.514290243525,
    56301.051813034042,
    56321.591208917082,
    56342.13247755108,
    56362.675618594607,
    56383.220631706419,
    56403.767516545398,
    56424.316272770608,
    56444.866900041241,
    56465.419398016667,
    56485.973766356394,
    56506.530004720102,
    56527.088112767611,
    56547.648090158902,
    56568.209936554107,
    56588.773651613519,
    56609.339234997584,
    56629.9066863669,
    56650.47600538221,
    56671.04719170442,
    56691.620244994599,
    56712.195164913959,
    56732.771951123868,
    56753.350603285835,
    56773.931121061541,
    56794.513504112823,
    56815.097752101647,
    56835.683864690152,
    56856.271841540627,
    56876.86168231551,
    56897.453386677393,
    56918.046954289028,
    56938.642384813298,
    56959.239677913261,
    56979.838833252121,
    57000.439850493225,
    57021.04272930009,
    57041.647469336371,
    57062.254070265873,
    57082.862531752558,
    57103.472853460553,
    57124.085035054108,
    57144.699076197649,
    57165.314976555739,
    57185.932735793103,
    57206.552353574611,
    57227.173829565276,
    57247.797163430281,
    57268.42235483494,
    57289.049403444733,
    57309.678308925286,
    57330.30907094237,
    57350.941689161911,
    57371.576163249985,
    57392.212492872815,
    57412.850677696784,
    57433.490717388406,
    57454.132611614368,
    57474.776360041491,
    57495.421962336746,
    57516.069418167266,
    57536.718727200314,
    57557.36988910332,
    57578.022903543861,
    57598.677770189643,
    57619.334488708548,
    57639.993058768589,
    57660.653480037938,
    57681.315752184906,
    57701.979874877965,
    57722.64584778573,
    57743.31367057695,
    57763.983342920546,
    57784.654864485572,
    57805.328234941233,
    57826.003453956881,
    57846.680521202026,
    57867.359436346305,
    57888.040199059527,
    57908.722809011633,
    57929.407265872709,
    57950.093569313001,
    57970.781719002895,
    57991.471714612911,
    58012.16355581375,
    58032.857242276223,
    58053.552773671312,
    58074.25014967013,
    58094.949369943948,
    58115.650434164185,
    58136.353342002389,
    58157.058093130276,
    58177.764687219693,
    58198.47312394264,
    58219.183402971255,
    58239.895523977837,
    58260.609486634821,
    58281.325290614775,
    58302.042935590434,
    58322.762421234678,
    58343.483747220511,
    58364.206913221096,
    58384.931918909751,
    58405.658763959924,
    58426.3874480452,
    58447.117970839339,
    58467.85033201622,
    58488.584531249864,
    58509.320568214462,
    58530.058442584334,
    58550.798154033931,
    58571.539702237875,
    58592.283086870906,
    58613.028307607929,
    58633.775364123983,
    58654.52425609425,
    58675.274983194053,
    58696.027545098877,
    58716.781941484325,
    58737.538172026158,
    58758.296236400274,
    58779.056134282728,
    58799.817865349694,
    58820.581429277503,
    58841.346825742643,
    58862.114054421712,
    58882.883114991484,
    58903.654007128847,
    58924.426730510851,
    58945.201284814684,
    58965.977669717664,
    58986.755884897269,
    59007.535930031117,
    59028.317804796949,
    59049.101508872664,
    59069.887041936301,
    59090.674403666046,
    59111.463593740213,
    59132.254611837263,
    59153.047457635803,
    59173.84213081457,
    59194.638631052461,
    59215.436958028506,
    59236.237111421855,
    59257.039090911829,
    59277.842896177877,
    59298.648526899589,
    59319.455982756685,
    59340.26526342905,
    59361.076368596696,
    59381.889297939757,
    59402.704051138542,
    59423.520627873484,
    59444.339027825139,
    59465.159250674224,
    59485.9812961016,
    59506.805163788253,
    59527.630853415307,
    59548.458364664046,
    59569.287697215863,
    59590.118850752311,
    59610.951824955089,
    59631.786619506012,
    59652.623234087048,
    59673.461668380311,
    59694.301922068029,
    59715.143994832593,
    59735.987886356525,
    59756.833596322482,
    59777.681124413255,
    59798.530470311794,
    59819.381633701159,
    59840.234614264569,
    59861.089411685381,
    59881.94602564707,
    59902.804455833269,
    59923.664701927737,
    59944.526763614384,
    59965.390640577243,
    59986.256332500488,
    60007.123839068438,
    60027.993159965539,
    60048.864294876381,
    60069.737243485688,
    60090.612005478324,
    60111.488580539284,
    60132.366968353708,
    60153.247168606867,
    60174.129180984164,
    60195.013005171153,
    60215.898640853513,
    60236.786087717061,
    60257.675345447751,
    60278.566413731671,
    60299.459292255044,
    60320.353980704247,
    60341.25047876576,
    60362.148786126229,
    60383.048902472423,
    60403.950827491237,
    60424.854560869717,
    60445.76010229504,
    60466.667451454516,
    60487.57660803559,
    60508.487571725847,
    60529.400342212997,
    60550.314919184893,
    60571.231302329521,
    60592.149491335003,
    60613.069485889588,
    60633.991285681674,
    60654.914890399785,
    60675.840299732568,
    60696.767513368832,
    60717.696530997484,
    60738.627352307602,
    60759.55997698837,
    60780.494404729128,
    60801.430635219323,
    60822.368668148556,
    60843.308503206565,
    60864.250140083204,
    60885.193578468468,
    60906.138818052495,
    60927.085858525541,
    60948.034699578006,
    60968.985340900421,
    60989.937782183442,
    61010.892023117864,
    61031.848063394616,
    61052.805902704764,
    61073.765540739492,
    61094.726977190134,
    61115.690211748137,
    61136.655244105103,
    61157.622073952742,
    61178.590700982917,
    61199.561124887616,
    61220.533345358948,
    61241.507362089171,
    61262.483174770663,
    61283.460783095943,
    61304.440186757645,
    61325.421385448557,
    61346.404378861582,
    61367.389166689762,
    61388.375748626262,
    61409.364124364387,
    61430.354293597571,
    61451.346256019373,
    61472.340011323497,
    61493.335559203762,
    61514.332899354122,
    61535.332031468672,
    61556.332955241618,
    61577.335670367313,
    61598.340176540238,
    61619.346473454993,
    61640.354560806329,
    61661.3644382891,
    61682.376105598312,
    61703.389562429089,
    61724.404808476691,
    61745.42184343651,
    61766.440667004063,
    61787.461278874987,
    61808.483678745069,
    61829.507866310203,
    61850.533841266435,
    61871.561603309929,
    61892.591152136971,
    61913.622487443987,
    61934.655608927525,
    61955.690516284267,
    61976.727209211022,
    61997.765687404724,
    62018.805950562448,
    62039.847998381381,
    62060.891830558845,
    62081.93744679229,
    62102.984846779298,
    62124.034030217575,
    62145.084996804966,
    62166.137746239416,
    62187.19227821903,
    62208.248592442025,
    62229.306688606739,
    62250.366566411656,
    62271.428225555377,
    62292.491665736627,
    62313.556886654267,
    62334.623888007271,
    62355.692669494762,
    62376.763230815974,
    62397.835571670272,
    62418.909691757144,
    62439.98559077621,
    62461.063268427228,
    62482.142724410049,
    62503.223958424685,
    62524.306970171267,
    62545.39175935003,
    62566.478325661366,
    62587.566668805768,
    62608.656788483881,
    62629.748684396451,
    62650.842356244357,
    62671.937803728622,
    62693.035026550366,
    62714.134024410858,
    62735.234797011479,
    62756.337344053733,
    62777.441665239276,
    62798.547760269852,
    62819.655628847358,
    62840.765270673801,
    62861.876685451323,
    62882.989872882186,
    62904.104832668774,
    62925.221564513602,
    62946.340068119309,
    62967.460343188657,
    62988.582389424526,
    63009.70620652994,
    63030.831794208025,
    63051.959152162039,
    63073.08828009537,
    63094.219177711529,
    63115.351844714154,
    63136.486280806988,
    63157.622485693922,
    63178.760459078956,
    63199.900200666219,
    63221.041710159967,
    63242.184987264569,
    63263.330031684534,
    63284.476843124474,
    63305.625421289144,
    63326.775765883409,
    63347.927876612259,
    63369.081753180813,
    63390.237395294316,
    63411.39480265812,
    63432.553974977716,
    63453.714911958712,
    63474.877613306839,
    63496.042078727944,
    63517.208307927998,
    63538.376300613119,
    63559.546056489504,
    63580.717575263516,
    63601.890856641607,
    63623.065900330374,
    63644.242706036515,
    63665.421273466869,
    63686.601602328381,
    63707.783692328136,
    63728.967543173334,
    63750.153154571279,
    63771.340526229418,
    63792.529657855317,
    63813.720549156649,
    63834.913199841227,
    63856.107609616978,
    63877.303778191941,
    63898.501705274284,
    63919.7013905723,
    63940.902833794404,
    63962.106034649114,
    63983.310992845094,
    64004.517708091109,
    64025.726180096048,
    64046.936408568938,
    64068.1483932189,
    64089.362133755196,
    64110.577629887193,
    64131.794881324393,
    64153.013887776404,
    64174.234648952966,
    64195.457164563937,
    64216.681434319289,
    64237.907457929112,
    64259.135235103626,
    64280.36476555316,
    64301.596048988169,
    64322.829085119236,
    64344.06387365704,
    64365.300414312398,
    64386.538706796251,
    64407.778750819634,
    64429.020546093721,
    64450.26409232981,
    64471.509389239291,
    64492.756436533709,
    64514.005233924705,
    64535.255781124033,
    64556.50807784358,
    64577.762123795357,
    64599.017918691468,
    64620.275462244172,
    64641.534754165805,
    64662.795794168844,
    64684.058581965895,
    64705.323117269661,
    64726.589399792974,
    64747.857429248776,
    64769.127205350138,
    64790.398727810236,
    64811.671996342375,
    64832.947010659969,
    64854.223770476558,
    64875.502275505794,
    64896.782525461451,
    64918.064520057414,
    64939.348259007682,
    64960.633742026388,
    64981.920968827762,
    65003.209939126165,
    65024.500652636067,
    65045.793109072067,
    65067.087308148861,
    65088.383249581282,
    65109.680933084259,
    65130.980358372864,
    65152.28152516226,
    65173.584433167736,
    65194.889082104703,
    65216.195471688683,
    65237.503601635319,
    65258.813471660353,
    65280.125081479666,
    65301.438430809241,
    65322.753519365178,
    65344.070346863708,
    65365.388913021146,
    65386.709217553958,
    65408.031260178701,
    65429.355040612056,
    65450.680558570821,
    65472.00781377191,
    65493.336805932355,
    65514.66753476928,
    65535.999999999956,
    65557.334201341757,
    65578.670138512171,
    65600.007811228788,
    65621.347219209332,
    65642.688362171626,
    65664.031239833639,
    65685.375851913413,
    65706.722198129137,
    65728.070278199084,
    65749.420091841661,
    65770.771638775404,
    65792.124918718939,
    65813.479931391004,
    65834.836676510458,
    65856.195153796303,
    65877.5553629676,
    65898.917303743554,
    65920.280975843489,
    65941.646378986843,
    65963.013512893158,
    65984.382377282076,
    66005.752971873386,
    66027.125296386963,
    66048.499350542799,
    66069.875134061018,
    66091.252646661844,
    66112.631888065618,
    66134.01285799277,
    66155.395556163887,
    66176.779982299631,
    66198.166136120795,
    66219.554017348273,
    66240.943625703105,
    66262.334960906388,
    66283.728022679396,
    66305.122810743444,
    66326.519324820023,
    66347.917564630698,
    66369.317529897162,
    66390.719220341227,
    66412.122635684791,
    66433.527775649884,
    66454.934639958636,
    66476.343228333324,
    66497.753540496284,
    66519.165576169995,
    66540.57933507704,
    66561.994816940118,
    66583.412021482043,
    66604.830948425733,
    66626.251597494222,
    66647.673968410629,
    66669.098060898235,
    66690.523874680381,
    66711.951409480564,
    66733.380665022371,
    66754.811641029475,
    66776.244337225711,
    66797.678753334985,
    66819.11488908132,
    66840.552744188884,
    66861.992318381905,
    66883.433611384738,
    66904.876622921889,
    66926.321352717903,
    66947.767800497502,
    66969.215965985466,
    66990.665848906734,
    67012.117448986304,
    67033.570765949335,
    67055.025799521056,
    67076.482549426815,
    67097.941015392076,
    67119.401197142433,
    67140.863094403554,
    67162.326706901222,
    67183.792034361351,
    67205.259076509959,
    67226.72783307315,
    67248.198303777172,
    67269.670488348347,
    67291.144386513144,
    67312.619997998088,
    67334.09732252988,
    67355.576359835293,
    67377.057109641188,
    67398.53957167457,
    67420.023745662547,
    67441.50963133233,
    67462.99722841123,
    67484.486536626689,
    67505.977555706224,
    67527.470285377494,
    67548.964725368263,
    67570.460875406367,
    67591.9587352198,
    67613.458304536631,
    67634.95958308503,
    67656.462570593329,
    67677.967266789899,
    67699.473671403248,
    67720.981784162024,
    67742.491604794923,
    67764.003133030797,
    67785.516368598575,
    67807.031311227314,
    67828.547960646174,
    67850.066316584402,
    67871.58637877139,
    67893.108146936589,
    67914.63162080961,
    67936.156800120138,
    67957.683684597971,
    67979.212273973011,
    68000.742567975263,
    68022.274566334876,
    68043.808268782057,
    68065.343675047145,
    68086.880784860579,
    68108.419597952918,
    68129.960114054789,
    68151.502332896969,
    68173.04625421032,
    68194.591877725834,
    68216.139203174564,
    68237.688230287706,
    68259.238958796544,
    68280.791388432481,
    68302.345518927032,
    68323.901350011787,
    68345.458881418483,
    68367.018112878912,
    68388.579044125028,
    68410.141674888844,
    68431.706004902502,
    68453.272033898262,
    68474.839761608455,
    68496.409187765545,
    68517.980312102081,
    68539.553134350732,
    68561.127654244279,
    68582.70387151558,
    68604.281785897634,
    68625.861397123503,
    68647.44270492639,
    68669.025709039604,
    68690.610409196524,
    68712.196805130661,
    68733.784896575627,
    68755.374683265123,
    68776.966164932994,
    68798.559341313128,
    68820.154212139591,
    68841.750777146473,
    68863.349036068044,
    68884.948988638629,
    68906.550634592684,
    68928.153973664739,
    68949.75900558944,
    68971.365730101577,
    68992.974146935987,
    69014.584255827634,
    69036.196056511588,
    69057.809548723017,
    69079.424732197207,
    69101.041606669532,
    69122.660171875468,
    69144.280427550606,
    69165.902373430625,
    69187.526009251334,
    69209.151334748618,
    69230.778349658474,
    69252.40705371699,
    69274.037446660412,
    69295.669528225,
    69317.303298147192,
    69338.938756163494,
    69360.575902010532,
    69382.214735425005,
    69403.855256143754,
    69425.497463903681,
    69447.141358441833,
    69468.78693949533,
    69490.434206801394,
    69512.083160097391,
    69533.733799120717,
    69555.386123608929,
    69577.04013329967,
    69598.695827930685,
    69620.353207239794,
    69642.012270964973,
    69663.67301884426,
    69685.335450615792,
    69706.999566017839,
    69728.665364788743,
    69750.332846666963,
    69772.002011391058,
    69793.672858699691,
    69815.345388331611,
    69837.019600025669,
    69858.695493520849,
    69880.373068556204,
    69902.052324870907,
    69923.733262204216,
    69945.415880295492,
    69967.100178884211,
    69988.786157709939,
    70010.473816512356,
    70032.163155031216,
    70053.854173006403,
    70075.546870177874,
    70097.241246285717,
    70118.937301070109,
    70140.635034271298,
    70162.334445629691,
    70184.035534885741,
    70205.738301780017,
    70227.442746053217,
    70249.1488674461,
    70270.856665699539,
    70292.566140554511,
    70314.277291752107,
    70335.990119033493,
    70357.704622139936,
    70379.420800812819,
    70401.138654793613,
    70422.85818382389,
    70444.579387645339,
    70466.302265999722,
    70488.026818628918,
    70509.753045274876,
    70531.480945679708,
    70553.210519585555,
    70574.941766734701,
    70596.674686869505,
    70618.409279732456,
    70640.145545066101,
    70661.883482613106,
    70683.623092116264,
    70705.364373318414,
    70727.107325962526,
    70748.851949791671,
    70770.598244549008,
    70792.346209977783,
    70814.095845821372,
    70835.847151823225,
    70857.600127726895,
    70879.354773276034,
    70901.111088214413,
    70922.869072285859,
    70944.628725234332,
    70966.390046803877,
    70988.153036738629,
    71009.917694782853,
    71031.684020680885,
    71053.45201417715,
    71075.221675016204,
    71096.993002942661,
    71118.765997701266,
    71140.540659036851,
    71162.316986694335,
    71184.09498041874,
    71205.874639955218,
    71227.655965048951,
    71249.438955445294,
    71271.223610889632,
    71293.009931127483,
    71314.797915904477,
    71336.587564966307,
    71358.378878058764,
    71380.171854927772,
    71401.966495319313,
    71423.762798979486,
    71445.560765654489,
    71467.360395090596,
    71489.161687034211,
    71510.964641231811,
    71532.769257429973,
    71554.575535375348,
    71576.383474814749,
    71598.19307549503,
    71620.004337163133,
    71641.817259566145,
    71663.631842451214,
    71685.4480855656,
    71707.26598865664,
    71729.085551471784,
    71750.906773758586,
    71772.729655264673,
    71794.554195737772,
    71816.380394925713,
    71838.208252576442,
    71860.037768437964,
    71881.868942258385,
    71903.701773785942,
    71925.536262768932,
    71947.372408955751,
    71969.210212094898,
    71991.049671934976,
    72012.890788224686,
    72034.73356071279,
    72056.577989148165,
    72078.424073279821,
    72100.271812856794,
    72122.121207628254,
    72143.97225734347,
    72165.824961751801,
    72187.679320602692,
    72209.53533364569,
    72231.393000630429,
    72253.252321306645,
    72275.113295424177,
    72296.975922732949,
    72318.840202982959,
    72340.706135924338,
    72362.573721307272,
    72384.442958882093,
    72406.313848399179,
    72428.186389609036,
    72450.060582262216,
    72471.936426109431,
    72493.813920901433,
    72515.693066389096,
    72537.573862323392,
    72559.456308455352,
    72581.340404536139,
    72603.226150316987,
    72625.113545549248,
    72647.002589984331,
    72668.893283373764,
    72690.785625469172,
    72712.679616022273,
    72734.575254784853,
    72756.472541508803,
    72778.371475946144,
    72800.272057848939,
    72822.174286969355,
    72844.07816305969,
    72865.983685872285,
    72887.890855159596,
    72909.799670674183,
    72931.710132168693,
    72953.622239395845,
    72975.535992108475,
    72997.451390059519,
    73019.368433001961,
    73041.287120688925,
    73063.207452873612,
    73085.129429309294,
    73107.053049749389,
    73128.978313947344,
    73150.905221656736,
    73172.833772631217,
    73194.763966624567,
    73216.695803390612,
    73238.62928268328,
    73260.564404256627,
    73282.501167864757,
    73304.439573261901,
    73326.379620202337,
    73348.321308440485,
    73370.264637730841,
    73392.209607827957,
    73414.156218486532,
    73436.104469461323,
    73458.054360507173,
    73480.005891379056,
    73501.959061831993,
    73523.913871621116,
    73545.870320501665,
    73567.828408228932,
    73589.78813455833,
    73611.749499245358,
    73633.712502045615,
    73655.677142714747,
    73677.643421008557,
    73699.611336682879,
    73721.580889493693,
    73743.552079197019,
    73765.524905548999,
    73787.499368305856,
    73809.475467223907,
    73831.453202059551,
    73853.432572569291,
    73875.413578509717,
    73897.396219637507,
    73919.380495709411,
    73941.36640648231,
    73963.353951713143,
    73985.343131158952,
    74007.333944576865,
    74029.326391724098,
    74051.320472357969,
    74073.316186235883,
    74095.313533115303,
    74117.312512753837,
    74139.313124909138,
    74161.315369338976,
    74183.319245801191,
    74205.324754053727,
    74227.331893854629,
    74249.340664961986,
    74271.351067134034,
    74293.363100129049,
    74315.376763705441,
    74337.392057621662,
    74359.408981636298,
    74381.427535508003,
    74403.447718995507,
    74425.469531857671,
    74447.492973853383,
    74469.518044741693,
    74491.54474428168,
    74513.573072232539,
    74535.603028353551,
    74557.634612404087,
    74579.667824143602,
    74601.702663331642,
    74623.739129727837,
    74645.777223091936,
    74667.816943183716,
    74689.858289763113,
    74711.901262590094,
    74733.945861424741,
    74755.992086027225,
    74778.039936157802,
    74800.089411576817,
    74822.140512044702,
    74844.193237321961,
    74866.24758716923,
    74888.303561347187,
    74910.36115961663,
    74932.420381738411,
    74954.481227473516,
    74976.543696582972,
    74998.607788827925,
    75020.673503969607,
    75042.740841769322,
    75064.809801988464,
    75086.88038438854,
    75108.952588731103,
    75131.026414777836,
    75153.101862290467,
    75175.178931030852,
    75197.257620760924,
    75219.33793124267,
    75241.419862238225,
    75263.503413509738,
    75285.588584819503,
    75307.675375929874,
    75329.763786603318,
    75351.853816602365,
    75373.945465689612,
    75396.038733627807,
    75418.133620179724,
    75440.230125108254,
    75462.32824817636,
    75484.427989147109,
    75506.529347783653,
    75528.63232384919,
    75550.736917107075,
    75572.843127320695,
    75594.950954253538,
    75617.060397669193,
    75639.171457331307,
    75661.284133003646,
    75683.398424450032,
    75705.514331434402,
    75727.631853720741,
    75749.750991073175,
    75771.871743255862,
    75793.994110033076,
    75816.118091169177,
    75838.243686428585,
    75860.370895575848,
    75882.499718375562,
    75904.630154592422,
    75926.762203991224,
    75948.895866336825,
    75971.031141394182,
    75993.168028928325,
    76015.306528704401,
    76037.4466404876,
    76059.588364043215,
    76081.731699136653,
    76103.876645533353,
    76126.023202998884,
    76148.171371298871,
    76170.321150199044,
    76192.472539465205,
    76214.625538863256,
    76236.780148159174,
    76258.936367119008,
    76281.094195508922,
    76303.253633095141,
    76325.414679643975,
    76347.577334921851,
    76369.741598695226,
    76391.907470730686,
    76414.074950794879,
    76436.244038654564,
    76458.414734076548,
    76480.587036827754,
    76502.760946675175,
    76524.936463385893,
    76547.11358672705,
    76569.292316465915,
    76591.472652369819,
    76613.654594206164,
    76635.838141742468,
    76658.023294746308,
    76680.210052985349,
    76702.398416227341,
    76724.588384240138,
    76746.779956791637,
    76768.973133649866,
    76791.167914582897,
    76813.364299358902,
    76835.562287746157,
    76857.761879512967,
    76879.963074427797,
    76902.165872259109,
    76924.37027277553,
    76946.576275745727,
    76968.783880938441,
    76990.993088122515,
    77013.203897066895,
    77035.416307540567,
    77057.630319312622,
    77079.845932152239,
    77102.063145828695,
    77124.281960111301,
    77146.50237476948,
    77168.724389572759,
    77190.948004290723,
    77213.173218693031,
    77235.400032549442,
    77257.628445629802,
    77279.858457704031,
    77302.090068542122,
    77324.323277914169,
    77346.558085590339,
    77368.794491340886,
    77391.032494936138,
    77413.272096146524,
    77435.51329474253,
    77457.756090494731,
    77480.000483173804,
    77502.246472550498,
    77524.494058395634,
    77546.743240480107,
    77568.994018574944,
    77591.246392451198,
    77613.500361880026,
    77635.755926632657,
    77658.013086480438,
    77680.271841194757,
    77702.532190547092,
    77724.794134309021,
    77747.057672252195,
    77769.322804148323,
    77791.589529769248,
    77813.857848886837,
    77836.127761273063,
    77858.399266699998,
    77880.67236493979,
    77902.947055764627,
    77925.223338946831,
    77947.50121425878,
    77969.780681472927,
    77992.061740361838,
    78014.344390698127,
    78036.628632254491,
    78058.914464803747,
    78081.201888118725,
    78103.490901972415,
    78125.781506137821,
    78148.073700388064,
    78170.367484496339,
    78192.662858235926,
    78214.959821380166,
    78237.258373702498,
    78259.558514976452,
    78281.860244975614,
    78304.163563473659,
    78326.468470244363,
    78348.77496506153,
    78371.083047699125,
    78393.392717931114,
    78415.703975531578,
    78438.016820274701,
    78460.331251934695,
    78482.647270285903,
    78504.964875102727,
    78527.284066159627,
    78549.604843231195,
    78571.927206092048,
    78594.251154516911,
    78616.576688280606,
    78638.903807157985,
    78661.232510924034,
    78683.562799353778,
    78705.894672222363,
    78728.228129304945,
    78750.563170376859,
    78772.899795213423,
    78795.238003590101,
    78817.577795282399,
    78839.919170065928,
    78862.262127716356,
    78884.606668009452,
    78906.952790721043,
    78929.300495627045,
    78951.64978250346,
    78974.000651126378,
    78996.353101271932,
    79018.707132716358,
    79041.062745235977,
    79063.41993860717,
    79085.778712606436,
    79108.139067010285,
    79130.501001595389,
    79152.864516138419,
    79175.22961041618,
    79197.596284205531,
    79219.96453728342,
    79242.33436942687,
    79264.705780412987,
    79287.078770018954,
    79309.453338022009,
    79331.829484199508,
    79354.207208328866,
    79376.586510187582,
    79398.967389553218,
    79421.349846203433,
    79443.733879915948,
    79466.119490468584,
    79488.50667763922,
    79510.895441205823,
    79533.285780946433,
    79555.677696639163,
    79578.071188062226,
    79600.466254993895,
    79622.862897212515,
    79645.261114496549,
    79667.660906624471,
    79690.062273374875,
    79712.465214526455,
    79734.869729857935,
    79757.275819148126,
    79779.683482175955,
    79802.092718720378,
    79824.503528560454,
    79846.915911475327,
    79869.329867244203,
    79891.745395646343,
    79914.162496461155,
    79936.581169468045,
    79959.001414446553,
    79981.423231176261,
    80003.846619436852,
    80026.271579008084,
    80048.698109669771,
    80071.12621120183,
    80093.555883384237,
    80115.987125997053,
    80138.419938820414,
    80160.854321634528,
    80183.290274219689,
    80205.727796356281,
    80228.166887824715,
    80250.607548405547,
    80273.049777879336,
    80295.493576026798,
    80317.938942628651,
    80340.385877465727,
    80362.834380318949,
    80385.28445096928,
    80407.736089197788,
    80430.189294785596,
    80452.644067513917,
    80475.100407164035,
    80497.558313517322,
    80520.017786355209,
    80542.478825459213,
    80564.941430610925,
    80587.405601592007,
    80609.871338184195,
    80632.338640169342,
    80654.8075073293,
    80677.277939446067,
    80699.749936301683,
    80722.223497678278,
    80744.698623358039,
    80767.17531312324,
    80789.653566756242,
    80812.133384039465,
    80834.614764755403,
    80857.097708686648,
    80879.582215615854,
    80902.068285325731,
    80924.555917599093,
    80947.045112218824,
    80969.535868967869,
    80992.028187629272,
    81014.522067986123,
    81037.017509821613,
    81059.514512919006,
    81082.013077061609,
    81104.513202032831,
    81127.014887616184,
    81149.518133595193,
    81172.022939753486,
    81194.529305874807,
    81217.037231742899,
    81239.546717141639,
    81262.057761854958,
    81284.570365666848,
    81307.084528361403,
    81329.600249722775,
    81352.117529535186,
    81374.636367582949,
    81397.156763650448,
    81419.678717522125,
    81442.202228982511,
    81464.727297816222,
    81487.253923807933,
    81509.782106742379,
    81532.311846404409,
    81554.843142578902,
    81577.375995050839,
    81599.910403605274,
    81622.446368027333,
    81644.983888102215,
    81667.522963615178,
    81690.063594351581,
    81712.605780096841,
    81735.149520636449,
    81757.694815755967,
    81780.241665241047,
    81802.79006887741,
    81825.340026450824,
    81847.891537747171,
    81870.444602552379,
    81892.999220652477,
    81915.555391833506,
    81938.113115881672,
    81960.672392583176,
    81983.233221724338,
    82005.795603091537,
    82028.359536471224,
    82050.925021649906,
    82073.492058414209,
    82096.060646550788,
    82118.630785846399,
    82141.202476087841,
    82163.775717062032,
    82186.35050855593,
    82208.926850356569,
    82231.504742251054,
    82254.084184026578,
    82276.665175470393,
    82299.24771636985,
    82321.831806512317,
    82344.417445685307,
    82367.004633676348,
    82389.593370273054,
    82412.183655263143,
    82434.775488434374,
    82457.368869574595,
    82479.963798471697,
    82502.560274913689,
    82525.158298688606,
    82547.757869584602,
    82570.35898738986,
    82592.961651892678,
    82615.565862881398,
    82638.171620144421,
    82660.778923470265,
    82683.387772647475,
    82705.998167464713,
    82728.610107710658,
    82751.223593174116,
    82773.83862364394,
    82796.45519890904,
    82819.073318758441,
    82841.692982981185,
    82864.314191366429,
    82886.936943703375,
    82909.561239781324,
    82932.187079389638,
    82954.814462317736,
    82977.443388355125,
    83000.073857291369,
    83022.70586891612,
    83045.339423019104,
    83067.974519390089,
    83090.611157818959,
    83113.249338095629,
    83135.8890600101,
    83158.530323352461,
    83181.173127912858,
    83203.817473481497,
    83226.463359848669,
    83249.11078680474,
    83271.759754140134,
    83294.410261645375,
    83317.062309111003,
    83339.715896327703,
    83362.371023086147,
    83385.027689177165,
    83407.685894391587,
    83430.345638520361,
    83453.006921354478,
    83475.669742685001,
    83498.334102303095,
    83520.999999999942,
    83543.667435566866,
    83566.336408795192,
    83589.006919476349,
    83611.678967401851,
    83634.352552363242,
    83657.027674152167,
    83679.704332560359,
    83702.382527379552,
    83725.062258401638,
    83747.743525418511,
    83770.42632822218,
    83793.110666604684,
    83815.796540358162,
    83838.483949274829,
    83861.172893146941,
    83883.863371766842,
    83906.555384926964,
    83929.248932419752,
    83951.944014037799,
    83974.640629573696,
    83997.338778820151,
    84020.038461569929,
    84042.739677615857,
    84065.442426750829,
    84088.146708767847,
    84110.852523459922,
    84133.559870620171,
    84156.268750041796,
    84178.979161518029,
    84201.691104842204,
    84224.404579807713,
    84247.119586208006,
    84269.83612383662,
    84292.55419248715,
    84315.273791953281,
    84337.994922028738,
    84360.717582507335,
    84383.441773182945,
    84406.167493849513,
    84428.894744301069,
    84451.623524331691,
    84474.353833735542,
    84497.085672306828,
    84519.819039839858,
    84542.553936128999,
    84565.290360968676,
    84588.028314153402,
    84610.767795477717,
    84633.508804736295,
    84656.251341723822,
    84678.995406235073,
    84701.740998064924,
    84724.488117008252,
    84747.236762860062,
    84769.986935415407,
    84792.73863446941,
    84815.491859817252,
    84838.246611254188,
    84861.002888575575,
    84883.760691576768,
    84906.520020053256,
    84929.28087380057,
    84952.043252614312,
    84974.807156290146,
    84997.572584623806,
    85020.339537411113,
    85043.108014447949,
    85065.878015530237,
    85088.649540453989,
    85111.422589015303,
    85134.197161010321,
    85156.973256235244,
    85179.750874486374,
    85202.530015560071,
    85225.310679252725,
    85248.092865360857,
    85270.876573681016,
    85293.661804009811,
    85316.448556143951,
    85339.236829880188,
    85362.026625015351,
    85384.817941346351,
    85407.610778670132,
    85430.405136783724,
    85453.201015484257,
    85475.998414568865,
    85498.797333834795,
    85521.597773079353,
    85544.399732099904,
    85567.203210693886,
    85590.008208658808,
    85612.814725792239,
    85635.62276189182,
    85658.432316755265,
    85681.243390180331,
    85704.055981964877,
    85726.870091906807,
    85749.685719804082,
    85772.502865454764,
    85795.321528656961,
    85818.141709208852,
    85840.963406908675,
    85863.78662155474,
    85886.611352945445,
    85909.437600879217,
    85932.26536515457,
    85955.094645570091,
    85977.92544192441,
    86000.757754016275,
    86023.591581644432,
    86046.426924607746,
    86069.263782705122,
    86092.102155735556,
    86114.942043498071,
    86137.783445791807,
    86160.626362415918,
    86183.470793169676,
    86206.316737852379,
    86229.164196263402,
    86252.013168202204,
    86274.863653468303,
    86297.715651861261,
    86320.569163180728,
    86343.424187226425,
    86366.280723798132,
    86389.138772695675,
    86411.998333718977,
    86434.859406668009,
    86457.721991342827,
    86480.586087543532,
    86503.451695070296,
    86526.318813723352,
    86549.187443303032,
    86572.057583609683,
    86594.929234443756,
    86617.802395605773,
    86640.677066896271,
    86663.553248115903,
    86686.43093906538,
    86709.310139545443,
    86732.190849356964,
    86755.073068300815,
    86777.956796177954,
    86800.842032789442,
    86823.728777936354,
    86846.617031419853,
    86869.506793041175,
    86892.398062601613,
    86915.290839902518,
    86938.185124745316,
    86961.080916931489,
    86983.978216262592,
    87006.87702254027,
    87029.777335566177,
    87052.67915514209,
    87075.582481069796,
    87098.487313151185,
    87121.39365118822,
    87144.301494982894,
    87167.210844337285,
    87190.121699053532,
    87213.034058933845,
    87235.947923780506,
    87258.863293395829,
    87281.780167582241,
    87304.698546142172,
    87327.618428878181,
    87350.539815592856,
    87373.462706088845,
    87396.387100168897,
    87419.312997635774,
    87442.240398292357,
    87465.16930194154,
    87488.099708386319,
    87511.031617429733,
    87533.965028874911,
    87556.899942525008,
    87579.836358183282,
    87602.774275653021,
    87625.713694737613,
    87648.654615240492,
    87671.597036965148,
    87694.540959715145,
    87717.486383294105,
    87740.433307505737,
    87763.381732153779,
    87786.331657042057,
    87809.283081974456,
    87832.236006754916,
    87855.190431187453,
    87878.146355076155,
    87901.103778225151,
    87924.062700438633,
    87947.023121520891,
    87969.985041276246,
    87992.948459509105,
    88015.913376023906,
    88038.879790625171,
    88061.847703117513,
    88084.817113305573,
    88107.788020994049,
    88130.760425987726,
    88153.734328091465,
    88176.709727110137,
    88199.686622848749,
    88222.665015112303,
    88245.644903705906,
    88268.626288434709,
    88291.609169103947,
    88314.593545518903,
    88337.579417484914,
    88360.566784807408,
    88383.555647291854,
    88406.546004743795,
    88429.537856968818,
    88452.531203772611,
    88475.52604496089,
    88498.522380339447,
    88521.52020971413,
    88544.519532890874,
    88567.520349675644,
    88590.522659874507,
    88613.526463293543,
    88636.531759738922,
    88659.538549016899,
    88682.546830933745,
    88705.556605295846,
    88728.567871909589,
    88751.580630581491,
    88774.594881118086,
    88797.610623325963,
    88820.62785701183,
    88843.646581982393,
    88866.666798044462,
    88889.688505004888,
    88912.711702670611,
    88935.7363908486,
    88958.762569345898,
    88981.790237969632,
    89004.81939652696,
    89027.850044825114,
    89050.882182671412,
    89073.9158098732,
    89096.950926237885,
    89119.987531572973,
    89143.025625686001,
    89166.065208384563,
    89189.106279476357,
    89212.148838769106,
    89235.192886070581,
    89258.238421188667,
    89281.285443931265,
    89304.333954106376,
    89327.383951522017,
    89350.435435986306,
    89373.488407307406,
    89396.542865293537,
    89419.598809753006,
    89442.656240494165,
    89465.715157325409,
    89488.775560055219,
    89511.837448492137,
    89534.900822444746,
    89557.965681721733,
    89581.032026131812,
    89604.099855483742,
    89627.169169586399,
    89650.239968248672,
    89673.312251279538,
    89696.386018488018,
    89719.461269683205,
    89742.53800467425,
    89765.616223270365,
    89788.69592528083,
    89811.777110514988,
    89834.859778782207,
    89857.943929891975,
    89881.029563653807,
    89904.116679877261,
    89927.205278372014,
    89950.29535894774,
    89973.386921414218,
    89996.479965581268,
    90019.574491258769,
    90042.670498256688,
    90065.767986385021,
    90088.866955453836,
    90111.967405273259,
    90135.069335653476,
    90158.172746404758,
    90181.277637337407,
    90204.384008261797,
    90227.49185898836,
    90250.601189327586,
    90273.711999090039,
    90296.824288086325,
    90319.938056127125,
    90343.053303023189,
    90366.170028585286,
    90389.288232624298,
    90412.407914951138,
    90435.529075376777,
    90458.651713712257,
    90481.775829768681,
    90504.901423357209,
    90528.028494289058,
    90551.157042375504,
    90574.287067427911,
    90597.418569257643,
    90620.551547676194,
    90643.686002495073,
    90666.821933525847,
    90689.959340580186,
    90713.098223469773,
    90736.238582006365,
    90759.380416001804,
    90782.523725267951,
    90805.668509616764,
    90828.814768860233,
    90851.962502810435,
    90875.11171127946,
    90898.262394079517,
    90921.414551022855,
    90944.568181921743,
    90967.72328658856,
    90990.879864835719,
    91014.037916475718,
    91037.19744132107,
    91060.358439184391,
    91083.520909878338,
    91106.684853215629,
    91129.850269009039,
    91153.017157071401,
    91176.185517215621,
    91199.355349254649,
    91222.526653001492,
    91245.699428269247,
    91268.873674871036,
    91292.049392620058,
    91315.226581329553,
    91338.405240812834,
    91361.585370883287,
    91384.766971354344,
    91407.950042039476,
    91431.134582752245,
    91454.320593306256,
    91477.508073515171,
    91500.697023192712,
    91523.887442152685,
    91547.07933020893,
    91570.272687175326,
    91593.467512865856,
    91616.663807094534,
    91639.861569675442,
    91663.060800422725,
    91686.261499150554,
    91709.463665673218,
    91732.66729980502,
    91755.872401360321,
    91779.078970153569,
    91802.287005999257,
    91825.49650871192,
    91848.707478106167,
    91871.91991399668,
    91895.133816198169,
    91918.349184525418,
    91941.566018793281,
    91964.784318816659,
    91988.004084410495,
    92011.22531538982,
    92034.448011569708,
    92057.672172765277,
    92080.897798791746,
    92104.124889464365,
    92127.353444598411,
    92150.58346400928,
    92173.814947512379,
    92197.04789492322,
    92220.282306057314,
    92243.518180730272,
    92266.755518757753,
    92289.994319955469,
    92313.234584139194,
    92336.476311124774,
    92359.719500728082,
    92382.964152765067,
    92406.210267051734,
    92429.457843404161,
    92452.706881638471,
    92475.957381570814,
    92499.209343017443,
    92522.462765794655,
    92545.717649718805,
    92568.973994606305,
    92592.231800273614,
    92615.491066537259,
    92638.751793213814,
    92662.01398011994,
    92685.277627072326,
    92708.54273388772,
    92731.809300382942,
    92755.077326374871,
    92778.346811680414,
    92801.617756116568,
    92824.890159500384,
    92848.164021648947,
    92871.439342379424,
    92894.716121509016,
    92917.994358855023,
    92941.274054234746,
    92964.555207465572,
    92987.837818364962,
    93011.121886750407,
    93034.407412439468,
    93057.694395249753,
    93080.982834998955,
    93104.272731504767,
    93127.564084584999,
    93150.856894057491,
    93174.15115974014,
    93197.446881450916,
    93220.744059007804,
    93244.04269222889,
    93267.342780932304,
    93290.644324936235,
    93313.947324058914,
    93337.251778118633,
    93360.557686933767,
    93383.865050322696,
    93407.173868103928,
    93430.484140095941,
    93453.795866117362,
    93477.109045986799,
    93500.423679522952,
    93523.739766544561,
    93547.057306870454,
    93570.376300319491,
    93593.696746710571,
    93617.018645862699,
    93640.341997594893,
    93663.666801726242,
    93686.993058075881,
    93710.320766463032,
    93733.64992670693,
    93756.980538626914,
    93780.312602042337,
    93803.646116772637,
    93826.981082637285,
    93850.317499455836,
    93873.655367047861,
    93896.994685233032,
    93920.335453831038,
    93943.677672661666,
    93967.021341544707,
    93990.366460300051,
    94013.713028747632,
    94037.061046707429,
    94060.410513999494,
    94083.761430443905,
    94107.113795860845,
    94130.467610070496,
    94153.822872893157,
    94177.179584149111,
    94200.537743658759,
    94223.897351242529,
    94247.25840672091,
    94270.620909914433,
    94293.98486064373,
    94317.350258729421,
    94340.71710399224,
    94364.085396252936,
    94387.455135332348,
    94410.82632105134,
    94434.198953230851,
    94457.573031691878,
    94480.948556255447,
    94504.325526742658,
    94527.70394297468,
    94551.083804772716,
    94574.465111958023,
    94597.847864351934,
    94621.232061775823,
    94644.617704051096,
    94668.004790999272,
    94691.393322441872,
    94714.783298200506,
    94738.174718096794,
    94761.567581952477,
    94784.961889589307,
    94808.357640829097,
    94831.754835493703,
    94855.153473405066,
    94878.553554385173,
    94901.955078256055,
    94925.358044839784,
    94948.762453958523,
    94972.168305434476,
    94995.575599089891,
    95018.984334747074,
    95042.394512228391,
    95065.806131356265,
    95089.219191953176,
    95112.633693841635,
    95136.04963684424,
    95159.467020783617,
    95182.885845482466,
    95206.306110763529,
    95229.727816449609,
    95253.150962363579,
    95276.575548328314,
    95300.001574166803,
    95323.429039702052,
    95346.857944757154,
    95370.288289155214,
    95393.720072719429,
    95417.153295273019,
    95440.587956639298,
    95464.024056641589,
    95487.461595103305,
    95510.900571847902,
    95534.340986698866,
    95557.782839479783,
    95581.226130014256,
    95604.670858125959,
    95628.117023638595,
    95651.564626375985,
    95675.013666161918,
    95698.464142820303,
    95721.916056175076,
    95745.369406050231,
    95768.824192269807,
    95792.280414657915,
    95815.738073038709,
    95839.197167236387,
    95862.657697075221,
    95886.11966237954,
    95909.583062973688,
    95933.047898682111,
    95956.514169329268,
    95979.981874739708,
    96003.451014738006,
    96026.921589148798,
    96050.393597796792,
    96073.867040506724,
    96097.341917103375,
    96120.818227411626,
    96144.295971256375,
    96167.775148462577,
    96191.255758855244,
    96214.737802259449,
    96238.221278500292,
    96261.70618740299,
    96285.192528792715,
    96308.680302494788,
    96332.169508334526,
    96355.660146137321,
    96379.152215728609,
    96402.645716933868,
    96426.14064957868,
    96449.637013488609,
    96473.134808489311,
    96496.63403440651,
    96520.134691065963,
    96543.636778293469,
    96567.140295914898,
    96590.645243756153,
    96614.151621643221,
    96637.659429402134,
    96661.168666858954,
    96684.679333839798,
    96708.191430170875,
    96731.70495567839,
    96755.219910188665,
    96778.736293528011,
    96802.254105522836,
    96825.77334599958,
    96849.29401478474,
    96872.816111704873,
    96896.339636586577,
    96919.864589256511,
    96943.390969541389,
    96966.918777267958,
    96990.448012263048,
    97013.978674353522,
    97037.510763366285,
    97061.044279128328,
    97084.579221466673,
    97108.115590208385,
    97131.653385180587,
    97155.19260621049,
    97178.733253125291,
    97202.2753257523,
    97225.81882391886,
    97249.363747452342,
    97272.910096180189,
    97296.457869929916,
    97320.007068529041,
    97343.557691805196,
    97367.109739586012,
    97390.663211699197,
    97414.218107972498,
    97437.774428233737,
    97461.332172310766,
    97484.891340031507,
    97508.451931223899,
    97532.013945715982,
    97555.577383335811,
    97579.142243911512,
    97602.708527271257,
    97626.276233243261,
    97649.845361655811,
    97673.415912337223,
    97696.987885115886,
    97720.561279820206,
    97744.1360962787,
    97767.712334319876,
    97791.289993772341,
    97814.869074464703,
    97838.449576225685,
    97862.031498883996,
    97885.614842268449,
    97909.199606207883,
    97932.785790531183,
    97956.37339506732,
    97979.962419645264,
    98003.552864094076,
    98027.144728242856,
    98050.738011920766,
    98074.332714956996,
    98097.928837180807,
    98121.526378421506,
    98145.125338508456,
    98168.725717271067,
    98192.327514538789,
    98215.930730141132,
    98239.535363907664,
    98263.141415668011,
    98286.748885251814,
    98310.357772488816,
    98333.968077208759,
    98357.579799241488,
    98381.192938416847,
    98404.807494564782,
    98428.42346751524,
    98452.040857098269,
    98475.659663143917,
    98499.27988548232,
    98522.901523943656,
    98546.524578358163,
    98570.149048556093,
    98593.774934367786,
    98617.402235623624,
    98641.030952154048,
    98664.661083789513,
    98688.292630360564,
    98711.925591697771,
    98735.559967631794,
    98759.195757993293,
    98782.832962613014,
    98806.471581321734,
    98830.111613950285,
    98853.753060329575,
    98877.39592029051,
    98901.040193664099,
    98924.68588028138,
    98948.33297997342,
    98971.981492571387,
    98995.63141790645,
    99019.282755809851,
    99042.935506112874,
    99066.589668646877,
    99090.245243243233,
    99113.902229733401,
    99137.560627948857,
    99161.220437721131,
    99184.881658881859,
    99208.544291262631,
    99232.208334695169,
    99255.87378901121,
    99279.540654042547,
    99303.208929621018,
    99326.878615578535,
    99350.549711746993,
    99374.222217958435,
    99397.896134044888,
    99421.571459838422,
    99445.248195171211,
    99468.926339875441,
    99492.605893783344,
    99516.286856727209,
    99539.969228539398,
    99563.653009052287,
    99587.338198098325,
    99611.024795510006,
    99634.712801119866,
    99658.402214760499,
    99682.093036264545,
    99705.785265464699,
    99729.478902193689,
    99753.173946284325,
    99776.870397569437,
    99800.56825588191,
    99824.267521054688,
    99847.968192920773,
    99871.670271313182,
    99895.373756065004,
    99919.078647009388,
    99942.78494397951,
    99966.492646808634,
    99990.20175533001,
    100013.91226937699,
    100037.62418878295,
    100061.33751338134,
    100085.05224300563,
    100108.76837748935,
    100132.4859166661,
    100156.2048603695,
    100179.92520843323,
    100203.64696069101,
    100227.37011697664,
    100251.09467712394,
    100274.82064096678,
    100298.54800833909,
    100322.27677907483,
    100346.00695300807,
    100369.73852997283,
    100393.47150980328,
    100417.20589233354,
    100440.94167739789,
    100464.67886483055,
    100488.41745446586,
    100512.1574461382,
    100535.89883968196,
    100559.64163493161,
    100583.38583172169,
    100607.13142988674,
    100630.87842926137,
    100654.62682968024,
    100678.37663097809,
    100702.12783298964,
    100725.88043554971,
    100749.63443849317,
    100773.38984165489,
    100797.14664486986,
    100820.90484797307,
    100844.66445079957,
    100868.42545318443,
    100892.18785496285,
    100915.95165596998,
    100939.71685604109,
    100963.48345501146,
    100987.25145271645,
    101011.02084899142,
    101034.79164367182,
    101058.56383659317,
    101082.33742759094,
    101106.11241650078,
    101129.88880315828,
    101153.66658739912,
    101177.44576905905,
    101201.22634797383,
    101225.00832397929,
    101248.7916969113,
    101272.57646660579,
    101296.36263289873,
    101320.15019562612,
    101343.93915462404,
    101367.7295097286,
    101391.52126077596,
    101415.31440760233,
    101439.10895004397,
    101462.9048879372,
    101486.70222111834,
    101510.50094942382,
    101534.30107269008,
    101558.10259075361,
    101581.90550345098,
    101605.70981061876,
    101629.5155120936,
    101653.32260771218,
    101677.13109731126,
    101700.9409807276,
    101724.75225779804,
    101748.56492835947,
    101772.37899224881,
    101796.19444930303,
    101820.01129935916,
    101843.82954225427,
    101867.64917782549,
    101891.47020590997,
    101915.29262634492,
    101939.11643896763,
    101962.94164361537,
    101986.76824012553,
    102010.59622833549,
    102034.42560808272,
    102058.25637920471,
    102082.08854153901,
    102105.9220949232,
    102129.75703919494,
    102153.59337419191,
    102177.43109975185,
    102201.27021571253,
    102225.1107219118,
    102248.95261818753,
    102272.79590437764,
    102296.64058032009,
    102320.48664585294,
    102344.33410081422,
    102368.18294504205,
    102392.03317837461,
    102415.88480065008,
    102439.73781170673,
    102463.59221138287,
    102487.44799951684,
    102511.30517594704,
    102535.1637405119,
    102559.02369304992,
    102582.88503339965,
    102606.74776139967,
    102630.61187688859,
    102654.4773797051,
    102678.34426968795,
    102702.21254667587,
    102726.08221050771,
    102749.95326102231,
    102773.8256980586,
    102797.69952145554,
    102821.57473105213,
    102845.45132668741,
    102869.32930820051,
    102893.20867543056,
    102917.08942821674,
    102940.97156639832,
    102964.85508981455,
    102988.73999830478,
    103012.6262917084,
    103036.51396986481,
    103060.40303261351,
    103084.293479794,
    103108.18531124585,
    103132.07852680866,
    103155.97312632212,
    103179.8691096259,
    103203.76647655977,
    103227.66522696352,
    103251.56536067701,
    103275.46687754011,
    103299.36977739276,
    103323.27406007495,
    103347.1797254267,
    103371.0867732881,
    103394.99520349925,
    103418.90501590034,
    103442.81621033157,
    103466.72878663319,
    103490.64274464553,
    103514.55808420894,
    103538.4748051638,
    103562.39290735057,
    103586.31239060973,
    103610.23325478184,
    103634.15549970744,
    103658.07912522719,
    103682.00413118176,
    103705.93051741188,
    103729.85828375829,
    103753.78743006183,
    103777.71795616332,
    103801.64986190372,
    103825.58314712394,
    103849.51781166498,
    103873.4538553679,
    103897.39127807376,
    103921.33007962372,
    103945.27025985894,
    103969.21181862066,
    103993.15475575015,
    104017.0990710887,
    104041.0447644777,
    104064.99183575854,
    104088.94028477269,
    104112.89011136163,
    104136.84131536692,
    104160.79389663014,
    104184.74785499295,
    104208.70319029699,
    104232.65990238401,
    104256.61799109577,
    104280.57745627411,
    104304.53829776087,
    104328.50051539797,
    104352.46410902737,
    104376.42907849104,
    104400.39542363105,
    104424.36314428948,
    104448.33224030846,
    104472.3027115302,
    104496.27455779689,
    104520.24777895081,
    104544.22237483428,
    104568.19834528965,
    104592.17569015936,
    104616.15440928582,
    104640.13450251156,
    104664.1159696791,
    104688.09881063103,
    104712.08302520998,
    104736.06861325864,
    104760.05557461972,
    104784.043909136,
    104808.03361665027,
    104832.0246970054,
    104856.01715004431,
    104880.01097560991,
    104904.00617354522,
    104928.00274369326,
    104952.00068589712,
    104975.99999999993,
    105000.00068584486,
    105024.00274327511,
    105048.00617213396,
    105072.0109722647,
    105096.0171435107,
    105120.02468571534,
    105144.03359872208,
    105168.04388237436,
    105192.05553651576,
    105216.06856098982,
    105240.08295564017,
    105264.09872031047,
    105288.11585484444,
    105312.13435908582,
    105336.1542328784,
    105360.17547606604,
    105384.19808849262,
    105408.22207000206,
    105432.24742043833,
    105456.27413964548,
    105480.30222746753,
    105504.33168374863,
    105528.36250833291,
    105552.39470106458,
    105576.42826178786,
    105600.46319034706,
    105624.49948658649,
    105648.53715035053,
    105672.5761814836,
    105696.61657983017,
    105720.65834523473,
    105744.70147754184,
    105768.7459765961,
    105792.79184224214,
    105816.83907432464,
    105840.88767268835,
    105864.93763717801,
    105888.98896763846,
    105913.04166391456,
    105937.09572585119,
    105961.15115329332,
    105985.20794608595,
    106009.26610407409,
    106033.32562710284,
    106057.38651501729,
    106081.44876766266,
    106105.51238488412,
    106129.57736652695,
    106153.64371243643,
    106177.71142245791,
    106201.78049643678,
    106225.85093421848,
    106249.92273564848,
    106273.99590057228,
    106298.07042883546,
    106322.14632028362,
    106346.22357476239,
    106370.30219211751,
    106394.38217219469,
    106418.46351483969,
    106442.54621989837,
    106466.63028721658,
    106490.71571664025,
    106514.80250801529,
    106538.89066118775,
    106562.98017600364,
    106587.07105230905,
    106611.16328995011,
    106635.25688877302,
    106659.35184862395,
    106683.44816934918,
    106707.54585079502,
    106731.64489280782,
    106755.74529523395,
    106779.84705791986,
    106803.95018071201,
    106828.05466345693,
    106852.16050600118,
    106876.26770819137,
    106900.37626987413,
    106924.48619089619,
    106948.59747110425,
    106972.71011034511,
    106996.82410846559,
    107020.93946531253,
    107045.05618073288,
    107069.17425457356,
    107093.29368668159,
    107117.41447690397,
    107141.53662508781,
    107165.66013108024,
    107189.7849947284,
    107213.91121587952,
    107238.03879438085,
    107262.16773007967,
    107286.29802282334,
    107310.42967245923,
    107334.56267883476,
    107358.69704179741,
    107382.83276119467,
    107406.96983687414,
    107431.10826868335,
    107455.24805646999,
    107479.38920008171,
    107503.53169936626,
    107527.67555417139,
    107551.82076434491,
    107575.96732973469,
    107600.11525018861,
    107624.26452555459,
    107648.41515568066,
    107672.56714041479,
    107696.72047960508,
    107720.87517309963,
    107745.03122074658,
    107769.18862239413,
    107793.34737789053,
    107817.50748708403,
    107841.66894982298,
    107865.83176595572,
    107889.99593533068,
    107914.16145779629,
    107938.32833320105,
    107962.49656139348,
    107986.66614222217,
    108010.83707553572,
    108035.00936118282,
    108059.18299901215,
    108083.35798887245,
    108107.53433061253,
    108131.71202408121,
    108155.89106912735,
    108180.07146559987,
    108204.25321334775,
    108228.43631221994,
    108252.62076206553,
    108276.80656273357,
    108300.99371407321,
    108325.18221593359,
    108349.37206816394,
    108373.56327061349,
    108397.75582313156,
    108421.94972556747,
    108446.1449777706,
    108470.34157959036,
    108494.53953087622,
    108518.73883147769,
    108542.93948124432,
    108567.14148002568,
    108591.34482767139,
    108615.54952403114,
    108639.75556895464,
    108663.96296229165,
    108688.17170389196,
    108712.38179360541,
    108736.59323128188,
    108760.80601677128,
    108785.02014992358,
    108809.23563058881,
    108833.45245861699,
    108857.67063385822,
    108881.89015616261,
    108906.11102538036,
    108930.33324136167,
    108954.55680395682,
    108978.78171301607,
    109003.00796838976,
    109027.23556992831,
    109051.46451748211,
    109075.69481090162,
    109099.92645003737,
    109124.15943473989,
    109148.39376485976,
    109172.62944024763,
    109196.86646075416,
    109221.10482623006,
    109245.34453652608,
    109269.58559149304,
    109293.82799098175,
    109318.07173484311,
    109342.31682292801,
    109366.56325508743,
    109390.81103117237,
    109415.06015103387,
    109439.31061452301,
    109463.56242149093,
    109487.8155717888,
    109512.07006526781,
    109536.3259017792,
    109560.58308117429,
    109584.8416033044,
    109609.1014680209,
    109633.36267517522,
    109657.62522461878,
    109681.88911620311,
    109706.15434977971,
    109730.4209252002,
    109754.68884231619,
    109778.95810097932,
    109803.22870104131,
    109827.50064235389,
    109851.77392476884,
    109876.04854813802,
    109900.32451231324,
    109924.60181714644,
    109948.88046248957,
    109973.1604481946,
    109997.44177411357,
    110021.72444009855,
    110046.00844600165,
    110070.29379167501,
    110094.58047697082,
    110118.86850174134,
    110143.15786583882,
    110167.44856911557,
    110191.74061142397,
    110216.03399261639,
    110240.32871254528,
    110264.62477106311,
    110288.9221680224,
    110313.22090327571,
    110337.52097667565,
    110361.82238807483,
    110386.12513732594,
    110410.42922428172,
    110434.73464879491,
    110459.04141071832,
    110483.34950990479,
    110507.6589462072,
    110531.96971947847,
    110556.28182957157,
    110580.5952763395,
    110604.91005963532,
    110629.22617931209,
    110653.54363522294,
    110677.86242722106,
    110702.18255515963,
    110726.50401889188,
    110750.82681827113,
    110775.1509531507,
    110799.47642338395,
    110823.80322882428,
    110848.13136932514,
    110872.46084474004,
    110896.79165492248,
    110921.12379972603,
    110945.4572790043,
    110969.79209261097,
    110994.12824039967,
    111018.46572222417,
    111042.80453793822,
    111067.14468739564,
    111091.48617045028,
    111115.82898695602,
    111140.1731367668,
    111164.51861973655,
    111188.86543571933,
    111213.21358456917,
    111237.56306614014,
    111261.91388028639,
    111286.26602686207,
    111310.61950572141,
    111334.97431671864,
    111359.33045970804,
    111383.68793454397,
    111408.04674108078,
    111432.40687917286,
    111456.76834867468,
    111481.13114944073,
    111505.49528132551,
    111529.86074418361,
    111554.22753786964,
    111578.59566223821,
    111602.96511714405,
    111627.33590244185,
    111651.7080179864,
    111676.08146363248,
    111700.45623923496,
    111724.8323446487,
    111749.20977972864,
    111773.58854432974,
    111797.96863830699,
    111822.35006151545,
    111846.73281381019,
    111871.11689504632,
    111895.50230507903,
    111919.8890437635,
    111944.27711095495,
    111968.6665065087,
    111993.05723028004,
    112017.44928212435,
    112041.842661897,
    112066.23736945343,
    112090.63340464912,
    112115.03076733962,
    112139.42945738042,
    112163.82947462716,
    112188.23081893545,
    112212.63349016097,
    112237.03748815943,
    112261.44281278658,
    112285.84946389822,
    112310.25744135017,
    112334.66674499828,
    112359.07737469849,
    112383.48933030672,
    112407.90261167898,
    112432.31721867126,
    112456.73315113965,
    112481.15040894024,
    112505.56899192919,
    112529.98889996267,
    112554.41013289688,
    112578.8326905881,
    112603.25657289263,
    112627.68177966679,
    112652.10831076698,
    112676.53616604958,
    112700.96534537108,
    112725.39584858794,
    112749.82767555672,
    112774.26082613398,
    112798.6953001763,
    112823.13109754038,
    112847.56821808286,
    112872.00666166049,
    112896.44642813003,
    112920.88751734827,
    112945.32992917208,
    112969.77366345831,
    112994.21872006389,
    113018.66509884578,
    113043.11279966099,
    113067.56182236652,
    113092.01216681948,
    113116.46383287695,
    113140.9168203961,
    113165.37112923413,
    113189.82675924824,
    113214.28371029573,
    113238.74198223387,
    113263.20157492002,
    113287.66248821157,
    113312.12472196593,
    113336.58827604055,
    113361.05315029295,
    113385.51934458067,
    113409.98685876124,
    113434.45569269233,
    113458.92584623155,
    113483.39731923661,
    113507.87011156522,
    113532.34422307517,
    113556.81965362425,
    113581.2964030703,
    113605.77447127122,
    113630.25385808491,
    113654.73456336933,
    113679.2165869825,
    113703.69992878241,
    113728.18458862718,
    113752.67056637487,
    113777.15786188368,
    113801.64647501177,
    113826.13640561736,
    113850.62765355874,
    113875.12021869418,
    113899.61410088204,
    113924.1092999807,
    113948.60581584855,
    113973.10364834407,
    113997.60279732574,
    114022.1032626521,
    114046.60504418171,
    114071.10814177318,
    114095.61255528514,
    114120.11828457628,
    114144.62532950533,
    114169.13368993104,
    114193.6433657122,
    114218.15435670764,
    114242.66666277625,
    114267.18028377694,
    114291.69521956862,
    114316.21147001031,
    114340.72903496103,
    114365.24791427983,
    114389.7681078258,
    114414.2896154581,
    114438.81243703589,
    114463.33657241837,
    114487.8620214648,
    114512.38878403447,
    114536.91685998671,
    114561.44624918087,
    114585.97695147636,
    114610.5089667326,
    114635.04229480909,
    114659.57693556532,
    114684.11288886084,
    114708.65015455526,
    114733.18873250818,
    114757.72862257928,
    114782.26982462825,
    114806.81233851484,
    114831.35616409882,
    114855.90130123998,
    114880.44774979822,
    114904.99550963337,
    114929.5445806054,
    114954.09496257425,
    114978.64665539992,
    115003.19965894247,
    115027.75397306195,
    115052.30959761847,
    115076.86653247218,
    115101.42477748329,
    115125.984332512,
    115150.54519741859,
    115175.10737206334,
    115199.67085630659,
    115224.23565000873,
    115248.80175303014,
    115273.3691652313,
    115297.93788647266,
    115322.50791661476,
    115347.07925551817,
    115371.65190304347,
    115396.22585905129,
    115420.80112340231,
    115445.37769595724,
    115469.95557657682,
    115494.53476512182,
    115519.11526145306,
    115543.69706543141,
    115568.28017691776,
    115592.86459577303,
    115617.4503218582,
    115642.03735503425,
    115666.62569516223,
    115691.21534210323,
    115715.80629571836,
    115740.39855586876,
    115764.99212241563,
    115789.58699522018,
    115814.18317414368,
    115838.78065904744,
    115863.37944979276,
    115887.97954624105,
    115912.5809482537,
    115937.18365569216,
    115961.78766841792,
    115986.39298629249,
    116010.99960917742,
    116035.60753693432,
    116060.21676942479,
    116084.82730651053,
    116109.43914805322,
    116134.0522939146,
    116158.66674395646,
    116183.2824980406,
    116207.89955602887,
    116232.51791778316,
    116257.13758316539,
    116281.75855203751,
    116306.38082426153,
    116331.00439969949,
    116355.62927821343,
    116380.25545966547,
    116404.88294391775,
    116429.51173083246,
    116454.14182027178,
    116478.77321209799,
    116503.40590617337,
    116528.03990236025,
    116552.67520052097,
    116577.31180051794,
    116601.94970221359,
    116626.5889054704,
    116651.22941015086,
    116675.87121611751,
    116700.51432323294,
    116725.15873135976,
    116749.8044403606,
    116774.45145009817,
    116799.0997604352,
    116823.74937123443,
    116848.40028235866,
    116873.05249367072,
    116897.70600503348,
    116922.36081630984,
    116947.01692736275,
    116971.67433805518,
    116996.33304825013,
    117020.99305781067,
    117045.65436659988,
    117070.31697448085,
    117094.98088131678,
    117119.64608697082,
    117144.31259130624,
    117168.98039418629,
    117193.64949547425,
    117218.31989503348,
    117242.99159272734,
    117267.66458841923,
    117292.33888197262,
    117317.01447325097,
    117341.6913621178,
    117366.36954843666,
    117391.04903207115,
    117415.72981288488,
    117440.41189074152,
    117465.09526550474,
    117489.77993703831,
    117514.46590520597,
    117539.15316987153,
    117563.84173089883,
    117588.53158815173,
    117613.22274149416,
    117637.91519079007,
    117662.60893590341,
    117687.30397669821,
    117712.00031303853,
    117736.69794478847,
    117761.39687181212,
    117786.09709397367,
    117810.7986111373,
    117835.50142316725,
    117860.20552992777,
    117884.91093128319,
    117909.6176270978,
    117934.32561723603,
    117959.03490156225,
    117983.74547994092,
    118008.45735223651,
    118033.17051831353,
    118057.88497803656,
    118082.60073127014,
    118107.31777787894,
    118132.03611772758,
    118156.75575068076,
    118181.47667660323,
    118206.19889535972,
    118230.92240681504,
    118255.64721083404,
    118280.37330728157,
    118305.10069602253,
    118329.82937692189,
    118354.55934984458,
    118379.29061465565,
    118404.02317122012,
    118428.75701940308,
    118453.49215906965,
    118478.22859008498,
    118502.96631231424,
    118527.70532562268,
    118552.44562987552,
    118577.18722493808,
    118601.93011067568,
    118626.67428695368,
    118651.41975363747,
    118676.16651059251,
    118700.91455768423,
    118725.66389477813,
    118750.41452173979,
    118775.16643843475,
    118799.91964472862,
    118824.67414048707,
    118849.42992557574,
    118874.18699986035,
    118898.94536320666,
    118923.70501548045,
    118948.46595654752,
    118973.22818627374,
    118997.99170452499,
    119022.7565111672,
    119047.52260606633,
    119072.28998908834,
    119097.0586600993,
    119121.82861896523,
    119146.59986555226,
    119171.3723997265,
    119196.14622135412,
    119220.92133030134,
    119245.69772643436,
    119270.47540961947,
    119295.25437972297,
    119320.03463661121,
    119344.81618015055,
    119369.5990102074,
    119394.38312664822,
    119419.16852933947,
    119443.95521814766,
    119468.74319293935,
    119493.53245358112,
    119518.32299993958,
    119543.11483188139,
    119567.90794927324,
    119592.70235198183,
    119617.49803987393,
    119642.29501281632,
    119667.09327067583,
    119691.89281331931,
    119716.69364061367,
    119741.49575242582,
    119766.29914862274,
    119791.10382907141,
    119815.90979363887,
    119840.71704219218,
    119865.52557459843,
    119890.33539072477,
    119915.14649043836,
    119939.95887360642,
    119964.77254009615,
    119989.58748977486,
    120014.40372250983,
    120039.22123816841,
    120064.04003661797,
    120088.86011772591,
    120113.6814813597,
    120138.5041273868,
    120163.3280556747,
    120188.15326609099,
    120212.97975850321,
    120237.807532779,
    120262.63658878599,
    120287.46692639188,
    120312.29854546436,
    120337.13144587121,
    120361.9656274802,
    120386.80109015915,
    120411.63783377589,
    120436.47585819835,
    120461.31516329442,
    120486.15574893207,
    120510.99761497928,
    120535.84076130406,
    120560.68518777451,
    120585.53089425867,
    120610.3778806247,
    120635.22614674074,
    120660.07569247499,
    120684.92651769568,
    120709.77862227106,
    120734.63200606944,
    120759.48666895913,
    120784.3426108085,
    120809.19983148595,
    120834.05833085992,
    120858.91810879884,
    120883.77916517125,
    120908.64149984565,
    120933.5051126906,
    120958.37000357473,
    120983.23617236665,
    121008.10361893504,
    121032.97234314861,
    121057.84234487606,
    121082.71362398617,
    121107.58618034775,
    121132.46001382964,
    121157.33512430069,
    121182.21151162982,
    121207.08917568595,
    121231.96811633807,
    121256.84833345517,
    121281.72982690629,
    121306.61259656049,
    121331.49664228689,
    121356.38196395461,
    121381.26856143285,
    121406.15643459078,
    121431.04558329767,
    121455.93600742276,
    121480.82770683538,
    121505.72068140487,
    121530.61493100057,
    121555.51045549192,
    121580.40725474835,
    121605.30532863933,
    121630.20467703436,
    121655.10529980299,
    121680.00719681478,
    121704.91036793934,
    121729.81481304632,
    121754.72053200539,
    121779.62752468624,
    121804.53579095862,
    121829.44533069231,
    121854.3561437571,
    121879.26823002285,
    121904.1815893594,
    121929.09622163669,
    121954.01212672464,
    121978.92930449323,
    122003.84775481246,
    122028.76747755238,
    122053.68847258303,
    122078.61073977455,
    122103.53427899707,
    122128.45909012076,
    122153.38517301581,
    122178.31252755247,
    122203.24115360099,
    122228.17105103172,
    122253.10221971494,
    122278.03465952107,
    122302.96837032049,
    122327.90335198362,
    122352.83960438096,
    122377.777127383,
    122402.71592086025,
    122427.65598468333,
    122452.59731872278,
    122477.53992284928,
    122502.48379693348,
    122527.42894084606,
    122552.37535445779,
    122577.32303763942,
    122602.27199026172,
    122627.22221219557,
    122652.17370331181,
    122677.12646348133,
    122702.08049257506,
    122727.03579046397,
    122751.99235701906,
    122776.95019211136,
    122801.9092956119,
    122826.8696673918,
    122851.83130732219,
    122876.79421527422,
    122901.75839111909,
    122926.72383472799,
    122951.69054597223,
    122976.65852472307,
    123001.62777085182,
    123026.59828422987,
    123051.57006472857,
    123076.54311221937,
    123101.5174265737,
    123126.49300766307,
    123151.46985535898,
    123176.44796953299,
    123201.42735005668,
    123226.40799680166,
    123251.38990963959,
    123276.37308844214,
    123301.35753308103,
    123326.343243428,
    123351.33021935483,
    123376.31846073334,
    123401.30796743535,
    123426.29873933276,
    123451.29077629748,
    123476.28407820144,
    123501.2786449166,
    123526.27447631498,
    123551.27157226863,
    123576.26993264959,
    123601.26955732999,
    123626.27044618195,
    123651.27259907764,
    123676.27601588926,
    123701.28069648903,
    123726.28664074924,
    123751.29384854218,
    123776.30231974016,
    123801.31205421555,
    123826.32305184075,
    123851.33531248817,
    123876.34883603029,
    123901.36362233957,
    123926.37967128855,
    123951.39698274979,
    123976.41555659588,
    124001.43539269941,
    124026.45649093305,
    124051.47885116948,
    124076.50247328142,
    124101.5273571416,
    124126.55350262282,
    124151.58090959788,
    124176.60957793961,
    124201.63950752091,
    124226.67069821467,
    124251.70314989384,
    124276.73686243138,
    124301.7718357003,
    124326.80806957364,
    124351.84556392446,
    124376.88431862585,
    124401.92433355095,
    124426.96560857294,
    124452.00814356498,
    124477.05193840031,
    124502.0969929522,
    124527.14330709392,
    124552.19088069882,
    124577.23971364023,
    124602.28980579154,
    124627.34115702618,
    124652.3937672176,
    124677.44763623926,
    124702.50276396469,
    124727.55915026742,
    124752.61679502104,
    124777.67569809916,
    124802.73585937542,
    124827.79727872348,
    124852.85995601704,
    124877.92389112986,
    124902.98908393568,
    124928.05553430831,
    124953.1232421216,
    124978.19220724938,
    125003.26242956554,
    125028.33390894404,
    125053.40664525882,
    125078.48063838384,
    125103.55588819318,
    125128.63239456083,
    125153.71015736091,
    125178.78917646752,
    125203.86945175481,
    125228.95098309696,
    125254.03377036817,
    125279.1178134427,
    125304.20311219479,
    125329.28966649878,
    125354.37747622898,
    125379.46654125977,
    125404.55686146552,
    125429.6484367207,
    125454.74126689974,
    125479.83535187715,
    125504.93069152744,
    125530.02728572517,
    125555.12513434493,
    125580.22423726133,
    125605.32459434902,
    125630.4262054827,
    125655.52907053704,
    125680.63318938682,
    125705.73856190679,
    125730.84518797178,
    125755.9530674566,
    125781.06220023613,
    125806.17258618528,
    125831.28422517896,
    125856.39711709213,
    125881.51126179981,
    125906.62665917698,
    125931.74330909875,
    125956.86121144016,
    125981.98036607634,
    126007.10077288245,
    126032.22243173365,
    126057.34534250517,
    126082.46950507225,
    126107.59491931014,
    126132.72158509417,
    126157.84950229966,
    126182.97867080198,
    126208.10909047653,
    126233.24076119871,
    126258.37368284403,
    126283.50785528794,
    126308.64327840599,
    126333.77995207369,
    126358.91787616667,
    126384.0570505605,
    126409.19747513086,
    126434.3391497534,
    126459.48207430386,
    126484.62624865794,
    126509.77167269142,
    126534.9183462801,
    126560.06626929982,
    126585.21544162642,
    126610.36586313581,
    126635.51753370393,
    126660.67045320668,
    126685.82462152008,
    126710.98003852014,
    126736.13670408291,
    126761.29461808444,
    126786.45378040087,
    126811.61419090834,
    126836.77584948298,
    126861.93875600102,
    126887.10291033868,
    126912.26831237224,
    126937.43496197795,
    126962.60285903217,
    126987.77200341123,
    127012.94239499152,
    127038.11403364947,
    127063.2869192615,
    127088.46105170409,
    127113.63643085376,
    127138.81305658702,
    127163.99092878048,
    127189.17004731069,
    127214.35041205429,
    127239.53202288797,
    127264.71487968838,
    127289.89898233226,
    127315.08433069635,
    127340.27092465744,
    127365.45876409234,
    127390.64784887788,
    127415.83817889093,
    127441.02975400841,
    127466.22257410725,
    127491.41663906439,
    127516.61194875685,
    127541.80850306165,
    127567.00630185583,
    127592.20534501647,
    127617.4056324207,
    127642.60716394568,
    127667.80993946856,
    127693.01395886653,
    127718.21922201688,
    127743.42572879682,
    127768.63347908368,
    127793.84247275478,
    127819.05270968749,
    127844.26418975917,
    127869.47691284724,
    127894.69087882918,
    127919.90608758242,
    127945.12253898452,
    127970.34023291297,
    127995.55916924537,
    128020.77934785932,
    128046.00076863244,
    128071.22343144237,
    128096.44733616684,
    128121.67248268353,
    128146.89887087021,
    128172.12650060465,
    128197.35537176467,
    128222.5854842281,
    128247.81683787282,
    128273.04943257671,
    128298.28326821771,
    128323.51834467379,
    128348.75466182294,
    128373.99221954317,
    128399.23101771252,
    128424.47105620909,
    128449.71233491098,
    128474.95485369631,
    128500.19861244329,
    128525.44361103009,
    128550.68984933494,
    128575.93732723613,
    128601.18604461191,
    128626.43600134061,
    128651.68719730059,
    128676.93963237021,
    128702.1933064279,
    128727.44821935208,
    128752.70437102125,
    128777.96176131385,
    128803.22039010846,
    128828.48025728362,
    128853.74136271792,
    128879.00370628996,
    128904.26728787841,
    128929.53210736193,
    128954.79816461923,
    128980.06545952905,
    129005.33399197015,
    129030.60376182134,
    129055.87476896142,
    129081.14701326926,
    129106.42049462376,
    129131.6952129038,
    129156.97116798835,
    129182.24835975636,
    129207.52678808685,
    129232.80645285884,
    129258.08735395141,
    129283.36949124365,
    129308.65286461466,
    129333.9374739436,
    129359.22331910966,
    129384.51039999202,
    129409.79871646997,
    129435.08826842274,
    129460.37905572963,
    129485.67107826998,
    129510.96433592314,
    129536.25882856851,
    129561.55455608548,
    129586.85151835352,
    129612.14971525209,
    129637.4491466607,
    129662.74981245887,
    129688.0517125262,
    129713.35484674224,
    129738.65921498663,
    129763.96481713903,
    129789.27165307909,
    129814.57972268655,
    129839.88902584116,
    129865.19956242264,
    129890.51133231082,
    129915.82433538554,
    129941.13857152662,
    129966.45404061397,
    129991.7707425275,
    130017.08867714716,
    130042.4078443529,
    130067.72824402474,
    130093.04987604271,
    130118.37274028687,
    130143.69683663732,
    130169.02216497416,
    130194.34872517755,
    130219.67651712766,
    130245.0055407047,
    130270.33579578891,
    130295.66728226055,
    130320.99999999991,
    130346.33394888733,
    130371.66912880314,
    130397.00553962773,
    130422.34318124152,
    130447.68205352494,
    130473.02215635845,
    130498.36348962256,
    130523.70605319779,
    130549.0498469647,
    130574.39487080388,
    130599.74112459592,
    130625.08860822149,
    130650.43732156123,
    130675.78726449587,
    130701.13843690613,
    130726.49083867275,
    130751.84446967654,
    130777.19932979831,
    130802.5554189189,
    130827.91273691918,
    130853.27128368006,
    130878.63105908247,
    130903.99206300738,
    130929.35429533575,
    130954.71775594862,
    130980.08244472703,
    131005.44836155206,
    131030.81550630482,
    131056.18387886642,
    131081.55347911804,
    131106.92430694087,
    131132.29636221612,
    131157.66964482504,
    131183.0441546489,
    131208.41989156904,
    131233.79685546676,
    131259.17504622342,
    131284.55446372041,
    131309.93510783918,
    131335.31697846117,
    131360.70007546784,
    131386.0843987407,
    131411.46994816128,
    131436.85672361116,
    131462.24472497194,
    131487.63395212521,
    131513.02440495262,
    131538.41608333588,
    131563.80898715663,
    131589.2031162967,
    131614.59847063778,
    131639.9950500617,
    131665.39285445024,
    131690.79188368531,
    131716.19213764873,
    131741.59361622241,
    131766.99631928833,
    131792.40024672839,
    131817.80539842462,
    131843.21177425905,
    131868.61937411371,
    131894.02819787065,
    131919.43824541202,
    131944.84951661993,
    131970.26201137656,
    131995.67572956407,
    132021.09067106468,
    132046.50683576067,
    132071.9242235343,
    132097.34283426782,
    132122.76266784366,
    132148.1837241441,
    132173.60600305157,
    132199.02950444847,
    132224.45422821722,
    132249.88017424036,
    132275.30734240031,
    132300.73573257966,
    132326.16534466096,
    132351.59617852676,
    132377.02823405969,
    132402.46151114244,
    132427.89600965759,
    132453.33172948789,
    132478.76867051609,
    132504.20683262491,
    132529.64621569714,
    132555.08681961559,
    132580.5286442631,
    132605.97168952253,
    132631.41595527678,
    132656.86144140881,
    132682.30814780149,
    132707.75607433787,
    132733.20522090094,
    132758.65558737374,
    132784.10717363929,
    132809.55997958075,
    132835.01400508118,
    132860.46925002377,
    132885.92571429166,
    132911.38339776811,
    132936.84230033628,
    132962.30242187946,
    132987.76376228096,
    133013.22632142407,
    133038.69009919214,
    133064.15509546854,
    133089.62131013666,
    133115.08874307995,
    133140.55739418184,
    133166.02726332581,
    133191.49835039541,
    133216.97065527414,
    133242.44417784561,
    133267.91891799335,
    133293.39487560102,
    133318.87205055228,
    133344.35044273079,
    133369.83005202023,
    133395.31087830439,
    133420.79292146701,
    133446.27618139185,
    133471.76065796276,
    133497.24635106357,
    133522.73326057816,
    133548.22138639039,
    133573.71072838426,
    133599.20128644365,
    133624.69306045261,
    133650.1860502951,
    133675.68025585517,
    133701.1756770169,
    133726.67231366437,
    133752.17016568172,
    133777.66923295305,
    133803.16951536259,
    133828.67101279454,
    133854.17372513309,
    133879.67765226253,
    133905.18279406714,
    133930.68915043125,
    133956.19672123916,
    133981.70550637526,
    134007.21550572399,
    134032.7267191697,
    134058.23914659687,
    134083.75278789,
    134109.26764293358,
    134134.78371161217,
    134160.30099381026,
    134185.8194894125,
    134211.33919830353,
    134236.8601203679,
    134262.38225549037,
    134287.90560355558,
    134313.43016444831,
    134338.95593805326,
    134364.48292425525,
    134390.01112293909,
    134415.54053398955,
    134441.07115729159,
    134466.60299273001,
    134492.1360401898,
    134517.67029955584,
    134543.20577071316,
    134568.74245354676,
    134594.28034794159,
    134619.81945378278,
    134645.35977095537,
    134670.90129934452,
    134696.4440388353,
    134721.98798931291,
    134747.53315066252,
    134773.07952276937,
    134798.62710551871,
    134824.17589879577,
    134849.72590248589,
    134875.27711647438,
    134900.82954064661,
    134926.38317488792,
    134951.93801908373,
    134977.49407311951,
    135003.05133688069,
    135028.60981025276,
    135054.16949312127,
    135079.73038537172,
    135105.29248688967,
    135130.85579756077,
    135156.42031727062,
    135181.98604590484,
    135207.55298334916,
    135233.12112948924,
    135258.69048421088,
    135284.26104739975,
    135309.83281894168,
    135335.4057987225,
    135360.97998662802,
    135386.55538254412,
    135412.13198635669,
    135437.70979795168,
    135463.28881721498,
    135488.86904403262,
    135514.45047829056,
    135540.03311987486,
    135565.61696867159,
    135591.20202456677,
    135616.78828744654,
    135642.37575719706,
    135667.96443370447,
    135693.55431685498,
    135719.14540653475,
    135744.73770263011,
    135770.33120502727,
    135795.92591361253,
    135821.52182827223,
    135847.11894889272,
    135872.7172753604,
    135898.31680756161,
    135923.91754538284,
    135949.51948871053,
    135975.12263743114,
    136000.72699143123,
    136026.33255059729,
    136051.93931481591,
    136077.54728397369,
    136103.15645795723,
    136128.76683665317,
    136154.37841994822,
    136179.99120772901,
    136205.60519988232,
    136231.2203962949,
    136256.83679685349,
    136282.45440144493,
    136308.07320995603,
    136333.69322227367,
    136359.31443828469,
    136384.93685787608,
    136410.56048093468,
    136436.18530734754,
    136461.81133700156,
    136487.43856978384,
    136513.06700558143,
    136538.6966442813,
    136564.32748577066,
    136589.95952993655,
    136615.59277666616,
    136641.22722584667,
    136666.86287736523,
    136692.49973110916,
    136718.13778696564,
    136743.77704482197,
    136769.41750456547,
    136795.05916608346,
    136820.70202926331,
    136846.34609399244,
    136871.99136015819,
    136897.63782764805,
    136923.28549634948,
    136948.93436614997,
    136974.58443693706,
    137000.23570859825,
    137025.88818102115,
    137051.54185409332,
    137077.19672770242,
    137102.85280173609,
    137128.51007608202,
    137154.16855062786,
    137179.82822526142,
    137205.48909987041,
    137231.15117434258,
    137256.8144485658,
    137282.47892242789,
    137308.14459581667,
    137333.81146862009,
    137359.47954072602,
    137385.14881202241,
    137410.81928239719,
    137436.49095173844,
    137462.16381993407,
    137487.83788687221,
    137513.51315244089,
    137539.18961652822,
    137564.86727902229,
    137590.54613981131,
    137616.22619878338,
    137641.90745582676,
    137667.58991082967,
    137693.27356368033,
    137718.95841426702,
    137744.64446247809,
    137770.33170820182,
    137796.02015132661,
    137821.70979174081,
    137847.40062933284,
    137873.09266399115,
    137898.78589560417,
    137924.48032406042,
    137950.17594924837,
    137975.8727710566,
    138001.57078937365,
    138027.27000408815,
    138052.97041508864,
    138078.67202226384,
    138104.3748255024,
    138130.07882469296,
    138155.78401972432,
    138181.49041048516,
    138207.1979968643,
    138232.9067787505,
    138258.61675603263,
    138284.32792859949,
    138310.04029633995,
    138335.75385914298,
    138361.46861689744,
    138387.18456949232,
    138412.90171681659,
    138438.62005875923,
    138464.33959520931,
    138490.06032605586,
    138515.78225118798,
    138541.50537049473,
    138567.2296838653,
    138592.95519118884,
    138618.68189235451,
    138644.40978725153,
    138670.13887576913,
    138695.86915779658,
    138721.60063322316,
    138747.33330193823,
    138773.06716383106,
    138798.80221879104,
    138824.53846670757,
    138850.27590747006,
    138876.01454096794,
    138901.7543670907,
    138927.49538572782,
    138953.2375967688,
    138978.9810001032,
    139004.72559562061,
    139030.47138321059,
    139056.2183627628,
    139081.96653416683,
    139107.71589731239,
    139133.46645208917,
    139159.21819838689,
    139184.97113609532,
    139210.72526510421,
    139236.48058530336,
    139262.23709658257,
    139287.99479883176,
    139313.75369194071,
    139339.51377579942,
    139365.27505029776,
    139391.03751532568,
    139416.80117077316,
    139442.56601653024,
    139468.33205248689,
    139494.09927853322,
    139519.86769455927,
    139545.63730045516,
    139571.408096111,
    139597.18008141697,
    139622.95325626322,
    139648.72762054001,
    139674.5031741375,
    139700.27991694602,
    139726.05784885579,
    139751.83696975713,
    139777.61727954043,
    139803.39877809596,
    139829.18146531415,
    139854.96534108539,
    139880.75040530015,
    139906.53665784886,
    139932.32409862199,
    139958.11272751007,
    139983.90254440365,
    140009.69354919327,
    140035.48574176949,
    140061.27912202294,
    140087.07368984428,
    140112.86944512415,
    140138.66638775321,
    140164.4645176222,
    140190.26383462184,
    140216.06433864293,
    140241.86602957622,
    140267.66890731253,
    140293.47297174268,
    140319.27822275754,
    140345.08466024802,
    140370.89228410498,
    140396.70109421943,
    140422.51109048226,
    140448.32227278448,
    140474.13464101712,
    140499.94819507122,
    140525.76293483781,
    140551.57886020801,
    140577.3959710729,
    140603.21426732364,
    140629.03374885136,
    140654.85441554731,
    140680.67626730262,
    140706.49930400858,
    140732.32352555645,
    140758.1489318375,
    140783.97552274304,
    140809.80329816442,
    140835.63225799298,
    140861.46240212015,
    140887.29373043729,
    140913.12624283586,
    140938.95993920733,
    140964.79481944317,
    140990.63088343487,
    141016.46813107401,
    141042.30656225214,
    141068.14617686081,
    141093.98697479168,
    141119.82895593636,
    141145.6721201865,
    141171.51646743377,
    141197.36199756994,
    141223.20871048668,
    141249.05660607578,
    141274.90568422904,
    141300.75594483822,
    141326.6073877952,
    141352.4600129918,
    141378.31382031992,
    141404.16880967148,
    141430.02498093838,
    141455.8823340126,
    141481.74086878612,
    141507.60058515094,
    141533.46148299909,
    141559.32356222265,
    141585.18682271364,
    141611.05126436421,
    141636.9168870665,
    141662.78369071262,
    141688.65167519479,
    141714.5208404052,
    141740.39118623605,
    141766.26271257963,
    141792.1354193282,
    141818.00930637406,
    141843.88437360956,
    141869.760620927,
    141895.6380482188,
    141921.51665537735,
    141947.39644229505,
    141973.27740886438,
    141999.15955497778,
    142025.04288052776,
    142050.92738540689,
    142076.81306950765,
    142102.69993272264,
    142128.58797494444,
    142154.47719606571,
    142180.36759597904,
    142206.25917457714,
    142232.15193175265,
    142258.04586739838,
    142283.94098140698,
    142309.83727367126,
    142335.73474408401,
    142361.63339253806,
    142387.5332189262,
    142413.43422314132,
    142439.33640507635,
    142465.23976462413,
    142491.14430167765,
    142517.05001612983,
    142542.95690787368,
    142568.86497680223,
    142594.77422280848,
    142620.68464578551,
    142646.5962456264,
    142672.50902222423,
    142698.42297547215,
    142724.33810526333,
    142750.25441149093,
    142776.17189404817,
    142802.09055282827,
    142828.01038772447,
    142853.93139863008,
    142879.85358543837,
    142905.77694804268,
    142931.70148633636,
    142957.62720021277,
    142983.55408956532,
    143009.48215428743,
    143035.41139427255,
    143061.34180941415,
    143087.27339960571,
    143113.20616474075,
    143139.14010471283,
    143165.07521941551,
    143191.01150874238,
    143216.94897258704,
    143242.88761084314,
    143268.82742340435,
    143294.76841016437,
    143320.71057101688,
    143346.65390585564,
    143372.59841457437,
    143398.54409706692,
    143424.49095322701,
    143450.43898294857,
    143476.38818612538,
    143502.33856265133,
    143528.29011242036,
    143554.24283532638,
    143580.19673126334,
    143606.1518001252,
    143632.10804180597,
    143658.06545619969,
    143684.02404320039,
    143709.98380270213,
    143735.944734599,
    143761.90683878519,
    143787.87011515474,
    143813.83456360188,
    143839.8001840208,
    143865.76697630569,
    143891.73494035081,
    143917.7040760504,
    143943.67438329876,
    143969.6458619902,
    143995.61851201905,
    144021.59233327967,
    144047.56732566646,
    144073.54348907378,
    144099.52082339607,
    144125.49932852783,
    144151.4790043635,
    144177.45985079758,
    144203.44186772458,
    144229.42505503909,
    144255.40941263564,
    144281.39494040885,
    144307.38163825331,
    144333.36950606373,
    144359.35854373468,
    144385.34875116093,
    144411.34012823718,
    144437.33267485813,
    144463.32639091855,
    144489.32127631325,
    144515.31733093705,
    144541.31455468474,
    144567.3129474512,
    144593.3125091313,
    144619.31323961995,
    144645.31513881206,
    144671.31820660262,
    144697.32244288657,
    144723.32784755889,
    144749.33442051467,
    144775.34216164888,
    144801.35107085665,
    144827.36114803303,
    144853.37239307314,
    144879.38480587213,
    144905.39838632516,
    144931.41313432742,
    144957.4290497741,
    144983.44613256046,
    145009.46438258173,
    145035.48379973322,
    145061.50438391021,
    145087.52613500805,
    145113.54905292206,
    145139.57313754765,
    145165.59838878017,
    145191.62480651509,
    145217.65239064783,
    145243.68114107384,
    145269.71105768863,
    145295.74214038774,
    145321.77438906668,
    145347.80780362099,
    145373.84238394629,
    145399.87812993818,
    145425.91504149229,
    145451.95311850426,
    145477.9923608698,
    145504.03276848458,
    145530.07434124436,
    145556.11707904484,
    145582.16098178181,
    145608.20604935108,
    145634.25228164849,
    145660.29967856981,
    145686.34824001096,
    145712.39796586783,
    145738.4488560363,
    145764.50091041232,
    145790.55412889185,
    145816.60851137087,
    145842.66405774537,
    145868.72076791141,
    145894.77864176501,
    145920.83767920226,
    145946.89788011924,
    145972.95924441208,
    145999.02177197693,
    146025.08546270995,
    146051.15031650732,
    146077.21633326527,
    146103.28351288004,
    146129.35185524789,
    146155.42136026506,
    146181.49202782792,
    146207.56385783272,
    146233.63685017588,
    146259.71100475377,
    146285.78632146274,
    146311.86280019928,
    146337.94044085976,
    146364.01924334071,
    146390.09920753856,
    146416.18033334985,
    146442.26262067116,
    146468.34606939898,
    146494.43067942993,
    146520.51645066062,
    146546.60338298764,
    146572.69147630769,
    146598.78073051744,
    146624.87114551352,
    146650.96272119274,
    146677.05545745179,
    146703.14935418745,
    146729.2444112965,
    146755.34062867577,
    146781.43800622207,
    146807.53654383228,
    146833.63624140329,
    146859.73709883197,
    146885.83911601527,
    146911.94229285014,
    146938.04662923355,
    146964.15212506248,
    146990.25878023397,
    147016.36659464505,
    147042.47556819281,
    147068.58570077427,
    147094.6969922866,
    147120.80944262692,
    147146.92305169237,
    147173.03781938017,
    147199.15374558745,
    147225.27083021149,
    147251.38907314953,
    147277.50847429881,
    147303.62903355664,
    147329.75075082036,
    147355.87362598727,
    147381.99765895473,
    147408.12284962015,
    147434.24919788091,
    147460.37670363448,
    147486.50536677826,
    147512.63518720976,
    147538.76616482646,
    147564.89829952587,
    147591.03159120557,
    147617.16603976308,
    147643.30164509601,
    147669.43840710199,
    147695.57632567859,
    147721.71540072354,
    147747.85563213445,
    147773.99701980909,
    147800.13956364512,
    147826.28326354033,
    147852.42811939248,
    147878.57413109933,
    147904.72129855872,
    147930.86962166851,
    147957.01910032652,
    147983.16973443062,
    148009.32152387875,
    148035.47446856883,
    148061.62856839882,
    148087.78382326665,
    148113.94023307035,
    148140.09779770792,
    148166.25651707739,
    148192.41639107687,
    148218.57741960438,
    148244.73960255808,
    148270.90293983606,
    148297.0674313365,
    148323.23307695755,
    148349.39987659742,
    148375.56783015432,
    148401.73693752653,
    148427.90719861226,
    148454.07861330983,
    148480.25118151752,
    148506.42490313368,
    148532.59977805667,
    148558.77580618486,
    148584.95298741665,
    148611.13132165043,
    148637.31080878471,
    148663.49144871789,
    148689.6732413485,
    148715.85618657502,
    148742.040284296,
    148768.22553440998,
    148794.41193681557,
    148820.59949141133,
    148846.78819809589,
    148872.97805676793,
    148899.16906732606,
    148925.36122966901,
    148951.55454369547,
    148977.74900930419,
    149003.9446263939,
    149030.1413948634,
    149056.33931461151,
    149082.53838553699,
    149108.73860753875,
    149134.9399805156,
    149161.14250436646,
    149187.34617899026,
    149213.5510042859,
    149239.75698015234,
    149265.96410648854,
    149292.17238319354,
    149318.38181016635,
    149344.59238730598,
    149370.80411451156,
    149397.01699168212,
    149423.23101871679,
    149449.44619551473,
    149475.66252197503,
    149501.87999799693,
    149528.0986234796,
    149554.31839832227,
    149580.53932242419,
    149606.76139568459,
    149632.98461800278,
    149659.20898927809,
    149685.43450940982,
    149711.66117829733,
    149737.88899584001,
    149764.11796193724,
    149790.34807648844,
    149816.57933939309,
    149842.81175055061,
    149869.04530986046,
    149895.28001722222,
    149921.51587253538,
    149947.75287569952,
    149973.99102661415,
    150000.23032517891,
    150026.47077129342,
    150052.71236485732,
    150078.95510577026,
    150105.1989939319,
    150131.444029242,
    150157.69021160025,
    150183.93754090639,
    150210.18601706024,
    150236.43563996154,
    150262.68640951012,
    150288.93832560582,
    150315.19138814852,
    150341.44559703805,
    150367.70095217437,
    150393.95745345735,
    150420.21510078697,
    150446.47389406321,
    150472.73383318601,
    150498.99491805542,
    150525.25714857146,
    150551.52052463419,
    150577.78504614369,
    150604.05071300003,
    150630.31752510337,
    150656.58548235384,
    150682.85458465159,
    150709.1248318968,
    150735.39622398972,
    150761.66876083051,
    150787.9424423195,
    150814.21726835691,
    150840.49323884305,
    150866.77035367821,
    150893.04861276277,
    150919.32801599705,
    150945.60856328148,
    150971.89025451642,
    150998.17308960229,
    151024.45706843957,
    151050.74219092872,
    151077.02845697021,
    151103.31586646455,
    151129.60441931229,
    151155.894115414,
    151182.1849546702,
    151208.47693698155,
    151234.77006224863,
    151261.06433037209,
    151287.35974125259,
    151313.65629479082,
    151339.95399088747,
    151366.25282944329,
    151392.55281035902,
    151418.85393353543,
    151445.1561988733,
    151471.45960627345,
    151497.76415563675,
    151524.06984686397,
    151550.37667985607,
    151576.68465451393,
    151602.99377073845,
    151629.30402843058,
    151655.61542749128,
    151681.92796782157,
    151708.24164932242,
    151734.55647189484,
    151760.87243543993,
    151787.18953985872,
    151813.50778505235,
    151839.82717092187,
    151866.14769736846,
    151892.46936429327,
    151918.79217159748,
    151945.11611918229,
    151971.44120694889,
    151997.76743479856,
    152024.09480263255,
    152050.42331035214,
    152076.75295785864,
    152103.08374505339,
    152129.41567183775,
    152155.74873811303,
    152182.08294378067,
    152208.41828874208,
    152234.75477289871,
    152261.09239615197,
    152287.43115840337,
    152313.77105955439,
    152340.11209950657,
    152366.45427816146,
    152392.79759542056,
    152419.14205118554,
    152445.48764535793,
    152471.8343778394,
    152498.18224853161,
    152524.53125733617,
    152550.88140415482,
    152577.23268888926,
    152603.58511144121,
    152629.93867171241,
    152656.29336960468,
    152682.64920501978,
    152709.00617785956,
    152735.36428802583,
    152761.72353542043,
    152788.08391994529,
    152814.44544150229,
    152840.80809999333,
    152867.17189532038,
    152893.53682738543,
    152919.90289609041,
    152946.27010133737,
    152972.63844302832,
    152999.00792106529,
    153025.37853535041,
    153051.7502857857,
    153078.12317227334,
    153104.4971947154,
    153130.8723530141,
    153157.24864707157,
    153183.62607679001,
    153210.00464207167,
    153236.38434281875,
    153262.76517893354,
    153289.14715031831,
    153315.53025687535,
    153341.91449850702,
    153368.2998751156,
    153394.68638660354,
    153421.07403287315,
    153447.46281382689,
    153473.85272936718,
    153500.24377939643,
    153526.63596381716,
    153553.02928253182,
    153579.42373544298,
    153605.81932245308,
    153632.21604346478,
    153658.61389838057,
    153685.0128871031,
    153711.41300953497,
    153737.81426557881,
    153764.21665513728,
    153790.62017811305,
    153817.02483440886,
    153843.43062392739,
    153869.83754657139,
    153896.24560224367,
    153922.65479084692,
    153949.06511228404,
    153975.4765664578,
    154001.88915327107,
    154028.30287262669,
    154054.71772442761,
    154081.13370857667,
    154107.55082497682,
    154133.96907353101,
    154160.38845414223,
    154186.80896671346,
    154213.23061114774,
    154239.65338734805,
    154266.07729521746,
    154292.50233465908,
    154318.92850557598,
    154345.35580787127,
    154371.7842414481,
    154398.21380620965,
    154424.64450205903,
    154451.07632889951,
    154477.50928663427,
    154503.94337516659,
    154530.37859439969,
    154556.81494423689,
    154583.25242458144,
    154609.69103533673,
    154636.13077640603,
    154662.57164769279,
    154689.01364910032,
    154715.45678053208,
    154741.90104189145,
    154768.34643308193,
    154794.79295400696,
    154821.24060457002,
    154847.68938467462,
    154874.13929422433,
    154900.59033312264,
    154927.04250127316,
    154953.49579857948,
    154979.95022494521,
    155006.40578027396,
    155032.86246446942,
    155059.32027743524,
    155085.77921907514,
    155112.2392892928,
    155138.70048799197,
    155165.16281507642,
    155191.62627044989,
    155218.09085401625,
    155244.55656567923,
    155271.02340534274,
    155297.49137291059,
    155323.96046828668,
    155350.4306913749,
    155376.90204207919,
    155403.37452030348,
    155429.84812595171,
    155456.32285892789,
    155482.79871913602,
    155509.27570648011,
    155535.75382086422,
    155562.23306219239,
    155588.71343036872,
    155615.19492529731,
    155641.67754688227,
    155668.16129502779,
    155694.64616963797,
    155721.13217061706,
    155747.61929786921,
    155774.10755129869,
    155800.59693080973,
    155827.08743630661,
    155853.57906769359,
    155880.07182487496,
    155906.56570775513,
    155933.06071623837,
    155959.55685022907,
    155986.05410963166,
    156012.5524943505,
    156039.05200429002,
    156065.55263935472,
    156092.054399449,
    156118.5572844774,
    156145.06129434443,
    156171.5664289546,
    156198.07268821247,
    156224.5800720226,
    156251.08858028959,
    156277.59821291809,
    156304.10896981266,
    156330.62085087801,
    156357.1338560188,
    156383.64798513969,
    156410.16323814544,
    156436.67961494075,
    156463.1971154304,
    156489.71573951913,
    156516.23548711176,
    156542.75635811311,
    156569.27835242799,
    156595.80146996127,
    156622.32571061782,
    156648.85107430254,
    156675.37756092031,
    156701.90517037612,
    156728.43390257491,
    156754.96375742162,
    156781.49473482129,
    156808.02683467892,
    156834.5600568995,
    156861.09440138817,
    156887.62986804993,
    156914.16645678994,
    156940.70416751326,
    156967.24300012505,
    156993.78295453047,
    157020.32403063469,
    157046.8662283429,
    157073.40954756032,
    157099.9539881922,
    157126.49955014378,
    157153.04623332032,
    157179.59403762716,
    157206.14296296958,
    157232.69300925292,
    157259.24417638258,
    157285.79646426387,
    157312.34987280221,
    157338.90440190304,
    157365.46005147175,
    157392.01682141385,
    157418.57471163478,
    157445.13372204005,
    157471.69385253513,
    157498.25510302564,
    157524.81747341706,
    157551.38096361503,
    157577.9455735251,
    157604.51130305286,
    157631.07815210402,
    157657.64612058419,
    157684.21520839902,
    157710.78541545427,
    157737.35674165559,
    157763.92918690876,
    157790.50275111952,
    157817.07743419363,
    157843.65323603692,
    157870.23015655516,
    157896.80819565422,
    157923.3873532399,
    157949.96762921812,
    157976.54902349479,
    158003.13153597576,
    158029.71516656701,
    158056.29991517449,
    158082.88578170416,
    158109.47276606198,
    158136.06086815402,
    158162.65008788629,
    158189.24042516484,
    158215.83187989573,
    158242.42445198505,
    158269.01814133892,
    158295.61294786347,
    158322.20887146486,
    158348.80591204923,
    158375.4040695228,
    158402.00334379176,
    158428.60373476235,
    158455.2052423408,
    158481.80786643337,
    158508.41160694641,
    158535.01646378616,
    158561.62243685898,
    158588.2295260712,
    158614.8377313292,
    158641.44705253936,
    158668.05748960807,
    158694.66904244179,
    158721.28171094693,
    158747.89549502998,
    158774.5103945974,
    158801.12640955573,
    158827.74353981143,
    158854.36178527112,
    158880.9811458413,
    158907.60162142856,
    158934.22321193956,
    158960.84591728085,
    158987.46973735912,
    159014.09467208097,
    159040.72072135314,
    159067.3478850823,
    159093.97616317519,
    159120.60555553852,
    159147.23606207906,
    159173.8676827036,
    159200.50041731889,
    159227.13426583182,
    159253.76922814918,
    159280.40530417781,
    159307.04249382461,
    159333.68079699649,
    159360.32021360032,
    159386.96074354305,
    159413.60238673165,
    159440.24514307309,
    159466.88901247433,
    159493.53399484244,
    159520.18009008438,
    159546.82729810724,
    159573.47561881805,
    159600.12505212394,
    159626.77559793202,
    159653.42725614941,
    159680.08002668325,
    159706.73390944069,
    159733.38890432892,
    159760.04501125516,
    159786.70223012666,
    159813.36056085059,
    159840.02000333427,
    159866.68055748497,
    159893.34222320997,
    159920.00500041663,
    159946.66888901225,
    159973.33388890422,
    159999.99999999988,
    160026.66722220668,
    160053.33555543202,
    160080.0049995833,
    160106.67555456801,
    160133.3472202936,
    160160.0199966676,
    160186.6938835975,
    160213.36888099083,
    160240.04498875517,
    160266.72220679806,
    160293.40053502709,
    160320.07997334987,
    160346.76052167406,
    160373.44217990729,
    160400.1249479572,
    160426.80882573154,
    160453.49381313793,
    160480.17991008417,
    160506.86711647795,
    160533.55543222709,
    160560.24485723933,
    160586.93539142248,
    160613.62703468435,
    160640.31978693281,
    160667.01364807569,
    160693.70861802087,
    160720.40469667627,
    160747.1018839498,
    160773.80017974938,
    160800.49958398298,
    160827.20009655855,
    160853.90171738411,
    160880.60444636765,
    160907.30828341722,
    160934.01322844089,
    160960.71928134665,
    160987.42644204266,
    161014.13471043704,
    161040.84408643784,
    161067.55456995327,
    161094.26616089148,
    161120.97885916062,
    161147.69266466892,
    161174.40757732463,
    161201.12359703594,
    161227.84072371112,
    161254.55895725847,
    161281.27829758628,
    161307.99874460287,
    161334.72029821656,
    161361.44295833571,
    161388.1667248687,
    161414.89159772391,
    161441.61757680977,
    161468.34466203468,
    161495.07285330712,
    161521.80215053557,
    161548.53255362847,
    161575.26406249436,
    161601.99667704175,
    161628.7303971792,
    161655.46522281526,
    161682.20115385848,
    161708.93819021754,
    161735.67633180099,
    161762.41557851751,
    161789.15593027571,
    161815.89738698432,
    161842.63994855201,
    161869.38361488748,
    161896.1283858995,
    161922.87426149679,
    161949.62124158812,
    161976.36932608229,
    162003.1185148881,
    162029.8688079144,
    162056.62020507001,
    162083.37270626382,
    162110.12631140469,
    162136.88102040152,
    162163.63683316324,
    162190.39374959879,
    162217.15176961714,
    162243.91089312723,
    162270.67112003808,
    162297.43245025873,
    162324.19488369819,
    162350.9584202655,
    162377.72305986975,
    162404.48880242003,
    162431.25564782543,
    162458.02359599507,
    162484.79264683815,
    162511.56280026378,
    162538.33405618116,
    162565.10641449949,
    162591.87987512801,
    162618.65443797593,
    162645.43010295252,
    162672.20686996708,
    162698.98473892888,
    162725.76370974723,
    162752.54378233149,
    162779.32495659095,
    162806.10723243505,
    162832.89060977317,
    162859.67508851466,
    162886.46066856899,
    162913.24734984562,
    162940.03513225398,
    162966.82401570358,
    162993.6140001039,
    163020.40508536444,
    163047.19727139481,
    163073.99055810447,
    163100.78494540305,
    163127.58043320014,
    163154.37702140535,
    163181.17470992831,
    163207.97349867865,
    163234.77338756606,
    163261.57437650024,
    163288.37646539087,
    163315.17965414765,
    163341.98394268038,
    163368.78933089875,
    163395.59581871261,
    163422.40340603172,
    163449.2120927659,
    163476.02187882498,
    163502.83276411882,
    163529.6447485573,
    163556.45783205028,
    163583.2720145077,
    163610.08729583945,
    163636.90367595552,
    163663.72115476584,
    163690.53973218042,
    163717.35940810922,
    163744.18018246227,
    163771.00205514964,
    163797.82502608138,
    163824.64909516752,
    163851.4742623182,
    163878.3005274435,
    163905.12789045356,
    163931.95635125853,
    163958.78590976857,
    163985.61656589387,
    164012.44831954464,
    164039.28117063109,
    164066.11511906344,
    164092.95016475199,
    164119.78630760699,
    164146.62354753874,
    164173.46188445756,
    164200.30131827376,
    164227.14184889771,
    164253.98347623978,
    164280.82620021031,
    164307.67002071979,
    164334.51493767856,
    164361.3609509971,
    164388.20806058586,
    164415.05626635533,
    164441.905568216,
    164468.75596607837,
    164495.607459853,
    164522.4600494504,
    164549.31373478117,
    164576.16851575591,
    164603.02439228518,
    164629.88136427966,
    164656.73943164994,
    164683.59859430668,
    164710.45885216061,
    164737.32020512238,
    164764.1826531027,
    164791.04619601235,
    164817.91083376206,
    164844.77656626256,
    164871.64339342469,
    164898.51131515924,
    164925.38033137703,
    164952.25044198887,
    164979.1216469057,
    165005.9939460383,
    165032.86733929763,
    165059.7418265946,
    165086.61740784015,
    165113.4940829452
};

#else

#ifdef BIG_IQ_TABLE
#define IQ_TABLE_SIZE  8192
#else
#define IQ_TABLE_SIZE  1026
#endif

ALIGN static const real_t iq_table[IQ_TABLE_SIZE] =
{
    REAL_CONST(0.0),
    REAL_CONST(1.0/8.0),
    REAL_CONST(2.5198420997897464/8.0),
    REAL_CONST(4.3267487109222245/8.0),
    REAL_CONST(6.3496042078727974/8.0),
    REAL_CONST(8.5498797333834844/8.0),
    REAL_CONST(10.902723556992836/8.0),
    REAL_CONST(13.390518279406722/8.0),
    REAL_CONST(15.999999999999998/8.0),
    REAL_CONST(18.720754407467133/8.0),
    REAL_CONST(21.544346900318832/8.0),
    REAL_CONST(24.463780996262464/8.0),
    REAL_CONST(27.47314182127996/8.0),
    REAL_CONST(30.567350940369842/8.0),
    REAL_CONST(33.741991698453212/8.0),
    REAL_CONST(36.993181114957046/8.0),
    REAL_CONST(40.317473596635935/8.0),
    REAL_CONST(43.711787041189993/8.0),
    REAL_CONST(47.173345095760126/8.0),
    REAL_CONST(50.699631325716943/8.0),
    REAL_CONST(54.288352331898118/8.0),
    REAL_CONST(57.937407704003519/8.0),
    REAL_CONST(61.6448652744185/8.0),
    REAL_CONST(65.408940536585988/8.0),
    REAL_CONST(69.227979374755591/8.0),
    REAL_CONST(73.100443455321638/8.0),
    REAL_CONST(77.024897778591622/8.0),
    REAL_CONST(80.999999999999986/8.0),
    REAL_CONST(85.024491212518527/8.0),
    REAL_CONST(89.097187944889555/8.0),
    REAL_CONST(93.216975178615741/8.0),
    REAL_CONST(97.382800224133163/8.0),
    REAL_CONST(101.59366732596474/8.0),
    REAL_CONST(105.84863288986224/8.0),
    REAL_CONST(110.14680124343441/8.0),
    REAL_CONST(114.4873208566006/8.0),
    REAL_CONST(118.86938096020653/8.0),
    REAL_CONST(123.29220851090024/8.0),
    REAL_CONST(127.75506545836058/8.0),
    REAL_CONST(132.25724627755247/8.0),
    REAL_CONST(136.79807573413572/8.0),
    REAL_CONST(141.37690685569191/8.0),
    REAL_CONST(145.99311908523086/8.0),
    REAL_CONST(150.6461165966291/8.0),
    REAL_CONST(155.33532675434674/8.0),
    REAL_CONST(160.06019870205279/8.0),
    REAL_CONST(164.82020206673349/8.0),
    REAL_CONST(169.61482576651861/8.0),
    REAL_CONST(174.44357691188537/8.0),
    REAL_CONST(179.30597979112557/8.0),
    REAL_CONST(184.20157493201927/8.0),
    REAL_CONST(189.12991823257562/8.0),
    REAL_CONST(194.09058015449685/8.0),
    REAL_CONST(199.08314497371677/8.0),
    REAL_CONST(204.1072100829694/8.0),
    REAL_CONST(209.16238534187647/8.0),
    REAL_CONST(214.24829247050752/8.0),
    REAL_CONST(219.36456448277784/8.0),
    REAL_CONST(224.51084515641216/8.0),
    REAL_CONST(229.6867885365223/8.0),
    REAL_CONST(234.89205847013176/8.0),
    REAL_CONST(240.12632816923249/8.0),
    REAL_CONST(245.38927980018505/8.0),
    REAL_CONST(250.68060409747261/8.0),
    REAL_CONST(255.99999999999991/8.0),
    REAL_CONST(261.34717430828869/8.0),
    REAL_CONST(266.72184136106449/8.0),
    REAL_CONST(272.12372272986045/8.0),
    REAL_CONST(277.55254693037961/8.0),
    REAL_CONST(283.0080491494619/8.0),
    REAL_CONST(288.48997098659891/8.0),
    REAL_CONST(293.99806020902247/8.0),
    REAL_CONST(299.53207051947408/8.0),
    REAL_CONST(305.0917613358298/8.0),
    REAL_CONST(310.67689758182206/8.0),
    REAL_CONST(316.28724948815585/8.0),
    REAL_CONST(321.92259240337177/8.0),
    REAL_CONST(327.58270661385535/8.0),
    REAL_CONST(333.26737717243742/8.0),
    REAL_CONST(338.97639373507025/8.0),
    REAL_CONST(344.70955040510125/8.0),
    REAL_CONST(350.46664558470013/8.0),
    REAL_CONST(356.24748183302603/8.0),
    REAL_CONST(362.05186573075139/8.0),
    REAL_CONST(367.87960775058258/8.0),
    REAL_CONST(373.73052213344511/8.0),
    REAL_CONST(379.60442677002078/8.0),
    REAL_CONST(385.50114308734607/8.0),
    REAL_CONST(391.42049594019937/8.0),
    REAL_CONST(397.36231350702371/8.0),
    REAL_CONST(403.32642719014467/8.0),
    REAL_CONST(409.31267152006262/8.0),
    REAL_CONST(415.32088406360799/8.0),
    REAL_CONST(421.35090533576471/8.0),
    REAL_CONST(427.40257871497619/8.0),
    REAL_CONST(433.4757503617617/8.0),
    REAL_CONST(439.5702691404793/8.0),
    REAL_CONST(445.68598654408271/8.0),
    REAL_CONST(451.82275662172759/8.0),
    REAL_CONST(457.98043590909128/8.0),
    REAL_CONST(464.15888336127773/8.0),
    REAL_CONST(470.35796028818726/8.0),
    REAL_CONST(476.5775302922363/8.0),
    REAL_CONST(482.81745920832043/8.0),
    REAL_CONST(489.07761504591741/8.0),
    REAL_CONST(495.35786793323581/8.0),
    REAL_CONST(501.65809006331688/8.0),
    REAL_CONST(507.97815564200368/8.0),
    REAL_CONST(514.31794083769648/8.0),
    REAL_CONST(520.67732373281672/8.0),
    REAL_CONST(527.05618427690604/8.0),
    REAL_CONST(533.45440424129174/8.0),
    REAL_CONST(539.87186717525128/8.0),
    REAL_CONST(546.30845836361505/8.0),
    REAL_CONST(552.76406478574609/8.0),
    REAL_CONST(559.23857507584194/8.0),
    REAL_CONST(565.73187948450413/8.0),
    REAL_CONST(572.24386984152341/8.0),
    REAL_CONST(578.77443951983378/8.0),
    REAL_CONST(585.32348340058843/8.0),
    REAL_CONST(591.89089783931263/8.0),
    REAL_CONST(598.47658063309257/8.0),
    REAL_CONST(605.08043098876044/8.0),
    REAL_CONST(611.70234949203643/8.0),
    REAL_CONST(618.3422380775919/8.0),
    REAL_CONST(624.99999999999977/8.0),
    REAL_CONST(631.67553980553748/8.0),
    REAL_CONST(638.36876330481164/8.0),
    REAL_CONST(645.07957754617485/8.0),
    REAL_CONST(651.80789078990415/8.0),
    REAL_CONST(658.55361248311499/8.0),
    REAL_CONST(665.31665323538357/8.0),
    REAL_CONST(672.09692479505225/8.0),
    REAL_CONST(678.8943400261943/8.0),
    REAL_CONST(685.70881288621433/8.0),
    REAL_CONST(692.540258404062/8.0),
    REAL_CONST(699.38859265903977/8.0),
    REAL_CONST(706.25373276018058/8.0),
    REAL_CONST(713.13559682617972/8.0),
    REAL_CONST(720.03410396586037/8.0),
    REAL_CONST(726.94917425915435/8.0),
    REAL_CONST(733.88072873858209/8.0),
    REAL_CONST(740.82868937121543/8.0),
    REAL_CONST(747.79297904110535/8.0),
    REAL_CONST(754.77352153216191/8.0),
    REAL_CONST(761.77024151147043/8.0),
    REAL_CONST(768.78306451302956/8.0),
    REAL_CONST(775.81191692189896/8.0),
    REAL_CONST(782.85672595874246/8.0),
    REAL_CONST(789.91741966475445/8.0),
    REAL_CONST(796.99392688695798/8.0),
    REAL_CONST(804.08617726386274/8.0),
    REAL_CONST(811.19410121147098/8.0),
    REAL_CONST(818.31762990962227/8.0),
    REAL_CONST(825.45669528866563/8.0),
    REAL_CONST(832.61123001644864/8.0),
    REAL_CONST(839.78116748561604/8.0),
    REAL_CONST(846.96644180120552/8.0),
    REAL_CONST(854.16698776853514/8.0),
    REAL_CONST(861.38274088137143/8.0),
    REAL_CONST(868.61363731036977/8.0),
    REAL_CONST(875.85961389178203/8.0),
    REAL_CONST(883.12060811641959/8.0),
    REAL_CONST(890.39655811886757/8.0),
    REAL_CONST(897.68740266694181/8.0),
    REAL_CONST(904.99308115138172/8.0),
    REAL_CONST(912.31353357577188/8.0),
    REAL_CONST(919.64870054668756/8.0),
    REAL_CONST(926.99852326405619/8.0),
    REAL_CONST(934.36294351172899/8.0),
    REAL_CONST(941.74190364825859/8.0),
    REAL_CONST(949.13534659787422/8.0),
    REAL_CONST(956.54321584165211/8.0),
    REAL_CONST(963.96545540887348/8.0),
    REAL_CONST(971.40200986856541/8.0),
    REAL_CONST(978.85282432122176/8.0),
    REAL_CONST(986.31784439069588/8.0),
    REAL_CONST(993.7970162162635/8.0),
    REAL_CONST(1001.29028644485/8.0),
    REAL_CONST(1008.797602223418/8.0),
    REAL_CONST(1016.3189111915103/8.0),
    REAL_CONST(1023.8541614739464/8.0),
    REAL_CONST(1031.4033016736653/8.0),
    REAL_CONST(1038.9662808647138/8.0),
    REAL_CONST(1046.5430485853758/8.0),
    REAL_CONST(1054.1335548314366/8.0),
    REAL_CONST(1061.7377500495838/8.0),
    REAL_CONST(1069.3555851309357/8.0),
    REAL_CONST(1076.9870114046978/8.0),
    REAL_CONST(1084.6319806319441/8.0),
    REAL_CONST(1092.2904449995174/8.0),
    REAL_CONST(1099.9623571140482/8.0),
    REAL_CONST(1107.6476699960892/8.0),
    REAL_CONST(1115.3463370743607/8.0),
    REAL_CONST(1123.058312180106/8.0),
    REAL_CONST(1130.7835495415541/8.0),
    REAL_CONST(1138.5220037784854/8.0),
    REAL_CONST(1146.273629896901/8.0),
    REAL_CONST(1154.0383832837879/8.0),
    REAL_CONST(1161.816219701986/8.0),
    REAL_CONST(1169.607095285146/8.0),
    REAL_CONST(1177.4109665327808/8.0),
    REAL_CONST(1185.2277903054078/8.0),
    REAL_CONST(1193.0575238197798/8.0),
    REAL_CONST(1200.9001246442001/8.0),
    REAL_CONST(1208.7555506939248/8.0),
    REAL_CONST(1216.6237602266442/8.0),
    REAL_CONST(1224.5047118380478/8.0),
    REAL_CONST(1232.3983644574657/8.0),
    REAL_CONST(1240.3046773435874/8.0),
    REAL_CONST(1248.2236100802568/8.0),
    REAL_CONST(1256.1551225723395/8.0),
    REAL_CONST(1264.099175041662/8.0),
    REAL_CONST(1272.0557280230228/8.0),
    REAL_CONST(1280.0247423602691/8.0),
    REAL_CONST(1288.0061792024444/8.0),
    REAL_CONST(1295.9999999999995/8.0),
    REAL_CONST(1304.006166501068/8.0),
    REAL_CONST(1312.0246407478062/8.0),
    REAL_CONST(1320.0553850727929/8.0),
    REAL_CONST(1328.0983620954903/8.0),
    REAL_CONST(1336.1535347187651/8.0),
    REAL_CONST(1344.2208661254647/8.0),
    REAL_CONST(1352.3003197750522/8.0),
    REAL_CONST(1360.3918594002962/8.0),
    REAL_CONST(1368.4954490040145/8.0),
    REAL_CONST(1376.6110528558709/8.0),
    REAL_CONST(1384.7386354892244/8.0),
    REAL_CONST(1392.8781616980295/8.0),
    REAL_CONST(1401.0295965337855/8.0),
    REAL_CONST(1409.1929053025353/8.0),
    REAL_CONST(1417.3680535619119/8.0),
    REAL_CONST(1425.5550071182327/8.0),
    REAL_CONST(1433.7537320236374/8.0),
    REAL_CONST(1441.9641945732744/8.0),
    REAL_CONST(1450.1863613025282/8.0),
    REAL_CONST(1458.4201989842913/8.0),
    REAL_CONST(1466.6656746262797/8.0),
    REAL_CONST(1474.9227554683875/8.0),
    REAL_CONST(1483.1914089800841/8.0),
    REAL_CONST(1491.4716028578516/8.0),
    REAL_CONST(1499.7633050226596/8.0),
    REAL_CONST(1508.0664836174794/8.0),
    REAL_CONST(1516.3811070048375/8.0),
    REAL_CONST(1524.7071437644029/8.0),
    REAL_CONST(1533.0445626906128/8.0),
    REAL_CONST(1541.3933327903342/8.0),
    REAL_CONST(1549.7534232805581/8.0),
    REAL_CONST(1558.1248035861302/8.0),
    REAL_CONST(1566.507443337515/8.0),
    REAL_CONST(1574.9013123685909/8.0),
    REAL_CONST(1583.3063807144795/8.0),
    REAL_CONST(1591.7226186094069/8.0),
    REAL_CONST(1600.1499964845941/8.0),
    REAL_CONST(1608.58848496618/8.0),
    REAL_CONST(1617.0380548731737/8.0),
    REAL_CONST(1625.4986772154357/8.0),
    REAL_CONST(1633.9703231916887/8.0),
    REAL_CONST(1642.4529641875577/8.0),
    REAL_CONST(1650.9465717736346/8.0),
    REAL_CONST(1659.4511177035752/8.0),
    REAL_CONST(1667.9665739122186/8.0),
    REAL_CONST(1676.4929125137353/8.0),
    REAL_CONST(1685.030105799801/8.0),
    REAL_CONST(1693.5781262377957/8.0),
    REAL_CONST(1702.136946469027/8.0),
    REAL_CONST(1710.7065393069795/8.0),
    REAL_CONST(1719.2868777355877/8.0),
    REAL_CONST(1727.8779349075323/8.0),
    REAL_CONST(1736.4796841425596/8.0),
    REAL_CONST(1745.092098925825/8.0),
    REAL_CONST(1753.7151529062583/8.0),
    REAL_CONST(1762.3488198949503/8.0),
    REAL_CONST(1770.9930738635628/8.0),
    REAL_CONST(1779.6478889427597/8.0),
    REAL_CONST(1788.3132394206564/8.0),
    REAL_CONST(1796.9890997412947/8.0),
    REAL_CONST(1805.6754445031333/8.0),
    REAL_CONST(1814.3722484575621/8.0),
    REAL_CONST(1823.0794865074322/8.0),
    REAL_CONST(1831.7971337056094/8.0),
    REAL_CONST(1840.5251652535437/8.0),
    REAL_CONST(1849.2635564998579/8.0),
    REAL_CONST(1858.0122829389563/8.0),
    REAL_CONST(1866.7713202096493/8.0),
    REAL_CONST(1875.5406440937966/8.0),
    REAL_CONST(1884.3202305149687/8.0),
    REAL_CONST(1893.110055537124/8.0),
    REAL_CONST(1901.9100953633042/8.0),
    REAL_CONST(1910.7203263343454/8.0),
    REAL_CONST(1919.5407249276057/8.0),
    REAL_CONST(1928.3712677557098/8.0),
    REAL_CONST(1937.2119315653083/8.0),
    REAL_CONST(1946.0626932358525/8.0),
    REAL_CONST(1954.923529778386/8.0),
    REAL_CONST(1963.79441833435/8.0),
    REAL_CONST(1972.6753361744036/8.0),
    REAL_CONST(1981.5662606972594/8.0),
    REAL_CONST(1990.467169428533/8.0),
    REAL_CONST(1999.3780400196069/8.0),
    REAL_CONST(2008.2988502465078/8.0),
    REAL_CONST(2017.2295780087982/8.0),
    REAL_CONST(2026.1702013284819/8.0),
    REAL_CONST(2035.1206983489212/8.0),
    REAL_CONST(2044.0810473337688/8.0),
    REAL_CONST(2053.0512266659125/8.0),
    REAL_CONST(2062.0312148464309/8.0),
    REAL_CONST(2071.0209904935646/8.0),
    REAL_CONST(2080.0205323416958/8.0),
    REAL_CONST(2089.0298192403443/8.0),
    REAL_CONST(2098.0488301531714/8.0),
    REAL_CONST(2107.0775441569995/8.0),
    REAL_CONST(2116.115940440839/8.0),
    REAL_CONST(2125.1639983049317/8.0),
    REAL_CONST(2134.2216971597995/8.0),
    REAL_CONST(2143.2890165253098/8.0),
    REAL_CONST(2152.3659360297484/8.0),
    REAL_CONST(2161.4524354089031/8.0),
    REAL_CONST(2170.5484945051617/8.0),
    REAL_CONST(2179.6540932666144/8.0),
    REAL_CONST(2188.7692117461711/8.0),
    REAL_CONST(2197.8938301006888/8.0),
    REAL_CONST(2207.0279285901042/8.0),
    REAL_CONST(2216.1714875765838/8.0),
    REAL_CONST(2225.324487523676/8.0),
    REAL_CONST(2234.4869089954782/8.0),
    REAL_CONST(2243.6587326558101/8.0),
    REAL_CONST(2252.8399392673982/8.0),
    REAL_CONST(2262.0305096910702/8.0),
    REAL_CONST(2271.2304248849537/8.0),
    REAL_CONST(2280.4396659036897/8.0),
    REAL_CONST(2289.6582138976523/8.0),
    REAL_CONST(2298.8860501121762/8.0),
    REAL_CONST(2308.1231558867926/8.0),
    REAL_CONST(2317.3695126544767/8.0),
    REAL_CONST(2326.6251019409005/8.0),
    REAL_CONST(2335.8899053636933/8.0),
    REAL_CONST(2345.1639046317132/8.0),
    REAL_CONST(2354.4470815443233/8.0),
    REAL_CONST(2363.7394179906792/8.0),
    REAL_CONST(2373.0408959490205/8.0),
    REAL_CONST(2382.3514974859731/8.0),
    REAL_CONST(2391.6712047558558/8.0),
    REAL_CONST(2400.9999999999991/8.0),
    REAL_CONST(2410.3378655460651/8.0),
    REAL_CONST(2419.6847838073813/8.0),
    REAL_CONST(2429.0407372822747/8.0),
    REAL_CONST(2438.4057085534191/8.0),
    REAL_CONST(2447.7796802871858/8.0),
    REAL_CONST(2457.1626352330004/8.0),
    REAL_CONST(2466.5545562227112/8.0),
    REAL_CONST(2475.9554261699564/8.0),
    REAL_CONST(2485.3652280695474/8.0),
    REAL_CONST(2494.7839449968492/8.0),
    REAL_CONST(2504.2115601071737/8.0),
    REAL_CONST(2513.6480566351788/8.0),
    REAL_CONST(2523.0934178942675/8.0),
    REAL_CONST(2532.5476272760025/8.0),
    REAL_CONST(2542.0106682495189/8.0),
    REAL_CONST(2551.482524360948/8.0),
    REAL_CONST(2560.9631792328441/8.0),
    REAL_CONST(2570.4526165636184/8.0),
    REAL_CONST(2579.9508201269791/8.0),
    REAL_CONST(2589.4577737713744/8.0),
    REAL_CONST(2598.9734614194458/8.0),
    REAL_CONST(2608.4978670674823/8.0),
    REAL_CONST(2618.0309747848837/8.0),
    REAL_CONST(2627.5727687136259/8.0),
    REAL_CONST(2637.1232330677353/8.0),
    REAL_CONST(2646.6823521327647/8.0),
    REAL_CONST(2656.2501102652768/8.0),
    REAL_CONST(2665.8264918923328/8.0),
    REAL_CONST(2675.4114815109842/8.0),
    REAL_CONST(2685.0050636877722/8.0),
    REAL_CONST(2694.6072230582295/8.0),
    REAL_CONST(2704.2179443263894/8.0),
    REAL_CONST(2713.8372122642972/8.0),
    REAL_CONST(2723.4650117115279/8.0),
    REAL_CONST(2733.1013275747096/8.0),
    REAL_CONST(2742.7461448270483/8.0),
    REAL_CONST(2752.3994485078601/8.0),
    REAL_CONST(2762.0612237221085/8.0),
    REAL_CONST(2771.7314556399419/8.0),
    REAL_CONST(2781.4101294962406/8.0),
    REAL_CONST(2791.0972305901655/8.0),
    REAL_CONST(2800.7927442847094/8.0),
    REAL_CONST(2810.4966560062589/8.0),
    REAL_CONST(2820.2089512441521/8.0),
    REAL_CONST(2829.9296155502466/8.0),
    REAL_CONST(2839.6586345384894/8.0),
    REAL_CONST(2849.3959938844923/8.0),
    REAL_CONST(2859.1416793251065/8.0),
    REAL_CONST(2868.8956766580086/8.0),
    REAL_CONST(2878.6579717412847/8.0),
    REAL_CONST(2888.4285504930212/8.0),
    REAL_CONST(2898.2073988908974/8.0),
    REAL_CONST(2907.9945029717837/8.0),
    REAL_CONST(2917.789848831344/8.0),
    REAL_CONST(2927.5934226236377/8.0),
    REAL_CONST(2937.4052105607311/8.0),
    REAL_CONST(2947.2251989123079/8.0),
    REAL_CONST(2957.0533740052865/8.0),
    REAL_CONST(2966.8897222234368/8.0),
    REAL_CONST(2976.734230007005/8.0),
    REAL_CONST(2986.5868838523397/8.0),
    REAL_CONST(2996.4476703115197/8.0),
    REAL_CONST(3006.3165759919889/8.0),
    REAL_CONST(3016.1935875561908/8.0),
    REAL_CONST(3026.0786917212095/8.0),
    REAL_CONST(3035.9718752584108/8.0),
    REAL_CONST(3045.8731249930906/8.0),
    REAL_CONST(3055.7824278041207/8.0),
    REAL_CONST(3065.6997706236039/8.0),
    REAL_CONST(3075.625140436528/8.0),
    REAL_CONST(3085.5585242804245/8.0),
    REAL_CONST(3095.4999092450298/8.0),
    REAL_CONST(3105.4492824719491/8.0),
    REAL_CONST(3115.4066311543256/8.0),
    REAL_CONST(3125.3719425365089/8.0),
    REAL_CONST(3135.3452039137287/8.0),
    REAL_CONST(3145.3264026317715/8.0),
    REAL_CONST(3155.3155260866592/8.0),
    REAL_CONST(3165.3125617243295/8.0),
    REAL_CONST(3175.3174970403229/8.0),
    REAL_CONST(3185.3303195794679/8.0),
    REAL_CONST(3195.35101693557/8.0),
    REAL_CONST(3205.3795767511078/8.0),
    REAL_CONST(3215.4159867169251/8.0),
    REAL_CONST(3225.460234571929/8.0),
    REAL_CONST(3235.5123081027928/8.0),
    REAL_CONST(3245.5721951436558/8.0),
    REAL_CONST(3255.63988357583/8.0),
    REAL_CONST(3265.7153613275095/8.0),
    REAL_CONST(3275.7986163734795/8.0),
    REAL_CONST(3285.8896367348289/8.0),
    REAL_CONST(3295.9884104786665/8.0),
    REAL_CONST(3306.0949257178395/8.0),
    REAL_CONST(3316.2091706106517/8.0),
    REAL_CONST(3326.331133360588/8.0),
    REAL_CONST(3336.4608022160378/8.0),
    REAL_CONST(3346.5981654700231/8.0),
    REAL_CONST(3356.7432114599264/8.0),
    REAL_CONST(3366.8959285672249/8.0),
    REAL_CONST(3377.0563052172211/8.0),
    REAL_CONST(3387.2243298787821/8.0),
    REAL_CONST(3397.3999910640764/8.0),
    REAL_CONST(3407.5832773283128/8.0),
    REAL_CONST(3417.7741772694862/8.0),
    REAL_CONST(3427.9726795281199/8.0),
    REAL_CONST(3438.1787727870123/8.0),
    REAL_CONST(3448.3924457709873/8.0),
    REAL_CONST(3458.6136872466445/8.0),
    REAL_CONST(3468.8424860221107/8.0),
    REAL_CONST(3479.0788309467976/8.0),
    REAL_CONST(3489.3227109111554/8.0),
    REAL_CONST(3499.5741148464344/8.0),
    REAL_CONST(3509.8330317244445/8.0),
    REAL_CONST(3520.0994505573185/8.0),
    REAL_CONST(3530.3733603972751/8.0),
    REAL_CONST(3540.6547503363886/8.0),
    REAL_CONST(3550.9436095063534/8.0),
    REAL_CONST(3561.239927078258/8.0),
    REAL_CONST(3571.5436922623535/8.0),
    REAL_CONST(3581.8548943078308/8.0),
    REAL_CONST(3592.1735225025936/8.0),
    REAL_CONST(3602.4995661730372/8.0),
    REAL_CONST(3612.8330146838275/8.0),
    REAL_CONST(3623.1738574376814/8.0),
    REAL_CONST(3633.5220838751502/8.0),
    REAL_CONST(3643.8776834744031/8.0),
    REAL_CONST(3654.2406457510142/8.0),
    REAL_CONST(3664.6109602577494/8.0),
    REAL_CONST(3674.9886165843564/8.0),
    REAL_CONST(3685.3736043573545/8.0),
    REAL_CONST(3695.7659132398294/8.0),
    REAL_CONST(3706.1655329312248/8.0),
    REAL_CONST(3716.5724531671399/8.0),
    REAL_CONST(3726.9866637191262/8.0),
    REAL_CONST(3737.4081543944876/8.0),
    REAL_CONST(3747.8369150360782/8.0),
    REAL_CONST(3758.2729355221072/8.0),
    REAL_CONST(3768.7162057659411/8.0),
    REAL_CONST(3779.1667157159077/8.0),
    REAL_CONST(3789.6244553551055/8.0),
    REAL_CONST(3800.0894147012082/8.0),
    REAL_CONST(3810.5615838062768/8.0),
    REAL_CONST(3821.0409527565694/8.0),
    REAL_CONST(3831.5275116723533/8.0),
    REAL_CONST(3842.0212507077194/8.0),
    REAL_CONST(3852.522160050396/8.0),
    REAL_CONST(3863.0302299215673/8.0),
    REAL_CONST(3873.5454505756893/8.0),
    REAL_CONST(3884.0678123003108/8.0),
    REAL_CONST(3894.5973054158922/8.0),
    REAL_CONST(3905.1339202756285/8.0),
    REAL_CONST(3915.6776472652732/8.0),
    REAL_CONST(3926.2284768029604/8.0),
    REAL_CONST(3936.7863993390338/8.0),
    REAL_CONST(3947.3514053558706/8.0),
    REAL_CONST(3957.9234853677135/8.0),
    REAL_CONST(3968.5026299204969/8.0),
    REAL_CONST(3979.0888295916798/8.0),
    REAL_CONST(3989.6820749900776/8.0),
    REAL_CONST(4000.2823567556948/8.0),
    REAL_CONST(4010.8896655595613/8.0),
    REAL_CONST(4021.5039921035655/8.0),
    REAL_CONST(4032.1253271202945/8.0),
    REAL_CONST(4042.7536613728694/8.0),
    REAL_CONST(4053.3889856547858/8.0),
    REAL_CONST(4064.0312907897551/8.0),
    REAL_CONST(4074.6805676315448/8.0),
    REAL_CONST(4085.3368070638221/8.0),
    REAL_CONST(4095.9999999999982/8.0),
    REAL_CONST(4106.6701373830711/8.0),
    REAL_CONST(4117.347210185475/8.0),
    REAL_CONST(4128.0312094089259/8.0),
    REAL_CONST(4138.722126084268/8.0),
    REAL_CONST(4149.4199512713267/8.0),
    REAL_CONST(4160.1246760587583/8.0),
    REAL_CONST(4170.8362915638982/8.0),
    REAL_CONST(4181.5547889326181/8.0),
    REAL_CONST(4192.2801593391769/8.0),
    REAL_CONST(4203.0123939860741/8.0),
    REAL_CONST(4213.7514841039101/8.0),
    REAL_CONST(4224.4974209512384/8.0),
    REAL_CONST(4235.2501958144258/8.0),
    REAL_CONST(4246.0098000075095/8.0),
    REAL_CONST(4256.7762248720574/8.0),
    REAL_CONST(4267.549461777031/8.0),
    REAL_CONST(4278.3295021186423/8.0),
    REAL_CONST(4289.1163373202198/8.0),
    REAL_CONST(4299.9099588320714/8.0),
    REAL_CONST(4310.7103581313495/8.0),
    REAL_CONST(4321.5175267219138/8.0),
    REAL_CONST(4332.3314561342004/8.0),
    REAL_CONST(4343.152137925088/8.0),
    REAL_CONST(4353.9795636777671/8.0),
    REAL_CONST(4364.8137250016052/8.0),
    REAL_CONST(4375.6546135320223/8.0),
    REAL_CONST(4386.5022209303588/8.0),
    REAL_CONST(4397.3565388837469/8.0),
    REAL_CONST(4408.2175591049827/8.0),
    REAL_CONST(4419.0852733324018/8.0),
    REAL_CONST(4429.9596733297531/8.0),
    REAL_CONST(4440.8407508860728/8.0),
    REAL_CONST(4451.7284978155603/8.0),
    REAL_CONST(4462.6229059574571/8.0),
    REAL_CONST(4473.5239671759227/8.0),
    REAL_CONST(4484.4316733599126/8.0),
    REAL_CONST(4495.3460164230582/8.0),
    REAL_CONST(4506.2669883035496/8.0),
    REAL_CONST(4517.1945809640119/8.0),
    REAL_CONST(4528.1287863913894/8.0),
    REAL_CONST(4539.069596596828/8.0),
    REAL_CONST(4550.0170036155587/8.0),
    REAL_CONST(4560.9709995067806/8.0),
    REAL_CONST(4571.931576353546/8.0),
    REAL_CONST(4582.898726262647/8.0),
    REAL_CONST(4593.8724413645004/8.0),
    REAL_CONST(4604.8527138130348/8.0),
    REAL_CONST(4615.8395357855816/8.0),
    REAL_CONST(4626.8328994827571/8.0),
    REAL_CONST(4637.8327971283588/8.0),
    REAL_CONST(4648.8392209692511/8.0),
    REAL_CONST(4659.8521632752563/8.0),
    REAL_CONST(4670.8716163390473/8.0),
    REAL_CONST(4681.8975724760394/8.0),
    REAL_CONST(4692.9300240242837/8.0),
    REAL_CONST(4703.9689633443595/8.0),
    REAL_CONST(4715.0143828192668/8.0),
    REAL_CONST(4726.0662748543255/8.0),
    REAL_CONST(4737.1246318770682/8.0),
    REAL_CONST(4748.1894463371373/8.0),
    REAL_CONST(4759.2607107061804/8.0),
    REAL_CONST(4770.3384174777493/8.0),
    REAL_CONST(4781.4225591671993/8.0),
    REAL_CONST(4792.5131283115852/8.0),
    REAL_CONST(4803.6101174695614/8.0),
    REAL_CONST(4814.7135192212854/8.0),
    REAL_CONST(4825.8233261683154/8.0),
    REAL_CONST(4836.9395309335096/8.0),
    REAL_CONST(4848.0621261609349/8.0),
    REAL_CONST(4859.1911045157631/8.0),
    REAL_CONST(4870.3264586841779/8.0),
    REAL_CONST(4881.4681813732768/8.0),
    REAL_CONST(4892.6162653109768/8.0),
    REAL_CONST(4903.7707032459193/8.0),
    REAL_CONST(4914.931487947375/8.0),
    REAL_CONST(4926.0986122051509/8.0),
    REAL_CONST(4937.2720688294967/8.0),
    REAL_CONST(4948.4518506510112/8.0),
    REAL_CONST(4959.637950520555/8.0),
    REAL_CONST(4970.8303613091521/8.0),
    REAL_CONST(4982.0290759079044/8.0),
    REAL_CONST(4993.2340872278974/8.0),
    REAL_CONST(5004.4453882001153/8.0),
    REAL_CONST(5015.6629717753467/8.0),
    REAL_CONST(5026.8868309241007/8.0),
    REAL_CONST(5038.1169586365131/8.0),
    REAL_CONST(5049.353347922266/8.0),
    REAL_CONST(5060.5959918104927/8.0),
    REAL_CONST(5071.8448833496996/8.0),
    REAL_CONST(5083.1000156076734/8.0),
    REAL_CONST(5094.3613816713996/8.0),
    REAL_CONST(5105.6289746469747/8.0),
    REAL_CONST(5116.9027876595246/8.0),
    REAL_CONST(5128.18281385312/8.0),
    REAL_CONST(5139.4690463906918/8.0),
    REAL_CONST(5150.7614784539473/8.0),
    REAL_CONST(5162.0601032432933/8.0),
    REAL_CONST(5173.3649139777472/8.0),
    REAL_CONST(5184.6759038948594/8.0),
    REAL_CONST(5195.9930662506322/8.0),
    REAL_CONST(5207.3163943194386/8.0),
    REAL_CONST(5218.6458813939435/8.0),
    REAL_CONST(5229.9815207850224/8.0),
    REAL_CONST(5241.3233058216847/8.0),
    REAL_CONST(5252.6712298509919/8.0),
    REAL_CONST(5264.025286237983/8.0),
    REAL_CONST(5275.3854683655954/8.0),
    REAL_CONST(5286.7517696345885/8.0),
    REAL_CONST(5298.1241834634639/8.0),
    REAL_CONST(5309.5027032883945/8.0),
    REAL_CONST(5320.887322563146/8.0),
    REAL_CONST(5332.2780347589978/8.0),
    REAL_CONST(5343.6748333646756/8.0),
    REAL_CONST(5355.0777118862716/8.0),
    REAL_CONST(5366.4866638471722/8.0),
    REAL_CONST(5377.901682787985/8.0),
    REAL_CONST(5389.3227622664635/8.0),
    REAL_CONST(5400.749895857437/8.0),
    REAL_CONST(5412.1830771527357/8.0),
    REAL_CONST(5423.622299761123/8.0),
    REAL_CONST(5435.067557308219/8.0),
    REAL_CONST(5446.5188434364318/8.0),
    REAL_CONST(5457.9761518048872/8.0),
    REAL_CONST(5469.4394760893592/8.0),
    REAL_CONST(5480.9088099821975/8.0),
    REAL_CONST(5492.3841471922606/8.0),
    REAL_CONST(5503.8654814448455/8.0),
    REAL_CONST(5515.3528064816201/8.0),
    REAL_CONST(5526.846116060552/8.0),
    REAL_CONST(5538.3454039558474/8.0),
    REAL_CONST(5549.8506639578736/8.0),
    REAL_CONST(5561.3618898731029/8.0),
    REAL_CONST(5572.8790755240361/8.0),
    REAL_CONST(5584.4022147491451/8.0),
    REAL_CONST(5595.9313014027975/8.0),
    REAL_CONST(5607.4663293552012/8.0),
    REAL_CONST(5619.0072924923297/8.0),
    REAL_CONST(5630.5541847158656/8.0),
    REAL_CONST(5642.1069999431284/8.0),
    REAL_CONST(5653.665732107017/8.0),
    REAL_CONST(5665.230375155943/8.0),
    REAL_CONST(5676.8009230537655/8.0),
    REAL_CONST(5688.3773697797333/8.0),
    REAL_CONST(5699.9597093284156/8.0),
    REAL_CONST(5711.5479357096474/8.0),
    REAL_CONST(5723.1420429484588/8.0),
    REAL_CONST(5734.7420250850209/8.0),
    REAL_CONST(5746.347876174581/8.0),
    REAL_CONST(5757.9595902874016/8.0),
    REAL_CONST(5769.5771615087006/8.0),
    REAL_CONST(5781.2005839385911/8.0),
    REAL_CONST(5792.8298516920213/8.0),
    REAL_CONST(5804.4649588987149/8.0),
    REAL_CONST(5816.1058997031105/8.0),
    REAL_CONST(5827.7526682643065/8.0),
    REAL_CONST(5839.4052587559972/8.0),
    REAL_CONST(5851.0636653664196/8.0),
    REAL_CONST(5862.7278822982908/8.0),
    REAL_CONST(5874.3979037687541/8.0),
    REAL_CONST(5886.0737240093204/8.0),
    REAL_CONST(5897.7553372658094/8.0),
    REAL_CONST(5909.4427377982956/8.0),
    REAL_CONST(5921.1359198810505/8.0),
    REAL_CONST(5932.8348778024874/8.0),
    REAL_CONST(5944.5396058651031/8.0),
    REAL_CONST(5956.2500983854261/8.0),
    REAL_CONST(5967.9663496939575/8.0),
    REAL_CONST(5979.6883541351208/8.0),
    REAL_CONST(5991.4161060672022/8.0),
    REAL_CONST(6003.1495998623004/8.0),
    REAL_CONST(6014.8888299062692/8.0),
    REAL_CONST(6026.6337905986684/8.0),
    REAL_CONST(6038.3844763527022/8.0),
    REAL_CONST(6050.1408815951781/8.0),
    REAL_CONST(6061.9030007664414/8.0),
    REAL_CONST(6073.6708283203316/8.0),
    REAL_CONST(6085.4443587241267/8.0),
    REAL_CONST(6097.2235864584891/8.0),
    REAL_CONST(6109.0085060174197/8.0),
    REAL_CONST(6120.7991119081998/8.0),
    REAL_CONST(6132.595398651345/8.0),
    REAL_CONST(6144.3973607805519/8.0),
    REAL_CONST(6156.2049928426459/8.0),
    REAL_CONST(6168.0182893975361/8.0),
    REAL_CONST(6179.8372450181578/8.0),
    REAL_CONST(6191.6618542904307/8.0),
    REAL_CONST(6203.4921118132024/8.0),
    REAL_CONST(6215.3280121982016/8.0),
    REAL_CONST(6227.1695500699925/8.0),
    REAL_CONST(6239.0167200659189/8.0),
    REAL_CONST(6250.8695168360628/8.0),
    REAL_CONST(6262.7279350431891/8.0),
    REAL_CONST(6274.5919693627056/8.0),
    REAL_CONST(6286.4616144826068/8.0),
    REAL_CONST(6298.3368651034316/8.0),
    REAL_CONST(6310.2177159382172/8.0),
    REAL_CONST(6322.1041617124456/8.0),
    REAL_CONST(6333.9961971640032/8.0),
    REAL_CONST(6345.8938170431311/8.0),
    REAL_CONST(6357.7970161123785/8.0),
    REAL_CONST(6369.7057891465583/8.0),
    REAL_CONST(6381.6201309327007/8.0),
    REAL_CONST(6393.5400362700075/8.0),
    REAL_CONST(6405.4654999698032/8.0),
    REAL_CONST(6417.3965168554978/8.0),
    REAL_CONST(6429.3330817625329/8.0),
    REAL_CONST(6441.2751895383453/8.0),
    REAL_CONST(6453.2228350423138/8.0),
    REAL_CONST(6465.176013145724/8.0),
    REAL_CONST(6477.134718731716/8.0),
    REAL_CONST(6489.0989466952469/8.0),
    REAL_CONST(6501.0686919430445/8.0),
    REAL_CONST(6513.0439493935628/8.0),
    REAL_CONST(6525.0247139769417/8.0),
    REAL_CONST(6537.010980634961/8.0),
    REAL_CONST(6549.002744321001/8.0),
    REAL_CONST(6560.9999999999973/8.0),
    REAL_CONST(6573.0027426483985/8.0),
    REAL_CONST(6585.0109672541284/8.0),
    REAL_CONST(6597.0246688165371/8.0),
    REAL_CONST(6609.0438423463656/8.0),
    REAL_CONST(6621.0684828657004/8.0),
    REAL_CONST(6633.0985854079354/8.0),
    REAL_CONST(6645.134145017727/8.0),
    REAL_CONST(6657.1751567509573/8.0),
    REAL_CONST(6669.2216156746908/8.0),
    REAL_CONST(6681.2735168671343/8.0),
    REAL_CONST(6693.3308554176001/8.0),
    REAL_CONST(6705.3936264264594/8.0),
    REAL_CONST(6717.461825005108/8.0),
    REAL_CONST(6729.535446275926/8.0),
    REAL_CONST(6741.6144853722335/8.0),
    REAL_CONST(6753.6989374382601/8.0),
    REAL_CONST(6765.7887976290967/8.0),
    REAL_CONST(6777.8840611106634/8.0),
    REAL_CONST(6789.9847230596661/8.0),
    REAL_CONST(6802.0907786635626/8.0),
    REAL_CONST(6814.2022231205201/8.0),
    REAL_CONST(6826.3190516393797/8.0),
    REAL_CONST(6838.4412594396181/8.0),
    REAL_CONST(6850.5688417513074/8.0),
    REAL_CONST(6862.701793815083/8.0),
    REAL_CONST(6874.840110882099/8.0),
    REAL_CONST(6886.9837882139991/8.0),
    REAL_CONST(6899.1328210828724/8.0),
    REAL_CONST(6911.2872047712199/8.0),
    REAL_CONST(6923.4469345719199/8.0),
    REAL_CONST(6935.6120057881863/8.0),
    REAL_CONST(6947.7824137335365/8.0),
    REAL_CONST(6959.9581537317536/8.0),
    REAL_CONST(6972.1392211168532/8.0),
    REAL_CONST(6984.3256112330409/8.0),
    REAL_CONST(6996.5173194346862/8.0),
    REAL_CONST(7008.7143410862773/8.0),
    REAL_CONST(7020.9166715623942/8.0),
    REAL_CONST(7033.1243062476678/8.0),
    REAL_CONST(7045.3372405367481/8.0),
    REAL_CONST(7057.5554698342685/8.0),
    REAL_CONST(7069.7789895548103/8.0),
    REAL_CONST(7082.0077951228714/8.0),
    REAL_CONST(7094.2418819728273/8.0),
    REAL_CONST(7106.4812455489018/8.0),
    REAL_CONST(7118.7258813051285/8.0),
    REAL_CONST(7130.9757847053224/8.0),
    REAL_CONST(7143.2309512230404/8.0),
    REAL_CONST(7155.4913763415516/8.0),
    REAL_CONST(7167.7570555538041/8.0),
    REAL_CONST(7180.0279843623894/8.0),
    REAL_CONST(7192.3041582795131/8.0),
    REAL_CONST(7204.5855728269571/8.0),
    REAL_CONST(7216.8722235360519/8.0),
    REAL_CONST(7229.1641059476406/8.0),
    REAL_CONST(7241.4612156120484/8.0),
    REAL_CONST(7253.7635480890503/8.0),
    REAL_CONST(7266.0710989478375/8.0),
    REAL_CONST(7278.3838637669869/8.0),
    REAL_CONST(7290.7018381344296/8.0),
    REAL_CONST(7303.0250176474174/8.0),
    REAL_CONST(7315.3533979124932/8.0),
    REAL_CONST(7327.6869745454596/8.0),
    REAL_CONST(7340.0257431713462/8.0),
    REAL_CONST(7352.3696994243801/8.0),
    REAL_CONST(7364.7188389479543/8.0),
    REAL_CONST(7377.0731573945968/8.0),
    REAL_CONST(7389.4326504259407/8.0),
    REAL_CONST(7401.7973137126937/8.0),
    REAL_CONST(7414.1671429346061/8.0),
    REAL_CONST(7426.5421337804428/8.0),
    REAL_CONST(7438.922281947951/8.0),
    REAL_CONST(7451.3075831438346/8.0),
    REAL_CONST(7463.6980330837177/8.0),
    REAL_CONST(7476.0936274921214/8.0),
    REAL_CONST(7488.4943621024304/8.0),
    REAL_CONST(7500.9002326568652/8.0),
    REAL_CONST(7513.3112349064522/8.0),
    REAL_CONST(7525.7273646109943/8.0),
    REAL_CONST(7538.1486175390446/8.0),
    REAL_CONST(7550.5749894678729/8.0),
    REAL_CONST(7563.0064761834419/8.0),
    REAL_CONST(7575.4430734803736/8.0),
    REAL_CONST(7587.8847771619248/8.0),
    REAL_CONST(7600.3315830399597/8.0),
    REAL_CONST(7612.7834869349153/8.0),
    REAL_CONST(7625.24048467578/8.0),
    REAL_CONST(7637.7025721000637/8.0),
    REAL_CONST(7650.1697450537677/8.0),
    REAL_CONST(7662.6419993913596/8.0),
    REAL_CONST(7675.1193309757446/8.0),
    REAL_CONST(7687.6017356782404/8.0),
    REAL_CONST(7700.0892093785433/8.0),
    REAL_CONST(7712.5817479647112/8.0),
    REAL_CONST(7725.079347333125/8.0),
    REAL_CONST(7737.5820033884729/8.0),
    REAL_CONST(7750.0897120437139/8.0),
    REAL_CONST(7762.6024692200581/8.0),
    REAL_CONST(7775.1202708469355/8.0),
    REAL_CONST(7787.6431128619733/8.0),
    REAL_CONST(7800.1709912109645/8.0),
    REAL_CONST(7812.7039018478481/8.0),
    REAL_CONST(7825.2418407346768/8.0),
    REAL_CONST(7837.7848038415968/8.0),
    REAL_CONST(7850.3327871468155/8.0),
    REAL_CONST(7862.8857866365806/8.0),
    REAL_CONST(7875.4437983051539/8.0),
    REAL_CONST(7888.006818154784/8.0),
    REAL_CONST(7900.5748421956796/8.0),
    REAL_CONST(7913.1478664459901/8.0),
    REAL_CONST(7925.725886931772/8.0),
    REAL_CONST(7938.3088996869719/8.0),
    REAL_CONST(7950.8969007533951/8.0),
    REAL_CONST(7963.4898861806851/8.0),
    REAL_CONST(7976.0878520262959/8.0),
    REAL_CONST(7988.6907943554688/8.0),
    REAL_CONST(8001.2987092412086/8.0),
    REAL_CONST(8013.911592764257/8.0),
    REAL_CONST(8026.5294410130691/8.0),
    REAL_CONST(8039.1522500837891/8.0),
    REAL_CONST(8051.7800160802271/8.0),
    REAL_CONST(8064.412735113835/8.0),
    REAL_CONST(8077.0504033036796/8.0),
    REAL_CONST(8089.6930167764222/8.0),
    REAL_CONST(8102.3405716662946/8.0),
    REAL_CONST(8114.9930641150731/8.0),
    REAL_CONST(8127.6504902720571/8.0),
    REAL_CONST(8140.3128462940449/8.0),
    REAL_CONST(8152.9801283453098/8.0),
    REAL_CONST(8165.6523325975786/8.0),
    REAL_CONST(8178.3294552300049/8.0),
    REAL_CONST(8191.0114924291529/8.0),
    REAL_CONST(8203.6984403889655/8.0),
    REAL_CONST(8216.3902953107463/8.0),
    REAL_CONST(8229.0870534031419/8.0),
    REAL_CONST(8241.7887108821069/8.0),
    REAL_CONST(8254.4952639708936/8.0),
    REAL_CONST(8267.2067089000211/8.0),
    REAL_CONST(8279.9230419072574/8.0),
    REAL_CONST(8292.6442592375952/8.0),
    REAL_CONST(8305.3703571432306/8.0),
    REAL_CONST(8318.101331883543/8.0),
    REAL_CONST(8330.8371797250657/8.0),
    REAL_CONST(8343.577896941475/8.0),
    REAL_CONST(8356.3234798135582/8.0),
    REAL_CONST(8369.0739246291978/8.0),
    REAL_CONST(8381.8292276833508/8.0),
    REAL_CONST(8394.5893852780209/8.0),
    REAL_CONST(8407.3543937222421/8.0),
    REAL_CONST(8420.1242493320569/8.0),
    REAL_CONST(8432.8989484304948/8.0),
    REAL_CONST(8445.6784873475499/8.0),
    REAL_CONST(8458.4628624201578/8.0),
    REAL_CONST(8471.2520699921806/8.0),
    REAL_CONST(8484.0461064143838/8.0),
    REAL_CONST(8496.8449680444082/8.0),
    REAL_CONST(8509.6486512467636/8.0),
    REAL_CONST(8522.4571523927953/8.0),
    REAL_CONST(8535.270467860666/8.0),
    REAL_CONST(8548.0885940353437/8.0),
    REAL_CONST(8560.9115273085663/8.0),
    REAL_CONST(8573.7392640788403/8.0),
    REAL_CONST(8586.5718007514006/8.0),
    REAL_CONST(8599.4091337382069/8.0),
    REAL_CONST(8612.2512594579148/8.0),
    REAL_CONST(8625.0981743358552/8.0),
    REAL_CONST(8637.9498748040205/8.0),
    REAL_CONST(8650.8063573010386/8.0),
    REAL_CONST(8663.6676182721567/8.0),
    REAL_CONST(8676.533654169225/8.0),
    REAL_CONST(8689.4044614506638/8.0),
    REAL_CONST(8702.2800365814601/8.0),
    REAL_CONST(8715.1603760331418/8.0),
    REAL_CONST(8728.0454762837508/8.0),
    REAL_CONST(8740.9353338178389/8.0),
    REAL_CONST(8753.8299451264356/8.0),
    REAL_CONST(8766.7293067070332/8.0),
    REAL_CONST(8779.6334150635721/8.0),
    REAL_CONST(8792.5422667064158/8.0),
    REAL_CONST(8805.4558581523324/8.0),
    REAL_CONST(8818.3741859244819/8.0),
    REAL_CONST(8831.2972465523908/8.0),
    REAL_CONST(8844.2250365719356/8.0),
    REAL_CONST(8857.1575525253265/8.0),
    REAL_CONST(8870.0947909610859/8.0),
    REAL_CONST(8883.0367484340295/8.0),
    REAL_CONST(8895.9834215052524/8.0),
    REAL_CONST(8908.934806742107/8.0),
    REAL_CONST(8921.8909007181846/8.0),
    REAL_CONST(8934.8517000132997/8.0),
    REAL_CONST(8947.817201213471/8.0),
    REAL_CONST(8960.7874009109/8.0),
    REAL_CONST(8973.7622957039603/8.0),
    REAL_CONST(8986.7418821971733/8.0),
    REAL_CONST(8999.7261570011924/8.0),
    REAL_CONST(9012.7151167327884/8.0),
    REAL_CONST(9025.7087580148236/8.0),
    REAL_CONST(9038.7070774762469/8.0),
    REAL_CONST(9051.7100717520643/8.0),
    REAL_CONST(9064.7177374833282/8.0),
    REAL_CONST(9077.7300713171153/8.0),
    REAL_CONST(9090.7470699065179/8.0),
    REAL_CONST(9103.7687299106146/8.0),
    REAL_CONST(9116.7950479944648/8.0),
    REAL_CONST(9129.8260208290812/8.0),
    REAL_CONST(9142.8616450914233/8.0),
    REAL_CONST(9155.9019174643727/8.0),
    REAL_CONST(9168.9468346367157/8.0),
    REAL_CONST(9181.9963933031358/8.0),
    REAL_CONST(9195.0505901641845/8.0),
    REAL_CONST(9208.1094219262741/8.0),
    REAL_CONST(9221.1728853016557/8.0),
    REAL_CONST(9234.240977008405/8.0),
    REAL_CONST(9247.3136937704076/8.0),
    REAL_CONST(9260.3910323173386/8.0),
    REAL_CONST(9273.472989384647/8.0),
    REAL_CONST(9286.5595617135423/8.0),
    REAL_CONST(9299.6507460509747/8.0),
    REAL_CONST(9312.7465391496207/8.0),
    REAL_CONST(9325.8469377678684/8.0),
    REAL_CONST(9338.9519386698012/8.0),
    REAL_CONST(9352.0615386251757/8.0),
    REAL_CONST(9365.1757344094131/8.0),
    REAL_CONST(9378.2945228035842/8.0),
    REAL_CONST(9391.4179005943843/8.0),
    REAL_CONST(9404.5458645741273/8.0),
    REAL_CONST(9417.6784115407263/8.0),
    REAL_CONST(9430.8155382976747/8.0),
    REAL_CONST(9443.9572416540359/8.0),
    REAL_CONST(9457.1035184244265/8.0),
    REAL_CONST(9470.2543654290002/8.0),
    REAL_CONST(9483.4097794934296/8.0),
    REAL_CONST(9496.5697574488931/8.0),
    REAL_CONST(9509.7342961320664/8.0),
    REAL_CONST(9522.9033923850911/8.0),
    REAL_CONST(9536.0770430555804/8.0),
    REAL_CONST(9549.2552449965824/8.0),
    REAL_CONST(9562.4379950665825/8.0),
    REAL_CONST(9575.6252901294793/8.0),
    REAL_CONST(9588.8171270545736/8.0),
    REAL_CONST(9602.0135027165488/8.0),
    REAL_CONST(9615.2144139954635/8.0),
    REAL_CONST(9628.4198577767274/8.0),
    REAL_CONST(9641.629830951093/8.0),
    REAL_CONST(9654.844330414644/8.0),
    REAL_CONST(9668.0633530687719/8.0),
    REAL_CONST(9681.286895820167/8.0),
    REAL_CONST(9694.5149555808002/8.0),
    REAL_CONST(9707.7475292679192/8.0),
    REAL_CONST(9720.9846138040157/8.0),
    REAL_CONST(9734.2262061168276/8.0),
    REAL_CONST(9747.4723031393187/8.0),
    REAL_CONST(9760.7229018096641/8.0),
    REAL_CONST(9773.9779990712323/8.0),
    REAL_CONST(9787.2375918725811/8.0),
    REAL_CONST(9800.5016771674327/8.0),
    REAL_CONST(9813.7702519146696/8.0),
    REAL_CONST(9827.0433130783094/8.0),
    REAL_CONST(9840.3208576275028/8.0),
    REAL_CONST(9853.602882536512/8.0),
    REAL_CONST(9866.8893847846994/8.0),
    REAL_CONST(9880.1803613565116/8.0),
    REAL_CONST(9893.4758092414686/8.0),
    REAL_CONST(9906.7757254341523/8.0),
    REAL_CONST(9920.0801069341851/8.0),
    REAL_CONST(9933.3889507462245/8.0),
    REAL_CONST(9946.7022538799429/8.0),
    REAL_CONST(9960.0200133500221/8.0),
    REAL_CONST(9973.3422261761298/8.0),
    REAL_CONST(9986.6688893829159/8.0),
    REAL_CONST(9999.9999999999945/8.0),
    REAL_CONST(10013.335555061929/8.0),
    REAL_CONST(10026.675551608221/8.0),
    REAL_CONST(10040.019986683301/8.0),
    REAL_CONST(10053.368857336509/8.0),
    REAL_CONST(10066.722160622081/8.0),
    REAL_CONST(10080.079893599144/8.0),
    REAL_CONST(10093.442053331697/8.0),
    REAL_CONST(10106.808636888598/8.0),
    REAL_CONST(10120.179641343551/8.0),
    REAL_CONST(10133.555063775095/8.0),
    REAL_CONST(10146.934901266595/8.0),
    REAL_CONST(10160.31915090622/8.0),
    REAL_CONST(10173.707809786936/8.0),
    REAL_CONST(10187.100875006496/8.0),
    REAL_CONST(10200.498343667417/8.0),
    REAL_CONST(10213.900212876984/8.0),
    REAL_CONST(10227.306479747222/8.0),
    REAL_CONST(10240.717141394889/8.0),
    REAL_CONST(10254.132194941467/8.0),
    REAL_CONST(10267.551637513146/8.0),
    REAL_CONST(10280.975466240814/8.0),
    REAL_CONST(10294.40367826004/8.0),
    REAL_CONST(10307.836270711066/8.0),
    REAL_CONST(10321.273240738796/8.0),
    REAL_CONST(10334.71458549278/8.0)
#ifdef BIG_IQ_TABLE
   ,REAL_CONST(10348.160302127204/8.0),
    REAL_CONST(10361.610387800878/8.0),
    REAL_CONST(10375.064839677221/8.0),
    REAL_CONST(10388.523654924258/8.0),
    REAL_CONST(10401.986830714593/8.0),
    REAL_CONST(10415.454364225412/8.0),
    REAL_CONST(10428.926252638465/8.0),
    REAL_CONST(10442.402493140049/8.0),
    REAL_CONST(10455.883082921007/8.0),
    REAL_CONST(10469.368019176709/8.0),
    REAL_CONST(10482.85729910704/8.0),
    REAL_CONST(10496.350919916393/8.0),
    REAL_CONST(10509.848878813653/8.0),
    REAL_CONST(10523.351173012188/8.0),
    REAL_CONST(10536.857799729838/8.0),
    REAL_CONST(10550.3687561889/8.0),
    REAL_CONST(10563.884039616123/8.0),
    REAL_CONST(10577.403647242685/8.0),
    REAL_CONST(10590.927576304197/8.0),
    REAL_CONST(10604.455824040679/8.0),
    REAL_CONST(10617.988387696556/8.0),
    REAL_CONST(10631.525264520642/8.0),
    REAL_CONST(10645.066451766135/8.0),
    REAL_CONST(10658.611946690598/8.0),
    REAL_CONST(10672.161746555956/8.0),
    REAL_CONST(10685.715848628475/8.0),
    REAL_CONST(10699.274250178762/8.0),
    REAL_CONST(10712.836948481747/8.0),
    REAL_CONST(10726.403940816675/8.0),
    REAL_CONST(10739.975224467091/8.0),
    REAL_CONST(10753.550796720834/8.0),
    REAL_CONST(10767.130654870027/8.0),
    REAL_CONST(10780.714796211059/8.0),
    REAL_CONST(10794.303218044579/8.0),
    REAL_CONST(10807.895917675487/8.0),
    REAL_CONST(10821.492892412922/8.0),
    REAL_CONST(10835.094139570248/8.0),
    REAL_CONST(10848.699656465047/8.0),
    REAL_CONST(10862.309440419107/8.0),
    REAL_CONST(10875.923488758415/8.0),
    REAL_CONST(10889.541798813138/8.0),
    REAL_CONST(10903.16436791762/8.0),
    REAL_CONST(10916.791193410372/8.0),
    REAL_CONST(10930.422272634056/8.0),
    REAL_CONST(10944.05760293548/8.0),
    REAL_CONST(10957.697181665582/8.0),
    REAL_CONST(10971.341006179427/8.0),
    REAL_CONST(10984.98907383619/8.0),
    REAL_CONST(10998.641381999149/8.0),
    REAL_CONST(11012.297928035676/8.0),
    REAL_CONST(11025.958709317223/8.0),
    REAL_CONST(11039.623723219316/8.0),
    REAL_CONST(11053.292967121541/8.0),
    REAL_CONST(11066.966438407539/8.0),
    REAL_CONST(11080.64413446499/8.0),
    REAL_CONST(11094.326052685608/8.0),
    REAL_CONST(11108.012190465128/8.0),
    REAL_CONST(11121.702545203296/8.0),
    REAL_CONST(11135.397114303863/8.0),
    REAL_CONST(11149.095895174571/8.0),
    REAL_CONST(11162.798885227143/8.0),
    REAL_CONST(11176.506081877278/8.0),
    REAL_CONST(11190.217482544635/8.0),
    REAL_CONST(11203.933084652828/8.0),
    REAL_CONST(11217.652885629415/8.0),
    REAL_CONST(11231.376882905886/8.0),
    REAL_CONST(11245.105073917659/8.0),
    REAL_CONST(11258.837456104062/8.0),
    REAL_CONST(11272.574026908333/8.0),
    REAL_CONST(11286.314783777601/8.0),
    REAL_CONST(11300.059724162888/8.0),
    REAL_CONST(11313.808845519083/8.0),
    REAL_CONST(11327.562145304952/8.0),
    REAL_CONST(11341.319620983111/8.0),
    REAL_CONST(11355.081270020033/8.0),
    REAL_CONST(11368.847089886023/8.0),
    REAL_CONST(11382.617078055218/8.0),
    REAL_CONST(11396.391232005579/8.0),
    REAL_CONST(11410.169549218874/8.0),
    REAL_CONST(11423.952027180676/8.0),
    REAL_CONST(11437.738663380349/8.0),
    REAL_CONST(11451.529455311042/8.0),
    REAL_CONST(11465.324400469679/8.0),
    REAL_CONST(11479.123496356951/8.0),
    REAL_CONST(11492.926740477304/8.0),
    REAL_CONST(11506.734130338931/8.0),
    REAL_CONST(11520.545663453764/8.0),
    REAL_CONST(11534.361337337466/8.0),
    REAL_CONST(11548.181149509423/8.0),
    REAL_CONST(11562.005097492724/8.0),
    REAL_CONST(11575.83317881417/8.0),
    REAL_CONST(11589.665391004253/8.0),
    REAL_CONST(11603.501731597149/8.0),
    REAL_CONST(11617.342198130715/8.0),
    REAL_CONST(11631.186788146468/8.0),
    REAL_CONST(11645.035499189589/8.0),
    REAL_CONST(11658.888328808911/8.0),
    REAL_CONST(11672.745274556904/8.0),
    REAL_CONST(11686.606333989675/8.0),
    REAL_CONST(11700.471504666955/8.0),
    REAL_CONST(11714.340784152086/8.0),
    REAL_CONST(11728.214170012021/8.0),
    REAL_CONST(11742.091659817312/8.0),
    REAL_CONST(11755.973251142101/8.0),
    REAL_CONST(11769.858941564111/8.0),
    REAL_CONST(11783.748728664636/8.0),
    REAL_CONST(11797.642610028539/8.0),
    REAL_CONST(11811.540583244237/8.0),
    REAL_CONST(11825.442645903697/8.0),
    REAL_CONST(11839.34879560242/8.0),
    REAL_CONST(11853.259029939445/8.0),
    REAL_CONST(11867.173346517333/8.0),
    REAL_CONST(11881.091742942155/8.0),
    REAL_CONST(11895.014216823492/8.0),
    REAL_CONST(11908.940765774427/8.0),
    REAL_CONST(11922.871387411526/8.0),
    REAL_CONST(11936.806079354839/8.0),
    REAL_CONST(11950.744839227897/8.0),
    REAL_CONST(11964.687664657684/8.0),
    REAL_CONST(11978.634553274653/8.0),
    REAL_CONST(11992.585502712702/8.0),
    REAL_CONST(12006.540510609168/8.0),
    REAL_CONST(12020.499574604828/8.0),
    REAL_CONST(12034.462692343877/8.0),
    REAL_CONST(12048.429861473938/8.0),
    REAL_CONST(12062.401079646032/8.0),
    REAL_CONST(12076.376344514589/8.0),
    REAL_CONST(12090.355653737433/8.0),
    REAL_CONST(12104.339004975769/8.0),
    REAL_CONST(12118.326395894188/8.0),
    REAL_CONST(12132.317824160644/8.0),
    REAL_CONST(12146.313287446457/8.0),
    REAL_CONST(12160.312783426305/8.0),
    REAL_CONST(12174.316309778205/8.0),
    REAL_CONST(12188.323864183525/8.0),
    REAL_CONST(12202.335444326955/8.0),
    REAL_CONST(12216.351047896511/8.0),
    REAL_CONST(12230.370672583531/8.0),
    REAL_CONST(12244.394316082657/8.0),
    REAL_CONST(12258.421976091831/8.0),
    REAL_CONST(12272.453650312296/8.0),
    REAL_CONST(12286.489336448574/8.0),
    REAL_CONST(12300.529032208471/8.0),
    REAL_CONST(12314.572735303058/8.0),
    REAL_CONST(12328.620443446678/8.0),
    REAL_CONST(12342.672154356922/8.0),
    REAL_CONST(12356.727865754638/8.0),
    REAL_CONST(12370.787575363909/8.0),
    REAL_CONST(12384.851280912055/8.0),
    REAL_CONST(12398.918980129623/8.0),
    REAL_CONST(12412.990670750381/8.0),
    REAL_CONST(12427.066350511306/8.0),
    REAL_CONST(12441.146017152583/8.0),
    REAL_CONST(12455.229668417589/8.0),
    REAL_CONST(12469.317302052901/8.0),
    REAL_CONST(12483.40891580827/8.0),
    REAL_CONST(12497.50450743663/8.0),
    REAL_CONST(12511.604074694078/8.0),
    REAL_CONST(12525.707615339878/8.0),
    REAL_CONST(12539.815127136444/8.0),
    REAL_CONST(12553.926607849342/8.0),
    REAL_CONST(12568.042055247275/8.0),
    REAL_CONST(12582.161467102082/8.0),
    REAL_CONST(12596.284841188726/8.0),
    REAL_CONST(12610.41217528529/8.0),
    REAL_CONST(12624.543467172971/8.0),
    REAL_CONST(12638.678714636069/8.0),
    REAL_CONST(12652.817915461985/8.0),
    REAL_CONST(12666.961067441209/8.0),
    REAL_CONST(12681.108168367316/8.0),
    REAL_CONST(12695.259216036962/8.0),
    REAL_CONST(12709.414208249869/8.0),
    REAL_CONST(12723.573142808827/8.0),
    REAL_CONST(12737.736017519681/8.0),
    REAL_CONST(12751.902830191326/8.0),
    REAL_CONST(12766.073578635704/8.0),
    REAL_CONST(12780.248260667788/8.0),
    REAL_CONST(12794.426874105588/8.0),
    REAL_CONST(12808.609416770132/8.0),
    REAL_CONST(12822.795886485468/8.0),
    REAL_CONST(12836.986281078653/8.0),
    REAL_CONST(12851.180598379744/8.0),
    REAL_CONST(12865.378836221802/8.0),
    REAL_CONST(12879.580992440871/8.0),
    REAL_CONST(12893.787064875984/8.0),
    REAL_CONST(12907.997051369144/8.0),
    REAL_CONST(12922.210949765335/8.0),
    REAL_CONST(12936.428757912496/8.0),
    REAL_CONST(12950.650473661524/8.0),
    REAL_CONST(12964.876094866273/8.0),
    REAL_CONST(12979.105619383534/8.0),
    REAL_CONST(12993.339045073039/8.0),
    REAL_CONST(13007.576369797454/8.0),
    REAL_CONST(13021.817591422368/8.0),
    REAL_CONST(13036.062707816285/8.0),
    REAL_CONST(13050.311716850629/8.0),
    REAL_CONST(13064.564616399723/8.0),
    REAL_CONST(13078.821404340792/8.0),
    REAL_CONST(13093.082078553954/8.0),
    REAL_CONST(13107.346636922217/8.0),
    REAL_CONST(13121.615077331464/8.0),
    REAL_CONST(13135.887397670458/8.0),
    REAL_CONST(13150.163595830827/8.0),
    REAL_CONST(13164.44366970706/8.0),
    REAL_CONST(13178.727617196502/8.0),
    REAL_CONST(13193.015436199352/8.0),
    REAL_CONST(13207.307124618648/8.0),
    REAL_CONST(13221.602680360265/8.0),
    REAL_CONST(13235.902101332911/8.0),
    REAL_CONST(13250.205385448118/8.0),
    REAL_CONST(13264.512530620239/8.0),
    REAL_CONST(13278.823534766434/8.0),
    REAL_CONST(13293.138395806676/8.0),
    REAL_CONST(13307.457111663734/8.0),
    REAL_CONST(13321.779680263176/8.0),
    REAL_CONST(13336.106099533356/8.0),
    REAL_CONST(13350.436367405409/8.0),
    REAL_CONST(13364.77048181325/8.0),
    REAL_CONST(13379.108440693562/8.0),
    REAL_CONST(13393.450241985796/8.0),
    REAL_CONST(13407.795883632158/8.0),
    REAL_CONST(13422.145363577607/8.0),
    REAL_CONST(13436.498679769853/8.0),
    REAL_CONST(13450.855830159346/8.0),
    REAL_CONST(13465.216812699266/8.0),
    REAL_CONST(13479.581625345529/8.0),
    REAL_CONST(13493.950266056772/8.0),
    REAL_CONST(13508.32273279435/8.0),
    REAL_CONST(13522.699023522329/8.0),
    REAL_CONST(13537.079136207483/8.0),
    REAL_CONST(13551.463068819286/8.0),
    REAL_CONST(13565.850819329906/8.0),
    REAL_CONST(13580.2423857142/8.0),
    REAL_CONST(13594.63776594971/8.0),
    REAL_CONST(13609.036958016657/8.0),
    REAL_CONST(13623.439959897927/8.0),
    REAL_CONST(13637.846769579081/8.0),
    REAL_CONST(13652.257385048335/8.0),
    REAL_CONST(13666.67180429656/8.0),
    REAL_CONST(13681.090025317284/8.0),
    REAL_CONST(13695.512046106669/8.0),
    REAL_CONST(13709.937864663521/8.0),
    REAL_CONST(13724.367478989278/8.0),
    REAL_CONST(13738.800887088004/8.0),
    REAL_CONST(13753.238086966385/8.0),
    REAL_CONST(13767.679076633727/8.0),
    REAL_CONST(13782.123854101939/8.0),
    REAL_CONST(13796.572417385545/8.0),
    REAL_CONST(13811.024764501659/8.0),
    REAL_CONST(13825.480893469998/8.0),
    REAL_CONST(13839.94080231286/8.0),
    REAL_CONST(13854.404489055134/8.0),
    REAL_CONST(13868.871951724283/8.0),
    REAL_CONST(13883.34318835034/8.0),
    REAL_CONST(13897.818196965914/8.0),
    REAL_CONST(13912.296975606168/8.0),
    REAL_CONST(13926.779522308825/8.0),
    REAL_CONST(13941.26583511416/8.0),
    REAL_CONST(13955.755912064991/8.0),
    REAL_CONST(13970.249751206682/8.0),
    REAL_CONST(13984.747350587126/8.0),
    REAL_CONST(13999.248708256751/8.0),
    REAL_CONST(14013.753822268511/8.0),
    REAL_CONST(14028.262690677873/8.0),
    REAL_CONST(14042.775311542828/8.0),
    REAL_CONST(14057.291682923867/8.0),
    REAL_CONST(14071.811802883994/8.0),
    REAL_CONST(14086.335669488704/8.0),
    REAL_CONST(14100.863280805994/8.0),
    REAL_CONST(14115.394634906341/8.0),
    REAL_CONST(14129.92972986271/8.0),
    REAL_CONST(14144.468563750548/8.0),
    REAL_CONST(14159.01113464777/8.0),
    REAL_CONST(14173.55744063476/8.0),
    REAL_CONST(14188.107479794369/8.0),
    REAL_CONST(14202.661250211901/8.0),
    REAL_CONST(14217.218749975118/8.0),
    REAL_CONST(14231.779977174227/8.0),
    REAL_CONST(14246.344929901879/8.0),
    REAL_CONST(14260.913606253163/8.0),
    REAL_CONST(14275.486004325601/8.0),
    REAL_CONST(14290.062122219146/8.0),
    REAL_CONST(14304.641958036171/8.0),
    REAL_CONST(14319.225509881464/8.0),
    REAL_CONST(14333.812775862236/8.0),
    REAL_CONST(14348.403754088098/8.0),
    REAL_CONST(14362.998442671067/8.0),
    REAL_CONST(14377.59683972556/8.0),
    REAL_CONST(14392.198943368388/8.0),
    REAL_CONST(14406.804751718748/8.0),
    REAL_CONST(14421.414262898223/8.0),
    REAL_CONST(14436.027475030774/8.0),
    REAL_CONST(14450.64438624274/8.0),
    REAL_CONST(14465.264994662828/8.0),
    REAL_CONST(14479.889298422106/8.0),
    REAL_CONST(14494.517295654005/8.0),
    REAL_CONST(14509.148984494313/8.0),
    REAL_CONST(14523.784363081166/8.0),
    REAL_CONST(14538.423429555049/8.0),
    REAL_CONST(14553.066182058781/8.0),
    REAL_CONST(14567.712618737527/8.0),
    REAL_CONST(14582.362737738777/8.0),
    REAL_CONST(14597.016537212348/8.0),
    REAL_CONST(14611.674015310382/8.0),
    REAL_CONST(14626.33517018734/8.0),
    REAL_CONST(14640.999999999993/8.0),
    REAL_CONST(14655.668502907418/8.0),
    REAL_CONST(14670.340677071003/8.0),
    REAL_CONST(14685.016520654426/8.0),
    REAL_CONST(14699.696031823671/8.0),
    REAL_CONST(14714.379208746999/8.0),
    REAL_CONST(14729.066049594967/8.0),
    REAL_CONST(14743.756552540408/8.0),
    REAL_CONST(14758.45071575843/8.0),
    REAL_CONST(14773.148537426418/8.0),
    REAL_CONST(14787.850015724018/8.0),
    REAL_CONST(14802.555148833142/8.0),
    REAL_CONST(14817.263934937961/8.0),
    REAL_CONST(14831.976372224897/8.0),
    REAL_CONST(14846.692458882624/8.0),
    REAL_CONST(14861.41219310206/8.0),
    REAL_CONST(14876.135573076363/8.0),
    REAL_CONST(14890.862597000923/8.0),
    REAL_CONST(14905.593263073371/8.0),
    REAL_CONST(14920.327569493558/8.0),
    REAL_CONST(14935.065514463557/8.0),
    REAL_CONST(14949.807096187662/8.0),
    REAL_CONST(14964.552312872382/8.0),
    REAL_CONST(14979.301162726431/8.0),
    REAL_CONST(14994.053643960735/8.0),
    REAL_CONST(15008.809754788414/8.0),
    REAL_CONST(15023.569493424788/8.0),
    REAL_CONST(15038.332858087369/8.0),
    REAL_CONST(15053.099846995858/8.0),
    REAL_CONST(15067.870458372134/8.0),
    REAL_CONST(15082.644690440264/8.0),
    REAL_CONST(15097.422541426484/8.0),
    REAL_CONST(15112.204009559202/8.0),
    REAL_CONST(15126.989093068994/8.0),
    REAL_CONST(15141.777790188597/8.0),
    REAL_CONST(15156.570099152905/8.0),
    REAL_CONST(15171.366018198967/8.0),
    REAL_CONST(15186.165545565986/8.0),
    REAL_CONST(15200.968679495301/8.0),
    REAL_CONST(15215.775418230402/8.0),
    REAL_CONST(15230.585760016909/8.0),
    REAL_CONST(15245.399703102579/8.0),
    REAL_CONST(15260.217245737298/8.0),
    REAL_CONST(15275.038386173073/8.0),
    REAL_CONST(15289.863122664035/8.0),
    REAL_CONST(15304.691453466432/8.0),
    REAL_CONST(15319.523376838621/8.0),
    REAL_CONST(15334.358891041069/8.0),
    REAL_CONST(15349.197994336346/8.0),
    REAL_CONST(15364.040684989128/8.0),
    REAL_CONST(15378.886961266177/8.0),
    REAL_CONST(15393.736821436356/8.0),
    REAL_CONST(15408.590263770609/8.0),
    REAL_CONST(15423.447286541972/8.0),
    REAL_CONST(15438.307888025554/8.0),
    REAL_CONST(15453.172066498542/8.0),
    REAL_CONST(15468.039820240196/8.0),
    REAL_CONST(15482.91114753184/8.0),
    REAL_CONST(15497.786046656869/8.0),
    REAL_CONST(15512.664515900733/8.0),
    REAL_CONST(15527.546553550939/8.0),
    REAL_CONST(15542.432157897045/8.0),
    REAL_CONST(15557.32132723066/8.0),
    REAL_CONST(15572.214059845435/8.0),
    REAL_CONST(15587.110354037064/8.0),
    REAL_CONST(15602.010208103273/8.0),
    REAL_CONST(15616.913620343823/8.0),
    REAL_CONST(15631.820589060506/8.0),
    REAL_CONST(15646.731112557136/8.0),
    REAL_CONST(15661.645189139546/8.0),
    REAL_CONST(15676.562817115593/8.0),
    REAL_CONST(15691.483994795139/8.0),
    REAL_CONST(15706.408720490062/8.0),
    REAL_CONST(15721.336992514242/8.0),
    REAL_CONST(15736.268809183561/8.0),
    REAL_CONST(15751.204168815901/8.0),
    REAL_CONST(15766.143069731135/8.0),
    REAL_CONST(15781.085510251132/8.0),
    REAL_CONST(15796.03148869974/8.0),
    REAL_CONST(15810.981003402798/8.0),
    REAL_CONST(15825.934052688119/8.0),
    REAL_CONST(15840.890634885489/8.0),
    REAL_CONST(15855.850748326673/8.0),
    REAL_CONST(15870.814391345401/8.0),
    REAL_CONST(15885.781562277361/8.0),
    REAL_CONST(15900.752259460214/8.0),
    REAL_CONST(15915.726481233565/8.0),
    REAL_CONST(15930.704225938984/8.0),
    REAL_CONST(15945.685491919978/8.0),
    REAL_CONST(15960.670277522009/8.0),
    REAL_CONST(15975.658581092481/8.0),
    REAL_CONST(15990.65040098073/8.0),
    REAL_CONST(16005.645735538035/8.0),
    REAL_CONST(16020.644583117599/8.0),
    REAL_CONST(16035.646942074556/8.0),
    REAL_CONST(16050.652810765967/8.0),
    REAL_CONST(16065.662187550806/8.0),
    REAL_CONST(16080.675070789974/8.0),
    REAL_CONST(16095.691458846273/8.0),
    REAL_CONST(16110.711350084424/8.0),
    REAL_CONST(16125.734742871053/8.0),
    REAL_CONST(16140.761635574685/8.0),
    REAL_CONST(16155.792026565747/8.0),
    REAL_CONST(16170.825914216561/8.0),
    REAL_CONST(16185.863296901338/8.0),
    REAL_CONST(16200.904172996183/8.0),
    REAL_CONST(16215.948540879079/8.0),
    REAL_CONST(16230.996398929899/8.0),
    REAL_CONST(16246.047745530386/8.0),
    REAL_CONST(16261.102579064163/8.0),
    REAL_CONST(16276.160897916721/8.0),
    REAL_CONST(16291.22270047542/8.0),
    REAL_CONST(16306.287985129484/8.0),
    REAL_CONST(16321.356750269995/8.0),
    REAL_CONST(16336.428994289896/8.0),
    REAL_CONST(16351.504715583982/8.0),
    REAL_CONST(16366.5839125489/8.0),
    REAL_CONST(16381.666583583141/8.0),
    REAL_CONST(16396.752727087041/8.0),
    REAL_CONST(16411.842341462776/8.0),
    REAL_CONST(16426.935425114363/8.0),
    REAL_CONST(16442.031976447644/8.0),
    REAL_CONST(16457.131993870298/8.0),
    REAL_CONST(16472.235475791829/8.0),
    REAL_CONST(16487.342420623561/8.0),
    REAL_CONST(16502.452826778641/8.0),
    REAL_CONST(16517.566692672033/8.0),
    REAL_CONST(16532.684016720516/8.0),
    REAL_CONST(16547.804797342676/8.0),
    REAL_CONST(16562.929032958902/8.0),
    REAL_CONST(16578.056721991394/8.0),
    REAL_CONST(16593.18786286415/8.0),
    REAL_CONST(16608.322454002962/8.0),
    REAL_CONST(16623.460493835417/8.0),
    REAL_CONST(16638.601980790896/8.0),
    REAL_CONST(16653.746913300558/8.0),
    REAL_CONST(16668.895289797354/8.0),
    REAL_CONST(16684.047108716015/8.0),
    REAL_CONST(16699.202368493046/8.0),
    REAL_CONST(16714.361067566726/8.0),
    REAL_CONST(16729.523204377107/8.0),
    REAL_CONST(16744.688777366009/8.0),
    REAL_CONST(16759.857784977012/8.0),
    REAL_CONST(16775.030225655464/8.0),
    REAL_CONST(16790.206097848466/8.0),
    REAL_CONST(16805.385400004874/8.0),
    REAL_CONST(16820.568130575302/8.0),
    REAL_CONST(16835.754288012104/8.0),
    REAL_CONST(16850.943870769381/8.0),
    REAL_CONST(16866.136877302983/8.0),
    REAL_CONST(16881.333306070494/8.0),
    REAL_CONST(16896.53315553123/8.0),
    REAL_CONST(16911.736424146249/8.0),
    REAL_CONST(16926.943110378332/8.0),
    REAL_CONST(16942.153212691992/8.0),
    REAL_CONST(16957.366729553454/8.0),
    REAL_CONST(16972.583659430682/8.0),
    REAL_CONST(16987.804000793338/8.0),
    REAL_CONST(17003.027752112816/8.0),
    REAL_CONST(17018.254911862205/8.0),
    REAL_CONST(17033.485478516312/8.0),
    REAL_CONST(17048.719450551645/8.0),
    REAL_CONST(17063.956826446421/8.0),
    REAL_CONST(17079.197604680547/8.0),
    REAL_CONST(17094.44178373563/8.0),
    REAL_CONST(17109.689362094967/8.0),
    REAL_CONST(17124.940338243552/8.0),
    REAL_CONST(17140.194710668064/8.0),
    REAL_CONST(17155.452477856852/8.0),
    REAL_CONST(17170.713638299967/8.0),
    REAL_CONST(17185.978190489128/8.0),
    REAL_CONST(17201.246132917724/8.0),
    REAL_CONST(17216.517464080825/8.0),
    REAL_CONST(17231.792182475165/8.0),
    REAL_CONST(17247.070286599141/8.0),
    REAL_CONST(17262.351774952826/8.0),
    REAL_CONST(17277.636646037936/8.0),
    REAL_CONST(17292.924898357855/8.0),
    REAL_CONST(17308.216530417623/8.0),
    REAL_CONST(17323.511540723921/8.0),
    REAL_CONST(17338.809927785089/8.0),
    REAL_CONST(17354.111690111105/8.0),
    REAL_CONST(17369.416826213594/8.0),
    REAL_CONST(17384.725334605821/8.0),
    REAL_CONST(17400.037213802683/8.0),
    REAL_CONST(17415.352462320716/8.0),
    REAL_CONST(17430.67107867809/8.0),
    REAL_CONST(17445.993061394587/8.0),
    REAL_CONST(17461.318408991636/8.0),
    REAL_CONST(17476.647119992274/8.0),
    REAL_CONST(17491.979192921168/8.0),
    REAL_CONST(17507.314626304586/8.0),
    REAL_CONST(17522.653418670423/8.0),
    REAL_CONST(17537.995568548187/8.0),
    REAL_CONST(17553.341074468986/8.0),
    REAL_CONST(17568.689934965536/8.0),
    REAL_CONST(17584.042148572156/8.0),
    REAL_CONST(17599.397713824768/8.0),
    REAL_CONST(17614.75662926089/8.0),
    REAL_CONST(17630.118893419625/8.0),
    REAL_CONST(17645.484504841683/8.0),
    REAL_CONST(17660.853462069354/8.0),
    REAL_CONST(17676.225763646511/8.0),
    REAL_CONST(17691.601408118619/8.0),
    REAL_CONST(17706.980394032718/8.0),
    REAL_CONST(17722.362719937424/8.0),
    REAL_CONST(17737.748384382936/8.0),
    REAL_CONST(17753.137385921014/8.0),
    REAL_CONST(17768.529723104999/8.0),
    REAL_CONST(17783.92539448979/8.0),
    REAL_CONST(17799.324398631856/8.0),
    REAL_CONST(17814.726734089225/8.0),
    REAL_CONST(17830.13239942148/8.0),
    REAL_CONST(17845.541393189767/8.0),
    REAL_CONST(17860.95371395678/8.0),
    REAL_CONST(17876.369360286772/8.0),
    REAL_CONST(17891.788330745527/8.0),
    REAL_CONST(17907.210623900395/8.0),
    REAL_CONST(17922.636238320254/8.0),
    REAL_CONST(17938.065172575527/8.0),
    REAL_CONST(17953.497425238176/8.0),
    REAL_CONST(17968.932994881692/8.0),
    REAL_CONST(17984.371880081104/8.0),
    REAL_CONST(17999.814079412972/8.0),
    REAL_CONST(18015.259591455371/8.0),
    REAL_CONST(18030.708414787914/8.0),
    REAL_CONST(18046.160547991731/8.0),
    REAL_CONST(18061.615989649465/8.0),
    REAL_CONST(18077.074738345284/8.0),
    REAL_CONST(18092.536792664861/8.0),
    REAL_CONST(18108.002151195393/8.0),
    REAL_CONST(18123.470812525571/8.0),
    REAL_CONST(18138.942775245599/8.0),
    REAL_CONST(18154.418037947191/8.0),
    REAL_CONST(18169.896599223546/8.0),
    REAL_CONST(18185.37845766938/8.0),
    REAL_CONST(18200.863611880886/8.0),
    REAL_CONST(18216.352060455767/8.0),
    REAL_CONST(18231.843801993204/8.0),
    REAL_CONST(18247.338835093873/8.0),
    REAL_CONST(18262.837158359936/8.0),
    REAL_CONST(18278.338770395032/8.0),
    REAL_CONST(18293.84366980429/8.0),
    REAL_CONST(18309.351855194309/8.0),
    REAL_CONST(18324.863325173166/8.0),
    REAL_CONST(18340.378078350412/8.0),
    REAL_CONST(18355.896113337069/8.0),
    REAL_CONST(18371.417428745623/8.0),
    REAL_CONST(18386.942023190033/8.0),
    REAL_CONST(18402.469895285718/8.0),
    REAL_CONST(18418.00104364955/8.0),
    REAL_CONST(18433.53546689987/8.0),
    REAL_CONST(18449.073163656474/8.0),
    REAL_CONST(18464.614132540602/8.0),
    REAL_CONST(18480.158372174956/8.0),
    REAL_CONST(18495.705881183676/8.0),
    REAL_CONST(18511.256658192357/8.0),
    REAL_CONST(18526.810701828035/8.0),
    REAL_CONST(18542.368010719183/8.0),
    REAL_CONST(18557.928583495715/8.0),
    REAL_CONST(18573.492418788985/8.0),
    REAL_CONST(18589.059515231773/8.0),
    REAL_CONST(18604.629871458303/8.0),
    REAL_CONST(18620.203486104212/8.0),
    REAL_CONST(18635.78035780658/8.0),
    REAL_CONST(18651.360485203899/8.0),
    REAL_CONST(18666.943866936086/8.0),
    REAL_CONST(18682.53050164448/8.0),
    REAL_CONST(18698.120387971841/8.0),
    REAL_CONST(18713.713524562332/8.0),
    REAL_CONST(18729.30991006154/8.0),
    REAL_CONST(18744.909543116457/8.0),
    REAL_CONST(18760.512422375479/8.0),
    REAL_CONST(18776.118546488418/8.0),
    REAL_CONST(18791.727914106479/8.0),
    REAL_CONST(18807.340523882274/8.0),
    REAL_CONST(18822.95637446981/8.0),
    REAL_CONST(18838.575464524489/8.0),
    REAL_CONST(18854.197792703111/8.0),
    REAL_CONST(18869.823357663863/8.0),
    REAL_CONST(18885.452158066328/8.0),
    REAL_CONST(18901.08419257147/8.0),
    REAL_CONST(18916.719459841639/8.0),
    REAL_CONST(18932.357958540564/8.0),
    REAL_CONST(18947.999687333362/8.0),
    REAL_CONST(18963.644644886521/8.0),
    REAL_CONST(18979.292829867907/8.0),
    REAL_CONST(18994.944240946759/8.0),
    REAL_CONST(19010.598876793687/8.0),
    REAL_CONST(19026.256736080668/8.0),
    REAL_CONST(19041.917817481048/8.0),
    REAL_CONST(19057.582119669532/8.0),
    REAL_CONST(19073.2496413222/8.0),
    REAL_CONST(19088.920381116473/8.0),
    REAL_CONST(19104.594337731145/8.0),
    REAL_CONST(19120.271509846356/8.0),
    REAL_CONST(19135.951896143604/8.0),
    REAL_CONST(19151.635495305738/8.0),
    REAL_CONST(19167.322306016948/8.0),
    REAL_CONST(19183.012326962784/8.0),
    REAL_CONST(19198.705556830122/8.0),
    REAL_CONST(19214.401994307198/8.0),
    REAL_CONST(19230.101638083579/8.0),
    REAL_CONST(19245.804486850167/8.0),
    REAL_CONST(19261.510539299208/8.0),
    REAL_CONST(19277.219794124274/8.0),
    REAL_CONST(19292.932250020265/8.0),
    REAL_CONST(19308.647905683421/8.0),
    REAL_CONST(19324.366759811302/8.0),
    REAL_CONST(19340.088811102793/8.0),
    REAL_CONST(19355.8140582581/8.0),
    REAL_CONST(19371.542499978754/8.0),
    REAL_CONST(19387.2741349676/8.0),
    REAL_CONST(19403.008961928797/8.0),
    REAL_CONST(19418.746979567823/8.0),
    REAL_CONST(19434.488186591469/8.0),
    REAL_CONST(19450.232581707827/8.0),
    REAL_CONST(19465.980163626304/8.0),
    REAL_CONST(19481.730931057613/8.0),
    REAL_CONST(19497.484882713761/8.0),
    REAL_CONST(19513.242017308068/8.0),
    REAL_CONST(19529.002333555141/8.0),
    REAL_CONST(19544.765830170898/8.0),
    REAL_CONST(19560.532505872539/8.0),
    REAL_CONST(19576.302359378566/8.0),
    REAL_CONST(19592.075389408761/8.0),
    REAL_CONST(19607.851594684209/8.0),
    REAL_CONST(19623.630973927269/8.0),
    REAL_CONST(19639.41352586159/8.0),
    REAL_CONST(19655.199249212103/8.0),
    REAL_CONST(19670.988142705017/8.0),
    REAL_CONST(19686.780205067826/8.0),
    REAL_CONST(19702.575435029288/8.0),
    REAL_CONST(19718.373831319448/8.0),
    REAL_CONST(19734.175392669615/8.0),
    REAL_CONST(19749.980117812371/8.0),
    REAL_CONST(19765.788005481569/8.0),
    REAL_CONST(19781.599054412323/8.0),
    REAL_CONST(19797.413263341008/8.0),
    REAL_CONST(19813.230631005274/8.0),
    REAL_CONST(19829.051156144014/8.0),
    REAL_CONST(19844.874837497395/8.0),
    REAL_CONST(19860.701673806827/8.0),
    REAL_CONST(19876.531663814985/8.0),
    REAL_CONST(19892.364806265789/8.0),
    REAL_CONST(19908.201099904403/8.0),
    REAL_CONST(19924.040543477258/8.0),
    REAL_CONST(19939.883135732012/8.0),
    REAL_CONST(19955.728875417579/8.0),
    REAL_CONST(19971.577761284105/8.0),
    REAL_CONST(19987.429792082985/8.0),
    REAL_CONST(20003.284966566847/8.0),
    REAL_CONST(20019.14328348956/8.0),
    REAL_CONST(20035.004741606219/8.0),
    REAL_CONST(20050.869339673161/8.0),
    REAL_CONST(20066.737076447946/8.0),
    REAL_CONST(20082.607950689362/8.0),
    REAL_CONST(20098.481961157428/8.0),
    REAL_CONST(20114.359106613385/8.0),
    REAL_CONST(20130.239385819699/8.0),
    REAL_CONST(20146.122797540058/8.0),
    REAL_CONST(20162.009340539353/8.0),
    REAL_CONST(20177.899013583716/8.0),
    REAL_CONST(20193.791815440476/8.0),
    REAL_CONST(20209.687744878182/8.0),
    REAL_CONST(20225.586800666591/8.0),
    REAL_CONST(20241.488981576669/8.0),
    REAL_CONST(20257.394286380597/8.0),
    REAL_CONST(20273.302713851754/8.0),
    REAL_CONST(20289.214262764715/8.0),
    REAL_CONST(20305.128931895277/8.0),
    REAL_CONST(20321.046720020415/8.0),
    REAL_CONST(20336.967625918318/8.0),
    REAL_CONST(20352.891648368361/8.0),
    REAL_CONST(20368.818786151114/8.0),
    REAL_CONST(20384.749038048347/8.0),
    REAL_CONST(20400.682402843009/8.0),
    REAL_CONST(20416.618879319249/8.0),
    REAL_CONST(20432.558466262391/8.0),
    REAL_CONST(20448.501162458953/8.0),
    REAL_CONST(20464.446966696629/8.0),
    REAL_CONST(20480.395877764302/8.0),
    REAL_CONST(20496.347894452025/8.0),
    REAL_CONST(20512.303015551031/8.0),
    REAL_CONST(20528.261239853735/8.0),
    REAL_CONST(20544.22256615372/8.0),
    REAL_CONST(20560.186993245738/8.0),
    REAL_CONST(20576.15451992572/8.0),
    REAL_CONST(20592.125144990758/8.0),
    REAL_CONST(20608.098867239107/8.0),
    REAL_CONST(20624.075685470198/8.0),
    REAL_CONST(20640.055598484618/8.0),
    REAL_CONST(20656.038605084115/8.0),
    REAL_CONST(20672.024704071595/8.0),
    REAL_CONST(20688.013894251126/8.0),
    REAL_CONST(20704.006174427926/8.0),
    REAL_CONST(20720.001543408373/8.0),
    REAL_CONST(20735.999999999989/8.0),
    REAL_CONST(20752.001543011454/8.0),
    REAL_CONST(20768.006171252597/8.0),
    REAL_CONST(20784.013883534382/8.0),
    REAL_CONST(20800.024678668931/8.0),
    REAL_CONST(20816.038555469506/8.0),
    REAL_CONST(20832.055512750507/8.0),
    REAL_CONST(20848.075549327474/8.0),
    REAL_CONST(20864.098664017085/8.0),
    REAL_CONST(20880.124855637161/8.0),
    REAL_CONST(20896.154123006647/8.0),
    REAL_CONST(20912.186464945626/8.0),
    REAL_CONST(20928.221880275312/8.0),
    REAL_CONST(20944.260367818049/8.0),
    REAL_CONST(20960.301926397311/8.0),
    REAL_CONST(20976.346554837684/8.0),
    REAL_CONST(20992.394251964895/8.0),
    REAL_CONST(21008.445016605787/8.0),
    REAL_CONST(21024.498847588318/8.0),
    REAL_CONST(21040.555743741574/8.0),
    REAL_CONST(21056.615703895754/8.0),
    REAL_CONST(21072.678726882168/8.0),
    REAL_CONST(21088.744811533252/8.0),
    REAL_CONST(21104.813956682538/8.0),
    REAL_CONST(21120.886161164683/8.0),
    REAL_CONST(21136.961423815443/8.0),
    REAL_CONST(21153.039743471683/8.0),
    REAL_CONST(21169.121118971379/8.0),
    REAL_CONST(21185.205549153605/8.0),
    REAL_CONST(21201.293032858535/8.0),
    REAL_CONST(21217.383568927453/8.0),
    REAL_CONST(21233.477156202731/8.0),
    REAL_CONST(21249.573793527841/8.0),
    REAL_CONST(21265.673479747358/8.0),
    REAL_CONST(21281.776213706937/8.0),
    REAL_CONST(21297.881994253334/8.0),
    REAL_CONST(21313.990820234398/8.0),
    REAL_CONST(21330.102690499054/8.0),
    REAL_CONST(21346.21760389733/8.0),
    REAL_CONST(21362.335559280327/8.0),
    REAL_CONST(21378.456555500241/8.0),
    REAL_CONST(21394.580591410333/8.0),
    REAL_CONST(21410.707665864964/8.0),
    REAL_CONST(21426.83777771956/8.0),
    REAL_CONST(21442.970925830628/8.0),
    REAL_CONST(21459.107109055756/8.0),
    REAL_CONST(21475.246326253604/8.0),
    REAL_CONST(21491.388576283895/8.0),
    REAL_CONST(21507.533858007431/8.0),
    REAL_CONST(21523.682170286087/8.0),
    REAL_CONST(21539.833511982797/8.0),
    REAL_CONST(21555.987881961566/8.0),
    REAL_CONST(21572.145279087465/8.0),
    REAL_CONST(21588.305702226615/8.0),
    REAL_CONST(21604.469150246216/8.0),
    REAL_CONST(21620.635622014521/8.0),
    REAL_CONST(21636.805116400832/8.0),
    REAL_CONST(21652.977632275521/8.0),
    REAL_CONST(21669.153168510009/8.0),
    REAL_CONST(21685.331723976764/8.0),
    REAL_CONST(21701.513297549318/8.0),
    REAL_CONST(21717.697888102244/8.0),
    REAL_CONST(21733.885494511167/8.0),
    REAL_CONST(21750.076115652759/8.0),
    REAL_CONST(21766.269750404736/8.0),
    REAL_CONST(21782.466397645861/8.0),
    REAL_CONST(21798.666056255934/8.0),
    REAL_CONST(21814.868725115801/8.0),
    REAL_CONST(21831.074403107345/8.0),
    REAL_CONST(21847.283089113484/8.0),
    REAL_CONST(21863.494782018177/8.0),
    REAL_CONST(21879.709480706417/8.0),
    REAL_CONST(21895.927184064229/8.0),
    REAL_CONST(21912.147890978667/8.0),
    REAL_CONST(21928.371600337818/8.0),
    REAL_CONST(21944.598311030797/8.0),
    REAL_CONST(21960.828021947746/8.0),
    REAL_CONST(21977.060731979829/8.0),
    REAL_CONST(21993.296440019243/8.0),
    REAL_CONST(22009.535144959198/8.0),
    REAL_CONST(22025.77684569393/8.0),
    REAL_CONST(22042.021541118691/8.0),
    REAL_CONST(22058.269230129757/8.0),
    REAL_CONST(22074.519911624411/8.0),
    REAL_CONST(22090.773584500959/8.0),
    REAL_CONST(22107.030247658717/8.0),
    REAL_CONST(22123.289899998013/8.0),
    REAL_CONST(22139.552540420187/8.0),
    REAL_CONST(22155.818167827587/8.0),
    REAL_CONST(22172.086781123569/8.0),
    REAL_CONST(22188.358379212495/8.0),
    REAL_CONST(22204.632960999726/8.0),
    REAL_CONST(22220.910525391639/8.0),
    REAL_CONST(22237.191071295601/8.0),
    REAL_CONST(22253.474597619981/8.0),
    REAL_CONST(22269.761103274148/8.0),
    REAL_CONST(22286.050587168469/8.0),
    REAL_CONST(22302.343048214312/8.0),
    REAL_CONST(22318.638485324027/8.0),
    REAL_CONST(22334.936897410968/8.0),
    REAL_CONST(22351.23828338947/8.0),
    REAL_CONST(22367.542642174871/8.0),
    REAL_CONST(22383.849972683485/8.0),
    REAL_CONST(22400.160273832618/8.0),
    REAL_CONST(22416.473544540564/8.0),
    REAL_CONST(22432.789783726603/8.0),
    REAL_CONST(22449.108990310986/8.0),
    REAL_CONST(22465.431163214958/8.0),
    REAL_CONST(22481.75630136074/8.0),
    REAL_CONST(22498.084403671528/8.0),
    REAL_CONST(22514.415469071497/8.0),
    REAL_CONST(22530.749496485802/8.0),
    REAL_CONST(22547.086484840562/8.0),
    REAL_CONST(22563.426433062879/8.0),
    REAL_CONST(22579.769340080824/8.0),
    REAL_CONST(22596.115204823436/8.0),
    REAL_CONST(22612.464026220721/8.0),
    REAL_CONST(22628.815803203655/8.0),
    REAL_CONST(22645.170534704179/8.0),
    REAL_CONST(22661.5282196552/8.0),
    REAL_CONST(22677.888856990587/8.0),
    REAL_CONST(22694.252445645168/8.0),
    REAL_CONST(22710.618984554734/8.0),
    REAL_CONST(22726.988472656034/8.0),
    REAL_CONST(22743.360908886778/8.0),
    REAL_CONST(22759.736292185622/8.0),
    REAL_CONST(22776.114621492186/8.0),
    REAL_CONST(22792.495895747044/8.0),
    REAL_CONST(22808.880113891719/8.0),
    REAL_CONST(22825.267274868678/8.0),
    REAL_CONST(22841.657377621348/8.0),
    REAL_CONST(22858.050421094096/8.0),
    REAL_CONST(22874.446404232243/8.0),
    REAL_CONST(22890.845325982053/8.0),
    REAL_CONST(22907.247185290722/8.0),
    REAL_CONST(22923.651981106406/8.0),
    REAL_CONST(22940.059712378195/8.0),
    REAL_CONST(22956.470378056114/8.0),
    REAL_CONST(22972.883977091129/8.0),
    REAL_CONST(22989.300508435153/8.0),
    REAL_CONST(23005.719971041017/8.0),
    REAL_CONST(23022.142363862498/8.0),
    REAL_CONST(23038.567685854305/8.0),
    REAL_CONST(23054.995935972078/8.0),
    REAL_CONST(23071.427113172387/8.0),
    REAL_CONST(23087.86121641273/8.0),
    REAL_CONST(23104.298244651531/8.0),
    REAL_CONST(23120.738196848146/8.0),
    REAL_CONST(23137.181071962848/8.0),
    REAL_CONST(23153.626868956846/8.0),
    REAL_CONST(23170.075586792263/8.0),
    REAL_CONST(23186.527224432142/8.0),
    REAL_CONST(23202.981780840448/8.0),
    REAL_CONST(23219.439254982066/8.0),
    REAL_CONST(23235.899645822796/8.0),
    REAL_CONST(23252.362952329357/8.0),
    REAL_CONST(23268.829173469378/8.0),
    REAL_CONST(23285.298308211408/8.0),
    REAL_CONST(23301.770355524899/8.0),
    REAL_CONST(23318.245314380223/8.0),
    REAL_CONST(23334.723183748658/8.0),
    REAL_CONST(23351.203962602387/8.0),
    REAL_CONST(23367.687649914504/8.0),
    REAL_CONST(23384.174244659007/8.0),
    REAL_CONST(23400.663745810798/8.0),
    REAL_CONST(23417.15615234568/8.0),
    REAL_CONST(23433.651463240367/8.0),
    REAL_CONST(23450.149677472462/8.0),
    REAL_CONST(23466.650794020472/8.0),
    REAL_CONST(23483.154811863806/8.0),
    REAL_CONST(23499.661729982763/8.0),
    REAL_CONST(23516.171547358543/8.0),
    REAL_CONST(23532.684262973235/8.0),
    REAL_CONST(23549.199875809823/8.0),
    REAL_CONST(23565.718384852185/8.0),
    REAL_CONST(23582.239789085092/8.0),
    REAL_CONST(23598.764087494197/8.0),
    REAL_CONST(23615.291279066041/8.0),
    REAL_CONST(23631.821362788058/8.0),
    REAL_CONST(23648.354337648565/8.0),
    REAL_CONST(23664.890202636761/8.0),
    REAL_CONST(23681.428956742733/8.0),
    REAL_CONST(23697.970598957443/8.0),
    REAL_CONST(23714.515128272738/8.0),
    REAL_CONST(23731.062543681343/8.0),
    REAL_CONST(23747.612844176863/8.0),
    REAL_CONST(23764.166028753778/8.0),
    REAL_CONST(23780.72209640744/8.0),
    REAL_CONST(23797.281046134085/8.0),
    REAL_CONST(23813.842876930816/8.0),
    REAL_CONST(23830.407587795606/8.0),
    REAL_CONST(23846.975177727301/8.0),
    REAL_CONST(23863.545645725622/8.0),
    REAL_CONST(23880.11899079115/8.0),
    REAL_CONST(23896.695211925336/8.0),
    REAL_CONST(23913.274308130498/8.0),
    REAL_CONST(23929.856278409821/8.0),
    REAL_CONST(23946.441121767348/8.0),
    REAL_CONST(23963.028837207989/8.0),
    REAL_CONST(23979.619423737513/8.0),
    REAL_CONST(23996.212880362549/8.0),
    REAL_CONST(24012.809206090584/8.0),
    REAL_CONST(24029.408399929966/8.0),
    REAL_CONST(24046.010460889898/8.0),
    REAL_CONST(24062.615387980433/8.0),
    REAL_CONST(24079.223180212492/8.0),
    REAL_CONST(24095.833836597827/8.0),
    REAL_CONST(24112.447356149063/8.0),
    REAL_CONST(24129.063737879667/8.0),
    REAL_CONST(24145.682980803951/8.0),
    REAL_CONST(24162.305083937081/8.0),
    REAL_CONST(24178.930046295067/8.0),
    REAL_CONST(24195.557866894767/8.0),
    REAL_CONST(24212.188544753884/8.0),
    REAL_CONST(24228.822078890964/8.0),
    REAL_CONST(24245.458468325389/8.0),
    REAL_CONST(24262.097712077397/8.0),
    REAL_CONST(24278.739809168052/8.0),
    REAL_CONST(24295.384758619261/8.0),
    REAL_CONST(24312.032559453768/8.0),
    REAL_CONST(24328.683210695162/8.0),
    REAL_CONST(24345.336711367858/8.0),
    REAL_CONST(24361.993060497109/8.0),
    REAL_CONST(24378.652257108995/8.0),
    REAL_CONST(24395.314300230442/8.0),
    REAL_CONST(24411.979188889192/8.0),
    REAL_CONST(24428.646922113825/8.0),
    REAL_CONST(24445.317498933746/8.0),
    REAL_CONST(24461.990918379193/8.0),
    REAL_CONST(24478.667179481225/8.0),
    REAL_CONST(24495.346281271726/8.0),
    REAL_CONST(24512.028222783407/8.0),
    REAL_CONST(24528.713003049801/8.0),
    REAL_CONST(24545.400621105266/8.0),
    REAL_CONST(24562.091075984976/8.0),
    REAL_CONST(24578.784366724925/8.0),
    REAL_CONST(24595.480492361927/8.0),
    REAL_CONST(24612.179451933614/8.0),
    REAL_CONST(24628.881244478438/8.0),
    REAL_CONST(24645.585869035654/8.0),
    REAL_CONST(24662.293324645343/8.0),
    REAL_CONST(24679.003610348394/8.0),
    REAL_CONST(24695.716725186514/8.0),
    REAL_CONST(24712.432668202211/8.0),
    REAL_CONST(24729.151438438807/8.0),
    REAL_CONST(24745.873034940436/8.0),
    REAL_CONST(24762.597456752032/8.0),
    REAL_CONST(24779.324702919344/8.0),
    REAL_CONST(24796.054772488926/8.0),
    REAL_CONST(24812.787664508123/8.0),
    REAL_CONST(24829.5233780251/8.0),
    REAL_CONST(24846.261912088819/8.0),
    REAL_CONST(24863.003265749034/8.0),
    REAL_CONST(24879.747438056307/8.0),
    REAL_CONST(24896.494428062004/8.0),
    REAL_CONST(24913.244234818278/8.0),
    REAL_CONST(24929.996857378079/8.0),
    REAL_CONST(24946.752294795166/8.0),
    REAL_CONST(24963.510546124078/8.0),
    REAL_CONST(24980.271610420157/8.0),
    REAL_CONST(24997.035486739525/8.0),
    REAL_CONST(25013.802174139113/8.0),
    REAL_CONST(25030.571671676629/8.0),
    REAL_CONST(25047.343978410572/8.0),
    REAL_CONST(25064.119093400237/8.0),
    REAL_CONST(25080.897015705697/8.0),
    REAL_CONST(25097.677744387816/8.0),
    REAL_CONST(25114.461278508239/8.0),
    REAL_CONST(25131.2476171294/8.0),
    REAL_CONST(25148.036759314517/8.0),
    REAL_CONST(25164.828704127583/8.0),
    REAL_CONST(25181.623450633375/8.0),
    REAL_CONST(25198.42099789745/8.0),
    REAL_CONST(25215.221344986145/8.0),
    REAL_CONST(25232.024490966574/8.0),
    REAL_CONST(25248.830434906627/8.0),
    REAL_CONST(25265.639175874974/8.0),
    REAL_CONST(25282.450712941049/8.0),
    REAL_CONST(25299.265045175071/8.0),
    REAL_CONST(25316.082171648024/8.0),
    REAL_CONST(25332.902091431668/8.0),
    REAL_CONST(25349.724803598532/8.0),
    REAL_CONST(25366.550307221914/8.0),
    REAL_CONST(25383.378601375884/8.0),
    REAL_CONST(25400.209685135269/8.0),
    REAL_CONST(25417.043557575678/8.0),
    REAL_CONST(25433.880217773472/8.0),
    REAL_CONST(25450.719664805783/8.0),
    REAL_CONST(25467.561897750507/8.0),
    REAL_CONST(25484.406915686297/8.0),
    REAL_CONST(25501.254717692573/8.0),
    REAL_CONST(25518.105302849512/8.0),
    REAL_CONST(25534.958670238051/8.0),
    REAL_CONST(25551.814818939893/8.0),
    REAL_CONST(25568.67374803748/8.0),
    REAL_CONST(25585.535456614027/8.0),
    REAL_CONST(25602.399943753502/8.0),
    REAL_CONST(25619.267208540619/8.0),
    REAL_CONST(25636.137250060852/8.0),
    REAL_CONST(25653.010067400432/8.0),
    REAL_CONST(25669.885659646327/8.0),
    REAL_CONST(25686.76402588627/8.0),
    REAL_CONST(25703.645165208734/8.0),
    REAL_CONST(25720.529076702944/8.0),
    REAL_CONST(25737.415759458876/8.0),
    REAL_CONST(25754.305212567244/8.0),
    REAL_CONST(25771.197435119517/8.0),
    REAL_CONST(25788.092426207899/8.0),
    REAL_CONST(25804.990184925344/8.0),
    REAL_CONST(25821.890710365547/8.0),
    REAL_CONST(25838.794001622944/8.0),
    REAL_CONST(25855.700057792714/8.0),
    REAL_CONST(25872.608877970775/8.0),
    REAL_CONST(25889.520461253778/8.0),
    REAL_CONST(25906.434806739118/8.0),
    REAL_CONST(25923.351913524923/8.0),
    REAL_CONST(25940.271780710063/8.0),
    REAL_CONST(25957.194407394138/8.0),
    REAL_CONST(25974.11979267748/8.0),
    REAL_CONST(25991.047935661154/8.0),
    REAL_CONST(26007.978835446964/8.0),
    REAL_CONST(26024.912491137442/8.0),
    REAL_CONST(26041.848901835841/8.0),
    REAL_CONST(26058.788066646157/8.0),
    REAL_CONST(26075.729984673108/8.0),
    REAL_CONST(26092.674655022136/8.0),
    REAL_CONST(26109.622076799409/8.0),
    REAL_CONST(26126.572249111829/8.0),
    REAL_CONST(26143.525171067016/8.0),
    REAL_CONST(26160.480841773315/8.0),
    REAL_CONST(26177.43926033979/8.0),
    REAL_CONST(26194.400425876229/8.0),
    REAL_CONST(26211.364337493149/8.0),
    REAL_CONST(26228.330994301767/8.0),
    REAL_CONST(26245.30039541404/8.0),
    REAL_CONST(26262.272539942627/8.0),
    REAL_CONST(26279.247427000919/8.0),
    REAL_CONST(26296.225055703002/8.0),
    REAL_CONST(26313.205425163702/8.0),
    REAL_CONST(26330.188534498539/8.0),
    REAL_CONST(26347.174382823756/8.0),
    REAL_CONST(26364.162969256304/8.0),
    REAL_CONST(26381.154292913852/8.0),
    REAL_CONST(26398.148352914774/8.0),
    REAL_CONST(26415.145148378149/8.0),
    REAL_CONST(26432.144678423778/8.0),
    REAL_CONST(26449.146942172156/8.0),
    REAL_CONST(26466.151938744493/8.0),
    REAL_CONST(26483.159667262702/8.0),
    REAL_CONST(26500.170126849403/8.0),
    REAL_CONST(26517.183316627921/8.0),
    REAL_CONST(26534.199235722277/8.0),
    REAL_CONST(26551.217883257199/8.0),
    REAL_CONST(26568.239258358124/8.0),
    REAL_CONST(26585.263360151173/8.0),
    REAL_CONST(26602.290187763181/8.0),
    REAL_CONST(26619.319740321676/8.0),
    REAL_CONST(26636.352016954883/8.0),
    REAL_CONST(26653.387016791727/8.0),
    REAL_CONST(26670.424738961825/8.0),
    REAL_CONST(26687.465182595493/8.0),
    REAL_CONST(26704.508346823739/8.0),
    REAL_CONST(26721.554230778267/8.0),
    REAL_CONST(26738.602833591467/8.0),
    REAL_CONST(26755.65415439643/8.0),
    REAL_CONST(26772.708192326929/8.0),
    REAL_CONST(26789.764946517433/8.0),
    REAL_CONST(26806.824416103096/8.0),
    REAL_CONST(26823.886600219761/8.0),
    REAL_CONST(26840.95149800396/8.0),
    REAL_CONST(26858.019108592915/8.0),
    REAL_CONST(26875.089431124517/8.0),
    REAL_CONST(26892.162464737365/8.0),
    REAL_CONST(26909.238208570721/8.0),
    REAL_CONST(26926.316661764544/8.0),
    REAL_CONST(26943.397823459472/8.0),
    REAL_CONST(26960.481692796813/8.0),
    REAL_CONST(26977.568268918571/8.0),
    REAL_CONST(26994.657550967422/8.0),
    REAL_CONST(27011.749538086722/8.0),
    REAL_CONST(27028.844229420498/8.0),
    REAL_CONST(27045.941624113464/8.0),
    REAL_CONST(27063.041721311005/8.0),
    REAL_CONST(27080.144520159181/8.0),
    REAL_CONST(27097.250019804727/8.0),
    REAL_CONST(27114.35821939505/8.0),
    REAL_CONST(27131.469118078236/8.0),
    REAL_CONST(27148.582715003027/8.0),
    REAL_CONST(27165.699009318858/8.0),
    REAL_CONST(27182.818000175819/8.0),
    REAL_CONST(27199.939686724665/8.0),
    REAL_CONST(27217.064068116837/8.0),
    REAL_CONST(27234.191143504428/8.0),
    REAL_CONST(27251.320912040203/8.0),
    REAL_CONST(27268.453372877593/8.0),
    REAL_CONST(27285.588525170693/8.0),
    REAL_CONST(27302.726368074269/8.0),
    REAL_CONST(27319.866900743735/8.0),
    REAL_CONST(27337.010122335181/8.0),
    REAL_CONST(27354.156032005358/8.0),
    REAL_CONST(27371.304628911668/8.0),
    REAL_CONST(27388.455912212183/8.0),
    REAL_CONST(27405.609881065626/8.0),
    REAL_CONST(27422.766534631384/8.0),
    REAL_CONST(27439.925872069507/8.0),
    REAL_CONST(27457.087892540683/8.0),
    REAL_CONST(27474.252595206275/8.0),
    REAL_CONST(27491.419979228293/8.0),
    REAL_CONST(27508.5900437694/8.0),
    REAL_CONST(27525.762787992917/8.0),
    REAL_CONST(27542.93821106281/8.0),
    REAL_CONST(27560.116312143706/8.0),
    REAL_CONST(27577.297090400876/8.0),
    REAL_CONST(27594.480545000242/8.0),
    REAL_CONST(27611.666675108383/8.0),
    REAL_CONST(27628.855479892518/8.0),
    REAL_CONST(27646.046958520514/8.0),
    REAL_CONST(27663.241110160889/8.0),
    REAL_CONST(27680.437933982801/8.0),
    REAL_CONST(27697.637429156068/8.0),
    REAL_CONST(27714.839594851132/8.0),
    REAL_CONST(27732.04443023909/8.0),
    REAL_CONST(27749.251934491687/8.0),
    REAL_CONST(27766.462106781299/8.0),
    REAL_CONST(27783.674946280949/8.0),
    REAL_CONST(27800.890452164302/8.0),
    REAL_CONST(27818.108623605654/8.0),
    REAL_CONST(27835.329459779954/8.0),
    REAL_CONST(27852.55295986278/8.0),
    REAL_CONST(27869.779123030345/8.0),
    REAL_CONST(27887.007948459504/8.0),
    REAL_CONST(27904.239435327745/8.0),
    REAL_CONST(27921.473582813196/8.0),
    REAL_CONST(27938.710390094613/8.0),
    REAL_CONST(27955.949856351392/8.0),
    REAL_CONST(27973.19198076355/8.0),
    REAL_CONST(27990.436762511745/8.0),
    REAL_CONST(28007.684200777272/8.0),
    REAL_CONST(28024.934294742041/8.0),
    REAL_CONST(28042.187043588601/8.0),
    REAL_CONST(28059.442446500128/8.0),
    REAL_CONST(28076.700502660427/8.0),
    REAL_CONST(28093.961211253929/8.0),
    REAL_CONST(28111.224571465693/8.0),
    REAL_CONST(28128.490582481401/8.0),
    REAL_CONST(28145.759243487362/8.0),
    REAL_CONST(28163.030553670509/8.0),
    REAL_CONST(28180.304512218394/8.0),
    REAL_CONST(28197.581118319198/8.0),
    REAL_CONST(28214.860371161725/8.0),
    REAL_CONST(28232.14226993539/8.0),
    REAL_CONST(28249.42681383024/8.0),
    REAL_CONST(28266.71400203693/8.0),
    REAL_CONST(28284.003833746745/8.0),
    REAL_CONST(28301.296308151585/8.0),
    REAL_CONST(28318.591424443959/8.0),
    REAL_CONST(28335.889181817001/8.0),
    REAL_CONST(28353.189579464462/8.0),
    REAL_CONST(28370.492616580705/8.0),
    REAL_CONST(28387.798292360701/8.0),
    REAL_CONST(28405.106606000048/8.0),
    REAL_CONST(28422.417556694945/8.0),
    REAL_CONST(28439.731143642206/8.0),
    REAL_CONST(28457.047366039264/8.0),
    REAL_CONST(28474.366223084147/8.0),
    REAL_CONST(28491.687713975512/8.0),
    REAL_CONST(28509.011837912611/8.0),
    REAL_CONST(28526.338594095305/8.0),
    REAL_CONST(28543.667981724069/8.0),
    REAL_CONST(28560.999999999982/8.0),
    REAL_CONST(28578.334648124732/8.0),
    REAL_CONST(28595.671925300605/8.0),
    REAL_CONST(28613.011830730498/8.0),
    REAL_CONST(28630.354363617909/8.0),
    REAL_CONST(28647.699523166943/8.0),
    REAL_CONST(28665.0473085823/8.0),
    REAL_CONST(28682.397719069289/8.0),
    REAL_CONST(28699.750753833818/8.0),
    REAL_CONST(28717.10641208239/8.0),
    REAL_CONST(28734.464693022121/8.0),
    REAL_CONST(28751.825595860708/8.0),
    REAL_CONST(28769.189119806462/8.0),
    REAL_CONST(28786.55526406828/8.0),
    REAL_CONST(28803.924027855664/8.0),
    REAL_CONST(28821.295410378701/8.0),
    REAL_CONST(28838.669410848088/8.0),
    REAL_CONST(28856.046028475103/8.0),
    REAL_CONST(28873.425262471628/8.0),
    REAL_CONST(28890.80711205013/8.0),
    REAL_CONST(28908.191576423673/8.0),
    REAL_CONST(28925.578654805915/8.0),
    REAL_CONST(28942.968346411097/8.0),
    REAL_CONST(28960.360650454055/8.0),
    REAL_CONST(28977.755566150216/8.0),
    REAL_CONST(28995.153092715591/8.0),
    REAL_CONST(29012.553229366786/8.0),
    REAL_CONST(29029.955975320987/8.0),
    REAL_CONST(29047.361329795975/8.0),
    REAL_CONST(29064.769292010107/8.0),
    REAL_CONST(29082.179861182336/8.0),
    REAL_CONST(29099.593036532187/8.0),
    REAL_CONST(29117.00881727978/8.0),
    REAL_CONST(29134.427202645813/8.0),
    REAL_CONST(29151.848191851568/8.0),
    REAL_CONST(29169.271784118911/8.0),
    REAL_CONST(29186.697978670283/8.0),
    REAL_CONST(29204.126774728706/8.0),
    REAL_CONST(29221.55817151779/8.0),
    REAL_CONST(29238.992168261717/8.0),
    REAL_CONST(29256.42876418525/8.0),
    REAL_CONST(29273.867958513725/8.0),
    REAL_CONST(29291.309750473058/8.0),
    REAL_CONST(29308.754139289747/8.0),
    REAL_CONST(29326.201124190855/8.0),
    REAL_CONST(29343.65070440403/8.0),
    REAL_CONST(29361.102879157483/8.0),
    REAL_CONST(29378.557647680012/8.0),
    REAL_CONST(29396.015009200975/8.0),
    REAL_CONST(29413.474962950309/8.0),
    REAL_CONST(29430.937508158524/8.0),
    REAL_CONST(29448.402644056692/8.0),
    REAL_CONST(29465.870369876469/8.0),
    REAL_CONST(29483.340684850071/8.0),
    REAL_CONST(29500.81358821028/8.0),
    REAL_CONST(29518.289079190454/8.0),
    REAL_CONST(29535.767157024511/8.0),
    REAL_CONST(29553.247820946945/8.0),
    REAL_CONST(29570.731070192807/8.0),
    REAL_CONST(29588.216903997723/8.0),
    REAL_CONST(29605.70532159787/8.0),
    REAL_CONST(29623.19632223/8.0),
    REAL_CONST(29640.689905131429/8.0),
    REAL_CONST(29658.186069540028/8.0),
    REAL_CONST(29675.684814694236/8.0),
    REAL_CONST(29693.186139833047/8.0),
    REAL_CONST(29710.690044196028/8.0),
    REAL_CONST(29728.196527023298/8.0),
    REAL_CONST(29745.705587555527/8.0),
    REAL_CONST(29763.217225033964/8.0),
    REAL_CONST(29780.731438700397/8.0),
    REAL_CONST(29798.248227797183/8.0),
    REAL_CONST(29815.76759156723/8.0),
    REAL_CONST(29833.289529254005/8.0),
    REAL_CONST(29850.81404010153/8.0),
    REAL_CONST(29868.341123354381/8.0),
    REAL_CONST(29885.870778257693/8.0),
    REAL_CONST(29903.403004057145/8.0),
    REAL_CONST(29920.937799998974/8.0),
    REAL_CONST(29938.475165329975/8.0),
    REAL_CONST(29956.015099297485/8.0),
    REAL_CONST(29973.557601149394/8.0),
    REAL_CONST(29991.102670134147/8.0),
    REAL_CONST(30008.650305500738/8.0),
    REAL_CONST(30026.200506498706/8.0),
    REAL_CONST(30043.753272378144/8.0),
    REAL_CONST(30061.308602389683/8.0),
    REAL_CONST(30078.866495784507/8.0),
    REAL_CONST(30096.426951814352/8.0),
    REAL_CONST(30113.989969731494/8.0),
    REAL_CONST(30131.55554878875/8.0),
    REAL_CONST(30149.123688239491/8.0),
    REAL_CONST(30166.694387337629/8.0),
    REAL_CONST(30184.267645337608/8.0),
    REAL_CONST(30201.843461494434/8.0),
    REAL_CONST(30219.42183506364/8.0),
    REAL_CONST(30237.002765301309/8.0),
    REAL_CONST(30254.586251464058/8.0),
    REAL_CONST(30272.172292809046/8.0),
    REAL_CONST(30289.760888593977/8.0),
    REAL_CONST(30307.35203807709/8.0),
    REAL_CONST(30324.94574051716/8.0),
    REAL_CONST(30342.541995173502/8.0),
    REAL_CONST(30360.140801305966/8.0),
    REAL_CONST(30377.742158174944/8.0),
    REAL_CONST(30395.346065041358/8.0),
    REAL_CONST(30412.952521166666/8.0),
    REAL_CONST(30430.561525812864/8.0),
    REAL_CONST(30448.173078242475/8.0),
    REAL_CONST(30465.787177718561/8.0),
    REAL_CONST(30483.403823504719/8.0),
    REAL_CONST(30501.02301486507/8.0),
    REAL_CONST(30518.644751064272/8.0),
    REAL_CONST(30536.269031367516/8.0),
    REAL_CONST(30553.895855040515/8.0),
    REAL_CONST(30571.525221349519/8.0),
    REAL_CONST(30589.157129561307/8.0),
    REAL_CONST(30606.791578943175/8.0),
    REAL_CONST(30624.428568762964/8.0),
    REAL_CONST(30642.06809828903/8.0),
    REAL_CONST(30659.710166790261/8.0),
    REAL_CONST(30677.35477353607/8.0),
    REAL_CONST(30695.001917796391/8.0),
    REAL_CONST(30712.651598841687/8.0),
    REAL_CONST(30730.303815942945/8.0),
    REAL_CONST(30747.958568371676/8.0),
    REAL_CONST(30765.615855399912/8.0),
    REAL_CONST(30783.275676300211/8.0),
    REAL_CONST(30800.938030345646/8.0),
    REAL_CONST(30818.602916809814/8.0),
    REAL_CONST(30836.270334966837/8.0),
    REAL_CONST(30853.940284091354/8.0),
    REAL_CONST(30871.612763458521/8.0),
    REAL_CONST(30889.287772344011/8.0),
    REAL_CONST(30906.965310024025/8.0),
    REAL_CONST(30924.645375775272/8.0),
    REAL_CONST(30942.327968874983/8.0),
    REAL_CONST(30960.013088600903/8.0),
    REAL_CONST(30977.700734231294/8.0),
    REAL_CONST(30995.390905044929/8.0),
    REAL_CONST(31013.083600321101/8.0),
    REAL_CONST(31030.778819339619/8.0),
    REAL_CONST(31048.476561380798/8.0),
    REAL_CONST(31066.17682572547/8.0),
    REAL_CONST(31083.879611654978/8.0),
    REAL_CONST(31101.584918451179/8.0),
    REAL_CONST(31119.29274539644/8.0),
    REAL_CONST(31137.003091773637/8.0),
    REAL_CONST(31154.715956866155/8.0),
    REAL_CONST(31172.431339957893/8.0),
    REAL_CONST(31190.14924033326/8.0),
    REAL_CONST(31207.869657277162/8.0),
    REAL_CONST(31225.592590075023/8.0),
    REAL_CONST(31243.318038012771/8.0),
    REAL_CONST(31261.046000376838/8.0),
    REAL_CONST(31278.776476454172/8.0),
    REAL_CONST(31296.50946553221/8.0),
    REAL_CONST(31314.24496689891/8.0),
    REAL_CONST(31331.98297984272/8.0),
    REAL_CONST(31349.7235036526/8.0),
    REAL_CONST(31367.466537618013/8.0),
    REAL_CONST(31385.212081028923/8.0),
    REAL_CONST(31402.960133175795/8.0),
    REAL_CONST(31420.710693349596/8.0),
    REAL_CONST(31438.463760841791/8.0),
    REAL_CONST(31456.219334944351/8.0),
    REAL_CONST(31473.977414949743/8.0),
    REAL_CONST(31491.738000150934/8.0),
    REAL_CONST(31509.501089841389/8.0),
    REAL_CONST(31527.266683315069/8.0),
    REAL_CONST(31545.034779866437/8.0),
    REAL_CONST(31562.80537879045/8.0),
    REAL_CONST(31580.578479382562/8.0),
    REAL_CONST(31598.35408093872/8.0),
    REAL_CONST(31616.132182755369/8.0),
    REAL_CONST(31633.91278412945/8.0),
    REAL_CONST(31651.695884358396/8.0),
    REAL_CONST(31669.481482740131/8.0),
    REAL_CONST(31687.269578573076/8.0),
    REAL_CONST(31705.060171156143/8.0),
    REAL_CONST(31722.853259788735/8.0),
    REAL_CONST(31740.648843770748/8.0),
    REAL_CONST(31758.446922402567/8.0),
    REAL_CONST(31776.247494985066/8.0),
    REAL_CONST(31794.050560819614/8.0),
    REAL_CONST(31811.85611920806/8.0),
    REAL_CONST(31829.664169452753/8.0),
    REAL_CONST(31847.474710856521/8.0),
    REAL_CONST(31865.287742722685/8.0),
    REAL_CONST(31883.103264355046/8.0),
    REAL_CONST(31900.921275057899/8.0),
    REAL_CONST(31918.741774136019/8.0),
    REAL_CONST(31936.564760894671/8.0),
    REAL_CONST(31954.390234639599/8.0),
    REAL_CONST(31972.21819467704/8.0),
    REAL_CONST(31990.048640313704/8.0),
    REAL_CONST(32007.881570856793/8.0),
    REAL_CONST(32025.716985613984/8.0),
    REAL_CONST(32043.554883893445/8.0),
    REAL_CONST(32061.395265003815/8.0),
    REAL_CONST(32079.238128254223/8.0),
    REAL_CONST(32097.083472954269/8.0),
    REAL_CONST(32114.931298414049/8.0),
    REAL_CONST(32132.781603944117/8.0),
    REAL_CONST(32150.634388855524/8.0),
    REAL_CONST(32168.48965245979/8.0),
    REAL_CONST(32186.347394068915/8.0),
    REAL_CONST(32204.207612995371/8.0),
    REAL_CONST(32222.07030855212/8.0),
    REAL_CONST(32239.935480052583/8.0),
    REAL_CONST(32257.803126810672/8.0),
    REAL_CONST(32275.673248140767/8.0),
    REAL_CONST(32293.545843357719/8.0),
    REAL_CONST(32311.420911776862/8.0),
    REAL_CONST(32329.298452713996/8.0),
    REAL_CONST(32347.178465485395/8.0),
    REAL_CONST(32365.060949407813/8.0),
    REAL_CONST(32382.945903798463/8.0),
    REAL_CONST(32400.83332797504/8.0),
    REAL_CONST(32418.723221255706/8.0),
    REAL_CONST(32436.615582959093/8.0),
    REAL_CONST(32454.510412404306/8.0),
    REAL_CONST(32472.407708910916/8.0),
    REAL_CONST(32490.307471798966/8.0),
    REAL_CONST(32508.209700388961/8.0),
    REAL_CONST(32526.114394001877/8.0),
    REAL_CONST(32544.021551959166/8.0),
    REAL_CONST(32561.931173582732/8.0),
    REAL_CONST(32579.843258194956/8.0),
    REAL_CONST(32597.757805118679/8.0),
    REAL_CONST(32615.674813677211/8.0),
    REAL_CONST(32633.594283194328/8.0),
    REAL_CONST(32651.516212994258/8.0),
    REAL_CONST(32669.440602401712/8.0),
    REAL_CONST(32687.367450741847/8.0),
    REAL_CONST(32705.296757340297/8.0),
    REAL_CONST(32723.228521523146/8.0),
    REAL_CONST(32741.162742616943/8.0),
    REAL_CONST(32759.099419948703/8.0),
    REAL_CONST(32777.038552845901/8.0),
    REAL_CONST(32794.980140636464/8.0),
    REAL_CONST(32812.924182648792/8.0),
    REAL_CONST(32830.87067821173/8.0),
    REAL_CONST(32848.819626654593/8.0),
    REAL_CONST(32866.77102730715/8.0),
    REAL_CONST(32884.724879499619/8.0),
    REAL_CONST(32902.681182562686/8.0),
    REAL_CONST(32920.639935827494/8.0),
    REAL_CONST(32938.601138625643/8.0),
    REAL_CONST(32956.56479028918/8.0),
    REAL_CONST(32974.530890150607/8.0),
    REAL_CONST(32992.499437542894/8.0),
    REAL_CONST(33010.470431799447/8.0),
    REAL_CONST(33028.443872254145/8.0),
    REAL_CONST(33046.419758241311/8.0),
    REAL_CONST(33064.39808909571/8.0),
    REAL_CONST(33082.378864152583/8.0),
    REAL_CONST(33100.36208274759/8.0),
    REAL_CONST(33118.347744216881/8.0),
    REAL_CONST(33136.335847897026/8.0),
    REAL_CONST(33154.326393125062/8.0),
    REAL_CONST(33172.31937923847/8.0),
    REAL_CONST(33190.314805575174/8.0),
    REAL_CONST(33208.312671473555/8.0),
    REAL_CONST(33226.312976272442/8.0),
    REAL_CONST(33244.315719311111/8.0),
    REAL_CONST(33262.320899929284/8.0),
    REAL_CONST(33280.328517467125/8.0),
    REAL_CONST(33298.33857126526/8.0),
    REAL_CONST(33316.351060664747/8.0),
    REAL_CONST(33334.365985007091/8.0),
    REAL_CONST(33352.383343634239/8.0),
    REAL_CONST(33370.403135888591/8.0),
    REAL_CONST(33388.42536111299/8.0),
    REAL_CONST(33406.450018650721/8.0),
    REAL_CONST(33424.477107845501/8.0),
    REAL_CONST(33442.506628041512/8.0),
    REAL_CONST(33460.53857858335/8.0),
    REAL_CONST(33478.572958816083/8.0),
    REAL_CONST(33496.609768085189/8.0),
    REAL_CONST(33514.649005736617/8.0),
    REAL_CONST(33532.690671116739/8.0),
    REAL_CONST(33550.734763572356/8.0),
    REAL_CONST(33568.781282450735/8.0),
    REAL_CONST(33586.830227099563/8.0),
    REAL_CONST(33604.881596866973/8.0),
    REAL_CONST(33622.935391101528/8.0),
    REAL_CONST(33640.991609152239/8.0),
    REAL_CONST(33659.050250368542/8.0),
    REAL_CONST(33677.111314100322/8.0),
    REAL_CONST(33695.174799697881/8.0),
    REAL_CONST(33713.240706511984/8.0),
    REAL_CONST(33731.309033893805/8.0),
    REAL_CONST(33749.37978119497/8.0),
    REAL_CONST(33767.452947767531/8.0),
    REAL_CONST(33785.528532963974/8.0),
    REAL_CONST(33803.606536137209/8.0),
    REAL_CONST(33821.686956640602/8.0),
    REAL_CONST(33839.769793827938/8.0),
    REAL_CONST(33857.855047053425/8.0),
    REAL_CONST(33875.942715671707/8.0),
    REAL_CONST(33894.032799037872/8.0),
    REAL_CONST(33912.125296507431/8.0),
    REAL_CONST(33930.220207436316/8.0),
    REAL_CONST(33948.317531180888/8.0),
    REAL_CONST(33966.417267097961/8.0),
    REAL_CONST(33984.519414544746/8.0),
    REAL_CONST(34002.623972878901/8.0),
    REAL_CONST(34020.730941458511/8.0),
    REAL_CONST(34038.840319642077/8.0),
    REAL_CONST(34056.952106788536/8.0),
    REAL_CONST(34075.066302257255/8.0),
    REAL_CONST(34093.182905408015/8.0),
    REAL_CONST(34111.301915601027/8.0),
    REAL_CONST(34129.42333219693/8.0),
    REAL_CONST(34147.547154556785/8.0),
    REAL_CONST(34165.673382042078/8.0),
    REAL_CONST(34183.80201401472/8.0),
    REAL_CONST(34201.933049837033/8.0),
    REAL_CONST(34220.06648887178/8.0),
    REAL_CONST(34238.202330482141/8.0),
    REAL_CONST(34256.340574031703/8.0),
    REAL_CONST(34274.481218884495/8.0),
    REAL_CONST(34292.624264404949/8.0),
    REAL_CONST(34310.769709957938/8.0),
    REAL_CONST(34328.91755490873/8.0),
    REAL_CONST(34347.067798623029/8.0),
    REAL_CONST(34365.220440466954/8.0),
    REAL_CONST(34383.375479807051/8.0),
    REAL_CONST(34401.532916010263/8.0),
    REAL_CONST(34419.692748443973/8.0),
    REAL_CONST(34437.854976475966/8.0),
    REAL_CONST(34456.01959947445/8.0),
    REAL_CONST(34474.18661680806/8.0),
    REAL_CONST(34492.356027845817/8.0),
    REAL_CONST(34510.527831957188/8.0),
    REAL_CONST(34528.702028512052/8.0),
    REAL_CONST(34546.878616880676/8.0),
    REAL_CONST(34565.05759643377/8.0),
    REAL_CONST(34583.238966542449/8.0),
    REAL_CONST(34601.422726578232/8.0),
    REAL_CONST(34619.608875913065/8.0),
    REAL_CONST(34637.797413919296/8.0),
    REAL_CONST(34655.988339969692/8.0),
    REAL_CONST(34674.181653437423/8.0),
    REAL_CONST(34692.37735369608/8.0),
    REAL_CONST(34710.575440119668/8.0),
    REAL_CONST(34728.775912082579/8.0),
    REAL_CONST(34746.978768959649/8.0),
    REAL_CONST(34765.184010126082/8.0),
    REAL_CONST(34783.391634957537/8.0),
    REAL_CONST(34801.60164283005/8.0),
    REAL_CONST(34819.814033120063/8.0),
    REAL_CONST(34838.028805204456/8.0),
    REAL_CONST(34856.24595846048/8.0),
    REAL_CONST(34874.465492265823/8.0),
    REAL_CONST(34892.687405998557/8.0),
    REAL_CONST(34910.911699037177/8.0),
    REAL_CONST(34929.138370760564/8.0),
    REAL_CONST(34947.367420548027/8.0),
    REAL_CONST(34965.598847779271/8.0),
    REAL_CONST(34983.832651834389/8.0),
    REAL_CONST(35002.068832093908/8.0),
    REAL_CONST(35020.307387938738/8.0),
    REAL_CONST(35038.548318750189/8.0),
    REAL_CONST(35056.79162390998/8.0),
    REAL_CONST(35075.03730280025/8.0),
    REAL_CONST(35093.285354803513/8.0),
    REAL_CONST(35111.535779302685/8.0),
    REAL_CONST(35129.788575681116/8.0),
    REAL_CONST(35148.043743322516/8.0),
    REAL_CONST(35166.301281611013/8.0),
    REAL_CONST(35184.561189931141/8.0),
    REAL_CONST(35202.823467667826/8.0),
    REAL_CONST(35221.088114206388/8.0),
    REAL_CONST(35239.355128932555/8.0),
    REAL_CONST(35257.624511232447/8.0),
    REAL_CONST(35275.896260492584/8.0),
    REAL_CONST(35294.170376099886/8.0),
    REAL_CONST(35312.446857441668/8.0),
    REAL_CONST(35330.725703905628/8.0),
    REAL_CONST(35349.006914879887/8.0),
    REAL_CONST(35367.290489752944/8.0),
    REAL_CONST(35385.576427913686/8.0),
    REAL_CONST(35403.864728751418/8.0),
    REAL_CONST(35422.155391655811/8.0),
    REAL_CONST(35440.448416016967/8.0),
    REAL_CONST(35458.743801225341/8.0),
    REAL_CONST(35477.041546671804/8.0),
    REAL_CONST(35495.341651747622/8.0),
    REAL_CONST(35513.644115844436/8.0),
    REAL_CONST(35531.948938354304/8.0),
    REAL_CONST(35550.256118669655/8.0),
    REAL_CONST(35568.565656183309/8.0),
    REAL_CONST(35586.877550288496/8.0),
    REAL_CONST(35605.191800378816/8.0),
    REAL_CONST(35623.508405848268/8.0),
    REAL_CONST(35641.827366091238/8.0),
    REAL_CONST(35660.148680502505/8.0),
    REAL_CONST(35678.472348477233/8.0),
    REAL_CONST(35696.798369410979/8.0),
    REAL_CONST(35715.126742699678/8.0),
    REAL_CONST(35733.457467739659/8.0),
    REAL_CONST(35751.790543927644/8.0),
    REAL_CONST(35770.125970660738/8.0),
    REAL_CONST(35788.46374733642/8.0),
    REAL_CONST(35806.803873352568/8.0),
    REAL_CONST(35825.146348107453/8.0),
    REAL_CONST(35843.49117099971/8.0),
    REAL_CONST(35861.838341428367/8.0),
    REAL_CONST(35880.187858792851/8.0),
    REAL_CONST(35898.539722492955/8.0),
    REAL_CONST(35916.893931928862/8.0),
    REAL_CONST(35935.250486501129/8.0),
    REAL_CONST(35953.609385610718/8.0),
    REAL_CONST(35971.970628658957/8.0),
    REAL_CONST(35990.334215047558/8.0),
    REAL_CONST(36008.700144178612/8.0),
    REAL_CONST(36027.068415454596/8.0),
    REAL_CONST(36045.439028278372/8.0),
    REAL_CONST(36063.811982053165/8.0),
    REAL_CONST(36082.187276182609/8.0),
    REAL_CONST(36100.564910070694/8.0),
    REAL_CONST(36118.944883121789/8.0),
    REAL_CONST(36137.327194740654/8.0),
    REAL_CONST(36155.711844332429/8.0),
    REAL_CONST(36174.098831302617/8.0),
    REAL_CONST(36192.488155057115/8.0),
    REAL_CONST(36210.87981500219/8.0),
    REAL_CONST(36229.273810544473/8.0),
    REAL_CONST(36247.670141091003/8.0),
    REAL_CONST(36266.068806049167/8.0),
    REAL_CONST(36284.469804826738/8.0),
    REAL_CONST(36302.873136831862/8.0),
    REAL_CONST(36321.278801473069/8.0),
    REAL_CONST(36339.686798159251/8.0),
    REAL_CONST(36358.097126299683/8.0),
    REAL_CONST(36376.509785304013/8.0),
    REAL_CONST(36394.924774582258/8.0),
    REAL_CONST(36413.342093544816/8.0),
    REAL_CONST(36431.761741602444/8.0),
    REAL_CONST(36450.183718166292/8.0),
    REAL_CONST(36468.608022647859/8.0),
    REAL_CONST(36487.034654459028/8.0),
    REAL_CONST(36505.463613012063/8.0),
    REAL_CONST(36523.894897719583/8.0),
    REAL_CONST(36542.328507994578/8.0),
    REAL_CONST(36560.764443250409/8.0),
    REAL_CONST(36579.202702900831/8.0),
    REAL_CONST(36597.643286359926/8.0),
    REAL_CONST(36616.086193042182/8.0),
    REAL_CONST(36634.531422362437/8.0),
    REAL_CONST(36652.978973735895/8.0),
    REAL_CONST(36671.428846578143/8.0),
    REAL_CONST(36689.881040305125/8.0),
    REAL_CONST(36708.335554333149/8.0),
    REAL_CONST(36726.792388078902/8.0),
    REAL_CONST(36745.251540959427/8.0),
    REAL_CONST(36763.713012392138/8.0),
    REAL_CONST(36782.176801794812/8.0),
    REAL_CONST(36800.642908585593/8.0),
    REAL_CONST(36819.111332182983/8.0),
    REAL_CONST(36837.582072005869/8.0),
    REAL_CONST(36856.055127473483/8.0),
    REAL_CONST(36874.530498005421/8.0),
    REAL_CONST(36893.008183021651/8.0),
    REAL_CONST(36911.488181942506/8.0),
    REAL_CONST(36929.970494188674/8.0),
    REAL_CONST(36948.455119181206/8.0),
    REAL_CONST(36966.942056341519/8.0),
    REAL_CONST(36985.431305091392/8.0),
    REAL_CONST(37003.922864852961/8.0),
    REAL_CONST(37022.416735048733/8.0),
    REAL_CONST(37040.912915101559/8.0),
    REAL_CONST(37059.411404434657/8.0),
    REAL_CONST(37077.91220247162/8.0),
    REAL_CONST(37096.415308636388/8.0),
    REAL_CONST(37114.920722353243/8.0),
    REAL_CONST(37133.428443046862/8.0),
    REAL_CONST(37151.938470142253/8.0),
    REAL_CONST(37170.450803064785/8.0),
    REAL_CONST(37188.965441240209/8.0),
    REAL_CONST(37207.482384094597/8.0),
    REAL_CONST(37226.001631054402/8.0),
    REAL_CONST(37244.523181546429/8.0),
    REAL_CONST(37263.047034997842/8.0),
    REAL_CONST(37281.573190836149/8.0),
    REAL_CONST(37300.101648489224/8.0),
    REAL_CONST(37318.632407385296/8.0),
    REAL_CONST(37337.165466952945/8.0),
    REAL_CONST(37355.700826621112/8.0),
    REAL_CONST(37374.238485819085/8.0),
    REAL_CONST(37392.778443976509/8.0),
    REAL_CONST(37411.320700523385/8.0),
    REAL_CONST(37429.865254890057/8.0),
    REAL_CONST(37448.412106507232/8.0),
    REAL_CONST(37466.961254805974/8.0),
    REAL_CONST(37485.512699217681/8.0),
    REAL_CONST(37504.066439174116/8.0),
    REAL_CONST(37522.622474107404/8.0),
    REAL_CONST(37541.180803449992/8.0),
    REAL_CONST(37559.741426634704/8.0),
    REAL_CONST(37578.304343094693/8.0),
    REAL_CONST(37596.869552263488/8.0),
    REAL_CONST(37615.43705357494/8.0),
    REAL_CONST(37634.006846463279/8.0),
    REAL_CONST(37652.578930363044/8.0),
    REAL_CONST(37671.153304709165/8.0),
    REAL_CONST(37689.729968936896/8.0),
    REAL_CONST(37708.308922481847/8.0),
    REAL_CONST(37726.890164779965/8.0),
    REAL_CONST(37745.473695267559/8.0),
    REAL_CONST(37764.059513381275/8.0),
    REAL_CONST(37782.647618558112/8.0),
    REAL_CONST(37801.238010235415/8.0),
    REAL_CONST(37819.830687850859/8.0),
    REAL_CONST(37838.425650842495/8.0),
    REAL_CONST(37857.022898648691/8.0),
    REAL_CONST(37875.622430708172/8.0),
    REAL_CONST(37894.224246460013/8.0),
    REAL_CONST(37912.828345343616/8.0),
    REAL_CONST(37931.434726798747/8.0),
    REAL_CONST(37950.043390265506/8.0),
    REAL_CONST(37968.654335184328/8.0),
    REAL_CONST(37987.267560995999/8.0),
    REAL_CONST(38005.883067141665/8.0),
    REAL_CONST(38024.500853062775/8.0),
    REAL_CONST(38043.120918201159/8.0),
    REAL_CONST(38061.743261998963/8.0),
    REAL_CONST(38080.367883898682/8.0),
    REAL_CONST(38098.994783343158/8.0),
    REAL_CONST(38117.623959775563/8.0),
    REAL_CONST(38136.255412639417/8.0),
    REAL_CONST(38154.889141378575/8.0),
    REAL_CONST(38173.525145437234/8.0),
    REAL_CONST(38192.163424259939/8.0),
    REAL_CONST(38210.803977291551/8.0),
    REAL_CONST(38229.446803977284/8.0),
    REAL_CONST(38248.091903762703/8.0),
    REAL_CONST(38266.739276093685/8.0),
    REAL_CONST(38285.388920416466/8.0),
    REAL_CONST(38304.040836177606/8.0),
    REAL_CONST(38322.695022824002/8.0),
    REAL_CONST(38341.351479802899/8.0),
    REAL_CONST(38360.010206561863/8.0),
    REAL_CONST(38378.671202548816/8.0),
    REAL_CONST(38397.334467211993/8.0),
    REAL_CONST(38415.999999999978/8.0),
    REAL_CONST(38434.667800361683/8.0),
    REAL_CONST(38453.33786774637/8.0),
    REAL_CONST(38472.010201603611/8.0),
    REAL_CONST(38490.684801383337/8.0),
    REAL_CONST(38509.361666535784/8.0),
    REAL_CONST(38528.040796511552/8.0),
    REAL_CONST(38546.722190761553/8.0),
    REAL_CONST(38565.405848737035/8.0),
    REAL_CONST(38584.091769889594/8.0),
    REAL_CONST(38602.779953671132/8.0),
    REAL_CONST(38621.470399533908/8.0),
    REAL_CONST(38640.163106930493/8.0),
    REAL_CONST(38658.858075313794/8.0),
    REAL_CONST(38677.555304137059/8.0),
    REAL_CONST(38696.254792853862/8.0),
    REAL_CONST(38714.956540918094/8.0),
    REAL_CONST(38733.660547783991/8.0),
    REAL_CONST(38752.366812906112/8.0),
    REAL_CONST(38771.075335739348/8.0),
    REAL_CONST(38789.78611573892/8.0),
    REAL_CONST(38808.499152360368/8.0),
    REAL_CONST(38827.214445059573/8.0),
    REAL_CONST(38845.931993292739/8.0),
    REAL_CONST(38864.651796516388/8.0),
    REAL_CONST(38883.373854187383/8.0),
    REAL_CONST(38902.098165762916/8.0),
    REAL_CONST(38920.824730700486/8.0),
    REAL_CONST(38939.553548457938/8.0),
    REAL_CONST(38958.284618493431/8.0),
    REAL_CONST(38977.017940265461/8.0),
    REAL_CONST(38995.753513232834/8.0),
    REAL_CONST(39014.491336854699/8.0),
    REAL_CONST(39033.231410590517/8.0),
    REAL_CONST(39051.973733900079/8.0),
    REAL_CONST(39070.718306243485/8.0),
    REAL_CONST(39089.465127081188/8.0),
    REAL_CONST(39108.214195873945/8.0),
    REAL_CONST(39126.965512082832/8.0),
    REAL_CONST(39145.719075169261/8.0),
    REAL_CONST(39164.474884594965/8.0),
    REAL_CONST(39183.232939821988/8.0),
    REAL_CONST(39201.99324031271/8.0),
    REAL_CONST(39220.755785529815/8.0),
    REAL_CONST(39239.52057493633/8.0),
    REAL_CONST(39258.287607995589/8.0),
    REAL_CONST(39277.056884171245/8.0),
    REAL_CONST(39295.828402927284/8.0),
    REAL_CONST(39314.602163728006/8.0),
    REAL_CONST(39333.378166038019/8.0),
    REAL_CONST(39352.15640932227/8.0),
    REAL_CONST(39370.936893046004/8.0),
    REAL_CONST(39389.719616674811/8.0),
    REAL_CONST(39408.504579674584/8.0),
    REAL_CONST(39427.291781511522/8.0),
    REAL_CONST(39446.081221652174/8.0),
    REAL_CONST(39464.872899563372/8.0),
    REAL_CONST(39483.666814712291/8.0),
    REAL_CONST(39502.462966566411/8.0),
    REAL_CONST(39521.261354593538/8.0),
    REAL_CONST(39540.06197826178/8.0),
    REAL_CONST(39558.864837039568/8.0),
    REAL_CONST(39577.669930395656/8.0),
    REAL_CONST(39596.47725779911/8.0),
    REAL_CONST(39615.286818719302/8.0),
    REAL_CONST(39634.098612625923/8.0),
    REAL_CONST(39652.912638988993/8.0),
    REAL_CONST(39671.728897278823/8.0),
    REAL_CONST(39690.547386966064/8.0),
    REAL_CONST(39709.368107521652/8.0),
    REAL_CONST(39728.191058416858/8.0),
    REAL_CONST(39747.016239123259/8.0),
    REAL_CONST(39765.84364911275/8.0),
    REAL_CONST(39784.673287857528/8.0),
    REAL_CONST(39803.505154830105/8.0),
    REAL_CONST(39822.339249503319/8.0),
    REAL_CONST(39841.175571350293/8.0),
    REAL_CONST(39860.014119844491/8.0),
    REAL_CONST(39878.854894459677/8.0),
    REAL_CONST(39897.697894669909/8.0),
    REAL_CONST(39916.54311994958/8.0),
    REAL_CONST(39935.390569773372/8.0),
    REAL_CONST(39954.240243616303/8.0),
    REAL_CONST(39973.092140953675/8.0),
    REAL_CONST(39991.946261261117/8.0),
    REAL_CONST(40010.802604014549/8.0),
    REAL_CONST(40029.661168690225/8.0),
    REAL_CONST(40048.521954764678/8.0),
    REAL_CONST(40067.384961714779/8.0),
    REAL_CONST(40086.250189017679/8.0),
    REAL_CONST(40105.117636150855/8.0),
    REAL_CONST(40123.98730259209/8.0),
    REAL_CONST(40142.859187819471/8.0),
    REAL_CONST(40161.733291311379/8.0),
    REAL_CONST(40180.609612546526/8.0),
    REAL_CONST(40199.488151003912/8.0),
    REAL_CONST(40218.368906162854/8.0),
    REAL_CONST(40237.25187750296/8.0),
    REAL_CONST(40256.137064504153/8.0),
    REAL_CONST(40275.024466646668/8.0),
    REAL_CONST(40293.914083411029/8.0),
    REAL_CONST(40312.805914278084/8.0),
    REAL_CONST(40331.699958728961/8.0),
    REAL_CONST(40350.596216245103/8.0),
    REAL_CONST(40369.494686308273/8.0),
    REAL_CONST(40388.39536840051/8.0),
    REAL_CONST(40407.298262004173/8.0),
    REAL_CONST(40426.20336660192/8.0),
    REAL_CONST(40445.110681676706/8.0),
    REAL_CONST(40464.020206711793/8.0),
    REAL_CONST(40482.931941190756/8.0),
    REAL_CONST(40501.845884597446/8.0),
    REAL_CONST(40520.762036416032/8.0),
    REAL_CONST(40539.680396130985/8.0),
    REAL_CONST(40558.600963227072/8.0),
    REAL_CONST(40577.523737189367/8.0),
    REAL_CONST(40596.448717503234/8.0),
    REAL_CONST(40615.375903654342/8.0),
    REAL_CONST(40634.305295128659/8.0),
    REAL_CONST(40653.236891412453/8.0),
    REAL_CONST(40672.170691992294/8.0),
    REAL_CONST(40691.106696355047/8.0),
    REAL_CONST(40710.044903987873/8.0),
    REAL_CONST(40728.985314378238/8.0),
    REAL_CONST(40747.927927013901/8.0),
    REAL_CONST(40766.872741382918/8.0),
    REAL_CONST(40785.819756973651/8.0),
    REAL_CONST(40804.768973274746/8.0),
    REAL_CONST(40823.720389775161/8.0),
    REAL_CONST(40842.674005964131/8.0),
    REAL_CONST(40861.629821331211/8.0),
    REAL_CONST(40880.587835366234/8.0),
    REAL_CONST(40899.548047559321/8.0),
    REAL_CONST(40918.510457400931/8.0),
    REAL_CONST(40937.475064381761/8.0),
    REAL_CONST(40956.441867992849/8.0),
    REAL_CONST(40975.410867725499/8.0),
    REAL_CONST(40994.382063071331/8.0),
    REAL_CONST(41013.355453522236/8.0),
    REAL_CONST(41032.331038570417/8.0),
    REAL_CONST(41051.308817708363/8.0),
    REAL_CONST(41070.288790428858/8.0),
    REAL_CONST(41089.270956224987/8.0),
    REAL_CONST(41108.255314590111/8.0),
    REAL_CONST(41127.241865017888/8.0),
    REAL_CONST(41146.23060700229/8.0),
    REAL_CONST(41165.221540037543/8.0),
    REAL_CONST(41184.214663618193/8.0),
    REAL_CONST(41203.209977239079/8.0),
    REAL_CONST(41222.207480395307/8.0),
    REAL_CONST(41241.207172582297/8.0),
    REAL_CONST(41260.209053295752/8.0),
    REAL_CONST(41279.213122031659/8.0),
    REAL_CONST(41298.219378286303/8.0),
    REAL_CONST(41317.227821556255/8.0),
    REAL_CONST(41336.23845133838/8.0),
    REAL_CONST(41355.251267129832/8.0),
    REAL_CONST(41374.266268428037/8.0),
    REAL_CONST(41393.283454730743/8.0),
    REAL_CONST(41412.302825535953/8.0),
    REAL_CONST(41431.324380341983/8.0),
    REAL_CONST(41450.348118647416/8.0),
    REAL_CONST(41469.374039951144/8.0),
    REAL_CONST(41488.402143752326/8.0),
    REAL_CONST(41507.432429550427/8.0),
    REAL_CONST(41526.464896845187/8.0),
    REAL_CONST(41545.499545136627/8.0),
    REAL_CONST(41564.536373925075/8.0),
    REAL_CONST(41583.575382711126/8.0),
    REAL_CONST(41602.616570995662/8.0),
    REAL_CONST(41621.659938279874/8.0),
    REAL_CONST(41640.705484065205/8.0),
    REAL_CONST(41659.753207853406/8.0),
    REAL_CONST(41678.803109146495/8.0),
    REAL_CONST(41697.855187446803/8.0),
    REAL_CONST(41716.909442256911/8.0),
    REAL_CONST(41735.965873079709/8.0),
    REAL_CONST(41755.02447941836/8.0),
    REAL_CONST(41774.085260776315/8.0),
    REAL_CONST(41793.148216657297/8.0),
    REAL_CONST(41812.213346565331/8.0),
    REAL_CONST(41831.280650004708/8.0),
    REAL_CONST(41850.350126480014/8.0),
    REAL_CONST(41869.421775496106/8.0),
    REAL_CONST(41888.495596558132/8.0),
    REAL_CONST(41907.571589171515/8.0),
    REAL_CONST(41926.649752841957/8.0),
    REAL_CONST(41945.730087075463/8.0),
    REAL_CONST(41964.812591378286/8.0),
    REAL_CONST(41983.897265256979/8.0),
    REAL_CONST(42002.984108218378/8.0),
    REAL_CONST(42022.073119769593/8.0),
    REAL_CONST(42041.164299418015/8.0),
    REAL_CONST(42060.257646671307/8.0),
    REAL_CONST(42079.353161037419/8.0),
    REAL_CONST(42098.450842024591/8.0),
    REAL_CONST(42117.550689141324/8.0),
    REAL_CONST(42136.652701896404/8.0),
    REAL_CONST(42155.756879798893/8.0),
    REAL_CONST(42174.863222358137/8.0),
    REAL_CONST(42193.971729083758/8.0),
    REAL_CONST(42213.082399485655/8.0),
    REAL_CONST(42232.195233074002/8.0),
    REAL_CONST(42251.310229359246/8.0),
    REAL_CONST(42270.427387852127/8.0),
    REAL_CONST(42289.546708063644/8.0),
    REAL_CONST(42308.668189505079/8.0),
    REAL_CONST(42327.791831687995/8.0),
    REAL_CONST(42346.917634124227/8.0),
    REAL_CONST(42366.045596325886/8.0),
    REAL_CONST(42385.175717805352/8.0),
    REAL_CONST(42404.307998075295/8.0),
    REAL_CONST(42423.442436648642/8.0),
    REAL_CONST(42442.579033038608/8.0),
    REAL_CONST(42461.717786758672/8.0),
    REAL_CONST(42480.858697322597/8.0),
    REAL_CONST(42500.001764244422/8.0),
    REAL_CONST(42519.146987038446/8.0),
    REAL_CONST(42538.294365219248/8.0),
    REAL_CONST(42557.443898301688/8.0),
    REAL_CONST(42576.595585800882/8.0),
    REAL_CONST(42595.749427232236/8.0),
    REAL_CONST(42614.90542211142/8.0),
    REAL_CONST(42634.063569954378/8.0),
    REAL_CONST(42653.223870277317/8.0),
    REAL_CONST(42672.386322596729/8.0),
    REAL_CONST(42691.55092642938/8.0),
    REAL_CONST(42710.717681292292/8.0),
    REAL_CONST(42729.886586702756/8.0),
    REAL_CONST(42749.057642178363/8.0),
    REAL_CONST(42768.23084723694/8.0),
    REAL_CONST(42787.406201396603/8.0),
    REAL_CONST(42806.58370417574/8.0),
    REAL_CONST(42825.76335509299/8.0),
    REAL_CONST(42844.945153667286/8.0),
    REAL_CONST(42864.129099417805/8.0),
    REAL_CONST(42883.315191864014/8.0),
    REAL_CONST(42902.503430525649/8.0),
    REAL_CONST(42921.693814922692/8.0),
    REAL_CONST(42940.88634457541/8.0),
    REAL_CONST(42960.081019004348/8.0),
    REAL_CONST(42979.277837730297/8.0),
    REAL_CONST(42998.476800274322/8.0),
    REAL_CONST(43017.677906157769/8.0),
    REAL_CONST(43036.881154902228/8.0),
    REAL_CONST(43056.086546029583/8.0),
    REAL_CONST(43075.294079061961/8.0),
    REAL_CONST(43094.503753521763/8.0),
    REAL_CONST(43113.715568931671/8.0),
    REAL_CONST(43132.929524814601/8.0),
    REAL_CONST(43152.145620693766/8.0),
    REAL_CONST(43171.363856092619/8.0),
    REAL_CONST(43190.584230534907/8.0),
    REAL_CONST(43209.806743544621/8.0),
    REAL_CONST(43229.031394646016/8.0),
    REAL_CONST(43248.258183363621/8.0),
    REAL_CONST(43267.487109222224/8.0),
    REAL_CONST(43286.718171746885/8.0),
    REAL_CONST(43305.951370462906/8.0),
    REAL_CONST(43325.186704895881/8.0),
    REAL_CONST(43344.42417457165/8.0),
    REAL_CONST(43363.663779016322/8.0),
    REAL_CONST(43382.905517756262/8.0),
    REAL_CONST(43402.149390318104/8.0),
    REAL_CONST(43421.395396228749/8.0),
    REAL_CONST(43440.643535015348/8.0),
    REAL_CONST(43459.89380620532/8.0),
    REAL_CONST(43479.146209326354/8.0),
    REAL_CONST(43498.400743906379/8.0),
    REAL_CONST(43517.657409473606/8.0),
    REAL_CONST(43536.916205556496/8.0),
    REAL_CONST(43556.177131683784/8.0),
    REAL_CONST(43575.44018738444/8.0),
    REAL_CONST(43594.705372187724/8.0),
    REAL_CONST(43613.972685623135/8.0),
    REAL_CONST(43633.242127220445/8.0),
    REAL_CONST(43652.513696509668/8.0),
    REAL_CONST(43671.787393021099/8.0),
    REAL_CONST(43691.063216285271/8.0),
    REAL_CONST(43710.341165833001/8.0),
    REAL_CONST(43729.621241195346/8.0),
    REAL_CONST(43748.903441903625/8.0),
    REAL_CONST(43768.187767489413/8.0),
    REAL_CONST(43787.474217484552/8.0),
    REAL_CONST(43806.762791421126/8.0),
    REAL_CONST(43826.053488831501/8.0),
    REAL_CONST(43845.346309248278/8.0),
    REAL_CONST(43864.641252204325/8.0),
    REAL_CONST(43883.938317232765/8.0),
    REAL_CONST(43903.237503866971/8.0),
    REAL_CONST(43922.538811640596/8.0),
    REAL_CONST(43941.842240087513/8.0),
    REAL_CONST(43961.147788741881/8.0),
    REAL_CONST(43980.455457138101/8.0),
    REAL_CONST(43999.765244810835/8.0),
    REAL_CONST(44019.077151295001/8.0),
    REAL_CONST(44038.391176125755/8.0),
    REAL_CONST(44057.70731883854/8.0),
    REAL_CONST(44077.02557896902/8.0),
    REAL_CONST(44096.345956053141/8.0),
    REAL_CONST(44115.668449627083/8.0),
    REAL_CONST(44134.993059227287/8.0),
    REAL_CONST(44154.319784390456/8.0),
    REAL_CONST(44173.648624653535/8.0),
    REAL_CONST(44192.979579553728/8.0),
    REAL_CONST(44212.312648628489/8.0),
    REAL_CONST(44231.647831415532/8.0),
    REAL_CONST(44250.985127452805/8.0),
    REAL_CONST(44270.324536278538/8.0),
    REAL_CONST(44289.666057431183/8.0),
    REAL_CONST(44309.009690449464/8.0),
    REAL_CONST(44328.355434872348/8.0),
    REAL_CONST(44347.703290239064/8.0),
    REAL_CONST(44367.053256089079/8.0),
    REAL_CONST(44386.405331962109/8.0),
    REAL_CONST(44405.759517398139/8.0),
    REAL_CONST(44425.115811937387/8.0),
    REAL_CONST(44444.474215120332/8.0),
    REAL_CONST(44463.834726487694/8.0),
    REAL_CONST(44483.197345580462/8.0),
    REAL_CONST(44502.562071939843/8.0),
    REAL_CONST(44521.928905107328/8.0),
    REAL_CONST(44541.297844624634/8.0),
    REAL_CONST(44560.668890033732/8.0),
    REAL_CONST(44580.042040876848/8.0),
    REAL_CONST(44599.417296696454/8.0),
    REAL_CONST(44618.794657035272/8.0),
    REAL_CONST(44638.174121436256/8.0),
    REAL_CONST(44657.555689442641/8.0),
    REAL_CONST(44676.939360597877/8.0),
    REAL_CONST(44696.325134445673/8.0),
    REAL_CONST(44715.713010530002/8.0),
    REAL_CONST(44735.102988395054/8.0),
    REAL_CONST(44754.495067585296/8.0),
    REAL_CONST(44773.88924764542/8.0),
    REAL_CONST(44793.285528120374/8.0),
    REAL_CONST(44812.683908555344/8.0),
    REAL_CONST(44832.084388495779/8.0),
    REAL_CONST(44851.486967487363/8.0),
    REAL_CONST(44870.891645076015/8.0),
    REAL_CONST(44890.298420807922/8.0),
    REAL_CONST(44909.707294229491/8.0),
    REAL_CONST(44929.118264887409/8.0),
    REAL_CONST(44948.531332328566/8.0),
    REAL_CONST(44967.946496100136/8.0),
    REAL_CONST(44987.363755749502/8.0),
    REAL_CONST(45006.783110824319/8.0),
    REAL_CONST(45026.204560872473/8.0),
    REAL_CONST(45045.628105442098/8.0),
    REAL_CONST(45065.053744081561/8.0),
    REAL_CONST(45084.48147633949/8.0),
    REAL_CONST(45103.911301764747/8.0),
    REAL_CONST(45123.343219906426/8.0),
    REAL_CONST(45142.777230313885/8.0),
    REAL_CONST(45162.21333253671/8.0),
    REAL_CONST(45181.651526124733/8.0),
    REAL_CONST(45201.091810628037/8.0),
    REAL_CONST(45220.534185596924/8.0),
    REAL_CONST(45239.978650581965/8.0),
    REAL_CONST(45259.425205133957/8.0),
    REAL_CONST(45278.873848803938/8.0),
    REAL_CONST(45298.324581143192/8.0),
    REAL_CONST(45317.777401703235/8.0),
    REAL_CONST(45337.232310035848/8.0),
    REAL_CONST(45356.68930569302/8.0),
    REAL_CONST(45376.148388226997/8.0),
    REAL_CONST(45395.60955719027/8.0),
    REAL_CONST(45415.072812135557/8.0),
    REAL_CONST(45434.538152615823/8.0),
    REAL_CONST(45454.005578184282/8.0),
    REAL_CONST(45473.475088394356/8.0),
    REAL_CONST(45492.946682799746/8.0),
    REAL_CONST(45512.420360954362/8.0),
    REAL_CONST(45531.896122412363/8.0),
    REAL_CONST(45551.373966728155/8.0),
    REAL_CONST(45570.853893456362/8.0),
    REAL_CONST(45590.33590215187/8.0),
    REAL_CONST(45609.819992369776/8.0),
    REAL_CONST(45629.306163665438/8.0),
    REAL_CONST(45648.794415594442/8.0),
    REAL_CONST(45668.284747712612/8.0),
    REAL_CONST(45687.777159576006/8.0),
    REAL_CONST(45707.27165074092/8.0),
    REAL_CONST(45726.768220763894/8.0),
    REAL_CONST(45746.266869201696/8.0),
    REAL_CONST(45765.767595611323/8.0),
    REAL_CONST(45785.270399550034/8.0),
    REAL_CONST(45804.775280575297/8.0),
    REAL_CONST(45824.282238244828/8.0),
    REAL_CONST(45843.79127211657/8.0),
    REAL_CONST(45863.302381748719/8.0),
    REAL_CONST(45882.815566699683/8.0),
    REAL_CONST(45902.33082652813/8.0),
    REAL_CONST(45921.848160792935/8.0),
    REAL_CONST(45941.367569053225/8.0),
    REAL_CONST(45960.889050868354/8.0),
    REAL_CONST(45980.41260579793/8.0),
    REAL_CONST(45999.938233401757/8.0),
    REAL_CONST(46019.465933239902/8.0),
    REAL_CONST(46038.995704872657/8.0),
    REAL_CONST(46058.527547860547/8.0),
    REAL_CONST(46078.06146176433/8.0),
    REAL_CONST(46097.597446144995/8.0),
    REAL_CONST(46117.135500563774/8.0),
    REAL_CONST(46136.675624582109/8.0),
    REAL_CONST(46156.217817761702/8.0),
    REAL_CONST(46175.762079664462/8.0),
    REAL_CONST(46195.308409852543/8.0),
    REAL_CONST(46214.856807888333/8.0),
    REAL_CONST(46234.407273334444/8.0),
    REAL_CONST(46253.959805753715/8.0),
    REAL_CONST(46273.51440470924/8.0),
    REAL_CONST(46293.071069764315/8.0),
    REAL_CONST(46312.629800482478/8.0),
    REAL_CONST(46332.190596427499/8.0),
    REAL_CONST(46351.753457163381/8.0),
    REAL_CONST(46371.318382254351/8.0),
    REAL_CONST(46390.885371264863/8.0),
    REAL_CONST(46410.45442375962/8.0),
    REAL_CONST(46430.025539303526/8.0),
    REAL_CONST(46449.598717461733/8.0),
    REAL_CONST(46469.17395779962/8.0),
    REAL_CONST(46488.751259882782/8.0),
    REAL_CONST(46508.33062327707/8.0),
    REAL_CONST(46527.912047548532/8.0),
    REAL_CONST(46547.495532263471/8.0),
    REAL_CONST(46567.081076988397/8.0),
    REAL_CONST(46586.668681290059/8.0),
    REAL_CONST(46606.258344735434/8.0),
    REAL_CONST(46625.850066891719/8.0),
    REAL_CONST(46645.443847326351/8.0),
    REAL_CONST(46665.039685606986/8.0),
    REAL_CONST(46684.637581301497/8.0),
    REAL_CONST(46704.237533978005/8.0),
    REAL_CONST(46723.839543204842/8.0),
    REAL_CONST(46743.443608550573/8.0),
    REAL_CONST(46763.049729583989/8.0),
    REAL_CONST(46782.657905874104/8.0),
    REAL_CONST(46802.268136990162/8.0),
    REAL_CONST(46821.880422501628/8.0),
    REAL_CONST(46841.494761978196/8.0),
    REAL_CONST(46861.111154989776/8.0),
    REAL_CONST(46880.729601106526/8.0),
    REAL_CONST(46900.350099898795/8.0),
    REAL_CONST(46919.97265093719/8.0),
    REAL_CONST(46939.597253792526/8.0),
    REAL_CONST(46959.223908035841/8.0),
    REAL_CONST(46978.852613238392/8.0),
    REAL_CONST(46998.483368971691/8.0),
    REAL_CONST(47018.11617480743/8.0),
    REAL_CONST(47037.751030317551/8.0),
    REAL_CONST(47057.387935074221/8.0),
    REAL_CONST(47077.026888649809/8.0),
    REAL_CONST(47096.66789061694/8.0),
    REAL_CONST(47116.310940548428/8.0),
    REAL_CONST(47135.956038017328/8.0),
    REAL_CONST(47155.603182596918/8.0),
    REAL_CONST(47175.252373860698/8.0),
    REAL_CONST(47194.903611382375/8.0),
    REAL_CONST(47214.556894735892/8.0),
    REAL_CONST(47234.212223495422/8.0),
    REAL_CONST(47253.869597235338/8.0),
    REAL_CONST(47273.52901553025/8.0),
    REAL_CONST(47293.19047795498/8.0),
    REAL_CONST(47312.853984084577/8.0),
    REAL_CONST(47332.519533494306/8.0),
    REAL_CONST(47352.187125759658/8.0),
    REAL_CONST(47371.856760456343/8.0),
    REAL_CONST(47391.528437160297/8.0),
    REAL_CONST(47411.202155447652/8.0),
    REAL_CONST(47430.877914894787/8.0),
    REAL_CONST(47450.555715078299/8.0),
    REAL_CONST(47470.235555574982/8.0),
    REAL_CONST(47489.917435961863/8.0),
    REAL_CONST(47509.601355816201/8.0),
    REAL_CONST(47529.287314715453/8.0),
    REAL_CONST(47548.975312237308/8.0),
    REAL_CONST(47568.665347959672/8.0),
    REAL_CONST(47588.357421460656/8.0),
    REAL_CONST(47608.051532318605/8.0),
    REAL_CONST(47627.747680112072/8.0),
    REAL_CONST(47647.445864419846/8.0),
    REAL_CONST(47667.14608482091/8.0),
    REAL_CONST(47686.848340894474/8.0),
    REAL_CONST(47706.552632219973/8.0),
    REAL_CONST(47726.258958377046/8.0),
    REAL_CONST(47745.967318945557/8.0),
    REAL_CONST(47765.677713505589/8.0),
    REAL_CONST(47785.390141637428/8.0),
    REAL_CONST(47805.104602921601/8.0),
    REAL_CONST(47824.821096938824/8.0),
    REAL_CONST(47844.539623270044/8.0),
    REAL_CONST(47864.260181496429/8.0),
    REAL_CONST(47883.982771199349/8.0),
    REAL_CONST(47903.707391960394/8.0),
    REAL_CONST(47923.434043361369/8.0),
    REAL_CONST(47943.162724984308/8.0),
    REAL_CONST(47962.893436411439/8.0),
    REAL_CONST(47982.626177225218/8.0),
    REAL_CONST(48002.36094700831/8.0),
    REAL_CONST(48022.097745343599/8.0),
    REAL_CONST(48041.836571814172/8.0),
    REAL_CONST(48061.57742600335/8.0),
    REAL_CONST(48081.32030749465/8.0),
    REAL_CONST(48101.065215871815/8.0),
    REAL_CONST(48120.81215071879/8.0),
    REAL_CONST(48140.56111161974/8.0),
    REAL_CONST(48160.312098159047/8.0),
    REAL_CONST(48180.065109921306/8.0),
    REAL_CONST(48199.820146491307/8.0),
    REAL_CONST(48219.577207454073/8.0),
    REAL_CONST(48239.336292394844/8.0),
    REAL_CONST(48259.097400899045/8.0),
    REAL_CONST(48278.860532552339/8.0),
    REAL_CONST(48298.625686940592/8.0),
    REAL_CONST(48318.392863649875/8.0),
    REAL_CONST(48338.162062266485/8.0),
    REAL_CONST(48357.933282376915/8.0),
    REAL_CONST(48377.706523567889/8.0),
    REAL_CONST(48397.481785426316/8.0),
    REAL_CONST(48417.259067539344/8.0),
    REAL_CONST(48437.038369494308/8.0),
    REAL_CONST(48456.819690878765/8.0),
    REAL_CONST(48476.603031280487/8.0),
    REAL_CONST(48496.388390287451/8.0),
    REAL_CONST(48516.175767487839/8.0),
    REAL_CONST(48535.965162470042/8.0),
    REAL_CONST(48555.756574822684/8.0),
    REAL_CONST(48575.550004134566/8.0),
    REAL_CONST(48595.345449994718/8.0),
    REAL_CONST(48615.142911992378/8.0),
    REAL_CONST(48634.942389716991/8.0),
    REAL_CONST(48654.743882758201/8.0),
    REAL_CONST(48674.547390705877/8.0),
    REAL_CONST(48694.352913150084/8.0),
    REAL_CONST(48714.160449681112/8.0),
    REAL_CONST(48733.969999889443/8.0),
    REAL_CONST(48753.781563365759/8.0),
    REAL_CONST(48773.595139700978/8.0),
    REAL_CONST(48793.410728486211/8.0),
    REAL_CONST(48813.228329312769/8.0),
    REAL_CONST(48833.047941772187/8.0),
    REAL_CONST(48852.869565456189/8.0),
    REAL_CONST(48872.693199956717/8.0),
    REAL_CONST(48892.518844865925/8.0),
    REAL_CONST(48912.346499776155/8.0),
    REAL_CONST(48932.176164279976/8.0),
    REAL_CONST(48952.007837970152/8.0),
    REAL_CONST(48971.841520439666/8.0),
    REAL_CONST(48991.677211281676/8.0),
    REAL_CONST(49011.514910089587/8.0),
    REAL_CONST(49031.354616456978/8.0),
    REAL_CONST(49051.196329977654/8.0),
    REAL_CONST(49071.04005024561/8.0),
    REAL_CONST(49090.885776855059/8.0),
    REAL_CONST(49110.733509400408/8.0),
    REAL_CONST(49130.583247476279/8.0),
    REAL_CONST(49150.434990677488/8.0),
    REAL_CONST(49170.288738599062/8.0),
    REAL_CONST(49190.144490836232/8.0),
    REAL_CONST(49210.002246984441/8.0),
    REAL_CONST(49229.86200663932/8.0),
    REAL_CONST(49249.723769396718/8.0),
    REAL_CONST(49269.587534852675/8.0),
    REAL_CONST(49289.453302603448/8.0),
    REAL_CONST(49309.32107224549/8.0),
    REAL_CONST(49329.190843375451/8.0),
    REAL_CONST(49349.062615590192/8.0),
    REAL_CONST(49368.936388486785/8.0),
    REAL_CONST(49388.812161662492/8.0),
    REAL_CONST(49408.689934714785/8.0),
    REAL_CONST(49428.569707241324/8.0),
    REAL_CONST(49448.45147883999/8.0),
    REAL_CONST(49468.335249108866/8.0),
    REAL_CONST(49488.22101764621/8.0),
    REAL_CONST(49508.108784050521/8.0),
    REAL_CONST(49527.99854792047/8.0),
    REAL_CONST(49547.890308854934/8.0),
    REAL_CONST(49567.784066453009/8.0),
    REAL_CONST(49587.679820313977/8.0),
    REAL_CONST(49607.57757003732/8.0),
    REAL_CONST(49627.477315222721/8.0),
    REAL_CONST(49647.379055470075/8.0),
    REAL_CONST(49667.28279037946/8.0),
    REAL_CONST(49687.188519551179/8.0),
    REAL_CONST(49707.096242585707/8.0),
    REAL_CONST(49727.005959083741/8.0),
    REAL_CONST(49746.917668646165/8.0),
    REAL_CONST(49766.831370874068/8.0),
    REAL_CONST(49786.747065368734/8.0),
    REAL_CONST(49806.66475173166/8.0),
    REAL_CONST(49826.584429564515/8.0),
    REAL_CONST(49846.506098469203/8.0),
    REAL_CONST(49866.429758047794/8.0),
    REAL_CONST(49886.355407902578/8.0),
    REAL_CONST(49906.283047636032/8.0),
    REAL_CONST(49926.212676850846/8.0),
    REAL_CONST(49946.144295149883/8.0),
    REAL_CONST(49966.077902136225/8.0),
    REAL_CONST(49986.013497413151/8.0),
    REAL_CONST(50005.951080584135/8.0),
    REAL_CONST(50025.890651252834/8.0),
    REAL_CONST(50045.832209023123/8.0),
    REAL_CONST(50065.775753499074/8.0),
    REAL_CONST(50085.721284284933/8.0),
    REAL_CONST(50105.668800985164/8.0),
    REAL_CONST(50125.618303204428/8.0),
    REAL_CONST(50145.569790547575/8.0),
    REAL_CONST(50165.523262619652/8.0),
    REAL_CONST(50185.478719025901/8.0),
    REAL_CONST(50205.436159371769/8.0),
    REAL_CONST(50225.395583262893/8.0),
    REAL_CONST(50245.356990305103/8.0),
    REAL_CONST(50265.320380104429/8.0),
    REAL_CONST(50285.285752267104/8.0),
    REAL_CONST(50305.253106399534/8.0),
    REAL_CONST(50325.222442108337/8.0),
    REAL_CONST(50345.193759000336/8.0),
    REAL_CONST(50365.16705668252/8.0),
    REAL_CONST(50385.142334762102/8.0),
    REAL_CONST(50405.119592846473/8.0),
    REAL_CONST(50425.098830543218/8.0),
    REAL_CONST(50445.080047460127/8.0),
    REAL_CONST(50465.063243205179/8.0),
    REAL_CONST(50485.048417386541/8.0),
    REAL_CONST(50505.035569612577/8.0),
    REAL_CONST(50525.024699491856/8.0),
    REAL_CONST(50545.015806633128/8.0),
    REAL_CONST(50565.008890645338/8.0),
    REAL_CONST(50585.003951137631/8.0),
    REAL_CONST(50605.00098771933/8.0),
    REAL_CONST(50624.999999999971/8.0),
    REAL_CONST(50645.000987589265/8.0),
    REAL_CONST(50665.003950097132/8.0),
    REAL_CONST(50685.008887133677/8.0),
    REAL_CONST(50705.015798309192/8.0),
    REAL_CONST(50725.024683234165/8.0),
    REAL_CONST(50745.035541519283/8.0),
    REAL_CONST(50765.048372775411/8.0),
    REAL_CONST(50785.063176613621/8.0),
    REAL_CONST(50805.079952645159/8.0),
    REAL_CONST(50825.098700481489/8.0),
    REAL_CONST(50845.119419734241/8.0),
    REAL_CONST(50865.142110015244/8.0),
    REAL_CONST(50885.166770936521/8.0),
    REAL_CONST(50905.193402110279/8.0),
    REAL_CONST(50925.222003148934/8.0),
    REAL_CONST(50945.252573665071/8.0),
    REAL_CONST(50965.285113271471/8.0),
    REAL_CONST(50985.319621581119/8.0),
    REAL_CONST(51005.356098207172/8.0),
    REAL_CONST(51025.394542762981/8.0),
    REAL_CONST(51045.434954862096/8.0),
    REAL_CONST(51065.477334118244/8.0),
    REAL_CONST(51085.521680145357/8.0),
    REAL_CONST(51105.567992557546/8.0),
    REAL_CONST(51125.616270969113/8.0),
    REAL_CONST(51145.66651499454/8.0),
    REAL_CONST(51165.718724248516/8.0),
    REAL_CONST(51185.772898345916/8.0),
    REAL_CONST(51205.829036901778/8.0),
    REAL_CONST(51225.887139531362/8.0),
    REAL_CONST(51245.947205850105/8.0),
    REAL_CONST(51266.009235473619/8.0),
    REAL_CONST(51286.073228017718/8.0),
    REAL_CONST(51306.139183098399/8.0),
    REAL_CONST(51326.207100331856/8.0),
    REAL_CONST(51346.276979334456/8.0),
    REAL_CONST(51366.348819722756/8.0),
    REAL_CONST(51386.42262111351/8.0),
    REAL_CONST(51406.498383123653/8.0),
    REAL_CONST(51426.57610537031/8.0),
    REAL_CONST(51446.655787470787/8.0),
    REAL_CONST(51466.737429042587/8.0),
    REAL_CONST(51486.82102970338/8.0),
    REAL_CONST(51506.906589071048/8.0),
    REAL_CONST(51526.994106763632/8.0),
    REAL_CONST(51547.083582399391/8.0),
    REAL_CONST(51567.175015596738/8.0),
    REAL_CONST(51587.268405974297/8.0),
    REAL_CONST(51607.363753150858/8.0),
    REAL_CONST(51627.461056745415/8.0),
    REAL_CONST(51647.56031637713/8.0),
    REAL_CONST(51667.661531665362/8.0),
    REAL_CONST(51687.764702229651/8.0),
    REAL_CONST(51707.869827689727/8.0),
    REAL_CONST(51727.976907665499/8.0),
    REAL_CONST(51748.085941777055/8.0),
    REAL_CONST(51768.196929644677/8.0),
    REAL_CONST(51788.309870888836/8.0),
    REAL_CONST(51808.42476513017/8.0),
    REAL_CONST(51828.541611989524/8.0),
    REAL_CONST(51848.660411087905/8.0),
    REAL_CONST(51868.781162046515/8.0),
    REAL_CONST(51888.90386448674/8.0),
    REAL_CONST(51909.028518030143/8.0),
    REAL_CONST(51929.155122298485/8.0),
    REAL_CONST(51949.283676913685/8.0),
    REAL_CONST(51969.414181497872/8.0),
    REAL_CONST(51989.546635673345/8.0),
    REAL_CONST(52009.681039062583/8.0),
    REAL_CONST(52029.817391288263/8.0),
    REAL_CONST(52049.955691973213/8.0),
    REAL_CONST(52070.095940740481/8.0),
    REAL_CONST(52090.238137213273/8.0),
    REAL_CONST(52110.382281014987/8.0),
    REAL_CONST(52130.5283717692/8.0),
    REAL_CONST(52150.676409099666/8.0),
    REAL_CONST(52170.826392630333/8.0),
    REAL_CONST(52190.97832198532/8.0),
    REAL_CONST(52211.132196788931/8.0),
    REAL_CONST(52231.288016665654/8.0),
    REAL_CONST(52251.445781240145/8.0),
    REAL_CONST(52271.60549013727/8.0),
    REAL_CONST(52291.76714298204/8.0),
    REAL_CONST(52311.930739399664/8.0),
    REAL_CONST(52332.096279015546/8.0),
    REAL_CONST(52352.263761455244/8.0),
    REAL_CONST(52372.433186344519/8.0),
    REAL_CONST(52392.604553309284/8.0),
    REAL_CONST(52412.777861975665/8.0),
    REAL_CONST(52432.953111969946/8.0),
    REAL_CONST(52453.130302918595/8.0),
    REAL_CONST(52473.309434448267/8.0),
    REAL_CONST(52493.490506185793/8.0),
    REAL_CONST(52513.67351775818/8.0),
    REAL_CONST(52533.858468792605/8.0),
    REAL_CONST(52554.045358916446/8.0),
    REAL_CONST(52574.234187757254/8.0),
    REAL_CONST(52594.42495494274/8.0),
    REAL_CONST(52614.617660100812/8.0),
    REAL_CONST(52634.812302859558/8.0),
    REAL_CONST(52655.008882847229/8.0),
    REAL_CONST(52675.20739969227/8.0),
    REAL_CONST(52695.407853023295/8.0),
    REAL_CONST(52715.610242469098/8.0),
    REAL_CONST(52735.814567658657/8.0),
    REAL_CONST(52756.02082822111/8.0),
    REAL_CONST(52776.229023785803/8.0),
    REAL_CONST(52796.439153982225/8.0),
    REAL_CONST(52816.651218440056/8.0),
    REAL_CONST(52836.865216789171/8.0),
    REAL_CONST(52857.081148659599/8.0),
    REAL_CONST(52877.29901368155/8.0),
    REAL_CONST(52897.518811485425/8.0),
    REAL_CONST(52917.740541701773/8.0),
    REAL_CONST(52937.964203961354/8.0),
    REAL_CONST(52958.18979789508/8.0),
    REAL_CONST(52978.417323134046/8.0),
    REAL_CONST(52998.646779309529/8.0),
    REAL_CONST(53018.878166052978/8.0),
    REAL_CONST(53039.111482996006/8.0),
    REAL_CONST(53059.346729770419/8.0),
    REAL_CONST(53079.583906008193/8.0),
    REAL_CONST(53099.823011341483/8.0),
    REAL_CONST(53120.0640454026/8.0),
    REAL_CONST(53140.307007824063/8.0),
    REAL_CONST(53160.551898238533/8.0),
    REAL_CONST(53180.79871627887/8.0),
    REAL_CONST(53201.047461578091/8.0),
    REAL_CONST(53221.2981337694/8.0),
    REAL_CONST(53241.550732486176/8.0),
    REAL_CONST(53261.805257361964/8.0),
    REAL_CONST(53282.061708030487/8.0),
    REAL_CONST(53302.32008412564/8.0),
    REAL_CONST(53322.580385281493/8.0),
    REAL_CONST(53342.842611132299/8.0),
    REAL_CONST(53363.106761312469/8.0),
    REAL_CONST(53383.372835456597/8.0),
    REAL_CONST(53403.640833199453/8.0),
    REAL_CONST(53423.910754175973/8.0),
    REAL_CONST(53444.18259802126/8.0),
    REAL_CONST(53464.456364370613/8.0),
    REAL_CONST(53484.732052859479/8.0),
    REAL_CONST(53505.009663123499/8.0),
    REAL_CONST(53525.289194798468/8.0),
    REAL_CONST(53545.570647520362/8.0),
    REAL_CONST(53565.854020925333/8.0),
    REAL_CONST(53586.139314649699/8.0),
    REAL_CONST(53606.426528329954/8.0),
    REAL_CONST(53626.715661602764/8.0),
    REAL_CONST(53647.006714104959/8.0),
    REAL_CONST(53667.299685473547/8.0),
    REAL_CONST(53687.59457534572/8.0),
    REAL_CONST(53707.891383358816/8.0),
    REAL_CONST(53728.190109150361/8.0),
    REAL_CONST(53748.490752358055/8.0),
    REAL_CONST(53768.793312619753/8.0),
    REAL_CONST(53789.09778957349/8.0),
    REAL_CONST(53809.404182857485/8.0),
    REAL_CONST(53829.712492110106/8.0),
    REAL_CONST(53850.022716969899/8.0),
    REAL_CONST(53870.334857075584/8.0),
    REAL_CONST(53890.648912066055/8.0),
    REAL_CONST(53910.964881580367/8.0),
    REAL_CONST(53931.28276525774/8.0),
    REAL_CONST(53951.602562737586/8.0),
    REAL_CONST(53971.924273659461/8.0),
    REAL_CONST(53992.24789766311/8.0),
    REAL_CONST(54012.57343438844/8.0),
    REAL_CONST(54032.90088347553/8.0),
    REAL_CONST(54053.23024456462/8.0),
    REAL_CONST(54073.561517296133/8.0),
    REAL_CONST(54093.894701310644/8.0),
    REAL_CONST(54114.22979624891/8.0),
    REAL_CONST(54134.566801751855/8.0),
    REAL_CONST(54154.90571746057/8.0),
    REAL_CONST(54175.246543016314/8.0),
    REAL_CONST(54195.589278060506/8.0),
    REAL_CONST(54215.933922234755/8.0),
    REAL_CONST(54236.280475180814/8.0),
    REAL_CONST(54256.628936540626/8.0),
    REAL_CONST(54276.97930595628/8.0),
    REAL_CONST(54297.331583070045/8.0),
    REAL_CONST(54317.685767524359/8.0),
    REAL_CONST(54338.041858961828/8.0),
    REAL_CONST(54358.399857025215/8.0),
    REAL_CONST(54378.759761357462/8.0),
    REAL_CONST(54399.121571601667/8.0),
    REAL_CONST(54419.485287401105/8.0),
    REAL_CONST(54439.850908399218/8.0),
    REAL_CONST(54460.218434239614/8.0),
    REAL_CONST(54480.587864566056/8.0),
    REAL_CONST(54500.95919902248/8.0),
    REAL_CONST(54521.332437252997/8.0),
    REAL_CONST(54541.707578901878/8.0),
    REAL_CONST(54562.084623613555/8.0),
    REAL_CONST(54582.46357103264/8.0),
    REAL_CONST(54602.844420803893/8.0),
    REAL_CONST(54623.227172572246/8.0),
    REAL_CONST(54643.611825982807/8.0),
    REAL_CONST(54663.998380680838/8.0),
    REAL_CONST(54684.386836311773/8.0),
    REAL_CONST(54704.777192521207/8.0),
    REAL_CONST(54725.169448954897/8.0),
    REAL_CONST(54745.563605258772/8.0),
    REAL_CONST(54765.959661078923/8.0),
    REAL_CONST(54786.357616061614/8.0),
    REAL_CONST(54806.757469853255/8.0),
    REAL_CONST(54827.159222100439/8.0),
    REAL_CONST(54847.562872449904/8.0),
    REAL_CONST(54867.968420548583/8.0),
    REAL_CONST(54888.375866043534/8.0),
    REAL_CONST(54908.785208582012/8.0),
    REAL_CONST(54929.196447811417/8.0),
    REAL_CONST(54949.609583379322/8.0),
    REAL_CONST(54970.024614933463/8.0),
    REAL_CONST(54990.441542121727/8.0),
    REAL_CONST(55010.86036459219/8.0),
    REAL_CONST(55031.28108199306/8.0),
    REAL_CONST(55051.703693972733/8.0),
    REAL_CONST(55072.128200179759/8.0),
    REAL_CONST(55092.554600262847/8.0),
    REAL_CONST(55112.982893870874/8.0),
    REAL_CONST(55133.413080652877/8.0),
    REAL_CONST(55153.845160258061/8.0),
    REAL_CONST(55174.279132335789/8.0),
    REAL_CONST(55194.714996535586/8.0),
    REAL_CONST(55215.152752507143/8.0),
    REAL_CONST(55235.592399900306/8.0),
    REAL_CONST(55256.033938365079/8.0),
    REAL_CONST(55276.477367551655/8.0),
    REAL_CONST(55296.92268711036/8.0),
    REAL_CONST(55317.369896691685/8.0),
    REAL_CONST(55337.818995946305/8.0),
    REAL_CONST(55358.269984525024/8.0),
    REAL_CONST(55378.72286207883/8.0),
    REAL_CONST(55399.177628258869/8.0),
    REAL_CONST(55419.634282716441/8.0),
    REAL_CONST(55440.092825103013/8.0),
    REAL_CONST(55460.553255070205/8.0),
    REAL_CONST(55481.015572269804/8.0),
    REAL_CONST(55501.479776353764/8.0),
    REAL_CONST(55521.945866974187/8.0),
    REAL_CONST(55542.413843783339/8.0),
    REAL_CONST(55562.883706433655/8.0),
    REAL_CONST(55583.355454577715/8.0),
    REAL_CONST(55603.82908786826/8.0),
    REAL_CONST(55624.304605958219/8.0),
    REAL_CONST(55644.782008500639/8.0),
    REAL_CONST(55665.261295148754/8.0),
    REAL_CONST(55685.742465555952/8.0),
    REAL_CONST(55706.225519375774/8.0),
    REAL_CONST(55726.710456261928/8.0),
    REAL_CONST(55747.197275868275/8.0),
    REAL_CONST(55767.685977848843/8.0),
    REAL_CONST(55788.176561857814/8.0),
    REAL_CONST(55808.669027549528/8.0),
    REAL_CONST(55829.163374578478/8.0),
    REAL_CONST(55849.659602599328/8.0),
    REAL_CONST(55870.157711266889/8.0),
    REAL_CONST(55890.657700236145/8.0),
    REAL_CONST(55911.159569162221/8.0),
    REAL_CONST(55931.663317700411/8.0),
    REAL_CONST(55952.168945506164/8.0),
    REAL_CONST(55972.676452235086/8.0),
    REAL_CONST(55993.185837542944/8.0),
    REAL_CONST(56013.697101085651/8.0),
    REAL_CONST(56034.210242519301/8.0),
    REAL_CONST(56054.72526150012/8.0),
    REAL_CONST(56075.242157684508/8.0),
    REAL_CONST(56095.760930729011/8.0),
    REAL_CONST(56116.281580290342/8.0),
    REAL_CONST(56136.804106025367/8.0),
    REAL_CONST(56157.328507591104/8.0),
    REAL_CONST(56177.85478464474/8.0),
    REAL_CONST(56198.382936843598/8.0),
    REAL_CONST(56218.912963845185/8.0),
    REAL_CONST(56239.444865307138/8.0),
    REAL_CONST(56259.978640887268/8.0),
    REAL_CONST(56280.514290243525/8.0),
    REAL_CONST(56301.051813034042/8.0),
    REAL_CONST(56321.591208917082/8.0),
    REAL_CONST(56342.13247755108/8.0),
    REAL_CONST(56362.675618594607/8.0),
    REAL_CONST(56383.220631706419/8.0),
    REAL_CONST(56403.767516545398/8.0),
    REAL_CONST(56424.316272770608/8.0),
    REAL_CONST(56444.866900041241/8.0),
    REAL_CONST(56465.419398016667/8.0),
    REAL_CONST(56485.973766356394/8.0),
    REAL_CONST(56506.530004720102/8.0),
    REAL_CONST(56527.088112767611/8.0),
    REAL_CONST(56547.648090158902/8.0),
    REAL_CONST(56568.209936554107/8.0),
    REAL_CONST(56588.773651613519/8.0),
    REAL_CONST(56609.339234997584/8.0),
    REAL_CONST(56629.9066863669/8.0),
    REAL_CONST(56650.47600538221/8.0),
    REAL_CONST(56671.04719170442/8.0),
    REAL_CONST(56691.620244994599/8.0),
    REAL_CONST(56712.195164913959/8.0),
    REAL_CONST(56732.771951123868/8.0),
    REAL_CONST(56753.350603285835/8.0),
    REAL_CONST(56773.931121061541/8.0),
    REAL_CONST(56794.513504112823/8.0),
    REAL_CONST(56815.097752101647/8.0),
    REAL_CONST(56835.683864690152/8.0),
    REAL_CONST(56856.271841540627/8.0),
    REAL_CONST(56876.86168231551/8.0),
    REAL_CONST(56897.453386677393/8.0),
    REAL_CONST(56918.046954289028/8.0),
    REAL_CONST(56938.642384813298/8.0),
    REAL_CONST(56959.239677913261/8.0),
    REAL_CONST(56979.838833252121/8.0),
    REAL_CONST(57000.439850493225/8.0),
    REAL_CONST(57021.04272930009/8.0),
    REAL_CONST(57041.647469336371/8.0),
    REAL_CONST(57062.254070265873/8.0),
    REAL_CONST(57082.862531752558/8.0),
    REAL_CONST(57103.472853460553/8.0),
    REAL_CONST(57124.085035054108/8.0),
    REAL_CONST(57144.699076197649/8.0),
    REAL_CONST(57165.314976555739/8.0),
    REAL_CONST(57185.932735793103/8.0),
    REAL_CONST(57206.552353574611/8.0),
    REAL_CONST(57227.173829565276/8.0),
    REAL_CONST(57247.797163430281/8.0),
    REAL_CONST(57268.42235483494/8.0),
    REAL_CONST(57289.049403444733/8.0),
    REAL_CONST(57309.678308925286/8.0),
    REAL_CONST(57330.30907094237/8.0),
    REAL_CONST(57350.941689161911/8.0),
    REAL_CONST(57371.576163249985/8.0),
    REAL_CONST(57392.212492872815/8.0),
    REAL_CONST(57412.850677696784/8.0),
    REAL_CONST(57433.490717388406/8.0),
    REAL_CONST(57454.132611614368/8.0),
    REAL_CONST(57474.776360041491/8.0),
    REAL_CONST(57495.421962336746/8.0),
    REAL_CONST(57516.069418167266/8.0),
    REAL_CONST(57536.718727200314/8.0),
    REAL_CONST(57557.36988910332/8.0),
    REAL_CONST(57578.022903543861/8.0),
    REAL_CONST(57598.677770189643/8.0),
    REAL_CONST(57619.334488708548/8.0),
    REAL_CONST(57639.993058768589/8.0),
    REAL_CONST(57660.653480037938/8.0),
    REAL_CONST(57681.315752184906/8.0),
    REAL_CONST(57701.979874877965/8.0),
    REAL_CONST(57722.64584778573/8.0),
    REAL_CONST(57743.31367057695/8.0),
    REAL_CONST(57763.983342920546/8.0),
    REAL_CONST(57784.654864485572/8.0),
    REAL_CONST(57805.328234941233/8.0),
    REAL_CONST(57826.003453956881/8.0),
    REAL_CONST(57846.680521202026/8.0),
    REAL_CONST(57867.359436346305/8.0),
    REAL_CONST(57888.040199059527/8.0),
    REAL_CONST(57908.722809011633/8.0),
    REAL_CONST(57929.407265872709/8.0),
    REAL_CONST(57950.093569313001/8.0),
    REAL_CONST(57970.781719002895/8.0),
    REAL_CONST(57991.471714612911/8.0),
    REAL_CONST(58012.16355581375/8.0),
    REAL_CONST(58032.857242276223/8.0),
    REAL_CONST(58053.552773671312/8.0),
    REAL_CONST(58074.25014967013/8.0),
    REAL_CONST(58094.949369943948/8.0),
    REAL_CONST(58115.650434164185/8.0),
    REAL_CONST(58136.353342002389/8.0),
    REAL_CONST(58157.058093130276/8.0),
    REAL_CONST(58177.764687219693/8.0),
    REAL_CONST(58198.47312394264/8.0),
    REAL_CONST(58219.183402971255/8.0),
    REAL_CONST(58239.895523977837/8.0),
    REAL_CONST(58260.609486634821/8.0),
    REAL_CONST(58281.325290614775/8.0),
    REAL_CONST(58302.042935590434/8.0),
    REAL_CONST(58322.762421234678/8.0),
    REAL_CONST(58343.483747220511/8.0),
    REAL_CONST(58364.206913221096/8.0),
    REAL_CONST(58384.931918909751/8.0),
    REAL_CONST(58405.658763959924/8.0),
    REAL_CONST(58426.3874480452/8.0),
    REAL_CONST(58447.117970839339/8.0),
    REAL_CONST(58467.85033201622/8.0),
    REAL_CONST(58488.584531249864/8.0),
    REAL_CONST(58509.320568214462/8.0),
    REAL_CONST(58530.058442584334/8.0),
    REAL_CONST(58550.798154033931/8.0),
    REAL_CONST(58571.539702237875/8.0),
    REAL_CONST(58592.283086870906/8.0),
    REAL_CONST(58613.028307607929/8.0),
    REAL_CONST(58633.775364123983/8.0),
    REAL_CONST(58654.52425609425/8.0),
    REAL_CONST(58675.274983194053/8.0),
    REAL_CONST(58696.027545098877/8.0),
    REAL_CONST(58716.781941484325/8.0),
    REAL_CONST(58737.538172026158/8.0),
    REAL_CONST(58758.296236400274/8.0),
    REAL_CONST(58779.056134282728/8.0),
    REAL_CONST(58799.817865349694/8.0),
    REAL_CONST(58820.581429277503/8.0),
    REAL_CONST(58841.346825742643/8.0),
    REAL_CONST(58862.114054421712/8.0),
    REAL_CONST(58882.883114991484/8.0),
    REAL_CONST(58903.654007128847/8.0),
    REAL_CONST(58924.426730510851/8.0),
    REAL_CONST(58945.201284814684/8.0),
    REAL_CONST(58965.977669717664/8.0),
    REAL_CONST(58986.755884897269/8.0),
    REAL_CONST(59007.535930031117/8.0),
    REAL_CONST(59028.317804796949/8.0),
    REAL_CONST(59049.101508872664/8.0),
    REAL_CONST(59069.887041936301/8.0),
    REAL_CONST(59090.674403666046/8.0),
    REAL_CONST(59111.463593740213/8.0),
    REAL_CONST(59132.254611837263/8.0),
    REAL_CONST(59153.047457635803/8.0),
    REAL_CONST(59173.84213081457/8.0),
    REAL_CONST(59194.638631052461/8.0),
    REAL_CONST(59215.436958028506/8.0),
    REAL_CONST(59236.237111421855/8.0),
    REAL_CONST(59257.039090911829/8.0),
    REAL_CONST(59277.842896177877/8.0),
    REAL_CONST(59298.648526899589/8.0),
    REAL_CONST(59319.455982756685/8.0),
    REAL_CONST(59340.26526342905/8.0),
    REAL_CONST(59361.076368596696/8.0),
    REAL_CONST(59381.889297939757/8.0),
    REAL_CONST(59402.704051138542/8.0),
    REAL_CONST(59423.520627873484/8.0),
    REAL_CONST(59444.339027825139/8.0),
    REAL_CONST(59465.159250674224/8.0),
    REAL_CONST(59485.9812961016/8.0),
    REAL_CONST(59506.805163788253/8.0),
    REAL_CONST(59527.630853415307/8.0),
    REAL_CONST(59548.458364664046/8.0),
    REAL_CONST(59569.287697215863/8.0),
    REAL_CONST(59590.118850752311/8.0),
    REAL_CONST(59610.951824955089/8.0),
    REAL_CONST(59631.786619506012/8.0),
    REAL_CONST(59652.623234087048/8.0),
    REAL_CONST(59673.461668380311/8.0),
    REAL_CONST(59694.301922068029/8.0),
    REAL_CONST(59715.143994832593/8.0),
    REAL_CONST(59735.987886356525/8.0),
    REAL_CONST(59756.833596322482/8.0),
    REAL_CONST(59777.681124413255/8.0),
    REAL_CONST(59798.530470311794/8.0),
    REAL_CONST(59819.381633701159/8.0),
    REAL_CONST(59840.234614264569/8.0),
    REAL_CONST(59861.089411685381/8.0),
    REAL_CONST(59881.94602564707/8.0),
    REAL_CONST(59902.804455833269/8.0),
    REAL_CONST(59923.664701927737/8.0),
    REAL_CONST(59944.526763614384/8.0),
    REAL_CONST(59965.390640577243/8.0),
    REAL_CONST(59986.256332500488/8.0),
    REAL_CONST(60007.123839068438/8.0),
    REAL_CONST(60027.993159965539/8.0),
    REAL_CONST(60048.864294876381/8.0),
    REAL_CONST(60069.737243485688/8.0),
    REAL_CONST(60090.612005478324/8.0),
    REAL_CONST(60111.488580539284/8.0),
    REAL_CONST(60132.366968353708/8.0),
    REAL_CONST(60153.247168606867/8.0),
    REAL_CONST(60174.129180984164/8.0),
    REAL_CONST(60195.013005171153/8.0),
    REAL_CONST(60215.898640853513/8.0),
    REAL_CONST(60236.786087717061/8.0),
    REAL_CONST(60257.675345447751/8.0),
    REAL_CONST(60278.566413731671/8.0),
    REAL_CONST(60299.459292255044/8.0),
    REAL_CONST(60320.353980704247/8.0),
    REAL_CONST(60341.25047876576/8.0),
    REAL_CONST(60362.148786126229/8.0),
    REAL_CONST(60383.048902472423/8.0),
    REAL_CONST(60403.950827491237/8.0),
    REAL_CONST(60424.854560869717/8.0),
    REAL_CONST(60445.76010229504/8.0),
    REAL_CONST(60466.667451454516/8.0),
    REAL_CONST(60487.57660803559/8.0),
    REAL_CONST(60508.487571725847/8.0),
    REAL_CONST(60529.400342212997/8.0),
    REAL_CONST(60550.314919184893/8.0),
    REAL_CONST(60571.231302329521/8.0),
    REAL_CONST(60592.149491335003/8.0),
    REAL_CONST(60613.069485889588/8.0),
    REAL_CONST(60633.991285681674/8.0),
    REAL_CONST(60654.914890399785/8.0),
    REAL_CONST(60675.840299732568/8.0),
    REAL_CONST(60696.767513368832/8.0),
    REAL_CONST(60717.696530997484/8.0),
    REAL_CONST(60738.627352307602/8.0),
    REAL_CONST(60759.55997698837/8.0),
    REAL_CONST(60780.494404729128/8.0),
    REAL_CONST(60801.430635219323/8.0),
    REAL_CONST(60822.368668148556/8.0),
    REAL_CONST(60843.308503206565/8.0),
    REAL_CONST(60864.250140083204/8.0),
    REAL_CONST(60885.193578468468/8.0),
    REAL_CONST(60906.138818052495/8.0),
    REAL_CONST(60927.085858525541/8.0),
    REAL_CONST(60948.034699578006/8.0),
    REAL_CONST(60968.985340900421/8.0),
    REAL_CONST(60989.937782183442/8.0),
    REAL_CONST(61010.892023117864/8.0),
    REAL_CONST(61031.848063394616/8.0),
    REAL_CONST(61052.805902704764/8.0),
    REAL_CONST(61073.765540739492/8.0),
    REAL_CONST(61094.726977190134/8.0),
    REAL_CONST(61115.690211748137/8.0),
    REAL_CONST(61136.655244105103/8.0),
    REAL_CONST(61157.622073952742/8.0),
    REAL_CONST(61178.590700982917/8.0),
    REAL_CONST(61199.561124887616/8.0),
    REAL_CONST(61220.533345358948/8.0),
    REAL_CONST(61241.507362089171/8.0),
    REAL_CONST(61262.483174770663/8.0),
    REAL_CONST(61283.460783095943/8.0),
    REAL_CONST(61304.440186757645/8.0),
    REAL_CONST(61325.421385448557/8.0),
    REAL_CONST(61346.404378861582/8.0),
    REAL_CONST(61367.389166689762/8.0),
    REAL_CONST(61388.375748626262/8.0),
    REAL_CONST(61409.364124364387/8.0),
    REAL_CONST(61430.354293597571/8.0),
    REAL_CONST(61451.346256019373/8.0),
    REAL_CONST(61472.340011323497/8.0),
    REAL_CONST(61493.335559203762/8.0),
    REAL_CONST(61514.332899354122/8.0),
    REAL_CONST(61535.332031468672/8.0),
    REAL_CONST(61556.332955241618/8.0),
    REAL_CONST(61577.335670367313/8.0),
    REAL_CONST(61598.340176540238/8.0),
    REAL_CONST(61619.346473454993/8.0),
    REAL_CONST(61640.354560806329/8.0),
    REAL_CONST(61661.3644382891/8.0),
    REAL_CONST(61682.376105598312/8.0),
    REAL_CONST(61703.389562429089/8.0),
    REAL_CONST(61724.404808476691/8.0),
    REAL_CONST(61745.42184343651/8.0),
    REAL_CONST(61766.440667004063/8.0),
    REAL_CONST(61787.461278874987/8.0),
    REAL_CONST(61808.483678745069/8.0),
    REAL_CONST(61829.507866310203/8.0),
    REAL_CONST(61850.533841266435/8.0),
    REAL_CONST(61871.561603309929/8.0),
    REAL_CONST(61892.591152136971/8.0),
    REAL_CONST(61913.622487443987/8.0),
    REAL_CONST(61934.655608927525/8.0),
    REAL_CONST(61955.690516284267/8.0),
    REAL_CONST(61976.727209211022/8.0),
    REAL_CONST(61997.765687404724/8.0),
    REAL_CONST(62018.805950562448/8.0),
    REAL_CONST(62039.847998381381/8.0),
    REAL_CONST(62060.891830558845/8.0),
    REAL_CONST(62081.93744679229/8.0),
    REAL_CONST(62102.984846779298/8.0),
    REAL_CONST(62124.034030217575/8.0),
    REAL_CONST(62145.084996804966/8.0),
    REAL_CONST(62166.137746239416/8.0),
    REAL_CONST(62187.19227821903/8.0),
    REAL_CONST(62208.248592442025/8.0),
    REAL_CONST(62229.306688606739/8.0),
    REAL_CONST(62250.366566411656/8.0),
    REAL_CONST(62271.428225555377/8.0),
    REAL_CONST(62292.491665736627/8.0),
    REAL_CONST(62313.556886654267/8.0),
    REAL_CONST(62334.623888007271/8.0),
    REAL_CONST(62355.692669494762/8.0),
    REAL_CONST(62376.763230815974/8.0),
    REAL_CONST(62397.835571670272/8.0),
    REAL_CONST(62418.909691757144/8.0),
    REAL_CONST(62439.98559077621/8.0),
    REAL_CONST(62461.063268427228/8.0),
    REAL_CONST(62482.142724410049/8.0),
    REAL_CONST(62503.223958424685/8.0),
    REAL_CONST(62524.306970171267/8.0),
    REAL_CONST(62545.39175935003/8.0),
    REAL_CONST(62566.478325661366/8.0),
    REAL_CONST(62587.566668805768/8.0),
    REAL_CONST(62608.656788483881/8.0),
    REAL_CONST(62629.748684396451/8.0),
    REAL_CONST(62650.842356244357/8.0),
    REAL_CONST(62671.937803728622/8.0),
    REAL_CONST(62693.035026550366/8.0),
    REAL_CONST(62714.134024410858/8.0),
    REAL_CONST(62735.234797011479/8.0),
    REAL_CONST(62756.337344053733/8.0),
    REAL_CONST(62777.441665239276/8.0),
    REAL_CONST(62798.547760269852/8.0),
    REAL_CONST(62819.655628847358/8.0),
    REAL_CONST(62840.765270673801/8.0),
    REAL_CONST(62861.876685451323/8.0),
    REAL_CONST(62882.989872882186/8.0),
    REAL_CONST(62904.104832668774/8.0),
    REAL_CONST(62925.221564513602/8.0),
    REAL_CONST(62946.340068119309/8.0),
    REAL_CONST(62967.460343188657/8.0),
    REAL_CONST(62988.582389424526/8.0),
    REAL_CONST(63009.70620652994/8.0),
    REAL_CONST(63030.831794208025/8.0),
    REAL_CONST(63051.959152162039/8.0),
    REAL_CONST(63073.08828009537/8.0),
    REAL_CONST(63094.219177711529/8.0),
    REAL_CONST(63115.351844714154/8.0),
    REAL_CONST(63136.486280806988/8.0),
    REAL_CONST(63157.622485693922/8.0),
    REAL_CONST(63178.760459078956/8.0),
    REAL_CONST(63199.900200666219/8.0),
    REAL_CONST(63221.041710159967/8.0),
    REAL_CONST(63242.184987264569/8.0),
    REAL_CONST(63263.330031684534/8.0),
    REAL_CONST(63284.476843124474/8.0),
    REAL_CONST(63305.625421289144/8.0),
    REAL_CONST(63326.775765883409/8.0),
    REAL_CONST(63347.927876612259/8.0),
    REAL_CONST(63369.081753180813/8.0),
    REAL_CONST(63390.237395294316/8.0),
    REAL_CONST(63411.39480265812/8.0),
    REAL_CONST(63432.553974977716/8.0),
    REAL_CONST(63453.714911958712/8.0),
    REAL_CONST(63474.877613306839/8.0),
    REAL_CONST(63496.042078727944/8.0),
    REAL_CONST(63517.208307927998/8.0),
    REAL_CONST(63538.376300613119/8.0),
    REAL_CONST(63559.546056489504/8.0),
    REAL_CONST(63580.717575263516/8.0),
    REAL_CONST(63601.890856641607/8.0),
    REAL_CONST(63623.065900330374/8.0),
    REAL_CONST(63644.242706036515/8.0),
    REAL_CONST(63665.421273466869/8.0),
    REAL_CONST(63686.601602328381/8.0),
    REAL_CONST(63707.783692328136/8.0),
    REAL_CONST(63728.967543173334/8.0),
    REAL_CONST(63750.153154571279/8.0),
    REAL_CONST(63771.340526229418/8.0),
    REAL_CONST(63792.529657855317/8.0),
    REAL_CONST(63813.720549156649/8.0),
    REAL_CONST(63834.913199841227/8.0),
    REAL_CONST(63856.107609616978/8.0),
    REAL_CONST(63877.303778191941/8.0),
    REAL_CONST(63898.501705274284/8.0),
    REAL_CONST(63919.7013905723/8.0),
    REAL_CONST(63940.902833794404/8.0),
    REAL_CONST(63962.106034649114/8.0),
    REAL_CONST(63983.310992845094/8.0),
    REAL_CONST(64004.517708091109/8.0),
    REAL_CONST(64025.726180096048/8.0),
    REAL_CONST(64046.936408568938/8.0),
    REAL_CONST(64068.1483932189/8.0),
    REAL_CONST(64089.362133755196/8.0),
    REAL_CONST(64110.577629887193/8.0),
    REAL_CONST(64131.794881324393/8.0),
    REAL_CONST(64153.013887776404/8.0),
    REAL_CONST(64174.234648952966/8.0),
    REAL_CONST(64195.457164563937/8.0),
    REAL_CONST(64216.681434319289/8.0),
    REAL_CONST(64237.907457929112/8.0),
    REAL_CONST(64259.135235103626/8.0),
    REAL_CONST(64280.36476555316/8.0),
    REAL_CONST(64301.596048988169/8.0),
    REAL_CONST(64322.829085119236/8.0),
    REAL_CONST(64344.06387365704/8.0),
    REAL_CONST(64365.300414312398/8.0),
    REAL_CONST(64386.538706796251/8.0),
    REAL_CONST(64407.778750819634/8.0),
    REAL_CONST(64429.020546093721/8.0),
    REAL_CONST(64450.26409232981/8.0),
    REAL_CONST(64471.509389239291/8.0),
    REAL_CONST(64492.756436533709/8.0),
    REAL_CONST(64514.005233924705/8.0),
    REAL_CONST(64535.255781124033/8.0),
    REAL_CONST(64556.50807784358/8.0),
    REAL_CONST(64577.762123795357/8.0),
    REAL_CONST(64599.017918691468/8.0),
    REAL_CONST(64620.275462244172/8.0),
    REAL_CONST(64641.534754165805/8.0),
    REAL_CONST(64662.795794168844/8.0),
    REAL_CONST(64684.058581965895/8.0),
    REAL_CONST(64705.323117269661/8.0),
    REAL_CONST(64726.589399792974/8.0),
    REAL_CONST(64747.857429248776/8.0),
    REAL_CONST(64769.127205350138/8.0),
    REAL_CONST(64790.398727810236/8.0),
    REAL_CONST(64811.671996342375/8.0),
    REAL_CONST(64832.947010659969/8.0),
    REAL_CONST(64854.223770476558/8.0),
    REAL_CONST(64875.502275505794/8.0),
    REAL_CONST(64896.782525461451/8.0),
    REAL_CONST(64918.064520057414/8.0),
    REAL_CONST(64939.348259007682/8.0),
    REAL_CONST(64960.633742026388/8.0),
    REAL_CONST(64981.920968827762/8.0),
    REAL_CONST(65003.209939126165/8.0),
    REAL_CONST(65024.500652636067/8.0),
    REAL_CONST(65045.793109072067/8.0),
    REAL_CONST(65067.087308148861/8.0),
    REAL_CONST(65088.383249581282/8.0),
    REAL_CONST(65109.680933084259/8.0),
    REAL_CONST(65130.980358372864/8.0),
    REAL_CONST(65152.28152516226/8.0),
    REAL_CONST(65173.584433167736/8.0),
    REAL_CONST(65194.889082104703/8.0),
    REAL_CONST(65216.195471688683/8.0),
    REAL_CONST(65237.503601635319/8.0),
    REAL_CONST(65258.813471660353/8.0),
    REAL_CONST(65280.125081479666/8.0),
    REAL_CONST(65301.438430809241/8.0),
    REAL_CONST(65322.753519365178/8.0),
    REAL_CONST(65344.070346863708/8.0),
    REAL_CONST(65365.388913021146/8.0),
    REAL_CONST(65386.709217553958/8.0),
    REAL_CONST(65408.031260178701/8.0),
    REAL_CONST(65429.355040612056/8.0),
    REAL_CONST(65450.680558570821/8.0),
    REAL_CONST(65472.00781377191/8.0),
    REAL_CONST(65493.336805932355/8.0),
    REAL_CONST(65514.66753476928/8.0),
    REAL_CONST(65535.999999999956/8.0),
    REAL_CONST(65557.334201341757/8.0),
    REAL_CONST(65578.670138512171/8.0),
    REAL_CONST(65600.007811228788/8.0),
    REAL_CONST(65621.347219209332/8.0),
    REAL_CONST(65642.688362171626/8.0),
    REAL_CONST(65664.031239833639/8.0),
    REAL_CONST(65685.375851913413/8.0),
    REAL_CONST(65706.722198129137/8.0),
    REAL_CONST(65728.070278199084/8.0),
    REAL_CONST(65749.420091841661/8.0),
    REAL_CONST(65770.771638775404/8.0),
    REAL_CONST(65792.124918718939/8.0),
    REAL_CONST(65813.479931391004/8.0),
    REAL_CONST(65834.836676510458/8.0),
    REAL_CONST(65856.195153796303/8.0),
    REAL_CONST(65877.5553629676/8.0),
    REAL_CONST(65898.917303743554/8.0),
    REAL_CONST(65920.280975843489/8.0),
    REAL_CONST(65941.646378986843/8.0),
    REAL_CONST(65963.013512893158/8.0),
    REAL_CONST(65984.382377282076/8.0),
    REAL_CONST(66005.752971873386/8.0),
    REAL_CONST(66027.125296386963/8.0),
    REAL_CONST(66048.499350542799/8.0),
    REAL_CONST(66069.875134061018/8.0),
    REAL_CONST(66091.252646661844/8.0),
    REAL_CONST(66112.631888065618/8.0),
    REAL_CONST(66134.01285799277/8.0),
    REAL_CONST(66155.395556163887/8.0),
    REAL_CONST(66176.779982299631/8.0),
    REAL_CONST(66198.166136120795/8.0),
    REAL_CONST(66219.554017348273/8.0),
    REAL_CONST(66240.943625703105/8.0),
    REAL_CONST(66262.334960906388/8.0),
    REAL_CONST(66283.728022679396/8.0),
    REAL_CONST(66305.122810743444/8.0),
    REAL_CONST(66326.519324820023/8.0),
    REAL_CONST(66347.917564630698/8.0),
    REAL_CONST(66369.317529897162/8.0),
    REAL_CONST(66390.719220341227/8.0),
    REAL_CONST(66412.122635684791/8.0),
    REAL_CONST(66433.527775649884/8.0),
    REAL_CONST(66454.934639958636/8.0),
    REAL_CONST(66476.343228333324/8.0),
    REAL_CONST(66497.753540496284/8.0),
    REAL_CONST(66519.165576169995/8.0),
    REAL_CONST(66540.57933507704/8.0),
    REAL_CONST(66561.994816940118/8.0),
    REAL_CONST(66583.412021482043/8.0),
    REAL_CONST(66604.830948425733/8.0),
    REAL_CONST(66626.251597494222/8.0),
    REAL_CONST(66647.673968410629/8.0),
    REAL_CONST(66669.098060898235/8.0),
    REAL_CONST(66690.523874680381/8.0),
    REAL_CONST(66711.951409480564/8.0),
    REAL_CONST(66733.380665022371/8.0),
    REAL_CONST(66754.811641029475/8.0),
    REAL_CONST(66776.244337225711/8.0),
    REAL_CONST(66797.678753334985/8.0),
    REAL_CONST(66819.11488908132/8.0),
    REAL_CONST(66840.552744188884/8.0),
    REAL_CONST(66861.992318381905/8.0),
    REAL_CONST(66883.433611384738/8.0),
    REAL_CONST(66904.876622921889/8.0),
    REAL_CONST(66926.321352717903/8.0),
    REAL_CONST(66947.767800497502/8.0),
    REAL_CONST(66969.215965985466/8.0),
    REAL_CONST(66990.665848906734/8.0),
    REAL_CONST(67012.117448986304/8.0),
    REAL_CONST(67033.570765949335/8.0),
    REAL_CONST(67055.025799521056/8.0),
    REAL_CONST(67076.482549426815/8.0),
    REAL_CONST(67097.941015392076/8.0),
    REAL_CONST(67119.401197142433/8.0),
    REAL_CONST(67140.863094403554/8.0),
    REAL_CONST(67162.326706901222/8.0),
    REAL_CONST(67183.792034361351/8.0),
    REAL_CONST(67205.259076509959/8.0),
    REAL_CONST(67226.72783307315/8.0),
    REAL_CONST(67248.198303777172/8.0),
    REAL_CONST(67269.670488348347/8.0),
    REAL_CONST(67291.144386513144/8.0),
    REAL_CONST(67312.619997998088/8.0),
    REAL_CONST(67334.09732252988/8.0),
    REAL_CONST(67355.576359835293/8.0),
    REAL_CONST(67377.057109641188/8.0),
    REAL_CONST(67398.53957167457/8.0),
    REAL_CONST(67420.023745662547/8.0),
    REAL_CONST(67441.50963133233/8.0),
    REAL_CONST(67462.99722841123/8.0),
    REAL_CONST(67484.486536626689/8.0),
    REAL_CONST(67505.977555706224/8.0),
    REAL_CONST(67527.470285377494/8.0),
    REAL_CONST(67548.964725368263/8.0),
    REAL_CONST(67570.460875406367/8.0),
    REAL_CONST(67591.9587352198/8.0),
    REAL_CONST(67613.458304536631/8.0),
    REAL_CONST(67634.95958308503/8.0),
    REAL_CONST(67656.462570593329/8.0),
    REAL_CONST(67677.967266789899/8.0),
    REAL_CONST(67699.473671403248/8.0),
    REAL_CONST(67720.981784162024/8.0),
    REAL_CONST(67742.491604794923/8.0),
    REAL_CONST(67764.003133030797/8.0),
    REAL_CONST(67785.516368598575/8.0),
    REAL_CONST(67807.031311227314/8.0),
    REAL_CONST(67828.547960646174/8.0),
    REAL_CONST(67850.066316584402/8.0),
    REAL_CONST(67871.58637877139/8.0),
    REAL_CONST(67893.108146936589/8.0),
    REAL_CONST(67914.63162080961/8.0),
    REAL_CONST(67936.156800120138/8.0),
    REAL_CONST(67957.683684597971/8.0),
    REAL_CONST(67979.212273973011/8.0),
    REAL_CONST(68000.742567975263/8.0),
    REAL_CONST(68022.274566334876/8.0),
    REAL_CONST(68043.808268782057/8.0),
    REAL_CONST(68065.343675047145/8.0),
    REAL_CONST(68086.880784860579/8.0),
    REAL_CONST(68108.419597952918/8.0),
    REAL_CONST(68129.960114054789/8.0),
    REAL_CONST(68151.502332896969/8.0),
    REAL_CONST(68173.04625421032/8.0),
    REAL_CONST(68194.591877725834/8.0),
    REAL_CONST(68216.139203174564/8.0),
    REAL_CONST(68237.688230287706/8.0),
    REAL_CONST(68259.238958796544/8.0),
    REAL_CONST(68280.791388432481/8.0),
    REAL_CONST(68302.345518927032/8.0),
    REAL_CONST(68323.901350011787/8.0),
    REAL_CONST(68345.458881418483/8.0),
    REAL_CONST(68367.018112878912/8.0),
    REAL_CONST(68388.579044125028/8.0),
    REAL_CONST(68410.141674888844/8.0),
    REAL_CONST(68431.706004902502/8.0),
    REAL_CONST(68453.272033898262/8.0),
    REAL_CONST(68474.839761608455/8.0),
    REAL_CONST(68496.409187765545/8.0),
    REAL_CONST(68517.980312102081/8.0),
    REAL_CONST(68539.553134350732/8.0),
    REAL_CONST(68561.127654244279/8.0),
    REAL_CONST(68582.70387151558/8.0),
    REAL_CONST(68604.281785897634/8.0),
    REAL_CONST(68625.861397123503/8.0),
    REAL_CONST(68647.44270492639/8.0),
    REAL_CONST(68669.025709039604/8.0),
    REAL_CONST(68690.610409196524/8.0),
    REAL_CONST(68712.196805130661/8.0),
    REAL_CONST(68733.784896575627/8.0),
    REAL_CONST(68755.374683265123/8.0),
    REAL_CONST(68776.966164932994/8.0),
    REAL_CONST(68798.559341313128/8.0),
    REAL_CONST(68820.154212139591/8.0),
    REAL_CONST(68841.750777146473/8.0),
    REAL_CONST(68863.349036068044/8.0),
    REAL_CONST(68884.948988638629/8.0),
    REAL_CONST(68906.550634592684/8.0),
    REAL_CONST(68928.153973664739/8.0),
    REAL_CONST(68949.75900558944/8.0),
    REAL_CONST(68971.365730101577/8.0),
    REAL_CONST(68992.974146935987/8.0),
    REAL_CONST(69014.584255827634/8.0),
    REAL_CONST(69036.196056511588/8.0),
    REAL_CONST(69057.809548723017/8.0),
    REAL_CONST(69079.424732197207/8.0),
    REAL_CONST(69101.041606669532/8.0),
    REAL_CONST(69122.660171875468/8.0),
    REAL_CONST(69144.280427550606/8.0),
    REAL_CONST(69165.902373430625/8.0),
    REAL_CONST(69187.526009251334/8.0),
    REAL_CONST(69209.151334748618/8.0),
    REAL_CONST(69230.778349658474/8.0),
    REAL_CONST(69252.40705371699/8.0),
    REAL_CONST(69274.037446660412/8.0),
    REAL_CONST(69295.669528225/8.0),
    REAL_CONST(69317.303298147192/8.0),
    REAL_CONST(69338.938756163494/8.0),
    REAL_CONST(69360.575902010532/8.0),
    REAL_CONST(69382.214735425005/8.0),
    REAL_CONST(69403.855256143754/8.0),
    REAL_CONST(69425.497463903681/8.0),
    REAL_CONST(69447.141358441833/8.0),
    REAL_CONST(69468.78693949533/8.0),
    REAL_CONST(69490.434206801394/8.0),
    REAL_CONST(69512.083160097391/8.0),
    REAL_CONST(69533.733799120717/8.0),
    REAL_CONST(69555.386123608929/8.0),
    REAL_CONST(69577.04013329967/8.0),
    REAL_CONST(69598.695827930685/8.0),
    REAL_CONST(69620.353207239794/8.0),
    REAL_CONST(69642.012270964973/8.0),
    REAL_CONST(69663.67301884426/8.0),
    REAL_CONST(69685.335450615792/8.0),
    REAL_CONST(69706.999566017839/8.0),
    REAL_CONST(69728.665364788743/8.0),
    REAL_CONST(69750.332846666963/8.0),
    REAL_CONST(69772.002011391058/8.0),
    REAL_CONST(69793.672858699691/8.0),
    REAL_CONST(69815.345388331611/8.0),
    REAL_CONST(69837.019600025669/8.0),
    REAL_CONST(69858.695493520849/8.0),
    REAL_CONST(69880.373068556204/8.0),
    REAL_CONST(69902.052324870907/8.0),
    REAL_CONST(69923.733262204216/8.0),
    REAL_CONST(69945.415880295492/8.0),
    REAL_CONST(69967.100178884211/8.0),
    REAL_CONST(69988.786157709939/8.0),
    REAL_CONST(70010.473816512356/8.0),
    REAL_CONST(70032.163155031216/8.0),
    REAL_CONST(70053.854173006403/8.0),
    REAL_CONST(70075.546870177874/8.0),
    REAL_CONST(70097.241246285717/8.0),
    REAL_CONST(70118.937301070109/8.0),
    REAL_CONST(70140.635034271298/8.0),
    REAL_CONST(70162.334445629691/8.0),
    REAL_CONST(70184.035534885741/8.0),
    REAL_CONST(70205.738301780017/8.0),
    REAL_CONST(70227.442746053217/8.0),
    REAL_CONST(70249.1488674461/8.0),
    REAL_CONST(70270.856665699539/8.0),
    REAL_CONST(70292.566140554511/8.0),
    REAL_CONST(70314.277291752107/8.0),
    REAL_CONST(70335.990119033493/8.0),
    REAL_CONST(70357.704622139936/8.0),
    REAL_CONST(70379.420800812819/8.0),
    REAL_CONST(70401.138654793613/8.0),
    REAL_CONST(70422.85818382389/8.0),
    REAL_CONST(70444.579387645339/8.0),
    REAL_CONST(70466.302265999722/8.0),
    REAL_CONST(70488.026818628918/8.0),
    REAL_CONST(70509.753045274876/8.0),
    REAL_CONST(70531.480945679708/8.0),
    REAL_CONST(70553.210519585555/8.0),
    REAL_CONST(70574.941766734701/8.0),
    REAL_CONST(70596.674686869505/8.0),
    REAL_CONST(70618.409279732456/8.0),
    REAL_CONST(70640.145545066101/8.0),
    REAL_CONST(70661.883482613106/8.0),
    REAL_CONST(70683.623092116264/8.0),
    REAL_CONST(70705.364373318414/8.0),
    REAL_CONST(70727.107325962526/8.0),
    REAL_CONST(70748.851949791671/8.0),
    REAL_CONST(70770.598244549008/8.0),
    REAL_CONST(70792.346209977783/8.0),
    REAL_CONST(70814.095845821372/8.0),
    REAL_CONST(70835.847151823225/8.0),
    REAL_CONST(70857.600127726895/8.0),
    REAL_CONST(70879.354773276034/8.0),
    REAL_CONST(70901.111088214413/8.0),
    REAL_CONST(70922.869072285859/8.0),
    REAL_CONST(70944.628725234332/8.0),
    REAL_CONST(70966.390046803877/8.0),
    REAL_CONST(70988.153036738629/8.0),
    REAL_CONST(71009.917694782853/8.0),
    REAL_CONST(71031.684020680885/8.0),
    REAL_CONST(71053.45201417715/8.0),
    REAL_CONST(71075.221675016204/8.0),
    REAL_CONST(71096.993002942661/8.0),
    REAL_CONST(71118.765997701266/8.0),
    REAL_CONST(71140.540659036851/8.0),
    REAL_CONST(71162.316986694335/8.0),
    REAL_CONST(71184.09498041874/8.0),
    REAL_CONST(71205.874639955218/8.0),
    REAL_CONST(71227.655965048951/8.0),
    REAL_CONST(71249.438955445294/8.0),
    REAL_CONST(71271.223610889632/8.0),
    REAL_CONST(71293.009931127483/8.0),
    REAL_CONST(71314.797915904477/8.0),
    REAL_CONST(71336.587564966307/8.0),
    REAL_CONST(71358.378878058764/8.0),
    REAL_CONST(71380.171854927772/8.0),
    REAL_CONST(71401.966495319313/8.0),
    REAL_CONST(71423.762798979486/8.0),
    REAL_CONST(71445.560765654489/8.0),
    REAL_CONST(71467.360395090596/8.0),
    REAL_CONST(71489.161687034211/8.0),
    REAL_CONST(71510.964641231811/8.0),
    REAL_CONST(71532.769257429973/8.0),
    REAL_CONST(71554.575535375348/8.0),
    REAL_CONST(71576.383474814749/8.0),
    REAL_CONST(71598.19307549503/8.0),
    REAL_CONST(71620.004337163133/8.0),
    REAL_CONST(71641.817259566145/8.0),
    REAL_CONST(71663.631842451214/8.0),
    REAL_CONST(71685.4480855656/8.0),
    REAL_CONST(71707.26598865664/8.0),
    REAL_CONST(71729.085551471784/8.0),
    REAL_CONST(71750.906773758586/8.0),
    REAL_CONST(71772.729655264673/8.0),
    REAL_CONST(71794.554195737772/8.0),
    REAL_CONST(71816.380394925713/8.0),
    REAL_CONST(71838.208252576442/8.0),
    REAL_CONST(71860.037768437964/8.0),
    REAL_CONST(71881.868942258385/8.0),
    REAL_CONST(71903.701773785942/8.0),
    REAL_CONST(71925.536262768932/8.0),
    REAL_CONST(71947.372408955751/8.0),
    REAL_CONST(71969.210212094898/8.0),
    REAL_CONST(71991.049671934976/8.0),
    REAL_CONST(72012.890788224686/8.0),
    REAL_CONST(72034.73356071279/8.0),
    REAL_CONST(72056.577989148165/8.0),
    REAL_CONST(72078.424073279821/8.0),
    REAL_CONST(72100.271812856794/8.0),
    REAL_CONST(72122.121207628254/8.0),
    REAL_CONST(72143.97225734347/8.0),
    REAL_CONST(72165.824961751801/8.0),
    REAL_CONST(72187.679320602692/8.0),
    REAL_CONST(72209.53533364569/8.0),
    REAL_CONST(72231.393000630429/8.0),
    REAL_CONST(72253.252321306645/8.0),
    REAL_CONST(72275.113295424177/8.0),
    REAL_CONST(72296.975922732949/8.0),
    REAL_CONST(72318.840202982959/8.0),
    REAL_CONST(72340.706135924338/8.0),
    REAL_CONST(72362.573721307272/8.0),
    REAL_CONST(72384.442958882093/8.0),
    REAL_CONST(72406.313848399179/8.0),
    REAL_CONST(72428.186389609036/8.0),
    REAL_CONST(72450.060582262216/8.0),
    REAL_CONST(72471.936426109431/8.0),
    REAL_CONST(72493.813920901433/8.0),
    REAL_CONST(72515.693066389096/8.0),
    REAL_CONST(72537.573862323392/8.0),
    REAL_CONST(72559.456308455352/8.0),
    REAL_CONST(72581.340404536139/8.0),
    REAL_CONST(72603.226150316987/8.0),
    REAL_CONST(72625.113545549248/8.0),
    REAL_CONST(72647.002589984331/8.0),
    REAL_CONST(72668.893283373764/8.0),
    REAL_CONST(72690.785625469172/8.0),
    REAL_CONST(72712.679616022273/8.0),
    REAL_CONST(72734.575254784853/8.0),
    REAL_CONST(72756.472541508803/8.0),
    REAL_CONST(72778.371475946144/8.0),
    REAL_CONST(72800.272057848939/8.0),
    REAL_CONST(72822.174286969355/8.0),
    REAL_CONST(72844.07816305969/8.0),
    REAL_CONST(72865.983685872285/8.0),
    REAL_CONST(72887.890855159596/8.0),
    REAL_CONST(72909.799670674183/8.0),
    REAL_CONST(72931.710132168693/8.0),
    REAL_CONST(72953.622239395845/8.0),
    REAL_CONST(72975.535992108475/8.0),
    REAL_CONST(72997.451390059519/8.0),
    REAL_CONST(73019.368433001961/8.0),
    REAL_CONST(73041.287120688925/8.0),
    REAL_CONST(73063.207452873612/8.0),
    REAL_CONST(73085.129429309294/8.0),
    REAL_CONST(73107.053049749389/8.0),
    REAL_CONST(73128.978313947344/8.0),
    REAL_CONST(73150.905221656736/8.0),
    REAL_CONST(73172.833772631217/8.0),
    REAL_CONST(73194.763966624567/8.0),
    REAL_CONST(73216.695803390612/8.0),
    REAL_CONST(73238.62928268328/8.0),
    REAL_CONST(73260.564404256627/8.0),
    REAL_CONST(73282.501167864757/8.0),
    REAL_CONST(73304.439573261901/8.0),
    REAL_CONST(73326.379620202337/8.0),
    REAL_CONST(73348.321308440485/8.0),
    REAL_CONST(73370.264637730841/8.0),
    REAL_CONST(73392.209607827957/8.0),
    REAL_CONST(73414.156218486532/8.0),
    REAL_CONST(73436.104469461323/8.0),
    REAL_CONST(73458.054360507173/8.0),
    REAL_CONST(73480.005891379056/8.0),
    REAL_CONST(73501.959061831993/8.0),
    REAL_CONST(73523.913871621116/8.0),
    REAL_CONST(73545.870320501665/8.0),
    REAL_CONST(73567.828408228932/8.0),
    REAL_CONST(73589.78813455833/8.0),
    REAL_CONST(73611.749499245358/8.0),
    REAL_CONST(73633.712502045615/8.0),
    REAL_CONST(73655.677142714747/8.0),
    REAL_CONST(73677.643421008557/8.0),
    REAL_CONST(73699.611336682879/8.0),
    REAL_CONST(73721.580889493693/8.0),
    REAL_CONST(73743.552079197019/8.0),
    REAL_CONST(73765.524905548999/8.0),
    REAL_CONST(73787.499368305856/8.0),
    REAL_CONST(73809.475467223907/8.0),
    REAL_CONST(73831.453202059551/8.0),
    REAL_CONST(73853.432572569291/8.0),
    REAL_CONST(73875.413578509717/8.0),
    REAL_CONST(73897.396219637507/8.0),
    REAL_CONST(73919.380495709411/8.0),
    REAL_CONST(73941.36640648231/8.0),
    REAL_CONST(73963.353951713143/8.0),
    REAL_CONST(73985.343131158952/8.0),
    REAL_CONST(74007.333944576865/8.0),
    REAL_CONST(74029.326391724098/8.0),
    REAL_CONST(74051.320472357969/8.0),
    REAL_CONST(74073.316186235883/8.0),
    REAL_CONST(74095.313533115303/8.0),
    REAL_CONST(74117.312512753837/8.0),
    REAL_CONST(74139.313124909138/8.0),
    REAL_CONST(74161.315369338976/8.0),
    REAL_CONST(74183.319245801191/8.0),
    REAL_CONST(74205.324754053727/8.0),
    REAL_CONST(74227.331893854629/8.0),
    REAL_CONST(74249.340664961986/8.0),
    REAL_CONST(74271.351067134034/8.0),
    REAL_CONST(74293.363100129049/8.0),
    REAL_CONST(74315.376763705441/8.0),
    REAL_CONST(74337.392057621662/8.0),
    REAL_CONST(74359.408981636298/8.0),
    REAL_CONST(74381.427535508003/8.0),
    REAL_CONST(74403.447718995507/8.0),
    REAL_CONST(74425.469531857671/8.0),
    REAL_CONST(74447.492973853383/8.0),
    REAL_CONST(74469.518044741693/8.0),
    REAL_CONST(74491.54474428168/8.0),
    REAL_CONST(74513.573072232539/8.0),
    REAL_CONST(74535.603028353551/8.0),
    REAL_CONST(74557.634612404087/8.0),
    REAL_CONST(74579.667824143602/8.0),
    REAL_CONST(74601.702663331642/8.0),
    REAL_CONST(74623.739129727837/8.0),
    REAL_CONST(74645.777223091936/8.0),
    REAL_CONST(74667.816943183716/8.0),
    REAL_CONST(74689.858289763113/8.0),
    REAL_CONST(74711.901262590094/8.0),
    REAL_CONST(74733.945861424741/8.0),
    REAL_CONST(74755.992086027225/8.0),
    REAL_CONST(74778.039936157802/8.0),
    REAL_CONST(74800.089411576817/8.0),
    REAL_CONST(74822.140512044702/8.0),
    REAL_CONST(74844.193237321961/8.0),
    REAL_CONST(74866.24758716923/8.0),
    REAL_CONST(74888.303561347187/8.0),
    REAL_CONST(74910.36115961663/8.0),
    REAL_CONST(74932.420381738411/8.0),
    REAL_CONST(74954.481227473516/8.0),
    REAL_CONST(74976.543696582972/8.0),
    REAL_CONST(74998.607788827925/8.0),
    REAL_CONST(75020.673503969607/8.0),
    REAL_CONST(75042.740841769322/8.0),
    REAL_CONST(75064.809801988464/8.0),
    REAL_CONST(75086.88038438854/8.0),
    REAL_CONST(75108.952588731103/8.0),
    REAL_CONST(75131.026414777836/8.0),
    REAL_CONST(75153.101862290467/8.0),
    REAL_CONST(75175.178931030852/8.0),
    REAL_CONST(75197.257620760924/8.0),
    REAL_CONST(75219.33793124267/8.0),
    REAL_CONST(75241.419862238225/8.0),
    REAL_CONST(75263.503413509738/8.0),
    REAL_CONST(75285.588584819503/8.0),
    REAL_CONST(75307.675375929874/8.0),
    REAL_CONST(75329.763786603318/8.0),
    REAL_CONST(75351.853816602365/8.0),
    REAL_CONST(75373.945465689612/8.0),
    REAL_CONST(75396.038733627807/8.0),
    REAL_CONST(75418.133620179724/8.0),
    REAL_CONST(75440.230125108254/8.0),
    REAL_CONST(75462.32824817636/8.0),
    REAL_CONST(75484.427989147109/8.0),
    REAL_CONST(75506.529347783653/8.0),
    REAL_CONST(75528.63232384919/8.0),
    REAL_CONST(75550.736917107075/8.0),
    REAL_CONST(75572.843127320695/8.0),
    REAL_CONST(75594.950954253538/8.0),
    REAL_CONST(75617.060397669193/8.0),
    REAL_CONST(75639.171457331307/8.0),
    REAL_CONST(75661.284133003646/8.0),
    REAL_CONST(75683.398424450032/8.0),
    REAL_CONST(75705.514331434402/8.0),
    REAL_CONST(75727.631853720741/8.0),
    REAL_CONST(75749.750991073175/8.0),
    REAL_CONST(75771.871743255862/8.0),
    REAL_CONST(75793.994110033076/8.0),
    REAL_CONST(75816.118091169177/8.0),
    REAL_CONST(75838.243686428585/8.0),
    REAL_CONST(75860.370895575848/8.0),
    REAL_CONST(75882.499718375562/8.0),
    REAL_CONST(75904.630154592422/8.0),
    REAL_CONST(75926.762203991224/8.0),
    REAL_CONST(75948.895866336825/8.0),
    REAL_CONST(75971.031141394182/8.0),
    REAL_CONST(75993.168028928325/8.0),
    REAL_CONST(76015.306528704401/8.0),
    REAL_CONST(76037.4466404876/8.0),
    REAL_CONST(76059.588364043215/8.0),
    REAL_CONST(76081.731699136653/8.0),
    REAL_CONST(76103.876645533353/8.0),
    REAL_CONST(76126.023202998884/8.0),
    REAL_CONST(76148.171371298871/8.0),
    REAL_CONST(76170.321150199044/8.0),
    REAL_CONST(76192.472539465205/8.0),
    REAL_CONST(76214.625538863256/8.0),
    REAL_CONST(76236.780148159174/8.0),
    REAL_CONST(76258.936367119008/8.0),
    REAL_CONST(76281.094195508922/8.0),
    REAL_CONST(76303.253633095141/8.0),
    REAL_CONST(76325.414679643975/8.0),
    REAL_CONST(76347.577334921851/8.0),
    REAL_CONST(76369.741598695226/8.0),
    REAL_CONST(76391.907470730686/8.0),
    REAL_CONST(76414.074950794879/8.0),
    REAL_CONST(76436.244038654564/8.0),
    REAL_CONST(76458.414734076548/8.0),
    REAL_CONST(76480.587036827754/8.0),
    REAL_CONST(76502.760946675175/8.0),
    REAL_CONST(76524.936463385893/8.0),
    REAL_CONST(76547.11358672705/8.0),
    REAL_CONST(76569.292316465915/8.0),
    REAL_CONST(76591.472652369819/8.0),
    REAL_CONST(76613.654594206164/8.0),
    REAL_CONST(76635.838141742468/8.0),
    REAL_CONST(76658.023294746308/8.0),
    REAL_CONST(76680.210052985349/8.0),
    REAL_CONST(76702.398416227341/8.0),
    REAL_CONST(76724.588384240138/8.0),
    REAL_CONST(76746.779956791637/8.0),
    REAL_CONST(76768.973133649866/8.0),
    REAL_CONST(76791.167914582897/8.0),
    REAL_CONST(76813.364299358902/8.0),
    REAL_CONST(76835.562287746157/8.0),
    REAL_CONST(76857.761879512967/8.0),
    REAL_CONST(76879.963074427797/8.0),
    REAL_CONST(76902.165872259109/8.0),
    REAL_CONST(76924.37027277553/8.0),
    REAL_CONST(76946.576275745727/8.0),
    REAL_CONST(76968.783880938441/8.0),
    REAL_CONST(76990.993088122515/8.0),
    REAL_CONST(77013.203897066895/8.0),
    REAL_CONST(77035.416307540567/8.0),
    REAL_CONST(77057.630319312622/8.0),
    REAL_CONST(77079.845932152239/8.0),
    REAL_CONST(77102.063145828695/8.0),
    REAL_CONST(77124.281960111301/8.0),
    REAL_CONST(77146.50237476948/8.0),
    REAL_CONST(77168.724389572759/8.0),
    REAL_CONST(77190.948004290723/8.0),
    REAL_CONST(77213.173218693031/8.0),
    REAL_CONST(77235.400032549442/8.0),
    REAL_CONST(77257.628445629802/8.0),
    REAL_CONST(77279.858457704031/8.0),
    REAL_CONST(77302.090068542122/8.0),
    REAL_CONST(77324.323277914169/8.0),
    REAL_CONST(77346.558085590339/8.0),
    REAL_CONST(77368.794491340886/8.0),
    REAL_CONST(77391.032494936138/8.0),
    REAL_CONST(77413.272096146524/8.0),
    REAL_CONST(77435.51329474253/8.0),
    REAL_CONST(77457.756090494731/8.0),
    REAL_CONST(77480.000483173804/8.0),
    REAL_CONST(77502.246472550498/8.0),
    REAL_CONST(77524.494058395634/8.0),
    REAL_CONST(77546.743240480107/8.0),
    REAL_CONST(77568.994018574944/8.0),
    REAL_CONST(77591.246392451198/8.0),
    REAL_CONST(77613.500361880026/8.0),
    REAL_CONST(77635.755926632657/8.0),
    REAL_CONST(77658.013086480438/8.0),
    REAL_CONST(77680.271841194757/8.0),
    REAL_CONST(77702.532190547092/8.0),
    REAL_CONST(77724.794134309021/8.0),
    REAL_CONST(77747.057672252195/8.0),
    REAL_CONST(77769.322804148323/8.0),
    REAL_CONST(77791.589529769248/8.0),
    REAL_CONST(77813.857848886837/8.0),
    REAL_CONST(77836.127761273063/8.0),
    REAL_CONST(77858.399266699998/8.0),
    REAL_CONST(77880.67236493979/8.0),
    REAL_CONST(77902.947055764627/8.0),
    REAL_CONST(77925.223338946831/8.0),
    REAL_CONST(77947.50121425878/8.0),
    REAL_CONST(77969.780681472927/8.0),
    REAL_CONST(77992.061740361838/8.0),
    REAL_CONST(78014.344390698127/8.0),
    REAL_CONST(78036.628632254491/8.0),
    REAL_CONST(78058.914464803747/8.0),
    REAL_CONST(78081.201888118725/8.0),
    REAL_CONST(78103.490901972415/8.0),
    REAL_CONST(78125.781506137821/8.0),
    REAL_CONST(78148.073700388064/8.0),
    REAL_CONST(78170.367484496339/8.0),
    REAL_CONST(78192.662858235926/8.0),
    REAL_CONST(78214.959821380166/8.0),
    REAL_CONST(78237.258373702498/8.0),
    REAL_CONST(78259.558514976452/8.0),
    REAL_CONST(78281.860244975614/8.0),
    REAL_CONST(78304.163563473659/8.0),
    REAL_CONST(78326.468470244363/8.0),
    REAL_CONST(78348.77496506153/8.0),
    REAL_CONST(78371.083047699125/8.0),
    REAL_CONST(78393.392717931114/8.0),
    REAL_CONST(78415.703975531578/8.0),
    REAL_CONST(78438.016820274701/8.0),
    REAL_CONST(78460.331251934695/8.0),
    REAL_CONST(78482.647270285903/8.0),
    REAL_CONST(78504.964875102727/8.0),
    REAL_CONST(78527.284066159627/8.0),
    REAL_CONST(78549.604843231195/8.0),
    REAL_CONST(78571.927206092048/8.0),
    REAL_CONST(78594.251154516911/8.0),
    REAL_CONST(78616.576688280606/8.0),
    REAL_CONST(78638.903807157985/8.0),
    REAL_CONST(78661.232510924034/8.0),
    REAL_CONST(78683.562799353778/8.0),
    REAL_CONST(78705.894672222363/8.0),
    REAL_CONST(78728.228129304945/8.0),
    REAL_CONST(78750.563170376859/8.0),
    REAL_CONST(78772.899795213423/8.0),
    REAL_CONST(78795.238003590101/8.0),
    REAL_CONST(78817.577795282399/8.0),
    REAL_CONST(78839.919170065928/8.0),
    REAL_CONST(78862.262127716356/8.0),
    REAL_CONST(78884.606668009452/8.0),
    REAL_CONST(78906.952790721043/8.0),
    REAL_CONST(78929.300495627045/8.0),
    REAL_CONST(78951.64978250346/8.0),
    REAL_CONST(78974.000651126378/8.0),
    REAL_CONST(78996.353101271932/8.0),
    REAL_CONST(79018.707132716358/8.0),
    REAL_CONST(79041.062745235977/8.0),
    REAL_CONST(79063.41993860717/8.0),
    REAL_CONST(79085.778712606436/8.0),
    REAL_CONST(79108.139067010285/8.0),
    REAL_CONST(79130.501001595389/8.0),
    REAL_CONST(79152.864516138419/8.0),
    REAL_CONST(79175.22961041618/8.0),
    REAL_CONST(79197.596284205531/8.0),
    REAL_CONST(79219.96453728342/8.0),
    REAL_CONST(79242.33436942687/8.0),
    REAL_CONST(79264.705780412987/8.0),
    REAL_CONST(79287.078770018954/8.0),
    REAL_CONST(79309.453338022009/8.0),
    REAL_CONST(79331.829484199508/8.0),
    REAL_CONST(79354.207208328866/8.0),
    REAL_CONST(79376.586510187582/8.0),
    REAL_CONST(79398.967389553218/8.0),
    REAL_CONST(79421.349846203433/8.0),
    REAL_CONST(79443.733879915948/8.0),
    REAL_CONST(79466.119490468584/8.0),
    REAL_CONST(79488.50667763922/8.0),
    REAL_CONST(79510.895441205823/8.0),
    REAL_CONST(79533.285780946433/8.0),
    REAL_CONST(79555.677696639163/8.0),
    REAL_CONST(79578.071188062226/8.0),
    REAL_CONST(79600.466254993895/8.0),
    REAL_CONST(79622.862897212515/8.0),
    REAL_CONST(79645.261114496549/8.0),
    REAL_CONST(79667.660906624471/8.0),
    REAL_CONST(79690.062273374875/8.0),
    REAL_CONST(79712.465214526455/8.0),
    REAL_CONST(79734.869729857935/8.0),
    REAL_CONST(79757.275819148126/8.0),
    REAL_CONST(79779.683482175955/8.0),
    REAL_CONST(79802.092718720378/8.0),
    REAL_CONST(79824.503528560454/8.0),
    REAL_CONST(79846.915911475327/8.0),
    REAL_CONST(79869.329867244203/8.0),
    REAL_CONST(79891.745395646343/8.0),
    REAL_CONST(79914.162496461155/8.0),
    REAL_CONST(79936.581169468045/8.0),
    REAL_CONST(79959.001414446553/8.0),
    REAL_CONST(79981.423231176261/8.0),
    REAL_CONST(80003.846619436852/8.0),
    REAL_CONST(80026.271579008084/8.0),
    REAL_CONST(80048.698109669771/8.0),
    REAL_CONST(80071.12621120183/8.0),
    REAL_CONST(80093.555883384237/8.0),
    REAL_CONST(80115.987125997053/8.0),
    REAL_CONST(80138.419938820414/8.0),
    REAL_CONST(80160.854321634528/8.0),
    REAL_CONST(80183.290274219689/8.0),
    REAL_CONST(80205.727796356281/8.0),
    REAL_CONST(80228.166887824715/8.0),
    REAL_CONST(80250.607548405547/8.0),
    REAL_CONST(80273.049777879336/8.0),
    REAL_CONST(80295.493576026798/8.0),
    REAL_CONST(80317.938942628651/8.0),
    REAL_CONST(80340.385877465727/8.0),
    REAL_CONST(80362.834380318949/8.0),
    REAL_CONST(80385.28445096928/8.0),
    REAL_CONST(80407.736089197788/8.0),
    REAL_CONST(80430.189294785596/8.0),
    REAL_CONST(80452.644067513917/8.0),
    REAL_CONST(80475.100407164035/8.0),
    REAL_CONST(80497.558313517322/8.0),
    REAL_CONST(80520.017786355209/8.0),
    REAL_CONST(80542.478825459213/8.0),
    REAL_CONST(80564.941430610925/8.0),
    REAL_CONST(80587.405601592007/8.0),
    REAL_CONST(80609.871338184195/8.0),
    REAL_CONST(80632.338640169342/8.0),
    REAL_CONST(80654.8075073293/8.0),
    REAL_CONST(80677.277939446067/8.0),
    REAL_CONST(80699.749936301683/8.0),
    REAL_CONST(80722.223497678278/8.0),
    REAL_CONST(80744.698623358039/8.0),
    REAL_CONST(80767.17531312324/8.0),
    REAL_CONST(80789.653566756242/8.0),
    REAL_CONST(80812.133384039465/8.0),
    REAL_CONST(80834.614764755403/8.0),
    REAL_CONST(80857.097708686648/8.0),
    REAL_CONST(80879.582215615854/8.0),
    REAL_CONST(80902.068285325731/8.0),
    REAL_CONST(80924.555917599093/8.0),
    REAL_CONST(80947.045112218824/8.0),
    REAL_CONST(80969.535868967869/8.0),
    REAL_CONST(80992.028187629272/8.0),
    REAL_CONST(81014.522067986123/8.0),
    REAL_CONST(81037.017509821613/8.0),
    REAL_CONST(81059.514512919006/8.0),
    REAL_CONST(81082.013077061609/8.0),
    REAL_CONST(81104.513202032831/8.0),
    REAL_CONST(81127.014887616184/8.0),
    REAL_CONST(81149.518133595193/8.0),
    REAL_CONST(81172.022939753486/8.0),
    REAL_CONST(81194.529305874807/8.0),
    REAL_CONST(81217.037231742899/8.0),
    REAL_CONST(81239.546717141639/8.0),
    REAL_CONST(81262.057761854958/8.0),
    REAL_CONST(81284.570365666848/8.0),
    REAL_CONST(81307.084528361403/8.0),
    REAL_CONST(81329.600249722775/8.0),
    REAL_CONST(81352.117529535186/8.0),
    REAL_CONST(81374.636367582949/8.0),
    REAL_CONST(81397.156763650448/8.0),
    REAL_CONST(81419.678717522125/8.0),
    REAL_CONST(81442.202228982511/8.0),
    REAL_CONST(81464.727297816222/8.0),
    REAL_CONST(81487.253923807933/8.0),
    REAL_CONST(81509.782106742379/8.0),
    REAL_CONST(81532.311846404409/8.0),
    REAL_CONST(81554.843142578902/8.0),
    REAL_CONST(81577.375995050839/8.0),
    REAL_CONST(81599.910403605274/8.0),
    REAL_CONST(81622.446368027333/8.0),
    REAL_CONST(81644.983888102215/8.0),
    REAL_CONST(81667.522963615178/8.0),
    REAL_CONST(81690.063594351581/8.0),
    REAL_CONST(81712.605780096841/8.0),
    REAL_CONST(81735.149520636449/8.0),
    REAL_CONST(81757.694815755967/8.0),
    REAL_CONST(81780.241665241047/8.0),
    REAL_CONST(81802.79006887741/8.0),
    REAL_CONST(81825.340026450824/8.0),
    REAL_CONST(81847.891537747171/8.0),
    REAL_CONST(81870.444602552379/8.0),
    REAL_CONST(81892.999220652477/8.0),
    REAL_CONST(81915.555391833506/8.0),
    REAL_CONST(81938.113115881672/8.0),
    REAL_CONST(81960.672392583176/8.0),
    REAL_CONST(81983.233221724338/8.0),
    REAL_CONST(82005.795603091537/8.0),
    REAL_CONST(82028.359536471224/8.0),
    REAL_CONST(82050.925021649906/8.0),
    REAL_CONST(82073.492058414209/8.0),
    REAL_CONST(82096.060646550788/8.0),
    REAL_CONST(82118.630785846399/8.0),
    REAL_CONST(82141.202476087841/8.0),
    REAL_CONST(82163.775717062032/8.0),
    REAL_CONST(82186.35050855593/8.0),
    REAL_CONST(82208.926850356569/8.0),
    REAL_CONST(82231.504742251054/8.0),
    REAL_CONST(82254.084184026578/8.0),
    REAL_CONST(82276.665175470393/8.0),
    REAL_CONST(82299.24771636985/8.0),
    REAL_CONST(82321.831806512317/8.0),
    REAL_CONST(82344.417445685307/8.0),
    REAL_CONST(82367.004633676348/8.0),
    REAL_CONST(82389.593370273054/8.0),
    REAL_CONST(82412.183655263143/8.0),
    REAL_CONST(82434.775488434374/8.0),
    REAL_CONST(82457.368869574595/8.0),
    REAL_CONST(82479.963798471697/8.0),
    REAL_CONST(82502.560274913689/8.0),
    REAL_CONST(82525.158298688606/8.0),
    REAL_CONST(82547.757869584602/8.0),
    REAL_CONST(82570.35898738986/8.0),
    REAL_CONST(82592.961651892678/8.0),
    REAL_CONST(82615.565862881398/8.0),
    REAL_CONST(82638.171620144421/8.0),
    REAL_CONST(82660.778923470265/8.0),
    REAL_CONST(82683.387772647475/8.0),
    REAL_CONST(82705.998167464713/8.0),
    REAL_CONST(82728.610107710658/8.0),
    REAL_CONST(82751.223593174116/8.0),
    REAL_CONST(82773.83862364394/8.0),
    REAL_CONST(82796.45519890904/8.0),
    REAL_CONST(82819.073318758441/8.0),
    REAL_CONST(82841.692982981185/8.0),
    REAL_CONST(82864.314191366429/8.0),
    REAL_CONST(82886.936943703375/8.0),
    REAL_CONST(82909.561239781324/8.0),
    REAL_CONST(82932.187079389638/8.0),
    REAL_CONST(82954.814462317736/8.0),
    REAL_CONST(82977.443388355125/8.0),
    REAL_CONST(83000.073857291369/8.0),
    REAL_CONST(83022.70586891612/8.0),
    REAL_CONST(83045.339423019104/8.0),
    REAL_CONST(83067.974519390089/8.0),
    REAL_CONST(83090.611157818959/8.0),
    REAL_CONST(83113.249338095629/8.0),
    REAL_CONST(83135.8890600101/8.0),
    REAL_CONST(83158.530323352461/8.0),
    REAL_CONST(83181.173127912858/8.0),
    REAL_CONST(83203.817473481497/8.0),
    REAL_CONST(83226.463359848669/8.0),
    REAL_CONST(83249.11078680474/8.0),
    REAL_CONST(83271.759754140134/8.0),
    REAL_CONST(83294.410261645375/8.0),
    REAL_CONST(83317.062309111003/8.0),
    REAL_CONST(83339.715896327703/8.0),
    REAL_CONST(83362.371023086147/8.0),
    REAL_CONST(83385.027689177165/8.0),
    REAL_CONST(83407.685894391587/8.0),
    REAL_CONST(83430.345638520361/8.0),
    REAL_CONST(83453.006921354478/8.0),
    REAL_CONST(83475.669742685001/8.0),
    REAL_CONST(83498.334102303095/8.0),
    REAL_CONST(83520.999999999942/8.0),
    REAL_CONST(83543.667435566866/8.0),
    REAL_CONST(83566.336408795192/8.0),
    REAL_CONST(83589.006919476349/8.0),
    REAL_CONST(83611.678967401851/8.0),
    REAL_CONST(83634.352552363242/8.0),
    REAL_CONST(83657.027674152167/8.0),
    REAL_CONST(83679.704332560359/8.0),
    REAL_CONST(83702.382527379552/8.0),
    REAL_CONST(83725.062258401638/8.0),
    REAL_CONST(83747.743525418511/8.0),
    REAL_CONST(83770.42632822218/8.0),
    REAL_CONST(83793.110666604684/8.0),
    REAL_CONST(83815.796540358162/8.0),
    REAL_CONST(83838.483949274829/8.0),
    REAL_CONST(83861.172893146941/8.0),
    REAL_CONST(83883.863371766842/8.0),
    REAL_CONST(83906.555384926964/8.0),
    REAL_CONST(83929.248932419752/8.0),
    REAL_CONST(83951.944014037799/8.0),
    REAL_CONST(83974.640629573696/8.0),
    REAL_CONST(83997.338778820151/8.0),
    REAL_CONST(84020.038461569929/8.0),
    REAL_CONST(84042.739677615857/8.0),
    REAL_CONST(84065.442426750829/8.0),
    REAL_CONST(84088.146708767847/8.0),
    REAL_CONST(84110.852523459922/8.0),
    REAL_CONST(84133.559870620171/8.0),
    REAL_CONST(84156.268750041796/8.0),
    REAL_CONST(84178.979161518029/8.0),
    REAL_CONST(84201.691104842204/8.0),
    REAL_CONST(84224.404579807713/8.0),
    REAL_CONST(84247.119586208006/8.0),
    REAL_CONST(84269.83612383662/8.0),
    REAL_CONST(84292.55419248715/8.0),
    REAL_CONST(84315.273791953281/8.0),
    REAL_CONST(84337.994922028738/8.0),
    REAL_CONST(84360.717582507335/8.0),
    REAL_CONST(84383.441773182945/8.0),
    REAL_CONST(84406.167493849513/8.0),
    REAL_CONST(84428.894744301069/8.0),
    REAL_CONST(84451.623524331691/8.0),
    REAL_CONST(84474.353833735542/8.0),
    REAL_CONST(84497.085672306828/8.0),
    REAL_CONST(84519.819039839858/8.0),
    REAL_CONST(84542.553936128999/8.0),
    REAL_CONST(84565.290360968676/8.0),
    REAL_CONST(84588.028314153402/8.0),
    REAL_CONST(84610.767795477717/8.0),
    REAL_CONST(84633.508804736295/8.0),
    REAL_CONST(84656.251341723822/8.0),
    REAL_CONST(84678.995406235073/8.0),
    REAL_CONST(84701.740998064924/8.0),
    REAL_CONST(84724.488117008252/8.0),
    REAL_CONST(84747.236762860062/8.0),
    REAL_CONST(84769.986935415407/8.0),
    REAL_CONST(84792.73863446941/8.0),
    REAL_CONST(84815.491859817252/8.0),
    REAL_CONST(84838.246611254188/8.0),
    REAL_CONST(84861.002888575575/8.0),
    REAL_CONST(84883.760691576768/8.0),
    REAL_CONST(84906.520020053256/8.0),
    REAL_CONST(84929.28087380057/8.0),
    REAL_CONST(84952.043252614312/8.0),
    REAL_CONST(84974.807156290146/8.0),
    REAL_CONST(84997.572584623806/8.0),
    REAL_CONST(85020.339537411113/8.0),
    REAL_CONST(85043.108014447949/8.0),
    REAL_CONST(85065.878015530237/8.0),
    REAL_CONST(85088.649540453989/8.0),
    REAL_CONST(85111.422589015303/8.0),
    REAL_CONST(85134.197161010321/8.0),
    REAL_CONST(85156.973256235244/8.0),
    REAL_CONST(85179.750874486374/8.0),
    REAL_CONST(85202.530015560071/8.0),
    REAL_CONST(85225.310679252725/8.0),
    REAL_CONST(85248.092865360857/8.0),
    REAL_CONST(85270.876573681016/8.0),
    REAL_CONST(85293.661804009811/8.0),
    REAL_CONST(85316.448556143951/8.0),
    REAL_CONST(85339.236829880188/8.0),
    REAL_CONST(85362.026625015351/8.0),
    REAL_CONST(85384.817941346351/8.0),
    REAL_CONST(85407.610778670132/8.0),
    REAL_CONST(85430.405136783724/8.0),
    REAL_CONST(85453.201015484257/8.0),
    REAL_CONST(85475.998414568865/8.0),
    REAL_CONST(85498.797333834795/8.0),
    REAL_CONST(85521.597773079353/8.0),
    REAL_CONST(85544.399732099904/8.0),
    REAL_CONST(85567.203210693886/8.0),
    REAL_CONST(85590.008208658808/8.0),
    REAL_CONST(85612.814725792239/8.0),
    REAL_CONST(85635.62276189182/8.0),
    REAL_CONST(85658.432316755265/8.0),
    REAL_CONST(85681.243390180331/8.0),
    REAL_CONST(85704.055981964877/8.0),
    REAL_CONST(85726.870091906807/8.0),
    REAL_CONST(85749.685719804082/8.0),
    REAL_CONST(85772.502865454764/8.0),
    REAL_CONST(85795.321528656961/8.0),
    REAL_CONST(85818.141709208852/8.0),
    REAL_CONST(85840.963406908675/8.0),
    REAL_CONST(85863.78662155474/8.0),
    REAL_CONST(85886.611352945445/8.0),
    REAL_CONST(85909.437600879217/8.0),
    REAL_CONST(85932.26536515457/8.0),
    REAL_CONST(85955.094645570091/8.0),
    REAL_CONST(85977.92544192441/8.0),
    REAL_CONST(86000.757754016275/8.0),
    REAL_CONST(86023.591581644432/8.0),
    REAL_CONST(86046.426924607746/8.0),
    REAL_CONST(86069.263782705122/8.0),
    REAL_CONST(86092.102155735556/8.0),
    REAL_CONST(86114.942043498071/8.0),
    REAL_CONST(86137.783445791807/8.0),
    REAL_CONST(86160.626362415918/8.0),
    REAL_CONST(86183.470793169676/8.0),
    REAL_CONST(86206.316737852379/8.0),
    REAL_CONST(86229.164196263402/8.0),
    REAL_CONST(86252.013168202204/8.0),
    REAL_CONST(86274.863653468303/8.0),
    REAL_CONST(86297.715651861261/8.0),
    REAL_CONST(86320.569163180728/8.0),
    REAL_CONST(86343.424187226425/8.0),
    REAL_CONST(86366.280723798132/8.0),
    REAL_CONST(86389.138772695675/8.0),
    REAL_CONST(86411.998333718977/8.0),
    REAL_CONST(86434.859406668009/8.0),
    REAL_CONST(86457.721991342827/8.0),
    REAL_CONST(86480.586087543532/8.0),
    REAL_CONST(86503.451695070296/8.0),
    REAL_CONST(86526.318813723352/8.0),
    REAL_CONST(86549.187443303032/8.0),
    REAL_CONST(86572.057583609683/8.0),
    REAL_CONST(86594.929234443756/8.0),
    REAL_CONST(86617.802395605773/8.0),
    REAL_CONST(86640.677066896271/8.0),
    REAL_CONST(86663.553248115903/8.0),
    REAL_CONST(86686.43093906538/8.0),
    REAL_CONST(86709.310139545443/8.0),
    REAL_CONST(86732.190849356964/8.0),
    REAL_CONST(86755.073068300815/8.0),
    REAL_CONST(86777.956796177954/8.0),
    REAL_CONST(86800.842032789442/8.0),
    REAL_CONST(86823.728777936354/8.0),
    REAL_CONST(86846.617031419853/8.0),
    REAL_CONST(86869.506793041175/8.0),
    REAL_CONST(86892.398062601613/8.0),
    REAL_CONST(86915.290839902518/8.0),
    REAL_CONST(86938.185124745316/8.0),
    REAL_CONST(86961.080916931489/8.0),
    REAL_CONST(86983.978216262592/8.0),
    REAL_CONST(87006.87702254027/8.0),
    REAL_CONST(87029.777335566177/8.0),
    REAL_CONST(87052.67915514209/8.0),
    REAL_CONST(87075.582481069796/8.0),
    REAL_CONST(87098.487313151185/8.0),
    REAL_CONST(87121.39365118822/8.0),
    REAL_CONST(87144.301494982894/8.0),
    REAL_CONST(87167.210844337285/8.0),
    REAL_CONST(87190.121699053532/8.0),
    REAL_CONST(87213.034058933845/8.0),
    REAL_CONST(87235.947923780506/8.0),
    REAL_CONST(87258.863293395829/8.0),
    REAL_CONST(87281.780167582241/8.0),
    REAL_CONST(87304.698546142172/8.0),
    REAL_CONST(87327.618428878181/8.0),
    REAL_CONST(87350.539815592856/8.0),
    REAL_CONST(87373.462706088845/8.0),
    REAL_CONST(87396.387100168897/8.0),
    REAL_CONST(87419.312997635774/8.0),
    REAL_CONST(87442.240398292357/8.0),
    REAL_CONST(87465.16930194154/8.0),
    REAL_CONST(87488.099708386319/8.0),
    REAL_CONST(87511.031617429733/8.0),
    REAL_CONST(87533.965028874911/8.0),
    REAL_CONST(87556.899942525008/8.0),
    REAL_CONST(87579.836358183282/8.0),
    REAL_CONST(87602.774275653021/8.0),
    REAL_CONST(87625.713694737613/8.0),
    REAL_CONST(87648.654615240492/8.0),
    REAL_CONST(87671.597036965148/8.0),
    REAL_CONST(87694.540959715145/8.0),
    REAL_CONST(87717.486383294105/8.0),
    REAL_CONST(87740.433307505737/8.0),
    REAL_CONST(87763.381732153779/8.0),
    REAL_CONST(87786.331657042057/8.0),
    REAL_CONST(87809.283081974456/8.0),
    REAL_CONST(87832.236006754916/8.0),
    REAL_CONST(87855.190431187453/8.0),
    REAL_CONST(87878.146355076155/8.0),
    REAL_CONST(87901.103778225151/8.0),
    REAL_CONST(87924.062700438633/8.0),
    REAL_CONST(87947.023121520891/8.0),
    REAL_CONST(87969.985041276246/8.0),
    REAL_CONST(87992.948459509105/8.0),
    REAL_CONST(88015.913376023906/8.0),
    REAL_CONST(88038.879790625171/8.0),
    REAL_CONST(88061.847703117513/8.0),
    REAL_CONST(88084.817113305573/8.0),
    REAL_CONST(88107.788020994049/8.0),
    REAL_CONST(88130.760425987726/8.0),
    REAL_CONST(88153.734328091465/8.0),
    REAL_CONST(88176.709727110137/8.0),
    REAL_CONST(88199.686622848749/8.0),
    REAL_CONST(88222.665015112303/8.0),
    REAL_CONST(88245.644903705906/8.0),
    REAL_CONST(88268.626288434709/8.0),
    REAL_CONST(88291.609169103947/8.0),
    REAL_CONST(88314.593545518903/8.0),
    REAL_CONST(88337.579417484914/8.0),
    REAL_CONST(88360.566784807408/8.0),
    REAL_CONST(88383.555647291854/8.0),
    REAL_CONST(88406.546004743795/8.0),
    REAL_CONST(88429.537856968818/8.0),
    REAL_CONST(88452.531203772611/8.0),
    REAL_CONST(88475.52604496089/8.0),
    REAL_CONST(88498.522380339447/8.0),
    REAL_CONST(88521.52020971413/8.0),
    REAL_CONST(88544.519532890874/8.0),
    REAL_CONST(88567.520349675644/8.0),
    REAL_CONST(88590.522659874507/8.0),
    REAL_CONST(88613.526463293543/8.0),
    REAL_CONST(88636.531759738922/8.0),
    REAL_CONST(88659.538549016899/8.0),
    REAL_CONST(88682.546830933745/8.0),
    REAL_CONST(88705.556605295846/8.0),
    REAL_CONST(88728.567871909589/8.0),
    REAL_CONST(88751.580630581491/8.0),
    REAL_CONST(88774.594881118086/8.0),
    REAL_CONST(88797.610623325963/8.0),
    REAL_CONST(88820.62785701183/8.0),
    REAL_CONST(88843.646581982393/8.0),
    REAL_CONST(88866.666798044462/8.0),
    REAL_CONST(88889.688505004888/8.0),
    REAL_CONST(88912.711702670611/8.0),
    REAL_CONST(88935.7363908486/8.0),
    REAL_CONST(88958.762569345898/8.0),
    REAL_CONST(88981.790237969632/8.0),
    REAL_CONST(89004.81939652696/8.0),
    REAL_CONST(89027.850044825114/8.0),
    REAL_CONST(89050.882182671412/8.0),
    REAL_CONST(89073.9158098732/8.0),
    REAL_CONST(89096.950926237885/8.0),
    REAL_CONST(89119.987531572973/8.0),
    REAL_CONST(89143.025625686001/8.0),
    REAL_CONST(89166.065208384563/8.0),
    REAL_CONST(89189.106279476357/8.0),
    REAL_CONST(89212.148838769106/8.0),
    REAL_CONST(89235.192886070581/8.0),
    REAL_CONST(89258.238421188667/8.0),
    REAL_CONST(89281.285443931265/8.0),
    REAL_CONST(89304.333954106376/8.0),
    REAL_CONST(89327.383951522017/8.0),
    REAL_CONST(89350.435435986306/8.0),
    REAL_CONST(89373.488407307406/8.0),
    REAL_CONST(89396.542865293537/8.0),
    REAL_CONST(89419.598809753006/8.0),
    REAL_CONST(89442.656240494165/8.0),
    REAL_CONST(89465.715157325409/8.0),
    REAL_CONST(89488.775560055219/8.0),
    REAL_CONST(89511.837448492137/8.0),
    REAL_CONST(89534.900822444746/8.0),
    REAL_CONST(89557.965681721733/8.0),
    REAL_CONST(89581.032026131812/8.0),
    REAL_CONST(89604.099855483742/8.0),
    REAL_CONST(89627.169169586399/8.0),
    REAL_CONST(89650.239968248672/8.0),
    REAL_CONST(89673.312251279538/8.0),
    REAL_CONST(89696.386018488018/8.0),
    REAL_CONST(89719.461269683205/8.0),
    REAL_CONST(89742.53800467425/8.0),
    REAL_CONST(89765.616223270365/8.0),
    REAL_CONST(89788.69592528083/8.0),
    REAL_CONST(89811.777110514988/8.0),
    REAL_CONST(89834.859778782207/8.0),
    REAL_CONST(89857.943929891975/8.0),
    REAL_CONST(89881.029563653807/8.0),
    REAL_CONST(89904.116679877261/8.0),
    REAL_CONST(89927.205278372014/8.0),
    REAL_CONST(89950.29535894774/8.0),
    REAL_CONST(89973.386921414218/8.0),
    REAL_CONST(89996.479965581268/8.0),
    REAL_CONST(90019.574491258769/8.0),
    REAL_CONST(90042.670498256688/8.0),
    REAL_CONST(90065.767986385021/8.0),
    REAL_CONST(90088.866955453836/8.0),
    REAL_CONST(90111.967405273259/8.0),
    REAL_CONST(90135.069335653476/8.0),
    REAL_CONST(90158.172746404758/8.0),
    REAL_CONST(90181.277637337407/8.0),
    REAL_CONST(90204.384008261797/8.0),
    REAL_CONST(90227.49185898836/8.0),
    REAL_CONST(90250.601189327586/8.0),
    REAL_CONST(90273.711999090039/8.0),
    REAL_CONST(90296.824288086325/8.0),
    REAL_CONST(90319.938056127125/8.0),
    REAL_CONST(90343.053303023189/8.0),
    REAL_CONST(90366.170028585286/8.0),
    REAL_CONST(90389.288232624298/8.0),
    REAL_CONST(90412.407914951138/8.0),
    REAL_CONST(90435.529075376777/8.0),
    REAL_CONST(90458.651713712257/8.0),
    REAL_CONST(90481.775829768681/8.0),
    REAL_CONST(90504.901423357209/8.0),
    REAL_CONST(90528.028494289058/8.0),
    REAL_CONST(90551.157042375504/8.0),
    REAL_CONST(90574.287067427911/8.0),
    REAL_CONST(90597.418569257643/8.0),
    REAL_CONST(90620.551547676194/8.0),
    REAL_CONST(90643.686002495073/8.0),
    REAL_CONST(90666.821933525847/8.0),
    REAL_CONST(90689.959340580186/8.0),
    REAL_CONST(90713.098223469773/8.0),
    REAL_CONST(90736.238582006365/8.0),
    REAL_CONST(90759.380416001804/8.0),
    REAL_CONST(90782.523725267951/8.0),
    REAL_CONST(90805.668509616764/8.0),
    REAL_CONST(90828.814768860233/8.0),
    REAL_CONST(90851.962502810435/8.0),
    REAL_CONST(90875.11171127946/8.0),
    REAL_CONST(90898.262394079517/8.0),
    REAL_CONST(90921.414551022855/8.0),
    REAL_CONST(90944.568181921743/8.0),
    REAL_CONST(90967.72328658856/8.0),
    REAL_CONST(90990.879864835719/8.0),
    REAL_CONST(91014.037916475718/8.0),
    REAL_CONST(91037.19744132107/8.0),
    REAL_CONST(91060.358439184391/8.0),
    REAL_CONST(91083.520909878338/8.0),
    REAL_CONST(91106.684853215629/8.0),
    REAL_CONST(91129.850269009039/8.0),
    REAL_CONST(91153.017157071401/8.0),
    REAL_CONST(91176.185517215621/8.0),
    REAL_CONST(91199.355349254649/8.0),
    REAL_CONST(91222.526653001492/8.0),
    REAL_CONST(91245.699428269247/8.0),
    REAL_CONST(91268.873674871036/8.0),
    REAL_CONST(91292.049392620058/8.0),
    REAL_CONST(91315.226581329553/8.0),
    REAL_CONST(91338.405240812834/8.0),
    REAL_CONST(91361.585370883287/8.0),
    REAL_CONST(91384.766971354344/8.0),
    REAL_CONST(91407.950042039476/8.0),
    REAL_CONST(91431.134582752245/8.0),
    REAL_CONST(91454.320593306256/8.0),
    REAL_CONST(91477.508073515171/8.0),
    REAL_CONST(91500.697023192712/8.0),
    REAL_CONST(91523.887442152685/8.0),
    REAL_CONST(91547.07933020893/8.0),
    REAL_CONST(91570.272687175326/8.0),
    REAL_CONST(91593.467512865856/8.0),
    REAL_CONST(91616.663807094534/8.0),
    REAL_CONST(91639.861569675442/8.0),
    REAL_CONST(91663.060800422725/8.0),
    REAL_CONST(91686.261499150554/8.0),
    REAL_CONST(91709.463665673218/8.0),
    REAL_CONST(91732.66729980502/8.0),
    REAL_CONST(91755.872401360321/8.0),
    REAL_CONST(91779.078970153569/8.0),
    REAL_CONST(91802.287005999257/8.0),
    REAL_CONST(91825.49650871192/8.0),
    REAL_CONST(91848.707478106167/8.0),
    REAL_CONST(91871.91991399668/8.0),
    REAL_CONST(91895.133816198169/8.0),
    REAL_CONST(91918.349184525418/8.0),
    REAL_CONST(91941.566018793281/8.0),
    REAL_CONST(91964.784318816659/8.0),
    REAL_CONST(91988.004084410495/8.0),
    REAL_CONST(92011.22531538982/8.0),
    REAL_CONST(92034.448011569708/8.0),
    REAL_CONST(92057.672172765277/8.0),
    REAL_CONST(92080.897798791746/8.0),
    REAL_CONST(92104.124889464365/8.0),
    REAL_CONST(92127.353444598411/8.0),
    REAL_CONST(92150.58346400928/8.0),
    REAL_CONST(92173.814947512379/8.0),
    REAL_CONST(92197.04789492322/8.0),
    REAL_CONST(92220.282306057314/8.0),
    REAL_CONST(92243.518180730272/8.0),
    REAL_CONST(92266.755518757753/8.0),
    REAL_CONST(92289.994319955469/8.0),
    REAL_CONST(92313.234584139194/8.0),
    REAL_CONST(92336.476311124774/8.0),
    REAL_CONST(92359.719500728082/8.0),
    REAL_CONST(92382.964152765067/8.0),
    REAL_CONST(92406.210267051734/8.0),
    REAL_CONST(92429.457843404161/8.0),
    REAL_CONST(92452.706881638471/8.0),
    REAL_CONST(92475.957381570814/8.0),
    REAL_CONST(92499.209343017443/8.0),
    REAL_CONST(92522.462765794655/8.0),
    REAL_CONST(92545.717649718805/8.0),
    REAL_CONST(92568.973994606305/8.0),
    REAL_CONST(92592.231800273614/8.0),
    REAL_CONST(92615.491066537259/8.0),
    REAL_CONST(92638.751793213814/8.0),
    REAL_CONST(92662.01398011994/8.0),
    REAL_CONST(92685.277627072326/8.0),
    REAL_CONST(92708.54273388772/8.0),
    REAL_CONST(92731.809300382942/8.0),
    REAL_CONST(92755.077326374871/8.0),
    REAL_CONST(92778.346811680414/8.0),
    REAL_CONST(92801.617756116568/8.0),
    REAL_CONST(92824.890159500384/8.0),
    REAL_CONST(92848.164021648947/8.0),
    REAL_CONST(92871.439342379424/8.0),
    REAL_CONST(92894.716121509016/8.0),
    REAL_CONST(92917.994358855023/8.0),
    REAL_CONST(92941.274054234746/8.0),
    REAL_CONST(92964.555207465572/8.0),
    REAL_CONST(92987.837818364962/8.0),
    REAL_CONST(93011.121886750407/8.0),
    REAL_CONST(93034.407412439468/8.0),
    REAL_CONST(93057.694395249753/8.0),
    REAL_CONST(93080.982834998955/8.0),
    REAL_CONST(93104.272731504767/8.0),
    REAL_CONST(93127.564084584999/8.0),
    REAL_CONST(93150.856894057491/8.0),
    REAL_CONST(93174.15115974014/8.0),
    REAL_CONST(93197.446881450916/8.0),
    REAL_CONST(93220.744059007804/8.0),
    REAL_CONST(93244.04269222889/8.0),
    REAL_CONST(93267.342780932304/8.0),
    REAL_CONST(93290.644324936235/8.0),
    REAL_CONST(93313.947324058914/8.0),
    REAL_CONST(93337.251778118633/8.0),
    REAL_CONST(93360.557686933767/8.0),
    REAL_CONST(93383.865050322696/8.0),
    REAL_CONST(93407.173868103928/8.0),
    REAL_CONST(93430.484140095941/8.0),
    REAL_CONST(93453.795866117362/8.0),
    REAL_CONST(93477.109045986799/8.0),
    REAL_CONST(93500.423679522952/8.0),
    REAL_CONST(93523.739766544561/8.0),
    REAL_CONST(93547.057306870454/8.0),
    REAL_CONST(93570.376300319491/8.0),
    REAL_CONST(93593.696746710571/8.0),
    REAL_CONST(93617.018645862699/8.0),
    REAL_CONST(93640.341997594893/8.0),
    REAL_CONST(93663.666801726242/8.0),
    REAL_CONST(93686.993058075881/8.0),
    REAL_CONST(93710.320766463032/8.0),
    REAL_CONST(93733.64992670693/8.0),
    REAL_CONST(93756.980538626914/8.0),
    REAL_CONST(93780.312602042337/8.0),
    REAL_CONST(93803.646116772637/8.0),
    REAL_CONST(93826.981082637285/8.0),
    REAL_CONST(93850.317499455836/8.0),
    REAL_CONST(93873.655367047861/8.0),
    REAL_CONST(93896.994685233032/8.0),
    REAL_CONST(93920.335453831038/8.0),
    REAL_CONST(93943.677672661666/8.0),
    REAL_CONST(93967.021341544707/8.0),
    REAL_CONST(93990.366460300051/8.0),
    REAL_CONST(94013.713028747632/8.0),
    REAL_CONST(94037.061046707429/8.0),
    REAL_CONST(94060.410513999494/8.0),
    REAL_CONST(94083.761430443905/8.0),
    REAL_CONST(94107.113795860845/8.0),
    REAL_CONST(94130.467610070496/8.0),
    REAL_CONST(94153.822872893157/8.0),
    REAL_CONST(94177.179584149111/8.0),
    REAL_CONST(94200.537743658759/8.0),
    REAL_CONST(94223.897351242529/8.0),
    REAL_CONST(94247.25840672091/8.0),
    REAL_CONST(94270.620909914433/8.0),
    REAL_CONST(94293.98486064373/8.0),
    REAL_CONST(94317.350258729421/8.0),
    REAL_CONST(94340.71710399224/8.0),
    REAL_CONST(94364.085396252936/8.0),
    REAL_CONST(94387.455135332348/8.0),
    REAL_CONST(94410.82632105134/8.0),
    REAL_CONST(94434.198953230851/8.0),
    REAL_CONST(94457.573031691878/8.0),
    REAL_CONST(94480.948556255447/8.0),
    REAL_CONST(94504.325526742658/8.0),
    REAL_CONST(94527.70394297468/8.0),
    REAL_CONST(94551.083804772716/8.0),
    REAL_CONST(94574.465111958023/8.0),
    REAL_CONST(94597.847864351934/8.0),
    REAL_CONST(94621.232061775823/8.0),
    REAL_CONST(94644.617704051096/8.0),
    REAL_CONST(94668.004790999272/8.0),
    REAL_CONST(94691.393322441872/8.0),
    REAL_CONST(94714.783298200506/8.0),
    REAL_CONST(94738.174718096794/8.0),
    REAL_CONST(94761.567581952477/8.0),
    REAL_CONST(94784.961889589307/8.0),
    REAL_CONST(94808.357640829097/8.0),
    REAL_CONST(94831.754835493703/8.0),
    REAL_CONST(94855.153473405066/8.0),
    REAL_CONST(94878.553554385173/8.0),
    REAL_CONST(94901.955078256055/8.0),
    REAL_CONST(94925.358044839784/8.0),
    REAL_CONST(94948.762453958523/8.0),
    REAL_CONST(94972.168305434476/8.0),
    REAL_CONST(94995.575599089891/8.0),
    REAL_CONST(95018.984334747074/8.0),
    REAL_CONST(95042.394512228391/8.0),
    REAL_CONST(95065.806131356265/8.0),
    REAL_CONST(95089.219191953176/8.0),
    REAL_CONST(95112.633693841635/8.0),
    REAL_CONST(95136.04963684424/8.0),
    REAL_CONST(95159.467020783617/8.0),
    REAL_CONST(95182.885845482466/8.0),
    REAL_CONST(95206.306110763529/8.0),
    REAL_CONST(95229.727816449609/8.0),
    REAL_CONST(95253.150962363579/8.0),
    REAL_CONST(95276.575548328314/8.0),
    REAL_CONST(95300.001574166803/8.0),
    REAL_CONST(95323.429039702052/8.0),
    REAL_CONST(95346.857944757154/8.0),
    REAL_CONST(95370.288289155214/8.0),
    REAL_CONST(95393.720072719429/8.0),
    REAL_CONST(95417.153295273019/8.0),
    REAL_CONST(95440.587956639298/8.0),
    REAL_CONST(95464.024056641589/8.0),
    REAL_CONST(95487.461595103305/8.0),
    REAL_CONST(95510.900571847902/8.0),
    REAL_CONST(95534.340986698866/8.0),
    REAL_CONST(95557.782839479783/8.0),
    REAL_CONST(95581.226130014256/8.0),
    REAL_CONST(95604.670858125959/8.0),
    REAL_CONST(95628.117023638595/8.0),
    REAL_CONST(95651.564626375985/8.0),
    REAL_CONST(95675.013666161918/8.0),
    REAL_CONST(95698.464142820303/8.0),
    REAL_CONST(95721.916056175076/8.0),
    REAL_CONST(95745.369406050231/8.0),
    REAL_CONST(95768.824192269807/8.0),
    REAL_CONST(95792.280414657915/8.0),
    REAL_CONST(95815.738073038709/8.0),
    REAL_CONST(95839.197167236387/8.0),
    REAL_CONST(95862.657697075221/8.0),
    REAL_CONST(95886.11966237954/8.0),
    REAL_CONST(95909.583062973688/8.0),
    REAL_CONST(95933.047898682111/8.0),
    REAL_CONST(95956.514169329268/8.0),
    REAL_CONST(95979.981874739708/8.0),
    REAL_CONST(96003.451014738006/8.0),
    REAL_CONST(96026.921589148798/8.0),
    REAL_CONST(96050.393597796792/8.0),
    REAL_CONST(96073.867040506724/8.0),
    REAL_CONST(96097.341917103375/8.0),
    REAL_CONST(96120.818227411626/8.0),
    REAL_CONST(96144.295971256375/8.0),
    REAL_CONST(96167.775148462577/8.0),
    REAL_CONST(96191.255758855244/8.0),
    REAL_CONST(96214.737802259449/8.0),
    REAL_CONST(96238.221278500292/8.0),
    REAL_CONST(96261.70618740299/8.0),
    REAL_CONST(96285.192528792715/8.0),
    REAL_CONST(96308.680302494788/8.0),
    REAL_CONST(96332.169508334526/8.0),
    REAL_CONST(96355.660146137321/8.0),
    REAL_CONST(96379.152215728609/8.0),
    REAL_CONST(96402.645716933868/8.0),
    REAL_CONST(96426.14064957868/8.0),
    REAL_CONST(96449.637013488609/8.0),
    REAL_CONST(96473.134808489311/8.0),
    REAL_CONST(96496.63403440651/8.0),
    REAL_CONST(96520.134691065963/8.0),
    REAL_CONST(96543.636778293469/8.0),
    REAL_CONST(96567.140295914898/8.0),
    REAL_CONST(96590.645243756153/8.0),
    REAL_CONST(96614.151621643221/8.0),
    REAL_CONST(96637.659429402134/8.0),
    REAL_CONST(96661.168666858954/8.0),
    REAL_CONST(96684.679333839798/8.0),
    REAL_CONST(96708.191430170875/8.0),
    REAL_CONST(96731.70495567839/8.0),
    REAL_CONST(96755.219910188665/8.0),
    REAL_CONST(96778.736293528011/8.0),
    REAL_CONST(96802.254105522836/8.0),
    REAL_CONST(96825.77334599958/8.0),
    REAL_CONST(96849.29401478474/8.0),
    REAL_CONST(96872.816111704873/8.0),
    REAL_CONST(96896.339636586577/8.0),
    REAL_CONST(96919.864589256511/8.0),
    REAL_CONST(96943.390969541389/8.0),
    REAL_CONST(96966.918777267958/8.0),
    REAL_CONST(96990.448012263048/8.0),
    REAL_CONST(97013.978674353522/8.0),
    REAL_CONST(97037.510763366285/8.0),
    REAL_CONST(97061.044279128328/8.0),
    REAL_CONST(97084.579221466673/8.0),
    REAL_CONST(97108.115590208385/8.0),
    REAL_CONST(97131.653385180587/8.0),
    REAL_CONST(97155.19260621049/8.0),
    REAL_CONST(97178.733253125291/8.0),
    REAL_CONST(97202.2753257523/8.0),
    REAL_CONST(97225.81882391886/8.0),
    REAL_CONST(97249.363747452342/8.0),
    REAL_CONST(97272.910096180189/8.0),
    REAL_CONST(97296.457869929916/8.0),
    REAL_CONST(97320.007068529041/8.0),
    REAL_CONST(97343.557691805196/8.0),
    REAL_CONST(97367.109739586012/8.0),
    REAL_CONST(97390.663211699197/8.0),
    REAL_CONST(97414.218107972498/8.0),
    REAL_CONST(97437.774428233737/8.0),
    REAL_CONST(97461.332172310766/8.0),
    REAL_CONST(97484.891340031507/8.0),
    REAL_CONST(97508.451931223899/8.0),
    REAL_CONST(97532.013945715982/8.0),
    REAL_CONST(97555.577383335811/8.0),
    REAL_CONST(97579.142243911512/8.0),
    REAL_CONST(97602.708527271257/8.0),
    REAL_CONST(97626.276233243261/8.0),
    REAL_CONST(97649.845361655811/8.0),
    REAL_CONST(97673.415912337223/8.0),
    REAL_CONST(97696.987885115886/8.0),
    REAL_CONST(97720.561279820206/8.0),
    REAL_CONST(97744.1360962787/8.0),
    REAL_CONST(97767.712334319876/8.0),
    REAL_CONST(97791.289993772341/8.0),
    REAL_CONST(97814.869074464703/8.0),
    REAL_CONST(97838.449576225685/8.0),
    REAL_CONST(97862.031498883996/8.0),
    REAL_CONST(97885.614842268449/8.0),
    REAL_CONST(97909.199606207883/8.0),
    REAL_CONST(97932.785790531183/8.0),
    REAL_CONST(97956.37339506732/8.0),
    REAL_CONST(97979.962419645264/8.0),
    REAL_CONST(98003.552864094076/8.0),
    REAL_CONST(98027.144728242856/8.0),
    REAL_CONST(98050.738011920766/8.0),
    REAL_CONST(98074.332714956996/8.0),
    REAL_CONST(98097.928837180807/8.0),
    REAL_CONST(98121.526378421506/8.0),
    REAL_CONST(98145.125338508456/8.0),
    REAL_CONST(98168.725717271067/8.0),
    REAL_CONST(98192.327514538789/8.0),
    REAL_CONST(98215.930730141132/8.0),
    REAL_CONST(98239.535363907664/8.0),
    REAL_CONST(98263.141415668011/8.0),
    REAL_CONST(98286.748885251814/8.0),
    REAL_CONST(98310.357772488816/8.0),
    REAL_CONST(98333.968077208759/8.0),
    REAL_CONST(98357.579799241488/8.0),
    REAL_CONST(98381.192938416847/8.0),
    REAL_CONST(98404.807494564782/8.0),
    REAL_CONST(98428.42346751524/8.0),
    REAL_CONST(98452.040857098269/8.0),
    REAL_CONST(98475.659663143917/8.0),
    REAL_CONST(98499.27988548232/8.0),
    REAL_CONST(98522.901523943656/8.0),
    REAL_CONST(98546.524578358163/8.0),
    REAL_CONST(98570.149048556093/8.0),
    REAL_CONST(98593.774934367786/8.0),
    REAL_CONST(98617.402235623624/8.0),
    REAL_CONST(98641.030952154048/8.0),
    REAL_CONST(98664.661083789513/8.0),
    REAL_CONST(98688.292630360564/8.0),
    REAL_CONST(98711.925591697771/8.0),
    REAL_CONST(98735.559967631794/8.0),
    REAL_CONST(98759.195757993293/8.0),
    REAL_CONST(98782.832962613014/8.0),
    REAL_CONST(98806.471581321734/8.0),
    REAL_CONST(98830.111613950285/8.0),
    REAL_CONST(98853.753060329575/8.0),
    REAL_CONST(98877.39592029051/8.0),
    REAL_CONST(98901.040193664099/8.0),
    REAL_CONST(98924.68588028138/8.0),
    REAL_CONST(98948.33297997342/8.0),
    REAL_CONST(98971.981492571387/8.0),
    REAL_CONST(98995.63141790645/8.0),
    REAL_CONST(99019.282755809851/8.0),
    REAL_CONST(99042.935506112874/8.0),
    REAL_CONST(99066.589668646877/8.0),
    REAL_CONST(99090.245243243233/8.0),
    REAL_CONST(99113.902229733401/8.0),
    REAL_CONST(99137.560627948857/8.0),
    REAL_CONST(99161.220437721131/8.0),
    REAL_CONST(99184.881658881859/8.0),
    REAL_CONST(99208.544291262631/8.0),
    REAL_CONST(99232.208334695169/8.0),
    REAL_CONST(99255.87378901121/8.0),
    REAL_CONST(99279.540654042547/8.0),
    REAL_CONST(99303.208929621018/8.0),
    REAL_CONST(99326.878615578535/8.0),
    REAL_CONST(99350.549711746993/8.0),
    REAL_CONST(99374.222217958435/8.0),
    REAL_CONST(99397.896134044888/8.0),
    REAL_CONST(99421.571459838422/8.0),
    REAL_CONST(99445.248195171211/8.0),
    REAL_CONST(99468.926339875441/8.0),
    REAL_CONST(99492.605893783344/8.0),
    REAL_CONST(99516.286856727209/8.0),
    REAL_CONST(99539.969228539398/8.0),
    REAL_CONST(99563.653009052287/8.0),
    REAL_CONST(99587.338198098325/8.0),
    REAL_CONST(99611.024795510006/8.0),
    REAL_CONST(99634.712801119866/8.0),
    REAL_CONST(99658.402214760499/8.0),
    REAL_CONST(99682.093036264545/8.0),
    REAL_CONST(99705.785265464699/8.0),
    REAL_CONST(99729.478902193689/8.0),
    REAL_CONST(99753.173946284325/8.0),
    REAL_CONST(99776.870397569437/8.0),
    REAL_CONST(99800.56825588191/8.0),
    REAL_CONST(99824.267521054688/8.0),
    REAL_CONST(99847.968192920773/8.0),
    REAL_CONST(99871.670271313182/8.0),
    REAL_CONST(99895.373756065004/8.0),
    REAL_CONST(99919.078647009388/8.0),
    REAL_CONST(99942.78494397951/8.0),
    REAL_CONST(99966.492646808634/8.0),
    REAL_CONST(99990.20175533001/8.0),
    REAL_CONST(100013.91226937699/8.0),
    REAL_CONST(100037.62418878295/8.0),
    REAL_CONST(100061.33751338134/8.0),
    REAL_CONST(100085.05224300563/8.0),
    REAL_CONST(100108.76837748935/8.0),
    REAL_CONST(100132.4859166661/8.0),
    REAL_CONST(100156.2048603695/8.0),
    REAL_CONST(100179.92520843323/8.0),
    REAL_CONST(100203.64696069101/8.0),
    REAL_CONST(100227.37011697664/8.0),
    REAL_CONST(100251.09467712394/8.0),
    REAL_CONST(100274.82064096678/8.0),
    REAL_CONST(100298.54800833909/8.0),
    REAL_CONST(100322.27677907483/8.0),
    REAL_CONST(100346.00695300807/8.0),
    REAL_CONST(100369.73852997283/8.0),
    REAL_CONST(100393.47150980328/8.0),
    REAL_CONST(100417.20589233354/8.0),
    REAL_CONST(100440.94167739789/8.0),
    REAL_CONST(100464.67886483055/8.0),
    REAL_CONST(100488.41745446586/8.0),
    REAL_CONST(100512.1574461382/8.0),
    REAL_CONST(100535.89883968196/8.0),
    REAL_CONST(100559.64163493161/8.0),
    REAL_CONST(100583.38583172169/8.0),
    REAL_CONST(100607.13142988674/8.0),
    REAL_CONST(100630.87842926137/8.0),
    REAL_CONST(100654.62682968024/8.0),
    REAL_CONST(100678.37663097809/8.0),
    REAL_CONST(100702.12783298964/8.0),
    REAL_CONST(100725.88043554971/8.0),
    REAL_CONST(100749.63443849317/8.0),
    REAL_CONST(100773.38984165489/8.0),
    REAL_CONST(100797.14664486986/8.0),
    REAL_CONST(100820.90484797307/8.0),
    REAL_CONST(100844.66445079957/8.0),
    REAL_CONST(100868.42545318443/8.0),
    REAL_CONST(100892.18785496285/8.0),
    REAL_CONST(100915.95165596998/8.0),
    REAL_CONST(100939.71685604109/8.0),
    REAL_CONST(100963.48345501146/8.0),
    REAL_CONST(100987.25145271645/8.0),
    REAL_CONST(101011.02084899142/8.0),
    REAL_CONST(101034.79164367182/8.0),
    REAL_CONST(101058.56383659317/8.0),
    REAL_CONST(101082.33742759094/8.0),
    REAL_CONST(101106.11241650078/8.0),
    REAL_CONST(101129.88880315828/8.0),
    REAL_CONST(101153.66658739912/8.0),
    REAL_CONST(101177.44576905905/8.0),
    REAL_CONST(101201.22634797383/8.0),
    REAL_CONST(101225.00832397929/8.0),
    REAL_CONST(101248.7916969113/8.0),
    REAL_CONST(101272.57646660579/8.0),
    REAL_CONST(101296.36263289873/8.0),
    REAL_CONST(101320.15019562612/8.0),
    REAL_CONST(101343.93915462404/8.0),
    REAL_CONST(101367.7295097286/8.0),
    REAL_CONST(101391.52126077596/8.0),
    REAL_CONST(101415.31440760233/8.0),
    REAL_CONST(101439.10895004397/8.0),
    REAL_CONST(101462.9048879372/8.0),
    REAL_CONST(101486.70222111834/8.0),
    REAL_CONST(101510.50094942382/8.0),
    REAL_CONST(101534.30107269008/8.0),
    REAL_CONST(101558.10259075361/8.0),
    REAL_CONST(101581.90550345098/8.0),
    REAL_CONST(101605.70981061876/8.0),
    REAL_CONST(101629.5155120936/8.0),
    REAL_CONST(101653.32260771218/8.0),
    REAL_CONST(101677.13109731126/8.0),
    REAL_CONST(101700.9409807276/8.0),
    REAL_CONST(101724.75225779804/8.0),
    REAL_CONST(101748.56492835947/8.0),
    REAL_CONST(101772.37899224881/8.0),
    REAL_CONST(101796.19444930303/8.0),
    REAL_CONST(101820.01129935916/8.0),
    REAL_CONST(101843.82954225427/8.0),
    REAL_CONST(101867.64917782549/8.0),
    REAL_CONST(101891.47020590997/8.0),
    REAL_CONST(101915.29262634492/8.0),
    REAL_CONST(101939.11643896763/8.0),
    REAL_CONST(101962.94164361537/8.0),
    REAL_CONST(101986.76824012553/8.0),
    REAL_CONST(102010.59622833549/8.0),
    REAL_CONST(102034.42560808272/8.0),
    REAL_CONST(102058.25637920471/8.0),
    REAL_CONST(102082.08854153901/8.0),
    REAL_CONST(102105.9220949232/8.0),
    REAL_CONST(102129.75703919494/8.0),
    REAL_CONST(102153.59337419191/8.0),
    REAL_CONST(102177.43109975185/8.0),
    REAL_CONST(102201.27021571253/8.0),
    REAL_CONST(102225.1107219118/8.0),
    REAL_CONST(102248.95261818753/8.0),
    REAL_CONST(102272.79590437764/8.0),
    REAL_CONST(102296.64058032009/8.0),
    REAL_CONST(102320.48664585294/8.0),
    REAL_CONST(102344.33410081422/8.0),
    REAL_CONST(102368.18294504205/8.0),
    REAL_CONST(102392.03317837461/8.0),
    REAL_CONST(102415.88480065008/8.0),
    REAL_CONST(102439.73781170673/8.0),
    REAL_CONST(102463.59221138287/8.0),
    REAL_CONST(102487.44799951684/8.0),
    REAL_CONST(102511.30517594704/8.0),
    REAL_CONST(102535.1637405119/8.0),
    REAL_CONST(102559.02369304992/8.0),
    REAL_CONST(102582.88503339965/8.0),
    REAL_CONST(102606.74776139967/8.0),
    REAL_CONST(102630.61187688859/8.0),
    REAL_CONST(102654.4773797051/8.0),
    REAL_CONST(102678.34426968795/8.0),
    REAL_CONST(102702.21254667587/8.0),
    REAL_CONST(102726.08221050771/8.0),
    REAL_CONST(102749.95326102231/8.0),
    REAL_CONST(102773.8256980586/8.0),
    REAL_CONST(102797.69952145554/8.0),
    REAL_CONST(102821.57473105213/8.0),
    REAL_CONST(102845.45132668741/8.0),
    REAL_CONST(102869.32930820051/8.0),
    REAL_CONST(102893.20867543056/8.0),
    REAL_CONST(102917.08942821674/8.0),
    REAL_CONST(102940.97156639832/8.0),
    REAL_CONST(102964.85508981455/8.0),
    REAL_CONST(102988.73999830478/8.0),
    REAL_CONST(103012.6262917084/8.0),
    REAL_CONST(103036.51396986481/8.0),
    REAL_CONST(103060.40303261351/8.0),
    REAL_CONST(103084.293479794/8.0),
    REAL_CONST(103108.18531124585/8.0),
    REAL_CONST(103132.07852680866/8.0),
    REAL_CONST(103155.97312632212/8.0),
    REAL_CONST(103179.8691096259/8.0),
    REAL_CONST(103203.76647655977/8.0),
    REAL_CONST(103227.66522696352/8.0),
    REAL_CONST(103251.56536067701/8.0),
    REAL_CONST(103275.46687754011/8.0),
    REAL_CONST(103299.36977739276/8.0),
    REAL_CONST(103323.27406007495/8.0),
    REAL_CONST(103347.1797254267/8.0),
    REAL_CONST(103371.0867732881/8.0),
    REAL_CONST(103394.99520349925/8.0),
    REAL_CONST(103418.90501590034/8.0),
    REAL_CONST(103442.81621033157/8.0),
    REAL_CONST(103466.72878663319/8.0),
    REAL_CONST(103490.64274464553/8.0),
    REAL_CONST(103514.55808420894/8.0),
    REAL_CONST(103538.4748051638/8.0),
    REAL_CONST(103562.39290735057/8.0),
    REAL_CONST(103586.31239060973/8.0),
    REAL_CONST(103610.23325478184/8.0),
    REAL_CONST(103634.15549970744/8.0),
    REAL_CONST(103658.07912522719/8.0),
    REAL_CONST(103682.00413118176/8.0),
    REAL_CONST(103705.93051741188/8.0),
    REAL_CONST(103729.85828375829/8.0),
    REAL_CONST(103753.78743006183/8.0),
    REAL_CONST(103777.71795616332/8.0),
    REAL_CONST(103801.64986190372/8.0),
    REAL_CONST(103825.58314712394/8.0),
    REAL_CONST(103849.51781166498/8.0),
    REAL_CONST(103873.4538553679/8.0),
    REAL_CONST(103897.39127807376/8.0),
    REAL_CONST(103921.33007962372/8.0),
    REAL_CONST(103945.27025985894/8.0),
    REAL_CONST(103969.21181862066/8.0),
    REAL_CONST(103993.15475575015/8.0),
    REAL_CONST(104017.0990710887/8.0),
    REAL_CONST(104041.0447644777/8.0),
    REAL_CONST(104064.99183575854/8.0),
    REAL_CONST(104088.94028477269/8.0),
    REAL_CONST(104112.89011136163/8.0),
    REAL_CONST(104136.84131536692/8.0),
    REAL_CONST(104160.79389663014/8.0),
    REAL_CONST(104184.74785499295/8.0),
    REAL_CONST(104208.70319029699/8.0),
    REAL_CONST(104232.65990238401/8.0),
    REAL_CONST(104256.61799109577/8.0),
    REAL_CONST(104280.57745627411/8.0),
    REAL_CONST(104304.53829776087/8.0),
    REAL_CONST(104328.50051539797/8.0),
    REAL_CONST(104352.46410902737/8.0),
    REAL_CONST(104376.42907849104/8.0),
    REAL_CONST(104400.39542363105/8.0),
    REAL_CONST(104424.36314428948/8.0),
    REAL_CONST(104448.33224030846/8.0),
    REAL_CONST(104472.3027115302/8.0),
    REAL_CONST(104496.27455779689/8.0),
    REAL_CONST(104520.24777895081/8.0),
    REAL_CONST(104544.22237483428/8.0),
    REAL_CONST(104568.19834528965/8.0),
    REAL_CONST(104592.17569015936/8.0),
    REAL_CONST(104616.15440928582/8.0),
    REAL_CONST(104640.13450251156/8.0),
    REAL_CONST(104664.1159696791/8.0),
    REAL_CONST(104688.09881063103/8.0),
    REAL_CONST(104712.08302520998/8.0),
    REAL_CONST(104736.06861325864/8.0),
    REAL_CONST(104760.05557461972/8.0),
    REAL_CONST(104784.043909136/8.0),
    REAL_CONST(104808.03361665027/8.0),
    REAL_CONST(104832.0246970054/8.0),
    REAL_CONST(104856.01715004431/8.0),
    REAL_CONST(104880.01097560991/8.0),
    REAL_CONST(104904.00617354522/8.0),
    REAL_CONST(104928.00274369326/8.0),
    REAL_CONST(104952.00068589712/8.0),
    REAL_CONST(104975.99999999993/8.0),
    REAL_CONST(105000.00068584486/8.0),
    REAL_CONST(105024.00274327511/8.0),
    REAL_CONST(105048.00617213396/8.0),
    REAL_CONST(105072.0109722647/8.0),
    REAL_CONST(105096.0171435107/8.0),
    REAL_CONST(105120.02468571534/8.0),
    REAL_CONST(105144.03359872208/8.0),
    REAL_CONST(105168.04388237436/8.0),
    REAL_CONST(105192.05553651576/8.0),
    REAL_CONST(105216.06856098982/8.0),
    REAL_CONST(105240.08295564017/8.0),
    REAL_CONST(105264.09872031047/8.0),
    REAL_CONST(105288.11585484444/8.0),
    REAL_CONST(105312.13435908582/8.0),
    REAL_CONST(105336.1542328784/8.0),
    REAL_CONST(105360.17547606604/8.0),
    REAL_CONST(105384.19808849262/8.0),
    REAL_CONST(105408.22207000206/8.0),
    REAL_CONST(105432.24742043833/8.0),
    REAL_CONST(105456.27413964548/8.0),
    REAL_CONST(105480.30222746753/8.0),
    REAL_CONST(105504.33168374863/8.0),
    REAL_CONST(105528.36250833291/8.0),
    REAL_CONST(105552.39470106458/8.0),
    REAL_CONST(105576.42826178786/8.0),
    REAL_CONST(105600.46319034706/8.0),
    REAL_CONST(105624.49948658649/8.0),
    REAL_CONST(105648.53715035053/8.0),
    REAL_CONST(105672.5761814836/8.0),
    REAL_CONST(105696.61657983017/8.0),
    REAL_CONST(105720.65834523473/8.0),
    REAL_CONST(105744.70147754184/8.0),
    REAL_CONST(105768.7459765961/8.0),
    REAL_CONST(105792.79184224214/8.0),
    REAL_CONST(105816.83907432464/8.0),
    REAL_CONST(105840.88767268835/8.0),
    REAL_CONST(105864.93763717801/8.0),
    REAL_CONST(105888.98896763846/8.0),
    REAL_CONST(105913.04166391456/8.0),
    REAL_CONST(105937.09572585119/8.0),
    REAL_CONST(105961.15115329332/8.0),
    REAL_CONST(105985.20794608595/8.0),
    REAL_CONST(106009.26610407409/8.0),
    REAL_CONST(106033.32562710284/8.0),
    REAL_CONST(106057.38651501729/8.0),
    REAL_CONST(106081.44876766266/8.0),
    REAL_CONST(106105.51238488412/8.0),
    REAL_CONST(106129.57736652695/8.0),
    REAL_CONST(106153.64371243643/8.0),
    REAL_CONST(106177.71142245791/8.0),
    REAL_CONST(106201.78049643678/8.0),
    REAL_CONST(106225.85093421848/8.0),
    REAL_CONST(106249.92273564848/8.0),
    REAL_CONST(106273.99590057228/8.0),
    REAL_CONST(106298.07042883546/8.0),
    REAL_CONST(106322.14632028362/8.0),
    REAL_CONST(106346.22357476239/8.0),
    REAL_CONST(106370.30219211751/8.0),
    REAL_CONST(106394.38217219469/8.0),
    REAL_CONST(106418.46351483969/8.0),
    REAL_CONST(106442.54621989837/8.0),
    REAL_CONST(106466.63028721658/8.0),
    REAL_CONST(106490.71571664025/8.0),
    REAL_CONST(106514.80250801529/8.0),
    REAL_CONST(106538.89066118775/8.0),
    REAL_CONST(106562.98017600364/8.0),
    REAL_CONST(106587.07105230905/8.0),
    REAL_CONST(106611.16328995011/8.0),
    REAL_CONST(106635.25688877302/8.0),
    REAL_CONST(106659.35184862395/8.0),
    REAL_CONST(106683.44816934918/8.0),
    REAL_CONST(106707.54585079502/8.0),
    REAL_CONST(106731.64489280782/8.0),
    REAL_CONST(106755.74529523395/8.0),
    REAL_CONST(106779.84705791986/8.0),
    REAL_CONST(106803.95018071201/8.0),
    REAL_CONST(106828.05466345693/8.0),
    REAL_CONST(106852.16050600118/8.0),
    REAL_CONST(106876.26770819137/8.0),
    REAL_CONST(106900.37626987413/8.0),
    REAL_CONST(106924.48619089619/8.0),
    REAL_CONST(106948.59747110425/8.0),
    REAL_CONST(106972.71011034511/8.0),
    REAL_CONST(106996.82410846559/8.0),
    REAL_CONST(107020.93946531253/8.0),
    REAL_CONST(107045.05618073288/8.0),
    REAL_CONST(107069.17425457356/8.0),
    REAL_CONST(107093.29368668159/8.0),
    REAL_CONST(107117.41447690397/8.0),
    REAL_CONST(107141.53662508781/8.0),
    REAL_CONST(107165.66013108024/8.0),
    REAL_CONST(107189.7849947284/8.0),
    REAL_CONST(107213.91121587952/8.0),
    REAL_CONST(107238.03879438085/8.0),
    REAL_CONST(107262.16773007967/8.0),
    REAL_CONST(107286.29802282334/8.0),
    REAL_CONST(107310.42967245923/8.0),
    REAL_CONST(107334.56267883476/8.0),
    REAL_CONST(107358.69704179741/8.0),
    REAL_CONST(107382.83276119467/8.0),
    REAL_CONST(107406.96983687414/8.0),
    REAL_CONST(107431.10826868335/8.0),
    REAL_CONST(107455.24805646999/8.0),
    REAL_CONST(107479.38920008171/8.0),
    REAL_CONST(107503.53169936626/8.0),
    REAL_CONST(107527.67555417139/8.0),
    REAL_CONST(107551.82076434491/8.0),
    REAL_CONST(107575.96732973469/8.0),
    REAL_CONST(107600.11525018861/8.0),
    REAL_CONST(107624.26452555459/8.0),
    REAL_CONST(107648.41515568066/8.0),
    REAL_CONST(107672.56714041479/8.0),
    REAL_CONST(107696.72047960508/8.0),
    REAL_CONST(107720.87517309963/8.0),
    REAL_CONST(107745.03122074658/8.0),
    REAL_CONST(107769.18862239413/8.0),
    REAL_CONST(107793.34737789053/8.0),
    REAL_CONST(107817.50748708403/8.0),
    REAL_CONST(107841.66894982298/8.0),
    REAL_CONST(107865.83176595572/8.0),
    REAL_CONST(107889.99593533068/8.0),
    REAL_CONST(107914.16145779629/8.0),
    REAL_CONST(107938.32833320105/8.0),
    REAL_CONST(107962.49656139348/8.0),
    REAL_CONST(107986.66614222217/8.0),
    REAL_CONST(108010.83707553572/8.0),
    REAL_CONST(108035.00936118282/8.0),
    REAL_CONST(108059.18299901215/8.0),
    REAL_CONST(108083.35798887245/8.0),
    REAL_CONST(108107.53433061253/8.0),
    REAL_CONST(108131.71202408121/8.0),
    REAL_CONST(108155.89106912735/8.0),
    REAL_CONST(108180.07146559987/8.0),
    REAL_CONST(108204.25321334775/8.0),
    REAL_CONST(108228.43631221994/8.0),
    REAL_CONST(108252.62076206553/8.0),
    REAL_CONST(108276.80656273357/8.0),
    REAL_CONST(108300.99371407321/8.0),
    REAL_CONST(108325.18221593359/8.0),
    REAL_CONST(108349.37206816394/8.0),
    REAL_CONST(108373.56327061349/8.0),
    REAL_CONST(108397.75582313156/8.0),
    REAL_CONST(108421.94972556747/8.0),
    REAL_CONST(108446.1449777706/8.0),
    REAL_CONST(108470.34157959036/8.0),
    REAL_CONST(108494.53953087622/8.0),
    REAL_CONST(108518.73883147769/8.0),
    REAL_CONST(108542.93948124432/8.0),
    REAL_CONST(108567.14148002568/8.0),
    REAL_CONST(108591.34482767139/8.0),
    REAL_CONST(108615.54952403114/8.0),
    REAL_CONST(108639.75556895464/8.0),
    REAL_CONST(108663.96296229165/8.0),
    REAL_CONST(108688.17170389196/8.0),
    REAL_CONST(108712.38179360541/8.0),
    REAL_CONST(108736.59323128188/8.0),
    REAL_CONST(108760.80601677128/8.0),
    REAL_CONST(108785.02014992358/8.0),
    REAL_CONST(108809.23563058881/8.0),
    REAL_CONST(108833.45245861699/8.0),
    REAL_CONST(108857.67063385822/8.0),
    REAL_CONST(108881.89015616261/8.0),
    REAL_CONST(108906.11102538036/8.0),
    REAL_CONST(108930.33324136167/8.0),
    REAL_CONST(108954.55680395682/8.0),
    REAL_CONST(108978.78171301607/8.0),
    REAL_CONST(109003.00796838976/8.0),
    REAL_CONST(109027.23556992831/8.0),
    REAL_CONST(109051.46451748211/8.0),
    REAL_CONST(109075.69481090162/8.0),
    REAL_CONST(109099.92645003737/8.0),
    REAL_CONST(109124.15943473989/8.0),
    REAL_CONST(109148.39376485976/8.0),
    REAL_CONST(109172.62944024763/8.0),
    REAL_CONST(109196.86646075416/8.0),
    REAL_CONST(109221.10482623006/8.0),
    REAL_CONST(109245.34453652608/8.0),
    REAL_CONST(109269.58559149304/8.0),
    REAL_CONST(109293.82799098175/8.0),
    REAL_CONST(109318.07173484311/8.0),
    REAL_CONST(109342.31682292801/8.0),
    REAL_CONST(109366.56325508743/8.0),
    REAL_CONST(109390.81103117237/8.0),
    REAL_CONST(109415.06015103387/8.0),
    REAL_CONST(109439.31061452301/8.0),
    REAL_CONST(109463.56242149093/8.0),
    REAL_CONST(109487.8155717888/8.0),
    REAL_CONST(109512.07006526781/8.0),
    REAL_CONST(109536.3259017792/8.0),
    REAL_CONST(109560.58308117429/8.0),
    REAL_CONST(109584.8416033044/8.0),
    REAL_CONST(109609.1014680209/8.0),
    REAL_CONST(109633.36267517522/8.0),
    REAL_CONST(109657.62522461878/8.0),
    REAL_CONST(109681.88911620311/8.0),
    REAL_CONST(109706.15434977971/8.0),
    REAL_CONST(109730.4209252002/8.0),
    REAL_CONST(109754.68884231619/8.0),
    REAL_CONST(109778.95810097932/8.0),
    REAL_CONST(109803.22870104131/8.0),
    REAL_CONST(109827.50064235389/8.0),
    REAL_CONST(109851.77392476884/8.0),
    REAL_CONST(109876.04854813802/8.0),
    REAL_CONST(109900.32451231324/8.0),
    REAL_CONST(109924.60181714644/8.0),
    REAL_CONST(109948.88046248957/8.0),
    REAL_CONST(109973.1604481946/8.0),
    REAL_CONST(109997.44177411357/8.0),
    REAL_CONST(110021.72444009855/8.0),
    REAL_CONST(110046.00844600165/8.0),
    REAL_CONST(110070.29379167501/8.0),
    REAL_CONST(110094.58047697082/8.0),
    REAL_CONST(110118.86850174134/8.0),
    REAL_CONST(110143.15786583882/8.0),
    REAL_CONST(110167.44856911557/8.0),
    REAL_CONST(110191.74061142397/8.0),
    REAL_CONST(110216.03399261639/8.0),
    REAL_CONST(110240.32871254528/8.0),
    REAL_CONST(110264.62477106311/8.0),
    REAL_CONST(110288.9221680224/8.0),
    REAL_CONST(110313.22090327571/8.0),
    REAL_CONST(110337.52097667565/8.0),
    REAL_CONST(110361.82238807483/8.0),
    REAL_CONST(110386.12513732594/8.0),
    REAL_CONST(110410.42922428172/8.0),
    REAL_CONST(110434.73464879491/8.0),
    REAL_CONST(110459.04141071832/8.0),
    REAL_CONST(110483.34950990479/8.0),
    REAL_CONST(110507.6589462072/8.0),
    REAL_CONST(110531.96971947847/8.0),
    REAL_CONST(110556.28182957157/8.0),
    REAL_CONST(110580.5952763395/8.0),
    REAL_CONST(110604.91005963532/8.0),
    REAL_CONST(110629.22617931209/8.0),
    REAL_CONST(110653.54363522294/8.0),
    REAL_CONST(110677.86242722106/8.0),
    REAL_CONST(110702.18255515963/8.0),
    REAL_CONST(110726.50401889188/8.0),
    REAL_CONST(110750.82681827113/8.0),
    REAL_CONST(110775.1509531507/8.0),
    REAL_CONST(110799.47642338395/8.0),
    REAL_CONST(110823.80322882428/8.0),
    REAL_CONST(110848.13136932514/8.0),
    REAL_CONST(110872.46084474004/8.0),
    REAL_CONST(110896.79165492248/8.0),
    REAL_CONST(110921.12379972603/8.0),
    REAL_CONST(110945.4572790043/8.0),
    REAL_CONST(110969.79209261097/8.0),
    REAL_CONST(110994.12824039967/8.0),
    REAL_CONST(111018.46572222417/8.0),
    REAL_CONST(111042.80453793822/8.0),
    REAL_CONST(111067.14468739564/8.0),
    REAL_CONST(111091.48617045028/8.0),
    REAL_CONST(111115.82898695602/8.0),
    REAL_CONST(111140.1731367668/8.0),
    REAL_CONST(111164.51861973655/8.0),
    REAL_CONST(111188.86543571933/8.0),
    REAL_CONST(111213.21358456917/8.0),
    REAL_CONST(111237.56306614014/8.0),
    REAL_CONST(111261.91388028639/8.0),
    REAL_CONST(111286.26602686207/8.0),
    REAL_CONST(111310.61950572141/8.0),
    REAL_CONST(111334.97431671864/8.0),
    REAL_CONST(111359.33045970804/8.0),
    REAL_CONST(111383.68793454397/8.0),
    REAL_CONST(111408.04674108078/8.0),
    REAL_CONST(111432.40687917286/8.0),
    REAL_CONST(111456.76834867468/8.0),
    REAL_CONST(111481.13114944073/8.0),
    REAL_CONST(111505.49528132551/8.0),
    REAL_CONST(111529.86074418361/8.0),
    REAL_CONST(111554.22753786964/8.0),
    REAL_CONST(111578.59566223821/8.0),
    REAL_CONST(111602.96511714405/8.0),
    REAL_CONST(111627.33590244185/8.0),
    REAL_CONST(111651.7080179864/8.0),
    REAL_CONST(111676.08146363248/8.0),
    REAL_CONST(111700.45623923496/8.0),
    REAL_CONST(111724.8323446487/8.0),
    REAL_CONST(111749.20977972864/8.0),
    REAL_CONST(111773.58854432974/8.0),
    REAL_CONST(111797.96863830699/8.0),
    REAL_CONST(111822.35006151545/8.0),
    REAL_CONST(111846.73281381019/8.0),
    REAL_CONST(111871.11689504632/8.0),
    REAL_CONST(111895.50230507903/8.0),
    REAL_CONST(111919.8890437635/8.0),
    REAL_CONST(111944.27711095495/8.0),
    REAL_CONST(111968.6665065087/8.0),
    REAL_CONST(111993.05723028004/8.0),
    REAL_CONST(112017.44928212435/8.0),
    REAL_CONST(112041.842661897/8.0),
    REAL_CONST(112066.23736945343/8.0),
    REAL_CONST(112090.63340464912/8.0),
    REAL_CONST(112115.03076733962/8.0),
    REAL_CONST(112139.42945738042/8.0),
    REAL_CONST(112163.82947462716/8.0),
    REAL_CONST(112188.23081893545/8.0),
    REAL_CONST(112212.63349016097/8.0),
    REAL_CONST(112237.03748815943/8.0),
    REAL_CONST(112261.44281278658/8.0),
    REAL_CONST(112285.84946389822/8.0),
    REAL_CONST(112310.25744135017/8.0),
    REAL_CONST(112334.66674499828/8.0),
    REAL_CONST(112359.07737469849/8.0),
    REAL_CONST(112383.48933030672/8.0),
    REAL_CONST(112407.90261167898/8.0),
    REAL_CONST(112432.31721867126/8.0),
    REAL_CONST(112456.73315113965/8.0),
    REAL_CONST(112481.15040894024/8.0),
    REAL_CONST(112505.56899192919/8.0),
    REAL_CONST(112529.98889996267/8.0),
    REAL_CONST(112554.41013289688/8.0),
    REAL_CONST(112578.8326905881/8.0),
    REAL_CONST(112603.25657289263/8.0),
    REAL_CONST(112627.68177966679/8.0),
    REAL_CONST(112652.10831076698/8.0),
    REAL_CONST(112676.53616604958/8.0),
    REAL_CONST(112700.96534537108/8.0),
    REAL_CONST(112725.39584858794/8.0),
    REAL_CONST(112749.82767555672/8.0),
    REAL_CONST(112774.26082613398/8.0),
    REAL_CONST(112798.6953001763/8.0),
    REAL_CONST(112823.13109754038/8.0),
    REAL_CONST(112847.56821808286/8.0),
    REAL_CONST(112872.00666166049/8.0),
    REAL_CONST(112896.44642813003/8.0),
    REAL_CONST(112920.88751734827/8.0),
    REAL_CONST(112945.32992917208/8.0),
    REAL_CONST(112969.77366345831/8.0),
    REAL_CONST(112994.21872006389/8.0),
    REAL_CONST(113018.66509884578/8.0),
    REAL_CONST(113043.11279966099/8.0),
    REAL_CONST(113067.56182236652/8.0),
    REAL_CONST(113092.01216681948/8.0),
    REAL_CONST(113116.46383287695/8.0),
    REAL_CONST(113140.9168203961/8.0),
    REAL_CONST(113165.37112923413/8.0),
    REAL_CONST(113189.82675924824/8.0),
    REAL_CONST(113214.28371029573/8.0),
    REAL_CONST(113238.74198223387/8.0),
    REAL_CONST(113263.20157492002/8.0),
    REAL_CONST(113287.66248821157/8.0),
    REAL_CONST(113312.12472196593/8.0),
    REAL_CONST(113336.58827604055/8.0),
    REAL_CONST(113361.05315029295/8.0),
    REAL_CONST(113385.51934458067/8.0),
    REAL_CONST(113409.98685876124/8.0),
    REAL_CONST(113434.45569269233/8.0),
    REAL_CONST(113458.92584623155/8.0),
    REAL_CONST(113483.39731923661/8.0),
    REAL_CONST(113507.87011156522/8.0),
    REAL_CONST(113532.34422307517/8.0),
    REAL_CONST(113556.81965362425/8.0),
    REAL_CONST(113581.2964030703/8.0),
    REAL_CONST(113605.77447127122/8.0),
    REAL_CONST(113630.25385808491/8.0),
    REAL_CONST(113654.73456336933/8.0),
    REAL_CONST(113679.2165869825/8.0),
    REAL_CONST(113703.69992878241/8.0),
    REAL_CONST(113728.18458862718/8.0),
    REAL_CONST(113752.67056637487/8.0),
    REAL_CONST(113777.15786188368/8.0),
    REAL_CONST(113801.64647501177/8.0),
    REAL_CONST(113826.13640561736/8.0),
    REAL_CONST(113850.62765355874/8.0),
    REAL_CONST(113875.12021869418/8.0),
    REAL_CONST(113899.61410088204/8.0),
    REAL_CONST(113924.1092999807/8.0),
    REAL_CONST(113948.60581584855/8.0),
    REAL_CONST(113973.10364834407/8.0),
    REAL_CONST(113997.60279732574/8.0),
    REAL_CONST(114022.1032626521/8.0),
    REAL_CONST(114046.60504418171/8.0),
    REAL_CONST(114071.10814177318/8.0),
    REAL_CONST(114095.61255528514/8.0),
    REAL_CONST(114120.11828457628/8.0),
    REAL_CONST(114144.62532950533/8.0),
    REAL_CONST(114169.13368993104/8.0),
    REAL_CONST(114193.6433657122/8.0),
    REAL_CONST(114218.15435670764/8.0),
    REAL_CONST(114242.66666277625/8.0),
    REAL_CONST(114267.18028377694/8.0),
    REAL_CONST(114291.69521956862/8.0),
    REAL_CONST(114316.21147001031/8.0),
    REAL_CONST(114340.72903496103/8.0),
    REAL_CONST(114365.24791427983/8.0),
    REAL_CONST(114389.7681078258/8.0),
    REAL_CONST(114414.2896154581/8.0),
    REAL_CONST(114438.81243703589/8.0),
    REAL_CONST(114463.33657241837/8.0),
    REAL_CONST(114487.8620214648/8.0),
    REAL_CONST(114512.38878403447/8.0),
    REAL_CONST(114536.91685998671/8.0),
    REAL_CONST(114561.44624918087/8.0),
    REAL_CONST(114585.97695147636/8.0),
    REAL_CONST(114610.5089667326/8.0),
    REAL_CONST(114635.04229480909/8.0),
    REAL_CONST(114659.57693556532/8.0),
    REAL_CONST(114684.11288886084/8.0),
    REAL_CONST(114708.65015455526/8.0),
    REAL_CONST(114733.18873250818/8.0),
    REAL_CONST(114757.72862257928/8.0),
    REAL_CONST(114782.26982462825/8.0),
    REAL_CONST(114806.81233851484/8.0),
    REAL_CONST(114831.35616409882/8.0),
    REAL_CONST(114855.90130123998/8.0),
    REAL_CONST(114880.44774979822/8.0),
    REAL_CONST(114904.99550963337/8.0),
    REAL_CONST(114929.5445806054/8.0),
    REAL_CONST(114954.09496257425/8.0),
    REAL_CONST(114978.64665539992/8.0),
    REAL_CONST(115003.19965894247/8.0),
    REAL_CONST(115027.75397306195/8.0),
    REAL_CONST(115052.30959761847/8.0),
    REAL_CONST(115076.86653247218/8.0),
    REAL_CONST(115101.42477748329/8.0),
    REAL_CONST(115125.984332512/8.0),
    REAL_CONST(115150.54519741859/8.0),
    REAL_CONST(115175.10737206334/8.0),
    REAL_CONST(115199.67085630659/8.0),
    REAL_CONST(115224.23565000873/8.0),
    REAL_CONST(115248.80175303014/8.0),
    REAL_CONST(115273.3691652313/8.0),
    REAL_CONST(115297.93788647266/8.0),
    REAL_CONST(115322.50791661476/8.0),
    REAL_CONST(115347.07925551817/8.0),
    REAL_CONST(115371.65190304347/8.0),
    REAL_CONST(115396.22585905129/8.0),
    REAL_CONST(115420.80112340231/8.0),
    REAL_CONST(115445.37769595724/8.0),
    REAL_CONST(115469.95557657682/8.0),
    REAL_CONST(115494.53476512182/8.0),
    REAL_CONST(115519.11526145306/8.0),
    REAL_CONST(115543.69706543141/8.0),
    REAL_CONST(115568.28017691776/8.0),
    REAL_CONST(115592.86459577303/8.0),
    REAL_CONST(115617.4503218582/8.0),
    REAL_CONST(115642.03735503425/8.0),
    REAL_CONST(115666.62569516223/8.0),
    REAL_CONST(115691.21534210323/8.0),
    REAL_CONST(115715.80629571836/8.0),
    REAL_CONST(115740.39855586876/8.0),
    REAL_CONST(115764.99212241563/8.0),
    REAL_CONST(115789.58699522018/8.0),
    REAL_CONST(115814.18317414368/8.0),
    REAL_CONST(115838.78065904744/8.0),
    REAL_CONST(115863.37944979276/8.0),
    REAL_CONST(115887.97954624105/8.0),
    REAL_CONST(115912.5809482537/8.0),
    REAL_CONST(115937.18365569216/8.0),
    REAL_CONST(115961.78766841792/8.0),
    REAL_CONST(115986.39298629249/8.0),
    REAL_CONST(116010.99960917742/8.0),
    REAL_CONST(116035.60753693432/8.0),
    REAL_CONST(116060.21676942479/8.0),
    REAL_CONST(116084.82730651053/8.0),
    REAL_CONST(116109.43914805322/8.0),
    REAL_CONST(116134.0522939146/8.0),
    REAL_CONST(116158.66674395646/8.0),
    REAL_CONST(116183.2824980406/8.0),
    REAL_CONST(116207.89955602887/8.0),
    REAL_CONST(116232.51791778316/8.0),
    REAL_CONST(116257.13758316539/8.0),
    REAL_CONST(116281.75855203751/8.0),
    REAL_CONST(116306.38082426153/8.0),
    REAL_CONST(116331.00439969949/8.0),
    REAL_CONST(116355.62927821343/8.0),
    REAL_CONST(116380.25545966547/8.0),
    REAL_CONST(116404.88294391775/8.0),
    REAL_CONST(116429.51173083246/8.0),
    REAL_CONST(116454.14182027178/8.0),
    REAL_CONST(116478.77321209799/8.0),
    REAL_CONST(116503.40590617337/8.0),
    REAL_CONST(116528.03990236025/8.0),
    REAL_CONST(116552.67520052097/8.0),
    REAL_CONST(116577.31180051794/8.0),
    REAL_CONST(116601.94970221359/8.0),
    REAL_CONST(116626.5889054704/8.0),
    REAL_CONST(116651.22941015086/8.0),
    REAL_CONST(116675.87121611751/8.0),
    REAL_CONST(116700.51432323294/8.0),
    REAL_CONST(116725.15873135976/8.0),
    REAL_CONST(116749.8044403606/8.0),
    REAL_CONST(116774.45145009817/8.0),
    REAL_CONST(116799.0997604352/8.0),
    REAL_CONST(116823.74937123443/8.0),
    REAL_CONST(116848.40028235866/8.0),
    REAL_CONST(116873.05249367072/8.0),
    REAL_CONST(116897.70600503348/8.0),
    REAL_CONST(116922.36081630984/8.0),
    REAL_CONST(116947.01692736275/8.0),
    REAL_CONST(116971.67433805518/8.0),
    REAL_CONST(116996.33304825013/8.0),
    REAL_CONST(117020.99305781067/8.0),
    REAL_CONST(117045.65436659988/8.0),
    REAL_CONST(117070.31697448085/8.0),
    REAL_CONST(117094.98088131678/8.0),
    REAL_CONST(117119.64608697082/8.0),
    REAL_CONST(117144.31259130624/8.0),
    REAL_CONST(117168.98039418629/8.0),
    REAL_CONST(117193.64949547425/8.0),
    REAL_CONST(117218.31989503348/8.0),
    REAL_CONST(117242.99159272734/8.0),
    REAL_CONST(117267.66458841923/8.0),
    REAL_CONST(117292.33888197262/8.0),
    REAL_CONST(117317.01447325097/8.0),
    REAL_CONST(117341.6913621178/8.0),
    REAL_CONST(117366.36954843666/8.0),
    REAL_CONST(117391.04903207115/8.0),
    REAL_CONST(117415.72981288488/8.0),
    REAL_CONST(117440.41189074152/8.0),
    REAL_CONST(117465.09526550474/8.0),
    REAL_CONST(117489.77993703831/8.0),
    REAL_CONST(117514.46590520597/8.0),
    REAL_CONST(117539.15316987153/8.0),
    REAL_CONST(117563.84173089883/8.0),
    REAL_CONST(117588.53158815173/8.0),
    REAL_CONST(117613.22274149416/8.0),
    REAL_CONST(117637.91519079007/8.0),
    REAL_CONST(117662.60893590341/8.0),
    REAL_CONST(117687.30397669821/8.0),
    REAL_CONST(117712.00031303853/8.0),
    REAL_CONST(117736.69794478847/8.0),
    REAL_CONST(117761.39687181212/8.0),
    REAL_CONST(117786.09709397367/8.0),
    REAL_CONST(117810.7986111373/8.0),
    REAL_CONST(117835.50142316725/8.0),
    REAL_CONST(117860.20552992777/8.0),
    REAL_CONST(117884.91093128319/8.0),
    REAL_CONST(117909.6176270978/8.0),
    REAL_CONST(117934.32561723603/8.0),
    REAL_CONST(117959.03490156225/8.0),
    REAL_CONST(117983.74547994092/8.0),
    REAL_CONST(118008.45735223651/8.0),
    REAL_CONST(118033.17051831353/8.0),
    REAL_CONST(118057.88497803656/8.0),
    REAL_CONST(118082.60073127014/8.0),
    REAL_CONST(118107.31777787894/8.0),
    REAL_CONST(118132.03611772758/8.0),
    REAL_CONST(118156.75575068076/8.0),
    REAL_CONST(118181.47667660323/8.0),
    REAL_CONST(118206.19889535972/8.0),
    REAL_CONST(118230.92240681504/8.0),
    REAL_CONST(118255.64721083404/8.0),
    REAL_CONST(118280.37330728157/8.0),
    REAL_CONST(118305.10069602253/8.0),
    REAL_CONST(118329.82937692189/8.0),
    REAL_CONST(118354.55934984458/8.0),
    REAL_CONST(118379.29061465565/8.0),
    REAL_CONST(118404.02317122012/8.0),
    REAL_CONST(118428.75701940308/8.0),
    REAL_CONST(118453.49215906965/8.0),
    REAL_CONST(118478.22859008498/8.0),
    REAL_CONST(118502.96631231424/8.0),
    REAL_CONST(118527.70532562268/8.0),
    REAL_CONST(118552.44562987552/8.0),
    REAL_CONST(118577.18722493808/8.0),
    REAL_CONST(118601.93011067568/8.0),
    REAL_CONST(118626.67428695368/8.0),
    REAL_CONST(118651.41975363747/8.0),
    REAL_CONST(118676.16651059251/8.0),
    REAL_CONST(118700.91455768423/8.0),
    REAL_CONST(118725.66389477813/8.0),
    REAL_CONST(118750.41452173979/8.0),
    REAL_CONST(118775.16643843475/8.0),
    REAL_CONST(118799.91964472862/8.0),
    REAL_CONST(118824.67414048707/8.0),
    REAL_CONST(118849.42992557574/8.0),
    REAL_CONST(118874.18699986035/8.0),
    REAL_CONST(118898.94536320666/8.0),
    REAL_CONST(118923.70501548045/8.0),
    REAL_CONST(118948.46595654752/8.0),
    REAL_CONST(118973.22818627374/8.0),
    REAL_CONST(118997.99170452499/8.0),
    REAL_CONST(119022.7565111672/8.0),
    REAL_CONST(119047.52260606633/8.0),
    REAL_CONST(119072.28998908834/8.0),
    REAL_CONST(119097.0586600993/8.0),
    REAL_CONST(119121.82861896523/8.0),
    REAL_CONST(119146.59986555226/8.0),
    REAL_CONST(119171.3723997265/8.0),
    REAL_CONST(119196.14622135412/8.0),
    REAL_CONST(119220.92133030134/8.0),
    REAL_CONST(119245.69772643436/8.0),
    REAL_CONST(119270.47540961947/8.0),
    REAL_CONST(119295.25437972297/8.0),
    REAL_CONST(119320.03463661121/8.0),
    REAL_CONST(119344.81618015055/8.0),
    REAL_CONST(119369.5990102074/8.0),
    REAL_CONST(119394.38312664822/8.0),
    REAL_CONST(119419.16852933947/8.0),
    REAL_CONST(119443.95521814766/8.0),
    REAL_CONST(119468.74319293935/8.0),
    REAL_CONST(119493.53245358112/8.0),
    REAL_CONST(119518.32299993958/8.0),
    REAL_CONST(119543.11483188139/8.0),
    REAL_CONST(119567.90794927324/8.0),
    REAL_CONST(119592.70235198183/8.0),
    REAL_CONST(119617.49803987393/8.0),
    REAL_CONST(119642.29501281632/8.0),
    REAL_CONST(119667.09327067583/8.0),
    REAL_CONST(119691.89281331931/8.0),
    REAL_CONST(119716.69364061367/8.0),
    REAL_CONST(119741.49575242582/8.0),
    REAL_CONST(119766.29914862274/8.0),
    REAL_CONST(119791.10382907141/8.0),
    REAL_CONST(119815.90979363887/8.0),
    REAL_CONST(119840.71704219218/8.0),
    REAL_CONST(119865.52557459843/8.0),
    REAL_CONST(119890.33539072477/8.0),
    REAL_CONST(119915.14649043836/8.0),
    REAL_CONST(119939.95887360642/8.0),
    REAL_CONST(119964.77254009615/8.0),
    REAL_CONST(119989.58748977486/8.0),
    REAL_CONST(120014.40372250983/8.0),
    REAL_CONST(120039.22123816841/8.0),
    REAL_CONST(120064.04003661797/8.0),
    REAL_CONST(120088.86011772591/8.0),
    REAL_CONST(120113.6814813597/8.0),
    REAL_CONST(120138.5041273868/8.0),
    REAL_CONST(120163.3280556747/8.0),
    REAL_CONST(120188.15326609099/8.0),
    REAL_CONST(120212.97975850321/8.0),
    REAL_CONST(120237.807532779/8.0),
    REAL_CONST(120262.63658878599/8.0),
    REAL_CONST(120287.46692639188/8.0),
    REAL_CONST(120312.29854546436/8.0),
    REAL_CONST(120337.13144587121/8.0),
    REAL_CONST(120361.9656274802/8.0),
    REAL_CONST(120386.80109015915/8.0),
    REAL_CONST(120411.63783377589/8.0),
    REAL_CONST(120436.47585819835/8.0),
    REAL_CONST(120461.31516329442/8.0),
    REAL_CONST(120486.15574893207/8.0),
    REAL_CONST(120510.99761497928/8.0),
    REAL_CONST(120535.84076130406/8.0),
    REAL_CONST(120560.68518777451/8.0),
    REAL_CONST(120585.53089425867/8.0),
    REAL_CONST(120610.3778806247/8.0),
    REAL_CONST(120635.22614674074/8.0),
    REAL_CONST(120660.07569247499/8.0),
    REAL_CONST(120684.92651769568/8.0),
    REAL_CONST(120709.77862227106/8.0),
    REAL_CONST(120734.63200606944/8.0),
    REAL_CONST(120759.48666895913/8.0),
    REAL_CONST(120784.3426108085/8.0),
    REAL_CONST(120809.19983148595/8.0),
    REAL_CONST(120834.05833085992/8.0),
    REAL_CONST(120858.91810879884/8.0),
    REAL_CONST(120883.77916517125/8.0),
    REAL_CONST(120908.64149984565/8.0),
    REAL_CONST(120933.5051126906/8.0),
    REAL_CONST(120958.37000357473/8.0),
    REAL_CONST(120983.23617236665/8.0),
    REAL_CONST(121008.10361893504/8.0),
    REAL_CONST(121032.97234314861/8.0),
    REAL_CONST(121057.84234487606/8.0),
    REAL_CONST(121082.71362398617/8.0),
    REAL_CONST(121107.58618034775/8.0),
    REAL_CONST(121132.46001382964/8.0),
    REAL_CONST(121157.33512430069/8.0),
    REAL_CONST(121182.21151162982/8.0),
    REAL_CONST(121207.08917568595/8.0),
    REAL_CONST(121231.96811633807/8.0),
    REAL_CONST(121256.84833345517/8.0),
    REAL_CONST(121281.72982690629/8.0),
    REAL_CONST(121306.61259656049/8.0),
    REAL_CONST(121331.49664228689/8.0),
    REAL_CONST(121356.38196395461/8.0),
    REAL_CONST(121381.26856143285/8.0),
    REAL_CONST(121406.15643459078/8.0),
    REAL_CONST(121431.04558329767/8.0),
    REAL_CONST(121455.93600742276/8.0),
    REAL_CONST(121480.82770683538/8.0),
    REAL_CONST(121505.72068140487/8.0),
    REAL_CONST(121530.61493100057/8.0),
    REAL_CONST(121555.51045549192/8.0),
    REAL_CONST(121580.40725474835/8.0),
    REAL_CONST(121605.30532863933/8.0),
    REAL_CONST(121630.20467703436/8.0),
    REAL_CONST(121655.10529980299/8.0),
    REAL_CONST(121680.00719681478/8.0),
    REAL_CONST(121704.91036793934/8.0),
    REAL_CONST(121729.81481304632/8.0),
    REAL_CONST(121754.72053200539/8.0),
    REAL_CONST(121779.62752468624/8.0),
    REAL_CONST(121804.53579095862/8.0),
    REAL_CONST(121829.44533069231/8.0),
    REAL_CONST(121854.3561437571/8.0),
    REAL_CONST(121879.26823002285/8.0),
    REAL_CONST(121904.1815893594/8.0),
    REAL_CONST(121929.09622163669/8.0),
    REAL_CONST(121954.01212672464/8.0),
    REAL_CONST(121978.92930449323/8.0),
    REAL_CONST(122003.84775481246/8.0),
    REAL_CONST(122028.76747755238/8.0),
    REAL_CONST(122053.68847258303/8.0),
    REAL_CONST(122078.61073977455/8.0),
    REAL_CONST(122103.53427899707/8.0),
    REAL_CONST(122128.45909012076/8.0),
    REAL_CONST(122153.38517301581/8.0),
    REAL_CONST(122178.31252755247/8.0),
    REAL_CONST(122203.24115360099/8.0),
    REAL_CONST(122228.17105103172/8.0),
    REAL_CONST(122253.10221971494/8.0),
    REAL_CONST(122278.03465952107/8.0),
    REAL_CONST(122302.96837032049/8.0),
    REAL_CONST(122327.90335198362/8.0),
    REAL_CONST(122352.83960438096/8.0),
    REAL_CONST(122377.777127383/8.0),
    REAL_CONST(122402.71592086025/8.0),
    REAL_CONST(122427.65598468333/8.0),
    REAL_CONST(122452.59731872278/8.0),
    REAL_CONST(122477.53992284928/8.0),
    REAL_CONST(122502.48379693348/8.0),
    REAL_CONST(122527.42894084606/8.0),
    REAL_CONST(122552.37535445779/8.0),
    REAL_CONST(122577.32303763942/8.0),
    REAL_CONST(122602.27199026172/8.0),
    REAL_CONST(122627.22221219557/8.0),
    REAL_CONST(122652.17370331181/8.0),
    REAL_CONST(122677.12646348133/8.0),
    REAL_CONST(122702.08049257506/8.0),
    REAL_CONST(122727.03579046397/8.0),
    REAL_CONST(122751.99235701906/8.0),
    REAL_CONST(122776.95019211136/8.0),
    REAL_CONST(122801.9092956119/8.0),
    REAL_CONST(122826.8696673918/8.0),
    REAL_CONST(122851.83130732219/8.0),
    REAL_CONST(122876.79421527422/8.0),
    REAL_CONST(122901.75839111909/8.0),
    REAL_CONST(122926.72383472799/8.0),
    REAL_CONST(122951.69054597223/8.0),
    REAL_CONST(122976.65852472307/8.0),
    REAL_CONST(123001.62777085182/8.0),
    REAL_CONST(123026.59828422987/8.0),
    REAL_CONST(123051.57006472857/8.0),
    REAL_CONST(123076.54311221937/8.0),
    REAL_CONST(123101.5174265737/8.0),
    REAL_CONST(123126.49300766307/8.0),
    REAL_CONST(123151.46985535898/8.0),
    REAL_CONST(123176.44796953299/8.0),
    REAL_CONST(123201.42735005668/8.0),
    REAL_CONST(123226.40799680166/8.0),
    REAL_CONST(123251.38990963959/8.0),
    REAL_CONST(123276.37308844214/8.0),
    REAL_CONST(123301.35753308103/8.0),
    REAL_CONST(123326.343243428/8.0),
    REAL_CONST(123351.33021935483/8.0),
    REAL_CONST(123376.31846073334/8.0),
    REAL_CONST(123401.30796743535/8.0),
    REAL_CONST(123426.29873933276/8.0),
    REAL_CONST(123451.29077629748/8.0),
    REAL_CONST(123476.28407820144/8.0),
    REAL_CONST(123501.2786449166/8.0),
    REAL_CONST(123526.27447631498/8.0),
    REAL_CONST(123551.27157226863/8.0),
    REAL_CONST(123576.26993264959/8.0),
    REAL_CONST(123601.26955732999/8.0),
    REAL_CONST(123626.27044618195/8.0),
    REAL_CONST(123651.27259907764/8.0),
    REAL_CONST(123676.27601588926/8.0),
    REAL_CONST(123701.28069648903/8.0),
    REAL_CONST(123726.28664074924/8.0),
    REAL_CONST(123751.29384854218/8.0),
    REAL_CONST(123776.30231974016/8.0),
    REAL_CONST(123801.31205421555/8.0),
    REAL_CONST(123826.32305184075/8.0),
    REAL_CONST(123851.33531248817/8.0),
    REAL_CONST(123876.34883603029/8.0),
    REAL_CONST(123901.36362233957/8.0),
    REAL_CONST(123926.37967128855/8.0),
    REAL_CONST(123951.39698274979/8.0),
    REAL_CONST(123976.41555659588/8.0),
    REAL_CONST(124001.43539269941/8.0),
    REAL_CONST(124026.45649093305/8.0),
    REAL_CONST(124051.47885116948/8.0),
    REAL_CONST(124076.50247328142/8.0),
    REAL_CONST(124101.5273571416/8.0),
    REAL_CONST(124126.55350262282/8.0),
    REAL_CONST(124151.58090959788/8.0),
    REAL_CONST(124176.60957793961/8.0),
    REAL_CONST(124201.63950752091/8.0),
    REAL_CONST(124226.67069821467/8.0),
    REAL_CONST(124251.70314989384/8.0),
    REAL_CONST(124276.73686243138/8.0),
    REAL_CONST(124301.7718357003/8.0),
    REAL_CONST(124326.80806957364/8.0),
    REAL_CONST(124351.84556392446/8.0),
    REAL_CONST(124376.88431862585/8.0),
    REAL_CONST(124401.92433355095/8.0),
    REAL_CONST(124426.96560857294/8.0),
    REAL_CONST(124452.00814356498/8.0),
    REAL_CONST(124477.05193840031/8.0),
    REAL_CONST(124502.0969929522/8.0),
    REAL_CONST(124527.14330709392/8.0),
    REAL_CONST(124552.19088069882/8.0),
    REAL_CONST(124577.23971364023/8.0),
    REAL_CONST(124602.28980579154/8.0),
    REAL_CONST(124627.34115702618/8.0),
    REAL_CONST(124652.3937672176/8.0),
    REAL_CONST(124677.44763623926/8.0),
    REAL_CONST(124702.50276396469/8.0),
    REAL_CONST(124727.55915026742/8.0),
    REAL_CONST(124752.61679502104/8.0),
    REAL_CONST(124777.67569809916/8.0),
    REAL_CONST(124802.73585937542/8.0),
    REAL_CONST(124827.79727872348/8.0),
    REAL_CONST(124852.85995601704/8.0),
    REAL_CONST(124877.92389112986/8.0),
    REAL_CONST(124902.98908393568/8.0),
    REAL_CONST(124928.05553430831/8.0),
    REAL_CONST(124953.1232421216/8.0),
    REAL_CONST(124978.19220724938/8.0),
    REAL_CONST(125003.26242956554/8.0),
    REAL_CONST(125028.33390894404/8.0),
    REAL_CONST(125053.40664525882/8.0),
    REAL_CONST(125078.48063838384/8.0),
    REAL_CONST(125103.55588819318/8.0),
    REAL_CONST(125128.63239456083/8.0),
    REAL_CONST(125153.71015736091/8.0),
    REAL_CONST(125178.78917646752/8.0),
    REAL_CONST(125203.86945175481/8.0),
    REAL_CONST(125228.95098309696/8.0),
    REAL_CONST(125254.03377036817/8.0),
    REAL_CONST(125279.1178134427/8.0),
    REAL_CONST(125304.20311219479/8.0),
    REAL_CONST(125329.28966649878/8.0),
    REAL_CONST(125354.37747622898/8.0),
    REAL_CONST(125379.46654125977/8.0),
    REAL_CONST(125404.55686146552/8.0),
    REAL_CONST(125429.6484367207/8.0),
    REAL_CONST(125454.74126689974/8.0),
    REAL_CONST(125479.83535187715/8.0),
    REAL_CONST(125504.93069152744/8.0),
    REAL_CONST(125530.02728572517/8.0),
    REAL_CONST(125555.12513434493/8.0),
    REAL_CONST(125580.22423726133/8.0),
    REAL_CONST(125605.32459434902/8.0),
    REAL_CONST(125630.4262054827/8.0),
    REAL_CONST(125655.52907053704/8.0),
    REAL_CONST(125680.63318938682/8.0),
    REAL_CONST(125705.73856190679/8.0),
    REAL_CONST(125730.84518797178/8.0),
    REAL_CONST(125755.9530674566/8.0),
    REAL_CONST(125781.06220023613/8.0),
    REAL_CONST(125806.17258618528/8.0),
    REAL_CONST(125831.28422517896/8.0),
    REAL_CONST(125856.39711709213/8.0),
    REAL_CONST(125881.51126179981/8.0),
    REAL_CONST(125906.62665917698/8.0),
    REAL_CONST(125931.74330909875/8.0),
    REAL_CONST(125956.86121144016/8.0),
    REAL_CONST(125981.98036607634/8.0),
    REAL_CONST(126007.10077288245/8.0),
    REAL_CONST(126032.22243173365/8.0),
    REAL_CONST(126057.34534250517/8.0),
    REAL_CONST(126082.46950507225/8.0),
    REAL_CONST(126107.59491931014/8.0),
    REAL_CONST(126132.72158509417/8.0),
    REAL_CONST(126157.84950229966/8.0),
    REAL_CONST(126182.97867080198/8.0),
    REAL_CONST(126208.10909047653/8.0),
    REAL_CONST(126233.24076119871/8.0),
    REAL_CONST(126258.37368284403/8.0),
    REAL_CONST(126283.50785528794/8.0),
    REAL_CONST(126308.64327840599/8.0),
    REAL_CONST(126333.77995207369/8.0),
    REAL_CONST(126358.91787616667/8.0),
    REAL_CONST(126384.0570505605/8.0),
    REAL_CONST(126409.19747513086/8.0),
    REAL_CONST(126434.3391497534/8.0),
    REAL_CONST(126459.48207430386/8.0),
    REAL_CONST(126484.62624865794/8.0),
    REAL_CONST(126509.77167269142/8.0),
    REAL_CONST(126534.9183462801/8.0),
    REAL_CONST(126560.06626929982/8.0),
    REAL_CONST(126585.21544162642/8.0),
    REAL_CONST(126610.36586313581/8.0),
    REAL_CONST(126635.51753370393/8.0),
    REAL_CONST(126660.67045320668/8.0),
    REAL_CONST(126685.82462152008/8.0),
    REAL_CONST(126710.98003852014/8.0),
    REAL_CONST(126736.13670408291/8.0),
    REAL_CONST(126761.29461808444/8.0),
    REAL_CONST(126786.45378040087/8.0),
    REAL_CONST(126811.61419090834/8.0),
    REAL_CONST(126836.77584948298/8.0),
    REAL_CONST(126861.93875600102/8.0),
    REAL_CONST(126887.10291033868/8.0),
    REAL_CONST(126912.26831237224/8.0),
    REAL_CONST(126937.43496197795/8.0),
    REAL_CONST(126962.60285903217/8.0),
    REAL_CONST(126987.77200341123/8.0),
    REAL_CONST(127012.94239499152/8.0),
    REAL_CONST(127038.11403364947/8.0),
    REAL_CONST(127063.2869192615/8.0),
    REAL_CONST(127088.46105170409/8.0),
    REAL_CONST(127113.63643085376/8.0),
    REAL_CONST(127138.81305658702/8.0),
    REAL_CONST(127163.99092878048/8.0),
    REAL_CONST(127189.17004731069/8.0),
    REAL_CONST(127214.35041205429/8.0),
    REAL_CONST(127239.53202288797/8.0),
    REAL_CONST(127264.71487968838/8.0),
    REAL_CONST(127289.89898233226/8.0),
    REAL_CONST(127315.08433069635/8.0),
    REAL_CONST(127340.27092465744/8.0),
    REAL_CONST(127365.45876409234/8.0),
    REAL_CONST(127390.64784887788/8.0),
    REAL_CONST(127415.83817889093/8.0),
    REAL_CONST(127441.02975400841/8.0),
    REAL_CONST(127466.22257410725/8.0),
    REAL_CONST(127491.41663906439/8.0),
    REAL_CONST(127516.61194875685/8.0),
    REAL_CONST(127541.80850306165/8.0),
    REAL_CONST(127567.00630185583/8.0),
    REAL_CONST(127592.20534501647/8.0),
    REAL_CONST(127617.4056324207/8.0),
    REAL_CONST(127642.60716394568/8.0),
    REAL_CONST(127667.80993946856/8.0),
    REAL_CONST(127693.01395886653/8.0),
    REAL_CONST(127718.21922201688/8.0),
    REAL_CONST(127743.42572879682/8.0),
    REAL_CONST(127768.63347908368/8.0),
    REAL_CONST(127793.84247275478/8.0),
    REAL_CONST(127819.05270968749/8.0),
    REAL_CONST(127844.26418975917/8.0),
    REAL_CONST(127869.47691284724/8.0),
    REAL_CONST(127894.69087882918/8.0),
    REAL_CONST(127919.90608758242/8.0),
    REAL_CONST(127945.12253898452/8.0),
    REAL_CONST(127970.34023291297/8.0),
    REAL_CONST(127995.55916924537/8.0),
    REAL_CONST(128020.77934785932/8.0),
    REAL_CONST(128046.00076863244/8.0),
    REAL_CONST(128071.22343144237/8.0),
    REAL_CONST(128096.44733616684/8.0),
    REAL_CONST(128121.67248268353/8.0),
    REAL_CONST(128146.89887087021/8.0),
    REAL_CONST(128172.12650060465/8.0),
    REAL_CONST(128197.35537176467/8.0),
    REAL_CONST(128222.5854842281/8.0),
    REAL_CONST(128247.81683787282/8.0),
    REAL_CONST(128273.04943257671/8.0),
    REAL_CONST(128298.28326821771/8.0),
    REAL_CONST(128323.51834467379/8.0),
    REAL_CONST(128348.75466182294/8.0),
    REAL_CONST(128373.99221954317/8.0),
    REAL_CONST(128399.23101771252/8.0),
    REAL_CONST(128424.47105620909/8.0),
    REAL_CONST(128449.71233491098/8.0),
    REAL_CONST(128474.95485369631/8.0),
    REAL_CONST(128500.19861244329/8.0),
    REAL_CONST(128525.44361103009/8.0),
    REAL_CONST(128550.68984933494/8.0),
    REAL_CONST(128575.93732723613/8.0),
    REAL_CONST(128601.18604461191/8.0),
    REAL_CONST(128626.43600134061/8.0),
    REAL_CONST(128651.68719730059/8.0),
    REAL_CONST(128676.93963237021/8.0),
    REAL_CONST(128702.1933064279/8.0),
    REAL_CONST(128727.44821935208/8.0),
    REAL_CONST(128752.70437102125/8.0),
    REAL_CONST(128777.96176131385/8.0),
    REAL_CONST(128803.22039010846/8.0),
    REAL_CONST(128828.48025728362/8.0),
    REAL_CONST(128853.74136271792/8.0),
    REAL_CONST(128879.00370628996/8.0),
    REAL_CONST(128904.26728787841/8.0),
    REAL_CONST(128929.53210736193/8.0),
    REAL_CONST(128954.79816461923/8.0),
    REAL_CONST(128980.06545952905/8.0),
    REAL_CONST(129005.33399197015/8.0),
    REAL_CONST(129030.60376182134/8.0),
    REAL_CONST(129055.87476896142/8.0),
    REAL_CONST(129081.14701326926/8.0),
    REAL_CONST(129106.42049462376/8.0),
    REAL_CONST(129131.6952129038/8.0),
    REAL_CONST(129156.97116798835/8.0),
    REAL_CONST(129182.24835975636/8.0),
    REAL_CONST(129207.52678808685/8.0),
    REAL_CONST(129232.80645285884/8.0),
    REAL_CONST(129258.08735395141/8.0),
    REAL_CONST(129283.36949124365/8.0),
    REAL_CONST(129308.65286461466/8.0),
    REAL_CONST(129333.9374739436/8.0),
    REAL_CONST(129359.22331910966/8.0),
    REAL_CONST(129384.51039999202/8.0),
    REAL_CONST(129409.79871646997/8.0),
    REAL_CONST(129435.08826842274/8.0),
    REAL_CONST(129460.37905572963/8.0),
    REAL_CONST(129485.67107826998/8.0),
    REAL_CONST(129510.96433592314/8.0),
    REAL_CONST(129536.25882856851/8.0),
    REAL_CONST(129561.55455608548/8.0),
    REAL_CONST(129586.85151835352/8.0),
    REAL_CONST(129612.14971525209/8.0),
    REAL_CONST(129637.4491466607/8.0),
    REAL_CONST(129662.74981245887/8.0),
    REAL_CONST(129688.0517125262/8.0),
    REAL_CONST(129713.35484674224/8.0),
    REAL_CONST(129738.65921498663/8.0),
    REAL_CONST(129763.96481713903/8.0),
    REAL_CONST(129789.27165307909/8.0),
    REAL_CONST(129814.57972268655/8.0),
    REAL_CONST(129839.88902584116/8.0),
    REAL_CONST(129865.19956242264/8.0),
    REAL_CONST(129890.51133231082/8.0),
    REAL_CONST(129915.82433538554/8.0),
    REAL_CONST(129941.13857152662/8.0),
    REAL_CONST(129966.45404061397/8.0),
    REAL_CONST(129991.7707425275/8.0),
    REAL_CONST(130017.08867714716/8.0),
    REAL_CONST(130042.4078443529/8.0),
    REAL_CONST(130067.72824402474/8.0),
    REAL_CONST(130093.04987604271/8.0),
    REAL_CONST(130118.37274028687/8.0),
    REAL_CONST(130143.69683663732/8.0),
    REAL_CONST(130169.02216497416/8.0),
    REAL_CONST(130194.34872517755/8.0),
    REAL_CONST(130219.67651712766/8.0),
    REAL_CONST(130245.0055407047/8.0),
    REAL_CONST(130270.33579578891/8.0),
    REAL_CONST(130295.66728226055/8.0),
    REAL_CONST(130320.99999999991/8.0),
    REAL_CONST(130346.33394888733/8.0),
    REAL_CONST(130371.66912880314/8.0),
    REAL_CONST(130397.00553962773/8.0),
    REAL_CONST(130422.34318124152/8.0),
    REAL_CONST(130447.68205352494/8.0),
    REAL_CONST(130473.02215635845/8.0),
    REAL_CONST(130498.36348962256/8.0),
    REAL_CONST(130523.70605319779/8.0),
    REAL_CONST(130549.0498469647/8.0),
    REAL_CONST(130574.39487080388/8.0),
    REAL_CONST(130599.74112459592/8.0),
    REAL_CONST(130625.08860822149/8.0),
    REAL_CONST(130650.43732156123/8.0),
    REAL_CONST(130675.78726449587/8.0),
    REAL_CONST(130701.13843690613/8.0),
    REAL_CONST(130726.49083867275/8.0),
    REAL_CONST(130751.84446967654/8.0),
    REAL_CONST(130777.19932979831/8.0),
    REAL_CONST(130802.5554189189/8.0),
    REAL_CONST(130827.91273691918/8.0),
    REAL_CONST(130853.27128368006/8.0),
    REAL_CONST(130878.63105908247/8.0),
    REAL_CONST(130903.99206300738/8.0),
    REAL_CONST(130929.35429533575/8.0),
    REAL_CONST(130954.71775594862/8.0),
    REAL_CONST(130980.08244472703/8.0),
    REAL_CONST(131005.44836155206/8.0),
    REAL_CONST(131030.81550630482/8.0),
    REAL_CONST(131056.18387886642/8.0),
    REAL_CONST(131081.55347911804/8.0),
    REAL_CONST(131106.92430694087/8.0),
    REAL_CONST(131132.29636221612/8.0),
    REAL_CONST(131157.66964482504/8.0),
    REAL_CONST(131183.0441546489/8.0),
    REAL_CONST(131208.41989156904/8.0),
    REAL_CONST(131233.79685546676/8.0),
    REAL_CONST(131259.17504622342/8.0),
    REAL_CONST(131284.55446372041/8.0),
    REAL_CONST(131309.93510783918/8.0),
    REAL_CONST(131335.31697846117/8.0),
    REAL_CONST(131360.70007546784/8.0),
    REAL_CONST(131386.0843987407/8.0),
    REAL_CONST(131411.46994816128/8.0),
    REAL_CONST(131436.85672361116/8.0),
    REAL_CONST(131462.24472497194/8.0),
    REAL_CONST(131487.63395212521/8.0),
    REAL_CONST(131513.02440495262/8.0),
    REAL_CONST(131538.41608333588/8.0),
    REAL_CONST(131563.80898715663/8.0),
    REAL_CONST(131589.2031162967/8.0),
    REAL_CONST(131614.59847063778/8.0),
    REAL_CONST(131639.9950500617/8.0),
    REAL_CONST(131665.39285445024/8.0),
    REAL_CONST(131690.79188368531/8.0),
    REAL_CONST(131716.19213764873/8.0),
    REAL_CONST(131741.59361622241/8.0),
    REAL_CONST(131766.99631928833/8.0),
    REAL_CONST(131792.40024672839/8.0),
    REAL_CONST(131817.80539842462/8.0),
    REAL_CONST(131843.21177425905/8.0),
    REAL_CONST(131868.61937411371/8.0),
    REAL_CONST(131894.02819787065/8.0),
    REAL_CONST(131919.43824541202/8.0),
    REAL_CONST(131944.84951661993/8.0),
    REAL_CONST(131970.26201137656/8.0),
    REAL_CONST(131995.67572956407/8.0),
    REAL_CONST(132021.09067106468/8.0),
    REAL_CONST(132046.50683576067/8.0),
    REAL_CONST(132071.9242235343/8.0),
    REAL_CONST(132097.34283426782/8.0),
    REAL_CONST(132122.76266784366/8.0),
    REAL_CONST(132148.1837241441/8.0),
    REAL_CONST(132173.60600305157/8.0),
    REAL_CONST(132199.02950444847/8.0),
    REAL_CONST(132224.45422821722/8.0),
    REAL_CONST(132249.88017424036/8.0),
    REAL_CONST(132275.30734240031/8.0),
    REAL_CONST(132300.73573257966/8.0),
    REAL_CONST(132326.16534466096/8.0),
    REAL_CONST(132351.59617852676/8.0),
    REAL_CONST(132377.02823405969/8.0),
    REAL_CONST(132402.46151114244/8.0),
    REAL_CONST(132427.89600965759/8.0),
    REAL_CONST(132453.33172948789/8.0),
    REAL_CONST(132478.76867051609/8.0),
    REAL_CONST(132504.20683262491/8.0),
    REAL_CONST(132529.64621569714/8.0),
    REAL_CONST(132555.08681961559/8.0),
    REAL_CONST(132580.5286442631/8.0),
    REAL_CONST(132605.97168952253/8.0),
    REAL_CONST(132631.41595527678/8.0),
    REAL_CONST(132656.86144140881/8.0),
    REAL_CONST(132682.30814780149/8.0),
    REAL_CONST(132707.75607433787/8.0),
    REAL_CONST(132733.20522090094/8.0),
    REAL_CONST(132758.65558737374/8.0),
    REAL_CONST(132784.10717363929/8.0),
    REAL_CONST(132809.55997958075/8.0),
    REAL_CONST(132835.01400508118/8.0),
    REAL_CONST(132860.46925002377/8.0),
    REAL_CONST(132885.92571429166/8.0),
    REAL_CONST(132911.38339776811/8.0),
    REAL_CONST(132936.84230033628/8.0),
    REAL_CONST(132962.30242187946/8.0),
    REAL_CONST(132987.76376228096/8.0),
    REAL_CONST(133013.22632142407/8.0),
    REAL_CONST(133038.69009919214/8.0),
    REAL_CONST(133064.15509546854/8.0),
    REAL_CONST(133089.62131013666/8.0),
    REAL_CONST(133115.08874307995/8.0),
    REAL_CONST(133140.55739418184/8.0),
    REAL_CONST(133166.02726332581/8.0),
    REAL_CONST(133191.49835039541/8.0),
    REAL_CONST(133216.97065527414/8.0),
    REAL_CONST(133242.44417784561/8.0),
    REAL_CONST(133267.91891799335/8.0),
    REAL_CONST(133293.39487560102/8.0),
    REAL_CONST(133318.87205055228/8.0),
    REAL_CONST(133344.35044273079/8.0),
    REAL_CONST(133369.83005202023/8.0),
    REAL_CONST(133395.31087830439/8.0),
    REAL_CONST(133420.79292146701/8.0),
    REAL_CONST(133446.27618139185/8.0),
    REAL_CONST(133471.76065796276/8.0),
    REAL_CONST(133497.24635106357/8.0),
    REAL_CONST(133522.73326057816/8.0),
    REAL_CONST(133548.22138639039/8.0),
    REAL_CONST(133573.71072838426/8.0),
    REAL_CONST(133599.20128644365/8.0),
    REAL_CONST(133624.69306045261/8.0),
    REAL_CONST(133650.1860502951/8.0),
    REAL_CONST(133675.68025585517/8.0),
    REAL_CONST(133701.1756770169/8.0),
    REAL_CONST(133726.67231366437/8.0),
    REAL_CONST(133752.17016568172/8.0),
    REAL_CONST(133777.66923295305/8.0),
    REAL_CONST(133803.16951536259/8.0),
    REAL_CONST(133828.67101279454/8.0),
    REAL_CONST(133854.17372513309/8.0),
    REAL_CONST(133879.67765226253/8.0),
    REAL_CONST(133905.18279406714/8.0),
    REAL_CONST(133930.68915043125/8.0),
    REAL_CONST(133956.19672123916/8.0),
    REAL_CONST(133981.70550637526/8.0),
    REAL_CONST(134007.21550572399/8.0),
    REAL_CONST(134032.7267191697/8.0),
    REAL_CONST(134058.23914659687/8.0),
    REAL_CONST(134083.75278789/8.0),
    REAL_CONST(134109.26764293358/8.0),
    REAL_CONST(134134.78371161217/8.0),
    REAL_CONST(134160.30099381026/8.0),
    REAL_CONST(134185.8194894125/8.0),
    REAL_CONST(134211.33919830353/8.0),
    REAL_CONST(134236.8601203679/8.0),
    REAL_CONST(134262.38225549037/8.0),
    REAL_CONST(134287.90560355558/8.0),
    REAL_CONST(134313.43016444831/8.0),
    REAL_CONST(134338.95593805326/8.0),
    REAL_CONST(134364.48292425525/8.0),
    REAL_CONST(134390.01112293909/8.0),
    REAL_CONST(134415.54053398955/8.0),
    REAL_CONST(134441.07115729159/8.0),
    REAL_CONST(134466.60299273001/8.0),
    REAL_CONST(134492.1360401898/8.0),
    REAL_CONST(134517.67029955584/8.0),
    REAL_CONST(134543.20577071316/8.0),
    REAL_CONST(134568.74245354676/8.0),
    REAL_CONST(134594.28034794159/8.0),
    REAL_CONST(134619.81945378278/8.0),
    REAL_CONST(134645.35977095537/8.0),
    REAL_CONST(134670.90129934452/8.0),
    REAL_CONST(134696.4440388353/8.0),
    REAL_CONST(134721.98798931291/8.0),
    REAL_CONST(134747.53315066252/8.0),
    REAL_CONST(134773.07952276937/8.0),
    REAL_CONST(134798.62710551871/8.0),
    REAL_CONST(134824.17589879577/8.0),
    REAL_CONST(134849.72590248589/8.0),
    REAL_CONST(134875.27711647438/8.0),
    REAL_CONST(134900.82954064661/8.0),
    REAL_CONST(134926.38317488792/8.0),
    REAL_CONST(134951.93801908373/8.0),
    REAL_CONST(134977.49407311951/8.0),
    REAL_CONST(135003.05133688069/8.0),
    REAL_CONST(135028.60981025276/8.0),
    REAL_CONST(135054.16949312127/8.0),
    REAL_CONST(135079.73038537172/8.0),
    REAL_CONST(135105.29248688967/8.0),
    REAL_CONST(135130.85579756077/8.0),
    REAL_CONST(135156.42031727062/8.0),
    REAL_CONST(135181.98604590484/8.0),
    REAL_CONST(135207.55298334916/8.0),
    REAL_CONST(135233.12112948924/8.0),
    REAL_CONST(135258.69048421088/8.0),
    REAL_CONST(135284.26104739975/8.0),
    REAL_CONST(135309.83281894168/8.0),
    REAL_CONST(135335.4057987225/8.0),
    REAL_CONST(135360.97998662802/8.0),
    REAL_CONST(135386.55538254412/8.0),
    REAL_CONST(135412.13198635669/8.0),
    REAL_CONST(135437.70979795168/8.0),
    REAL_CONST(135463.28881721498/8.0),
    REAL_CONST(135488.86904403262/8.0),
    REAL_CONST(135514.45047829056/8.0),
    REAL_CONST(135540.03311987486/8.0),
    REAL_CONST(135565.61696867159/8.0),
    REAL_CONST(135591.20202456677/8.0),
    REAL_CONST(135616.78828744654/8.0),
    REAL_CONST(135642.37575719706/8.0),
    REAL_CONST(135667.96443370447/8.0),
    REAL_CONST(135693.55431685498/8.0),
    REAL_CONST(135719.14540653475/8.0),
    REAL_CONST(135744.73770263011/8.0),
    REAL_CONST(135770.33120502727/8.0),
    REAL_CONST(135795.92591361253/8.0),
    REAL_CONST(135821.52182827223/8.0),
    REAL_CONST(135847.11894889272/8.0),
    REAL_CONST(135872.7172753604/8.0),
    REAL_CONST(135898.31680756161/8.0),
    REAL_CONST(135923.91754538284/8.0),
    REAL_CONST(135949.51948871053/8.0),
    REAL_CONST(135975.12263743114/8.0),
    REAL_CONST(136000.72699143123/8.0),
    REAL_CONST(136026.33255059729/8.0),
    REAL_CONST(136051.93931481591/8.0),
    REAL_CONST(136077.54728397369/8.0),
    REAL_CONST(136103.15645795723/8.0),
    REAL_CONST(136128.76683665317/8.0),
    REAL_CONST(136154.37841994822/8.0),
    REAL_CONST(136179.99120772901/8.0),
    REAL_CONST(136205.60519988232/8.0),
    REAL_CONST(136231.2203962949/8.0),
    REAL_CONST(136256.83679685349/8.0),
    REAL_CONST(136282.45440144493/8.0),
    REAL_CONST(136308.07320995603/8.0),
    REAL_CONST(136333.69322227367/8.0),
    REAL_CONST(136359.31443828469/8.0),
    REAL_CONST(136384.93685787608/8.0),
    REAL_CONST(136410.56048093468/8.0),
    REAL_CONST(136436.18530734754/8.0),
    REAL_CONST(136461.81133700156/8.0),
    REAL_CONST(136487.43856978384/8.0),
    REAL_CONST(136513.06700558143/8.0),
    REAL_CONST(136538.6966442813/8.0),
    REAL_CONST(136564.32748577066/8.0),
    REAL_CONST(136589.95952993655/8.0),
    REAL_CONST(136615.59277666616/8.0),
    REAL_CONST(136641.22722584667/8.0),
    REAL_CONST(136666.86287736523/8.0),
    REAL_CONST(136692.49973110916/8.0),
    REAL_CONST(136718.13778696564/8.0),
    REAL_CONST(136743.77704482197/8.0),
    REAL_CONST(136769.41750456547/8.0),
    REAL_CONST(136795.05916608346/8.0),
    REAL_CONST(136820.70202926331/8.0),
    REAL_CONST(136846.34609399244/8.0),
    REAL_CONST(136871.99136015819/8.0),
    REAL_CONST(136897.63782764805/8.0),
    REAL_CONST(136923.28549634948/8.0),
    REAL_CONST(136948.93436614997/8.0),
    REAL_CONST(136974.58443693706/8.0),
    REAL_CONST(137000.23570859825/8.0),
    REAL_CONST(137025.88818102115/8.0),
    REAL_CONST(137051.54185409332/8.0),
    REAL_CONST(137077.19672770242/8.0),
    REAL_CONST(137102.85280173609/8.0),
    REAL_CONST(137128.51007608202/8.0),
    REAL_CONST(137154.16855062786/8.0),
    REAL_CONST(137179.82822526142/8.0),
    REAL_CONST(137205.48909987041/8.0),
    REAL_CONST(137231.15117434258/8.0),
    REAL_CONST(137256.8144485658/8.0),
    REAL_CONST(137282.47892242789/8.0),
    REAL_CONST(137308.14459581667/8.0),
    REAL_CONST(137333.81146862009/8.0),
    REAL_CONST(137359.47954072602/8.0),
    REAL_CONST(137385.14881202241/8.0),
    REAL_CONST(137410.81928239719/8.0),
    REAL_CONST(137436.49095173844/8.0),
    REAL_CONST(137462.16381993407/8.0),
    REAL_CONST(137487.83788687221/8.0),
    REAL_CONST(137513.51315244089/8.0),
    REAL_CONST(137539.18961652822/8.0),
    REAL_CONST(137564.86727902229/8.0),
    REAL_CONST(137590.54613981131/8.0),
    REAL_CONST(137616.22619878338/8.0),
    REAL_CONST(137641.90745582676/8.0),
    REAL_CONST(137667.58991082967/8.0),
    REAL_CONST(137693.27356368033/8.0),
    REAL_CONST(137718.95841426702/8.0),
    REAL_CONST(137744.64446247809/8.0),
    REAL_CONST(137770.33170820182/8.0),
    REAL_CONST(137796.02015132661/8.0),
    REAL_CONST(137821.70979174081/8.0),
    REAL_CONST(137847.40062933284/8.0),
    REAL_CONST(137873.09266399115/8.0),
    REAL_CONST(137898.78589560417/8.0),
    REAL_CONST(137924.48032406042/8.0),
    REAL_CONST(137950.17594924837/8.0),
    REAL_CONST(137975.8727710566/8.0),
    REAL_CONST(138001.57078937365/8.0),
    REAL_CONST(138027.27000408815/8.0),
    REAL_CONST(138052.97041508864/8.0),
    REAL_CONST(138078.67202226384/8.0),
    REAL_CONST(138104.3748255024/8.0),
    REAL_CONST(138130.07882469296/8.0),
    REAL_CONST(138155.78401972432/8.0),
    REAL_CONST(138181.49041048516/8.0),
    REAL_CONST(138207.1979968643/8.0),
    REAL_CONST(138232.9067787505/8.0),
    REAL_CONST(138258.61675603263/8.0),
    REAL_CONST(138284.32792859949/8.0),
    REAL_CONST(138310.04029633995/8.0),
    REAL_CONST(138335.75385914298/8.0),
    REAL_CONST(138361.46861689744/8.0),
    REAL_CONST(138387.18456949232/8.0),
    REAL_CONST(138412.90171681659/8.0),
    REAL_CONST(138438.62005875923/8.0),
    REAL_CONST(138464.33959520931/8.0),
    REAL_CONST(138490.06032605586/8.0),
    REAL_CONST(138515.78225118798/8.0),
    REAL_CONST(138541.50537049473/8.0),
    REAL_CONST(138567.2296838653/8.0),
    REAL_CONST(138592.95519118884/8.0),
    REAL_CONST(138618.68189235451/8.0),
    REAL_CONST(138644.40978725153/8.0),
    REAL_CONST(138670.13887576913/8.0),
    REAL_CONST(138695.86915779658/8.0),
    REAL_CONST(138721.60063322316/8.0),
    REAL_CONST(138747.33330193823/8.0),
    REAL_CONST(138773.06716383106/8.0),
    REAL_CONST(138798.80221879104/8.0),
    REAL_CONST(138824.53846670757/8.0),
    REAL_CONST(138850.27590747006/8.0),
    REAL_CONST(138876.01454096794/8.0),
    REAL_CONST(138901.7543670907/8.0),
    REAL_CONST(138927.49538572782/8.0),
    REAL_CONST(138953.2375967688/8.0),
    REAL_CONST(138978.9810001032/8.0),
    REAL_CONST(139004.72559562061/8.0),
    REAL_CONST(139030.47138321059/8.0),
    REAL_CONST(139056.2183627628/8.0),
    REAL_CONST(139081.96653416683/8.0),
    REAL_CONST(139107.71589731239/8.0),
    REAL_CONST(139133.46645208917/8.0),
    REAL_CONST(139159.21819838689/8.0),
    REAL_CONST(139184.97113609532/8.0),
    REAL_CONST(139210.72526510421/8.0),
    REAL_CONST(139236.48058530336/8.0),
    REAL_CONST(139262.23709658257/8.0),
    REAL_CONST(139287.99479883176/8.0),
    REAL_CONST(139313.75369194071/8.0),
    REAL_CONST(139339.51377579942/8.0),
    REAL_CONST(139365.27505029776/8.0),
    REAL_CONST(139391.03751532568/8.0),
    REAL_CONST(139416.80117077316/8.0),
    REAL_CONST(139442.56601653024/8.0),
    REAL_CONST(139468.33205248689/8.0),
    REAL_CONST(139494.09927853322/8.0),
    REAL_CONST(139519.86769455927/8.0),
    REAL_CONST(139545.63730045516/8.0),
    REAL_CONST(139571.408096111/8.0),
    REAL_CONST(139597.18008141697/8.0),
    REAL_CONST(139622.95325626322/8.0),
    REAL_CONST(139648.72762054001/8.0),
    REAL_CONST(139674.5031741375/8.0),
    REAL_CONST(139700.27991694602/8.0),
    REAL_CONST(139726.05784885579/8.0),
    REAL_CONST(139751.83696975713/8.0),
    REAL_CONST(139777.61727954043/8.0),
    REAL_CONST(139803.39877809596/8.0),
    REAL_CONST(139829.18146531415/8.0),
    REAL_CONST(139854.96534108539/8.0),
    REAL_CONST(139880.75040530015/8.0),
    REAL_CONST(139906.53665784886/8.0),
    REAL_CONST(139932.32409862199/8.0),
    REAL_CONST(139958.11272751007/8.0),
    REAL_CONST(139983.90254440365/8.0),
    REAL_CONST(140009.69354919327/8.0),
    REAL_CONST(140035.48574176949/8.0),
    REAL_CONST(140061.27912202294/8.0),
    REAL_CONST(140087.07368984428/8.0),
    REAL_CONST(140112.86944512415/8.0),
    REAL_CONST(140138.66638775321/8.0),
    REAL_CONST(140164.4645176222/8.0),
    REAL_CONST(140190.26383462184/8.0),
    REAL_CONST(140216.06433864293/8.0),
    REAL_CONST(140241.86602957622/8.0),
    REAL_CONST(140267.66890731253/8.0),
    REAL_CONST(140293.47297174268/8.0),
    REAL_CONST(140319.27822275754/8.0),
    REAL_CONST(140345.08466024802/8.0),
    REAL_CONST(140370.89228410498/8.0),
    REAL_CONST(140396.70109421943/8.0),
    REAL_CONST(140422.51109048226/8.0),
    REAL_CONST(140448.32227278448/8.0),
    REAL_CONST(140474.13464101712/8.0),
    REAL_CONST(140499.94819507122/8.0),
    REAL_CONST(140525.76293483781/8.0),
    REAL_CONST(140551.57886020801/8.0),
    REAL_CONST(140577.3959710729/8.0),
    REAL_CONST(140603.21426732364/8.0),
    REAL_CONST(140629.03374885136/8.0),
    REAL_CONST(140654.85441554731/8.0),
    REAL_CONST(140680.67626730262/8.0),
    REAL_CONST(140706.49930400858/8.0),
    REAL_CONST(140732.32352555645/8.0),
    REAL_CONST(140758.1489318375/8.0),
    REAL_CONST(140783.97552274304/8.0),
    REAL_CONST(140809.80329816442/8.0),
    REAL_CONST(140835.63225799298/8.0),
    REAL_CONST(140861.46240212015/8.0),
    REAL_CONST(140887.29373043729/8.0),
    REAL_CONST(140913.12624283586/8.0),
    REAL_CONST(140938.95993920733/8.0),
    REAL_CONST(140964.79481944317/8.0),
    REAL_CONST(140990.63088343487/8.0),
    REAL_CONST(141016.46813107401/8.0),
    REAL_CONST(141042.30656225214/8.0),
    REAL_CONST(141068.14617686081/8.0),
    REAL_CONST(141093.98697479168/8.0),
    REAL_CONST(141119.82895593636/8.0),
    REAL_CONST(141145.6721201865/8.0),
    REAL_CONST(141171.51646743377/8.0),
    REAL_CONST(141197.36199756994/8.0),
    REAL_CONST(141223.20871048668/8.0),
    REAL_CONST(141249.05660607578/8.0),
    REAL_CONST(141274.90568422904/8.0),
    REAL_CONST(141300.75594483822/8.0),
    REAL_CONST(141326.6073877952/8.0),
    REAL_CONST(141352.4600129918/8.0),
    REAL_CONST(141378.31382031992/8.0),
    REAL_CONST(141404.16880967148/8.0),
    REAL_CONST(141430.02498093838/8.0),
    REAL_CONST(141455.8823340126/8.0),
    REAL_CONST(141481.74086878612/8.0),
    REAL_CONST(141507.60058515094/8.0),
    REAL_CONST(141533.46148299909/8.0),
    REAL_CONST(141559.32356222265/8.0),
    REAL_CONST(141585.18682271364/8.0),
    REAL_CONST(141611.05126436421/8.0),
    REAL_CONST(141636.9168870665/8.0),
    REAL_CONST(141662.78369071262/8.0),
    REAL_CONST(141688.65167519479/8.0),
    REAL_CONST(141714.5208404052/8.0),
    REAL_CONST(141740.39118623605/8.0),
    REAL_CONST(141766.26271257963/8.0),
    REAL_CONST(141792.1354193282/8.0),
    REAL_CONST(141818.00930637406/8.0),
    REAL_CONST(141843.88437360956/8.0),
    REAL_CONST(141869.760620927/8.0),
    REAL_CONST(141895.6380482188/8.0),
    REAL_CONST(141921.51665537735/8.0),
    REAL_CONST(141947.39644229505/8.0),
    REAL_CONST(141973.27740886438/8.0),
    REAL_CONST(141999.15955497778/8.0),
    REAL_CONST(142025.04288052776/8.0),
    REAL_CONST(142050.92738540689/8.0),
    REAL_CONST(142076.81306950765/8.0),
    REAL_CONST(142102.69993272264/8.0),
    REAL_CONST(142128.58797494444/8.0),
    REAL_CONST(142154.47719606571/8.0),
    REAL_CONST(142180.36759597904/8.0),
    REAL_CONST(142206.25917457714/8.0),
    REAL_CONST(142232.15193175265/8.0),
    REAL_CONST(142258.04586739838/8.0),
    REAL_CONST(142283.94098140698/8.0),
    REAL_CONST(142309.83727367126/8.0),
    REAL_CONST(142335.73474408401/8.0),
    REAL_CONST(142361.63339253806/8.0),
    REAL_CONST(142387.5332189262/8.0),
    REAL_CONST(142413.43422314132/8.0),
    REAL_CONST(142439.33640507635/8.0),
    REAL_CONST(142465.23976462413/8.0),
    REAL_CONST(142491.14430167765/8.0),
    REAL_CONST(142517.05001612983/8.0),
    REAL_CONST(142542.95690787368/8.0),
    REAL_CONST(142568.86497680223/8.0),
    REAL_CONST(142594.77422280848/8.0),
    REAL_CONST(142620.68464578551/8.0),
    REAL_CONST(142646.5962456264/8.0),
    REAL_CONST(142672.50902222423/8.0),
    REAL_CONST(142698.42297547215/8.0),
    REAL_CONST(142724.33810526333/8.0),
    REAL_CONST(142750.25441149093/8.0),
    REAL_CONST(142776.17189404817/8.0),
    REAL_CONST(142802.09055282827/8.0),
    REAL_CONST(142828.01038772447/8.0),
    REAL_CONST(142853.93139863008/8.0),
    REAL_CONST(142879.85358543837/8.0),
    REAL_CONST(142905.77694804268/8.0),
    REAL_CONST(142931.70148633636/8.0),
    REAL_CONST(142957.62720021277/8.0),
    REAL_CONST(142983.55408956532/8.0),
    REAL_CONST(143009.48215428743/8.0),
    REAL_CONST(143035.41139427255/8.0),
    REAL_CONST(143061.34180941415/8.0),
    REAL_CONST(143087.27339960571/8.0),
    REAL_CONST(143113.20616474075/8.0),
    REAL_CONST(143139.14010471283/8.0),
    REAL_CONST(143165.07521941551/8.0),
    REAL_CONST(143191.01150874238/8.0),
    REAL_CONST(143216.94897258704/8.0),
    REAL_CONST(143242.88761084314/8.0),
    REAL_CONST(143268.82742340435/8.0),
    REAL_CONST(143294.76841016437/8.0),
    REAL_CONST(143320.71057101688/8.0),
    REAL_CONST(143346.65390585564/8.0),
    REAL_CONST(143372.59841457437/8.0),
    REAL_CONST(143398.54409706692/8.0),
    REAL_CONST(143424.49095322701/8.0),
    REAL_CONST(143450.43898294857/8.0),
    REAL_CONST(143476.38818612538/8.0),
    REAL_CONST(143502.33856265133/8.0),
    REAL_CONST(143528.29011242036/8.0),
    REAL_CONST(143554.24283532638/8.0),
    REAL_CONST(143580.19673126334/8.0),
    REAL_CONST(143606.1518001252/8.0),
    REAL_CONST(143632.10804180597/8.0),
    REAL_CONST(143658.06545619969/8.0),
    REAL_CONST(143684.02404320039/8.0),
    REAL_CONST(143709.98380270213/8.0),
    REAL_CONST(143735.944734599/8.0),
    REAL_CONST(143761.90683878519/8.0),
    REAL_CONST(143787.87011515474/8.0),
    REAL_CONST(143813.83456360188/8.0),
    REAL_CONST(143839.8001840208/8.0),
    REAL_CONST(143865.76697630569/8.0),
    REAL_CONST(143891.73494035081/8.0),
    REAL_CONST(143917.7040760504/8.0),
    REAL_CONST(143943.67438329876/8.0),
    REAL_CONST(143969.6458619902/8.0),
    REAL_CONST(143995.61851201905/8.0),
    REAL_CONST(144021.59233327967/8.0),
    REAL_CONST(144047.56732566646/8.0),
    REAL_CONST(144073.54348907378/8.0),
    REAL_CONST(144099.52082339607/8.0),
    REAL_CONST(144125.49932852783/8.0),
    REAL_CONST(144151.4790043635/8.0),
    REAL_CONST(144177.45985079758/8.0),
    REAL_CONST(144203.44186772458/8.0),
    REAL_CONST(144229.42505503909/8.0),
    REAL_CONST(144255.40941263564/8.0),
    REAL_CONST(144281.39494040885/8.0),
    REAL_CONST(144307.38163825331/8.0),
    REAL_CONST(144333.36950606373/8.0),
    REAL_CONST(144359.35854373468/8.0),
    REAL_CONST(144385.34875116093/8.0),
    REAL_CONST(144411.34012823718/8.0),
    REAL_CONST(144437.33267485813/8.0),
    REAL_CONST(144463.32639091855/8.0),
    REAL_CONST(144489.32127631325/8.0),
    REAL_CONST(144515.31733093705/8.0),
    REAL_CONST(144541.31455468474/8.0),
    REAL_CONST(144567.3129474512/8.0),
    REAL_CONST(144593.3125091313/8.0),
    REAL_CONST(144619.31323961995/8.0),
    REAL_CONST(144645.31513881206/8.0),
    REAL_CONST(144671.31820660262/8.0),
    REAL_CONST(144697.32244288657/8.0),
    REAL_CONST(144723.32784755889/8.0),
    REAL_CONST(144749.33442051467/8.0),
    REAL_CONST(144775.34216164888/8.0),
    REAL_CONST(144801.35107085665/8.0),
    REAL_CONST(144827.36114803303/8.0),
    REAL_CONST(144853.37239307314/8.0),
    REAL_CONST(144879.38480587213/8.0),
    REAL_CONST(144905.39838632516/8.0),
    REAL_CONST(144931.41313432742/8.0),
    REAL_CONST(144957.4290497741/8.0),
    REAL_CONST(144983.44613256046/8.0),
    REAL_CONST(145009.46438258173/8.0),
    REAL_CONST(145035.48379973322/8.0),
    REAL_CONST(145061.50438391021/8.0),
    REAL_CONST(145087.52613500805/8.0),
    REAL_CONST(145113.54905292206/8.0),
    REAL_CONST(145139.57313754765/8.0),
    REAL_CONST(145165.59838878017/8.0),
    REAL_CONST(145191.62480651509/8.0),
    REAL_CONST(145217.65239064783/8.0),
    REAL_CONST(145243.68114107384/8.0),
    REAL_CONST(145269.71105768863/8.0),
    REAL_CONST(145295.74214038774/8.0),
    REAL_CONST(145321.77438906668/8.0),
    REAL_CONST(145347.80780362099/8.0),
    REAL_CONST(145373.84238394629/8.0),
    REAL_CONST(145399.87812993818/8.0),
    REAL_CONST(145425.91504149229/8.0),
    REAL_CONST(145451.95311850426/8.0),
    REAL_CONST(145477.9923608698/8.0),
    REAL_CONST(145504.03276848458/8.0),
    REAL_CONST(145530.07434124436/8.0),
    REAL_CONST(145556.11707904484/8.0),
    REAL_CONST(145582.16098178181/8.0),
    REAL_CONST(145608.20604935108/8.0),
    REAL_CONST(145634.25228164849/8.0),
    REAL_CONST(145660.29967856981/8.0),
    REAL_CONST(145686.34824001096/8.0),
    REAL_CONST(145712.39796586783/8.0),
    REAL_CONST(145738.4488560363/8.0),
    REAL_CONST(145764.50091041232/8.0),
    REAL_CONST(145790.55412889185/8.0),
    REAL_CONST(145816.60851137087/8.0),
    REAL_CONST(145842.66405774537/8.0),
    REAL_CONST(145868.72076791141/8.0),
    REAL_CONST(145894.77864176501/8.0),
    REAL_CONST(145920.83767920226/8.0),
    REAL_CONST(145946.89788011924/8.0),
    REAL_CONST(145972.95924441208/8.0),
    REAL_CONST(145999.02177197693/8.0),
    REAL_CONST(146025.08546270995/8.0),
    REAL_CONST(146051.15031650732/8.0),
    REAL_CONST(146077.21633326527/8.0),
    REAL_CONST(146103.28351288004/8.0),
    REAL_CONST(146129.35185524789/8.0),
    REAL_CONST(146155.42136026506/8.0),
    REAL_CONST(146181.49202782792/8.0),
    REAL_CONST(146207.56385783272/8.0),
    REAL_CONST(146233.63685017588/8.0),
    REAL_CONST(146259.71100475377/8.0),
    REAL_CONST(146285.78632146274/8.0),
    REAL_CONST(146311.86280019928/8.0),
    REAL_CONST(146337.94044085976/8.0),
    REAL_CONST(146364.01924334071/8.0),
    REAL_CONST(146390.09920753856/8.0),
    REAL_CONST(146416.18033334985/8.0),
    REAL_CONST(146442.26262067116/8.0),
    REAL_CONST(146468.34606939898/8.0),
    REAL_CONST(146494.43067942993/8.0),
    REAL_CONST(146520.51645066062/8.0),
    REAL_CONST(146546.60338298764/8.0),
    REAL_CONST(146572.69147630769/8.0),
    REAL_CONST(146598.78073051744/8.0),
    REAL_CONST(146624.87114551352/8.0),
    REAL_CONST(146650.96272119274/8.0),
    REAL_CONST(146677.05545745179/8.0),
    REAL_CONST(146703.14935418745/8.0),
    REAL_CONST(146729.2444112965/8.0),
    REAL_CONST(146755.34062867577/8.0),
    REAL_CONST(146781.43800622207/8.0),
    REAL_CONST(146807.53654383228/8.0),
    REAL_CONST(146833.63624140329/8.0),
    REAL_CONST(146859.73709883197/8.0),
    REAL_CONST(146885.83911601527/8.0),
    REAL_CONST(146911.94229285014/8.0),
    REAL_CONST(146938.04662923355/8.0),
    REAL_CONST(146964.15212506248/8.0),
    REAL_CONST(146990.25878023397/8.0),
    REAL_CONST(147016.36659464505/8.0),
    REAL_CONST(147042.47556819281/8.0),
    REAL_CONST(147068.58570077427/8.0),
    REAL_CONST(147094.6969922866/8.0),
    REAL_CONST(147120.80944262692/8.0),
    REAL_CONST(147146.92305169237/8.0),
    REAL_CONST(147173.03781938017/8.0),
    REAL_CONST(147199.15374558745/8.0),
    REAL_CONST(147225.27083021149/8.0),
    REAL_CONST(147251.38907314953/8.0),
    REAL_CONST(147277.50847429881/8.0),
    REAL_CONST(147303.62903355664/8.0),
    REAL_CONST(147329.75075082036/8.0),
    REAL_CONST(147355.87362598727/8.0),
    REAL_CONST(147381.99765895473/8.0),
    REAL_CONST(147408.12284962015/8.0),
    REAL_CONST(147434.24919788091/8.0),
    REAL_CONST(147460.37670363448/8.0),
    REAL_CONST(147486.50536677826/8.0),
    REAL_CONST(147512.63518720976/8.0),
    REAL_CONST(147538.76616482646/8.0),
    REAL_CONST(147564.89829952587/8.0),
    REAL_CONST(147591.03159120557/8.0),
    REAL_CONST(147617.16603976308/8.0),
    REAL_CONST(147643.30164509601/8.0),
    REAL_CONST(147669.43840710199/8.0),
    REAL_CONST(147695.57632567859/8.0),
    REAL_CONST(147721.71540072354/8.0),
    REAL_CONST(147747.85563213445/8.0),
    REAL_CONST(147773.99701980909/8.0),
    REAL_CONST(147800.13956364512/8.0),
    REAL_CONST(147826.28326354033/8.0),
    REAL_CONST(147852.42811939248/8.0),
    REAL_CONST(147878.57413109933/8.0),
    REAL_CONST(147904.72129855872/8.0),
    REAL_CONST(147930.86962166851/8.0),
    REAL_CONST(147957.01910032652/8.0),
    REAL_CONST(147983.16973443062/8.0),
    REAL_CONST(148009.32152387875/8.0),
    REAL_CONST(148035.47446856883/8.0),
    REAL_CONST(148061.62856839882/8.0),
    REAL_CONST(148087.78382326665/8.0),
    REAL_CONST(148113.94023307035/8.0),
    REAL_CONST(148140.09779770792/8.0),
    REAL_CONST(148166.25651707739/8.0),
    REAL_CONST(148192.41639107687/8.0),
    REAL_CONST(148218.57741960438/8.0),
    REAL_CONST(148244.73960255808/8.0),
    REAL_CONST(148270.90293983606/8.0),
    REAL_CONST(148297.0674313365/8.0),
    REAL_CONST(148323.23307695755/8.0),
    REAL_CONST(148349.39987659742/8.0),
    REAL_CONST(148375.56783015432/8.0),
    REAL_CONST(148401.73693752653/8.0),
    REAL_CONST(148427.90719861226/8.0),
    REAL_CONST(148454.07861330983/8.0),
    REAL_CONST(148480.25118151752/8.0),
    REAL_CONST(148506.42490313368/8.0),
    REAL_CONST(148532.59977805667/8.0),
    REAL_CONST(148558.77580618486/8.0),
    REAL_CONST(148584.95298741665/8.0),
    REAL_CONST(148611.13132165043/8.0),
    REAL_CONST(148637.31080878471/8.0),
    REAL_CONST(148663.49144871789/8.0),
    REAL_CONST(148689.6732413485/8.0),
    REAL_CONST(148715.85618657502/8.0),
    REAL_CONST(148742.040284296/8.0),
    REAL_CONST(148768.22553440998/8.0),
    REAL_CONST(148794.41193681557/8.0),
    REAL_CONST(148820.59949141133/8.0),
    REAL_CONST(148846.78819809589/8.0),
    REAL_CONST(148872.97805676793/8.0),
    REAL_CONST(148899.16906732606/8.0),
    REAL_CONST(148925.36122966901/8.0),
    REAL_CONST(148951.55454369547/8.0),
    REAL_CONST(148977.74900930419/8.0),
    REAL_CONST(149003.9446263939/8.0),
    REAL_CONST(149030.1413948634/8.0),
    REAL_CONST(149056.33931461151/8.0),
    REAL_CONST(149082.53838553699/8.0),
    REAL_CONST(149108.73860753875/8.0),
    REAL_CONST(149134.9399805156/8.0),
    REAL_CONST(149161.14250436646/8.0),
    REAL_CONST(149187.34617899026/8.0),
    REAL_CONST(149213.5510042859/8.0),
    REAL_CONST(149239.75698015234/8.0),
    REAL_CONST(149265.96410648854/8.0),
    REAL_CONST(149292.17238319354/8.0),
    REAL_CONST(149318.38181016635/8.0),
    REAL_CONST(149344.59238730598/8.0),
    REAL_CONST(149370.80411451156/8.0),
    REAL_CONST(149397.01699168212/8.0),
    REAL_CONST(149423.23101871679/8.0),
    REAL_CONST(149449.44619551473/8.0),
    REAL_CONST(149475.66252197503/8.0),
    REAL_CONST(149501.87999799693/8.0),
    REAL_CONST(149528.0986234796/8.0),
    REAL_CONST(149554.31839832227/8.0),
    REAL_CONST(149580.53932242419/8.0),
    REAL_CONST(149606.76139568459/8.0),
    REAL_CONST(149632.98461800278/8.0),
    REAL_CONST(149659.20898927809/8.0),
    REAL_CONST(149685.43450940982/8.0),
    REAL_CONST(149711.66117829733/8.0),
    REAL_CONST(149737.88899584001/8.0),
    REAL_CONST(149764.11796193724/8.0),
    REAL_CONST(149790.34807648844/8.0),
    REAL_CONST(149816.57933939309/8.0),
    REAL_CONST(149842.81175055061/8.0),
    REAL_CONST(149869.04530986046/8.0),
    REAL_CONST(149895.28001722222/8.0),
    REAL_CONST(149921.51587253538/8.0),
    REAL_CONST(149947.75287569952/8.0),
    REAL_CONST(149973.99102661415/8.0),
    REAL_CONST(150000.23032517891/8.0),
    REAL_CONST(150026.47077129342/8.0),
    REAL_CONST(150052.71236485732/8.0),
    REAL_CONST(150078.95510577026/8.0),
    REAL_CONST(150105.1989939319/8.0),
    REAL_CONST(150131.444029242/8.0),
    REAL_CONST(150157.69021160025/8.0),
    REAL_CONST(150183.93754090639/8.0),
    REAL_CONST(150210.18601706024/8.0),
    REAL_CONST(150236.43563996154/8.0),
    REAL_CONST(150262.68640951012/8.0),
    REAL_CONST(150288.93832560582/8.0),
    REAL_CONST(150315.19138814852/8.0),
    REAL_CONST(150341.44559703805/8.0),
    REAL_CONST(150367.70095217437/8.0),
    REAL_CONST(150393.95745345735/8.0),
    REAL_CONST(150420.21510078697/8.0),
    REAL_CONST(150446.47389406321/8.0),
    REAL_CONST(150472.73383318601/8.0),
    REAL_CONST(150498.99491805542/8.0),
    REAL_CONST(150525.25714857146/8.0),
    REAL_CONST(150551.52052463419/8.0),
    REAL_CONST(150577.78504614369/8.0),
    REAL_CONST(150604.05071300003/8.0),
    REAL_CONST(150630.31752510337/8.0),
    REAL_CONST(150656.58548235384/8.0),
    REAL_CONST(150682.85458465159/8.0),
    REAL_CONST(150709.1248318968/8.0),
    REAL_CONST(150735.39622398972/8.0),
    REAL_CONST(150761.66876083051/8.0),
    REAL_CONST(150787.9424423195/8.0),
    REAL_CONST(150814.21726835691/8.0),
    REAL_CONST(150840.49323884305/8.0),
    REAL_CONST(150866.77035367821/8.0),
    REAL_CONST(150893.04861276277/8.0),
    REAL_CONST(150919.32801599705/8.0),
    REAL_CONST(150945.60856328148/8.0),
    REAL_CONST(150971.89025451642/8.0),
    REAL_CONST(150998.17308960229/8.0),
    REAL_CONST(151024.45706843957/8.0),
    REAL_CONST(151050.74219092872/8.0),
    REAL_CONST(151077.02845697021/8.0),
    REAL_CONST(151103.31586646455/8.0),
    REAL_CONST(151129.60441931229/8.0),
    REAL_CONST(151155.894115414/8.0),
    REAL_CONST(151182.1849546702/8.0),
    REAL_CONST(151208.47693698155/8.0),
    REAL_CONST(151234.77006224863/8.0),
    REAL_CONST(151261.06433037209/8.0),
    REAL_CONST(151287.35974125259/8.0),
    REAL_CONST(151313.65629479082/8.0),
    REAL_CONST(151339.95399088747/8.0),
    REAL_CONST(151366.25282944329/8.0),
    REAL_CONST(151392.55281035902/8.0),
    REAL_CONST(151418.85393353543/8.0),
    REAL_CONST(151445.1561988733/8.0),
    REAL_CONST(151471.45960627345/8.0),
    REAL_CONST(151497.76415563675/8.0),
    REAL_CONST(151524.06984686397/8.0),
    REAL_CONST(151550.37667985607/8.0),
    REAL_CONST(151576.68465451393/8.0),
    REAL_CONST(151602.99377073845/8.0),
    REAL_CONST(151629.30402843058/8.0),
    REAL_CONST(151655.61542749128/8.0),
    REAL_CONST(151681.92796782157/8.0),
    REAL_CONST(151708.24164932242/8.0),
    REAL_CONST(151734.55647189484/8.0),
    REAL_CONST(151760.87243543993/8.0),
    REAL_CONST(151787.18953985872/8.0),
    REAL_CONST(151813.50778505235/8.0),
    REAL_CONST(151839.82717092187/8.0),
    REAL_CONST(151866.14769736846/8.0),
    REAL_CONST(151892.46936429327/8.0),
    REAL_CONST(151918.79217159748/8.0),
    REAL_CONST(151945.11611918229/8.0),
    REAL_CONST(151971.44120694889/8.0),
    REAL_CONST(151997.76743479856/8.0),
    REAL_CONST(152024.09480263255/8.0),
    REAL_CONST(152050.42331035214/8.0),
    REAL_CONST(152076.75295785864/8.0),
    REAL_CONST(152103.08374505339/8.0),
    REAL_CONST(152129.41567183775/8.0),
    REAL_CONST(152155.74873811303/8.0),
    REAL_CONST(152182.08294378067/8.0),
    REAL_CONST(152208.41828874208/8.0),
    REAL_CONST(152234.75477289871/8.0),
    REAL_CONST(152261.09239615197/8.0),
    REAL_CONST(152287.43115840337/8.0),
    REAL_CONST(152313.77105955439/8.0),
    REAL_CONST(152340.11209950657/8.0),
    REAL_CONST(152366.45427816146/8.0),
    REAL_CONST(152392.79759542056/8.0),
    REAL_CONST(152419.14205118554/8.0),
    REAL_CONST(152445.48764535793/8.0),
    REAL_CONST(152471.8343778394/8.0),
    REAL_CONST(152498.18224853161/8.0),
    REAL_CONST(152524.53125733617/8.0),
    REAL_CONST(152550.88140415482/8.0),
    REAL_CONST(152577.23268888926/8.0),
    REAL_CONST(152603.58511144121/8.0),
    REAL_CONST(152629.93867171241/8.0),
    REAL_CONST(152656.29336960468/8.0),
    REAL_CONST(152682.64920501978/8.0),
    REAL_CONST(152709.00617785956/8.0),
    REAL_CONST(152735.36428802583/8.0),
    REAL_CONST(152761.72353542043/8.0),
    REAL_CONST(152788.08391994529/8.0),
    REAL_CONST(152814.44544150229/8.0),
    REAL_CONST(152840.80809999333/8.0),
    REAL_CONST(152867.17189532038/8.0),
    REAL_CONST(152893.53682738543/8.0),
    REAL_CONST(152919.90289609041/8.0),
    REAL_CONST(152946.27010133737/8.0),
    REAL_CONST(152972.63844302832/8.0),
    REAL_CONST(152999.00792106529/8.0),
    REAL_CONST(153025.37853535041/8.0),
    REAL_CONST(153051.7502857857/8.0),
    REAL_CONST(153078.12317227334/8.0),
    REAL_CONST(153104.4971947154/8.0),
    REAL_CONST(153130.8723530141/8.0),
    REAL_CONST(153157.24864707157/8.0),
    REAL_CONST(153183.62607679001/8.0),
    REAL_CONST(153210.00464207167/8.0),
    REAL_CONST(153236.38434281875/8.0),
    REAL_CONST(153262.76517893354/8.0),
    REAL_CONST(153289.14715031831/8.0),
    REAL_CONST(153315.53025687535/8.0),
    REAL_CONST(153341.91449850702/8.0),
    REAL_CONST(153368.2998751156/8.0),
    REAL_CONST(153394.68638660354/8.0),
    REAL_CONST(153421.07403287315/8.0),
    REAL_CONST(153447.46281382689/8.0),
    REAL_CONST(153473.85272936718/8.0),
    REAL_CONST(153500.24377939643/8.0),
    REAL_CONST(153526.63596381716/8.0),
    REAL_CONST(153553.02928253182/8.0),
    REAL_CONST(153579.42373544298/8.0),
    REAL_CONST(153605.81932245308/8.0),
    REAL_CONST(153632.21604346478/8.0),
    REAL_CONST(153658.61389838057/8.0),
    REAL_CONST(153685.0128871031/8.0),
    REAL_CONST(153711.41300953497/8.0),
    REAL_CONST(153737.81426557881/8.0),
    REAL_CONST(153764.21665513728/8.0),
    REAL_CONST(153790.62017811305/8.0),
    REAL_CONST(153817.02483440886/8.0),
    REAL_CONST(153843.43062392739/8.0),
    REAL_CONST(153869.83754657139/8.0),
    REAL_CONST(153896.24560224367/8.0),
    REAL_CONST(153922.65479084692/8.0),
    REAL_CONST(153949.06511228404/8.0),
    REAL_CONST(153975.4765664578/8.0),
    REAL_CONST(154001.88915327107/8.0),
    REAL_CONST(154028.30287262669/8.0),
    REAL_CONST(154054.71772442761/8.0),
    REAL_CONST(154081.13370857667/8.0),
    REAL_CONST(154107.55082497682/8.0),
    REAL_CONST(154133.96907353101/8.0),
    REAL_CONST(154160.38845414223/8.0),
    REAL_CONST(154186.80896671346/8.0),
    REAL_CONST(154213.23061114774/8.0),
    REAL_CONST(154239.65338734805/8.0),
    REAL_CONST(154266.07729521746/8.0),
    REAL_CONST(154292.50233465908/8.0),
    REAL_CONST(154318.92850557598/8.0),
    REAL_CONST(154345.35580787127/8.0),
    REAL_CONST(154371.7842414481/8.0),
    REAL_CONST(154398.21380620965/8.0),
    REAL_CONST(154424.64450205903/8.0),
    REAL_CONST(154451.07632889951/8.0),
    REAL_CONST(154477.50928663427/8.0),
    REAL_CONST(154503.94337516659/8.0),
    REAL_CONST(154530.37859439969/8.0),
    REAL_CONST(154556.81494423689/8.0),
    REAL_CONST(154583.25242458144/8.0),
    REAL_CONST(154609.69103533673/8.0),
    REAL_CONST(154636.13077640603/8.0),
    REAL_CONST(154662.57164769279/8.0),
    REAL_CONST(154689.01364910032/8.0),
    REAL_CONST(154715.45678053208/8.0),
    REAL_CONST(154741.90104189145/8.0),
    REAL_CONST(154768.34643308193/8.0),
    REAL_CONST(154794.79295400696/8.0),
    REAL_CONST(154821.24060457002/8.0),
    REAL_CONST(154847.68938467462/8.0),
    REAL_CONST(154874.13929422433/8.0),
    REAL_CONST(154900.59033312264/8.0),
    REAL_CONST(154927.04250127316/8.0),
    REAL_CONST(154953.49579857948/8.0),
    REAL_CONST(154979.95022494521/8.0),
    REAL_CONST(155006.40578027396/8.0),
    REAL_CONST(155032.86246446942/8.0),
    REAL_CONST(155059.32027743524/8.0),
    REAL_CONST(155085.77921907514/8.0),
    REAL_CONST(155112.2392892928/8.0),
    REAL_CONST(155138.70048799197/8.0),
    REAL_CONST(155165.16281507642/8.0),
    REAL_CONST(155191.62627044989/8.0),
    REAL_CONST(155218.09085401625/8.0),
    REAL_CONST(155244.55656567923/8.0),
    REAL_CONST(155271.02340534274/8.0),
    REAL_CONST(155297.49137291059/8.0),
    REAL_CONST(155323.96046828668/8.0),
    REAL_CONST(155350.4306913749/8.0),
    REAL_CONST(155376.90204207919/8.0),
    REAL_CONST(155403.37452030348/8.0),
    REAL_CONST(155429.84812595171/8.0),
    REAL_CONST(155456.32285892789/8.0),
    REAL_CONST(155482.79871913602/8.0),
    REAL_CONST(155509.27570648011/8.0),
    REAL_CONST(155535.75382086422/8.0),
    REAL_CONST(155562.23306219239/8.0),
    REAL_CONST(155588.71343036872/8.0),
    REAL_CONST(155615.19492529731/8.0),
    REAL_CONST(155641.67754688227/8.0),
    REAL_CONST(155668.16129502779/8.0),
    REAL_CONST(155694.64616963797/8.0),
    REAL_CONST(155721.13217061706/8.0),
    REAL_CONST(155747.61929786921/8.0),
    REAL_CONST(155774.10755129869/8.0),
    REAL_CONST(155800.59693080973/8.0),
    REAL_CONST(155827.08743630661/8.0),
    REAL_CONST(155853.57906769359/8.0),
    REAL_CONST(155880.07182487496/8.0),
    REAL_CONST(155906.56570775513/8.0),
    REAL_CONST(155933.06071623837/8.0),
    REAL_CONST(155959.55685022907/8.0),
    REAL_CONST(155986.05410963166/8.0),
    REAL_CONST(156012.5524943505/8.0),
    REAL_CONST(156039.05200429002/8.0),
    REAL_CONST(156065.55263935472/8.0),
    REAL_CONST(156092.054399449/8.0),
    REAL_CONST(156118.5572844774/8.0),
    REAL_CONST(156145.06129434443/8.0),
    REAL_CONST(156171.5664289546/8.0),
    REAL_CONST(156198.07268821247/8.0),
    REAL_CONST(156224.5800720226/8.0),
    REAL_CONST(156251.08858028959/8.0),
    REAL_CONST(156277.59821291809/8.0),
    REAL_CONST(156304.10896981266/8.0),
    REAL_CONST(156330.62085087801/8.0),
    REAL_CONST(156357.1338560188/8.0),
    REAL_CONST(156383.64798513969/8.0),
    REAL_CONST(156410.16323814544/8.0),
    REAL_CONST(156436.67961494075/8.0),
    REAL_CONST(156463.1971154304/8.0),
    REAL_CONST(156489.71573951913/8.0),
    REAL_CONST(156516.23548711176/8.0),
    REAL_CONST(156542.75635811311/8.0),
    REAL_CONST(156569.27835242799/8.0),
    REAL_CONST(156595.80146996127/8.0),
    REAL_CONST(156622.32571061782/8.0),
    REAL_CONST(156648.85107430254/8.0),
    REAL_CONST(156675.37756092031/8.0),
    REAL_CONST(156701.90517037612/8.0),
    REAL_CONST(156728.43390257491/8.0),
    REAL_CONST(156754.96375742162/8.0),
    REAL_CONST(156781.49473482129/8.0),
    REAL_CONST(156808.02683467892/8.0),
    REAL_CONST(156834.5600568995/8.0),
    REAL_CONST(156861.09440138817/8.0),
    REAL_CONST(156887.62986804993/8.0),
    REAL_CONST(156914.16645678994/8.0),
    REAL_CONST(156940.70416751326/8.0),
    REAL_CONST(156967.24300012505/8.0),
    REAL_CONST(156993.78295453047/8.0),
    REAL_CONST(157020.32403063469/8.0),
    REAL_CONST(157046.8662283429/8.0),
    REAL_CONST(157073.40954756032/8.0),
    REAL_CONST(157099.9539881922/8.0),
    REAL_CONST(157126.49955014378/8.0),
    REAL_CONST(157153.04623332032/8.0),
    REAL_CONST(157179.59403762716/8.0),
    REAL_CONST(157206.14296296958/8.0),
    REAL_CONST(157232.69300925292/8.0),
    REAL_CONST(157259.24417638258/8.0),
    REAL_CONST(157285.79646426387/8.0),
    REAL_CONST(157312.34987280221/8.0),
    REAL_CONST(157338.90440190304/8.0),
    REAL_CONST(157365.46005147175/8.0),
    REAL_CONST(157392.01682141385/8.0),
    REAL_CONST(157418.57471163478/8.0),
    REAL_CONST(157445.13372204005/8.0),
    REAL_CONST(157471.69385253513/8.0),
    REAL_CONST(157498.25510302564/8.0),
    REAL_CONST(157524.81747341706/8.0),
    REAL_CONST(157551.38096361503/8.0),
    REAL_CONST(157577.9455735251/8.0),
    REAL_CONST(157604.51130305286/8.0),
    REAL_CONST(157631.07815210402/8.0),
    REAL_CONST(157657.64612058419/8.0),
    REAL_CONST(157684.21520839902/8.0),
    REAL_CONST(157710.78541545427/8.0),
    REAL_CONST(157737.35674165559/8.0),
    REAL_CONST(157763.92918690876/8.0),
    REAL_CONST(157790.50275111952/8.0),
    REAL_CONST(157817.07743419363/8.0),
    REAL_CONST(157843.65323603692/8.0),
    REAL_CONST(157870.23015655516/8.0),
    REAL_CONST(157896.80819565422/8.0),
    REAL_CONST(157923.3873532399/8.0),
    REAL_CONST(157949.96762921812/8.0),
    REAL_CONST(157976.54902349479/8.0),
    REAL_CONST(158003.13153597576/8.0),
    REAL_CONST(158029.71516656701/8.0),
    REAL_CONST(158056.29991517449/8.0),
    REAL_CONST(158082.88578170416/8.0),
    REAL_CONST(158109.47276606198/8.0),
    REAL_CONST(158136.06086815402/8.0),
    REAL_CONST(158162.65008788629/8.0),
    REAL_CONST(158189.24042516484/8.0),
    REAL_CONST(158215.83187989573/8.0),
    REAL_CONST(158242.42445198505/8.0),
    REAL_CONST(158269.01814133892/8.0),
    REAL_CONST(158295.61294786347/8.0),
    REAL_CONST(158322.20887146486/8.0),
    REAL_CONST(158348.80591204923/8.0),
    REAL_CONST(158375.4040695228/8.0),
    REAL_CONST(158402.00334379176/8.0),
    REAL_CONST(158428.60373476235/8.0),
    REAL_CONST(158455.2052423408/8.0),
    REAL_CONST(158481.80786643337/8.0),
    REAL_CONST(158508.41160694641/8.0),
    REAL_CONST(158535.01646378616/8.0),
    REAL_CONST(158561.62243685898/8.0),
    REAL_CONST(158588.2295260712/8.0),
    REAL_CONST(158614.8377313292/8.0),
    REAL_CONST(158641.44705253936/8.0),
    REAL_CONST(158668.05748960807/8.0),
    REAL_CONST(158694.66904244179/8.0),
    REAL_CONST(158721.28171094693/8.0),
    REAL_CONST(158747.89549502998/8.0),
    REAL_CONST(158774.5103945974/8.0),
    REAL_CONST(158801.12640955573/8.0),
    REAL_CONST(158827.74353981143/8.0),
    REAL_CONST(158854.36178527112/8.0),
    REAL_CONST(158880.9811458413/8.0),
    REAL_CONST(158907.60162142856/8.0),
    REAL_CONST(158934.22321193956/8.0),
    REAL_CONST(158960.84591728085/8.0),
    REAL_CONST(158987.46973735912/8.0),
    REAL_CONST(159014.09467208097/8.0),
    REAL_CONST(159040.72072135314/8.0),
    REAL_CONST(159067.3478850823/8.0),
    REAL_CONST(159093.97616317519/8.0),
    REAL_CONST(159120.60555553852/8.0),
    REAL_CONST(159147.23606207906/8.0),
    REAL_CONST(159173.8676827036/8.0),
    REAL_CONST(159200.50041731889/8.0),
    REAL_CONST(159227.13426583182/8.0),
    REAL_CONST(159253.76922814918/8.0),
    REAL_CONST(159280.40530417781/8.0),
    REAL_CONST(159307.04249382461/8.0),
    REAL_CONST(159333.68079699649/8.0),
    REAL_CONST(159360.32021360032/8.0),
    REAL_CONST(159386.96074354305/8.0),
    REAL_CONST(159413.60238673165/8.0),
    REAL_CONST(159440.24514307309/8.0),
    REAL_CONST(159466.88901247433/8.0),
    REAL_CONST(159493.53399484244/8.0),
    REAL_CONST(159520.18009008438/8.0),
    REAL_CONST(159546.82729810724/8.0),
    REAL_CONST(159573.47561881805/8.0),
    REAL_CONST(159600.12505212394/8.0),
    REAL_CONST(159626.77559793202/8.0),
    REAL_CONST(159653.42725614941/8.0),
    REAL_CONST(159680.08002668325/8.0),
    REAL_CONST(159706.73390944069/8.0),
    REAL_CONST(159733.38890432892/8.0),
    REAL_CONST(159760.04501125516/8.0),
    REAL_CONST(159786.70223012666/8.0),
    REAL_CONST(159813.36056085059/8.0),
    REAL_CONST(159840.02000333427/8.0),
    REAL_CONST(159866.68055748497/8.0),
    REAL_CONST(159893.34222320997/8.0),
    REAL_CONST(159920.00500041663/8.0),
    REAL_CONST(159946.66888901225/8.0),
    REAL_CONST(159973.33388890422/8.0),
    REAL_CONST(159999.99999999988/8.0),
    REAL_CONST(160026.66722220668/8.0),
    REAL_CONST(160053.33555543202/8.0),
    REAL_CONST(160080.0049995833/8.0),
    REAL_CONST(160106.67555456801/8.0),
    REAL_CONST(160133.3472202936/8.0),
    REAL_CONST(160160.0199966676/8.0),
    REAL_CONST(160186.6938835975/8.0),
    REAL_CONST(160213.36888099083/8.0),
    REAL_CONST(160240.04498875517/8.0),
    REAL_CONST(160266.72220679806/8.0),
    REAL_CONST(160293.40053502709/8.0),
    REAL_CONST(160320.07997334987/8.0),
    REAL_CONST(160346.76052167406/8.0),
    REAL_CONST(160373.44217990729/8.0),
    REAL_CONST(160400.1249479572/8.0),
    REAL_CONST(160426.80882573154/8.0),
    REAL_CONST(160453.49381313793/8.0),
    REAL_CONST(160480.17991008417/8.0),
    REAL_CONST(160506.86711647795/8.0),
    REAL_CONST(160533.55543222709/8.0),
    REAL_CONST(160560.24485723933/8.0),
    REAL_CONST(160586.93539142248/8.0),
    REAL_CONST(160613.62703468435/8.0),
    REAL_CONST(160640.31978693281/8.0),
    REAL_CONST(160667.01364807569/8.0),
    REAL_CONST(160693.70861802087/8.0),
    REAL_CONST(160720.40469667627/8.0),
    REAL_CONST(160747.1018839498/8.0),
    REAL_CONST(160773.80017974938/8.0),
    REAL_CONST(160800.49958398298/8.0),
    REAL_CONST(160827.20009655855/8.0),
    REAL_CONST(160853.90171738411/8.0),
    REAL_CONST(160880.60444636765/8.0),
    REAL_CONST(160907.30828341722/8.0),
    REAL_CONST(160934.01322844089/8.0),
    REAL_CONST(160960.71928134665/8.0),
    REAL_CONST(160987.42644204266/8.0),
    REAL_CONST(161014.13471043704/8.0),
    REAL_CONST(161040.84408643784/8.0),
    REAL_CONST(161067.55456995327/8.0),
    REAL_CONST(161094.26616089148/8.0),
    REAL_CONST(161120.97885916062/8.0),
    REAL_CONST(161147.69266466892/8.0),
    REAL_CONST(161174.40757732463/8.0),
    REAL_CONST(161201.12359703594/8.0),
    REAL_CONST(161227.84072371112/8.0),
    REAL_CONST(161254.55895725847/8.0),
    REAL_CONST(161281.27829758628/8.0),
    REAL_CONST(161307.99874460287/8.0),
    REAL_CONST(161334.72029821656/8.0),
    REAL_CONST(161361.44295833571/8.0),
    REAL_CONST(161388.1667248687/8.0),
    REAL_CONST(161414.89159772391/8.0),
    REAL_CONST(161441.61757680977/8.0),
    REAL_CONST(161468.34466203468/8.0),
    REAL_CONST(161495.07285330712/8.0),
    REAL_CONST(161521.80215053557/8.0),
    REAL_CONST(161548.53255362847/8.0),
    REAL_CONST(161575.26406249436/8.0),
    REAL_CONST(161601.99667704175/8.0),
    REAL_CONST(161628.7303971792/8.0),
    REAL_CONST(161655.46522281526/8.0),
    REAL_CONST(161682.20115385848/8.0),
    REAL_CONST(161708.93819021754/8.0),
    REAL_CONST(161735.67633180099/8.0),
    REAL_CONST(161762.41557851751/8.0),
    REAL_CONST(161789.15593027571/8.0),
    REAL_CONST(161815.89738698432/8.0),
    REAL_CONST(161842.63994855201/8.0),
    REAL_CONST(161869.38361488748/8.0),
    REAL_CONST(161896.1283858995/8.0),
    REAL_CONST(161922.87426149679/8.0),
    REAL_CONST(161949.62124158812/8.0),
    REAL_CONST(161976.36932608229/8.0),
    REAL_CONST(162003.1185148881/8.0),
    REAL_CONST(162029.8688079144/8.0),
    REAL_CONST(162056.62020507001/8.0),
    REAL_CONST(162083.37270626382/8.0),
    REAL_CONST(162110.12631140469/8.0),
    REAL_CONST(162136.88102040152/8.0),
    REAL_CONST(162163.63683316324/8.0),
    REAL_CONST(162190.39374959879/8.0),
    REAL_CONST(162217.15176961714/8.0),
    REAL_CONST(162243.91089312723/8.0),
    REAL_CONST(162270.67112003808/8.0),
    REAL_CONST(162297.43245025873/8.0),
    REAL_CONST(162324.19488369819/8.0),
    REAL_CONST(162350.9584202655/8.0),
    REAL_CONST(162377.72305986975/8.0),
    REAL_CONST(162404.48880242003/8.0),
    REAL_CONST(162431.25564782543/8.0),
    REAL_CONST(162458.02359599507/8.0),
    REAL_CONST(162484.79264683815/8.0),
    REAL_CONST(162511.56280026378/8.0),
    REAL_CONST(162538.33405618116/8.0),
    REAL_CONST(162565.10641449949/8.0),
    REAL_CONST(162591.87987512801/8.0),
    REAL_CONST(162618.65443797593/8.0),
    REAL_CONST(162645.43010295252/8.0),
    REAL_CONST(162672.20686996708/8.0),
    REAL_CONST(162698.98473892888/8.0),
    REAL_CONST(162725.76370974723/8.0),
    REAL_CONST(162752.54378233149/8.0),
    REAL_CONST(162779.32495659095/8.0),
    REAL_CONST(162806.10723243505/8.0),
    REAL_CONST(162832.89060977317/8.0),
    REAL_CONST(162859.67508851466/8.0),
    REAL_CONST(162886.46066856899/8.0),
    REAL_CONST(162913.24734984562/8.0),
    REAL_CONST(162940.03513225398/8.0),
    REAL_CONST(162966.82401570358/8.0),
    REAL_CONST(162993.6140001039/8.0),
    REAL_CONST(163020.40508536444/8.0),
    REAL_CONST(163047.19727139481/8.0),
    REAL_CONST(163073.99055810447/8.0),
    REAL_CONST(163100.78494540305/8.0),
    REAL_CONST(163127.58043320014/8.0),
    REAL_CONST(163154.37702140535/8.0),
    REAL_CONST(163181.17470992831/8.0),
    REAL_CONST(163207.97349867865/8.0),
    REAL_CONST(163234.77338756606/8.0),
    REAL_CONST(163261.57437650024/8.0),
    REAL_CONST(163288.37646539087/8.0),
    REAL_CONST(163315.17965414765/8.0),
    REAL_CONST(163341.98394268038/8.0),
    REAL_CONST(163368.78933089875/8.0),
    REAL_CONST(163395.59581871261/8.0),
    REAL_CONST(163422.40340603172/8.0),
    REAL_CONST(163449.2120927659/8.0),
    REAL_CONST(163476.02187882498/8.0),
    REAL_CONST(163502.83276411882/8.0),
    REAL_CONST(163529.6447485573/8.0),
    REAL_CONST(163556.45783205028/8.0),
    REAL_CONST(163583.2720145077/8.0),
    REAL_CONST(163610.08729583945/8.0),
    REAL_CONST(163636.90367595552/8.0),
    REAL_CONST(163663.72115476584/8.0),
    REAL_CONST(163690.53973218042/8.0),
    REAL_CONST(163717.35940810922/8.0),
    REAL_CONST(163744.18018246227/8.0),
    REAL_CONST(163771.00205514964/8.0),
    REAL_CONST(163797.82502608138/8.0),
    REAL_CONST(163824.64909516752/8.0),
    REAL_CONST(163851.4742623182/8.0),
    REAL_CONST(163878.3005274435/8.0),
    REAL_CONST(163905.12789045356/8.0),
    REAL_CONST(163931.95635125853/8.0),
    REAL_CONST(163958.78590976857/8.0),
    REAL_CONST(163985.61656589387/8.0),
    REAL_CONST(164012.44831954464/8.0),
    REAL_CONST(164039.28117063109/8.0),
    REAL_CONST(164066.11511906344/8.0),
    REAL_CONST(164092.95016475199/8.0),
    REAL_CONST(164119.78630760699/8.0),
    REAL_CONST(164146.62354753874/8.0),
    REAL_CONST(164173.46188445756/8.0),
    REAL_CONST(164200.30131827376/8.0),
    REAL_CONST(164227.14184889771/8.0),
    REAL_CONST(164253.98347623978/8.0),
    REAL_CONST(164280.82620021031/8.0),
    REAL_CONST(164307.67002071979/8.0),
    REAL_CONST(164334.51493767856/8.0),
    REAL_CONST(164361.3609509971/8.0),
    REAL_CONST(164388.20806058586/8.0),
    REAL_CONST(164415.05626635533/8.0),
    REAL_CONST(164441.905568216/8.0),
    REAL_CONST(164468.75596607837/8.0),
    REAL_CONST(164495.607459853/8.0),
    REAL_CONST(164522.4600494504/8.0),
    REAL_CONST(164549.31373478117/8.0),
    REAL_CONST(164576.16851575591/8.0),
    REAL_CONST(164603.02439228518/8.0),
    REAL_CONST(164629.88136427966/8.0),
    REAL_CONST(164656.73943164994/8.0),
    REAL_CONST(164683.59859430668/8.0),
    REAL_CONST(164710.45885216061/8.0),
    REAL_CONST(164737.32020512238/8.0),
    REAL_CONST(164764.1826531027/8.0),
    REAL_CONST(164791.04619601235/8.0),
    REAL_CONST(164817.91083376206/8.0),
    REAL_CONST(164844.77656626256/8.0),
    REAL_CONST(164871.64339342469/8.0),
    REAL_CONST(164898.51131515924/8.0),
    REAL_CONST(164925.38033137703/8.0),
    REAL_CONST(164952.25044198887/8.0),
    REAL_CONST(164979.1216469057/8.0),
    REAL_CONST(165005.9939460383/8.0),
    REAL_CONST(165032.86733929763/8.0),
    REAL_CONST(165059.7418265946/8.0),
    REAL_CONST(165086.61740784015/8.0),
    REAL_CONST(165113.4940829452/8.0)
#endif
};

#endif

#ifdef __cplusplus
}
#endif
#endif
