/*

Memory Mapped Files Emulation Layer v1.75
(c) 1998, 1999 Maurilio Longo - md2520@mclink.it

*/

#ifndef _SYS_MMAN_H		/* As per miyata@kusm.kyoto-u.ac.jp suggestion */
#define _SYS_MMAN_H
#define _MMAP_DECLARED
#if defined (__cplusplus)
extern "C" {
#endif

#define INCL_DOSEXCEPTIONS
#include <os2.h>

typedef EXCEPTIONREGISTRATIONRECORD mmap_reg_t;

#define HAVE_MSYNC	0x1
#define MSYNC_3		0x1
#define	PROT_READ	0x0001
#define	PROT_WRITE	0x0002
#define	PROT_EXEC	0x0004
#define	PROT_NONE	0x0000
#define	MAP_SHARED	0x1
#define	MAP_PRIVATE	0x2
#define MAP_FAILED ((void *) -1)
#define MAP_ANONYMOUS 0x20
#define	MAP_FIXED	0x10
#define	MCL_CURRENT	0x1
#define	MCL_FUTURE	0x2
#define	MS_ASYNC	0x1
#define	MS_INVALIDATE   0x2
#define MS_SYNC		0x4

#define	MS_MUNMAP	0x10     /* not standard, used internally by munmap() */


int	_System	getpagesize(void);
int	_System	mprotect(caddr_t pAddr, int cbLen, int fProtection);
int	_System	mlockall(int fFlags);
caddr_t	_System mmap(caddr_t pAddr, size_t cbLen, int fProtection, int fFlags, int hFile, off_t cbOffset);
int	_System	msync(caddr_t pAddr, int cbLen, int fFlags);
int	_System	munlockall(void);
int	_System	munmap(caddr_t pAddr, int cbLen);
int	_System	merror(void);
int     _System mregister(mmap_reg_t *pReg);
int     _System mderegister(mmap_reg_t *pReg);

#if defined (__cplusplus)
}
#endif
#endif /* not _SYS_MMAN_H */
