/*
** FAAD2 - Freeware Advanced Audio (AAC) Decoder including SBR decoding
** Copyright (C) 2003-2004 M. Bakker, Ahead Software AG, http://www.nero.com
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
** Any non-GPL usage of this software or parts of this software is strictly
** forbidden.
**
** Commercial non-GPL licensing of this software is possible.
** For more info contact Ahead Software through Mpeg4AAClicense@nero.com.
**
** $Id: ps_tables.h,v 1.1 2005/04/22 13:35:28 vladest Exp $
**/

#ifndef __PS_TABLES_H__
#define __PS_TABLES_H__

#ifdef __cplusplus
extern "C" {
#endif

#ifdef _MSC_VER
#pragma warning(disable:4305)
#pragma warning(disable:4244)
#endif

#if 0
#if 0
float f_center_20[12] = {
    0.5/4,  1.5/4,  2.5/4,  3.5/4,
    4.5/4*0,  5.5/4*0, -1.5/4, -0.5/4,
    3.5/2,  2.5/2,  4.5/2,  5.5/2
};
#else
float f_center_20[12] = {
    0.5/8,  1.5/8,  2.5/8,  3.5/8,
    4.5/8*0,  5.5/8*0, -1.5/8, -0.5/8,
    3.5/4,  2.5/4,  4.5/4,  5.5/4
};
#endif

float f_center_34[32] = {
    1/12,   3/12,   5/12,   7/12,
    9/12,  11/12,  13/12,  15/12,
    17/12, -5/12,  -3/12,  -1/12,
    17/8,   19/8,    5/8,    7/8,
    9/8,    11/8,   13/8,   15/8,
    9/4,    11/4,   13/4,    7/4,
    17/4,   11/4,   13/4,   15/4,
    17/4,   19/4,   21/4,   15/4
};

static const real_t frac_delay_q[] = {
    FRAC_CONST(0.43),
    FRAC_CONST(0.75),
    FRAC_CONST(0.347)
};
#endif

/* RE(ps->Phi_Fract_Qmf[j]) = (float)cos(M_PI*(j+0.5)*(0.39)); */
/* IM(ps->Phi_Fract_Qmf[j]) = (float)sin(M_PI*(j+0.5)*(0.39)); */
static const complex_t Phi_Fract_Qmf[] = {
    { FRAC_CONST(0.8181497455), FRAC_CONST(0.5750052333) },
    { FRAC_CONST(-0.2638730407), FRAC_CONST(0.9645574093) },
    { FRAC_CONST(-0.9969173074), FRAC_CONST(0.0784590989) },
    { FRAC_CONST(-0.4115143716), FRAC_CONST(-0.9114032984) },
    { FRAC_CONST(0.7181262970), FRAC_CONST(-0.6959127784) },
    { FRAC_CONST(0.8980275989), FRAC_CONST(0.4399391711) },
    { FRAC_CONST(-0.1097343117), FRAC_CONST(0.9939609766) },
    { FRAC_CONST(-0.9723699093), FRAC_CONST(0.2334453613) },
    { FRAC_CONST(-0.5490227938), FRAC_CONST(-0.8358073831) },
    { FRAC_CONST(0.6004202366), FRAC_CONST(-0.7996846437) },
    { FRAC_CONST(0.9557930231), FRAC_CONST(0.2940403223) },
    { FRAC_CONST(0.0471064523), FRAC_CONST(0.9988898635) },
    { FRAC_CONST(-0.9238795042), FRAC_CONST(0.3826834261) },
    { FRAC_CONST(-0.6730124950), FRAC_CONST(-0.7396311164) },
    { FRAC_CONST(0.4679298103), FRAC_CONST(-0.8837656379) },
    { FRAC_CONST(0.9900236726), FRAC_CONST(0.1409012377) },
    { FRAC_CONST(0.2027872950), FRAC_CONST(0.9792228341) },
    { FRAC_CONST(-0.8526401520), FRAC_CONST(0.5224985480) },
    { FRAC_CONST(-0.7804304361), FRAC_CONST(-0.6252426505) },
    { FRAC_CONST(0.3239174187), FRAC_CONST(-0.9460853338) },
    { FRAC_CONST(0.9998766184), FRAC_CONST(-0.0157073177) },
    { FRAC_CONST(0.3534748554), FRAC_CONST(0.9354440570) },
    { FRAC_CONST(-0.7604059577), FRAC_CONST(0.6494480371) },
    { FRAC_CONST(-0.8686315417), FRAC_CONST(-0.4954586625) },
    { FRAC_CONST(0.1719291061), FRAC_CONST(-0.9851093292) },
    { FRAC_CONST(0.9851093292), FRAC_CONST(-0.1719291061) },
    { FRAC_CONST(0.4954586625), FRAC_CONST(0.8686315417) },
    { FRAC_CONST(-0.6494480371), FRAC_CONST(0.7604059577) },
    { FRAC_CONST(-0.9354440570), FRAC_CONST(-0.3534748554) },
    { FRAC_CONST(0.0157073177), FRAC_CONST(-0.9998766184) },
    { FRAC_CONST(0.9460853338), FRAC_CONST(-0.3239174187) },
    { FRAC_CONST(0.6252426505), FRAC_CONST(0.7804304361) },
    { FRAC_CONST(-0.5224985480), FRAC_CONST(0.8526401520) },
    { FRAC_CONST(-0.9792228341), FRAC_CONST(-0.2027872950) },
    { FRAC_CONST(-0.1409012377), FRAC_CONST(-0.9900236726) },
    { FRAC_CONST(0.8837656379), FRAC_CONST(-0.4679298103) },
    { FRAC_CONST(0.7396311164), FRAC_CONST(0.6730124950) },
    { FRAC_CONST(-0.3826834261), FRAC_CONST(0.9238795042) },
    { FRAC_CONST(-0.9988898635), FRAC_CONST(-0.0471064523) },
    { FRAC_CONST(-0.2940403223), FRAC_CONST(-0.9557930231) },
    { FRAC_CONST(0.7996846437), FRAC_CONST(-0.6004202366) },
    { FRAC_CONST(0.8358073831), FRAC_CONST(0.5490227938) },
    { FRAC_CONST(-0.2334453613), FRAC_CONST(0.9723699093) },
    { FRAC_CONST(-0.9939609766), FRAC_CONST(0.1097343117) },
    { FRAC_CONST(-0.4399391711), FRAC_CONST(-0.8980275989) },
    { FRAC_CONST(0.6959127784), FRAC_CONST(-0.7181262970) },
    { FRAC_CONST(0.9114032984), FRAC_CONST(0.4115143716) },
    { FRAC_CONST(-0.0784590989), FRAC_CONST(0.9969173074) },
    { FRAC_CONST(-0.9645574093), FRAC_CONST(0.2638730407) },
    { FRAC_CONST(-0.5750052333), FRAC_CONST(-0.8181497455) },
    { FRAC_CONST(0.5750052333), FRAC_CONST(-0.8181497455) },
    { FRAC_CONST(0.9645574093), FRAC_CONST(0.2638730407) },
    { FRAC_CONST(0.0784590989), FRAC_CONST(0.9969173074) },
    { FRAC_CONST(-0.9114032984), FRAC_CONST(0.4115143716) },
    { FRAC_CONST(-0.6959127784), FRAC_CONST(-0.7181262970) },
    { FRAC_CONST(0.4399391711), FRAC_CONST(-0.8980275989) },
    { FRAC_CONST(0.9939609766), FRAC_CONST(0.1097343117) },
    { FRAC_CONST(0.2334453613), FRAC_CONST(0.9723699093) },
    { FRAC_CONST(-0.8358073831), FRAC_CONST(0.5490227938) },
    { FRAC_CONST(-0.7996846437), FRAC_CONST(-0.6004202366) },
    { FRAC_CONST(0.2940403223), FRAC_CONST(-0.9557930231) },
    { FRAC_CONST(0.9988898635), FRAC_CONST(-0.0471064523) },
    { FRAC_CONST(0.3826834261), FRAC_CONST(0.9238795042) },
    { FRAC_CONST(-0.7396311164), FRAC_CONST(0.6730124950) }
};

/* RE(Phi_Fract_SubQmf20[j]) = (float)cos(M_PI*f_center_20[j]*0.39); */
/* IM(Phi_Fract_SubQmf20[j]) = (float)sin(M_PI*f_center_20[j]*0.39); */
static const complex_t Phi_Fract_SubQmf20[] = {
    { FRAC_CONST(0.9882950187), FRAC_CONST(0.1525546312) },
    { FRAC_CONST(0.8962930441), FRAC_CONST(0.4434623122) },
    { FRAC_CONST(0.7208535671), FRAC_CONST(0.6930873394) },
    { FRAC_CONST(0.4783087075), FRAC_CONST(0.8781917691) },
    { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) },
    { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) },
    { FRAC_CONST(0.8962930441), FRAC_CONST(-0.4434623122) },
    { FRAC_CONST(0.9882950187), FRAC_CONST(-0.1525546312) },
    { FRAC_CONST(-0.5424415469), FRAC_CONST(0.8400935531) },
    { FRAC_CONST(0.0392598175), FRAC_CONST(0.9992290139) },
    { FRAC_CONST(-0.9268565774), FRAC_CONST(0.3754155636) },
    { FRAC_CONST(-0.9741733670), FRAC_CONST(-0.2258012742) }
};

/* RE(Phi_Fract_SubQmf34[j]) = (float)cos(M_PI*f_center_34[j]*0.39); */
/* IM(Phi_Fract_SubQmf34[j]) = (float)sin(M_PI*f_center_34[j]*0.39); */
static const complex_t Phi_Fract_SubQmf34[] = {
    { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) },
    { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) },
    { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) },
    { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) },
    { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) },
    { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) },
    { FRAC_CONST(0.3387379348), FRAC_CONST(0.9408807755) },
    { FRAC_CONST(0.3387379348), FRAC_CONST(0.9408807755) },
    { FRAC_CONST(0.3387379348), FRAC_CONST(0.9408807755) },
    { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) },
    { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) },
    { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) },
    { FRAC_CONST(-0.7705132365), FRAC_CONST(0.6374239922) },
    { FRAC_CONST(-0.7705132365), FRAC_CONST(0.6374239922) },
    { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) },
    { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) },
    { FRAC_CONST(0.3387379348), FRAC_CONST(0.9408807755) },
    { FRAC_CONST(0.3387379348), FRAC_CONST(0.9408807755) },
    { FRAC_CONST(0.3387379348), FRAC_CONST(0.9408807755) },
    { FRAC_CONST(0.3387379348), FRAC_CONST(0.9408807755) },
    { FRAC_CONST(-0.7705132365), FRAC_CONST(0.6374239922) },
    { FRAC_CONST(-0.7705132365), FRAC_CONST(0.6374239922) },
    { FRAC_CONST(-0.8607420325), FRAC_CONST(-0.5090414286) },
    { FRAC_CONST(0.3387379348), FRAC_CONST(0.9408807755) },
    { FRAC_CONST(0.1873813123), FRAC_CONST(-0.9822872281) },
    { FRAC_CONST(-0.7705132365), FRAC_CONST(0.6374239922) },
    { FRAC_CONST(-0.8607420325), FRAC_CONST(-0.5090414286) },
    { FRAC_CONST(-0.8607420325), FRAC_CONST(-0.5090414286) },
    { FRAC_CONST(0.1873813123), FRAC_CONST(-0.9822872281) },
    { FRAC_CONST(0.1873813123), FRAC_CONST(-0.9822872281) },
    { FRAC_CONST(0.9876883626), FRAC_CONST(-0.1564344615) },
    { FRAC_CONST(-0.8607420325), FRAC_CONST(-0.5090414286) }
};

/* RE(Q_Fract_allpass_Qmf[j][i]) = (float)cos(M_PI*(j+0.5)*(frac_delay_q[i])); */
/* IM(Q_Fract_allpass_Qmf[j][i]) = (float)sin(M_PI*(j+0.5)*(frac_delay_q[i])); */
static const complex_t Q_Fract_allpass_Qmf[][3] = {
    { { FRAC_CONST(0.7804303765), FRAC_CONST(0.6252426505) }, { FRAC_CONST(0.3826834261), FRAC_CONST(0.9238795042) }, { FRAC_CONST(0.8550928831), FRAC_CONST(0.5184748173) } },
    { { FRAC_CONST(-0.4399392009), FRAC_CONST(0.8980275393) }, { FRAC_CONST(-0.9238795042), FRAC_CONST(-0.3826834261) }, { FRAC_CONST(-0.0643581524), FRAC_CONST(0.9979268909) } },
    { { FRAC_CONST(-0.9723699093), FRAC_CONST(-0.2334454209) }, { FRAC_CONST(0.9238795042), FRAC_CONST(-0.3826834261) }, { FRAC_CONST(-0.9146071672), FRAC_CONST(0.4043435752) } },
    { { FRAC_CONST(0.0157073960), FRAC_CONST(-0.9998766184) }, { FRAC_CONST(-0.3826834261), FRAC_CONST(0.9238795042) }, { FRAC_CONST(-0.7814115286), FRAC_CONST(-0.6240159869) } },
    { { FRAC_CONST(0.9792228341), FRAC_CONST(-0.2027871907) }, { FRAC_CONST(-0.3826834261), FRAC_CONST(-0.9238795042) }, { FRAC_CONST(0.1920081824), FRAC_CONST(-0.9813933372) } },
    { { FRAC_CONST(0.4115142524), FRAC_CONST(0.9114032984) }, { FRAC_CONST(0.9238795042), FRAC_CONST(0.3826834261) }, { FRAC_CONST(0.9589683414), FRAC_CONST(-0.2835132182) } },
    { { FRAC_CONST(-0.7996847630), FRAC_CONST(0.6004201174) }, { FRAC_CONST(-0.9238795042), FRAC_CONST(0.3826834261) }, { FRAC_CONST(0.6947838664), FRAC_CONST(0.7192186117) } },
    { { FRAC_CONST(-0.7604058385), FRAC_CONST(-0.6494481564) }, { FRAC_CONST(0.3826834261), FRAC_CONST(-0.9238795042) }, { FRAC_CONST(-0.3164770305), FRAC_CONST(0.9486001730) } },
    { { FRAC_CONST(0.4679299891), FRAC_CONST(-0.8837655187) }, { FRAC_CONST(0.3826834261), FRAC_CONST(0.9238795042) }, { FRAC_CONST(-0.9874414206), FRAC_CONST(0.1579856575) } },
    { { FRAC_CONST(0.9645573497), FRAC_CONST(0.2638732493) }, { FRAC_CONST(-0.9238795042), FRAC_CONST(-0.3826834261) }, { FRAC_CONST(-0.5966450572), FRAC_CONST(-0.8025052547) } },
    { { FRAC_CONST(-0.0471066870), FRAC_CONST(0.9988898635) }, { FRAC_CONST(0.9238795042), FRAC_CONST(-0.3826834261) }, { FRAC_CONST(0.4357025325), FRAC_CONST(-0.9000906944) } },
    { { FRAC_CONST(-0.9851093888), FRAC_CONST(0.1719288528) }, { FRAC_CONST(-0.3826834261), FRAC_CONST(0.9238795042) }, { FRAC_CONST(0.9995546937), FRAC_CONST(-0.0298405960) } },
    { { FRAC_CONST(-0.3826831877), FRAC_CONST(-0.9238796234) }, { FRAC_CONST(-0.3826834261), FRAC_CONST(-0.9238795042) }, { FRAC_CONST(0.4886211455), FRAC_CONST(0.8724960685) } },
    { { FRAC_CONST(0.8181498647), FRAC_CONST(-0.5750049949) }, { FRAC_CONST(0.9238795042), FRAC_CONST(0.3826834261) }, { FRAC_CONST(-0.5477093458), FRAC_CONST(0.8366686702) } },
    { { FRAC_CONST(0.7396308780), FRAC_CONST(0.6730127335) }, { FRAC_CONST(-0.9238795042), FRAC_CONST(0.3826834261) }, { FRAC_CONST(-0.9951074123), FRAC_CONST(-0.0987988561) } },
    { { FRAC_CONST(-0.4954589605), FRAC_CONST(0.8686313629) }, { FRAC_CONST(0.3826834261), FRAC_CONST(-0.9238795042) }, { FRAC_CONST(-0.3725017905), FRAC_CONST(-0.9280315042) } },
    { { FRAC_CONST(-0.9557929039), FRAC_CONST(-0.2940406799) }, { FRAC_CONST(0.3826834261), FRAC_CONST(0.9238795042) }, { FRAC_CONST(0.6506417990), FRAC_CONST(-0.7593847513) } },
    { { FRAC_CONST(0.0784594864), FRAC_CONST(-0.9969173074) }, { FRAC_CONST(-0.9238795042), FRAC_CONST(-0.3826834261) }, { FRAC_CONST(0.9741733670), FRAC_CONST(0.2258014232) } },
    { { FRAC_CONST(0.9900237322), FRAC_CONST(-0.1409008205) }, { FRAC_CONST(0.9238795042), FRAC_CONST(-0.3826834261) }, { FRAC_CONST(0.2502108514), FRAC_CONST(0.9681913853) } },
    { { FRAC_CONST(0.3534744382), FRAC_CONST(0.9354441762) }, { FRAC_CONST(-0.3826834261), FRAC_CONST(0.9238795042) }, { FRAC_CONST(-0.7427945137), FRAC_CONST(0.6695194840) } },
    { { FRAC_CONST(-0.8358076215), FRAC_CONST(0.5490224361) }, { FRAC_CONST(-0.3826834261), FRAC_CONST(-0.9238795042) }, { FRAC_CONST(-0.9370992780), FRAC_CONST(-0.3490629196) } },
    { { FRAC_CONST(-0.7181259394), FRAC_CONST(-0.6959131360) }, { FRAC_CONST(0.9238795042), FRAC_CONST(0.3826834261) }, { FRAC_CONST(-0.1237744763), FRAC_CONST(-0.9923103452) } },
    { { FRAC_CONST(0.5224990249), FRAC_CONST(-0.8526399136) }, { FRAC_CONST(-0.9238795042), FRAC_CONST(0.3826834261) }, { FRAC_CONST(0.8226406574), FRAC_CONST(-0.5685616732) } },
    { { FRAC_CONST(0.9460852146), FRAC_CONST(0.3239179254) }, { FRAC_CONST(0.3826834261), FRAC_CONST(-0.9238795042) }, { FRAC_CONST(0.8844994903), FRAC_CONST(0.4665412009) } },
    { { FRAC_CONST(-0.1097348556), FRAC_CONST(0.9939609170) }, { FRAC_CONST(0.3826834261), FRAC_CONST(0.9238795042) }, { FRAC_CONST(-0.0047125919), FRAC_CONST(0.9999889135) } },
    { { FRAC_CONST(-0.9939610362), FRAC_CONST(0.1097337380) }, { FRAC_CONST(-0.9238795042), FRAC_CONST(-0.3826834261) }, { FRAC_CONST(-0.8888573647), FRAC_CONST(0.4581840038) } },
    { { FRAC_CONST(-0.3239168525), FRAC_CONST(-0.9460855722) }, { FRAC_CONST(0.9238795042), FRAC_CONST(-0.3826834261) }, { FRAC_CONST(-0.8172453642), FRAC_CONST(-0.5762898922) } },
    { { FRAC_CONST(0.8526405096), FRAC_CONST(-0.5224980116) }, { FRAC_CONST(-0.3826834261), FRAC_CONST(0.9238795042) }, { FRAC_CONST(0.1331215799), FRAC_CONST(-0.9910997152) } },
    { { FRAC_CONST(0.6959123611), FRAC_CONST(0.7181267142) }, { FRAC_CONST(-0.3826834261), FRAC_CONST(-0.9238795042) }, { FRAC_CONST(0.9403476119), FRAC_CONST(-0.3402152061) } },
    { { FRAC_CONST(-0.5490233898), FRAC_CONST(0.8358070254) }, { FRAC_CONST(0.9238795042), FRAC_CONST(0.3826834261) }, { FRAC_CONST(0.7364512086), FRAC_CONST(0.6764906645) } },
    { { FRAC_CONST(-0.9354437590), FRAC_CONST(-0.3534754813) }, { FRAC_CONST(-0.9238795042), FRAC_CONST(0.3826834261) }, { FRAC_CONST(-0.2593250275), FRAC_CONST(0.9657900929) } },
    { { FRAC_CONST(0.1409019381), FRAC_CONST(-0.9900235534) }, { FRAC_CONST(0.3826834261), FRAC_CONST(-0.9238795042) }, { FRAC_CONST(-0.9762582779), FRAC_CONST(0.2166097313) } },
    { { FRAC_CONST(0.9969173670), FRAC_CONST(-0.0784583688) }, { FRAC_CONST(0.3826834261), FRAC_CONST(0.9238795042) }, { FRAC_CONST(-0.6434556246), FRAC_CONST(-0.7654833794) } },
    { { FRAC_CONST(0.2940396070), FRAC_CONST(0.9557932615) }, { FRAC_CONST(-0.9238795042), FRAC_CONST(-0.3826834261) }, { FRAC_CONST(0.3812320232), FRAC_CONST(-0.9244794250) } },
    { { FRAC_CONST(-0.8686318994), FRAC_CONST(0.4954580069) }, { FRAC_CONST(0.9238795042), FRAC_CONST(-0.3826834261) }, { FRAC_CONST(0.9959943891), FRAC_CONST(-0.0894154981) } },
    { { FRAC_CONST(-0.6730118990), FRAC_CONST(-0.7396316528) }, { FRAC_CONST(-0.3826834261), FRAC_CONST(0.9238795042) }, { FRAC_CONST(0.5397993922), FRAC_CONST(0.8417937160) } },
    { { FRAC_CONST(0.5750059485), FRAC_CONST(-0.8181492686) }, { FRAC_CONST(-0.3826834261), FRAC_CONST(-0.9238795042) }, { FRAC_CONST(-0.4968227744), FRAC_CONST(0.8678520322) } },
    { { FRAC_CONST(0.9238792062), FRAC_CONST(0.3826842010) }, { FRAC_CONST(0.9238795042), FRAC_CONST(0.3826834261) }, { FRAC_CONST(-0.9992290139), FRAC_CONST(-0.0392601527) } },
    { { FRAC_CONST(-0.1719299555), FRAC_CONST(0.9851091504) }, { FRAC_CONST(-0.9238795042), FRAC_CONST(0.3826834261) }, { FRAC_CONST(-0.4271997511), FRAC_CONST(-0.9041572809) } },
    { { FRAC_CONST(-0.9988899231), FRAC_CONST(0.0471055657) }, { FRAC_CONST(0.3826834261), FRAC_CONST(-0.9238795042) }, { FRAC_CONST(0.6041822433), FRAC_CONST(-0.7968461514) } },
    { { FRAC_CONST(-0.2638721764), FRAC_CONST(-0.9645576477) }, { FRAC_CONST(0.3826834261), FRAC_CONST(0.9238795042) }, { FRAC_CONST(0.9859085083), FRAC_CONST(0.1672853529) } },
    { { FRAC_CONST(0.8837660551), FRAC_CONST(-0.4679289758) }, { FRAC_CONST(-0.9238795042), FRAC_CONST(-0.3826834261) }, { FRAC_CONST(0.3075223565), FRAC_CONST(0.9515408874) } },
    { { FRAC_CONST(0.6494473219), FRAC_CONST(0.7604066133) }, { FRAC_CONST(0.9238795042), FRAC_CONST(-0.3826834261) }, { FRAC_CONST(-0.7015317082), FRAC_CONST(0.7126382589) } },
    { { FRAC_CONST(-0.6004210114), FRAC_CONST(0.7996840477) }, { FRAC_CONST(-0.3826834261), FRAC_CONST(0.9238795042) }, { FRAC_CONST(-0.9562535882), FRAC_CONST(-0.2925389707) } },
    { { FRAC_CONST(-0.9114028811), FRAC_CONST(-0.4115152657) }, { FRAC_CONST(-0.3826834261), FRAC_CONST(-0.9238795042) }, { FRAC_CONST(-0.1827499419), FRAC_CONST(-0.9831594229) } },
    { { FRAC_CONST(0.2027882934), FRAC_CONST(-0.9792225957) }, { FRAC_CONST(0.9238795042), FRAC_CONST(0.3826834261) }, { FRAC_CONST(0.7872582674), FRAC_CONST(-0.6166234016) } },
    { { FRAC_CONST(0.9998766780), FRAC_CONST(-0.0157062728) }, { FRAC_CONST(-0.9238795042), FRAC_CONST(0.3826834261) }, { FRAC_CONST(0.9107555747), FRAC_CONST(0.4129458666) } },
    { { FRAC_CONST(0.2334443331), FRAC_CONST(0.9723701477) }, { FRAC_CONST(0.3826834261), FRAC_CONST(-0.9238795042) }, { FRAC_CONST(0.0549497530), FRAC_CONST(0.9984891415) } },
    { { FRAC_CONST(-0.8980280757), FRAC_CONST(0.4399381876) }, { FRAC_CONST(0.3826834261), FRAC_CONST(0.9238795042) }, { FRAC_CONST(-0.8599416018), FRAC_CONST(0.5103924870) } },
    { { FRAC_CONST(-0.6252418160), FRAC_CONST(-0.7804310918) }, { FRAC_CONST(-0.9238795042), FRAC_CONST(-0.3826834261) }, { FRAC_CONST(-0.8501682281), FRAC_CONST(-0.5265110731) } },
    { { FRAC_CONST(0.6252435446), FRAC_CONST(-0.7804297209) }, { FRAC_CONST(0.9238795042), FRAC_CONST(-0.3826834261) }, { FRAC_CONST(0.0737608299), FRAC_CONST(-0.9972759485) } },
    { { FRAC_CONST(0.8980270624), FRAC_CONST(0.4399402142) }, { FRAC_CONST(-0.3826834261), FRAC_CONST(0.9238795042) }, { FRAC_CONST(0.9183775187), FRAC_CONST(-0.3957053721) } },
    { { FRAC_CONST(-0.2334465086), FRAC_CONST(0.9723696709) }, { FRAC_CONST(-0.3826834261), FRAC_CONST(-0.9238795042) }, { FRAC_CONST(0.7754954696), FRAC_CONST(0.6313531399) } },
    { { FRAC_CONST(-0.9998766184), FRAC_CONST(-0.0157085191) }, { FRAC_CONST(0.9238795042), FRAC_CONST(0.3826834261) }, { FRAC_CONST(-0.2012493610), FRAC_CONST(0.9795400500) } },
    { { FRAC_CONST(-0.2027861029), FRAC_CONST(-0.9792230725) }, { FRAC_CONST(-0.9238795042), FRAC_CONST(0.3826834261) }, { FRAC_CONST(-0.9615978599), FRAC_CONST(0.2744622827) } },
    { { FRAC_CONST(0.9114037752), FRAC_CONST(-0.4115132093) }, { FRAC_CONST(0.3826834261), FRAC_CONST(-0.9238795042) }, { FRAC_CONST(-0.6879743338), FRAC_CONST(-0.7257350087) } },
    { { FRAC_CONST(0.6004192233), FRAC_CONST(0.7996854186) }, { FRAC_CONST(0.3826834261), FRAC_CONST(0.9238795042) }, { FRAC_CONST(0.3254036009), FRAC_CONST(-0.9455752373) } },
    { { FRAC_CONST(-0.6494490504), FRAC_CONST(0.7604051232) }, { FRAC_CONST(-0.9238795042), FRAC_CONST(-0.3826834261) }, { FRAC_CONST(0.9888865948), FRAC_CONST(-0.1486719251) } },
    { { FRAC_CONST(-0.8837650418), FRAC_CONST(-0.4679309726) }, { FRAC_CONST(0.9238795042), FRAC_CONST(-0.3826834261) }, { FRAC_CONST(0.5890548825), FRAC_CONST(0.8080930114) } },
    { { FRAC_CONST(0.2638743520), FRAC_CONST(-0.9645570517) }, { FRAC_CONST(-0.3826834261), FRAC_CONST(0.9238795042) }, { FRAC_CONST(-0.4441666007), FRAC_CONST(0.8959442377) } },
    { { FRAC_CONST(0.9988898039), FRAC_CONST(0.0471078083) }, { FRAC_CONST(-0.3826834261), FRAC_CONST(-0.9238795042) }, { FRAC_CONST(-0.9997915030), FRAC_CONST(0.0204183888) } },
    { { FRAC_CONST(0.1719277352), FRAC_CONST(0.9851095676) }, { FRAC_CONST(0.9238795042), FRAC_CONST(0.3826834261) }, { FRAC_CONST(-0.4803760946), FRAC_CONST(-0.8770626187) } },
    { { FRAC_CONST(-0.9238800406), FRAC_CONST(0.3826821446) }, { FRAC_CONST(-0.9238795042), FRAC_CONST(0.3826834261) }, { FRAC_CONST(0.5555707216), FRAC_CONST(-0.8314692974) } },
    { { FRAC_CONST(-0.5750041008), FRAC_CONST(-0.8181505203) }, { FRAC_CONST(0.3826834261), FRAC_CONST(-0.9238795042) }, { FRAC_CONST(0.9941320419), FRAC_CONST(0.1081734300) } }
};

/* RE(Q_Fract_allpass_SubQmf20[j][i]) = (float)cos(M_PI*f_center_20[j]*frac_delay_q[i]); */
/* IM(Q_Fract_allpass_SubQmf20[j][i]) = (float)sin(M_PI*f_center_20[j]*frac_delay_q[i]); */
static const complex_t Q_Fract_allpass_SubQmf20[][3] = {
    { { FRAC_CONST(0.9857769012), FRAC_CONST(0.1680592746) }, { FRAC_CONST(0.9569403529), FRAC_CONST(0.2902846634) }, { FRAC_CONST(0.9907300472), FRAC_CONST(0.1358452588) } },
    { { FRAC_CONST(0.8744080663), FRAC_CONST(0.4851911962) }, { FRAC_CONST(0.6343932748), FRAC_CONST(0.7730104327) }, { FRAC_CONST(0.9175986052), FRAC_CONST(0.3975082636) } },
    { { FRAC_CONST(0.6642524004), FRAC_CONST(0.7475083470) }, { FRAC_CONST(0.0980171412), FRAC_CONST(0.9951847196) }, { FRAC_CONST(0.7767338753), FRAC_CONST(0.6298289299) } },
    { { FRAC_CONST(0.3790524006), FRAC_CONST(0.9253752232) }, { FRAC_CONST(-0.4713967443), FRAC_CONST(0.8819212914) }, { FRAC_CONST(0.5785340071), FRAC_CONST(0.8156582713) } },
    { { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) } },
    { { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) } },
    { { FRAC_CONST(0.8744080663), FRAC_CONST(-0.4851911962) }, { FRAC_CONST(0.6343932748), FRAC_CONST(-0.7730104327) }, { FRAC_CONST(0.9175986052), FRAC_CONST(-0.3975082636) } },
    { { FRAC_CONST(0.9857769012), FRAC_CONST(-0.1680592746) }, { FRAC_CONST(0.9569403529), FRAC_CONST(-0.2902846634) }, { FRAC_CONST(0.9907300472), FRAC_CONST(-0.1358452588) } },
    { { FRAC_CONST(-0.7126385570), FRAC_CONST(0.7015314102) }, { FRAC_CONST(-0.5555702448), FRAC_CONST(-0.8314695954) }, { FRAC_CONST(-0.3305967748), FRAC_CONST(0.9437720776) } },
    { { FRAC_CONST(-0.1175374240), FRAC_CONST(0.9930684566) }, { FRAC_CONST(-0.9807852507), FRAC_CONST(0.1950903237) }, { FRAC_CONST(0.2066311091), FRAC_CONST(0.9784189463) } },
    { { FRAC_CONST(-0.9947921634), FRAC_CONST(0.1019244045) }, { FRAC_CONST(0.5555702448), FRAC_CONST(-0.8314695954) }, { FRAC_CONST(-0.7720130086), FRAC_CONST(0.6356067061) } },
    { { FRAC_CONST(-0.8400934935), FRAC_CONST(-0.5424416065) }, { FRAC_CONST(0.9807852507), FRAC_CONST(0.1950903237) }, { FRAC_CONST(-0.9896889329), FRAC_CONST(0.1432335079) } }
};

/* RE(Q_Fract_allpass_SubQmf34[j][i]) = (float)cos(M_PI*f_center_34[j]*frac_delay_q[i]); */
/* IM(Q_Fract_allpass_SubQmf34[j][i]) = (float)sin(M_PI*f_center_34[j]*frac_delay_q[i]); */
static const complex_t Q_Fract_allpass_SubQmf34[][3] = {
    { { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) } },
    { { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) } },
    { { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) } },
    { { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) } },
    { { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) } },
    { { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) } },
    { { FRAC_CONST(0.2181432247), FRAC_CONST(0.9759167433) }, { FRAC_CONST(-0.7071067691), FRAC_CONST(0.7071067691) }, { FRAC_CONST(0.4623677433), FRAC_CONST(0.8866882324) } },
    { { FRAC_CONST(0.2181432247), FRAC_CONST(0.9759167433) }, { FRAC_CONST(-0.7071067691), FRAC_CONST(0.7071067691) }, { FRAC_CONST(0.4623677433), FRAC_CONST(0.8866882324) } },
    { { FRAC_CONST(0.2181432247), FRAC_CONST(0.9759167433) }, { FRAC_CONST(-0.7071067691), FRAC_CONST(0.7071067691) }, { FRAC_CONST(0.4623677433), FRAC_CONST(0.8866882324) } },
    { { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) } },
    { { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) } },
    { { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) } },
    { { FRAC_CONST(-0.9048270583), FRAC_CONST(0.4257792532) }, { FRAC_CONST(-0.0000000000), FRAC_CONST(-1.0000000000) }, { FRAC_CONST(-0.5724321604), FRAC_CONST(0.8199520707) } },
    { { FRAC_CONST(-0.9048270583), FRAC_CONST(0.4257792532) }, { FRAC_CONST(-0.0000000000), FRAC_CONST(-1.0000000000) }, { FRAC_CONST(-0.5724321604), FRAC_CONST(0.8199520707) } },
    { { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) } },
    { { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(1.0000000000), FRAC_CONST(0.0000000000) } },
    { { FRAC_CONST(0.2181432247), FRAC_CONST(0.9759167433) }, { FRAC_CONST(-0.7071067691), FRAC_CONST(0.7071067691) }, { FRAC_CONST(0.4623677433), FRAC_CONST(0.8866882324) } },
    { { FRAC_CONST(0.2181432247), FRAC_CONST(0.9759167433) }, { FRAC_CONST(-0.7071067691), FRAC_CONST(0.7071067691) }, { FRAC_CONST(0.4623677433), FRAC_CONST(0.8866882324) } },
    { { FRAC_CONST(0.2181432247), FRAC_CONST(0.9759167433) }, { FRAC_CONST(-0.7071067691), FRAC_CONST(0.7071067691) }, { FRAC_CONST(0.4623677433), FRAC_CONST(0.8866882324) } },
    { { FRAC_CONST(0.2181432247), FRAC_CONST(0.9759167433) }, { FRAC_CONST(-0.7071067691), FRAC_CONST(0.7071067691) }, { FRAC_CONST(0.4623677433), FRAC_CONST(0.8866882324) } },
    { { FRAC_CONST(-0.9048270583), FRAC_CONST(0.4257792532) }, { FRAC_CONST(-0.0000000000), FRAC_CONST(-1.0000000000) }, { FRAC_CONST(-0.5724321604), FRAC_CONST(0.8199520707) } },
    { { FRAC_CONST(-0.9048270583), FRAC_CONST(0.4257792532) }, { FRAC_CONST(-0.0000000000), FRAC_CONST(-1.0000000000) }, { FRAC_CONST(-0.5724321604), FRAC_CONST(0.8199520707) } },
    { { FRAC_CONST(-0.6129069924), FRAC_CONST(-0.7901550531) }, { FRAC_CONST(0.7071067691), FRAC_CONST(0.7071067691) }, { FRAC_CONST(-0.9917160273), FRAC_CONST(-0.1284494549) } },
    { { FRAC_CONST(0.2181432247), FRAC_CONST(0.9759167433) }, { FRAC_CONST(-0.7071067691), FRAC_CONST(0.7071067691) }, { FRAC_CONST(0.4623677433), FRAC_CONST(0.8866882324) } },
    { { FRAC_CONST(0.6374240518), FRAC_CONST(-0.7705131769) }, { FRAC_CONST(-1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(-0.3446428776), FRAC_CONST(-0.9387338758) } },
    { { FRAC_CONST(-0.9048270583), FRAC_CONST(0.4257792532) }, { FRAC_CONST(-0.0000000000), FRAC_CONST(-1.0000000000) }, { FRAC_CONST(-0.5724321604), FRAC_CONST(0.8199520707) } },
    { { FRAC_CONST(-0.6129069924), FRAC_CONST(-0.7901550531) }, { FRAC_CONST(0.7071067691), FRAC_CONST(0.7071067691) }, { FRAC_CONST(-0.9917160273), FRAC_CONST(-0.1284494549) } },
    { { FRAC_CONST(-0.6129069924), FRAC_CONST(-0.7901550531) }, { FRAC_CONST(0.7071067691), FRAC_CONST(0.7071067691) }, { FRAC_CONST(-0.9917160273), FRAC_CONST(-0.1284494549) } },
    { { FRAC_CONST(0.6374240518), FRAC_CONST(-0.7705131769) }, { FRAC_CONST(-1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(-0.3446428776), FRAC_CONST(-0.9387338758) } },
    { { FRAC_CONST(0.6374240518), FRAC_CONST(-0.7705131769) }, { FRAC_CONST(-1.0000000000), FRAC_CONST(0.0000000000) }, { FRAC_CONST(-0.3446428776), FRAC_CONST(-0.9387338758) } },
    { { FRAC_CONST(0.8910064697), FRAC_CONST(0.4539906085) }, { FRAC_CONST(0.7071067691), FRAC_CONST(-0.7071067691) }, { FRAC_CONST(0.6730125546), FRAC_CONST(-0.7396310568) } },
    { { FRAC_CONST(-0.6129069924), FRAC_CONST(-0.7901550531) }, { FRAC_CONST(0.7071067691), FRAC_CONST(0.7071067691) }, { FRAC_CONST(-0.9917160273), FRAC_CONST(-0.1284494549) } }
};

#if 0
static float quant_rho[8] =
{
    FRAC_CONST(1.0), FRAC_CONST(0.937), FRAC_CONST(0.84118), FRAC_CONST(0.60092),
    FRAC_CONST(0.36764), FRAC_CONST(0.0), FRAC_CONST(-0.589), FRAC_CONST(-1.0)
};

static const uint8_t quant_iid_normal[7] =
{
    2, 4, 7, 10, 14, 18, 25
};

static const uint8_t quant_iid_fine[15] =
{
    2, 4, 6, 8, 10, 13, 16, 19, 22, 25, 30, 35, 40, 45, 50
};
#endif

static const real_t cos_alphas[] = {
    COEF_CONST(1.0000000000), COEF_CONST(0.9841239700), COEF_CONST(0.9594738210),
    COEF_CONST(0.8946843079), COEF_CONST(0.8269340931), COEF_CONST(0.7071067812),
    COEF_CONST(0.4533210856), COEF_CONST(0.0000000000)
};

static const real_t sin_alphas[] = {
    COEF_CONST(0.0000000000), COEF_CONST(0.1774824264), COEF_CONST(0.2817977763),
    COEF_CONST(0.4466989918), COEF_CONST(0.5622988580), COEF_CONST(0.7071067812),
    COEF_CONST(0.8913472911), COEF_CONST(1.0000000000)
};

static const real_t cos_betas_normal[][8] = {
    { COEF_CONST(1.0000000000), COEF_CONST(1.0000000000), COEF_CONST(1.0000000000), COEF_CONST(1.0000000000), COEF_CONST(1.0000000000), COEF_CONST(1.0000000000), COEF_CONST(1.0000000000), COEF_CONST(1.0000000000) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9995871699), COEF_CONST(0.9989419133), COEF_CONST(0.9972204583), COEF_CONST(0.9953790839), COEF_CONST(0.9920112747), COEF_CONST(0.9843408180), COEF_CONST(0.9681727381) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9984497744), COEF_CONST(0.9960279377), COEF_CONST(0.9895738413), COEF_CONST(0.9826814632), COEF_CONST(0.9701058164), COEF_CONST(0.9416098832), COEF_CONST(0.8822105900) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9959398908), COEF_CONST(0.9896038018), COEF_CONST(0.9727589768), COEF_CONST(0.9548355329), COEF_CONST(0.9223070404), COEF_CONST(0.8494349490), COEF_CONST(0.7013005535) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9932417400), COEF_CONST(0.9827071856), COEF_CONST(0.9547730996), COEF_CONST(0.9251668930), COEF_CONST(0.8717461589), COEF_CONST(0.7535520592), COEF_CONST(0.5198827312) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9902068095), COEF_CONST(0.9749613872), COEF_CONST(0.9346538534), COEF_CONST(0.8921231300), COEF_CONST(0.8158851259), COEF_CONST(0.6495964302), COEF_CONST(0.3313370772) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9880510933), COEF_CONST(0.9694670261), COEF_CONST(0.9204347876), COEF_CONST(0.8688622825), COEF_CONST(0.7768516704), COEF_CONST(0.5782161800), COEF_CONST(0.2069970356) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9858996945), COEF_CONST(0.9639898866), COEF_CONST(0.9063034786), COEF_CONST(0.8458214608), COEF_CONST(0.7384262300), COEF_CONST(0.5089811277), COEF_CONST(0.0905465944) }
};

static const real_t sin_betas_normal[][8] = {
    { COEF_CONST(0.0000000000), COEF_CONST(0.0000000000), COEF_CONST(0.0000000000), COEF_CONST(0.0000000000), COEF_CONST(0.0000000000), COEF_CONST(0.0000000000), COEF_CONST(0.0000000000), COEF_CONST(0.0000000000) },
    { COEF_CONST(0.0000000000), COEF_CONST(-0.0287313368), COEF_CONST(-0.0459897147), COEF_CONST(-0.0745074328), COEF_CONST(-0.0960233266), COEF_CONST(-0.1261492408), COEF_CONST(-0.1762757894), COEF_CONST(-0.2502829383) },
    { COEF_CONST(0.0000000000), COEF_CONST(-0.0556601118), COEF_CONST(-0.0890412670), COEF_CONST(-0.1440264301), COEF_CONST(-0.1853028382), COEF_CONST(-0.2426823129), COEF_CONST(-0.3367058477), COEF_CONST(-0.4708550466) },
    { COEF_CONST(0.0000000000), COEF_CONST(-0.0900207420), COEF_CONST(-0.1438204281), COEF_CONST(-0.2318188366), COEF_CONST(-0.2971348264), COEF_CONST(-0.3864579191), COEF_CONST(-0.5276933461), COEF_CONST(-0.7128657193) },
    { COEF_CONST(0.0000000000), COEF_CONST(-0.1160639735), COEF_CONST(-0.1851663774), COEF_CONST(-0.2973353800), COEF_CONST(-0.3795605619), COEF_CONST(-0.4899577884), COEF_CONST(-0.6573882369), COEF_CONST(-0.8542376401) },
    { COEF_CONST(0.0000000000), COEF_CONST(-0.1396082894), COEF_CONST(-0.2223742196), COEF_CONST(-0.3555589603), COEF_CONST(-0.4517923427), COEF_CONST(-0.5782140273), COEF_CONST(-0.7602792104), COEF_CONST(-0.9435124489) },
    { COEF_CONST(0.0000000000), COEF_CONST(-0.1541266914), COEF_CONST(-0.2452217065), COEF_CONST(-0.3908961522), COEF_CONST(-0.4950538699), COEF_CONST(-0.6296836366), COEF_CONST(-0.8158836002), COEF_CONST(-0.9783415698) },
    { COEF_CONST(0.0000000000), COEF_CONST(-0.1673373610), COEF_CONST(-0.2659389001), COEF_CONST(-0.4226275012), COEF_CONST(-0.5334660781), COEF_CONST(-0.6743342664), COEF_CONST(-0.8607776784), COEF_CONST(-0.9958922202) }
};

static const real_t cos_betas_fine[][8] = {
    { COEF_CONST(1.0000000000), COEF_CONST(1.0000000000), COEF_CONST(1.0000000000), COEF_CONST(1.0000000000), COEF_CONST(1.0000000000), COEF_CONST(1.0000000000), COEF_CONST(1.0000000000), COEF_CONST(1.0000000000) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9995871699), COEF_CONST(0.9989419133), COEF_CONST(0.9972204583), COEF_CONST(0.9953790839), COEF_CONST(0.9920112747), COEF_CONST(0.9843408180), COEF_CONST(0.9681727381) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9984497744), COEF_CONST(0.9960279377), COEF_CONST(0.9895738413), COEF_CONST(0.9826814632), COEF_CONST(0.9701058164), COEF_CONST(0.9416098832), COEF_CONST(0.8822105900) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9968361371), COEF_CONST(0.9918968104), COEF_CONST(0.9787540479), COEF_CONST(0.9647515190), COEF_CONST(0.9392903010), COEF_CONST(0.8820167114), COEF_CONST(0.7645325390) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9950262915), COEF_CONST(0.9872675041), COEF_CONST(0.9666584578), COEF_CONST(0.9447588606), COEF_CONST(0.9050918405), COEF_CONST(0.8165997379), COEF_CONST(0.6383824796) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9932417400), COEF_CONST(0.9827071856), COEF_CONST(0.9547730996), COEF_CONST(0.9251668930), COEF_CONST(0.8717461589), COEF_CONST(0.7535520592), COEF_CONST(0.5198827312) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9908827998), COEF_CONST(0.9766855904), COEF_CONST(0.9391249214), COEF_CONST(0.8994531782), COEF_CONST(0.8282352693), COEF_CONST(0.6723983174), COEF_CONST(0.3719473225) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9890240165), COEF_CONST(0.9719459866), COEF_CONST(0.9268448110), COEF_CONST(0.8793388536), COEF_CONST(0.7944023271), COEF_CONST(0.6101812098), COEF_CONST(0.2621501145) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9876350461), COEF_CONST(0.9684073447), COEF_CONST(0.9176973944), COEF_CONST(0.8643930070), COEF_CONST(0.7693796058), COEF_CONST(0.5646720713), COEF_CONST(0.1838899556) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9866247085), COEF_CONST(0.9658349704), COEF_CONST(0.9110590761), COEF_CONST(0.8535668048), COEF_CONST(0.7513165426), COEF_CONST(0.5320914819), COEF_CONST(0.1289530943) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9858996945), COEF_CONST(0.9639898866), COEF_CONST(0.9063034786), COEF_CONST(0.8458214608), COEF_CONST(0.7384262300), COEF_CONST(0.5089811277), COEF_CONST(0.0905465944) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9851245614), COEF_CONST(0.9620180268), COEF_CONST(0.9012265590), COEF_CONST(0.8375623272), COEF_CONST(0.7247108045), COEF_CONST(0.4845204297), COEF_CONST(0.0504115003) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9846869856), COEF_CONST(0.9609052357), COEF_CONST(0.8983639533), COEF_CONST(0.8329098386), COEF_CONST(0.7169983441), COEF_CONST(0.4708245354), COEF_CONST(0.0281732509) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9844406325), COEF_CONST(0.9602788522), COEF_CONST(0.8967533934), COEF_CONST(0.8302936455), COEF_CONST(0.7126658102), COEF_CONST(0.4631492839), COEF_CONST(0.0157851140) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9843020502), COEF_CONST(0.9599265269), COEF_CONST(0.8958477331), COEF_CONST(0.8288229094), COEF_CONST(0.7102315840), COEF_CONST(0.4588429315), COEF_CONST(0.0088578059) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9842241136), COEF_CONST(0.9597283916), COEF_CONST(0.8953385094), COEF_CONST(0.8279961409), COEF_CONST(0.7088635748), COEF_CONST(0.4564246834), COEF_CONST(0.0049751355) }
};

static const real_t sin_betas_fine[][8] = {
    { COEF_CONST(0.0000000000), COEF_CONST(0.0000000000), COEF_CONST(0.0000000000), COEF_CONST(0.0000000000), COEF_CONST(0.0000000000), COEF_CONST(0.0000000000), COEF_CONST(0.0000000000), COEF_CONST(0.0000000000) },
    { COEF_CONST(0.0000000000), COEF_CONST(-0.0287313368), COEF_CONST(-0.0459897147), COEF_CONST(-0.0745074328), COEF_CONST(-0.0960233266), COEF_CONST(-0.1261492408), COEF_CONST(-0.1762757894), COEF_CONST(-0.2502829383) },
    { COEF_CONST(0.0000000000), COEF_CONST(-0.0556601118), COEF_CONST(-0.0890412670), COEF_CONST(-0.1440264301), COEF_CONST(-0.1853028382), COEF_CONST(-0.2426823129), COEF_CONST(-0.3367058477), COEF_CONST(-0.4708550466) },
    { COEF_CONST(0.0000000000), COEF_CONST(-0.0794840594), COEF_CONST(-0.1270461238), COEF_CONST(-0.2050378347), COEF_CONST(-0.2631625097), COEF_CONST(-0.3431234916), COEF_CONST(-0.4712181245), COEF_CONST(-0.6445851354) },
    { COEF_CONST(0.0000000000), COEF_CONST(-0.0996126459), COEF_CONST(-0.1590687758), COEF_CONST(-0.2560691819), COEF_CONST(-0.3277662204), COEF_CONST(-0.4252161335), COEF_CONST(-0.5772043556), COEF_CONST(-0.7697193058) },
    { COEF_CONST(0.0000000000), COEF_CONST(-0.1160639735), COEF_CONST(-0.1851663774), COEF_CONST(-0.2973353800), COEF_CONST(-0.3795605619), COEF_CONST(-0.4899577884), COEF_CONST(-0.6573882369), COEF_CONST(-0.8542376401) },
    { COEF_CONST(0.0000000000), COEF_CONST(-0.1347266752), COEF_CONST(-0.2146747714), COEF_CONST(-0.3435758752), COEF_CONST(-0.4370171396), COEF_CONST(-0.5603805303), COEF_CONST(-0.7401895046), COEF_CONST(-0.9282538388) },
    { COEF_CONST(0.0000000000), COEF_CONST(-0.1477548470), COEF_CONST(-0.2352041647), COEF_CONST(-0.3754446647), COEF_CONST(-0.4761965776), COEF_CONST(-0.6073919186), COEF_CONST(-0.7922618830), COEF_CONST(-0.9650271071) },
    { COEF_CONST(0.0000000000), COEF_CONST(-0.1567705832), COEF_CONST(-0.2493736450), COEF_CONST(-0.3972801182), COEF_CONST(-0.5028167951), COEF_CONST(-0.6387918458), COEF_CONST(-0.8253153651), COEF_CONST(-0.9829468369) },
    { COEF_CONST(0.0000000000), COEF_CONST(-0.1630082348), COEF_CONST(-0.2591578860), COEF_CONST(-0.4122758299), COEF_CONST(-0.5209834064), COEF_CONST(-0.6599420072), COEF_CONST(-0.8466868694), COEF_CONST(-0.9916506943) },
    { COEF_CONST(0.0000000000), COEF_CONST(-0.1673373610), COEF_CONST(-0.2659389001), COEF_CONST(-0.4226275012), COEF_CONST(-0.5334660781), COEF_CONST(-0.6743342664), COEF_CONST(-0.8607776784), COEF_CONST(-0.9958922202) },
    { COEF_CONST(0.0000000000), COEF_CONST(-0.1718417832), COEF_CONST(-0.2729859267), COEF_CONST(-0.4333482310), COEF_CONST(-0.5463417868), COEF_CONST(-0.6890531546), COEF_CONST(-0.8747799456), COEF_CONST(-0.9987285320) },
    { COEF_CONST(0.0000000000), COEF_CONST(-0.1743316967), COEF_CONST(-0.2768774604), COEF_CONST(-0.4392518725), COEF_CONST(-0.5534087104), COEF_CONST(-0.6970748701), COEF_CONST(-0.8822268738), COEF_CONST(-0.9996030552) },
    { COEF_CONST(0.0000000000), COEF_CONST(-0.1757175038), COEF_CONST(-0.2790421580), COEF_CONST(-0.4425306221), COEF_CONST(-0.5573261722), COEF_CONST(-0.7015037013), COEF_CONST(-0.8862802834), COEF_CONST(-0.9998754073) },
    { COEF_CONST(0.0000000000), COEF_CONST(-0.1764921355), COEF_CONST(-0.2802517850), COEF_CONST(-0.4443611583), COEF_CONST(-0.5595110229), COEF_CONST(-0.7039681080), COEF_CONST(-0.8885173967), COEF_CONST(-0.9999607689) },
    { COEF_CONST(0.0000000000), COEF_CONST(-0.1769262394), COEF_CONST(-0.2809295540), COEF_CONST(-0.4453862969), COEF_CONST(-0.5607337966), COEF_CONST(-0.7053456119), COEF_CONST(-0.8897620516), COEF_CONST(-0.9999876239) }
};

static const real_t sincos_alphas_B_normal[][8] = {
    { COEF_CONST(0.0561454100), COEF_CONST(0.0526385859), COEF_CONST(0.0472937334), COEF_CONST(0.0338410641), COEF_CONST(0.0207261065), COEF_CONST(0.0028205635), COEF_CONST(0.0028205635), COEF_CONST(0.0028205635) },
    { COEF_CONST(0.1249065138), COEF_CONST(0.1173697697), COEF_CONST(0.1057888284), COEF_CONST(0.0761985131), COEF_CONST(0.0468732723), COEF_CONST(0.0063956103), COEF_CONST(0.0063956103), COEF_CONST(0.0063956103) },
    { COEF_CONST(0.1956693050), COEF_CONST(0.1846090179), COEF_CONST(0.1673645109), COEF_CONST(0.1220621836), COEF_CONST(0.0757362479), COEF_CONST(0.0103882630), COEF_CONST(0.0103882630), COEF_CONST(0.0103882630) },
    { COEF_CONST(0.3015113269), COEF_CONST(0.2870525790), COEF_CONST(0.2637738799), COEF_CONST(0.1984573949), COEF_CONST(0.1260749909), COEF_CONST(0.0175600126), COEF_CONST(0.0175600126), COEF_CONST(0.0175600126) },
    { COEF_CONST(0.4078449476), COEF_CONST(0.3929852420), COEF_CONST(0.3680589270), COEF_CONST(0.2911029124), COEF_CONST(0.1934512363), COEF_CONST(0.0278686716), COEF_CONST(0.0278686716), COEF_CONST(0.0278686716) },
    { COEF_CONST(0.5336171261), COEF_CONST(0.5226637762), COEF_CONST(0.5033652606), COEF_CONST(0.4349162672), COEF_CONST(0.3224682122), COEF_CONST(0.0521999036), COEF_CONST(0.0521999036), COEF_CONST(0.0521999036) },
    { COEF_CONST(0.6219832023), COEF_CONST(0.6161847276), COEF_CONST(0.6057251063), COEF_CONST(0.5654342668), COEF_CONST(0.4826149915), COEF_CONST(0.1058044758), COEF_CONST(0.1058044758), COEF_CONST(0.1058044758) },
    { COEF_CONST(0.7071067657), COEF_CONST(0.7071067657), COEF_CONST(0.7071067657), COEF_CONST(0.7071067657), COEF_CONST(0.7071067657), COEF_CONST(0.7071067657), COEF_CONST(0.7071067657), COEF_CONST(0.7071067657) },
    { COEF_CONST(0.7830305572), COEF_CONST(0.7876016373), COEF_CONST(0.7956739618), COEF_CONST(0.8247933372), COEF_CONST(0.8758325942), COEF_CONST(0.9943869542), COEF_CONST(0.9943869542), COEF_CONST(0.9943869542) },
    { COEF_CONST(0.8457261833), COEF_CONST(0.8525388778), COEF_CONST(0.8640737401), COEF_CONST(0.9004708933), COEF_CONST(0.9465802987), COEF_CONST(0.9986366532), COEF_CONST(0.9986366532), COEF_CONST(0.9986366532) },
    { COEF_CONST(0.9130511848), COEF_CONST(0.9195447612), COEF_CONST(0.9298024282), COEF_CONST(0.9566917233), COEF_CONST(0.9811098801), COEF_CONST(0.9996115928), COEF_CONST(0.9996115928), COEF_CONST(0.9996115928) },
    { COEF_CONST(0.9534625907), COEF_CONST(0.9579148236), COEF_CONST(0.9645845234), COEF_CONST(0.9801095128), COEF_CONST(0.9920207064), COEF_CONST(0.9998458099), COEF_CONST(0.9998458099), COEF_CONST(0.9998458099) },
    { COEF_CONST(0.9806699215), COEF_CONST(0.9828120260), COEF_CONST(0.9858950861), COEF_CONST(0.9925224431), COEF_CONST(0.9971278825), COEF_CONST(0.9999460406), COEF_CONST(0.9999460406), COEF_CONST(0.9999460406) },
    { COEF_CONST(0.9921685024), COEF_CONST(0.9930882705), COEF_CONST(0.9943886135), COEF_CONST(0.9970926648), COEF_CONST(0.9989008403), COEF_CONST(0.9999795479), COEF_CONST(0.9999795479), COEF_CONST(0.9999795479) },
    { COEF_CONST(0.9984226014), COEF_CONST(0.9986136287), COEF_CONST(0.9988810254), COEF_CONST(0.9994272242), COEF_CONST(0.9997851906), COEF_CONST(0.9999960221), COEF_CONST(0.9999960221), COEF_CONST(0.9999960221) }
};

static const real_t sincos_alphas_B_fine[][8] = {
    { COEF_CONST(0.0031622158), COEF_CONST(0.0029630181), COEF_CONST(0.0026599892), COEF_CONST(0.0019002704), COEF_CONST(0.0011626042), COEF_CONST(0.0001580278), COEF_CONST(0.0001580278), COEF_CONST(0.0001580278) },
    { COEF_CONST(0.0056232673), COEF_CONST(0.0052689825), COEF_CONST(0.0047302825), COEF_CONST(0.0033791756), COEF_CONST(0.0020674015), COEF_CONST(0.0002811710), COEF_CONST(0.0002811710), COEF_CONST(0.0002811710) },
    { COEF_CONST(0.0099994225), COEF_CONST(0.0093696693), COEF_CONST(0.0084117414), COEF_CONST(0.0060093796), COEF_CONST(0.0036766009), COEF_CONST(0.0005000392), COEF_CONST(0.0005000392), COEF_CONST(0.0005000392) },
    { COEF_CONST(0.0177799194), COEF_CONST(0.0166607102), COEF_CONST(0.0149581377), COEF_CONST(0.0106875809), COEF_CONST(0.0065392545), COEF_CONST(0.0008893767), COEF_CONST(0.0008893767), COEF_CONST(0.0008893767) },
    { COEF_CONST(0.0316069684), COEF_CONST(0.0296211579), COEF_CONST(0.0265987295), COEF_CONST(0.0190113813), COEF_CONST(0.0116349973), COEF_CONST(0.0015826974), COEF_CONST(0.0015826974), COEF_CONST(0.0015826974) },
    { COEF_CONST(0.0561454100), COEF_CONST(0.0526385859), COEF_CONST(0.0472937334), COEF_CONST(0.0338410641), COEF_CONST(0.0207261065), COEF_CONST(0.0028205635), COEF_CONST(0.0028205635), COEF_CONST(0.0028205635) },
    { COEF_CONST(0.0791834041), COEF_CONST(0.0742798103), COEF_CONST(0.0667907269), COEF_CONST(0.0478705292), COEF_CONST(0.0293500747), COEF_CONST(0.0039966755), COEF_CONST(0.0039966755), COEF_CONST(0.0039966755) },
    { COEF_CONST(0.1115021177), COEF_CONST(0.1047141985), COEF_CONST(0.0943053154), COEF_CONST(0.0678120561), COEF_CONST(0.0416669150), COEF_CONST(0.0056813213), COEF_CONST(0.0056813213), COEF_CONST(0.0056813213) },
    { COEF_CONST(0.1565355066), COEF_CONST(0.1473258371), COEF_CONST(0.1330924027), COEF_CONST(0.0963282233), COEF_CONST(0.0594509113), COEF_CONST(0.0081277946), COEF_CONST(0.0081277946), COEF_CONST(0.0081277946) },
    { COEF_CONST(0.2184643682), COEF_CONST(0.2064579524), COEF_CONST(0.1876265439), COEF_CONST(0.1375744167), COEF_CONST(0.0856896681), COEF_CONST(0.0117817338), COEF_CONST(0.0117817338), COEF_CONST(0.0117817338) },
    { COEF_CONST(0.3015113269), COEF_CONST(0.2870525790), COEF_CONST(0.2637738799), COEF_CONST(0.1984573949), COEF_CONST(0.1260749909), COEF_CONST(0.0175600126), COEF_CONST(0.0175600126), COEF_CONST(0.0175600126) },
    { COEF_CONST(0.3698741335), COEF_CONST(0.3547727297), COEF_CONST(0.3298252076), COEF_CONST(0.2556265829), COEF_CONST(0.1665990017), COEF_CONST(0.0236344541), COEF_CONST(0.0236344541), COEF_CONST(0.0236344541) },
    { COEF_CONST(0.4480623975), COEF_CONST(0.4339410024), COEF_CONST(0.4098613774), COEF_CONST(0.3322709108), COEF_CONST(0.2266784729), COEF_CONST(0.0334094131), COEF_CONST(0.0334094131), COEF_CONST(0.0334094131) },
    { COEF_CONST(0.5336171261), COEF_CONST(0.5226637762), COEF_CONST(0.5033652606), COEF_CONST(0.4349162672), COEF_CONST(0.3224682122), COEF_CONST(0.0521999036), COEF_CONST(0.0521999036), COEF_CONST(0.0521999036) },
    { COEF_CONST(0.6219832023), COEF_CONST(0.6161847276), COEF_CONST(0.6057251063), COEF_CONST(0.5654342668), COEF_CONST(0.4826149915), COEF_CONST(0.1058044758), COEF_CONST(0.1058044758), COEF_CONST(0.1058044758) },
    { COEF_CONST(0.7071067657), COEF_CONST(0.7071067657), COEF_CONST(0.7071067657), COEF_CONST(0.7071067657), COEF_CONST(0.7071067657), COEF_CONST(0.7071067657), COEF_CONST(0.7071067657), COEF_CONST(0.7071067657) },
    { COEF_CONST(0.7830305572), COEF_CONST(0.7876016373), COEF_CONST(0.7956739618), COEF_CONST(0.8247933372), COEF_CONST(0.8758325942), COEF_CONST(0.9943869542), COEF_CONST(0.9943869542), COEF_CONST(0.9943869542) },
    { COEF_CONST(0.8457261833), COEF_CONST(0.8525388778), COEF_CONST(0.8640737401), COEF_CONST(0.9004708933), COEF_CONST(0.9465802987), COEF_CONST(0.9986366532), COEF_CONST(0.9986366532), COEF_CONST(0.9986366532) },
    { COEF_CONST(0.8940022267), COEF_CONST(0.9009412572), COEF_CONST(0.9121477564), COEF_CONST(0.9431839770), COEF_CONST(0.9739696219), COEF_CONST(0.9994417480), COEF_CONST(0.9994417480), COEF_CONST(0.9994417480) },
    { COEF_CONST(0.9290818561), COEF_CONST(0.9349525662), COEF_CONST(0.9440420138), COEF_CONST(0.9667755833), COEF_CONST(0.9860247275), COEF_CONST(0.9997206664), COEF_CONST(0.9997206664), COEF_CONST(0.9997206664) },
    { COEF_CONST(0.9534625907), COEF_CONST(0.9579148236), COEF_CONST(0.9645845234), COEF_CONST(0.9801095128), COEF_CONST(0.9920207064), COEF_CONST(0.9998458099), COEF_CONST(0.9998458099), COEF_CONST(0.9998458099) },
    { COEF_CONST(0.9758449068), COEF_CONST(0.9784554646), COEF_CONST(0.9822404252), COEF_CONST(0.9904914275), COEF_CONST(0.9963218730), COEF_CONST(0.9999305926), COEF_CONST(0.9999305926), COEF_CONST(0.9999305926) },
    { COEF_CONST(0.9876723320), COEF_CONST(0.9890880155), COEF_CONST(0.9911036356), COEF_CONST(0.9953496173), COEF_CONST(0.9982312259), COEF_CONST(0.9999669685), COEF_CONST(0.9999669685), COEF_CONST(0.9999669685) },
    { COEF_CONST(0.9937641889), COEF_CONST(0.9945023501), COEF_CONST(0.9955433130), COEF_CONST(0.9976981117), COEF_CONST(0.9991315558), COEF_CONST(0.9999838610), COEF_CONST(0.9999838610), COEF_CONST(0.9999838610) },
    { COEF_CONST(0.9968600642), COEF_CONST(0.9972374385), COEF_CONST(0.9977670024), COEF_CONST(0.9988535464), COEF_CONST(0.9995691924), COEF_CONST(0.9999920129), COEF_CONST(0.9999920129), COEF_CONST(0.9999920129) },
    { COEF_CONST(0.9984226014), COEF_CONST(0.9986136287), COEF_CONST(0.9988810254), COEF_CONST(0.9994272242), COEF_CONST(0.9997851906), COEF_CONST(0.9999960221), COEF_CONST(0.9999960221), COEF_CONST(0.9999960221) },
    { COEF_CONST(0.9995003746), COEF_CONST(0.9995611974), COEF_CONST(0.9996461891), COEF_CONST(0.9998192657), COEF_CONST(0.9999323103), COEF_CONST(0.9999987475), COEF_CONST(0.9999987475), COEF_CONST(0.9999987475) },
    { COEF_CONST(0.9998419236), COEF_CONST(0.9998611991), COEF_CONST(0.9998881193), COEF_CONST(0.9999428861), COEF_CONST(0.9999786185), COEF_CONST(0.9999996045), COEF_CONST(0.9999996045), COEF_CONST(0.9999996045) },
    { COEF_CONST(0.9999500038), COEF_CONST(0.9999561034), COEF_CONST(0.9999646206), COEF_CONST(0.9999819429), COEF_CONST(0.9999932409), COEF_CONST(0.9999998750), COEF_CONST(0.9999998750), COEF_CONST(0.9999998750) },
    { COEF_CONST(0.9999841890), COEF_CONST(0.9999861183), COEF_CONST(0.9999888121), COEF_CONST(0.9999942902), COEF_CONST(0.9999978628), COEF_CONST(0.9999999605), COEF_CONST(0.9999999605), COEF_CONST(0.9999999605) },
    { COEF_CONST(0.9999950000), COEF_CONST(0.9999956102), COEF_CONST(0.9999964621), COEF_CONST(0.9999981945), COEF_CONST(0.9999993242), COEF_CONST(0.9999999875), COEF_CONST(0.9999999875), COEF_CONST(0.9999999875) }
};

static const real_t cos_gammas_normal[][8] = {
    { COEF_CONST(1.0000000000), COEF_CONST(0.9841239707), COEF_CONST(0.9594738226), COEF_CONST(0.8946843024), COEF_CONST(0.8269341029), COEF_CONST(0.7245688486), COEF_CONST(0.7245688486), COEF_CONST(0.7245688486) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9849690570), COEF_CONST(0.9617776789), COEF_CONST(0.9020941550), COEF_CONST(0.8436830391), COEF_CONST(0.7846832804), COEF_CONST(0.7846832804), COEF_CONST(0.7846832804) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9871656089), COEF_CONST(0.9676774734), COEF_CONST(0.9199102884), COEF_CONST(0.8785067015), COEF_CONST(0.8464232214), COEF_CONST(0.8464232214), COEF_CONST(0.8464232214) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9913533967), COEF_CONST(0.9786000177), COEF_CONST(0.9496063381), COEF_CONST(0.9277157252), COEF_CONST(0.9133354077), COEF_CONST(0.9133354077), COEF_CONST(0.9133354077) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9948924435), COEF_CONST(0.9875319180), COEF_CONST(0.9716329849), COEF_CONST(0.9604805241), COEF_CONST(0.9535949574), COEF_CONST(0.9535949574), COEF_CONST(0.9535949574) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9977406278), COEF_CONST(0.9945423840), COEF_CONST(0.9878736667), COEF_CONST(0.9833980494), COEF_CONST(0.9807207440), COEF_CONST(0.9807207440), COEF_CONST(0.9807207440) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9990607067), COEF_CONST(0.9977417734), COEF_CONST(0.9950323970), COEF_CONST(0.9932453273), COEF_CONST(0.9921884740), COEF_CONST(0.9921884740), COEF_CONST(0.9921884740) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9998081748), COEF_CONST(0.9995400312), COEF_CONST(0.9989936459), COEF_CONST(0.9986365356), COEF_CONST(0.9984265591), COEF_CONST(0.9984265591), COEF_CONST(0.9984265591) }
};

static const real_t cos_gammas_fine[][8] = {
    { COEF_CONST(1.0000000000), COEF_CONST(0.9841239707), COEF_CONST(0.9594738226), COEF_CONST(0.8946843024), COEF_CONST(0.8269341029), COEF_CONST(0.7245688486), COEF_CONST(0.7245688486), COEF_CONST(0.7245688486) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9849690570), COEF_CONST(0.9617776789), COEF_CONST(0.9020941550), COEF_CONST(0.8436830391), COEF_CONST(0.7846832804), COEF_CONST(0.7846832804), COEF_CONST(0.7846832804) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9871656089), COEF_CONST(0.9676774734), COEF_CONST(0.9199102884), COEF_CONST(0.8785067015), COEF_CONST(0.8464232214), COEF_CONST(0.8464232214), COEF_CONST(0.8464232214) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9899597309), COEF_CONST(0.9750098690), COEF_CONST(0.9402333855), COEF_CONST(0.9129698759), COEF_CONST(0.8943765944), COEF_CONST(0.8943765944), COEF_CONST(0.8943765944) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9926607607), COEF_CONST(0.9819295710), COEF_CONST(0.9580160104), COEF_CONST(0.9404993670), COEF_CONST(0.9293004472), COEF_CONST(0.9293004472), COEF_CONST(0.9293004472) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9948924435), COEF_CONST(0.9875319180), COEF_CONST(0.9716329849), COEF_CONST(0.9604805241), COEF_CONST(0.9535949574), COEF_CONST(0.9535949574), COEF_CONST(0.9535949574) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9972074644), COEF_CONST(0.9932414270), COEF_CONST(0.9849197629), COEF_CONST(0.9792926592), COEF_CONST(0.9759092525), COEF_CONST(0.9759092525), COEF_CONST(0.9759092525) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9985361982), COEF_CONST(0.9964742028), COEF_CONST(0.9922136306), COEF_CONST(0.9893845420), COEF_CONST(0.9877041371), COEF_CONST(0.9877041371), COEF_CONST(0.9877041371) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9992494366), COEF_CONST(0.9981967170), COEF_CONST(0.9960386625), COEF_CONST(0.9946185834), COEF_CONST(0.9937800239), COEF_CONST(0.9937800239), COEF_CONST(0.9937800239) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9996194722), COEF_CONST(0.9990869422), COEF_CONST(0.9979996269), COEF_CONST(0.9972873651), COEF_CONST(0.9968679747), COEF_CONST(0.9968679747), COEF_CONST(0.9968679747) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9998081748), COEF_CONST(0.9995400312), COEF_CONST(0.9989936459), COEF_CONST(0.9986365356), COEF_CONST(0.9984265591), COEF_CONST(0.9984265591), COEF_CONST(0.9984265591) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9999390971), COEF_CONST(0.9998540271), COEF_CONST(0.9996809352), COEF_CONST(0.9995679735), COEF_CONST(0.9995016284), COEF_CONST(0.9995016284), COEF_CONST(0.9995016284) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9999807170), COEF_CONST(0.9999537862), COEF_CONST(0.9998990191), COEF_CONST(0.9998632947), COEF_CONST(0.9998423208), COEF_CONST(0.9998423208), COEF_CONST(0.9998423208) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9999938979), COEF_CONST(0.9999853814), COEF_CONST(0.9999680568), COEF_CONST(0.9999567596), COEF_CONST(0.9999501270), COEF_CONST(0.9999501270), COEF_CONST(0.9999501270) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9999980703), COEF_CONST(0.9999953731), COEF_CONST(0.9999898968), COEF_CONST(0.9999863277), COEF_CONST(0.9999842265), COEF_CONST(0.9999842265), COEF_CONST(0.9999842265) },
    { COEF_CONST(1.0000000000), COEF_CONST(0.9999993891), COEF_CONST(0.9999985397), COEF_CONST(0.9999968037), COEF_CONST(0.9999956786), COEF_CONST(0.9999950155), COEF_CONST(0.9999950155), COEF_CONST(0.9999950155) }
};

static const real_t sin_gammas_normal[][8] = {
    { COEF_CONST(0.0000000000), COEF_CONST(0.1774824223), COEF_CONST(0.2817977711), COEF_CONST(0.4466990028), COEF_CONST(0.5622988435), COEF_CONST(0.6892024258), COEF_CONST(0.6892024258), COEF_CONST(0.6892024258) },
    { COEF_CONST(0.0000000000), COEF_CONST(0.1727308798), COEF_CONST(0.2738315110), COEF_CONST(0.4315392630), COEF_CONST(0.5368416242), COEF_CONST(0.6198968861), COEF_CONST(0.6198968861), COEF_CONST(0.6198968861) },
    { COEF_CONST(0.0000000000), COEF_CONST(0.1596999079), COEF_CONST(0.2521910140), COEF_CONST(0.3921288836), COEF_CONST(0.4777300236), COEF_CONST(0.5325107795), COEF_CONST(0.5325107795), COEF_CONST(0.5325107795) },
    { COEF_CONST(0.0000000000), COEF_CONST(0.1312190642), COEF_CONST(0.2057717310), COEF_CONST(0.3134450552), COEF_CONST(0.3732874674), COEF_CONST(0.4072080955), COEF_CONST(0.4072080955), COEF_CONST(0.4072080955) },
    { COEF_CONST(0.0000000000), COEF_CONST(0.1009407043), COEF_CONST(0.1574189028), COEF_CONST(0.2364938532), COEF_CONST(0.2783471983), COEF_CONST(0.3010924396), COEF_CONST(0.3010924396), COEF_CONST(0.3010924396) },
    { COEF_CONST(0.0000000000), COEF_CONST(0.0671836269), COEF_CONST(0.1043333428), COEF_CONST(0.1552598422), COEF_CONST(0.1814615013), COEF_CONST(0.1954144885), COEF_CONST(0.1954144885), COEF_CONST(0.1954144885) },
    { COEF_CONST(0.0000000000), COEF_CONST(0.0433324862), COEF_CONST(0.0671666110), COEF_CONST(0.0995516398), COEF_CONST(0.1160332699), COEF_CONST(0.1247478739), COEF_CONST(0.1247478739), COEF_CONST(0.1247478739) },
    { COEF_CONST(0.0000000000), COEF_CONST(0.0195860576), COEF_CONST(0.0303269852), COEF_CONST(0.0448519274), COEF_CONST(0.0522022017), COEF_CONST(0.0560750040), COEF_CONST(0.0560750040), COEF_CONST(0.0560750040) }
};

static const real_t sin_gammas_fine[][8] = {
    { COEF_CONST(0.0000000000), COEF_CONST(0.1774824223), COEF_CONST(0.2817977711), COEF_CONST(0.4466990028), COEF_CONST(0.5622988435), COEF_CONST(0.6892024258), COEF_CONST(0.6892024258), COEF_CONST(0.6892024258) },
    { COEF_CONST(0.0000000000), COEF_CONST(0.1727308798), COEF_CONST(0.2738315110), COEF_CONST(0.4315392630), COEF_CONST(0.5368416242), COEF_CONST(0.6198968861), COEF_CONST(0.6198968861), COEF_CONST(0.6198968861) },
    { COEF_CONST(0.0000000000), COEF_CONST(0.1596999079), COEF_CONST(0.2521910140), COEF_CONST(0.3921288836), COEF_CONST(0.4777300236), COEF_CONST(0.5325107795), COEF_CONST(0.5325107795), COEF_CONST(0.5325107795) },
    { COEF_CONST(0.0000000000), COEF_CONST(0.1413496768), COEF_CONST(0.2221615526), COEF_CONST(0.3405307340), COEF_CONST(0.4080269669), COEF_CONST(0.4473147744), COEF_CONST(0.4473147744), COEF_CONST(0.4473147744) },
    { COEF_CONST(0.0000000000), COEF_CONST(0.1209322714), COEF_CONST(0.1892467110), COEF_CONST(0.2867147079), COEF_CONST(0.3397954394), COEF_CONST(0.3693246252), COEF_CONST(0.3693246252), COEF_CONST(0.3693246252) },
    { COEF_CONST(0.0000000000), COEF_CONST(0.1009407043), COEF_CONST(0.1574189028), COEF_CONST(0.2364938532), COEF_CONST(0.2783471983), COEF_CONST(0.3010924396), COEF_CONST(0.3010924396), COEF_CONST(0.3010924396) },
    { COEF_CONST(0.0000000000), COEF_CONST(0.0746811420), COEF_CONST(0.1160666523), COEF_CONST(0.1730117353), COEF_CONST(0.2024497161), COEF_CONST(0.2181768341), COEF_CONST(0.2181768341), COEF_CONST(0.2181768341) },
    { COEF_CONST(0.0000000000), COEF_CONST(0.0540875291), COEF_CONST(0.0838997203), COEF_CONST(0.1245476266), COEF_CONST(0.1453211203), COEF_CONST(0.1563346972), COEF_CONST(0.1563346972), COEF_CONST(0.1563346972) },
    { COEF_CONST(0.0000000000), COEF_CONST(0.0387371058), COEF_CONST(0.0600276114), COEF_CONST(0.0889212171), COEF_CONST(0.1036044086), COEF_CONST(0.1113609634), COEF_CONST(0.1113609634), COEF_CONST(0.1113609634) },
    { COEF_CONST(0.0000000000), COEF_CONST(0.0275846110), COEF_CONST(0.0427233177), COEF_CONST(0.0632198125), COEF_CONST(0.0736064637), COEF_CONST(0.0790837596), COEF_CONST(0.0790837596), COEF_CONST(0.0790837596) },
    { COEF_CONST(0.0000000000), COEF_CONST(0.0195860576), COEF_CONST(0.0303269852), COEF_CONST(0.0448519274), COEF_CONST(0.0522022017), COEF_CONST(0.0560750040), COEF_CONST(0.0560750040), COEF_CONST(0.0560750040) },
    { COEF_CONST(0.0000000000), COEF_CONST(0.0110363955), COEF_CONST(0.0170857974), COEF_CONST(0.0252592108), COEF_CONST(0.0293916021), COEF_CONST(0.0315673054), COEF_CONST(0.0315673054), COEF_CONST(0.0315673054) },
    { COEF_CONST(0.0000000000), COEF_CONST(0.0062101284), COEF_CONST(0.0096138203), COEF_CONST(0.0142109649), COEF_CONST(0.0165345659), COEF_CONST(0.0177576316), COEF_CONST(0.0177576316), COEF_CONST(0.0177576316) },
    { COEF_CONST(0.0000000000), COEF_CONST(0.0034934509), COEF_CONST(0.0054071189), COEF_CONST(0.0079928316), COEF_CONST(0.0092994041), COEF_CONST(0.0099871631), COEF_CONST(0.0099871631), COEF_CONST(0.0099871631) },
    { COEF_CONST(0.0000000000), COEF_CONST(0.0019645397), COEF_CONST(0.0030419905), COEF_CONST(0.0044951511), COEF_CONST(0.0052291853), COEF_CONST(0.0056166498), COEF_CONST(0.0056166498), COEF_CONST(0.0056166498) },
    { COEF_CONST(0.0000000000), COEF_CONST(0.0011053943), COEF_CONST(0.0017089869), COEF_CONST(0.0025283670), COEF_CONST(0.0029398552), COEF_CONST(0.0031573685), COEF_CONST(0.0031573685), COEF_CONST(0.0031573685) }
};

static const real_t sf_iid_normal[] = {
    COEF_CONST(1.4119827747), COEF_CONST(1.4031381607), COEF_CONST(1.3868767023),
    COEF_CONST(1.3483997583), COEF_CONST(1.2912493944), COEF_CONST(1.1960374117),
    COEF_CONST(1.1073724031), COEF_CONST(1.0000000000), COEF_CONST(0.8796171546),
    COEF_CONST(0.7546485662), COEF_CONST(0.5767799020), COEF_CONST(0.4264014363),
    COEF_CONST(0.2767182887), COEF_CONST(0.1766446233), COEF_CONST(0.0794016272)
};

static const real_t sf_iid_fine[] = {
    COEF_CONST(1.4142065048), COEF_CONST(1.4141912460), COEF_CONST(1.4141428471),
    COEF_CONST(1.4139900208), COEF_CONST(1.4135069847), COEF_CONST(1.4119827747),
    COEF_CONST(1.4097729921), COEF_CONST(1.4053947926), COEF_CONST(1.3967796564),
    COEF_CONST(1.3800530434), COEF_CONST(1.3483997583), COEF_CONST(1.3139201403),
    COEF_CONST(1.2643101215), COEF_CONST(1.1960374117), COEF_CONST(1.1073724031),
    COEF_CONST(1.0000000000), COEF_CONST(0.8796171546), COEF_CONST(0.7546485662),
    COEF_CONST(0.6336560845), COEF_CONST(0.5230810642), COEF_CONST(0.4264014363),
    COEF_CONST(0.3089554012), COEF_CONST(0.2213746458), COEF_CONST(0.1576878875),
    COEF_CONST(0.1119822487), COEF_CONST(0.0794016272), COEF_CONST(0.0446990170),
    COEF_CONST(0.0251446925), COEF_CONST(0.0141414283), COEF_CONST(0.0079525812),
    COEF_CONST(0.0044721137)
};

#ifdef __cplusplus

#endif
#endif

