/*    util.h
 *
 *    Copyright (C) 1991, 1992, 1993, 1999, 2001, 2002,
 *    by Larry Wall and others
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 */

#ifdef VMS
#  define PERL_FILE_IS_ABSOLUTE(f) \
	(*(f) == '/'							\
	 || (strchr(f,':')						\
	     || ((*(f) == '[' || *(f) == '<')				\
		 && (isALNUM((f)[1]) || strchr("$-_]>",(f)[1])))))

#else		/* !VMS */
#  if defined(WIN32) || defined(__CYGWIN__)
#    define PERL_FILE_IS_ABSOLUTE(f) \
	(*(f) == '/' || *(f) == '\\'		/* UNC/rooted path */	\
	 || ((f)[0] && (f)[1] == ':'))		/* drive name */
#  else		/* !WIN32 */
#  ifdef NETWARE
#    define PERL_FILE_IS_ABSOLUTE(f) \
	(((f)[0] && (f)[1] == ':')		/* drive name */	\
	 || ((f)[0] == '\\' && (f)[1] == '\\')	/* UNC path */	\
	 ||	((f)[3] == ':'))				/* volume name, currently only sys */
#  else		/* !__NETWARE */
#    if defined( __INNOTEK_LIBC__)
#      define PERL_FILE_IS_ABSOLUTE(f) \
	(*(f) == '/' || *(f) == '\\'	\
	 || ((f)[1] == ':' && (f)[2] == '/') || ((f)[1] == ':' && (f)[2] == '\\'))		/* drive name */
#  else		/* !__INNOTEK_LIBC__ */
#    if defined( DOSISH) || defined(EPOC) 
#      define PERL_FILE_IS_ABSOLUTE(f) \
	(*(f) == '/'							\
	 || ((f)[0] && (f)[1] == ':'))		/* drive name */
#    else	/* NEITHER DOSISH NOR EPOCISH */
#      ifdef MACOS_TRADITIONAL
#        define PERL_FILE_IS_ABSOLUTE(f)	(strchr(f, ':') && *(f) != ':')
#      else /* !MACOS_TRADITIONAL */
#        define PERL_FILE_IS_ABSOLUTE(f)	(*(f) == '/')
#      endif /* MACOS_TRADITIONAL */
#    endif	/* DOSISH */
#   endif	/* NETWARE */
#   endif	/* __INNOTEK_LIBC__ */
#  endif	/* WIN32 */
#endif		/* VMS */
