@echo off 
set BSRC=.
set BMOUT=

if "%1" == "" goto help
set SEQUENCE=jump
if "%1" == "dhry21" goto dhry21
if "%1" == "bsort" goto bsort
if "%1" == "sieve" goto sieve 
if "%1" == "linp" goto linp
if "%1" == "whet" goto whet
if "%1" == "all" goto doall
   
:help
@echo *********************************************************
@echo * This demonstrates the High C compiler. It may take    *
@echo * as long as 20 minutes on a slow 386 machine with no   *
@echo * floating point coprocessor to compile and run all     *
@echo * demo programs. Linpack takes the most time.           *
@echo * High C will automatically detect and use an 80387     *
@echo * coprocessor if one is present on your machine.        *
@echo * There are 5 benchmarks in the demos directory:        *
@echo *   dhry21 -- dhrystone version 2.1                     *
@echo *   bsort  -- simple bubble-sort program                *
@echo *   sieve  -- sieve prime number benchmark program      *
@echo *   whet   -- whetstone benchmark                       *
@echo *   linp   -- linpack benchmark                         *
@echo * To run all of them, simply type the following command *
@echo *      demo all                                         *
@echo * at the OS/2 prompt.                                   *
@echo * To run an individual benchmark, type the individual   *
@echo * name on the command line. The following example       *
@echo * illustrates how to invoke the dhry21 benchmark:       *
@echo *      demo dhry21                                      *
@echo *********************************************************
goto done

:doall
set SEQUENCE=flow

:dhry21
	@echo ***************************************************************
        @echo * Making Dhrystone ver 2.1                                    *
	@echo ***************************************************************
	@if exist dhry21.out del dhry21.out
	@if exist dhry21.arg del dhry21.arg
	@echo -O4 -Hit=100 -Hic=4             >> dhry21.arg
	@echo %BSRC%\dpack1.c %BSRC%\dpack2.c >> dhry21.arg
	@echo -w -I%BSRC% -o dhry21           >> dhry21.arg
	@hcoppc @dhry21.arg
	@echo.
	@echo +-------------------------------------------------------------+
        @echo + You must run Dhrystone ver 2.1 on OS/2 for PowerPC          +
	@echo +-------------------------------------------------------------+
rem	@dhry21                        >> dhry21.out
rem	type dhry21.out
	@echo.
	@echo.
	@if exist dhry21.arg del dhry21.arg
	@if exist dhry21.map del dhry21.map
	@if exist dpack1.obj del dpack1.obj
	@if exist dpack2.obj del dpack2.obj
	@if exist dhry21.exp del dhry21.exp
	set BMOUT=%BMOUT% dhry21.out
	if "%SEQUENCE%" == "jump" goto done
	pause

:bsort
	@echo ***************************************************************
	@echo * Making Bubble Sort Demo Program                             *
	@echo ***************************************************************
	@if exist bsort.out del bsort.out
	@if exist bsort.arg del bsort.arg
	@echo -O7                              >> bsort.arg
	@echo -DITERATIONS=1000 -DBENCHMARK    >> bsort.arg
	@echo %BSRC%\bsort.c                   >> bsort.arg
	@echo -w -o bsort                      >> bsort.arg
	@hcoppc @bsort.arg
	@echo.
	@echo +-------------------------------------------------------------+
        @echo + You must run Bubble Sort Demo Program on OS/2 for PowerPC   +
	@echo +-------------------------------------------------------------+
rem	@bsort                          >> bsort.out
rem	@type bsort.out
	@echo.
	@echo.
	@if exist bsort.arg del bsort.arg
	@if exist bsort.map del bsort.map
	@if exist bsort.obj del bsort.obj
	@if exist bsort.exp del bsort.exp
	set BMOUT=%BMOUT% bsort.out
	if "%SEQUENCE%" == "jump" goto done
	pause

:sieve
	@echo ***************************************************************
        @echo * Making Sieve Prime Number Demo                              *
	@echo ***************************************************************
	@if exist sieve.out del sieve.out
	@if exist sieve.arg del sieve.arg
	@echo -O7                             >> sieve.arg
	@echo -DITERATIONS=1000 -DBENCHMARK   >> sieve.arg
	@echo %BSRC%\sieve.c                  >> sieve.arg
	@echo -w -o sieve                     >> sieve.arg
	@hcoppc @sieve.arg
	@echo.
	@echo +-------------------------------------------------------------+
        @echo + You must run Sieve Prime Number Demo on OS/2 for PowerPC    +
	@echo +-------------------------------------------------------------+
rem 	@sieve                         >> sieve.out
rem	@type sieve.out
	@echo.
	@echo.
	@if exist sieve.arg del sieve.arg
	@if exist sieve.obj del sieve.obj
	@if exist sieve.map del sieve.map
	@if exist sieve.exp del sieve.exp
	set BMOUT=%BMOUT% sieve.out
	if "%SEQUENCE%" == "jump" goto done
	pause

:whet
	@echo ***************************************************************
        @echo * Making Whetstone Single Precision Benchmark                 *
	@echo ***************************************************************
	@if exist whet.out del whet.out
	@if exist whet_s.arg del whet_s.arg
	@if exist whet_d.arg del whet_d.arg
	@echo -O7 -Hit=100 -Hic=4             >> whet_s.arg
	@echo -fsingle -fsingle2              >> whet_s.arg
	@echo %BSRC%\whet_s.c                 >> whet_s.arg
	@echo -w -o whet_s                    >> whet_s.arg
	@hcoppc @whet_s.arg
	@echo.
	@echo ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        @echo : You must run Whetstone Single Precision on OS/2 for PowerPC  :
        @echo ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
rem 	@whet_s                        >> whet.out
	@echo.
	@if exist whet_s.arg del whet_s.arg
	@if exist whet_s.map del whet_s.map
	@if exist whet_s.obj del whet_s.obj
	@if exist whet_s.exp del whet_s.exp

	@echo ***************************************************************
        @echo * Making Whetstone Double Precision Benchmark                 *
	@echo ***************************************************************
	@echo -O7 -Hit=100 -Hic=4             >> whet_d.arg
	@echo %BSRC%\whet_d.c                 >> whet_d.arg
	@echo -w -o whet_d                    >> whet_d.arg
	@hcoppc @whet_d.arg
	@echo.
	@echo :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        @echo : You must run Whetstone Double Precision on OS/2 for PowerPC :
	@echo :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
rem	@whet_d                        >> whet.out
	@echo.
	@if exist whet_d.arg del whet_d.arg
	@if exist whet_d.map del whet_d.map
	@if exist whet_d.obj del whet_d.obj
	@if exist whet_d.exp del whet_d.exp
	@echo +-------------------------------------------------------------+
	@echo + Running whetstone benchmark                                 +
	@echo +-------------------------------------------------------------+
rem	type whet.out
	@echo.
	@echo.
	set BMOUT=%BMOUT% whet.out
	if "%SEQUENCE%" == "jump" goto done
	pause

:linp
	@echo ***************************************************************
        @echo * Making Linpack Rolled Single Precision Benchmark            *
	@echo ***************************************************************
	@if exist linp.out del linp.out
	@if exist sroll.arg del sroll.arg
	@if exist droll.arg del droll.arg
	@if exist sunroll.arg del sunroll.arg
	@if exist dunroll.arg del dunroll.arg
	@echo -O7 -Hit=100 -Hic=4             >> sroll.arg
	@echo -DSP -DROLL                     >> sroll.arg
	@echo %BSRC%\linpack.c                >> sroll.arg
	@echo -w -o sroll                     >> sroll.arg
	@hcoppc @sroll.arg
	@echo.
	@echo ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        @echo : You must run Linpack Rolled Single Precision on OS/2 for PowerPC :
	@echo ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
rem	@sroll                         >>linp.out
	@echo.
	@if exist sroll.arg del sroll.arg
	@if exist sroll.map del sroll.map
	@if exist linpack.obj del linpack.obj
	@if exist sroll.exp del sroll.exp

	@echo ***************************************************************
        @echo * Making Linpack Rolled Double Precision Benchmark            *
	@echo ***************************************************************
	@echo -O7 -Hit=100 -Hic=4             >> droll.arg
	@echo -DDP -DROLL                     >> droll.arg
	@echo %BSRC%\linpack.c                >> droll.arg
	@echo -w -o droll                     >> droll.arg
	@hcoppc @droll.arg
	@echo.
	@echo ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        @echo : You must run Linpack Rolled Double Precision on OS/2 for PowerPC :
	@echo ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
rem	@droll                         >> linp.out
	@echo.
	@if exist droll.arg del droll.arg
	@if exist droll.map del droll.map
	@if exist linpack.obj del linpack.obj
	@if exist droll.exp del droll.exp

        @echo ***************************************************************
        @echo * Making Linpack Unrolled Single Precision Benchmark          *
        @echo ***************************************************************
	@echo -O7 -Hit=100 -Hic=4             >> sunroll.arg
	@echo -DSP -DUNROLL                   >> sunroll.arg
	@echo %BSRC%\linpack.c                >> sunroll.arg
	@echo -w -o sunroll                   >> sunroll.arg
	@hcoppc @sunroll.arg
	@echo.
	@echo ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        @echo : You must run Linpack Unrolled Single Precision on OS/2 for PowerPC :
	@echo ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
rem	@sunroll                       >> linp.out
	@echo.
	@if exist sunroll.arg del sunroll.arg
	@if exist sunroll.map del sunroll.map
	@if exist linpack.obj del linpack.obj
	@if exist sunroll.exp del sunroll.exp

	@echo ***************************************************************
        @echo * Making Linpack Unrolled Double Precision Benchmark          *
	@echo ***************************************************************
	@echo -O7 -Hit=100 -Hic=4             >> dunroll.arg
	@echo -DDP -DUNROLL                   >> dunroll.arg
	@echo %BSRC%\linpack.c                >> dunroll.arg
	@echo -w -o dunroll                   >> dunroll.arg
	@hcoppc @dunroll.arg
	@echo.
	@echo ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        @echo : You must run Linpack Unrolled Double Precision on OS/2 for PowerPC :
	@echo ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
rem	@dunroll                       >> linp.out
	@echo.
	@if exist dunroll.arg del dunroll.arg
	@if exist dunroll.map del dunroll.map
	@if exist linpack.obj del linpack.obj
	@if exist dunroll.exp del dunroll.exp
rem	@echo +-------------------------------------------------------------+
rem	@echo + Running Linpack benchmark                                   +
rem	@echo +-------------------------------------------------------------+
rem	type linp.out
	@echo.
	@echo.
	set BMOUT=%BMOUT% linp.out

:done
set SEQUENCE=
if "%BMOUT%" == "" goto end
  @echo ------------------------- Demo Completed ----------------------------
  @echo.
  set BMOUT=
:end
