#ifdef __HIGHC__
#  pragma wtrsvd1(16);	/* New Intel setting for Weitek registers. */
#  pragma on(align_labels);
#else
#  define NO_PROTOTYPES
#endif


#include <stdio.h>
#include <math.h>
#include <time.h>



long DoBench(bname, strp, liters, funcp)
char *bname;
char *strp;			/* Pointer to benchmark name */
long liters;			/* Number of iterations */	
int (*funcp)();			/* Pointer to benchmark function */
{

  long stime;		/* Start time */
  long etime;		/* End time */
  long time;		/* Elapse time */
  int secs;		/* Seconds */
  int hunds;		/* 1/100 seconds */

  printf("%4s %-22s  %6d  ", bname, strp, liters);
  stime = clock();
  (*funcp)();
  etime = clock();
  time = etime - stime;
  time = (long)(time / (CLOCKS_PER_SEC/60.0));
  secs = time / 100;
  hunds = time % 100;
  printf("%4d.%02d secs\n", secs, hunds);
  return time;
}


main()
{

  extern whets();
  long Wtime;

  printf("Code Benchmark               Iters     Time\n");
  printf("--------------------------- -------  -------\n");
  Wtime = DoBench("WS","Whetstone(single)",100L,whets);
  if (Wtime) printf("  (%d KWhets/sec).\n",(int)(10000 / (Wtime/100.0))); 
  exit(0);
}

/**************************************************************************
 *                                                                        *
 *      Whetstone benchmark in C.  This program is a translation of the   *
 *      original Algol version in "A Synthetic Benchmark" by H.J. Curnow  *
 *      and B.A. Wichman in Computer Journal, Vol  19 #1, February 1976.  *
 *                                                                        *
 *      Used to test compiler efficiency, optimization, and double        *
 *      precision floating-point performance.  This version is specific   *
 *      to the Turbo-Amiga and Amiga but it can be easily adapted to      *
 *      other systems by replacing the clock() routine with your own. *
 *                                                                        *
 **************************************************************************/

#define ITERATIONS   10       /* 1 Million Whetstone instructions    */

static long	j, k, l;
static float    S_e1[4];
static float    S_t, S_t1, S_t2; 

/* A true single-precision whestone can only be achieved by using
   ANSI prototypes.  Without them, doubles get passed to p3 and converted
   to float upon entry to p3.
   If your compiler doesn't support prototypes, you could instead
   pass pointers to x and y, for a slight decrease in efficiency.
*/   

#ifndef NO_PROTOTYPES
S_p3(float,float,float*);
#endif

whets() {

   long	    i;
   long     n1, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11;
   long     m, loops;
   float    S_x, S_y, S_z, S_x1, S_x2, S_x3, S_x4;
   
   /************************/
   /* initialize constants */
   /************************/

   S_t   =   0.499975;
   S_t1  =   0.500250;
   S_t2  =   2.0;

   /***********************/
   /* Set Module Weights. */
   /***********************/

   m = 10;                    /* m = 10 is used to obtain better timing  */
   loops = m * ITERATIONS;    /* accuracy only.  Slow systems should use */
   n1  =   0 * loops;         /* m = 1.                                  */
   n2  =  12 * loops;
   n3  =  14 * loops;
   n4  = 345 * loops;
   n5  =   0 * loops;
   n6  = 210 * loops;
   n7  =  32 * loops;
   n8  = 899 * loops;
   n9  = 616 * loops;
   n10 =   0 * loops;
   n11 =  93 * loops;

   /*********************************/
   /* MODULE 1:  simple identifiers */
   /*********************************/

   S_x1 =  1.0;
   S_x2 = -1.0;
   S_x3 = -1.0;
   S_x4 = -1.0;

   if( n1 > 0 )
   {
     for(i = 1; i <= n1; i++)
     {
      S_x1 = ( S_x1 + S_x2 + S_x3 - S_x4 ) * S_t;
      S_x2 = ( S_x1 + S_x2 - S_x3 - S_x4 ) * S_t;
      S_x3 = ( S_x1 - S_x2 + S_x3 + S_x4 ) * S_t;
      S_x4 = (-S_x1 + S_x2 + S_x3 + S_x4 ) * S_t;
     }
   }

   /*****************************/
   /* MODULE 2:  Array Elements */
   /*****************************/
   S_e1[0] =  1.0;        /* Start at element 0 in C, vice 1 in Fortran */
   S_e1[1] = -1.0;
   S_e1[2] = -1.0;
   S_e1[3] = -1.0;

   if( n2 > 0 )
   {
     for (i = 1; i <= n2; i++)
     {
      S_e1[0] = ( S_e1[0] + S_e1[1] + S_e1[2] - S_e1[3] ) * S_t;
      S_e1[1] = ( S_e1[0] + S_e1[1] - S_e1[2] + S_e1[3] ) * S_t;
      S_e1[2] = ( S_e1[0] - S_e1[1] + S_e1[2] + S_e1[3] ) * S_t;
      S_e1[3] = (-S_e1[0] + S_e1[1] + S_e1[2] + S_e1[3] ) * S_t;
     }
   }

   /*********************************/
   /* MODULE 3:  Array as Parameter */
   /*********************************/
   if( n3 > 0 )
   {
     for (i = 1; i <= n3; i++)
     {
      S_pa(S_e1);
     }
   }

   /********************************/
   /* MODULE 4:  Conditional Jumps */
   /********************************/
   j = 1;

   if( n4 > 0 )
   {
     for (i = 1; i <= n4; i++)
     {
      if (j == 1)
         j = 2;
      else
         j = 3;

      if (j > 2)
         j = 0;
      else
         j = 1;

      if (j < 1 )
         j = 1;
      else
         j = 0;
     }
   }

   /**********************/
   /* MODULE 5:  Omitted */
   /**********************/


   /*********************************/
   /* MODULE 6:  Integer Arithmetic */
   /*********************************/
   j = 1;
   k = 2;
   l = 3;

   if( n6 > 0 )
   {
     for (i = 1; i <= n6; i++)
     {
      j = j * (k - j) * (l -k);
      k = l * k - (l - j) * k;
      l = (l - k) * (k + j);

      S_e1[l - 2] = j + k + l;          /* Remember we started at S_e1[0]. */
      S_e1[k - 2] = j * k * l;          /* l-2 in C, vice l-1 in Fortran */
     }
   }

   /**************************************/
   /* MODULE 7:  Trigonometric Functions */
   /**************************************/
   S_x = 0.5;
   S_y = 0.5;

   if( n7 > 0 )
   {
     for(i = 1; i <= n7; i++)
     {
      S_x = S_t * atan(S_t2*sin(S_x)*cos(S_x)/(cos(S_x+S_y)+cos(S_x-S_y)-1));
      S_y = S_t * atan(S_t2*sin(S_y)*cos(S_y)/(cos(S_x+S_y)+cos(S_x-S_y)-1));
     }
   }

   /******************************/
   /* MODULE 8:  Procedure Calls */
   /******************************/

   S_x = 1.0;
   S_y = 1.0;
   S_z = 1.0;

   if( n8 > 0 )
   {
     for (i = 1; i <= n8; i++)
     {
      S_p3(S_x, S_y, &S_z);
     }
   }

   /*******************************/
   /* MODULE 9:  Array References */
   /*******************************/

   j = 1;
   k = 2;
   l = 3;

   S_e1[0] = 1.0;
   S_e1[1] = 2.0;
   S_e1[2] = 3.0;

   if( n9 > 0 )
   {
     for(i = 1; i <= n9; i++)
     {
      S_p0();
     }
   }

   /**********************************/
   /* MODULE 10:  Integer Arithmetic */
   /**********************************/

   j = 2;
   k = 3;

   if( n10 > 0 )
   {
     for(i = 1; i <= n10; i++)
     {
      j = j + k;
      k = j + k;
      j = k - j;
      k = k - j - j;
     }
   }

   /**********************************/
   /* MODULE 11:  Standard Functions */
   /**********************************/

   S_x = 0.75;

   if( n11 > 0 )
   {
     for(i = 1; i <= n11; i++)
     {
      S_x = sqrt( exp( log(S_x) / S_t1) );
     }
   }

   /**************************/
   /* End of Whetstone Tests */
   /**************************/

#if 0	/* Done elsewhere now. */
   stoptime  = clock();
   benchtime = stoptime - starttime - nulltime;
   S_x1 = (double)benchtime/100.0;
   printf("   Benchtime(sec) = %lf\n",S_x1);
   S_x2 = 100.0 * (double)loops / S_x1;
   KWhets = (long)S_x2;
   printf("   KWhets/sec     = %ld\n\n",KWhets);
#endif   

}

/*******************/
/* Subroutine pa() */
/*******************/

S_pa(e)                /* Exactly as in the Algol 60 version, but we */
                     /* could do away with that 'goto'.            */
float e[4];

{
   int j;

   j = 0;
     lab:
   e[0] = (  e[0] + e[1] + e[2] - e[3] ) * S_t;
   e[1] = (  e[0] + e[1] - e[2] + e[3] ) * S_t;
   e[2] = (  e[0] - e[1] + e[2] + e[3] ) * S_t;
   e[3] = ( -e[0] + e[1] + e[2] + e[3] ) / S_t2;
   j ++;

   if (j < 6)
      goto lab;
}

/************************/
/* Subroutine p3(x,y,z) */
/************************/

S_p3(x, y, z)

float x, y, *z;

{
   x  = S_t * (x + y);
   y  = S_t * (x + y);
   *z = (x + y) /S_t2;
}

/*******************/
/* Subroutine p0() */
/*******************/

S_p0()
{
   S_e1[j] = S_e1[k];
   S_e1[k] = S_e1[l];
   S_e1[l] = S_e1[j];
}

/*-- End Of Whetstone C Source Code -----------------*/
