/*
* This program prints out each prefix of its input that is a palindrome.
* It prints out such a prefix as soon as it is read in; the input is read
* character by character.
* The computation of palindromes is done WITHOUT arrays, records, or
* pointers, but with only simply scalar variables.
* It points out the power of procedural parameters and nested procedures,
* available only in MetaWare High C.

* For example, on input
     abcbaxyyxabcba
* the program should print that
     a
     abcba
     abcbaxyyxabcba
* are all palindromes.
*/

typedef enum{False,True} Boolean;

#include <stdio.h>

void Palindrome(
	int Ch(int I)!,     /* Extended-lambda:  full procedural parameter. */
	int Depth) {
   /* Read the next char and report if we have a palindrome so far. */
   int C;
   Boolean Is_pal;
   int I;
   do {
      C = getc(stdin);
      if (C == EOF) return;
      }
   while (C == '\n' || C == '\r');
   if (Depth > 140) return;  /* max stack limit exceeded */
   int Ch2(int I) {
      return I == Depth ? C : Ch(I);
      }
   Depth++;
   /* Do we currently have a palindrome? */
   Is_pal = True;
   for (I = 1; I <= Depth && Is_pal; I++)
      if (Ch2(I) != Ch2(Depth-I+1)) {Is_pal = False; break;}
   if (Is_pal) {
      printf("Palindrome discovered:");
      for (I = 1; I <= Depth; I++) printf("%c",Ch2(I));
      printf("\n");
      }
   Palindrome(Ch2,Depth);
   }

void main () {
   int Dummy(int I) { return I; }       /* Should never be called. */
   printf("Type in characters, hitting RETURN as often as you wish.\n");
   printf("As I recognize palindromes, I'll tell you.\n");
   printf("Type Control+Z, then RETURN to terminate program.\n");
   Palindrome(Dummy,0);
   }
