/* This queens program allows the board size to be specified	*/
/* when the program begins execution.				*/

#define False 0
#define True 1
#define Boolean char

#include <stdio.h>

typedef int Integer;

static Boardsize=0;

#define MaxBoardsize 20

#define Asub(I)  A[(I)-1]
#define Bsub(I)  B[(I)-2]
#define Csub(I)  C[(I)+MaxBoardsize-1]
#define Xsub(I)  X[(I)-1]

static Boolean A[MaxBoardsize /* 1. .MaxBoardsize */];
static Boolean B[MaxBoardsize+MaxBoardsize-1 /* 2..(MaxBoardsize+MaxBoardsize) */];
static Boolean C[MaxBoardsize+MaxBoardsize-1 /*-(MaxBoardsize-1)..(MaxBoardsize-1) */];
static Integer X[MaxBoardsize /* 1.. MaxBoardsize */];

/* Statistics: */
static long Trials=0;

void Try(I,Q) Integer I; Boolean *Q; {
   Integer J = 0;
   Trials++;
   do {
      J++; *Q = False;
      if (Asub(J) && Bsub(I+J) && Csub(I-J)) {
	 Xsub(I) = J;
	 Asub(J) = False; Bsub(I+J) = False; Csub(I-J) = False;
	 if (I < Boardsize) {
	    Try(I+1,Q);
	    if (!*Q) {
	       Asub(J) = True; Bsub(I+J) = True; Csub(I-J) = True;
	       }
	    }
	 else *Q = True;
	 }
      }
   while (!(*Q || J==Boardsize));
   }

void main () {
   Integer J,I,iter; Boolean Q;
   printf("Board size? ");
   scanf(" %d",&Boardsize);
   printf("No. of iterations? ");
   scanf(" %d",&iter);
   for (J = 0; J < iter; J++) {
      Trials = 0;
      for (I =	1; I <=  Boardsize; Asub(I++) = True);
      for (I =	2; I <= Boardsize+Boardsize; Bsub(I++) = True);
      for (I = -(Boardsize-1); I <=  Boardsize+1; Csub(I++) = True);
      Try(1,&Q);
      }
   printf("End of test; Trials=%ld %s solution:\n",Trials,Q?"":"no");
   if (Q)
      for (I = 1; I <= Boardsize;) {
	 printf("%4d",Xsub(I++));
	 }
   printf("\n");
   }
