/* The odd numbers between 3 and 16383, inclusive, are represented by
  the numbers between 0 and 8191, inclusive, according to the following scheme:
  if n in [0..8191], 2n+3 is the represented number.
  Each number 2n+3 is considered in turn.
  Its first odd multiple is (2n+3)*3, or 6n+9, or 2*(n+2n+3)+3.
  Thus the statements
	Prime = 2*I+3;	       -- 2n+3
  which computes the prime, and
	K = I+Prime;	       -- 2K+3 = 2*(n+2n+3)+3 = 6n+9
  which computes the index of the first odd multiple.
*/
#include <stdio.h>

typedef enum{False,True} Boolean;

void main () {
#  define SIZE 8190
   static Boolean Primes[SIZE+1];
   int I,Prime,K,Count,iter;
   /* The program currently computes the primes only once.		*/
   /* For a more time-consuming test, change ITERATIONS to a higher	*/
   /* value.								*/
#  define ITERATIONS 1

   printf("Begin computation of primes...\n");
   for (iter = 1; iter <= ITERATIONS; iter++) {
      Count = 0;
      for (I = 0; I <= SIZE; I++)
	 Primes[I] = True;
      for (I = 0; I <= SIZE; I++)
	 if (Primes[I]) {
	    Prime = 2*I+3;
	    K = I+Prime;
	    while (K <= SIZE) {
	       Primes[K] = False;
	       K += Prime;
	       }
	    Count++;
	    }

      }

   printf("%d primes between 3 and 16383:\n",Count);
   for (I = 0; I <= SIZE; I++)
      if (Primes[I])
	 printf("%8d",2*I+3);
   printf("\nEnd of sieve program.\n");
   }
