/*   bios.h -- extra-ANSI 
 *
 *   Functions, structures and constants needed to access
 *   the BIOS services.
 *
 *   Copyright (c) 1990,1991 MetaWare Incorporated
 */
#ifndef _BIOS_H
#define _BIOS_H
#pragma push_align_members(64);

#ifdef __CPLUSPLUS__
extern "C" {
#endif

#define _COM_INIT 0
#define _COM_SEND 1
#define _COM_RECEIVE 2
#define _COM_STATUS 3

#define _COM_CHR7 2
#define _COM_CHR8 3

#define _COM_STOP1 0
#define _COM_STOP2 4

#define _COM_NOPARITY 0
#define _COM_ODDPARITY 8
#define _COM_EVENPARITY 24

#define _COM_110 0
#define _COM_150 32
#define _COM_300 64
#define _COM_600 96
#define _COM_1200 128
#define _COM_2400 160
#define _COM_4800 192
#define _COM_9600 224
#define _COM_19_2 256
#define _COM_38_4 288
#define _COM_57_6 320
#define _COM_115_2 352

#define _DISK_RESET 0
#define _DISK_STATUS 1
#define _DISK_READ 2
#define _DISK_WRITE 3
#define _DISK_VERIFY 4
#define _DISK_FORMAT 5

#define _KEYBRD_READ 0
#define _KEYBRD_READY 1
#define _KEYBRD_SHIFTSTATUS 2

#define _NKEYBRD_READ 0x10
#define _NKEYBRD_READY 0x11
#define _NKEYBRD_SHIFTSTATUS 0x12

#define _PRINTER_WRITE 0
#define _PRINTER_INIT 1
#define _PRINTER_STATUS 2

#define _TIME_GETCLOCK 0
#define _TIME_SETCLOCK 1

extern unsigned _bios_equiplist(void);
extern unsigned _bios_keybrd(unsigned __service);
extern unsigned _bios_memsize(void);
extern unsigned _bios_printer(unsigned __service, unsigned __port, unsigned __data);
extern unsigned _bios_serialcom(unsigned __service, unsigned __port, unsigned __data);
extern unsigned _bios_timeofday(unsigned __service, long * __timeticks);


#ifndef _REGS_DEFINED
#define _REGS_DEFINED

struct _WORDREGS {
    unsigned int ax;
    unsigned int bx;
    unsigned int cx;
    unsigned int dx;
    unsigned int si;
    unsigned int di;
    unsigned int cflag;
    };

struct _BYTEREGS {
    unsigned char al, ah, xax[sizeof(int)-2];
    unsigned char bl, bh, xbx[sizeof(int)-2];
    unsigned char cl, ch, xcx[sizeof(int)-2];
    unsigned char dl, dh, xdx[sizeof(int)-2];
    };

union _REGS {
    struct _WORDREGS x;
    struct _BYTEREGS h;
    struct _BYTEREGS l;
    };

struct _SREGS {
    unsigned short int es;
    unsigned short int cs;
    unsigned short int ss;
    unsigned short int ds;
    };

#endif /* _REGS_DEFINED */

#ifndef DISKINFO_T_DEFINED
#define DISKINFO_T_DEFINED

_Packed struct _diskinfo_t {
    unsigned short drive;
    unsigned short head;
    unsigned short track;
    unsigned short sector;
    unsigned short nsectors;
    _Far void *buffer;
    };

#endif /* DISKINFO_T_DEFINED */

extern int _int86(int __number, union _REGS * __before, union _REGS * __after);
extern int _int86x(int __number, union _REGS * __before, union _REGS * __after, struct _SREGS * __segregs);

/*  _bios_disk is not fully supported by some dos extenders  */
/*  some options cause hard machine hangs  */
extern unsigned _bios_disk(unsigned __service, struct _diskinfo_t * __info);

#if __HIGHC__
#define REGS _REGS
#define SREGS _SREGS
#define WORDREGS _WORDREGS
#define BYTEREGS _BYTEREGS
#define diskinfo_t _diskinfo_t

#include <_na.h>
#if _NA_NAMES
    _NA(int86)
    _NA(int86x)
#elif _MSDOS
    extern int int86(int __number, union REGS * __before, union REGS * __after);
    extern int int86x(int __number, union REGS * __before, union REGS * __after,
	    struct SREGS * __segregs);
#endif
#endif /* __HIGHC__ */

#ifdef __CPLUSPLUS__
}
#endif
#pragma pop_align_members();
#endif /* _BIOS_H */
