/*
 *   conio.h -- extra-ANSI 
 *
 *   Function definitions for console input and output.
 *
 *           Copyright (c) 1990, MetaWare Incorporated
 */

#ifndef _CONIO_H
#define _CONIO_H

#ifdef __CPLUSPLUS__
extern "C" {
#endif

extern char * _cgets(char *);
extern int _cprintf(char *, ...);
extern int _cscanf(char *, ...);
extern int _cputs(char *);
extern int _getch(void);
extern int _getche(void);
extern int _inp(unsigned int);
extern unsigned _inpw(unsigned int);
extern int _kbhit(void);
extern int _outp(unsigned int ,int );
extern unsigned _outpw(unsigned int ,unsigned int );
extern int _putch(int );
extern int _ungetch(int );

#include <_na.h>
#if _NA_NAMES
    _NA(cgets)
    _NA(cprintf)
    _NA(cputs)
    _NA(cscanf)
    _NA(getch)
    _NA(getche)
    _NA(inp)
    _NA(inpw)
    _NA(kbhit)
    _NA(outp)
    _NA(outpw)
    _NA(putch)
    _NA(ungetch)
#elif _MSDOS && __HIGHC__
    extern char * cgets(char *);
    extern int cprintf(char *, ...);
    extern int cputs(char *);
    extern int cscanf(char *, ...);
    extern int getch(void);
    extern int getche(void);
    extern int inp(unsigned int);
    extern unsigned inpw(unsigned int);
    extern int kbhit(void);
    extern int outp(unsigned int ,int );
    extern unsigned outpw(unsigned int ,unsigned int );
    extern int putch(int );
    extern int ungetch(int );
#endif

#ifdef __CPLUSPLUS__
}
#endif
#endif /* _CONIO_H */
