/*
 *   direct.h -- extra-ANSI 
 *
 *   Functions for directory services.
 *
 *           Copyright (c) 1990, 1993 MetaWare Incorporated
 */

#ifndef _DIRECT_H
#define _DIRECT_H

#ifdef __CPLUSPLUS__
extern "C" {
#endif

#ifndef _UNICHAR_DEFINED
    typedef unsigned short _UNICHAR;
    #define _unichar _UNICHAR
    #define _UNICHAR_DEFINED
#endif

extern int _chdir(const char *);
#if _MSDOS || _OS2 || _MSNT
    extern int _mkdir(const char *);
#else
    extern int _mkdir(const char *, int);
#endif
extern int _rmdir(const char *);
extern char * _getcwd(char *, int);
extern int _chdrive(int __drive);
extern int _getdrive(void);

#include <_na.h>
#if _NA_NAMES
    _NA(chdir)
    _NA(mkdir)
    _NA(rmdir)
    _NA(getcwd)
#elif (_MSDOS || _HOBBIT) && __HIGHC__
    extern int chdir(const char *);
    #if _MSDOS || _OS2 || _MSNT
	extern int mkdir(const char *);
    #else
	extern int mkdir(const char *, int);
    #endif
    extern int rmdir(const char *);
    extern char * getcwd(char *, int);
#endif

/* Unicode functions */

extern int	 _uchdir(const _unichar *);
extern _unichar *_ugetcwd(_unichar *, int);
extern int	 _umkdir(const _unichar *, int);
extern int	 _urmdir(const _unichar *);

#ifdef __UNICODE__
    #define Uchdir  _uchdir
    #define Ugetcwd _ugetcwd
    #define Umkdir  _umkdir
    #define Urmdir  _urmdir
#elif _MSDOS || _OS2 || _MSNT
    #define Uchdir      _chdir
    #define Ugetcwd     _getcwd
    #define Umkdir(f,m) _mkdir(f)
    #define Urmdir      _rmdir
#elif _HOBBIT && __HIGHC__
    #define Uchdir  chdir
    #define Ugetcwd getcwd
    #define Umkdir  mkdir
    #define Urmdir  rmdir
#endif

#ifdef __CPLUSPLUS__
}
#endif
#endif /* _DIRECT_H */
