/*
 *   dirent.h -- extra-ANSI
 *
 *   POSIX directory functions.
 *
 *           Copyright (c) 1993 MetaWare Incorporated
 */

#ifndef _DIRENT_H
#define _DIRENT_H

#ifdef __CPLUSPLUS__
extern "C" {
#endif

#ifndef _UNICHAR_DEFINED
    typedef unsigned short _UNICHAR;
    #define _unichar _UNICHAR
    #define _UNICHAR_DEFINED
#endif

#ifdef __PENPOINT__
    #ifndef GO_INCLUDED
        #include <go.h>
    #endif

    typedef struct _udirent {
	void*       d_handle;                   /* readdir handle */
	_unichar    d_name[maxNameLength + 1];  /* file's name */
	char        d_attr;                     /* file's attribute */
    } _UDIR;

    typedef struct _dirent {
	void*       d_handle;                   /* readdir handle */
	char        d_name[maxNameLength + 1];  /* file's name */
	char        d_attr;                     /* file's attribute */
    } _DIR;

    /* Bit values in d_attr */

    #define _A_NORMAL   0
    #define _A_RDONLY   1
    #define _A_SUBDIR   16
#else
    typedef void _DIR;
    typedef void _UDIR;

    struct _dirent {
    #if _NT || _OS2
	char d_name[256];
    #else
	char d_name[13];
    #endif
	};

    struct _udirent {
    #if _NT || _OS2
	_unichar d_name[256];
    #else
	_unichar d_name[13];
    #endif
	};
#endif

_DIR *		 _opendir(const char *__dirname);
struct _dirent * _readdir(_DIR *__dir);
void		 _rewinddir(_DIR *__dir);
int		 _closedir(_DIR *__dir);

#ifdef __HIGHC__

    #define DIR _DIR
    #define UDIR _UDIR
    #define dirent _dirent
    #define udirent _udirent

    #include <_na.h>
    #if _NA_NAMES
	_NA(opendir)
	_NA(readdir)
	_NA(rewinddir)
	_NA(closedir)
    #elif _HOBBIT
	DIR *		 opendir(const char *__dirname);
	struct dirent  * readdir(DIR *__dir);
	void		 rewinddir(DIR *__dir);
	int		 closedir(DIR *__dir);
    #endif /* _NA_NAMES */

#endif /* __HIGHC__ */

/* Unicode functions
 */
_UDIR *		 _uopendir(const _unichar *__dirname);
struct _udirent *_ureaddir(_UDIR *__dirp);
void		 _urewinddir(_UDIR *__dirp);
int		 _uclosedir(_UDIR *__dirp);

#ifdef __UNICODE__
    #define Uopendir _uopendir
    #define Ureaddir _ureaddir
    #define Urewinddir _urewinddir
    #define Uclosedir _uclosedir
#elif _MSDOS || _OS2 || _MSNT
    #define Uopendir _opendir
    #define Ureaddir _readdir
    #define Urewinddir _rewinddir
    #define Uclosedir _closedir
#elif _HOBBIT && __HIGHC__
    #define Uopendir opendir
    #define Ureaddir readdir
    #define Urewinddir rewinddir
    #define Uclosedir closedir
#endif /* __UNICODE__ */

#ifdef __CPLUSPLUS__
}
#endif
#endif /*_DIRENT_H*/
