/*
 *   fcntl.h -- extra-ANSI 
 *
 *   Constants to control file opening and operations on file handles.
 *
 *           Copyright (c) 1990, 1993, MetaWare Incorporated
 */

#ifndef _FCNTL_H
#define _FCNTL_H

#ifdef __CPLUSPLUS__
extern "C" {
#endif

#ifndef _UNICHAR_DEFINED
    typedef unsigned short _unichar;
    #define _UNICHAR _unichar
    #define _UNICHAR_DEFINED;
#endif

#define _O_RDONLY 0
#define _O_WRONLY 1
#define _O_RDWR   2
#define _O_APPEND 8

#define _O_NOINHERIT 128

#define _O_CREAT 256
#define _O_TRUNC 512
#define _O_EXCL 1024

#define _O_TEXT   0x4000
#define _O_BINARY 0x8000
#define _O_RAW    0x8000

#if __HIGHC__

    #define O_RDONLY 	_O_RDONLY 
    #define O_WRONLY 	_O_WRONLY 
    #define O_RDWR 	_O_RDWR 
    #define O_APPEND 	_O_APPEND 

    #define O_NOINHERIT _O_NOINHERIT

    #define O_CREAT 	_O_CREAT
    #define O_TRUNC 	_O_TRUNC
    #define O_EXCL 	_O_EXCL 

    #define O_TEXT 	_O_TEXT
    #define O_BINARY 	_O_BINARY
    #define O_RAW 	_O_RAW

#endif

extern int   _creat(const char *,int );
extern int   _open(const char *,int ,...);

#include <_na.h>
#if _NA_NAMES
    _NA(creat)
    _NA(open)
#elif _HOBBIT && __HIGHC__
    extern int creat(const char *,int );
    extern int open(const char *,int ,...);
#endif

/* Unicode functions
 */
extern int 	 _uopen(const _unichar *, int, ...);
extern int 	 _ucreat(const _unichar *, int);

#ifdef __UNICODE__
    #define Ucreat _ucreat
    #define Uopen  _uopen
#elif _MSDOS || _OS2 || _MSNT
    #define Ucreat _creat
    #define Uopen  _open
#elif _HOBBIT && __HIGHC__
    #define Ucreat creat
    #define Uopen  open
#endif


#ifdef __CPLUSPLUS__
}
#endif
#endif /* _FCNTL_H */
