/*----------------------------------------------------------------------------;
;	NAME:	GDA  -	GLOBAL DATA AREA FOR 386 PROGRAMS		      ;
;  COPYRIGHT:	SOFTGUARD SYSTEMS, INC. 1986, 1987.  ALL RIGHTS RESERVED.     ;
;----------------------------------------------------------------------------*/
#ifndef _GDA_H
#define _GDA_H
#pragma push_align_members(64);

#ifdef __CPLUSPLUS__
extern "C" {
#endif

typedef struct {
    char eye[4]; 			/* EYECATCHER */
    char rlse[4];			/* VMRUN RELEASE LEVEL */
    int prv;				/* LOCATION OF PREVIOUS GDA (FLAT) */
    int nxt;				/* LOCATION OF NEXT GDA (FLAT) */
    int pspa;				/* PSP ADDRESS (FLAT) */
    int pspa6;				/* PSP ADDRESS (OFF:SEG) */
    int pro;				/* PROFILE ADDRESS (FLAT) */
    int ldpt;				/* APPLICATION START ADDR (FLAT) */

    struct { 			/* POINTER TO 256 ENTRY TABLE */
	void *before;		/* . FOR HIGH INTERCEPTS */
	void *after;		/* . ENTRIES ARE: */
				/* . DD FLAT ADDRESS OF "BEFORE" ROUTINE */
	} *hint;	        /* .. DD FLAT ADDRESS OF "AFTER" ROUTINE */

    int hint_reserved; 		/* RESERVED */

    struct { 			/* POINTER TO 32 ENTRY TABLE */
	void *flat; 		/* .. FOR INTEL INTERCEPTS */
	char count; 		/* .. ENTRIES ARE: */
	char dup[3]; 		/* .. DD FLAT ADDRESS */
	} *intel; 		/* .. DB PARAMETER COUNT (DWORDS) */
				/* .. DB 3 DUP(0) RESERVED */

    char irq0[2];       	/* SOFT INTS FOR IRQ'S 0-7 */
    char irq8[2];		/* SOFT INTS FOR IRQ'S 8-F */

    int serv;			/* POINTER TO SERVICE ROUTINE (FLAT) */
    int ldcsel;			/* APPLICATION CODE SELECTOR */
    int lddsel;			/* APPLICATION DATA SELECTOR */
    int hmem;			/* TOTAL AVAILABLE HIGH MEMORY IN K'S */
    int lmem;			/* TOTAL AVAILABLE LOW MEMORY IN K'S */
    int tstg;			/* TOTAL STORAGE IN K'S */
    int vstk;			/* A LOW STACK FOR V86 INTS (FLAT) */
    int vstk6;			/* A LOW STACK FOR V86 INTS (OFF:SEG) */
    int hlod;			/* HIGHEST USED LOAD ADDRESS */
				/*  THIS VALUE WILL BE EITHER THE */
				/*  TOP OF THE 386 PROGRAM */
				/*  OR THE TOP OF AN APPENDED STACK */

    int tlow;			/* HIGHEST USED LOW ADDRESS */
				/*  THIS VALUE CAN BE USED FOR */
				/*  FREEBLOCK REQUESTS */

    int lbuff;			/* ADDRESS OF USER LOW BUFFER (FLAT)*/
    int lbuff6;			/* ADDRESS OF USER LOW BUFFER (OFF:SEG) */
    int buffsz;			/* SIZE OF LOW BUFFER IN K'S */

    int work;			/* PTR TO USER LOW WORK AREA (FLAT) */
    int work6;			/* PTR TO USER LOW WORK AREA (OFF:SEG) */
    int worksz;			/* LENGTH OF USER WORK AREA IN BYTES */

    int stk;			/* PTR TO STACK (FLAT) */
    int stksz;			/* LENGTH OF STACK IN K'S */
    int mstksz;			/* MAX LENGTH OF STACK IN K'S */

    int vbuff;			/* PTR TO VM LOW BUFFERS (FLAT) */
    int vbuff6; 		/* PTR TO VM LOW BUFFERS (OFF:SEG) */
    int vbuffsz; 		/* LENGTH OF VM BUFFERS (MAX) IN K'S */

    int vwrk; 			/* PTR TO VM LOW WORK AREA (FLAT) */
    int vwrk6; 			/* PTR TO VM LOW WORK AREA (OFF:SEG) */
    int vwrksz; 		/* LENGTH OF VM WORK AREA IN BYTES */

    int dta; 			/* LOW DTA PTR (FLAT) */
    int dta6; 			/* LOW DTA PTR (OFF:SEG) */
    int dtasz;			/* LOW DTA SIZE (MAXIMUM) IN BYTES */
    int dtasz_reserved; 	/* ...RESERVED */

    int asy;			/* LOCATION OF ASYNCH PROFILE (FLAT) */
    int asy6;			/* LOCATION OF ASYNCH PROFILE (OFF:SEG) */

    int vmb;			/* LOCATION OF VMLD (FLAT) */
    int vmb6;			/* LOCATION OF VMLD (OFF:SEG) */

    char stov;			/* ACTION ON STACK OVERFLOW */
				/*  E=EXPAND */
				/*  Q=QUIT */
				/*  D=DEBUG */

    char dpl;			/*  DPL */
    char iop;			/*  IOPL */
    char iop_reserved;		/*  ...RESERVED */

				/*  DEBUG OPTIONS FOR APPLICATIONS */
    char p_asy;			/*  ASYNCH DEBUGGER OPTION */
				/*  Y=YES N=NO */
    char dbg;			/*  INITIAL BREAKPOINT FOR DEBUG */
				/*  Y=YES N=NO */
    char dbg_reserved[2];	/*  ...RESERVED */
    int dbp;			/*  INITIAL BREAKPOINT VALUE FOR DEBUG */

    int trace; 			/*  LOCATION OF TRACE TABLE */

    int symh; 			/* LOCATION OF SYMBOL TABLE HEADER */
    int  symsz; 		/* LEN OF SYMBOL TABLE-EXCLUDE WORD AREA */
    int swk; 			/* LOCATION OF SYMBOL TABLE WORK AREA */
    int swksz; 			/* LEN OF SYMBOL TABLE WORK AREA */

    char nmi; 			/* ..V=V86, D=DEBUG */
    char rmp; 			/* ..Y=YES N=NO */
    char ttb; 			/* ..Y=YES N=NO */
    char com; 			/* ..1 OR 2 */
    char sym; 			/* ..Y=YES N=NO */
    char hpl; 			/* ..Y=YES N=NO */
    char hpl_reserved[2];	/* RESERVED FOR FUTURE USE */

    int vstksz;			/* SIZE OF LOW STACK FOR V86 INTS */
    int vstksz_reserved[12];	/* .. */

    int r1;			/*  RESERVED FOR SOFTGUARD */
    int r2; 			/*  .. */
    int r3; 			/*  .. */
    int r4; 			/*  .. */

    int u1; 			/*  RESERVED FOR USER */
    int u2; 			/*  .. */
    int u3; 			/*  .. */
    int u4; 			/*  .. */
    int u5; 			/*  .. */
    int u6; 			/*  .. */
    int u7; 			/*  .. */
    int u8; 			/*  .. */
    } GDA;
#ifdef __CPLUSPLUS__
}
#endif

#pragma pop_align_members();
#endif
