/*
 *   io.h -- extra-ANSI 
 *
 *   DOS file service functions.
 *
 *           Copyright (c) 1990, MetaWare Incorporated
 */

#ifndef _IO_H
#define _IO_H

#ifdef __CPLUSPLUS__
extern "C" {
#endif

#ifndef _UNICHAR_DEFINED
    typedef unsigned short _unichar;
    #define _UNICHAR _unichar
    #define _UNICHAR_DEFINED;
#endif

#ifndef _FSIZE_T_DEFINED
    typedef unsigned long _fsize_t;
    #define _FSIZE_T_DEFINED
#endif

#ifndef _TIME_T_DEFINED
    typedef long time_t;
    #define _TIME_T_DEFINED
#endif

struct _finddata_t {
    unsigned attrib;
    time_t time_create;  /* -1 if not supported (i.e., FAT file system) */
    time_t time_access;  /* -1 if not supported */
    time_t time_write;
    _fsize_t size;
    char name[260];
    };

extern int   _access(const char *,int);
extern int   _chmod(const char *,int);
extern int   _chsize(int ,long);
extern int   _close(int);
extern int   _creat(const char *,int);
extern int   _dup(int);
extern int   _dup2(int,int);
extern int   _eof(int);
extern long  _filelength(int);
extern long  _findfirst(char *__filespec, struct _finddata_t *__fileinfo);
extern int   _findnext(long __handle, struct _finddata_t *__fileinfo);
extern int   _findclose(long __handle);
extern int   _isatty(int);
extern int   _locking(int ,int ,long);
extern long  _lseek(int ,long,int);
extern char *_mktemp(char *);
extern int   _open(const char *,int ,...);
extern int   _read(int ,char *,unsigned int);
extern int   _sopen(const char *,int ,int ,...);
extern long  _tell(int);
extern int   _umask(int);
extern int   _unlink(const char *);
extern int   _write(int, const void *, unsigned int);

#if _OS2 || _MSNT
extern int   _pipe(int *, unsigned int, int);
#endif

/* may be set with constants from "share.h" to specify default sharing mode
   for function _open.  This will also affect the "fopen" and "freopen".
   _sharing_mode is not used when sharing is explicitly specified, as in
   _sopen and _fsopen.
*/
extern int _sharing_mode;

#if __HIGHC__
    extern	int remove(const char *__pathname);
    extern	int rename(const char *__old, const char *__new);
#endif

#include <_na.h>
#if _NA_NAMES
    _NA(access)
    _NA(chmod)
    _NA(chsize)
    _NA(close)
    _NA(creat)
    _NA(dup)
    _NA(dup2)
    _NA(eof)
    _NA(filelength)
    _NA(isatty)
    _NA(locking)
    _NA(lseek)
    _NA(mktemp)
    _NA(open)
    _NA(read)
    _NA(sopen)
    _NA(tell)
    _NA(umask)
    _NA(unlink)
    _NA(write)
    #if _OS2 || _MSNT
	_NA(pipe)
    #endif
#elif (_MSDOS || _HOBBIT) && __HIGHC__
    extern int access(const char *,int);
    extern int chmod(const char *,int);
    extern int chsize(int ,long);
    extern int close(int);
    extern int creat(const char *,int);
    extern int dup(int);
    extern int dup2(int,int);
    extern int eof(int);
    extern long filelength(int);
    extern int isatty(int);
    extern int locking(int ,int ,long);
    extern long lseek(int ,long,int);
    extern char *mktemp(char *);
    extern int open(const char *,int ,...);
    extern int read(int ,char *,unsigned int);
    extern int remove(const char *);
    extern int rename(const char *,const char *);
    extern int sopen(const char *,int ,int ,...);
    extern long tell(int);
    extern int umask(int);
    extern int unlink(const char *);
    extern int write(int, const void *, unsigned int);
#endif

/* Unicode functions */

extern int	 _uaccess(const _unichar *, int);
extern int	 _uchmod(const _unichar *, int);
extern int 	 _ucreat(const _unichar *, int);
extern _unichar *_umktemp(_unichar *);
extern int 	 _uopen(const _unichar *, int, ...);
extern int	 _uunlink(const _unichar *);

#ifdef __UNICODE__
    #define Uaccess _uaccess
    #define Uchmod _uchmod
    #define Ucreat _ucreat
    #define Umktemp _umktemp
    #define Uopen  _uopen
    #define Uunlink _uunlink
#elif _MSDOS || _OS2 || _MSNT
    #define Uaccess _access
    #define Uchmod _chmod
    #define Ucreat _creat
    #define Umktemp _mktemp
    #define Uopen  _open
    #define Uunlink _unlink
#elif _HOBBIT && __HIGHC__
    #define Uaccess access
    #define Uchmod chmod
    #define Ucreat creat
    #define Umktemp mktemp
    #define Uopen  open
    #define Uunlink unlink
#endif

#ifdef __CPLUSPLUS__
}
#endif
#endif /* _IO_H */
