/*
 *   process.h -- extra-ANSI 
 *
 *   Functions and constants needed to control the active
 *   processes running in the computer system.
 *
 *           Copyright (c) 1990, MetaWare Incorporated
 */

#ifndef _PROCESS_H
#define _PROCESS_H

#ifdef __CPLUSPLUS__
extern "C" {
#endif

/* only _P_WAIT supported on MSDOS */
#define _P_WAIT    0
#define _P_NOWAIT  1
#define _P_OVERLAY 2
#define _P_NOWAITO 3
#define _P_DETACH  4
#define _WAIT_CHILD 0
#define _WAIT_GRANDCHILD 1

extern int _getpid(void);
extern int _spawnl(int __mode, const char * __path, const char * __arg0, ...);
extern int _spawnle(int __mode, const char * __path, const char * __arg0, ...);
extern int _spawnlp(int __mode, const char * __path, const char * __arg0, ...);
extern int _spawnlpe(int __mode, const char * __path, const char * __arg0, ...);
extern int _spawnv(int __mode, const char * __path, char ** __argv);
extern int _spawnve(int __mode, const char * __path, char ** __argv, char ** __envp);
extern int _spawnvp(int __mode, const char * __path, char ** __argv);
extern int _spawnvpe(int __mode, const char * __path, char ** __argv, char ** __envp);
extern int _execl (const char *__path, const char *__arg0, ...); 
extern int _execle (const char *__path, const char *__arg0, ...);
extern int _execlp (const char *__path, const char *__arg0, ...); 
extern int _execlpe (const char *__path, const char *__arg0, ...);
extern int _execv (const char *__path, char **__argv);
extern int _execve (const char *__path, char **__argv, char **__envp);
extern int _execvp (const char *__path, char **__argv);
extern int _execvpe (const char *__path, char **__argv, char **__envp);
#if _MSNT || _OS2
extern int _cwait(int *__statloc, int __pid, int __action);
extern int _wait(int *__statloc);
#endif

#if defined(_REENTRANT) && (_MSNT || _OS2)	/* if multi-thread */
    #if _MSNT
    extern unsigned long  /* returns thread HANDLE on NT */
    #else
    extern int		  /* returns thread ID on OS/2 */
    #endif
	       _beginthread (void (*__start)(void *), unsigned __stack_size,
			      void *__args);
    extern void _endthread (void);
    extern void _endthreadex(unsigned __exit_code);
    extern unsigned long __threadid(void);
    #ifndef _threadid
	#define _threadid (__threadid())
    #endif
    #if _MSNT
	  /* Provides full access to Win32 CreateThread interface.
	     Return is actually HANDLE. thread-id returned by _beginthread
	     is returned here in '__thread_id'.
	   */
	extern unsigned long _beginthreadex(
		void *__security_attrib,      /* LPSECURITY_ATTRIBUTES */
		unsigned long __create_flags, /* 0, CREATE_SUSPENDED, etc. */
		void (*__start_address)(void *),
		unsigned __stack_size,
		void *__args,
		unsigned long *__thread_id);
	    /* Borland call equivalent to _beginthreadex */
	extern unsigned long _beginthreadNT(void (*__start)(void *),
		unsigned __stack_size, void *__args,
		void *__security_attrib,      /* LPSECURITY_ATTRIBUTES */
		unsigned long __create_flags, /* 0, CREATE_SUSPENDED, etc. */
		unsigned long *__thread_id);
    #endif
#endif

#if __HIGHC__

#define P_WAIT    _P_WAIT
#define P_NOWAIT  _P_NOWAIT
#define P_OVERLAY _P_OVERLAY
#define P_NOWAITO _P_NOWAITO
#define P_DETACH  _P_DETACH
#define WAIT_CHILD _WAIT_CHILD
#define WAIT_GRANDCHILD _WAIT_GRANDCHILD

extern void abort(void);
extern void exit(int __status);
extern int system(const char *__string);

#include <_na.h>
#if _NA_NAMES
    _NA(getpid)
    _NA(spawnl)
    _NA(spawnle)
    _NA(spawnlp)
    _NA(spawnlpe)
    _NA(spawnv)
    _NA(spawnve)
    _NA(spawnvp)
    _NA(spawnvpe)
    _NA(execl)
    _NA(execle)
    _NA(execlp)
    _NA(execlpe)
    _NA(execv)
    _NA(execve)
    _NA(execvp)
    _NA(execvpe)
#if _MSNT || _OS2
    _NA(cwait)
    _NA(wait)
#endif
#elif _MSDOS
    extern int getpid(void);
    extern int spawnl(int __mode, char * __path, char * __arg0, ...);
    extern int spawnle(int __mode, char * __path, char * __arg0, ...);
    extern int spawnlp(int __mode, char * __path, char * __arg0, ...);
    extern int spawnlpe(int __mode, char * __path, char * __arg0, ...);
    extern int spawnv(int __mode, char * __path, char ** __argv);
    extern int spawnve(int __mode, char * __path, char ** __argv,
	    char ** __envp);
    extern int spawnvp(int __mode, char * __path, char ** __argv);
    extern int spawnvpe(int __mode, char * __path, char ** __argv,
	    char ** __envp);
    extern int execl (char *__path, char *__arg0, ...); 
    extern int execle (char *__path, char *__arg0, ...);
    extern int execlp (char *__path, char *__arg0, ...); 
    extern int execlpe (char *__path, char *__arg0, ...);
    extern int execv (char *__path, char **__argv);
    extern int execve (char *__path, char **__argv, char **__envp);
    extern int execvp (char *__path, char **__argv);
    extern int execvpe (char *__path, char **__argv, char **__envp);
#endif /* _NA_NAMES */

#endif /* __HIGHC__ */

#ifdef __CPLUSPLUS__
}
#endif
#endif /* _PROCESS_H */
