/*   profile.h -- extra-ANSI 
 *
 *   Profiler routines.
 *      Copyright (c) 1990, MetaWare Incorporated
 */
#ifndef _PROFILE_H
#define _PROFILE_H

#ifdef __CPLUSPLUS__
extern "C" {
#endif

/* Call to start the profiler. The profiler starts profiling as soon
 * as the function returns.
 */
void _profile_start(char *argv0, char *mapfile, char *monfile, int minutes, int times);

/* Call to stop the profiler. Usually called by the "atexit" function. */
void _profile_end();

/* Call to temporarily suspend profiling. */
void _profile_suspend();

/* Call to restart profiling after it has been suspended. */
void _profile_restart();

/* Default profiler setup. Easy interface to call to start and automatically
 * stop the profiler at exit. This function will call the above two.
 */
void _profile_setup(int argc, char **argv);

/*   The default number of minutes to run. */
#define _DEFAULT_MINUTES        5

/*   The default frequency. */
/*   As close to 500 as is possible. */
#define _DEFAULT_TIMES          504

/*  _profile_minutes is the number of minutes the profiler will run.
 *  _profile_times is the frequency in samples per second.
 *  _profile_on is a flag that is set to TRUE (1) if the profiler is active.
 */
extern int _profile_minutes,
           _profile_times,
           _profile_on;

#ifdef __CPLUSPLUS__
}
#endif
#endif /* _PROFILE_H */
