/*
 *   timeb.h -- extra-ANSI 
 *
 *   Definitions needed by the ftime function.
 *
 *           Copyright (c) 1990, MetaWare Incorporated
 */

#ifndef _TIMEB_H
#define _TIMEB_H
#pragma push_align_members(64);

#ifdef __CPLUSPLUS__
extern "C" {
#endif

#ifndef _TIME_T_DEFINED
#define _TIME_T_DEFINED
typedef long time_t;
#endif

#ifndef _TIMEB_DEFINED
#define _TIMEB_DEFINED
#if _MSDOS && _REENTRANT
	/* _REENTRANT macro for otherwise global variable "timezone" from
	   time.h conflicts with member name below.  Must refer to the global
	   "timezone" as "_timezone" if -Hthread is used and <timeb.h> is
	   included! Workaround: this restriction is removed if timeb.h is the
	   first header file included by the program! Specifically, timeb.h
	   must be included before static.h is read, so that "timezone" will
	   get redefined to it's intended value as a macro. */
	#undef timezone
#endif
struct _timeb {
	time_t time;
	unsigned short millitm;
	short timezone;
	short dstflag;
	};
#endif

extern void _ftime(struct _timeb * __tptr);

#include <_na.h>
#if _NA_NAMES
    #define timeb _timeb
    _NA(ftime)
#elif _MSDOS && __HIGHC__
    #define timeb _timeb
    extern void ftime(struct timeb * __tptr);
#endif /* _NA_NAMES */

#ifdef __CPLUSPLUS__
}
#endif
#pragma pop_align_members();
#endif /* _TIMEB_H */
