/*
 *   utime.h -- extra-ANSI 
 *
 *   Definitions needed by the utime function.
 *
 *           Copyright (c) 1990, 1993, MetaWare Incorporated
 */

#ifndef _UTIME_H
#define _UTIME_H
#pragma push_align_members(64);

#ifdef __CPLUSPLUS__
extern "C" {
#endif

#ifndef _UNICHAR_DEFINED
    typedef unsigned short _UNICHAR;
    #define _unichar _UNICHAR
    #define _UNICHAR_DEFINED
#endif

#ifndef _TIME_T_DEFINED
    #define _TIME_T_DEFINED
    typedef long time_t;
#endif

#ifndef _UTIMBUF_DEFINED
    #define _UTIMBUF_DEFINED

    struct _utimbuf {
	time_t actime;
	time_t modtime;
	};
#endif

int _utime (const char * __pathname, const struct _utimbuf * __newtime);
int _uutime(const _unichar * __pathname, const struct _utimbuf * __newtime);

#if _MSDOS || _MSNT || _OS2
    extern int _futime(int __filedes, const struct _utimbuf * __newtime);
#endif

#ifdef __UNICODE__
    #define Uutime _uutime
#elif _MSDOS || _OS2 || _MSNT
    #define Uutime _utime
#elif _HOBBIT && __HIGHC__
    #define Uutime utime
#endif

#include <_na.h>
#if _NA_NAMES
    _NA(utime)
#elif __HIGHC__
    int utime (const char * __pathname, const struct _utimbuf * __newtime);
#endif /* _NA_NAMES */

#if __HIGHC__
    #define utimbuf _utimbuf
#endif

#ifdef __CPLUSPLUS__
}
#endif
#pragma pop_align_members();
#endif /* _UTIME_H */
