/*
 *   errno.h -- ANSI 
 *
 *   Error code values.
 *
 *           Copyright (c) 1990-1994, MetaWare Incorporated
 */

#ifndef _ERRNO_H
#define _ERRNO_H	

#ifdef __CPLUSPLUS__
extern "C" {
#endif

#ifdef __PENPOINT__
#ifndef GO_INCLUDED
  #include <go.h>
#endif
#ifndef CLSMGR_INCLUDED
  #include <clsmgr.h>
#endif
#ifndef FS_INCLUDED
  #include <fs.h>
#endif
#ifndef GOMATH_INCLUDED
  #include <gomath.h>
#endif

/* Create an errno value from a PenPoint status */
#define StsToErrno(sts) ((U32)(sts)&~flag31)

/* Create a PenPoint status from an errno value */
#define ErrnoToSts(errno)   ((U32)(errno)|flag31)

#define EOK     StsToErrno(stsOK)           /* No error */
#define EINVAL  StsToErrno(stsBadParam)     /* Invalid argument */
#define ENOMEM  StsToErrno(stsOSOutOfMem)   /* No memory */
#define EBADF   StsToErrno(stsBadObject)    /* Bad file number */
#define ENOSPC  StsToErrno(stsFSVolFull)    /* No space left on device */

#define EIO	StsToErrno(stsFailed)
#define ENFILE  StsToErrno(stsOutOfMem)

/* math errors */
#define EDOM    StsToErrno(stsMathDomain)   /* Argument too large */
#define ERANGE  StsToErrno(stsMathRange)    /* Result too large */

#elif	_OS2 && _PPC		/* oppc */

#define EZERO		0		/* No error */

#define EDOM      	1		/* domain error */
#define ERANGE    	2		/* range error */

#define EBADMODE        3		/* the string mode is invalid */
#define EBADNAME        4		/* filename was invalid */
#define EISTEMPMEM      5		/* */
#define EBADSHARE       6		/* file cannot be shared */
#define EBUFMODE        7		/* buffer mode is not valid */
#define EERRSET         8		/* read/write error occured */
#define EISOPEN         9		/* memory file is currently open */
#define ENOTEXIST      10		/* memory file does not exist */
#define ENOTINIT       11		/* stream is not in initialized state */
#define ENULLFCB       12		/* stream FCB pointer is NULL */
#define EOUTOFMEM      13		/* no memory available for space block*/
#define ESMALLBF       14		/* buffer size is less than one for byte files */
#define EEXIST         16		/* File exists */
#define ENOGEN         17		/* a guaranteed unique file name could not be generated */
#define ENOSEEK        19		/* file positioning is not permitted for this stream */
#define EBADPOS        20		/* file position is invalid */
#define EBADSEEK       22		/* attempted seek beyond beginning of file or end of text */
#define ENOENT         23		/* No such file or directory */
#define EACCESS        24		/* cannot access file */
#define EMFILE         25		/* Too many open files */
#define ENOCMD         26		/* A command processor could not be found */
#define EGETANDPUT     28		/* illegal read after write */
#define EPASTEOF       29		/* Attempt to read past end-of-file */
#define ENOTREAD       30		/* file not opened for read */
#define ETOOMANYUNGETC 31		/* too many ungetc attempted */
#define EUNGETEOF      32		/* Attempt to unget an EOF */
#define EPUTUNGET      33		/* cannot do an unget after put */
#define ECHILD         34		/* No children */
#define EINTR          35		/* Interrupted system call */
#define EINVAL         36		/* Invalid argument */
#define ENOEXEC        37		/* Exec format error */
#define EAGAIN         38		/* No more processes */
#define EBADTYPE       39		/* stream has a wrong file type for this operation */
#define ENOTWRITE      40		/* file not opened for write */
#define EPUTANDGET     41		/* illegal write after read */
#define ELARGEBF       42		/* IO buffer provided is too large */
#define EBADF          43		/* Bad file number */
#define EXDEV          44		/* Cross-device link */
#define ENOSPC         45		/* No space left on device */
#define EMATH          46		/* returned value is NAN */
#define EMODNAME       47		/* module name is invalid */
#define EMAXATTR       49		/* Bad mode attributes for file open */
#define EREADERROR     50		/* Bad read error */
#define EBADATTR       51		/* Bad mode attribute for file open */

#define EOS2ERR 60                  	/* OS/2 error */

#define ENOMEM  EOUTOFMEM		/* Not enough core */
#define EACCES  EACCESS			/* Permission denied */

#define	EPERM		65		/* Not owner */
#define	ESRCH		66		/* No such process */
#define	EIO		67		/* I/O error */
#define	ENXIO		68		/* No such device or address */
#define	E2BIG		69		/* Arg list too long */
#define	EFAULT		70		/* Bad address */
#define	ENOTBLK		71		/* Block device required */
#define	EBUSY		72		/* Mount device busy */
#define	ENODEV		73		/* No such device */
#define	ENOTDIR		74		/* Not a directory*/
#define	EISDIR		75		/* Is a directory */
#define	ENFILE		76		/* File table overflow */
#define	ENOTTY		77		/* Not a typewriter */
#define	ETXTBSY		78		/* Text file busy */
#define	EFBIG		79		/* File too large */
#define	ESPIPE		80		/* Illegal seek */
#define	EROFS		81		/* Read-only file system */
#define	EMLINK		82		/* Too many links */
#define	EPIPE		83		/* Broken pipe */

/* non-blocking and interrupt i/o */
#define	EWOULDBLOCK	84	/* Operation would block */
#define	EDEADLK		EWOULDBLOCK	/*  ditto */
#define EDEADLOCK	EDEADLK
#define	EINPROGRESS	85	/* Operation now in progress */
#define	EALREADY	86	/* Operation already in progress */

/* ipc/network software */
#define	ENOTSOCK	90	/* Socket operation on non-socket */
#define	EDESTADDRREQ	91	/* Destination address required */
#define	EMSGSIZE	92	/* Message too long */
#define	EPROTOTYPE	93	/* Protocol wrong type for socket */
#define	ENOPROTOOPT	94	/* Protocol not available */
#define	EPROTONOSUPPORT	95	/* Protocol not supported */
#define	ESOCKTNOSUPPORT	96	/* Socket type not supported */
#define	EOPNOTSUPP	97	/* Operation not supported on socket */
#define	EPFNOSUPPORT	98	/* Protocol family not supported */
#define	EAFNOSUPPORT	99	/* Address family not supported by protocol family */
#define	EADDRINUSE	100	/* Address already in use */
#define	EADDRNOTAVAIL	101	/* Can't assign requested address */
/* operational errors */
#define	ENETDOWN	102	/* Network is down */
#define	ENETUNREACH	103	/* Network is unreachable */
#define	ENETRESET	104	/* Network dropped connection on reset*/
#define	ECONNABORTED	105	/* Software caused connection abort */
#define	ECONNRESET	106	/* Connection reset by peer */
#define	ENOBUFS		107	/* No buffer space available */
#define	EISCONN		108	/* Socket is already connected */
#define	ENOTCONN	109	/* Socket is not connected */
#define	ESHUTDOWN	110	/* Can't send after socket shutdown */
#define	ETOOMANYREFS	111	/* Too many references: can't splice */
#define	ETIMEDOUT	112	/* Connection timed out */
#define	ECONNREFUSED	113	/* Connection refused */
#define	EHOSTDOWN	114	/* Host is down */
#define	EHOSTUNREACH	115	/* No route to host */
#define	ELOOP		116	/* Too many levels of symbolic links */
#define	ENAMETOOLONG	117	/* File name too long */
#define	ENOTEMPTY	118	/* Directory not empty */
/* quotas & mush */
#define	EPROCLIM	119	/* Too many processes */
#define	EUSERS		120	/* Too many users */
#define	EDQUOT		121	/* Disc quota exceeded */
#define EVDBAD		122	/* RVD related disk error */

#else	/* not __PENPOINT__ nor oppc */

#define EZERO		0		/* No error */
#define	EPERM		1		/* Not owner */
#define	ENOENT		2		/* No such file or directory */
#define	ESRCH		3		/* No such process */
#define	EINTR		4		/* Interrupted system call */
#define	EIO		5		/* I/O error */
#define	ENXIO		6		/* No such device or address */
#define	E2BIG		7		/* Arg list too long */
#define	ENOEXEC		8		/* Exec format error */
#define	EBADF		9		/* Bad file number */
#define	ECHILD		10		/* No children */
#define	EAGAIN		11		/* No more processes */
#define	ENOMEM		12		/* Not enough core */
#define	EACCES		13		/* Permission denied */
#define	EFAULT		14		/* Bad address */
#define	ENOTBLK		15		/* Block device required */
#define	EBUSY		16		/* Mount device busy */
#define	EEXIST		17		/* File exists */
#define	EXDEV		18		/* Cross-device link */
#define	ENODEV		19		/* No such device */
#define	ENOTDIR		20		/* Not a directory*/
#define	EISDIR		21		/* Is a directory */
#define	EINVAL		22		/* Invalid argument */
#define	ENFILE		23		/* File table overflow */
#define	EMFILE		24		/* Too many open files */
#define	ENOTTY		25		/* Not a typewriter */
#define	ETXTBSY		26		/* Text file busy */
#define	EFBIG		27		/* File too large */
#define	ENOSPC		28		/* No space left on device */
#define	ESPIPE		29		/* Illegal seek */
#define	EROFS		30		/* Read-only file system */
#define	EMLINK		31		/* Too many links */
#define	EPIPE		32		/* Broken pipe */

/* math software */
#undef  EDOM
#define	EDOM		33		/* Argument too large */
#undef  ERANGE
#define	ERANGE		34		/* Result too large */

/* non-blocking and interrupt i/o */
#if _SOL
    #define	EWOULDBLOCK	EAGAIN
    #define	EDEADLK		45	/* Deadlock condition.	*/
    #define	EDEADLOCK 	56	/* file locking deadlock error */
    #define	EINPROGRESS	150	/* operation now in progress */
    #define	EALREADY	149	/* operation already in progress */
#else
    #define	EWOULDBLOCK	35	/* Operation would block */
    #if _SUN && _SPARC
	/* SystemV Record Locking */
	#define EDEADLK		78	/* Deadlock condition. */
    #else
	#define	EDEADLK		EWOULDBLOCK	/*  ditto */
    #endif
    #define 	EDEADLOCK	EDEADLK
    #define	EINPROGRESS	36	/* Operation now in progress */
    #define	EALREADY	37	/* Operation already in progress */
#endif

/* ipc/network software */

	/* argument errors */
#if _SOL
    #define	ENOTSOCK	95	/* Socket operation on non-socket */
    #define	EDESTADDRREQ	96	/* Destination address required */
    #define	EMSGSIZE	97	/* Message too long */
    #define	EPROTOTYPE	98	/* Protocol wrong type for socket */
    #define	ENOPROTOOPT	99	/* Protocol not available */
    #define	EPROTONOSUPPORT	120	/* Protocol not supported */
    #define	ESOCKTNOSUPPORT	121	/* Socket type not supported */
    #define	EOPNOTSUPP	122	/* Operation not supported on socket */
    #define	EPFNOSUPPORT	123	/* Protocol family not supported */
    #define	EAFNOSUPPORT	124	/* Address family not supported by */
    #define	EADDRINUSE	125	/* Address already in use */
    #define	EADDRNOTAVAIL	126	/* Can't assign requested address */
	/* operational errors */
    #define	ENETDOWN	127	/* Network is down */
    #define	ENETUNREACH	128	/* Network is unreachable */
    #define	ENETRESET	129	/* Network dropped connection because */
				        /* of reset */
    #define	ECONNABORTED	130	/* Software caused connection abort */
    #define	ECONNRESET	131	/* Connection reset by peer */
    #define	ENOBUFS		132	/* No buffer space available */
    #define	EISCONN		133	/* Socket is already connected */
    #define	ENOTCONN	134	/* Socket is not connected */
    /* 135 - 142 reserved for XENIX */
    #define	ESHUTDOWN	143	/* Can't send after socket shutdown */
    #define	ETOOMANYREFS	144	/* Too many references: can't splice */
    #define	ETIMEDOUT	145	/* Connection timed out */
    #define	ECONNREFUSED	146	/* Connection refused */
    #define	EHOSTDOWN	147	/* Host is down */
    #define	EHOSTUNREACH	148	/* No route to host */
#else
    #define	ENOTSOCK	38	/* Socket operation on non-socket */
    #define	EDESTADDRREQ	39	/* Destination address required */
    #define	EMSGSIZE	40	/* Message too long */
    #define	EPROTOTYPE	41	/* Protocol wrong type for socket */
    #define	ENOPROTOOPT	42	/* Protocol not available */
    #define	EPROTONOSUPPORT	43	/* Protocol not supported */
    #define	ESOCKTNOSUPPORT	44	/* Socket type not supported */
    #define	EOPNOTSUPP	45	/* Operation not supported on socket */
    #define	EPFNOSUPPORT	46	/* Protocol family not supported */
    #define	EAFNOSUPPORT	47	/* Address family not supported by protocol family */
    #define	EADDRINUSE	48	/* Address already in use */
    #define	EADDRNOTAVAIL	49	/* Can't assign requested address */
	/* operational errors */
    #define	ENETDOWN	50	/* Network is down */
    #define	ENETUNREACH	51	/* Network is unreachable */
    #define	ENETRESET	52	/* Network dropped connection on reset*/
    #define	ECONNABORTED	53	/* Software caused connection abort */
    #define	ECONNRESET	54	/* Connection reset by peer */
    #define	ENOBUFS		55	/* No buffer space available */
    #define	EISCONN		56	/* Socket is already connected */
    #define	ENOTCONN	57	/* Socket is not connected */
    #define	ESHUTDOWN	58	/* Can't send after socket shutdown */
    #define	ETOOMANYREFS	59	/* Too many references: can't splice */
    #define	ETIMEDOUT	60	/* Connection timed out */
    #define	ECONNREFUSED	61	/* Connection refused */
    #define	EHOSTDOWN	64	/* Host is down */
    #define	EHOSTUNREACH	65	/* No route to host */
#endif  /* _SOL */


#if _SOL
    #define	ENAMETOOLONG 	78	/* path name is too long */
    #define	ELOOP		90	/* Symbolic link loop	*/
    #define	ENOTEMPTY 	93	/* directory not empty	*/
    #define	EUSERS		94	/* Too many users (for UFS) */
#else
    #define	ELOOP		62	/* Too many levels of symbolic links */
    #define	ENAMETOOLONG	63	/* File name too long */
    #define	ENOTEMPTY	66	/* Directory not empty */
	/* quotas & mush */
    #define	EPROCLIM	67	/* Too many processes */
    #define	EUSERS		68	/* Too many users */
    #define	EDQUOT		69	/* Disc quota exceeded */
    #define 	EVDBAD		70	/* RVD related disk error */
#endif


#endif	/* __PENPOINT__ */


#ifdef VICE
/* Remote file access errors(that can't be mapped to standard error messages) */
#define ERFS		70		/* Remote file system error -- could be
					   anything; more precise details should
					   be reported elsewhere by the system*/
#define ENORMTWD	71		/* Out of remote working directory
					   structures */
#endif

#if _SOL
    #define	ENOMSG	35	/* No message of desired type		*/
    #define	EIDRM	36	/* Identifier removed			*/
    #define	ECHRNG	37	/* Channel number out of range		*/
    #define	EL2NSYNC 38	/* Level 2 not synchronized		*/
    #define	EL3HLT	39	/* Level 3 halted			*/
    #define	EL3RST	40	/* Level 3 reset			*/
    #define	ELNRNG	41	/* Link number out of range		*/
    #define	EUNATCH 42	/* Protocol driver not attached		*/
    #define	ENOCSI	43	/* No CSI structure available		*/
    #define	EL2HLT	44	/* Level 2 halted			*/
    #define	ENOLCK	46	/* No record locks available.		*/
    #define	ECANCELED 47	/* Operation canceled			*/
    #define	ENOTSUP	48	/* Operation not supported		*/
    #define	EBADE	50	/* invalid exchange			*/
    #define	EBADR	51	/* invalid request descriptor		*/
    #define	EXFULL	52	/* exchange full			*/
    #define	ENOANO	53	/* no anode				*/
    #define	EBADRQC	54	/* invalid request code			*/
    #define	EBADSLT	55	/* invalid slot				*/
    #define	EBFONT	57	/* bad font file fmt			*/
    #define	ENOSTR	60	/* Device not a stream			*/
    #define	ENODATA	61	/* no data (for no delay io)		*/
    #define	ETIME	62	/* timer expired			*/
    #define	ENOSR	63	/* out of streams resources		*/
    #define	ENONET	64	/* Machine is not on the network	*/
    #define	ENOPKG	65	/* Package not installed		*/
    #define	EREMOTE	66	/* The object is remote			*/
    #define	ENOLINK	67	/* the link has been severed		*/
    #define	EADV	68	/* advertise error			*/
    #define	ESRMNT	69	/* srmount error			*/
    #define	ECOMM	70	/* Communication error on send		*/
    #define	EPROTO	71	/* Protocol error			*/
    #define	EMULTIHOP 74	/* multihop attempted			*/
    #define	EBADMSG 77	/* trying to read unreadable message	*/
    #define	EOVERFLOW 79	/* value too large to be stored in data type */
    #define	ENOTUNIQ 80	/* given log. name not unique		*/
    #define	EBADFD	81	/* f.d. invalid for this operation	*/
    #define	EREMCHG	82	/* Remote address changed		*/
    #define	ELIBACC	83	/* Can't access a needed shared lib.	*/
    #define	ELIBBAD	84	/* Accessing a corrupted shared lib.	*/
    #define	ELIBSCN	85	/* .lib section in a.out corrupted.	*/
    #define	ELIBMAX	86	/* Attempting to link in too many libs.	*/
    #define	ELIBEXEC 87	/* Attempting to exec a shared library.	*/
    #define	EILSEQ	88	/* Illegal byte sequence.		*/
    #define	ENOSYS	89	/* Unsupported file system operation	*/
    #define	ERESTART 91	/* Restartable system call		*/
    #define	ESTRPIPE 92	/* if pipe/FIFO, don't sleep in stream head */

    /* SUN Network File System */
    #define	ESTALE		151	/* Stale NFS file handle */
#elif _SUN && _SPARC
    /* Network File System */
    #define	ESTALE		70	/* Stale NFS file handle */
    #define	EREMOTE		71	/* Too many levels of remote in path */

    /* streams */
    #define	ENOSTR		72	/* Device is not a stream */
    #define	ETIME		73	/* Timer expired */
    #define	ENOSR		74	/* Out of streams resources */
    #define	ENOMSG		75	/* No message of desired type */
    #define	EBADMSG		76	/* Trying to read unreadable message */

    /* SystemV IPC */
    #define EIDRM		77	/* Identifier removed */

    /* SystemV Record Locking */
    #define EDEADLK		78	/* Deadlock condition. */
    #define ENOLCK		79	/* No record locks available. */

    /* RFS */
    #define ENONET		80	/* Machine is not on the network */
    #define ERREMOTE		81	/* Object is remote */
    #define ENOLINK		82	/* the link has been severed */
    #define EADV		83	/* advertise error */
    #define ESRMNT		84	/* srmount error */
    #define ECOMM		85	/* Communication error on send */
    #define EPROTO		86	/* Protocol error */
    #define EMULTIHOP		87	/* multihop attempted */
    #define EDOTDOT		88	/* Cross mount point (not an error) */
    #define EREMCHG		89	/* Remote address changed */

    /* POSIX */
    #define ENOSYS		90	/* function not implemented */

#endif /* _SOL */


/* Note: errno cannot be declared as 
 * volatile, since that would prevent
 * it being passed by address to a routine
 * expecting an int * parameter. Also,
 * compiling with -Hunixlib prevents use
 * of this header file, making the declaration
 * useless. High C will mark errno as volatile
 * internally at compile time. Use of log,
 * log10, and other intrinsic functions on
 * some architectures requires this.
 */
#ifndef _CRTIMP
    #if _MSNT && _DLL
	#define _CRTIMP __declspec(dllimport)
    #else
	#define _CRTIMP
    #endif
#endif

#ifdef _REENTRANT
    #if _MSNT || _OS2
	extern int * _errno(void);
	extern int * __doserrno(void);
	#define errno   (*_errno())
	#define _doserrno   (*__doserrno())
    #elif (__OS_OPEN)
	/* do nothing */
    #elif (_SOL && _PPC)
	extern int * ___errno(void);
	#define errno   (*___errno())
    #elif !defined(_STATIC_H)
	#include <static.h>
    #endif
#else
    _CRTIMP extern int  errno;
    #if _MSDOS || _MSNT || _OS2
	_CRTIMP extern int  _doserrno;
    #endif
#endif

#if __OS_OPEN
    #define errno (*pthread_errno_np())
    extern int *pthread_errno_np(void);
#endif

#ifdef __CPLUSPLUS__
}
#endif
#endif /*_ERRNO_H*/
