/*
 * Copyright (c) 1993 MetaWare, Incorporated
 */

#ifndef _MWCTOR_H
#define _MWCTOR_H

#pragma push_align_members(64);

#ifdef __CPLUSPLUS__
extern "C" {
#endif

#define GLOBAL_CTOR  0x01  /* bit 0 => type 0 */
#define THREAD_CTOR  0x02  /* bit 1 => type 1 */

typedef struct _ct_elem {
    unsigned long	init_level;	/* C++ initialization level */
    void (*ct)();			/* pointer to constructor function */
#if (_OS2 && !_PPC) || _MSNT || _MSDOS
    unsigned long	type;		/* type: global or thread */
#else
    union {
	unsigned long type;		/* type: global or thread */
	struct _ct_elem *next;		/* next ctor in priority order */
	} u;
#endif
    } ct_elem, *ct_array;

struct ct_info {
    struct ct_info *link;	/* link to next constructor info (for DLLs) */
#if (_OS2 && !_PPC) || _MSNT || _MSDOS
    ct_array ctor_start;	/* start of constructor table */
    ct_array ctor_end;		/* end of constructor table */
    ct_array dtor_start;	/* start of destructor table */
    ct_array dtor_end;		/* end of destructor table */
#else
    void (*init)();		/* start of .init section */
    void (*fini)();		/* start of .fini section */
#endif
    };

extern void _mwdo_ctors(struct ct_info *ctor_list, int type);
extern void _mwdo_dtors(struct ct_info *ctor_list, int type);

#ifdef __CPLUSPLUS__
}
#endif
#pragma pop_align_members();

#endif
