
#ifndef WPDesktop_Source
#define WPDesktop_Source

#include <wpfolder.hh>
#pragma off(dts_class);
#pragma on(somobject_assignment_operators);
#pragma on(somobject_constructors);
#pragma on(somobject_destructor);
#pragma off(case_insensitive_class_names);

#pragma on(som_bindings);
class WPDesktop : public WPFolder {

     #pragma SOMMap (WPDesktop, "WPDesktop", "M_WPDesktop")

     #pragma SOMClassVersion (WPDesktop, 1, 2)

     #pragma SOMCallstyle (WPDesktop, oidl)

     #pragma off(som_bindings);
     #pragma pop(som_bindings);
  public :

#pragma off(use_override_signature)
     virtual BOOL wpIsCurrentDesktop();
     virtual ULONG wpAddDesktopLockup1Page(HWND hwndNotebook);
     virtual ULONG wpAddDesktopLockup2Page(HWND hwndNotebook);
     virtual ULONG wpAddDesktopLockup3Page(HWND hwndNotebook);
     virtual void wpInitData();
     virtual BOOL wpSaveState();
     virtual BOOL wpRestoreState(ULONG ulReserved);
     virtual BOOL wpModifyPopupMenu(HWND hwndMenu, HWND hwndCnr,
                                    ULONG iPosition);
     virtual BOOL wpMenuItemSelected(HWND hwndFrame, ULONG ulMenuId);
     virtual ULONG wpFilterPopupMenu(ULONG ulFlags, HWND hwndCnr,
                                     BOOL fMultiSelect);
     virtual BOOL wpAddSettingsPages(HWND hwndNotebook);
#pragma pop(use_override_signature)

     #pragma SOMReleaseOrder ( \
                              wpIsCurrentDesktop, \
                              wpAddDesktopLockup1Page, \
                              wpAddDesktopLockup2Page, \
                              wpAddDesktopLockup3Page)
};
#pragma pop(som_bindings);

#pragma pop(dts_class);
#pragma pop(somobject_assignment_operators);
#pragma pop(somobject_constructors);
#pragma pop(somobject_destructor);
#pragma pop(case_insensitive_class_names);
#endif /* WPDesktop_Source */

#ifndef M_WPDesktop_Source
#define M_WPDesktop_Source

#include <wpfolder.hh>
#include <somcls.hh>
#pragma off(dts_class);
#pragma on(somobject_assignment_operators);
#pragma on(somobject_constructors);
#pragma on(somobject_destructor);
#pragma off(case_insensitive_class_names);

#pragma on(som_bindings);
class M_WPDesktop : public M_WPFolder {

     #pragma SOMClassVersion (M_WPDesktop, 1, 2)

     #pragma SOMCallstyle (M_WPDesktop, oidl)

     #pragma off(som_bindings);
     #pragma pop(som_bindings);
  public :

#pragma off(use_override_signature)
     virtual ULONG wpclsQueryDefaultView();
     virtual PSZ wpclsQueryTitle();
     virtual ULONG wpclsQueryIconData(PICONINFO pIconInfo);
     virtual ULONG wpclsQueryStyle();
     virtual BOOL wpclsQueryDefaultHelp(PULONG pHelpPanelId,
                                        PSZ pszHelpLibrary);
#pragma pop(use_override_signature)

     #pragma SOMReleaseOrder ()

};
#pragma pop(som_bindings);

#pragma pop(dts_class);
#pragma pop(somobject_assignment_operators);
#pragma pop(somobject_constructors);
#pragma pop(somobject_destructor);
#pragma pop(case_insensitive_class_names);
#endif /* M_WPDesktop_Source */

