#if !defined(WPSPTRS) && !defined(WPSREFS)
   #define WPSPTRS
#endif

#ifndef WPFileSystem_Source
#define WPFileSystem_Source

#include <wpobject.hh>
#pragma off(dts_class);
#pragma on(somobject_assignment_operators);
#pragma on(somobject_constructors);
#pragma on(somobject_destructor);
#pragma off(case_insensitive_class_names);

#pragma on(som_bindings);
class WPFileSystem : public WPObject {

     #pragma SOMMap (WPFileSystem, "WPFileSystem", "M_WPFileSystem")

     #pragma SOMClassVersion (WPFileSystem, 1, 2)

     #pragma SOMCallstyle (WPFileSystem, oidl)

     #pragma off(som_bindings);
     #pragma pop(som_bindings);
  public :

#pragma off(use_override_signature)
     virtual BOOL wpSetRealName(PSZ pszName);
     virtual BOOL wpSetType(PSZ pszTypes, PFEA2LIST pfeal);
     virtual PSZ wpQueryType();
     virtual BOOL wpSetAttr(ULONG attrFile);
     virtual ULONG wpQueryAttr();
     virtual ULONG wpAddFile1Page(HWND hwndNotebook);
     virtual ULONG wpAddFile2Page(HWND hwndNotebook);
     virtual ULONG wpAddFile3Page(HWND hwndNotebook);
     virtual ULONG wpAddFileMenuPage(HWND hwndNotebook);
     virtual ULONG wpQueryCreation(FDATE* fdate, FTIME* ftime);
     virtual ULONG wpQueryLastAccess(FDATE* fdate, FTIME* ftime);
     virtual ULONG wpQueryLastWrite(FDATE* fdate, FTIME* ftime);
     virtual ULONG wpQueryFileSize();
     virtual ULONG wpQueryEASize();
     virtual ULONG wpSetDateInfo(FILEFINDBUF4* pstFileFindBuf);
     virtual ULONG wpSetFileSizeInfo(ULONG cbFileSize, ULONG cbEASize);
     virtual BOOL wpRefresh(ULONG ulView, PVOID pReserved);
     virtual ULONG wpQueryRefreshFlags();
     virtual BOOL wpSetRefreshFlags(ULONG ulRefreshFlags);
     virtual BOOL wpPrintPlainTextFile(PPRINTDEST pPrintDest);
     virtual BOOL wpSetTitleAndRenameFile(PSZ pszNewTitle, ULONG fConfirmations);
     virtual ULONG wpConfirmRenameFileWithExt();
     virtual ULONG wpVerifyUpdateAccess();
     virtual BOOL wpAddUserItemsToPopupMenu(HWND hwndMenu, HWND hwndCnr,
                                            ULONG iPosition);
     virtual BOOL wpQueryRealName(PSZ pszFilename, PULONG pcb,
                                  BOOL fQualified);
     virtual void wpUnInitData();
     virtual HOBJECT wpQueryHandle();
     virtual BOOL wpSaveImmediate();
     virtual ULONG wpFilterPopupMenu(ULONG ulFlags, HWND hwndCnr,
                                     BOOL fMultiSelect);
     virtual BOOL wpSetTitle(PSZ pszNewTitle);
     virtual HWND wpViewObject(HWND hwndCnr, ULONG ulView, ULONG param);
     virtual BOOL wpSwitchTo(ULONG View);
     virtual BOOL wpAddSettingsPages(HWND hwndNotebook);
#if defined(WPSREFS)
     virtual WPObject* wpCopyObject(WPFolder& Folder, BOOL fLock);
#else
     virtual WPObject* wpCopyObject(WPFolder* Folder, BOOL fLock);
#endif
#if defined(WPSREFS)
     virtual WPObject* wpCreateFromTemplate(WPFolder& folder,
#else
     virtual WPObject* wpCreateFromTemplate(WPFolder* folder,
#endif
                                            BOOL fLock);
#if defined(WPSREFS)
     virtual BOOL wpMoveObject(WPFolder& Folder);
#else
     virtual BOOL wpMoveObject(WPFolder* Folder);
#endif
     virtual ULONG wpQueryIconData(PICONINFO pIconInfo);
     virtual BOOL wpSetIconData(PICONINFO pIconInfo);
     virtual ULONG wpQueryDetailsData(PVOID* ppDetailsData, PULONG pcp);
     virtual BOOL wpModifyPopupMenu(HWND hwndMenu, HWND hwndCnr,
                                    ULONG iPosition);
     virtual BOOL wpSaveState();
     virtual BOOL wpRestoreState(ULONG ulReserved);
     virtual BOOL wpMenuItemSelected(HWND hwndFrame, ULONG ulMenuId);
     virtual HWND wpOpen(HWND hwndCnr, ULONG ulView, ULONG param);
#if defined(WPSREFS)
     virtual MRESULT wpDraggedOverObject(WPObject& DraggedOverObject);
#else
     virtual MRESULT wpDraggedOverObject(WPObject* DraggedOverObject);
#endif
#if defined(WPSREFS)
     virtual BOOL wpDroppedOnObject(WPObject& DroppedOnObject);
#else
     virtual BOOL wpDroppedOnObject(WPObject* DroppedOnObject);
#endif
     virtual BOOL wpFormatDragItem(PDRAGITEM pdrgItem);
     virtual ULONG wpQueryNameClashOptions(ULONG menuID);
#if defined(WPSREFS)
     virtual BOOL32 wpAppendObject(WPObject& targetObject, BOOL32 fMove);
#else
     virtual BOOL32 wpAppendObject(WPObject* targetObject, BOOL32 fMove);
#endif
#if defined(WPSREFS)
     virtual BOOL32 wpReplaceObject(WPObject& targetObject, BOOL32 fMove);
#else
     virtual BOOL32 wpReplaceObject(WPObject* targetObject, BOOL32 fMove);
#endif
     virtual ULONG wpQueryStyle();
     virtual BOOL wpSetStyle(ULONG ulNewStyle);
     virtual BOOL wpDoesObjectMatch(PVOID pvoidExtendedCriteria);
#pragma pop(use_override_signature)

     #pragma SOMReleaseOrder ( \
                              wpSetRealName, \
                              *, \
                              wpSetType, \
                              wpQueryType, \
                              wpSetAttr, \
                              wpQueryAttr, \
                              *, \
                              wpAddFile1Page, \
                              wpAddFile2Page, \
                              wpAddFile3Page, \
                              wpAddFileMenuPage, \
                              wpQueryCreation, \
                              wpQueryLastAccess, \
                              wpQueryLastWrite, \
                              wpQueryFileSize, \
                              wpQueryEASize, \
                              wpSetDateInfo, \
                              wpSetFileSizeInfo, \
                              wpRefresh, \
                              wpPrintPlainTextFile, \
                              wpSetRefreshFlags, \
                              wpQueryRefreshFlags, \
                              *, \
                              wpSetTitleAndRenameFile, \
                              wpConfirmRenameFileWithExt, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              wpQueryRealName, \
                              wpVerifyUpdateAccess, \
                              wpAddUserItemsToPopupMenu)
};

#pragma pop(som_bindings);
#pragma off(som_bindings);
/* Structure used to read + write the .CLASSINFO ea */

  typedef struct _INFOCLASS
  {
     ULONG    flags;
     PSZ      pszClass;
     ULONG    cbObjData;
     POBJDATA pObjData;
  } INFOCLASS;
  typedef INFOCLASS * PINFOCLASS;

  /* FILEDETAILS structure used for details view */

typedef struct _FILEDETAILS
{
   PSZ      pszRealName;     /* Real name */
   ULONG    ulSize;          /* Size of the file */
   CDATE    cdateLastMod;    /* Last modification date */
   CTIME    ctimeLastMod;    /* Last modification time */
   CDATE    cdateLastAccess; /* Last access date */
   CTIME    ctimeLastAccess; /* Last access time */
   CDATE    cdateCreation;   /* Date of creation */
   CTIME    ctimeCreation;   /* Time of creation */
   ULONG    ulFlags;         /* File flags */
}  FILEDETAILS;

typedef FILEDETAILS * PFILEDETAILS;

#define NUM_FILEDETAILS_FIELDS    9     /* Count of fields in FILEDETAILS */

  /* format of the extended search criteria for this class */
  typedef struct _FILESYS_SEARCH_INFO {
     USHORT Exclude;
     USHORT MustHave;

     BOOL   fIncludeLMD;
     USHORT LMDyear;
     USHORT LMDmonth;
     USHORT LMDday;
      SHORT LMDcriteria;

     BOOL   fIncludeLMT;
     USHORT LMThours;
     USHORT LMTminutes;
     USHORT LMTseconds;
      SHORT LMTcriteria;

     BOOL   fIncludeFDS;
     ULONG  FDSsize;
     SHORT  FDScriteria;

     BOOL   fIncludeFEAS;
     ULONG  FEASsize;
     SHORT  FEAScriteria;

     BOOL   fMustHaveNeedEA;
     BOOL   fMustNotHaveNeedEA;
     } FILESYS_SEARCH_INFO;
     typedef FILESYS_SEARCH_INFO *PFILESYS_SEARCH_INFO;


  /* Alignment macro: ensure alignment on 4byte boundary */

  #define ALIGN4(p) (PVOID)( ( ((ULONG)p) + 3 ) & 0xFFFFFFFC )

  /* return values for wpConfirmRenameFileWithExt */
  #define KEEP_RENAMEFILESWITHEXT     1
  #define DISCARD_RENAMEFILESWITHEXT  2
  #define CANCEL_RENAMEFILESWITHEXT   3

#pragma pop(som_bindings);
#pragma pop(som_bindings);

#pragma pop(dts_class);
#pragma pop(somobject_assignment_operators);
#pragma pop(somobject_constructors);
#pragma pop(somobject_destructor);
#pragma pop(case_insensitive_class_names);
#endif /* WPFileSystem_Source */


#ifndef M_WPFileSystem_Source
#define M_WPFileSystem_Source

#include <wpobject.hh>
#include <somcls.hh>
#pragma off(dts_class);
#pragma on(somobject_assignment_operators);
#pragma on(somobject_constructors);
#pragma on(somobject_destructor);
#pragma off(case_insensitive_class_names);

#pragma on(som_bindings);
class M_WPFileSystem : public M_WPObject {

     #pragma SOMClassVersion (M_WPFileSystem, 1, 2)

     #pragma SOMCallstyle (M_WPFileSystem, oidl)

     #pragma off(som_bindings);
     #pragma pop(som_bindings);
  public:

#pragma off(use_override_signature)
     virtual WPObject* wpclsQueryObjectFromPath(PSZ pszFQPath);
     virtual PSZ wpclsQueryInstanceType();
     virtual PSZ wpclsQueryInstanceFilter();
     virtual void wpclsInitData();
     virtual PSZ wpclsQueryTitle();
     virtual ULONG wpclsQueryDetailsInfo(PCLASSFIELDINFO* ppClassFieldInfo,
                                         PULONG pSize);
#if defined(WPSREFS)
     virtual void wpclsQuerySearchInfo(M_WPObject*& ClassExtended,
#else
     virtual void wpclsQuerySearchInfo(M_WPObject** ClassExtended,
#endif
#if defined(WPSREFS)
                                       M_WPObject*& ClassCreate,
#else
                                       M_WPObject** ClassCreate,
#endif
                                       PULONG pulClassCriteriaSize);
     virtual BOOL wpclsQueryExtendedCriteria(PSZ pszName, ULONG ulSearchType,
                                             PVOID pvoidExtendedCriteria);
#pragma pop(use_override_signature)

     #pragma SOMReleaseOrder ( \
                              wpclsQueryInstanceType, \
                              wpclsQueryInstanceFilter, \
                              wpclsQueryObjectFromPath)
};
#pragma pop(som_bindings);

#pragma pop(dts_class);
#pragma pop(somobject_assignment_operators);
#pragma pop(somobject_constructors);
#pragma pop(somobject_destructor);
#pragma pop(case_insensitive_class_names);
#endif /* M_WPFileSystem_Source */

