
#ifndef WPPalette_Source
#define WPPalette_Source

#include <wpabs.hh>

#pragma off(som_bindings);
  /*
   *  Open view for the wpOpen() method
   */

  #define OPEN_PALETTE       121

  /*
   *  Palette save-restore keys
   */

  #define IDKEY_PALXCELLCOUNT      1000
  #define IDKEY_PALYCELLCOUNT      1001
  #define IDKEY_PALXCELLWIDTH      1002
  #define IDKEY_PALYCELLHEIGHT     1003
  #define IDKEY_PALXGAP            1004
  #define IDKEY_PALYGAP            1005
  #define IDKEY_PALSCREENSIZEX     1006
  #define IDKEY_PALSCREENSIZEY     1007
  #define IDKEY_PALCELLDATA_FIRST  1050

  /*
   *  Default palette information
   */

  #define DEF_XCELLCOUNT      6
  #define DEF_YCELLCOUNT      5

  /*
   *  Variables kept for each open palette window as
   *  a structure pointed to by the QWL_USER window
   *  word ...
   */

  typedef struct _CELL
  {
     ULONG       cbData;           /* Size of the data that follows */

     /* Class specific cell data follows immediately afterwards -
      * for example the font palette would store the ASCII name of
      * the font, and the color palette would store the RGB color
      * of the cell.
      */
  } CELL;
  typedef CELL *PCELL;

  typedef struct _PALINFO
  {
     ULONG       xCellCount;       /* Number of columns of cells */
     ULONG       yCellCount;       /* Number of rows of cells */
     ULONG       xCursor;          /* Cursor location (readonly) */
     ULONG       yCursor;          /* Cursor location (readonly) */
     ULONG       xCellWidth;       /* Width of each cell */
     ULONG       yCellHeight;      /* Height of each cell */
     ULONG       xGap;             /* X separation of cells */
     ULONG       yGap;             /* Y separation of cells */
  } PALINFO;
  typedef PALINFO *PPALINFO;

  #define SetPaletteDataPtr( hwnd, pPaletteData ) \
       WinSetWindowULong( hwnd, QWL_USER, (ULONG)pPaletteData )

  #define QueryPaletteDataPtr( hwnd ) \
       (PPALETTEDATA)WinQueryWindowULong( hwnd, QWL_USER )

  typedef struct _PALETTEDATA
  {
     WPFolder   *Palette;          /* Folder object for this window */
     USEITEM     UseItem;          /* Folder object's INUSE list item */
     VIEWITEM    ViewItem;
     ULONG       xCursor;
     ULONG       yCursor;
  } PALETTEDATA;
  typedef PALETTEDATA *PPALETTEDATA;

  typedef struct _CELLSTRUCT
  {
     RECTL       rclCell;          /* Cell coordinates */
     PCELL       pCell;            /* Cell data pointer */
  } CELLSTRUCT;
  typedef CELLSTRUCT *PCELLSTRUCT;
  /*
   *  Miscellaneous
   */

  #define PM_INVALIDATECELL WM_USER+1000

  /* Macros that act on a PALINFO...
   */
  #define PALETTE_WIDTH(p)  ( p.xCellCount*(p.xCellWidth+p.xGap) )
  #define PALETTE_HEIGHT(p) ( p.yCellCount*(p.yCellHeight+p.yGap) )
  #define ID_PALSCROLLHORZ     8091
  #define ID_PALSCROLLVERT     8092

  /* Coordinates (these are in DIALOG UNITS)
   */
  #define CXBUTTON          12       /* Width of a button (with no text) */
  #define CYBUTTON          12       /* Height of a button */
  #define XBUTTONGAP        6
  #define YBUTTONGAP        4
  #define CYBUTTONAREA      (CYBUTTON + 2*YBUTTONGAP)
  #define DEF_XCELLWIDTH    22
  #define DEF_YCELLHEIGHT   16
  #define DEF_XCELLGAP      4
  #define DEF_YCELLGAP      4
#pragma pop(som_bindings);

#pragma off(dts_class);
#pragma on(somobject_assignment_operators);
#pragma on(somobject_constructors);
#pragma on(somobject_destructor);
#pragma off(case_insensitive_class_names);

#pragma on(som_bindings);
class WPPalette : public WPAbstract {

     #pragma SOMMap (WPPalette, "WPPalette", "M_WPPalette")

     #pragma SOMClassVersion (WPPalette, 1, 2)

     #pragma SOMCallstyle (WPPalette, oidl)

     #pragma off(som_bindings);
     #pragma pop(som_bindings);
  public :

#pragma off(use_override_signature)
     virtual void wpPaintCell(PCELL pCell, HPS hps, PRECTL prcl,
                              BOOL fHilite);
     virtual BOOL wpSetupCell(PVOID pCellData, ULONG cb, ULONG x,
                              ULONG y);
     virtual BOOL wpRedrawCell(PCELL pCell);
     virtual BOOL wpQueryPaletteInfo(PPALINFO pPalInfo);
     virtual BOOL wpSetPaletteInfo(PPALINFO pPalInfo);
     virtual BOOL wpEditCell(PCELL pCell, HWND hwndPal);
     virtual BOOL wpDragCell(PCELL pCell, HWND hwndPal, PPOINTL ptlDrag);
     virtual ULONG wpQueryPaletteHelp();
     virtual void wpInitData();
     virtual void wpUnInitData();
     virtual BOOL wpSetup(PSZ pszSetupString);
     virtual BOOL wpSaveState();
     virtual BOOL wpRestoreState(ULONG ulReserved);
     virtual BOOL wpMenuItemSelected(HWND hwndFrame, ULONG ulMenuId);
     virtual BOOL wpModifyPopupMenu(HWND hwndMenu, HWND hwndCnr,
                                    ULONG iPosition);
     virtual ULONG wpFilterPopupMenu(ULONG ulFlags, HWND hwndCnr,
                                     BOOL fMultiSelect);
     virtual HWND wpOpen(HWND hwndCnr, ULONG ulView, ULONG param);
     virtual BOOL wpMenuItemHelpSelected(ULONG MenuId);
#pragma pop(use_override_signature)

     #pragma SOMReleaseOrder ( \
                              wpPaintCell, \
                              *, \
                              wpSetupCell, \
                              wpQueryPaletteInfo, \
                              wpSetPaletteInfo, \
                              wpEditCell, \
                              wpDragCell, \
                              *, \
                              *, \
                              wpRedrawCell, \
                              *, \
                              *, \
                              wpQueryPaletteHelp, \
                              *)
};


#pragma pop(som_bindings);

#pragma pop(dts_class);
#pragma pop(somobject_assignment_operators);
#pragma pop(somobject_constructors);
#pragma pop(somobject_destructor);
#pragma pop(case_insensitive_class_names);
#endif /* WPPalette_Source */

#ifndef M_WPPalette_Source
#define M_WPPalette_Source

#include <wpabs.hh>
#include <somcls.hh>
#pragma off(dts_class);
#pragma on(somobject_assignment_operators);
#pragma on(somobject_constructors);
#pragma on(somobject_destructor);
#pragma off(case_insensitive_class_names);

#pragma on(som_bindings);
class M_WPPalette : public M_WPAbstract {

     #pragma SOMClassVersion (M_WPPalette, 1, 2)

     #pragma SOMCallstyle (M_WPPalette, oidl)

     #pragma off(som_bindings);
     #pragma pop(som_bindings);
  public :

#pragma off(use_override_signature)
     virtual PSZ wpclsQueryEditString();
     virtual PSZ wpclsQueryTitle();
     virtual ULONG wpclsQueryStyle();
     virtual ULONG wpclsQueryDefaultView();
     virtual BOOL wpclsQueryDefaultHelp(PULONG pHelpPanelId,
                                        PSZ pszHelpLibrary);
#pragma pop(use_override_signature)

     #pragma SOMReleaseOrder ( \
                              wpclsQueryEditString)
};
#pragma pop(som_bindings);

#pragma pop(dts_class);
#pragma pop(somobject_assignment_operators);
#pragma pop(somobject_constructors);
#pragma pop(somobject_destructor);
#pragma pop(case_insensitive_class_names);
#endif /* M_WPPalette_Source */

