#if !defined(WPSPTRS) && !defined(WPSREFS)
   #define WPSPTRS
#endif

#ifndef WPProgramFile_Source
#define WPProgramFile_Source

#include <wpdataf.hh>
#pragma off(dts_class);
#pragma on(somobject_assignment_operators);
#pragma on(somobject_constructors);
#pragma on(somobject_destructor);
#pragma off(case_insensitive_class_names);

#pragma on(som_bindings);
class WPProgramFile : public WPDataFile {

     #pragma SOMMap (WPProgramFile, "WPProgramFile", "M_WPProgramFile")

     #pragma SOMClassVersion (WPProgramFile, 1, 2)

     #pragma SOMCallstyle (WPProgramFile, oidl)

     #pragma off(som_bindings);
     #pragma pop(som_bindings);
  public :

#pragma off(use_override_signature)
     virtual ULONG wpAddProgramAssociationPage(HWND hwndNotebook);
     virtual BOOL wpQueryProgDetails(PPROGDETAILS pProgDetails,
                                     PULONG pulSize);
     virtual BOOL wpSetProgDetails(PPROGDETAILS pProgDetails);
     virtual ULONG wpAddProgramPage(HWND hwndNotebook);
     virtual ULONG wpAddProgramSessionPage(HWND hwndNotebook);
     virtual PSZ wpQueryAssociationFilter();
     virtual PSZ wpQueryAssociationType();
     virtual BOOL wpSetAssociationFilter(PSZ pszFilter);
     virtual BOOL wpSetAssociationType(PSZ pszType);
     virtual void wpSetAssociatedFileIcon();
     virtual void wpInitData();
     virtual BOOL wpSaveState();
     virtual BOOL wpRestoreState(ULONG ulReserved);
     virtual BOOL wpAddSettingsPages(HWND hwndNotebook);
     virtual HWND wpOpen(HWND hwndCnr, ULONG ulView, ULONG param);
     virtual BOOL wpModifyPopupMenu(HWND hwndMenu, HWND hwndCnr,
                                    ULONG iPosition);
     virtual BOOL wpMenuItemSelected(HWND hwndFrame, ULONG ulMenuId);
     virtual BOOL wpMenuItemHelpSelected(ULONG MenuId);
#if defined(WPSREFS)
     virtual BOOL wpMoveObject(WPFolder& Folder);
#else
     virtual BOOL wpMoveObject(WPFolder* Folder);
#endif
     virtual MRESULT wpDragOver(HWND hwndCnr, PDRAGINFO pdrgInfo);
     virtual MRESULT wpDrop(HWND hwndCnr, PDRAGINFO pdrgInfo,
                            PDRAGITEM pdrgItem);
#if defined(WPSREFS)
     virtual WPObject* wpCopyObject(WPFolder& Folder, BOOL fLock);
#else
     virtual WPObject* wpCopyObject(WPFolder* Folder, BOOL fLock);
#endif
     virtual ULONG wpConfirmRenameFileWithExt();
     virtual WPObject* wpCreateAnother(PSZ pszTitle, PSZ pszSetupEnv,
#if defined(WPSREFS)
                                       WPFolder& Folder);
#else
                                       WPFolder* Folder);
#endif
     virtual ULONG wpFilterPopupMenu(ULONG ulFlags, HWND hwndCnr,
                                     BOOL fMultiSelect);
     virtual BOOL wpSetup(PSZ pszSetupString);
     virtual ULONG wpQueryNameClashOptions(ULONG menuID);
#pragma pop(use_override_signature)

     #pragma SOMReleaseOrder ( \
                              wpAddProgramAssociationPage, \
                              wpAddProgramPage, \
                              wpAddProgramSessionPage, \
                              wpSetProgDetails, \
                              wpQueryProgDetails, \
                              *, \
                              wpQueryAssociationFilter, \
                              wpQueryAssociationType, \
                              wpSetAssociationFilter, \
                              wpSetAssociationType)
};
#pragma pop(som_bindings);

#pragma pop(dts_class);
#pragma pop(somobject_assignment_operators);
#pragma pop(somobject_constructors);
#pragma pop(somobject_destructor);
#pragma pop(case_insensitive_class_names);
#endif /* WPProgramFile_Source */

#ifndef M_WPProgramFile_Source
#define M_WPProgramFile_Source

#include <wpdataf.hh>
#include <somcls.hh>
#pragma off(dts_class);
#pragma on(somobject_assignment_operators);
#pragma on(somobject_constructors);
#pragma on(somobject_destructor);
#pragma off(case_insensitive_class_names);

#pragma on(som_bindings);
class M_WPProgramFile : public M_WPDataFile {

     #pragma SOMClassVersion (M_WPProgramFile, 1, 2)

     #pragma SOMCallstyle (M_WPProgramFile, oidl)

     #pragma off(som_bindings);
     #pragma pop(som_bindings);
  public :

#pragma off(use_override_signature)
     virtual PSZ wpclsQueryTitle();
     virtual ULONG wpclsQueryIconData(PICONINFO pIconInfo);
     virtual ULONG wpclsQueryDefaultView();
     virtual ULONG wpclsQueryStyle();
#pragma pop(use_override_signature)

     #pragma SOMReleaseOrder ()

};
#pragma pop(som_bindings);

#pragma pop(dts_class);
#pragma pop(somobject_assignment_operators);
#pragma pop(somobject_constructors);
#pragma pop(somobject_destructor);
#pragma pop(case_insensitive_class_names);
#endif /* M_WPProgramFile_Source */

