#===================================================================
#
#   names.MAK - names Make file
#   Copyright  IBM Corporation 1992
#
#===================================================================
#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

!include ..\..\ibmsamp.inc

#-------------------------------------------------------------------
#
#   A list of all of the object files
#
#-------------------------------------------------------------------

!if "$(TARGET_PROC)"=="386"
OBJS = names.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = names.obj
!endif
!endif

#-------------------------------------------------------------------
#   This section lists all files to be built by the make.  The
#   makefile builds the executible as well as its associated help
#   file.
#-------------------------------------------------------------------
all: names.dll

#-------------------------------------------------------------------
#   This section creates the command file used by the linker.  This
#   command file is recreated automatically every time you change
#   the object file list, linker flags, or library list.
#-------------------------------------------------------------------
#-------------------------------------------------------------------
#   Dependencies
#     This section lists all object files needed to be built for the
#     application, along with the files it is dependent upon (e.g.
#     its source and any header files).
#-------------------------------------------------------------------
!if "$(TARGET_PROC)"=="386"
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
!endif
!endif

names.obj: names.c $(HEADERS)

!if "$(TARGET_PROC)"=="386"
names.dll: $(OBJS)
   $(LINK) @<<names.lnk
$(OBJS: =+^
)
$@
$(@B).map
$(MTLIBS)
$(@B).def
<<keep
   rc -p -x names.dll
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
names.dll : $(OBJS)
        $(LINK) $(DLLFLAGS) $(LFLAGS) $@ $(DEFOPTS)names.def $(DMILIBS) $(OBJS)
!endif
!endif

clean :
        @if exist *.obj del *.obj
        @if exist *.dll del *.dll
        @if exist *.exe del *.exe
