/********************** START OF HEADER SPECIFICATION *********************/
/*                                                                        */
/* FILE NAME:  FFST.H                                                     */
/*                                                                        */
/* FUNCTIONS:  This header file contains the data structures pertaining   */
/*             to the FFSTProbe, FFSTSetConfiguration, and                */
/*             FFSTQueryConfiguration.                                    */
/*                                                                        */
/* (C) COPYRIGHT International Business Machines Corp., 1994.             */
/* All Rights Reserved                                                    */
/* Licensed Materials - Property of IBM                                   */
/*                                                                        */
/* US Government Users Restricted Rights - Use, duplication or            */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.      */
/*                                                                        */
/********************* END OF HEADER SPECIFICATION ************************/

#ifndef __FFSTH__
  #define __FFSTH__

#ifndef INCL_FFST
  #define INCL_FFST
#endif

#include <unidef.h>  /*002*/

/*------------------------------------------------------------------------*/
/*                                                                        */
/* Return codes from FFSTProbe to application and passed to ERRLOG        */
/*                                                                        */
/*------------------------------------------------------------------------*/
/*------------------------------------------------------------------------*/
/* Return codes for Invalid Pointers                                      */
/*------------------------------------------------------------------------*/

#define FFST_INVALID_PRODUCT_ADDRESS                 0x16500
#define FFST_INVALID_FFST_ADDRESS                    0x16501
#define FFST_INVALID_PRODDATA_ADDRESS                0x16502
#define FFST_INVALID_DMI_ADDRESS                     0x16503
#define FFST_INVALID_DUMP_ADDRESS                    0x16504
#define FFST_INVALID_USER_AREA_ADDRESS               0x16505
#define FFST_INVALID_LOG_DATA_ADDRESS                0x16506
#define FFST_INVALID_MESSAGE_ADDRESS                 0x16507
#define FFST_INVALID_VENDOR_TAG_ADDRESS              0x16508
#define FFST_INVALID_TAG_ADDRESS                     0x16509
#define FFST_INVALID_MODULENAME_ADDRESS              0x1650A
#define FFST_INVALID_REVISION_ADDRESS                0x1650B
#define FFST_INVALID_PRODUCT_ID_ADDRESS              0x1650C
#define FFST_INVALID_DMI_MODIFICATION_LEVEL_ADDRESS  0x1650D
#define FFST_INVALID_DMI_FIXLVL_ADDRESS              0x1650E
#define FFST_INVALID_TEMPFN_ADDRESS                  0x1650F
#define FFST_INVALID_USER_STRUCTURE_TITLE_ADDRESS    0x16510
#define FFST_INVALID_CONFIG_SUBPRODDATA_ADDRESS      0x16511

/*------------------------------------------------------------------------*/
/* Return codes for Invalid Revision Numbers                              */
/*------------------------------------------------------------------------*/

#define FFST_INVALID_PRODUCT_REVISION                0x16520
#define FFST_INVALID_DMI_REVISION                    0x16521
#define FFST_INVALID_FFST_REVISION                   0x16522

/*------------------------------------------------------------------------*/
/* Return code for Invalid Severity                                       */
/*------------------------------------------------------------------------*/

#define FFST_INVALID_SEVERITY                        0x16530

/*------------------------------------------------------------------------*/
/* Return code for Invalid Number of Dumps Specified by User              */
/*------------------------------------------------------------------------*/

#define FFST_INVALID_USER_DUMP_NUMBER                0x16531

/*------------------------------------------------------------------------*/
/* Return code for Invalid Number of Insert Texts                         */
/*------------------------------------------------------------------------*/

#define FFST_INVALID_INSERTS_NUMBER                  0x16532
#define FFST_INVALID_INSERT_TEXT_ADDRESS             0x16533

/*------------------------------------------------------------------------*/
/* Return code for Invalid Probe Flags                                    */
/*------------------------------------------------------------------------*/

#define FFST_INVALID_PROBE_FLAGS                     0x16534

/*------------------------------------------------------------------------*/
/* Return codes for Invalid PSTAT data and Process Environment data       */
/*------------------------------------------------------------------------*/

#define FFST_INVALID_PSTAT_DATA                      0x16535
#define FFST_INVALID_PROCESS_ENV                     0x16536

/*------------------------------------------------------------------------*/
/* Return codes for Invalid Packet Sizes                                  */
/*------------------------------------------------------------------------*/

#define FFST_INVALID_PRODUCTDATA_PACKET_SIZE         0x16540
#define FFST_INVALID_DMIDATA_PACKET_SIZE             0x16541
#define FFST_INVALID_FFSTPARMS_PACKET_SIZE           0x16542

/*------------------------------------------------------------------------*/
/* Return codes for DLL Load and Query                                    */
/*------------------------------------------------------------------------*/

#define FFST_DLL_QUERY_PROC_ERROR                    0x16550
#define FFST_DLL_LOAD_ERROR                          0x16551

/*------------------------------------------------------------------------*/
/* Return code for Multiple Errors Occurring during probe processing      */
/*------------------------------------------------------------------------*/

#define FFST_MULTIPLE_SYSTEM_ERRORS                  0x16552

/*------------------------------------------------------------------------*/
/* Return codes from FFSTProbe to application and not to ERRLOG           */
/*------------------------------------------------------------------------*/
/*------------------------------------------------------------------------*/
/* Return code for FFST not active.                                       */
/*------------------------------------------------------------------------*/

#define FFST_NOT_ACTIVE                              0x16553

/*------------------------------------------------------------------------------------*/
/*                                                                                    */
/* Return codes from FFSTQueryConfiguration and FFSTSetConfiguration                  */
/*                                                                                    */
/*------------------------------------------------------------------------------------*/

#define FFST_INVALID_CONFIG_ADDRESS                            0x16560
#define FFST_INVALID_CONFIG_REVISION_NUMBER                    0x16561
#define FFST_INVALID_CONFIG_PACKET_SIZE                        0x16562
#define FFST_INVALID_CONFIG_DUMP_FILE_WRAP                     0x16563
#define FFST_INVALID_CONFIG_DUMP_FILE_DIRECTORY_SIZE           0x16564
#define FFST_INVALID_CONFIG_KEEP_DUP_DUMP                      0x16565
#define FFST_INVALID_CONFIG_DUMP_FILE_DIRECTORY_NAME_ADDRESS   0x16566
#define FFST_INVALID_CONFIG_DUMP_FILE_DIRECTORY_NAME_LENGTH    0x16567
#define FFST_INVALID_CONFIG_NO_DISABLED_PRODUCTS               0x16568
#define FFST_INVALID_CONFIG_VENDOR_TAG_ADDRESS                 0x16569
#define FFST_INVALID_CONFIG_TAG_ADDRESS                        0x1656A
#define FFST_INVALID_CONFIG_REVISION_ADDRESS                   0x1656B
#define FFST_INVALID_CONFIG_MESSAGE_POPUP                      0x1656C

/*---------------------------------------------------------------------*/
/* Return codes for file errors during Configuration processing.       */
/*---------------------------------------------------------------------*/

#define FFST_CONFIG_FILE_OPEN_ERROR                            0x16570
#define FFST_CONFIG_FILE_SEARCH_ERROR                          0x16571
#define FFST_CONFIG_FILE_WRITE_ERROR                           0x16572

/*---------------------------------------------------------------------*/
/* Return code for an insufficient buffer passed to Configuration.     */
/*---------------------------------------------------------------------*/

#define FFST_CONFIG_INSUFFICIENT_BUFFER                        0x1657A

/*---------------------------------------------------------------------*/
/* Return code for invalid dump file directory driver passed to        */
/* FFSTSetConfiguration.                                               */
/*---------------------------------------------------------------------*/

#define FFST_INVALID_CONFIG_DUMP_FILE_DIR_DRIVE                0x1657B

/*---------------------------------------------------------------------*/
/* Return codes for an invalid drive or path passed to                 */
/* FFSTSetConfiguration.                                               */
/*---------------------------------------------------------------------*/

#define FFST_INVALID_DRIVE_REQUESTED                           0x1657C
#define FFST_INVALID_PATH_REQUESTED                            0x1657D

/*------------------------------------------------------------------------------------*/
/*                                                                                    */
/* Return codes from FFSTProbe, FFSTQueryConfiguration, FFSTSetConfiguration          */
/* or other FFST processing.                                                          */
/*                                                                                    */
/*------------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------*/
/* Return codes for shared memory errors.                              */
/*---------------------------------------------------------------------*/

#define FFST_GET_SHARED_MEM_ERROR                              0x16580
#define FFST_ALLOC_SHARED_MEM_ERROR                            0x16581
#define FFST_FREE_SHARED_MEM_ERROR                             0x16582

/*---------------------------------------------------------------------*/
/* Return codes for semaphore errors.                                  */
/*---------------------------------------------------------------------*/

#define FFST_SEMAPHORE_TIMEOUT_ERROR                           0x1658A
#define FFST_SEMAPHORE_OPEN_ERROR                              0x1658B
#define FFST_SEMAPHORE_RELEASE_ERROR                           0x1658C
#define FFST_SEMAPHORE_CLOSE_ERROR                             0x1658D
#define FFST_SEMAPHORE_REQUEST_ERROR                           0x1658E

/*---------------------------------------------------------------------*/
/* Return codes for dump engine processing which may be posted to the  */
/* SysLog.                                                             */
/*---------------------------------------------------------------------*/

#define FFST_DUMP_HDR_FILE_OPEN_ERROR                          0x16595
#define FFST_INDEX_FILE_OPEN_ERROR                             0x16596
#define FFST_DUMP_FILE_OPEN_ERROR                              0x16597
#define FFST_MEMORY_ALLOCATION_ERROR                           0x16598
#define FFST_QUERYFS_ERROR                                     0x16599
#define FFST_DUMP_WRAP_ERROR                                   0x1659A
#define FFST_TRACE_RENAME_ERROR                                0x1659B

/*---------------------------------------------------------------------*/
/* Return codes that may be in the SysLog during Worker bringup.       */
/*---------------------------------------------------------------------*/

#define FFST_CREATE_CONFIG_SEMAPHORE_ERROR                     0x165A1
#define FFST_CREATE_DUMP_SEMAPHORE_ERROR                       0x165A2
#define FFST_WORKER_ALLOC_SHARED_MEM_ERROR                     0x165A3
#define FFST_WORKER_GET_SHARED_MEM_ERROR                       0x165A4
#define FFST_CREATE_PCT_SEMAPHORE_ERROR                        0x165A5
#define FFST_FILE_ALREADY_EXISTS                               0x165A6
#define FFST_SPECIFIED_FILE_NOT_FOUND                          0x165A7
#define FFST_DUMP_VALIDATION_ERROR                             0x165A8
#define FFST_CONFIG_MEMORY_FILLED                              0x165A9

/*------------------------------------------------------------------------------------*/
/*                                                                                    */
/* Miscellaneous defines used by FFST                                                 */
/*                                                                                    */
/*------------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------*/
/* Maximum number of message inserts and dumps for FFSTProbe              */
/*------------------------------------------------------------------------*/

#define MAX_MSG_INSERTS                    9
#define MAX_USER_DUMPS                     30

/*------------------------------------------------------------------------*/
/* Major and Minor error codes for FFST                                   */
/*------------------------------------------------------------------------*/

#define FFST_MAJOR_CODE                    0x056
#define FFST_MINOR_CODE                    0x057

/*------------------------------------------------------------------------*/
/* Packet Revision number defines                                         */
/*------------------------------------------------------------------------*/

#define PRODUCTDATA_REVISION_NUMBER_1      1
#define DMIDATA_REVISION_NUMBER_1          1
#define NOTIFYINFO_REVISION_NUMBER_1       1
#define FFSTPARMS_WPOS_REVISION_NUMBER_1   1
#define FFSTPARMS_OS2_REVISION_NUMBER_1    2

/*------------------------------------------------------------------------*/
/* Severity definitions                                                   */
/*------------------------------------------------------------------------*/

#ifndef SEVERITY1
  #define SEVERITY1                        1
  #define SEVERITY2                        2
  #define SEVERITY3                        3
  #define SEVERITY4                        4
  #define SEVERITY5                        5
  #define SEVERITY6                        6
#endif

/*------------------------------------------------------------------------*/
/* Probe Flags                                                            */
/*------------------------------------------------------------------------*/

#define PSTAT_FLAG                         0x01
#define PROC_ENV_FLAG                      0x02
#define RESERVED                           0x04
#define PROCESS_DUMP_FLAG                  0x08
#define RELIABLE_STORAGE_FLAG              0x10
#define CAPTURE_TRACE                      0x100
#define MAX_PROBE_FLAGS_VALUE              0x3f

/*---------------------------------------------------------------------*/
/* Configuration API defines.                                          */
/*---------------------------------------------------------------------*/

#define   CONFIGPARMS_WPOS_REVISION_NUMBER_1                     1
#define   CONFIGPARMS_OS2_REVISION_NUMBER_1                      2

#define   FFST_DUMP_WRAP_OFF                                     0
#define   FFST_DUMP_WRAP_ON                                      1
#define   FFST_DUMP_WRAP_NO_CHANGE                               2

#define   FFST_KEEP_DUP_DUMP_OFF                                 0
#define   FFST_KEEP_DUP_DUMP_ON                                  1
#define   FFST_KEEP_DUP_DUMP_NO_CHANGE                           2

#define   FFST_DUMP_FILE_DIRECTORY_SIZE_NO_CHANGE                0
#define   FFST_DUMP_FILE_DIRECTORY_LENGTH_NO_CHANGE              0
#define   FFST_NO_OF_PROBE_DISABLED_PRODUCTS_NO_CHANGE           0xFFFFFFFF

/*------------------------------------------------------------------------------------*/
/*                                                                                    */
/* Structures used by FFST                                                            */
/*                                                                                    */
/*------------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------*/
/* FFSTProbe Structure Declares                                           */
/*------------------------------------------------------------------------*/

  typedef struct _PRODUCTDATA {           /* Product Information Packet   */
      ULONG    packet_size;               /* Length of product data packet*/
      ULONG    packet_revision_number;    /* revision number of this pkt  */
      UniChar  *DMI_vendor_tag;           /* ptr to vendor short name     */
      UniChar  *DMI_tag;                  /* ptr to vendor product name   */
      UniChar  *DMI_revision;             /* ptr to vendor revision num   */
    } PRODUCTDATA, *PPRODUCTDATA;


  typedef struct _DMIDATA {               /* DMI data structure           */
      ULONG    packet_size;               /* Length of packet             */
      ULONG    packet_revision_number;    /* Revision number of packet    */
      UniChar  *DMI_product_ID;           /* ptr to product number        */
      UniChar  *DMI_modification_level;   /* dmi product mod level        */
      UniChar  *DMI_fix_level;            /* dmi product fix level        */
      ULONG    template_filename_length;  /* length of template filename  */
      UniChar  *template_filename;        /* ptr to template filename     */
    } DMIDATA, *PDMIDATA;


  typedef struct _PRODUCTINFO {           /* Product Information Packet   */
      PPRODUCTDATA pProductData;          /* ptr to Probe Information     */
      PDMIDATA     pDMIData;              /* ptr to Product DMI Data      */
    } PRODUCTINFO, *PPRODUCTINFO;


  typedef struct _MSGINSTXT {             /* Insert Text Data             */
      ULONG    insert_number;             /* number of given insert       */
      UniChar  *insert_text;              /* ptr to insert text           */
    } MSGINSTXT, *PMSGINSTXT;


  typedef struct _MSGINSDATA {            /* Insert Text Data             */
      ULONG     no_inserts;               /* number of inserts provided   */
      MSGINSTXT MsgInsTxt[MAX_MSG_INSERTS]; /* struc containing inserts   */
    } MSGINSDATA, *PMSGINSDATA;


  typedef struct _DUMPDATAVAR {           /* User defined dump data       */
      ULONG    var_n_length;              /* length of data structure     */
      PVOID    var_n;                     /* pointer to data structure    */
    } DUMPDATAVAR, *PDUMPDATAVAR;


  typedef struct _DUMPUSERDATA {          /* User defined dump data       */
      ULONG       no_of_variables;        /* number of dumps              */
      DUMPDATAVAR DumpDataVar[MAX_USER_DUMPS]; /* dump data variable      */
    } DUMPUSERDATA, *PDUMPUSERDATA;


  typedef struct _FFSTPARMS {             /* FFSTPROBE Control Block      */
      ULONG         packet_size;          /* Length of packet             */
      ULONG         packet_revision_number; /* Revision number of packet  */
      UniChar       *module_name;         /* ptr to module identifier name*/
      ULONG         probe_ID;             /* probe id                     */
      ULONG         severity;             /* Severity of probe fired      */
      ULONG         template_record_ID;   /* Log Entry Format Template    */
      PMSGINSDATA   pMsgInsData;          /* Message inserts              */
      ULONG         probe_flags;          /* Flags set by application     */
      PDUMPUSERDATA pDumpUserData;        /* Dump Structures              */
      ULONG         log_user_data_length; /* length of log user data      */
      PVOID         log_user_data;        /* Data to be placed in errorlog*/
    } FFSTPARMS, *PFFSTPARMS;

/*------------------------------------------------------------------------*/
/* FFSTSetConfiguration and FFSTQueryConfiguration structures             */
/*------------------------------------------------------------------------*/

 typedef struct _DISABLEPRODUCT {         /* Disabled products structure  */
     UniChar    *DMI_vendor_tag;          /* ptr to vendor tag information*/
     UniChar    *DMI_tag;                 /* ptr to tag information       */
     UniChar    *DMI_revision;            /* ptr to revision information  */
 } DISABLEPRODUCT, *PDISABLEPRODUCT;

 typedef struct _CONFIGPARMS {            /* Configuration API's structure*/
     ULONG           packet_size;         /* size of the packet           */
     ULONG           packet_revision_number; /* revision of the packet    */
     ULONG           dump_file_wrap;      /* wrap the dump files flag     */
     ULONG           dump_file_directory_size; /* size to store dumps     */
     ULONG           keep_dup_dump;       /* keep duplicate dumps flag    */
     ULONG           dump_file_directory_name_length; /* length of dumpdir*/
     UniChar         *dump_file_directory_name; /* ptr to dump dir name   */
     ULONG           no_of_probe_disabled_products; /* no of products dis */
     PDISABLEPRODUCT pDisableProduct;     /* ptr to disabled products stuc*/
     ULONG           message_pop_up;      /* OS2 flag for message popup   */
 } CONFIGPARMS, *PCONFIGPARMS;


/*------------------------------------------------------------------------*/
/* FFSTProbe Prototype                                                    */
/*------------------------------------------------------------------------*/
APIRET APIENTRY FFSTProbe ( PPRODUCTINFO pProductInfo,
                            PFFSTPARMS   pFFSTParms);


/*------------------------------------------------------------------------*/
/* Prototypes for Configuration API's                                     */
/*------------------------------------------------------------------------*/
APIRET APIENTRY FFSTSetConfiguration   ( PCONFIGPARMS pConfigParms );
APIRET APIENTRY FFSTQueryConfiguration ( PULONG buffer_length, PCONFIGPARMS pConfigParms );

#endif /* __FFSTH__ */
