/*
 *   FUNCTIONS:
 *
 *   (C) COPYRIGHT International Business Machines Corp. 1991, 1993
 *   All Rights Reserved
 *   Licensed Materials - Property of IBM
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */

#ifndef _ICONV_H
  #define _ICONV_H

  #include <os2.h>
  #include <stddef.h>

  #ifdef __cplusplus
    extern "C" {
  #endif

  #if defined(__IBMCPP__) || defined(__IBMC__)
    #pragma pack(1)
  #else
    #pragma Align_members(1)
  #endif

  #ifndef __ICONVP_H
    typedef void *iconv_t;
  #endif

  #ifndef CCSID_DEF
    #define CCSID_DEF
    typedef unsigned int    CCSID;
  #endif

  iconv_t APIENTRY iconv_open (
    char *to_code,               /*in: encoding of the input string           */
    char *from_code);            /*in: encoding of the output string          */

  size_t  APIENTRY iconv (
    iconv_t cd,            /*in: conversion descriptor returned by iconv_open */
    char    **inbuf,       /*in:  beginning of input buffer,                  */
                           /*out: ending of input buffer                      */
    size_t  *inbytesleft,  /*in/out: bytes left to be convert in input buffer */
    char    **outbuf,      /*in:  beginning of output buffer,                 */
                           /*out: ending of output buffer                     */
    size_t  *outbytesleft );     /*in/out:  bytes left in output buffer       */

  int     APIENTRY iconv_close (
    iconv_t cd);           /*in: conversion descriptor to be close            */

  #ifndef __conv_endian_t
    #define __conv_endian_t

    #define   ENDIAN_SYSTEM   0x0000
    #define   ENDIAN_BIG      0xfeff
    #define   ENDIAN_LITTLE   0xfffe

    typedef struct _conv_endian_rec {
      unsigned int source : 16;
      unsigned int target : 16;
    } conv_endian_t;

  #endif
  /*
   *  options supported by iconv_set_attributes
   */
  #define ICONV_OPTION_SUBSTITUTE_TO   0x0001
  #define ICONV_OPTION_NO_SUBSTITUTE   0x0000

  typedef struct _iconv_attribute {
   int    type        : 16;   /* type of the target codepage, unchangable     */
   size_t mb_min_size : 8;    /* min len of a code point in byte, unchangable */
   size_t mb_max_size : 8;    /* max len of a code point in byte, unchangable */
   size_t options;            /* bitwise options                              */
   conv_endian_t endian;      /* endian                                       */
   size_t subchar_len : 8;    /* len of sub char in byte                      */
   char   subchar[32];        /* subchar to ucs                               */
   int    reserved;
  } iconv_attribute_t;

  #if defined(__IBMCPP__) || defined(__IBMC__)
    #pragma pack()
  #else
    #pragma Align_members()
  #endif

  #ifdef __cplusplus
  }
  #endif

#endif /*!_ICONV_H*/
