/*
 * COMPONENT_NAME:
 *
 * FUNCTIONS: Defines MBlconv structure - public
 *
 * ORIGINS: 27
 *
 * (C) COPYRIGHT International Business Machines Corp. 1989, 1992
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */

#ifndef _ULS_LCONV
#define _ULS_LCONV

#ifdef __cplusplus
   extern "C" {
#endif

#pragma pack( 1 )

struct mb_lconv {
    char *decimal_point;         /* decimal point character              */
    char *thousands_sep;         /* thousands separator                  */
    char *grouping;              /* digit grouping                       */
    char *int_curr_symbol;       /* international currency symbol        */
    char *currency_symbol;       /* national currency symbol             */
    char *mon_decimal_point;     /* currency decimal point               */
    char *mon_thousands_sep;     /* currency thousands separator         */
    char *mon_grouping;          /* currency digits grouping             */
    char *positive_sign;         /* currency plus sign                   */
    char *negative_sign;         /* currency minus sign                  */
    char int_frac_digits;        /* internat currency fractional digits  */
    char frac_digits;            /* currency fractional digits           */
    char p_cs_precedes;          /* currency plus location               */
    char p_sep_by_space;         /* currency plus space ind.             */
    char n_cs_precedes;          /* currency minus location              */
    char n_sep_by_space;         /* currency minus space ind.            */
    char p_sign_posn;            /* currency plus position               */
    char n_sign_posn;            /* currency minus position              */
    char os2_mondecpt;           /* os2 placement of currency symbol     */
    char *left_parenthesis;      /* negative currency left paren         */
    char *right_parenthesis;     /* negative currency right paren        */
    };

#pragma pack( )

#ifdef __cplusplus
   }
#endif

#endif
