/*
 *  @(#)48 1.9 95/08/06
 */
/*
 * COMPONENT_NAME: CPS - Registry/Name Server
 *
 * FILE_ID: name_api.h
 *
 * ORIGINS:
 *
 * (C) COPYRIGHT International Business Machines Corp. 1992,1993,1994,1995
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */
#ifndef _NAME_API_H_
#define _NAME_API_H_

#ifdef __cplusplus
  extern "C" {
#endif

#include <limits.h>             /* USHRT_MAX */

#ifndef NAMECALLCONV
#if defined(__IBMCPP__) || defined(__IBMC__)
   #define NAMECALLCONV    _Optlink
#else
   #define NAMECALLCONV
#endif
#endif

#pragma pack(4)

/* predefined node types -----------------------------------------------*/
#define NS_NODE_TYPE_DIR        0
#define NS_NODE_TYPE_ALIAS      1
#define NS_NODE_TYPE_LEAF       2

/* NameGetNodeType() flags ---------------------------------------------*/
#define NS_RESERVE_NODE_TYPE    1
#define NS_QUERY_NODE_TYPE      2

ns_error_t NAMECALLCONV NameGetNodeType(       /* get a node id from name   */
        UniChar         *node_type_name,       /* IN: node type name        */
        int              flags,                /* IN: reserve or query?     */
        ns_node_type_t  *node_type);           /* OUT: node type id         */

ns_error_t NAMECALLCONV NameGetNodeTypeName(   /* get node name from id     */
        ns_node_type_t   node_type,            /* IN: node type id          */
        vm_size_t        *node_type_name_size, /* IN|OUT: size of buffer    */
        UniChar         **node_type_name);     /* IN|OUT: node type name    */


/* Process a search/notify message
 */
typedef int
(* NAMECALLCONV ns_search_fnc_t)(           /* process a search/notif msg   */
        port_t           search_port,       /* IN: search port              */
        ns_error_t       return_code,       /* IN: the return code in msg   */
        int          num_entries,           /* IN: # entries in message     */
        int            *events,             /* IN: one event per entry      */
        ns_stack_t   *stacks);              /* IN: one stack per entry      */

/* Link id case insensitive flag valid for NameAddLink(), NameAddNode(),
 *  NameDeleteLink(), NameReLink(), NameResolve()
 */
#define NS_IGNORE_CASE                         0x00000020
#define NS_FAIL_ON_COLLISION                   0x00000040
#define NS_PREVENT_CASE_INSENSITIVE_DUPS       0x00000080
#define NS_RESOLVE_LOCAL                       0x00000100

/* Persistent flag valid on NameAddNode()
 */
#define NS_MAKE_PERSISTENT                     0x00000008

/* Delete flag valid for NameDeleteLink() and NameReLink()
 */
#define NS_SUPPRESS_EMPTY_CHECK                0x00000800

/* Conversion flags for NameConvertUnicodeToPath()
 */
#define NS_IGNORE_ENDING_DELIMITER             0x00000001
#define NS_COALESCE_CONSECUTIVE_DELIMITERS     0x00000002

/* Transaction creation feature flags for NameCreateTransaction()
 */
#define NS_FEATURE_ERR_ON_TRANSACT_BOUNDARIES  0x00000001
#define NS_FEATURE_WAIT_ON_TRANSACT_PENDING    0x00000002

/* Workspace creation feature flags for NameCreateWorkspace()
 */
#define NS_API_VERSION                         0x00000000
#define NS_API_REVISION                        0x00000001

#define NS_FEATURE_SHARED_WORKSPACE            0x00000001
#define NS_FEATURE_ALLOC_SHARED_WORKSPACE      0x00000002

/* Modify flags for NameModifyNode()
 */
#define NS_MODIFY_ATTRS                        0x00000100
#define NS_REPLACE_ATTRS                       0x00000200
#define NS_REPLACE_SERVICE_PORT                0x00000400

/*  Link delete flags for NameReLink()
 */
#define NS_DELETE_TARGET_LINK                  0x1000
#define NS_DELETE_SOURCE_LINK                  0x2000

/* Flags and values for count parameter of NameReadNode
 */
#define NS_LONG_VALUES                         0x00000001
#define NS_NO_VALUES                           0x00000002
#define NS_ALL_ATTRS                           USHRT_MAX

/* Resolve flags valid for NameResolve()
 */
#define NS_FOLLOW_ALIAS                        0x00000001
#define NS_FOLLOW_LEAF                         0x00000002
#define NS_COMPLETE_RESOLUTION                 0x00000004
#define NS_FORCE_COPY_PATH                     0x00000008
#define NS_DO_NOT_CACHE                        0x00000010

/* Flags for NameSearchAndNotify() and NameSearchAndNotifyNext()
 */
#define NS_EXACT_NUM_LEVELS                    0x00000001
#define NS_NODE_EXISTS                         0x00000002
#define NS_NODE_ADDED                          0x00000004
#define NS_NODE_DELETED                        0x00000008
#define NS_NODE_MODIFIED_ADDED                 0x00000010
#define NS_NODE_MODIFIED_DELETED               0x00000020
#define NS_NODE_MODIFIED                       0x00000040
#define NS_NO_EVENT_ARRAY                      0x00000080

/* Timeout parameters for NameSearchAndNotify() and NameSearchAndNotifyNext()
 */
#define NS_NO_WAIT                      0
#define NS_NO_TIMEOUT                  -1


/* MEH - Macros for general purpose use for building attributes */
#define NAMEINITATTRARRAY( _attr, _Unibuf, _asciiName, _sysType, _value, _count ) \
  _attr.name.count        = strlen(_asciiName); \
  char_to_UniChar( _Unibuf, _asciiName, _attr.name.count ); \
  _attr.name.name         = _Unibuf;  \
  _attr.value.user_type   = 0;          \
  _attr.value.system_type = (_sysType);  \
  _attr.value.count       = (_count);   \
  _attr.value.value.uninterpreted_byte_array = (_value)

#define NAMEINITATTRVALUE( _attr, _Unibuf, _asciiName, _sysType, _value ) \
  _attr.name.count        = strlen(_asciiName); \
  char_to_UniChar( _Unibuf, _asciiName, _attr.name.count ); \
  _attr.name.name         = _Unibuf;    \
  _attr.value.user_type   = 0;          \
  _attr.value.system_type = (_sysType);  \
  _attr.value.count       = 0;           \
  _attr.value.value.uint32_value = (_value)

/* ns_error_t NameAbortWork(
 *    ns_transaction_handle_t *transaction);           IN/OUT
 */
#define NameAbortWork(TRANSACTION) \
        NSI_FUNCTIONS2(TRANSACTION)->nsi_Abort( \
              (TRANSACTION))

/* ns_error_t NameAddLink(
 *    ns_node_handle_t         dir,                    IN
 *    ns_path_t                path,                   IN
 *    int                      flags,                  IN
 *    ns_node_handle_t         target_node);           IN
 */
#define NameAddLink(DIR,PATH,FLAGS,TARGET_NODE) \
        NSI_FUNCTIONS(DIR)->nsi_AddLink( \
              (DIR),(PATH),(FLAGS),(TARGET_NODE))

/* ns_error_t NameAddNode(
 *    ns_node_handle_t         dir,                    IN
 *    ns_path_t                path,                   IN
 *    int                      flags,                  IN
 *    ns_node_t               *new_node_contents,      IN
 *    ns_node_handle_t        *new_node);              IN/OUT
 */
#define NameAddNode(DIR,PATH,FLAGS,NEW_NODE_CONTENTS,NEWNODE) \
        NSI_FUNCTIONS(DIR)->nsi_AddNode( \
             (DIR),(PATH),(FLAGS),(NEW_NODE_CONTENTS),(NEWNODE))

/* ns_error_t NameAllocWorkspace(
 *    ns_node_handle_t         root                    IN
 */
#define NameAllocWorkspace(ROOT) \
        NSI_FUNCTIONS(ROOT)->nsi_AllocWorkspace((ROOT))

/* ns_error_t NameCheckpointWork(
 *    ns_transaction_handle_t  transaction);           IN
 */
#define NameCheckpointWork(TRANSACTION) \
        NSI_FUNCTIONS(TRANSACTION)->nsi_Checkpoint( \
              (TRANSACTION))

/* ns_error_t NameCloseNode(
 *    ns_node_handle_t        *node);                  IN/OUT
 */
#define NameCloseNode(NODE) \
        NSI_FUNCTIONS2(NODE)->nsi_CloseNode( \
              (NODE))

/* ns_error_t NameCommitWork(
 *    ns_transaction_handle_t *transaction);           IN/OUT
 */
#define NameCommitWork(TRANSACTION) \
        NSI_FUNCTIONS2(TRANSACTION)->nsi_Commit( \
              (TRANSACTION))

ns_error_t NAMECALLCONV NameConvertPathToUnicode(
   ns_path_t                   pn_path,             /* IN     */
   UniChar                     delimiter_char,      /* IN     */
   vm_size_t                  *path_size,           /* IN/OUT */
   UniChar                   **unicode_path);       /* IN/OUT */

ns_error_t NAMECALLCONV NameConvertUnicodeToPath(
   UniChar                    *unicode_path,        /* IN     */
   UniChar                    *delimiters,          /* IN     */
   int                         flags,               /* IN     */
   vm_size_t                  *path_size,           /* IN/OUT */
   ns_path_t                  *pn_path);            /* IN/OUT */


/* flag(s) for CreateWork()
 */
         /* used when handle passed to startWork */
#define NS_WAIT_ON_TRANSACTION_PENDING 0x0001 

/* ns_error_t NameCreateWork(
 *    ns_node_handle_t          dir,                   IN
 *    int                       num_levels,            IN
 *    int                       flags,                 IN
 *    ns_transaction_handle_t  *transaction);          OUT
 */
#define NameCreateWork(DIR,LEVELS,FLG,TRANSACTION) \
        NSI_FUNCTIONS(DIR)->nsi_Transact( \
              (DIR),(LEVELS),(FLG),(TRANSACTION))

ns_error_t NAMECALLCONV NameCreateWorkspace(
   int                        *features,            /* IN     */
   ns_node_handle_t           *root);               /* OUT    */

/* ns_error_t NameDeleteLink(
 *    ns_node_handle_t         dir,                    IN
 *    ns_path_t                path,                   IN
 *    int                      flags);                 IN
 */
#define NameDeleteLink(DIR,PATH,FLAGS) \
        NSI_FUNCTIONS(DIR)->nsi_DeleteLink( \
              (DIR),(PATH),(FLAGS))

/* ns_error_t NameDeleteWorkspace(
 *    ns_node_handle_t        *root);                  IN/OUT
 */
#define NameDeleteWorkspace(ROOT) \
        NSI_FUNCTIONS2(ROOT)->nsi_DeleteWorkspace((ROOT))

/* ns_error_t NameFree(
 *    void                   **ptr);                   IN/OUT
 */
#define NameFree(PTR) \
        NSI_FUNCTIONS2(PTR)->nsi_Free( \
              (PTR))

ns_error_t NAMECALLCONV NameGetAttr(
       ns_node_t        *node_contents, /* IN   */
       ns_attr_name_t   *attr_name,     /* IN   */
       ns_attr_t       **attr           /* OUT  */
);

#define NameMapNodeHandleToPort(node_handle, port) \
        NSI_FUNCTIONS(node_handle)->nsi_MapNodeHandleToPort( \
              (node_handle), (port) )

ns_error_t NAMECALLCONV NameMapPortToNodeHandle( /* map port to node handle */
        port_t            port,                  /* IN:  send right to port */
        ns_node_handle_t *node_handle);          /* OUT: a node handle      */

#define NameMapSearchHandleToPort(search_handle, port) \
        NSI_FUNCTIONS(search_handle)->nsi_MapSearchHandleToPort( \
              (search_handle), (port) )

ns_error_t NAMECALLCONV NameMapPortToSearchHandle( /* map port to Srch hndl */
        port_t              port,                  /* IN:  port send right  */
        ns_search_handle_t *Search_handle);        /* OUT: Search handle    */

/* ns_error_t NameModifyNode(
 *    ns_node_handle_t         node,                   IN
 *    ns_node_t               *node_contents,          IN
 *    int                      flags);                 IN
 */
#define NameModifyNode(NODE,NODE_CONTENTS,FLAGS) \
        NSI_FUNCTIONS(NODE)->nsi_ModifyNode( \
              (NODE),(NODE_CONTENTS),(FLAGS))

/* ns_error_t NameReadLong(
 *    ns_node_handle_t         node,                   IN
 *    ns_attr_t               *attr,                   IN/OUT
 *    int                     *value_size,             IN/OUT
 *    ns_value_t              *value);                 OUT
 */
#define NameReadLong(NODE,ATTR,VALUE_SIZE,VALUE) \
        NSI_FUNCTIONS(NODE)->nsi_ReadLong( \
              (NODE),(ATTR),(VALUE_SIZE),(VALUE))

/* ns_error_t NameReadNode(
 *    ns_node_handle_t         node,                   IN
 *    int                      flags,                  IN
 *    unsigned short           count,                  IN
 *    ns_attr_names_t          attr_names,             IN
 *    vm_size_t               *node_size,              IN/OUT
 *    ns_node_t                **node_contents);       IN/OUT
 */
#define NameReadNode(NODE,FLG,CNT,ATTR_NAMES,NODE_SIZE,NODE_CONTENTS) \
        NSI_FUNCTIONS(NODE)->nsi_ReadNode( \
              (NODE),(FLG),(CNT),(ATTR_NAMES),(NODE_SIZE),(NODE_CONTENTS))

/* ns_error_t NameReLink(
 *    ns_node_handle_t     source_dir,                 IN
 *    ns_path_t            source_path,                IN
 *    ns_node_handle_t     target_dir,                 IN
 *    ns_path_t            target_path,                IN
 *    int                  flags);                     IN
 */
#define NameReLink(DIR,PATH,TARGET_DIR,TARGET_PATH,FLAGS) \
        NSI_FUNCTIONS(DIR)->nsi_ReLink( \
              (DIR),(PATH),(TARGET_DIR),(TARGET_PATH),(FLAGS))

/* ns_error_t NameResolve(
 *    ns_node_handle_t         starting_node,          IN
 *    ns_path_t                path,                   IN
 *    int                      flags,                  IN
 *    ns_node_type_t          *node_type,              OUT
 *    ns_node_handle_t        *node_result,            OUT
 *    int                     *unresolved_path_size,   OUT
 *    ns_path_t               *unresolved_path);       OUT
 */
#define NameResolve(STARTING_NODE,PATH,FLAGS,NODETYPE,RESULT, \
                   UNRESOLVED_PATH_SIZE,UNRESOLVED_PATH) \
        NSI_FUNCTIONS(STARTING_NODE)->nsi_Resolve( \
              (STARTING_NODE),(PATH),(FLAGS),(NODETYPE),(RESULT), \
              (UNRESOLVED_PATH_SIZE),(UNRESOLVED_PATH))

/* ns_error_t NameSearchAndNotify(
 *    ns_node_handle_t         starting_node,          IN
 *    int                      number_of_levels,       IN
 *    int                      flags,                  IN
 *    ns_program_t             filter,                 IN
 *    ns_search_handle_t      *search_handle,          IN/OUT
 *    int                      wait;                   IN
 *    int                     *num_values,             IN/OUT
 *    int                    **events,                 IN/OUT
 *    int                     *stack_buffer_size,      IN/OUT
 *    ns_stack_t             **stacks);                OUT
 */
#define NameSearchAndNotify(STARTING_NODE,NUMBER_OF_LEVELS,FLAGS, \
                            FILTER,SEARCH_HANDLE, WAIT, \
                            NUM_VALUES,EVENTS,STACK_BUFFER_SIZE,STACKS) \
        NSI_FUNCTIONS(STARTING_NODE)->nsi_SearchAndNotify( \
              (STARTING_NODE),(NUMBER_OF_LEVELS),(FLAGS), \
              (FILTER),(SEARCH_HANDLE),(WAIT), \
              (NUM_VALUES),(EVENTS),(STACK_BUFFER_SIZE),(STACKS))

/* ns_error_t NameSearchClose(
 *    ns_search_handle_t      *search_handle);         IN/OUT
 */
#define NameSearchClose(SEARCH_HANDLE) \
        NSI_FUNCTIONS2(SEARCH_HANDLE)->nsi_SearchClose( \
              (SEARCH_HANDLE))

/* ns_error_t NameSearchNext(
 *    ns_search_handle_t       search_handle,          IN
 *    int                      wait,                   IN
 *    int                     *num_values,             IN/OUT
 *    int                    **events,                 IN/OUT
 *    int                     *stack_buffer_size,      IN/OUT
 *    ns_stack_t             **stacks);                IN/OUT
 */
#define NameSearchNext(SEARCH_HANDLE,WAIT,NUM_VALUES,EVENTS, \
                       STACK_BUFFER_SIZE,STACKS) \
        NSI_FUNCTIONS(SEARCH_HANDLE)->nsi_SearchNext( \
          (SEARCH_HANDLE),(WAIT),(NUM_VALUES),(EVENTS),(STACK_BUFFER_SIZE),\
          (STACKS))

/* ns_error_t NameRegisterNotifyRoutine(
 *    ns_search_handle_t       search_handle,          IN
 *    pfn                      callback_routine);      IN
 */
#define NameRegisterNotifyRoutine(SEARCH_HANDLE,NOTIFY_ROUTINE) \
        NSI_FUNCTIONS(SEARCH_HANDLE)->nsi_RegisterNotifyRoutine( \
          (SEARCH_HANDLE),(NOTIFY_ROUTINE))

void NAMECALLCONV NameNotifyRoutine(
      ns_search_handle_t   search_handle,       /* IN     */
      int                 *num_entries,         /* IN     */
      int                **events,              /* IN     */
      vm_size_t           *stack_buffer_size,   /* IN     */
      ns_stack_t         **stacks);             /* IN     */

/* ns_error_t NameStartWork(
 *    ns_transaction_handle_t  transaction);           IN
 */
#define NameStartWork(TRANSACTION) \
        NSI_FUNCTIONS(TRANSACTION)->nsi_Start( \
              (TRANSACTION))

#pragma pack()

#include <nsi.h>

#ifdef __cplusplus
  }
#endif

#endif /* _NAME_API_H_ */
