/* @(#)62 1.9 95/05/05
 *
 * COMPONENT_NAME: CPS - Registry/Name Server
 *
 * FILE_ID: name_err.h
 *
 * ORIGINS:
 *
 * (C) COPYRIGHT International Business Machines Corp. 1992,1993,1994,1995
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */
#ifndef _NAME_ERR_H_
#define _NAME_ERR_H_

#ifdef __cplusplus
  extern "C" {
#endif

#ifndef NAMECALLCONV
#if defined(__IBMCPP__) || defined(__IBMC__)
   #define NAMECALLCONV    _Optlink
#else
   #define NAMECALLCONV
#endif
#endif

#pragma pack(4)

#define NS_ESTARTRNS  0x00015400  /* base # for RNS compatible errors */
#define NS_ESTARTNAME 0x00015500  /* base # for NAME specific errors */
#define NS_ESTARTFW   0x00015600  /* base # for FW specific errors */
#define NS_ESTARTDSP  0x00015700  /* base # for DSP specific errors */

#define NS_ESUCCESS                                             0x00000000
#define NS_EACCESS                                (NS_ESTARTRNS + 0x00000000)   /* permission denied                  = */
#define NS_EDUP                                   (NS_ESTARTRNS + 0x00000001)   /* link would be case-insensitive dup   */
#define NS_EEXIST                                 (NS_ESTARTRNS + 0x00000002)   /* node already exists                = */
#define NS_EFILTER                                (NS_ESTARTRNS + 0x00000003)   /* filter execution error               */
#define NS_EINVAL                                 (NS_ESTARTRNS + 0x00000004)   /* invalid argument                   = */
#define NS_END_OF_SEARCH                          (NS_ESTARTRNS + 0x00000005)   /* no more entries in search            */
#define NS_ENOENT                                 (NS_ESTARTRNS + 0x00000006)   /* no such entity                     = */
#define NS_ENOMEM                                 (NS_ESTARTRNS + 0x00000007)   /* not enough user memory             = */
#define NS_ENOSUPPORT                             (NS_ESTARTRNS + 0x00000008)   /* unimplemented feature                */
#define NS_ENOTDIR                                (NS_ESTARTRNS + 0x00000009)   /* path component is not dir          = */
#define NS_ENOTEMPTY                              (NS_ESTARTRNS + 0x0000000A)   /* directory not empty                = */
#define NS_EMEM                                   (NS_ESTARTRNS + 0x0000000B)   /* not enough system memory             */
#define NS_EOVERFLOW                              (NS_ESTARTRNS + 0x0000000C)   /* stack/ref_count overflow             */
#define NS_EPARTIAL_RESOLUTION                    (NS_ESTARTRNS + 0x0000000D)   /* path crosses name border             */
#define NS_EPATH_AMBIGUOUS                        (NS_ESTARTRNS + 0x0000000E)   /* multiple paths satisfy resolution    */
#define NS_ETIMEOUT                               (NS_ESTARTRNS + 0x0000000F)   /* client not processing notifies       */

/* Name specific errors */

#define NS_SUCCESS                                NS_ESUCCESS

#define NS_EFAILURE                               (NS_ESTARTNAME + 0x00000000)
#define NS_ENOSUPPORT_PORTS                       (NS_ESTARTNAME + 0x00000001)
#define NS_NOSUPPORT_TRANSIENT                    (NS_ESTARTNAME + 0x00000002)
#define NS_NOSUPPORT_PERSISTENCE                  (NS_ESTARTNAME + 0x00000003)
#define NS_NOSUPPORT_MULTILINKS                   (NS_ESTARTNAME + 0x00000004)
#define NS_NOSUPPORT_LINK_PERSISTENT_TO_TRANSIENT (NS_ESTARTNAME + 0x00000005)
#define NS_ELINK_TRANSIENT_TO_PERSISTENT          (NS_ESTARTNAME + 0x00000006)
#define NS_EREADONLY                              (NS_ESTARTNAME + 0x00000007)
#define NS_NOSUPPORT_PORTS                        (NS_ESTARTNAME + 0x00000008)
#define NS_EBOUNDARY                              (NS_ESTARTNAME + 0x00000009)
#define NS_ETOOBIG                                (NS_ESTARTNAME + 0x0000000A)
#define NS_ENOSTART                               (NS_ESTARTNAME + 0x0000000B)
#define NS_ESHARE                                 (NS_ESTARTNAME + 0x0000000C)
#define NS_ESTACKSIZE                             (NS_ESTARTNAME + 0x0000000D)
#define NS_EVER                                   (NS_ESTARTNAME + 0x0000000E)
#define NS_EMAKE                                  (NS_ESTARTNAME + 0x0000000F)
#define NS_ETRANSACTPENDING                       (NS_ESTARTNAME + 0x00000010)
#define NS_ESYSTEMTYPE                            (NS_ESTARTNAME + 0x00000011)
#define NS_ENOSERVER                              (NS_ESTARTNAME + 0x00000012)
#define NS_EDELETED                               (NS_ESTARTNAME + 0x00000013)
#define NS_ELEAF                                  (NS_ESTARTNAME + 0x00000014)
#define NS_EEXCP_SP                               (NS_ESTARTNAME + 0x00000015)
#define NS_ENOTRANSACTONNAMEROOT                  (NS_ESTARTNAME + 0x00000016)  /* Can't create a transaction from default ws */

#define NS_EEXCP_FW                               (NS_ESTARTFW   + 0x00000000)

#define NS_EEXCP_DSP                              (NS_ESTARTDSP  + 0x00000000)
#define NS_ESYNTAX                                (NS_ESTARTDSP  + 0x00000001)
#define NS_ENOTIFY_ROUTINE_REGISTERED             (NS_ESTARTDSP  + 0x00000002)
#define NS_EUNTRANSLATABLE_SYSTEM_RETURN_CODE     (NS_ESTARTDSP  + 0x00000003)
#define NS_ETEMP_ONE_AT_A_TIME_RESTRICTION        (NS_ESTARTDSP  + 0x00000004)  /* DGE16 */

#pragma pack()

#ifdef __cplusplus
  }
#endif

#endif /* _NAME_ERR_H_ */
