/*
 *  @(#)63 1.11 95/08/10
 */
/*
 * COMPONENT_NAME: CPS - Registry/Name Server
 *
 * FILE_ID: name_typ.h
 *
 * ORIGINS:
 *
 * (C) COPYRIGHT International Business Machines Corp. 1992,1993,1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */
#ifndef _NAME_TYP_H_
#define _NAME_TYP_H_

#ifdef __cplusplus
  extern "C" {
#endif

/* PREREQUISITE HEADER FILES -----------------------------------------*/
/* NOTE:  We should be able to use UNIDEF.H to eliminate the logic    */
/*        associated with UniChar.                                    */
#if defined(__OS2_H__) || defined(OS2SRV)      /* for a OS2SRVR build */
  #ifndef _UNICHAR_H_               /* not included UniChar.h already */
    #define _UNICHAR_H_
    #ifndef _ULS_UNICHAR_DEFINED
      #define _ULS_UNICHAR_DEFINED
      typedef unsigned short UniChar;
    #endif
  #endif
  #ifndef _MK_H_                        /* not included mach.h already */
    typedef unsigned int   vm_size_t;
    typedef unsigned int   port_t     ;
  #endif
#else
  #include <pns/UniChar.h>                            /* UniChar      */
  #include <mk.h>                                     /* vm_size_t    */
                                                      /* port_t       */
#endif

#ifndef NAMECALLCONV
#if defined(__IBMCPP__) || defined(__IBMC__)
   #define NAMECALLCONV    _Optlink
#else
   #define NAMECALLCONV
#endif
#endif

#pragma pack(4)

/*
 * Type and structure definitions
 */

/*
 *  NOTE:  This is not bullet-proof; we need to coordinate
 *  a solution that is independent of the include orders!!!
 *
 *  The following types are in mach_type.h and should not be
 *  included if the user has already included the mach_types.h
 *  file.
 *
 */
#ifndef _MACH_MACH_TYPES_H_
typedef  signed   char    int8;
typedef  unsigned char    uint8;
typedef  short            int16;
typedef  unsigned short   uint16;
typedef  int              int32;
typedef  unsigned         uint32;
#endif

typedef struct val64_s {
    int               lo;
    unsigned          hi;
} val64;

typedef struct uval64_s {
    uint32            lo;
    uint32            hi;
} uval64;

typedef  unsigned char    ubyte;

typedef  unsigned         ns_node_handle_t;
typedef  unsigned         ns_search_handle_t;
typedef  unsigned         ns_trans_handle_t;
typedef  unsigned         ns_invalid_handle_t;
typedef  unsigned         ns_error_t;
typedef  unsigned long    acl_t;    /* Temporary until security supported */

/* link name types -----------------------------------------------------*/
#define NS_LINK_NAME_ID         1
#define NS_LINK_NAME_END        0

typedef struct ns_link_name {           /* a link name contains:        */
        short           type;           /* NS_LINK_NAME_ID or ..._END   */
        unsigned short  count;          /* # of unichars in link name   */
        UniChar        *name;           /* link name unicode string     */
} ns_link_name_t, *ns_path_t;           /* a path is an array of link names */

/*
 *    ns_attr_type_t:
 *
 *          Attribute and stack types known by system
 */
#define NS_TYPE_BOOLEAN                1
#define NS_TYPE_CHAR                   2
#define NS_TYPE_UCHAR                  3
#define NS_TYPE_UNICHAR                4
#define NS_TYPE_INT8                   5
#define NS_TYPE_UINT8                  6
#define NS_TYPE_INT16                  7
#define NS_TYPE_UINT16                 8
#define NS_TYPE_INT32                  9
#define NS_TYPE_UINT32                10
#define NS_TYPE_VAL64                 11
#define NS_TYPE_UVAL64                12
#define NS_TYPE_PORT                  13
#define NS_TYPE_NODE_HANDLE           14
#define NS_TYPE_ATTR_NAME             15
#define NS_TYPE_ATTR                  16
#define NS_TYPE_NODE_CONTENTS         17
#define NS_TYPE_LINK_NAME             18
#define NS_TYPE_PATH                  19
#define NS_TYPE_TYPED_VALUE           20
#define NS_TYPE_UNINTERPRETED_BYTE    21
#define NS_TYPE_NO_VALUE              22
#define NS_TYPE_DEL                   23
#define NS_TYPE_TOP_OF_STACK          24
#define NS_TYPE_TARGET_PATH           25

/* Defines for user_type */
#define NS_TYPE_USER_NO_TYPE           0
#define NS_TYPE_USER_FS_DATE           1
#define NS_TYPE_USER_FS_TIME           2

/*
 * System type flag bits
 */

#define NS_TYPE_ARRAY            0x8000  /* Value is pointer to array       */
#define NS_TYPE_LONG_VALUE       0x4000  /* Array value has more to be read */
#define NS_TYPE_VALUE_NOT_VALID  0x2000  /* Value field is not valid        */
#define NS_TYPE_MASK            ~(NS_TYPE_ARRAY | NS_TYPE_LONG_VALUE | \
                                  NS_TYPE_VALUE_NOT_VALID)

/*
 *    ns_attr_value_t:
 *
 *          Attribute values
 */
typedef union ns_value {
      int                      boolean_value;
      int                     *boolean_array;
      char                     char_value;
      char                    *char_array;
      unsigned char            uchar_value;
      unsigned char           *uchar_array;
      UniChar                  unichar_value;
      UniChar                 *unichar_array;
      int8                     int8_value;
      int8                    *int8_array;
      uint8                    uint8_value;
      uint8                   *uint8_array;
      int16                    int16_value;
      int16                   *int16_array;
      uint16                   uint16_value;
      uint16                  *uint16_array;
      int32                    int32_value;
      int32                   *int32_array;
      uint32                   uint32_value;
      uint32                  *uint32_array;
      val64                   *val64_value;
      val64                   *val64_array;
      uval64                  *uval64_value;
      uval64                  *uval64_array;
      port_t                   port_value;
      port_t                  *port_array;
      ns_node_handle_t         node_handle_value;
      ns_node_handle_t        *node_handle_array;
      struct ns_attr_name     *attr_name_value;
      struct ns_attr_name     *attr_name_array;
      struct ns_attr          *attr_value;
      struct ns_attr          *attr_array;
      struct ns_node          *node_contents_value;
      struct ns_node          *node_contents_array;
      ns_link_name_t          *link_name_value;
      ns_link_name_t         **link_name_array;
      ns_path_t                path_value;
      ns_path_t               *path_array;
      struct ns_typed_value   *typed_value_value;
      struct ns_typed_value   *typed_value_array;
      ubyte                    uninterpreted_byte_value;
      void                    *uninterpreted_byte_array;
} ns_value_t;

typedef struct ns_attr_name {
   UniChar          *name;
   unsigned short    count;
} ns_attr_name_t, *ns_attr_names_t;

typedef struct ns_typed_value {
   unsigned short  user_type;
   unsigned short  system_type;
   int             count;
   union ns_value  value;
} ns_typed_value_t;

/*
 *    ns_attr_t:
 *
 *          Defines the attribute set of a node
 */
typedef struct ns_attr {
      ns_attr_name_t                name;
      ns_typed_value_t              value;
} ns_attr_t, *ns_attrs_t;

/*
 * Limits
 */
#define NS_MAX_NODE_TYPES           0x40000
#define NS_MAX_NODE_TYPE_NAME_SIZE  128

/*
 * Node flags
 */
#define NS_RETAIN_UNTIL_NO_MORE_REFERENCES     1

/*
 * Leaf flags
 */
#define NS_DELETE_ON_PORT_DEATH                1

typedef unsigned long      ns_node_type_t;

/*
 *    ns_node_t:
 *
 *          Node contents are represented by one of these
 */
typedef struct ns_node {
      unsigned long                 reference_count;
      ns_node_type_t                node_type;
      unsigned short                node_flags;
      unsigned short                count;
      ns_attrs_t                    attrs;
      acl_t                         acl;
      union {
         /* The service_port, leaf_flags, and target node fields must
          * be null as input, and are always returned null by the NS API.
          * The field names are present for consistency and greater
          * source portability between NS API and NS PNI.
          */
         struct { /* for when type.system_type == NS_NODE_LEAF
                   */
               port_t               service_port;
               int                  leaf_flags;
         } leaf;
         struct { /* for when type.system_type == NS_NODE_ALIAS
                   */
               ns_node_handle_t     target_node;
               ns_path_t            target_path;
         } alias;
      } variant;
} ns_node_t;

/*
 *    ns_handle_t
 *
 *          Defines the handle types returned by Resolve
 */
typedef union ns_handle {
   ns_node_handle_t                 node_handle;
   port_t                           port;
} ns_handle_t;

/*
 * ns_opcode_t:
 *
 *          Opcodes allowed in a search/notify filter
 */
typedef enum {
    NS_OP_PUSH,

    NS_OP_POP,
    NS_OP_COPY,
    NS_OP_SWAP,

    NS_OP_PUSH_NODE_HANDLE,
    NS_OP_PUSH_NODE_CONTENTS,
    NS_OP_PUSH_REFERENCE_COUNT,
    NS_OP_PUSH_NODE_TYPE,
    NS_OP_PUSH_NODE_FLAGS,
    NS_OP_PUSH_COUNT,
    NS_OP_PUSH_ATTRS,
    NS_OP_PUSH_SERVICE_PORT,
    NS_OP_PUSH_LEAF_FLAGS,
    NS_OP_PUSH_TARGET_NODE,
    NS_OP_PUSH_TARGET_PATH,

    NS_OP_PUSH_PATH,         /* Pushes last path */
    NS_OP_PUSH_LAST_LINK_NAME,

    NS_OP_ATTR_VALUE,
    NS_OP_ATTR_EXISTS,

    NS_OP_USER_TYPE,
    NS_OP_SYSTEM_TYPE,
    NS_OP_COUNT,
    NS_OP_NTH,
    NS_OP_IN,

    NS_OP_ADD,
    NS_OP_SUBTRACT,
    NS_OP_MULTIPLY,
    NS_OP_DIVIDE,

    NS_OP_AND,
    NS_OP_OR,
    NS_OP_XOR,
    NS_OP_NOT,

    NS_OP_SAME,
    NS_OP_NOT_SAME,
    NS_OP_EQUAL,
    NS_OP_NOT_EQUAL,
    NS_OP_LESS,
    NS_OP_LESS_EQUAL,
    NS_OP_GREATER,
    NS_OP_GREATER_EQUAL,

    NS_OP_LEFT_STR,
    NS_OP_RIGHT_STR,
    NS_OP_MID_STR,

    NS_OP_EQUAL_IGNORE_CASE,
    NS_OP_NOT_EQUAL_IGNORE_CASE,
    NS_OP_LESS_IGNORE_CASE,
    NS_OP_LESS_EQUAL_IGNORE_CASE,
    NS_OP_GREATER_IGNORE_CASE,
    NS_OP_GREATER_EQUAL_IGNORE_CASE,

    NS_OP_LEFT_STR_IGNORE_CASE,
    NS_OP_RIGHT_STR_IGNORE_CASE,
    NS_OP_MID_STR_IGNORE_CASE,

    NS_OP_STOP_IF_TRUE,
    NS_OP_STOP_IF_FALSE,
    NS_OP_END_OF_PROGRAM,

    /*  NOTE:  RNS-Registry discrepancy.                    */
    /*  The following op-codes are unique to Registry as of */
    /*  28 June 1995.  We are trying to converge the ns*.h  */
    /*  and name*.h headers so this may change.             */
    NS_OP_PUSH_NODE_ID,
    NS_OP_PUSH_VISIT_COUNT,  /* Pushes a count that increments each time a
                              * node is visited due to multiple references
                              */
    NS_OP_PUSH_FIRST_PATH,   /* Always the shortest path to a node */

    NS_OP_BRANCH_IF_TRUE,
    NS_OP_BRANCH_IF_FALSE,
    NS_OP_BRANCH,

    NS_OP_SAME_IGNORE_CASE,
    NS_OP_NOT_SAME_IGNORE_CASE

} ns_opcode_t;

/*
 *    ns_type_t:
 *
 *          Identifies a type that a search/notify filter or a stack
 *          knows about, and whose value can be any defined for
 *          ns_attr_type_t
 */
typedef int             ns_type_t;

/*
 *    ns_filter_t:
 *
 *          Used in the definition of search/notify filters
 */
typedef union ns_program_step {
   ns_opcode_t          opcode;
   unsigned             user_type;
   unsigned             system_type;
   int                  count;
   ns_value_t           value;
} ns_program_step_t, *ns_program_t;

/*
 *    ns_stack_t:
 *
 *          Stack returned on searches and notifications
 */
typedef ns_typed_value_t *ns_stack_t;

#pragma pack()

#ifdef __cplusplus
  }
#endif

#endif     /* _NAME_TYP_H_ */
