/*
 *  @(#)65 1.10 95/08/06
 */
/*
 *    nsi_attr_t:
 *
 *          An array of these defines the attribute set of a node
 */

#ifndef _NSI_H_
#define _NSI_H_

#ifdef __cplusplus
  extern "C" {
#endif

#ifndef NAMECALLCONV
#if defined(__IBMCPP__) || defined(__IBMC__)
   #define NAMECALLCONV    _Optlink
#else
   #define NAMECALLCONV
#endif
#endif

#pragma pack(4)

typedef struct nsi_attr {
      ns_attr_name_t                name;
      ns_typed_value_t              value;
} nsi_attr_t;

/*
 *    nsi_link_t:
 *
 *          Defines a directed link between nodes
 */
typedef struct nsi_link *nsi_link_ptr;
typedef struct nsi_link {
      nsi_link_ptr                  next;
      ns_node_t                    *child;
      ns_node_t                    *parent;
      ns_link_name_t                name;
} nsi_link_t;

typedef struct NSI_workspace_body *NSI_workspace;

typedef int
(* NAMECALLCONV NSI_GetMem) (
      NSI_workspace         workspace,          /* IN     */
      void                **ppv,                /* OUT    */
      unsigned int          cb                  /* IN     */
);

typedef int
(* NAMECALLCONV NSI_FreeMem) (
      NSI_workspace         workspace,          /* IN     */
      void                 *ppv                 /* IN     */
);

typedef ns_error_t
(* NAMECALLCONV NSI_AddNode) (
      ns_node_handle_t     dir,                 /* IN     */
      ns_path_t            path,                /* IN     */
      int                  flags,               /* IN     */
      ns_node_t           *new_node_contents,   /* IN     */
      ns_node_handle_t    *new_node             /* IN/OUT */
);

typedef ns_error_t
(* NAMECALLCONV NSI_ReadNode) (
      ns_node_handle_t     node,                /* IN     */
      int                  flags,               /* IN     */
      unsigned short       count,               /* IN     */
      ns_attr_names_t      attr_names,          /* IN     */
      vm_size_t           *node_size,           /* IN/OUT */
      ns_node_t          **node_contents        /* OUT    */
);

typedef ns_error_t
(* NAMECALLCONV NSI_ReadLong) (
      ns_node_handle_t   node,               /* IN     */
      ns_attr_t         *attr,               /* IN     */
      vm_size_t         *value_size,         /* IN/OUT */
      ns_value_t       **value               /* OUT    */
);

typedef ns_error_t
(* NAMECALLCONV NSI_ModifyNode) (
      ns_node_handle_t     node,                /* IN     */
      ns_node_t           *node_contents,       /* IN     */
      int                  flags                /* IN     */
);

typedef ns_error_t
(* NAMECALLCONV NSI_CloseNode) (
      ns_node_handle_t    *node                 /* IN/OUT */
);

typedef ns_error_t
(* NAMECALLCONV NSI_AddLink) (
      ns_node_handle_t     dir,                 /* IN     */
      ns_path_t            path,                /* IN     */
      int                  flags,               /* IN     */
      ns_node_handle_t     target_node          /* IN     */
);

typedef ns_error_t
(* NAMECALLCONV NSI_DeleteLink) (
      ns_node_handle_t     dir,                 /* IN     */
      ns_path_t            path,                /* IN     */
      int                  flags                /* IN     */
);

typedef ns_error_t
(* NAMECALLCONV NSI_ReLink) (
      ns_node_handle_t     source_dir,          /* IN     */
      ns_path_t            source_path,         /* IN     */
      ns_node_handle_t     target_dir,          /* IN     */
      ns_path_t            target_path,         /* IN     */
      int                  flags                /* IN     */
);

typedef ns_error_t
(* NAMECALLCONV NSI_Resolve) (
      ns_node_handle_t     starting_node,       /* IN     */
      ns_path_t            path,                /* IN     */
      int                  flags,               /* IN     */
      ns_node_type_t      *node_type,           /* OUT    */
      ns_handle_t         *handle,              /* OUT    */
      vm_size_t           *unresolved_path_size,/* OUT    */
      ns_path_t           *unresolved_path      /* OUT    */
);

typedef ns_error_t
(* NAMECALLCONV NSI_Free) (
      void               **ptr                  /* IN/OUT */
);

typedef ns_error_t
(* NAMECALLCONV NSI_SearchAndNotify) (
      ns_node_handle_t     starting_node,       /* IN     */
      int                  num_levels,          /* IN     */
      int                  flags,               /* IN     */
      ns_program_t         filter,              /* IN     */
      ns_search_handle_t  *search_handle,       /* IN/OUT */
      int                  timeout,             /* IN     */
      int                 *num_entries,         /* IN/OUT */
      int                **events,              /* IN/OUT */
      vm_size_t           *stack_buffer_size,   /* IN/OUT */
      ns_stack_t         **stacks               /* OUT    */
);

typedef ns_error_t
(* NAMECALLCONV NSI_SearchNext) (
      ns_search_handle_t   search_handle,       /* IN     */
      int                  timeout,             /* IN     */
      int                 *num_entries,         /* IN/OUT */
      int                **events,              /* IN/OUT */
      vm_size_t           *stack_buffer_size,   /* IN/OUT */
      ns_stack_t         **stacks               /* IN/OUT */
);

typedef ns_error_t
(* NAMECALLCONV NSI_RegisterNotifyRoutine) (
      ns_search_handle_t   search_handle,       /* IN     */
      void                *notify_routine       /* IN     */
);

typedef ns_error_t
(* NAMECALLCONV NSI_SearchClose) (
      ns_search_handle_t  *search_handle        /* IN/OUT */
);

typedef ns_error_t
(* NAMECALLCONV NSI_Transact) (
      ns_node_handle_t     dir,                 /* IN     */
      int                  num_levels,          /* IN     */
      int                  flags,               /* IN     */
      ns_trans_handle_t    *trans_handle        /* OUT    */
);

typedef ns_error_t
(* NAMECALLCONV NSI_Start) (
      ns_trans_handle_t     trans_handle        /* IN     */
);

typedef ns_error_t
(* NAMECALLCONV NSI_Commit) (
      ns_trans_handle_t   *transn_handle        /* IN/OUT */
);

typedef ns_error_t
(* NAMECALLCONV NSI_Abort) (
      ns_trans_handle_t   *trans_handle         /* IN/OUT */
);

typedef ns_error_t
(* NAMECALLCONV NSI_Checkpoint) (
      ns_trans_handle_t    trans_handle         /* IN     */
);

typedef ns_error_t
(* NAMECALLCONV NSI_DeleteWorkspace) (
      ns_node_handle_t    *root                 /* IN/OUT */
);

typedef ns_error_t
(* NAMECALLCONV NSI_AllocWorkspace) (
      ns_node_handle_t     root                 /* IN */
);

typedef ns_error_t
(* NAMECALLCONV NSI_MapNodeHandleToPort) (
      ns_node_handle_t   node_handle,            /* IN */
      port_t            *port                    /* OUT */
);

typedef ns_error_t
(* NAMECALLCONV NSI_MapSearchHandleToPort) (
      ns_search_handle_t   search_handle,          /* IN */
      port_t              *port                    /* OUT */
);

typedef struct NSI_functions_body {
       int                     function_number;
       NSI_AllocWorkspace      nsi_AllocWorkspace;
       NSI_AddNode             nsi_AddNode;
       NSI_ReadNode            nsi_ReadNode;
       NSI_ModifyNode          nsi_ModifyNode;
       NSI_CloseNode           nsi_CloseNode;
       NSI_AddLink             nsi_AddLink;
       NSI_DeleteLink          nsi_DeleteLink;
       NSI_ReLink              nsi_ReLink;
       NSI_Resolve             nsi_Resolve;
       NSI_Free                nsi_Free;
       NSI_SearchAndNotify     nsi_SearchAndNotify;
       NSI_SearchNext          nsi_SearchNext;
       NSI_SearchClose         nsi_SearchClose;
       NSI_Transact            nsi_Transact;
       NSI_Start               nsi_Start;
       NSI_Commit              nsi_Commit;
       NSI_Abort               nsi_Abort;
       NSI_Checkpoint          nsi_Checkpoint;
       NSI_DeleteWorkspace     nsi_DeleteWorkspace;
       NSI_ReadLong            nsi_ReadLong;
       NSI_MapNodeHandleToPort   nsi_MapNodeHandleToPort;
       NSI_MapSearchHandleToPort nsi_MapSearchHandleToPort;
       NSI_GetMem                GetMem;
       NSI_FreeMem               FreeMem;
       NSI_RegisterNotifyRoutine nsi_RegisterNotifyRoutine;
} NSI_functions;

struct NSI_workspace_body {
       void                            *SPD_workspace;
       NSI_functions                   *functions;
};

typedef ns_error_t
  (* NAMECALLCONV NSI_CreateWorkspace)( NSI_workspace     workspace,
                          int              *features,
                          ns_node_handle_t *root_node );

#define NSI_WORKSPACE(object) ((NSI_workspace) *(((int *) (object))-2))
#define NSI_FUNCTIONS(object) ((NSI_functions *) *(((int *) (object))-1))
#define NSI_FUNCTIONS2(object) ((NSI_functions *) *(((int *) (*object))-1))

#define NS_OVERRIDE_EBOUNDARIES 64

#pragma pack()

#ifdef __cplusplus
  }
#endif

#endif     /* _NSI_H_ */
