/*
 * COMPONENT_NAME:
 *
 * FUNCTIONS: Core locale structures - public
 *
 * ORIGINS: 27
 *
 * (C) COPYRIGHT International Business Machines Corp. 1985, 1992
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */

#ifndef _ULS_LC_CORE
#define _ULS_LC_CORE

#ifdef __cplusplus
   extern "C" {
#endif

/* compiler dependent includes */
#include <stddef.h>           /* size_t and wchar_t defines */

/* ULS includes */
#include <mb_lconv.h>            /* for mb_lconv structure */


#ifdef _PTR_METH
#       define __DECL_METH(__h,__n)     __h __n
#       define __OBJ_DATA(__h)          (__h).obj
#else
#       define __DECL_METH(__h,__n)     int __n
#       define __OBJ_DATA(__h)          (__h).obj
#       define __OBJ_METH(__h)          (__h).meth
#endif

typedef struct {
    unsigned short __type_id;
    unsigned short __magic;
    unsigned long __version;
    size_t  __size;

} _LC_object_t;

/*
 * Valid type ids for type_id above.
 */
#define _LC_CAR       1
#define _LC_LOCALE    2
#define _LC_CHARMAP   3
#define _LC_CTYPE     4
#define _LC_COLLATE   5
#define _LC_NUMERIC   6
#define _LC_MONETARY  7
#define _LC_TIME      8
#define _LC_RESP      9
#define _LC_OBJ_HDL   10


/*
 * Version Identification
 */
#define _LC_MAGIC       0x4C43          /* object magic number for V3.2 */
#define _LC_VERSION     0x40000000      /* AIX V4.0 */

#define _LC_MAJOR_PART(version) ((version) >> 16)
#define _LC_MINOR_PART(version) ((version) & 0x0000ffff)
#define _LC_MAJOR       _LC_MAJOR_PART(_LC_VERSION)
#define _LC_MINOR       _LC_MINOR_PART(_LC_VERSION)


/* --- Category core structures --- */

typedef struct {

    _LC_object_t  __hdr;

      /* Message Services API Methods */
    __DECL_METH(unsigned char *, __catgets);
    __DECL_METH(void,            __catclose);

      /* Message compression methods */
    __DECL_METH(char *, __compress);
    __DECL_METH(char *, __decompress);
    __DECL_METH(int,    __start_compress);
    __DECL_METH(int,    __end_compress);

      /* Initialization method */
    __DECL_METH(int,    __init);
    void    *__data;

} _LC_core_car_t;


typedef struct {

    _LC_object_t  __hdr;

    /* locale info method */
    __DECL_METH(char *,  __nl_langinfo);

    /* Process code conversion methods */
    __DECL_METH(size_t,  __mbtowc);
    __DECL_METH(size_t,  __mbstowcs);
    __DECL_METH(int,     __wctomb);
    __DECL_METH(size_t,  __wcstombs);

    /* Character encoding length method */
    __DECL_METH(int,     __mblen);

    /* Character display width methods */
    __DECL_METH(size_t,  __wcswidth);
    __DECL_METH(size_t,  __wcwidth);

    /* private PC/CP converters */
    __DECL_METH(int,     __mbtopc);
    __DECL_METH(int,     __mbstopcs);
    __DECL_METH(int,     __pctomb);
    __DECL_METH(int,     __pcstombs);

    /* character set id method */
    __DECL_METH(char *,  __csid);
    __DECL_METH(char *,  __wcsid);

    /* implementation initialization */
    __DECL_METH(int,     __init);
    void     *__data;
} _LC_core_charmap_t;


typedef struct {

    _LC_object_t  __hdr;

    /* case conversion methods */
    __DECL_METH(wchar_t,    __towupper);
    __DECL_METH(wchar_t,    __towlower);

    /* classification methods */
    __DECL_METH(unsigned int,  __get_wctype);
    __DECL_METH(int,           __is_wctype);

    /* implementation initialization */
    __DECL_METH(int,        __init);
    void     *__data;

} _LC_core_ctype_t;


typedef struct {

    _LC_object_t  __hdr;

    /* character collation methods */
    __DECL_METH(int,      __strcoll);
    __DECL_METH(size_t,   __strxfrm);

    /* process code collation methods */
    __DECL_METH(int,      __wcscoll);
    __DECL_METH(size_t,   __wcsxfrm);

    /* filename matching methods */
    __DECL_METH(int,      __fnmatch);

    /* regular expression methods */
    __DECL_METH(int,      __regcomp);
    __DECL_METH(size_t,   __regerror);
    __DECL_METH(int,      __regexec);
    __DECL_METH(void,     __regfree);

    /* implementation initialization */
    __DECL_METH(int,      __init);
    void     *__data;
} _LC_core_collate_t;


typedef struct {

    _LC_object_t  __hdr;

    /* time info method */
    __DECL_METH(char *,   __nl_langinfo);

    /* time character string formatting methods */
    __DECL_METH(size_t,   __strftime);
    __DECL_METH(char *,   __strptime);

    /* time process code string formatting methods */
    __DECL_METH(size_t,   __wcsftime);

    /* implementation initialization */
    __DECL_METH(int,      __init);
    void     *__data;
} _LC_core_time_t;


typedef struct {

    _LC_object_t  __hdr;

    /* monetary info method */
    __DECL_METH(char *,   __nl_langinfo);

    /* character string monetary formatting method */
    __DECL_METH(size_t,   __strfmon);

    /* implementation initialization */
    __DECL_METH(int,      __init);
    void     *__data;
} _LC_core_monetary_t;


typedef struct {

    _LC_object_t  __hdr;

    /* langinfo method */
    __DECL_METH(char *,   __nl_langinfo);

    /* implementation initialization */
    __DECL_METH(int,      __init);
    void     *__data;
} _LC_core_numeric_t;


typedef struct {

    _LC_object_t  __hdr;

    /* langinfo method */
    __DECL_METH(char *,  __nl_langinfo);

    /* response matching method */
    __DECL_METH(char *,  __rpmatch);

    /* implementation initialization */
    __DECL_METH(int,     __init);
    void        *__data;
} _LC_core_resp_t;


typedef struct {

    _LC_object_t __hdr;

    /* langinfo method */
    __DECL_METH(char *,         __nl_langinfo);
    __DECL_METH(struct mb_lconv *, __localeconv);

    /* Initialization */
    __DECL_METH(int,   __init);
    void         *__data;
} _LC_core_locale_t;

#ifdef __cplusplus
   }
#endif

#endif
