/*
 * COMPONENT_NAME:
 *
 * FUNCTIONS: *_EXT - public - needed by .c files produced by locdef.exe
 *
 * ORIGINS: 27
 *
 * (C) COPYRIGHT International Business Machines Corp. 1989, 1992
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */

/* ---------- Category methods and data extensions ---------------- */

/* 13.9.93 Method and data pointers have been added to each category handle.
 * These will be used to extend the method table as described in the ULS
 * Base System Enhancement Detailed Design Spec 1.1.
 * This file contains the category extensions and macros used to access them.
 */

#ifndef _ULS_LC_EXT
#define _ULS_LC_EXT

#ifdef __cplusplus
   extern "C" {
#endif

#define _LC_UNI_MINOR     0x0100

#include <sys\locdata.h>         /* includes lc_core.h as well */

/*
 * ---- cast the data and method pointers since defined as void* ----
 */
#define __OBJ_DATA_EXT(hdl, category)       \
                ((_LC_##category##_data_t*)((hdl).obj->__data_ptr))
#define __OBJ_METH_EXT(hdl, category)       \
                ((_LC_##category##_meth_t*)((hdl).obj->__meth_ptr))

/*
 * ---------- locale extensions ----------
 */
#define N_LC_CATEGORIES 6
typedef struct {
        char *locale_names[N_LC_CATEGORIES];
        void *layout_hdl;
} _LC_locale_data_t;

#ifdef __cplusplus
   }
#endif

#endif
