/*
 * COMPONENT_NAME:
 *
 * FUNCTIONS: locale structures - public
 *
 * (C) COPYRIGHT International Business Machines Corp. 1991, 1992
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */

/* Updates:
 *      category handles now contain pointer back to parent locale
 *              handle.
 *      category records contain pointers to containing locale record,
 *              and pointers to extended locale methods and data.
 *      locale names are now part of locale data instead of global.
 */

#ifndef _ULS_LOCDATA
#define _ULS_LOCDATA

#ifdef __cplusplus
   extern "C" {
#endif

/* compiler dependent includes */
#include <stddef.h>         /* wchar_t */

/* ULS includes */
#include <ulslimit.h>       /* uls limits */
#include <sys\lc_core.h>    /* core structs */
#include <mb_lconv.h>          /* mb_lconv struct */

#ifdef INCL_386
   struct __LC_locale;
   struct _LC_locale_objhdl;
#endif /* INCL_386 */

#if !defined(COLL_WEIGHTS_MAX)
#       define _COLL_WEIGHTS_MAX  6
#else
#       define _COLL_WEIGHTS_MAX COLL_WEIGHTS_MAX
#endif

/* -------- Category Structures and their Handles -------- */

/* _LC_charmap_t
 *
 * maps characters to process code and vice-versa.
 */
typedef struct {

    _LC_core_charmap_t core;

    char     *cm_csname;        /* codeset name  */
    size_t   cm_mb_cur_max;     /* max encoding length for this codeset  */
    size_t   cm_mb_cur_min;     /* min encoding length for this codeset  */
    unsigned char
             cm_max_disp_width; /* max display width of any char */
                                /* in the codeset */
    unsigned
        char *cm_cstab;         /* character set id table. */

    struct __LC_locale *loc_rec;/* back pointer to containing locale */
    void    *__meth_ptr;
    void    *__data_ptr;

} _LC_charmap_t;

typedef struct _LC_charmap_objhdl _LC_charmap_objhdl_t;
struct _LC_charmap_objhdl {
        _LC_charmap_t *obj;
#       ifndef _PTR_METH
                void *(** meth)();
#       endif
        struct _LC_locale_objhdl *loc_hdl;    /* parent locale */
};


/* _LC_monetary_t
 *
 * MONETARY class defines the formatting of monetary
 * quantities for a locale.
 */
typedef struct {

    _LC_core_monetary_t   core;

    char *int_curr_symbol;         /* international currency symbol*/
    char *currency_symbol;         /* national currency symbol  */
    char *mon_decimal_point;       /* currency decimal point    */
    char *mon_thousands_sep;       /* currency thousands separator*/
    char *mon_grouping;            /* currency digits grouping  */
    char *positive_sign;           /* currency plus sign        */
    char *negative_sign;           /* currency minus sign       */
    signed char int_frac_digits;   /* internat currency fract digits*/
    signed char frac_digits;       /* currency fractional digits*/
    signed char p_cs_precedes;     /* currency plus location    */
    signed char p_sep_by_space;    /* currency plus space ind.  */
    signed char n_cs_precedes;     /* currency minus location   */
    signed char n_sep_by_space;    /* currency minus space ind. */
    signed char p_sign_posn;       /* currency plus position    */
    signed char n_sign_posn;       /* currency minus position   */
    char *debit_sign;              /* currency debit symbol     */
    char *credit_sign;             /* currency credit symbol    */
    char *left_parenthesis;        /* currency left parenthesis */
    char *right_parenthesis;       /* currency right parenthesis */
    signed char os2_mondecpt;      /* currency dec pt position  */

    struct __LC_locale *loc_rec;    /* back ptr to containing locale*/
    void    *__meth_ptr;
    void    *__data_ptr;

} _LC_monetary_t;

typedef struct _LC_monetary_objhdl _LC_monetary_objhdl_t;
struct _LC_monetary_objhdl {
        _LC_monetary_t *obj;
#       ifndef _PTR_METH
                void *(**   meth)();
#       endif
        struct _LC_locale_objhdl *loc_hdl;    /* parent locale */
};


/* _LC_numeric_t
 *
 * NUMERIC class defines the formatting of numeric quantities in a locale.
 */
typedef struct {

    _LC_core_numeric_t core;

    char     *decimal_point;
    char     *thousands_sep;
    unsigned char *grouping;

    struct __LC_locale *loc_rec; /* back pointer to containing locale */
    void    *__meth_ptr;         /* extended locale methods */
    void    *__data_ptr;         /* extedend locale data */

} _LC_numeric_t;

typedef struct _LC_numeric_objhdl _LC_numeric_objhdl_t;
struct _LC_numeric_objhdl {
        _LC_numeric_t *obj;
#       ifndef _PTR_METH
                void *(** meth)();
#       endif
        struct _LC_locale_objhdl *loc_hdl;    /* parent locale */
};


/* _LC_resp_t
 *
 * Defines the content of affirmative versus negative responses
 * in a locale.
 */
typedef struct  {

    _LC_core_resp_t core;

    char    *yesexpr;        /* POSIX: Expression for affirmative. */
    char    *noexpr;         /* POSIX: Expression for negative. */
    char    *yesstr;         /* X/OPEN: colon sep str for affirmative. */
    char    *nostr;          /* X/OPEN: colon sep str for negative. */
    char    *listsep;        /* OS/2 compatibility list separator */

    struct __LC_locale *loc_rec; /* back pointer to containing locale */
    void    *__meth_ptr;
    void    *__data_ptr;

} _LC_resp_t;

typedef struct _LC_resp_objhdl _LC_resp_objhdl_t;
struct _LC_resp_objhdl {
        _LC_resp_t *obj;
#       ifndef _PTR_METH
                void *(**   meth)();
#       endif
        struct _LC_locale_objhdl *loc_hdl;      /* parent locale */
};


/* _LC_time_t
 *
 * TIME class defines the formatting of time and date quantities in locale.
 */
typedef struct {

    _LC_core_time_t core;

    char *d_fmt;
    char *t_fmt;
    char *d_t_fmt;
    char *t_fmt_ampm;
    char *abday[7];
    char *day[7];
    char *abmon[12];
    char *mon[12];
    char *am_pm[2];
    char *era;
    char *era_year;
    char *era_d_fmt;
    char *alt_digits;
    char *era_d_t_fmt;
    char *era_t_fmt;
    char *datesep;
    char *timesep;

    struct __LC_locale *loc_rec; /* back pointer to containing locale */
    void    *__meth_ptr;
    void    *__data_ptr;

} _LC_time_t;

typedef struct _LC_time_objhdl _LC_time_objhdl_t;
struct _LC_time_objhdl {
        _LC_time_t *obj;
#       ifndef _PTR_METH
                void *(** meth)();
#       endif
        struct _LC_locale_objhdl *loc_hdl;      /* parent locale */
};


/* _LC_weight_t
**
** Array of collation weights for a character or collating symbol.
*/
typedef union {
    unsigned                   /* This type is used if the number of  */
        short  n[2];           /* collation orders is <= 2            */

    unsigned                   /* This type is used if the number of  */
        short  *p;             /* collation orders is > 2             */

} _LC_weight_t;


/* _LC_collel_t
**
** Collation data for a collation symbol
*/
typedef struct {

    char         *ce_sym;       /* value of collation symbol           */
    _LC_weight_t ce_wgt;        /* The weights associated with a       */
                                /* collating symbol matching ce_sym    */

} _LC_collel_t;


/* _LC_coltbl_t
**
** Array of per-character collation data for locale.
*/
typedef struct {
    _LC_weight_t   ct_wgt;    /* The collation weights for this      */
                              /* character.                          */

    _LC_collel_t   *ct_collel;/* Pointer to collation symbol array   */

} _LC_coltbl_t;


/* _LC_subs_t
**
** Substring source and target pair
*/
typedef struct {

    _LC_weight_t ss_act;             /* indicates for which orders this */
                                     /* substitution string is active. */
    char *ss_src;                    /* source string to match */
    char *ss_tgt;                    /* target string to replace */

} _LC_subs_t;


/* _LC_collate_t
 *
 * COLLATE class defines the collation rules for a locale.
 */
typedef struct {

    _LC_core_collate_t core;

    unsigned                                /* number of collation orders */
        char    co_nord;                    /* supported in this locale */

    _LC_weight_t co_sort;                   /* sort order     */
                                            /* processing flags    */

    wchar_t     co_wc_min;                  /* min process code    */
    wchar_t     co_wc_max;                  /* max process code    */

    wchar_t     co_col_min;                 /* min coll weight     */
    wchar_t     co_col_max;                 /* max coll weight     */

    _LC_coltbl_t *co_coltbl;                /* array of collation  */
                                            /* weights, symbols    */
                                            /* indexed by processing chars */
    unsigned
        char    co_nsubs;                   /* number of sub strs  */
    _LC_subs_t  *co_subs;                   /* substitution strs   */

    struct __LC_locale *loc_rec; /* back pointer to containing locale */
    void    *__meth_ptr;
    void    *__data_ptr;

} _LC_collate_t;

typedef struct _LC_collate_objhdl _LC_collate_objhdl_t;
struct _LC_collate_objhdl {
        _LC_collate_t *obj;
#       ifndef _PTR_METH
                void *(**   meth)();
#       endif
        struct _LC_locale_objhdl *loc_hdl;      /* parent locale */
};

/*
 * MASKS for the co_sort[] sort modifier array
 */
#define _COLL_FORWARD_MASK   1
#define _COLL_BACKWARD_MASK  2
#define _COLL_NOSUBS_MASK    4
#define _COLL_POSITION_MASK  8

/*
 * MASKS for the ss_act[] flags
 */
#define _SUBS_ACTIVE         1
#define _SUBS_REGEXP         2


/* _LC_classnm_t
 *
 * Element mapping class name to a bit-unique mask.
 */
typedef struct {

    char    *name;
    unsigned int mask;

} _LC_classnm_t;


/* _LC_ctype_t
 *
 * Structure representing CTYPE class which defines character
 * membership in a character class.
 */
typedef struct {

    _LC_core_ctype_t core;

  /* min and max process code */
    wchar_t      min_wc;
    wchar_t      max_wc;

  /* upper, lower translation */
    wchar_t      *upper;
    wchar_t      *lower;

  /* character class membership */
    unsigned int    *mask;      /* Array of masks for CPs 0..255 */
    unsigned int    *qmask;     /* Array of masks for CPs 255..+ */
    unsigned char   *qidx;      /* index into qmask for CPs 255..+ */

  /* class name mapping */
    unsigned char   nclasses;
   _LC_classnm_t    *classnms;

    struct __LC_locale *loc_rec;/* back pointer to containing locale */
    void    *__meth_ptr;        /* pointer to method extension table */
                                /* see lc_ext.h for extension methods */
    void    *__data_ptr;

} _LC_ctype_t;

typedef struct _LC_ctype_objhdl _LC_ctype_objhdl_t;
struct _LC_ctype_objhdl {
        _LC_ctype_t *obj;
#       ifndef _PTR_METH
                void *(**   meth)();
#       endif
        struct _LC_locale_objhdl *loc_hdl;      /* parent locale */
};


/* ------------- The Locale ----------- */

/*
 * IF THIS NUMBER CHANGES, IT MUST ALSO BE CHANGED IN
 * include/ulsitem.h
 */
#ifndef _NL_NUM_ITEMS
#define _NL_NUM_ITEMS   66
#endif

/* _LC_locale_t
 *
 * Entry point to locale database.  setlocale() receives a pointer to
 * this structure from __lc_load().
 */

typedef struct __LC_locale {

    _LC_core_locale_t core;

    char              *nl_info[_NL_NUM_ITEMS];
    struct mb_lconv   *nl_lconv;

    _LC_charmap_objhdl_t  lc_charmap;
    _LC_collate_objhdl_t  lc_collate;
    _LC_ctype_objhdl_t    lc_ctype;
    _LC_monetary_objhdl_t lc_monetary;
    _LC_numeric_objhdl_t  lc_numeric;
    _LC_resp_objhdl_t     lc_resp;
    _LC_time_objhdl_t     lc_time;

    struct __LC_locale *loc_rec; /* back pointer to containing locale */
    void   *__meth_ptr;
    void   *__data_ptr;

} _LC_locale_t;

typedef struct _LC_locale_objhdl _LC_locale_objhdl_t;
struct _LC_locale_objhdl {
        _LC_locale_t *obj;
#       ifndef _PTR_METH
                void *(**   meth)();
#       endif
        struct _LC_locale_objhdl *loc_hdl;    /* parent locale */
};

typedef struct {
        _LC_locale_t *obj;
#       ifndef _PTR_METH
                void *(**   meth)();
#       endif
        struct _LC_locale_objhdl *loc_hdl;    /* parent locale */
} __LOCALE_OBJECT;

/* _LC_object_handle_t
 *
 * Generic object reference.  The ptr field refers to the data for the object
 * and the context field points to the functions which implement the
 * methods for the object.
 */
typedef struct _LC_object_handle _LC_object_handle_t;
struct _LC_object_handle {
    union {
        _LC_object_t          lc_object;
        _LC_locale_objhdl_t   lc_locale;
        _LC_charmap_objhdl_t  lc_charmap;
        _LC_collate_objhdl_t  lc_collate;
        _LC_ctype_objhdl_t    lc_ctype;
        _LC_monetary_objhdl_t lc_monetary;
        _LC_numeric_objhdl_t  lc_numeric;
        _LC_resp_objhdl_t     lc_resp;
        _LC_time_objhdl_t     lc_time;
    } obj;

#   ifndef _PTR_METH
        void    *(**   meth)();
#   endif
};


typedef struct {
    _LC_object_t        hdr;              /* header for load object */
    _LC_locale_objhdl_t handle;           /* handle for object  */
} _LC_load_object_t;


#ifdef __cplusplus
   }
#endif

#endif
