/*
 * COMPONENT_NAME: wp.ulspc
 *
 * FUNCTIONS: ULS return codes
 *
 * (C) COPYRIGHT International Business Machines Corp. 1995
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */
#ifndef _ULS_ERRNO
#define _ULS_ERRNO

#ifdef __cplusplus
   extern "C" {
#endif

#define ULS_API_ERROR_BASE                      0x00020400
#define ULS_UCONVDEF_ERROR_BASE                 (ULS_API_ERROR_BASE | 0x63)
#define ULS_LOCDEF_ERROR_BASE                   (ULS_API_ERROR_BASE | 0x97)
#define ULS_MAKEKB_ERROR_BASE                   (ULS_API_ERROR_BASE | 0x105)
#define ULS_API_ERROR(x)                        (ULS_API_ERROR_BASE | (x))
#define ULS_UCONVDEF_ERROR(x)                   (ULS_UCONVDEF_ERROR_BASE | (x))
#define ULS_LOCDEF_ERROR(x)                     (ULS_LOCDEF_ERROR_BASE | (x))
#define ULS_MAKEKB_ERROR(x)                     (ULS_MAKEKB_ERROR_BASE | (x))

typedef enum _uls_return_codes {
     ULS_SUCCESS           =  0x00000000,
     ULS_OTHER             =  ULS_API_ERROR(1),
     ULS_ILLEGALSEQUENCE   =  ULS_API_ERROR(2),
     ULS_MAXFILESPERPROC   =  ULS_API_ERROR(3),
     ULS_MAXFILES          =  ULS_API_ERROR(4),
     ULS_NOOP              =  ULS_API_ERROR(5),
     ULS_TOOMANYKBD        =  ULS_API_ERROR(6),
     ULS_KBDNOTFOUND       =  ULS_API_ERROR(7),
     ULS_BADHANDLE         =  ULS_API_ERROR(8),
     ULS_NODEAD            =  ULS_API_ERROR(9),
     ULS_NOSCAN            =  ULS_API_ERROR(10),
     ULS_INVALIDSCAN       =  ULS_API_ERROR(11),
     ULS_NOTIMPLEMENTED    =  ULS_API_ERROR(12),
     ULS_NOMEMORY          =  ULS_API_ERROR(13),
     ULS_INVALID           =  ULS_API_ERROR(14),
     ULS_BADOBJECT         =  ULS_API_ERROR(15),
     ULS_NOTOKEN           =  ULS_API_ERROR(16),
     ULS_NOMATCH           =  ULS_API_ERROR(17),
     ULS_BUFFERFULL        =  ULS_API_ERROR(18),
     ULS_RANGE             =  ULS_API_ERROR(19),
     ULS_UNSUPPORTED       =  ULS_API_ERROR(20),
     ULS_BADATTR           =  ULS_API_ERROR(21),
     ULS_VERSION           =  ULS_API_ERROR(22),
     ULS_UCONVDEF102       =  ULS_UCONVDEF_ERROR(102),
     ULS_UCONVDEF103       =  ULS_UCONVDEF_ERROR(103),
     ULS_UCONVDEF104       =  ULS_UCONVDEF_ERROR(104),
     ULS_UCONVDEF105       =  ULS_UCONVDEF_ERROR(105),
     ULS_UCONVDEF106       =  ULS_UCONVDEF_ERROR(106),
     ULS_UCONVDEF107       =  ULS_UCONVDEF_ERROR(107),
     ULS_UCONVDEF108       =  ULS_UCONVDEF_ERROR(108),
     ULS_UCONVDEF109       =  ULS_UCONVDEF_ERROR(109),
     ULS_UCONVDEF110       =  ULS_UCONVDEF_ERROR(110),
     ULS_UCONVDEF111       =  ULS_UCONVDEF_ERROR(111),
     ULS_UCONVDEF112       =  ULS_UCONVDEF_ERROR(112),
     ULS_UCONVDEF113       =  ULS_UCONVDEF_ERROR(113),
     ULS_UCONVDEF114       =  ULS_UCONVDEF_ERROR(114),
     ULS_UCONVDEF115       =  ULS_UCONVDEF_ERROR(115),
     ULS_UCONVDEF116       =  ULS_UCONVDEF_ERROR(116),
     ULS_UCONVDEF117       =  ULS_UCONVDEF_ERROR(117),
     ULS_UCONVDEF118       =  ULS_UCONVDEF_ERROR(118),
     ULS_UCONVDEF119       =  ULS_UCONVDEF_ERROR(119),
     ULS_UCONVDEF120       =  ULS_UCONVDEF_ERROR(120),
     ULS_UCONVDEF121       =  ULS_UCONVDEF_ERROR(121),
     ULS_UCONVDEF122       =  ULS_UCONVDEF_ERROR(122),
     ULS_UCONVDEF123       =  ULS_UCONVDEF_ERROR(123),
     ULS_UCONVDEF124       =  ULS_UCONVDEF_ERROR(124),
     ULS_UCONVDEF125       =  ULS_UCONVDEF_ERROR(125),
     ULS_UCONVDEF126       =  ULS_UCONVDEF_ERROR(126),
     ULS_UCONVDEF127       =  ULS_UCONVDEF_ERROR(127),
     ULS_UCONVDEF128       =  ULS_UCONVDEF_ERROR(128),
     ULS_UCONVDEF129       =  ULS_UCONVDEF_ERROR(129),
     ULS_UCONVDEF130       =  ULS_UCONVDEF_ERROR(130),
     ULS_UCONVDEF131       =  ULS_UCONVDEF_ERROR(131),
     ULS_UCONVDEF132       =  ULS_UCONVDEF_ERROR(132),
     ULS_UCONVDEF133       =  ULS_UCONVDEF_ERROR(133),
     ULS_UCONVDEF134       =  ULS_UCONVDEF_ERROR(134),
     ULS_UCONVDEF135       =  ULS_UCONVDEF_ERROR(135),
     ULS_UCONVDEF136       =  ULS_UCONVDEF_ERROR(136),
     ULS_UCONVDEF137       =  ULS_UCONVDEF_ERROR(137),
     ULS_UCONVDEF138       =  ULS_UCONVDEF_ERROR(138),
     ULS_UCONVDEF139       =  ULS_UCONVDEF_ERROR(139),
     ULS_UCONVDEF140       =  ULS_UCONVDEF_ERROR(140),
     ULS_UCONVDEF141       =  ULS_UCONVDEF_ERROR(141),
     ULS_UCONVDEF142       =  ULS_UCONVDEF_ERROR(142),
     ULS_UCONVDEF143       =  ULS_UCONVDEF_ERROR(143),
     ULS_UCONVDEF144       =  ULS_UCONVDEF_ERROR(144),
     ULS_UCONVDEF145       =  ULS_UCONVDEF_ERROR(145),
     ULS_UCONVDEF146       =  ULS_UCONVDEF_ERROR(146),
     ULS_UCONVDEF147       =  ULS_UCONVDEF_ERROR(147),
     ULS_UCONVDEF148       =  ULS_UCONVDEF_ERROR(148),
     ULS_UCONVDEF149       =  ULS_UCONVDEF_ERROR(149),
     ULS_UCONVDEF150       =  ULS_LOCDEF_ERROR(150),
     ULS_LOCDEF151         =  ULS_LOCDEF_ERROR(151),
     ULS_LOCDEF152         =  ULS_LOCDEF_ERROR(152),
     ULS_LOCDEF153         =  ULS_LOCDEF_ERROR(153),
     ULS_LOCDEF154         =  ULS_LOCDEF_ERROR(154),
     ULS_LOCDEF155         =  ULS_LOCDEF_ERROR(155),
     ULS_LOCDEF156         =  ULS_LOCDEF_ERROR(156),
     ULS_LOCDEF157         =  ULS_LOCDEF_ERROR(157),
     ULS_LOCDEF158         =  ULS_LOCDEF_ERROR(158),
     ULS_LOCDEF159         =  ULS_LOCDEF_ERROR(159),
     ULS_LOCDEF160         =  ULS_LOCDEF_ERROR(160),
     ULS_LOCDEF161         =  ULS_LOCDEF_ERROR(161),
     ULS_LOCDEF162         =  ULS_LOCDEF_ERROR(162),
     ULS_LOCDEF163         =  ULS_LOCDEF_ERROR(163),
     ULS_LOCDEF164         =  ULS_LOCDEF_ERROR(164),
     ULS_LOCDEF165         =  ULS_LOCDEF_ERROR(165),
     ULS_LOCDEF166         =  ULS_LOCDEF_ERROR(166),
     ULS_LOCDEF167         =  ULS_LOCDEF_ERROR(167),
     ULS_LOCDEF168         =  ULS_LOCDEF_ERROR(168),
     ULS_LOCDEF169         =  ULS_LOCDEF_ERROR(169),
     ULS_LOCDEF170         =  ULS_LOCDEF_ERROR(170),
     ULS_LOCDEF171         =  ULS_LOCDEF_ERROR(171),
     ULS_LOCDEF172         =  ULS_LOCDEF_ERROR(172),
     ULS_LOCDEF173         =  ULS_LOCDEF_ERROR(173),
     ULS_LOCDEF174         =  ULS_LOCDEF_ERROR(174),
     ULS_LOCDEF175         =  ULS_LOCDEF_ERROR(175),
     ULS_LOCDEF176         =  ULS_LOCDEF_ERROR(176),
     ULS_LOCDEF177         =  ULS_LOCDEF_ERROR(177),
     ULS_LOCDEF178         =  ULS_LOCDEF_ERROR(178),
     ULS_LOCDEF179         =  ULS_LOCDEF_ERROR(179),
     ULS_LOCDEF180         =  ULS_LOCDEF_ERROR(180),
     ULS_LOCDEF181         =  ULS_LOCDEF_ERROR(181),
     ULS_LOCDEF182         =  ULS_LOCDEF_ERROR(182),
     ULS_LOCDEF183         =  ULS_LOCDEF_ERROR(183),
     ULS_LOCDEF184         =  ULS_LOCDEF_ERROR(184),
     ULS_LOCDEF185         =  ULS_LOCDEF_ERROR(185),
     ULS_LOCDEF186         =  ULS_LOCDEF_ERROR(186),
     ULS_LOCDEF187         =  ULS_LOCDEF_ERROR(187),
     ULS_LOCDEF188         =  ULS_LOCDEF_ERROR(188),
     ULS_LOCDEF189         =  ULS_LOCDEF_ERROR(189),
     ULS_LOCDEF190         =  ULS_LOCDEF_ERROR(190),
     ULS_LOCDEF191         =  ULS_LOCDEF_ERROR(191),
     ULS_LOCDEF192         =  ULS_LOCDEF_ERROR(192),
     ULS_LOCDEF193         =  ULS_LOCDEF_ERROR(193),
     ULS_LOCDEF194         =  ULS_LOCDEF_ERROR(194),
     ULS_LOCDEF195         =  ULS_LOCDEF_ERROR(195),
     ULS_LOCDEF196         =  ULS_LOCDEF_ERROR(196),
     ULS_LOCDEF197         =  ULS_LOCDEF_ERROR(197),
     ULS_LOCDEF198         =  ULS_LOCDEF_ERROR(198),
     ULS_LOCDEF199         =  ULS_LOCDEF_ERROR(199),
     ULS_LOCDEF200         =  ULS_LOCDEF_ERROR(200),
     ULS_LOCDEF201         =  ULS_LOCDEF_ERROR(201),
     ULS_LOCDEF202         =  ULS_LOCDEF_ERROR(202),
     ULS_LOCDEF203         =  ULS_LOCDEF_ERROR(203),
     ULS_LOCDEF204         =  ULS_LOCDEF_ERROR(204),
     ULS_LOCDEF205         =  ULS_LOCDEF_ERROR(205),
     ULS_LOCDEF206         =  ULS_LOCDEF_ERROR(206),
     ULS_LOCDEF207         =  ULS_LOCDEF_ERROR(207),
     ULS_LOCDEF208         =  ULS_LOCDEF_ERROR(208),
     ULS_LOCDEF209         =  ULS_LOCDEF_ERROR(209),
     ULS_LOCDEF210         =  ULS_LOCDEF_ERROR(210),
     ULS_LOCDEF211         =  ULS_LOCDEF_ERROR(211),
     ULS_LOCDEF212         =  ULS_LOCDEF_ERROR(212),
     ULS_LOCDEF213         =  ULS_LOCDEF_ERROR(213),
     ULS_LOCDEF214         =  ULS_LOCDEF_ERROR(214),
     ULS_LOCDEF215         =  ULS_LOCDEF_ERROR(215),
     ULS_LOCDEF216         =  ULS_LOCDEF_ERROR(216),
     ULS_LOCDEF217         =  ULS_LOCDEF_ERROR(217),
     ULS_LOCDEF218         =  ULS_LOCDEF_ERROR(218),
     ULS_LOCDEF219         =  ULS_LOCDEF_ERROR(219),
     ULS_LOCDEF220         =  ULS_LOCDEF_ERROR(220),
     ULS_LOCDEF221         =  ULS_LOCDEF_ERROR(221),
     ULS_LOCDEF222         =  ULS_LOCDEF_ERROR(222),
     ULS_LOCDEF223         =  ULS_LOCDEF_ERROR(223),
     ULS_LOCDEF224         =  ULS_LOCDEF_ERROR(224),
     ULS_LOCDEF225         =  ULS_LOCDEF_ERROR(225),
     ULS_LOCDEF226         =  ULS_LOCDEF_ERROR(226),
     ULS_LOCDEF227         =  ULS_LOCDEF_ERROR(227),
     ULS_LOCDEF228         =  ULS_LOCDEF_ERROR(228),
     ULS_LOCDEF229         =  ULS_LOCDEF_ERROR(229),
     ULS_LOCDEF230         =  ULS_LOCDEF_ERROR(230),
     ULS_LOCDEF231         =  ULS_LOCDEF_ERROR(231),
     ULS_LOCDEF232         =  ULS_LOCDEF_ERROR(232),
     ULS_LOCDEF233         =  ULS_LOCDEF_ERROR(233),
     ULS_LOCDEF234         =  ULS_LOCDEF_ERROR(234),
     ULS_LOCDEF235         =  ULS_LOCDEF_ERROR(235),
     ULS_LOCDEF236         =  ULS_LOCDEF_ERROR(236),
     ULS_LOCDEF237         =  ULS_LOCDEF_ERROR(237),
     ULS_LOCDEF238         =  ULS_LOCDEF_ERROR(238),
     ULS_LOCDEF239         =  ULS_LOCDEF_ERROR(239),
     ULS_LOCDEF240         =  ULS_LOCDEF_ERROR(240),
     ULS_LOCDEF241         =  ULS_LOCDEF_ERROR(241),
     ULS_LOCDEF242         =  ULS_LOCDEF_ERROR(242),
     ULS_LOCDEF243         =  ULS_LOCDEF_ERROR(243),
     ULS_LOCDEF244         =  ULS_LOCDEF_ERROR(244),
     ULS_LOCDEF245         =  ULS_LOCDEF_ERROR(245),
     ULS_LOCDEF246         =  ULS_LOCDEF_ERROR(246),
     ULS_LOCDEF247         =  ULS_LOCDEF_ERROR(247),
     ULS_LOCDEF248         =  ULS_LOCDEF_ERROR(248),
     ULS_LOCDEF249         =  ULS_LOCDEF_ERROR(249),
     ULS_LOCDEF250         =  ULS_LOCDEF_ERROR(250),
     ULS_LOCDEF251         =  ULS_LOCDEF_ERROR(251),
     ULS_LOCDEF252         =  ULS_LOCDEF_ERROR(252),
     ULS_LOCDEF253         =  ULS_LOCDEF_ERROR(253),
     ULS_LOCDEF254         =  ULS_LOCDEF_ERROR(254),
     ULS_LOCDEF255         =  ULS_LOCDEF_ERROR(255),
     ULS_LOCDEF256         =  ULS_LOCDEF_ERROR(256),
     ULS_LOCDEF257         =  ULS_LOCDEF_ERROR(257),
     ULS_LOCDEF258         =  ULS_LOCDEF_ERROR(258),
     ULS_LOCDEF259         =  ULS_LOCDEF_ERROR(259),
     ULS_LOCDEF260         =  ULS_LOCDEF_ERROR(260),
     ULS_MAKEKB261         =  ULS_MAKEKB_ERROR(261),
     ULS_MAKEKB262         =  ULS_MAKEKB_ERROR(262),
     ULS_MAKEKB263         =  ULS_MAKEKB_ERROR(263),
     ULS_MAKEKB264         =  ULS_MAKEKB_ERROR(264),
     ULS_MAKEKB265         =  ULS_MAKEKB_ERROR(265),
     ULS_MAKEKB266         =  ULS_MAKEKB_ERROR(266),
     ULS_MAKEKB267         =  ULS_MAKEKB_ERROR(267),
     ULS_MAKEKB268         =  ULS_MAKEKB_ERROR(268),
     ULS_MAKEKB269         =  ULS_MAKEKB_ERROR(269),
     ULS_MAKEKB270         =  ULS_MAKEKB_ERROR(270),
     ULS_MAKEKB271         =  ULS_MAKEKB_ERROR(271),
     ULS_MAKEKB272         =  ULS_MAKEKB_ERROR(272),
     ULS_MAKEKB273         =  ULS_MAKEKB_ERROR(273),
     ULS_MAKEKB274         =  ULS_MAKEKB_ERROR(274),
     ULS_MAKEKB275         =  ULS_MAKEKB_ERROR(275),
     ULS_MAKEKB276         =  ULS_MAKEKB_ERROR(276),
     ULS_MAKEKB277         =  ULS_MAKEKB_ERROR(277),
     ULS_MAKEKB278         =  ULS_MAKEKB_ERROR(278),
     ULS_MAKEKB279         =  ULS_MAKEKB_ERROR(279),
     ULS_MAKEKB280         =  ULS_MAKEKB_ERROR(280),
     ULS_MAKEKB281         =  ULS_MAKEKB_ERROR(281),
     ULS_MAKEKB282         =  ULS_MAKEKB_ERROR(282),
     ULS_MAKEKB283         =  ULS_MAKEKB_ERROR(283),
     ULS_MAKEKB284         =  ULS_MAKEKB_ERROR(284),
     ULS_MAKEKB285         =  ULS_MAKEKB_ERROR(285),
     ULS_MAKEKB286         =  ULS_MAKEKB_ERROR(286),
     ULS_MAKEKB287         =  ULS_MAKEKB_ERROR(287),
     ULS_MAKEKB288         =  ULS_MAKEKB_ERROR(288),
     ULS_MAKEKB289         =  ULS_MAKEKB_ERROR(289),
     ULS_MAKEKB290         =  ULS_MAKEKB_ERROR(290),
     ULS_MAKEKB291         =  ULS_MAKEKB_ERROR(291),
     ULS_MAKEKB292         =  ULS_MAKEKB_ERROR(292),
     ULS_MAKEKB293         =  ULS_MAKEKB_ERROR(293),
     ULS_MAKEKB294         =  ULS_MAKEKB_ERROR(294),
     ULS_MAKEKB295         =  ULS_MAKEKB_ERROR(295),
     ULS_MAKEKB296         =  ULS_MAKEKB_ERROR(296),
     ULS_MAKEKB297         =  ULS_MAKEKB_ERROR(297),
     ULS_MAKEKB298         =  ULS_MAKEKB_ERROR(298),
     ULS_MAKEKB299         =  ULS_MAKEKB_ERROR(299),
     ULS_MAKEKB300         =  ULS_MAKEKB_ERROR(300)
} uls_error_t;

#include <errcmpat.h>         /* compatibility with old ULS return codes */

#ifdef __cplusplus
   }
#endif

#endif            /* _ULS_ERRNO */
