/*
 * COMPONENT_NAME:
 *
 * FUNCTIONS: limits for uls code - public
 *
 * ORIGINS: 27
 *
 * (C) COPYRIGHT International Business Machines Corp. 1989, 1992
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */

#ifndef _ULS_LIMIT
#define _ULS_LIMIT

#ifdef __cplusplus
   extern "C" {
#endif

#include <limits.h>

/* limits on a system conforming to the POSIX standard */

#define _POSIX_PATH_MAX      255
#define _POSIX_NAME_MAX      14

/* The the system supports the following symbolic utility limits */

#define COLL_WEIGHTS_MAX     255
#define RE_DUP_MAX           255

/* max number of bytes in N-to-1 mapping characters */
#define NL_NMAX      10

/* number of bits in a byte */
#define NBBY         8

#undef  MB_LEN_MAX
#define MB_LEN_MAX   3

#define MB_MAX_LEN   4

#ifndef MB_CUR_MAX
#define MB_CUR_MAX   2           /* defined also in stdlib.h so */
#endif                           /* include stdlib.h first */

#ifdef __cplusplus
   }
#endif

#endif
