#---------------------------------------------------------------------------
#
#   Copyright 1991 IBM Corporation
#
#===================================================================

#===================================================================
#This include file is included by the various sample makefiles.
#Define the macros depending on the target specified.
#
# The only valid targets are the following :-
#
#       386 :-  Specifies OS/2 on Intel and uses the corresponding tools
#
#       ppc :-  Targets WPOS/2 for PPC ( OS/2 server on microkernel on PPC)
#
#===================================================================

#===================================================================
# First we handle the case where the TARGET_PROC might be defined in a
# mixed case fashion. We convert any case to the PPC so that we can deal
# with just one case (PPC)
#===================================================================

TARGET_PROC = $(TARGET_PROC:c=C)
TARGET_PROC = $(TARGET_PROC:p=P)

#!error $(TARGET_PROC) is at the front
#===================================================================
# First define the macros for 386
#===================================================================

!if "$(TARGET_PROC)"=="386"

.SUFFIXES:
.SUFFIXES: .rc .res .obj .lst .c .asm .hlp .itl .ipf

CFLAGS          =       /c /Gd- /Se /Re /ss /Ms /Gm+

CC              =      icc $(CFLAGS)

AS              =      ml /c /Zm

AFLAGS          =       /Mx -t -z

LFLAGS          =      /NOE /NOD /ALIGN:16 /EXEPACK /M /BASE:0x10000

LINK            =       link386 $(LFLAGS)

RC              =       rc

SOMCOMPILER     =       sc

MSGBIND         =       msgbind

MAPSYM          =       mapsym

OS2LIB          =       os2386.lib

IMPLIB          =       implib

IPF             =       ipfc

LIBS    = DDE4MBS + OS2386

STLIBS  = DDE4SBS + OS2386

MTLIBS  = DDE4MBS + os2386

DLLLIBS = DDE4NBS + os2386

VLIBS   = DDE4SBS + vdh + os2386

.c.lst:
    $(CC) -Fc$*.lst -Fo$*.obj $*.c

.c.obj :
        $(CC) -Fo$*.obj $*.c
.itl.hlp :
        cc -P $*.itl
        ipfc $*.i
        del $*.i

.ipf.hlp :
        $(IPF) $*.ipf /W3

.rc.res :
        $(RC) -r $*.rc
#===================================================================
#
#Now define the macros for ppc target, which implies WPOS/2 on PPC.
#===================================================================
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"

.SUFFIXES:
.SUFFIXES: .rc .res .obj .lst .c .asm .hlp .itl .ipf

# the following are the macros for the tools like the compiler, linker
# resource-compiler, SOM compiler, IPF compiler and others.
#

CFLAGS         = /c /Gd- /Se /Re /Ss /Gm+ /Ep /DINCL_PPC /DINCL_32 /Fo$*.obj
DLLCFLAGS      = /c /Gd- /Se /Re /Ss /Gm+ /Ep /DINCL_PPC /DINCL_32 /Fo$*.obj /Ge-
CC             = icc
LFLAGS         = /Gm+ /Ep /Fe
DEFOPTS        =
LINK           = icc
DLLFLAGS       = /Ge-
SOMFLAGS       = libsom.lib
REXXFLAGS      = librexx.lib
MMFLAGS        = libmmpm2.lib
MTLIB          = libcm.lib
STLIB          = libc.lib
STARTUPOBJ     = crt1_le.o
CPPLIB         = cppps31.lib
OS2LIB         = libos2.lib
GLUTLIBS       = libglut.lib opengl.lib
AUXLIBS        = libaux.lib  opengl.lib
DMILIBS        = libdmiap.lib
NOLIBSFLAG     = /Gn
AS             =
RC             = mres
SC             =
MSGBIND        =
IPF            = ipfc
MAPSYM         = mapsym

.c.obj:
        $(CC) $(CFLAGS) $(DBG_CFLAGS) $<

.cpp.obj:
        $(CC) $(CFLAGS) $(DBG_CFLAGS) $<

.ipf.hlp :
        $(IPF) $*.ipf /W3

!else
!error "Please set TARGET_PROC to either "386" or "PPC". Current value is $(TARGET_PROC)

!endif
!endif
