#==============================================================================
#
#  ADMCT Sample Makefile
#
#  Copyright (C) 1995 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#==============================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

include ..\..\ibmsamp.inc

HEADERS = admcdat.h admcfunc.h admcres.h audiomcd.h checkmem.h hhpheap.h \
          mcd.h mcipriv.h

!if "$(TARGET_PROC)"=="386"
CFLAGS= /C /Ge- /Gm+ /Gs- /Kb- /Ki- /Ms /Sm /Ss+ /O+ /DINCL_32
!else
!if "$(TARGET_PROC)"=="PPC"
OTHER_FLAGS = -DINCL_32 -DCONNECTION -DNEWCALC -DTOOLKIT -DINCL_OS2MM
DLLCFLAGS=$(CFLAGS) $(OTHER_FLAGS)
!endif
!endif
#===================================================================
#
#   A list of all of the object files
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
OBJS = admcdat.obj admcinit.obj admcstat.obj admcrest.obj admcload.obj \
       admcrecd.obj admcplay.obj audiosub.obj audiomcd.obj hhpheap.obj \
       checkmem.obj loadsubs.obj admcset.obj admcconn.obj admccue.obj \
       admcsave.obj admccap.obj strmsubs.obj admcopen.obj admcedit.obj \
       admcpst.obj admccopy.obj admcseek.obj admcclos.obj admcini.obj \
       admcini2.obj connect.obj spicalls.obj seekcalc.obj
!else
!if "$(TARGET_PROC)"=="PPC"
OBJS = admcdat.obj admcinit.obj admcstat.obj admcrest.obj admcload.obj \
       admcrecd.obj admcplay.obj audiosub.obj audiomcd.obj hhpheap.obj \
       checkmem.obj loadsubs.obj admcset.obj admcconn.obj admccue.obj \
       admcsave.obj admccap.obj strmsubs.obj admcopen.obj admcedit.obj \
       admcpst.obj admccopy.obj admcseek.obj admcclos.obj admcini.obj \
       admcini2.obj connect.obj spicalls.obj seekcalc.obj audrcout.obj
!endif
!endif

#===================================================================
#
#   Dependencies
#
#===================================================================

all: audiomct.dll

!if "$(TARGET_PROC)"=="386"
audiomct.res: audiomcd.rc prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC"
audrcout.obj: audiomcd.rc prodinfo.bmp
        $(RC) -As,audiomcd.rc -- $@
        del prodinfo.bmp
!endif
!endif

prodinfo.bmp :
                copy ..\..\prodinfo.bmp prodinfo.bmp

admcdat.obj:    admcdat.c   $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
admcinit.obj:   admcinit.c  $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
admcstat.obj:   admcstat.c  $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
admcrest.obj:   admcrest.c  $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
admcload.obj:   admcload.c  $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
admcrecd.obj:   admcrecd.c  $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
admcplay.obj:   admcplay.c  $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
audiosub.obj:   audiosub.c  $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
audiomcd.obj:   audiomcd.c  $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
hhpheap.obj:    hhpheap.c   $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
checkmem.obj:   checkmem.c  $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
loadsubs.obj:   loadsubs.c  $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
admcset.obj:    admcset.c   $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
admcconn.obj:   admcconn.c  $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
admccue.obj:    admccue.c   $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
admcsave.obj:   admcsave.c  $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
admccap.obj:    admccap.c   $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
strmsubs.obj:   strmsubs.c  $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
admcopen.obj:   admcopen.c  $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
admcedit.obj:   admcedit.c  $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
admcpst.obj:    admcpst.c   $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
admccopy.obj:   admccopy.c  $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
admcseek.obj:   admcseek.c  $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
admcclos.obj:   admcclos.c  $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
admcini.obj:    admcini.c   $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
admcini2.obj:   admcini2.c  $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
connect.obj:    connect.c   $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
spicalls.obj:   spicalls.c  $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
seekcalc.obj:   seekcalc.c  $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

!if "$(TARGET_PROC)"=="386"
audiomct.dll: $(OBJS) audiomct.def audiomct.res
    $(LINK) @<<audiomct.lnk
$(OBJS: =+^
)
$@
$(@B).map
$(MTLIBS) + mmpm2
audiomct.def
<<keep
    rc -p -x audiomct.res audiomct.dll
!else
!if "$(TARGET_PROC)"=="PPC"
audiomct.dll : $(OBJS) audiomct.def
        $(LINK) $(NOLIBSFLAG) $(DLLFLAGS) $(LFLAGS) $@ $(DEFOPTS)audiomct.def $(STARTUPOBJ) $(OBJS) $(MMFLAGS) $(MTLIB) $(CPPLIB) $(OS2LIB)
!endif
!endif

audiomct.def: admct.mak
        @echo Creating file @<<$(@B).def
LIBRARY AUDIOMCT INITINSTANCE
DATA MULTIPLE NONSHARED
SEGMENTS
SHR_SEG       CLASS 'FAR_DATA' SHARED
SHR_SEG_CONST CLASS 'FAR_DATA' SHARED
SHR_SEG_BSS   CLASS 'FAR_DATA' SHARED

BASE = 0x1B2A0000
EXPORTS   mciDriverEntry
<<keep

audiomct.lnk: admct.mak
        @echo Creating file <<$(@B).lnk
$(OBJS)
audiomct.dll
audiomct.map $(LFLAGS)
$(LIBS)
audiomct.def;
<<keep

clean :
        if exist *.exe del *.exe
        if exist *.obj del *.obj
        if exist *.dll del *.dll
