/********************* START OF SPECIFICATIONS *********************
*
* SOURCE FILE NAME:  ADSH.H
*
* DESCRIPTIVE NAME:  Audio Stream Handler common definitions
*
* COPYRIGHT:               IBM Confidential
*              Copyright (c) IBM Corporation  1993
*                        All Rights Reserved
*
* STATUS: OS/2 Release 2.0
*
* FUNCTION: This file contains public definitions specific to the audio
*           stream handler.
*
* NOTES:
*
*    DEPENDENCIES: NONE
*    RESTRICTIONS: NONE
*
* MODIFICATION HISTORY:
* DATE      DEVELOPER         CHANGE DESCRIPTION
* 04/14/93  Ann M. Robinson   Initial version
*********************** END OF SPECIFICATIONS **********************/
#ifndef ADSH_H
#define ADSH_H
/* XLATOFF */
#pragma pack(4)
/* XLATON */

/*------------------------- MESSAGES --------------------------------------
- The SpiSendMsg API is used to send messages to stream instances.
- Each of these messages has a HID and HSTREAM to route the message to the
- correct stream handler.  Message is routed to the stream manager sent
- in the following format:
-
-       SpiSendMsg (hstream, hid, ulMesagetype, pMsg)
-
- The ulMessage type is one of the ADSH_xxx #defines below and the pMsg
- message pointer points to the corresponding data structure accompanying
- the message.
-
- The message must contain a message length indicator as its first element
- so that the stream handler can validate it.
-
-------------------------------------------------------------------------*/
/******************************************************/
#define ADSH_MSG_GET_SUMMARY              1L

   typedef struct _PARM_ADSH_SUMMARY { /* adgetsum */

      ULONG       ulLength;           /* Input - length of structure     */
      ULONG       ulFrameCount;       /* Output - number of frames       */
                                      /*    handled for this stream      */
      ULONG       ulOverrunCount;     /* Output - number of overruns     */
                                      /*    lost frame because no buffer */
      ULONG       ulUnderrunCount;    /* Output - number of underruns    */
                                      /*    missed device interrupts     */

   } PARM_ADSH_SUMMARY;

typedef PARM_ADSH_SUMMARY  FAR *PPARM_ADSH_SUMMARY;

/******************************************************/
#define NUM_ADSH_MESSAGES                 1L



#define EVENT_SHC_REPORT_INT            0x80000000L
#define EVENT_SHC_REPORT_EVENT          0x40000000L

typedef LONG (APIENTRY MIXERENTRY) ( PPARM_SNDMSG pParm_SndMsg );

typedef MIXERENTRY *PMIXERENTRY;

/*********************************************************************/
/* parameter structure for the MCI_MIXSETUP_PARMS message            */
/*********************************************************************/
typedef struct _ADSH_ADDDRESS_PARMS {
  ULONG        ulStructLen;       /* IN--Structure  length                    */
  ULONG        ulAddressType;     /* Address type the stream handler is using */
  PMIXERENTRY   mixerEvent;        /* Event routine for SH to call             */
} ADSH_ADDDRESS_PARMS;

typedef ADSH_ADDDRESS_PARMS  *PADSH_ADDDRESS_PARMS;

#define DDCMD_HOOK 0x000FL  /* SpiSendMessage for DDCMD hooks */


/* XLATOFF */
#pragma pack()
/* XLATON */

#endif
