/****************************************************************************/
/*                                                                          */
/* Module Name: CONCB.H                                                     */
/*                                                                          */
/* OS/2 Multimedia Extensions Connection Control Block Definitions file     */
/*                                                                          */
/* Copyright (c) International Business Machines Corporation 1994           */
/*                        All Rights Reserved                               */
/*                                                                          */
/****************************************************************************/
/* NOINC */
#ifdef __cplusplus
   extern "C" {
#endif
/* INC */



/* XLATOFF */
#pragma pack(4)
/* XLATON */


/**********************************************
 *
 * CONCB - Connection Control Block
 *
 *       This data structure represents either
 *       the target or source connector information.
 *       Used to make a connection.
 *
 **********************************************/
 typedef struct  _CONCB { /* concb */
    ULONG        ulStructLength;
    HID          hid;
    SPCBKEY      spcbkey;
    ULONG        ulFlags;
    HSTREAM      hstreamAssoc;  /* Probably don't need any more! */
    HSTREAM      hstream;
    PDCB         pdcb;
    PEVCB        pevcb;
    PEVFN        pevfn;
    PVOID        pMediaHeader;
    PVOID        pTrackHeader;
    ULONG        ulConnectorType;
    ULONG        ulConnectorIndex;
    HNETWORK     hnetwork;
    USHORT       usUniqueId;
    USHORT       usReserved0;
    } CONCB;

 typedef CONCB           FAR  *PCONCB;            /* Ptr to a CONCB       */

#pragma pack()
/* XLATON */

/* NOINC */
#ifdef __cplusplus
}
#endif
/* INC */

