//**************************************************************************
//
// Module Name: FILTER.H
//
// Copyright (c) International Business Machines Corporation 1994,
//                        All Rights Reserved
//
// MODIFICATION HISTORY:
// DATE      DEVELOPER         CHANGE DESCRIPTION
// 05/18/94  VLB               Creation
// 11/01/94  SAO               Added more structures, etc.
// 11/03/94  SAO               Added #define for MMIO_FILTER and MMIO_CODEC
// 11/10/94  SAO               Added some function prototypes, etc.
// 11/11/94  SAO               - include os2me.h
//                             - add typedef of PFNFILTER
// 11/22/94  SAO               Updated AUDIO_CONNECTOR_TYPE
// 12/08/94  SAO               Function prototypes, MMIO_MATCHCONNECTORTYPE and
//                             MMIO_MATCHMCIDEVICETYPE, change ulCapFlag in
//                             FILTER_CONNECTION to ulCapsFlags
// 12/09/94  VLB               Add MAX_CONNECTIONS
// 12/09/94  LAD               Changed PFNFILTER prototype
//                             Changed sampleraterange to samplerate
//                             Added PFILTERINIFILEINFO field to FILTER_PARMS
//                             mmioLoadFilter change PFN to PFN *
// 12/09/94  VLB               Add flags for setting source or target
// 12/12/94  SAO               - Remove default fields from AUDIO_CONNECTOR_TYPE
//                             - add ulStateFlag to FILTER_CONNECTION
//                             - remove pNext from FILTER_CONNECTION
//                             - add STATE_DEFAULT_ACTIVE flag
//                             - rename ulStructLengthAudio to ulStructLength in
//                               PCOMMON_CONNECTOR_TYPE
// 12/16/94  SAO               - changed new MMIO_MATCH values
//                             - FilterLoad - PFNFILTER *pfnFilter (ptr to ptr)
// 01/18/95  LAD               new flags for AUDIO_DESCRIPTOR_TYPE
// 01/23/95  SAO               updated function prototypes
// 01/24/95  LAD               Updated MCI_FILTER flags
// 01/29/95  LAD               Added MCIDRV_DEVTYPE_PARMS struct
// 01/30/95  SAO               - updated function prototypes
//                             - removed ulMCIDeviceType from FILTER_CONNECTION
//                             - deleted MMIO_MATCHMCIDEVICETYPE flag
// 02/01/95  LAD               Update FILTER_PARMS to work with string interface
// 02/06/95  LAD               Add new MCI connector types
// 02/07/95  SAO               - removed ulAbsoluteConnectorIndex from FILTER_CONNECTION
//                             - removed ulNumConnectors from FILTER_CONNECTION
// 02/09/95  SAO               - Add MMIOM_FILTER_QUERYBITMAP, MMIOM_FILTER_QUERYBITMAPLENGTH
//                             - Add mmioQueryFilterName, mmioQueryFilterNameLength,
//                               mmioQueryFilterBitmap, mmioQueryFilterBitmapLength
//                               API prototypes
// 02/15/95  LAD               Remove spi define and modify MCIDRV_TEST_CONNECTION flag
// 02/16/95  LAD               Add corresponding #prage pack() to MCI struct.
// 06/13/95  SAO               change ulCompressType and ulCompressSubType
//                               in VIDEO_CONNECTOR_TYPE structure to ULONGs
//**************************************************************************
#ifndef _FILTER_
#define _FILTER_

#ifndef _MMIO_H_
#include <mmioos2.h>
#endif

#ifndef _SSM_H_
#include <os2me.h>
#endif

//  jph additions ------------------------------------------------------------

#define MCI_TEXT_STREAM_CONNECTOR                  0x00000016L
#define MMIO_MEDIATYPE_TEXT                        0x00000200L
#define TEXT_STREAM_CONNECTOR                      0x00000006L
#define WAVE_STREAM_CONNECTOR                      0x00000003L

#define FILTER_SPECIFIC                            0x00000008L
#define MMIOERR_ATTRIBUTE_SET_FAILED               0x0000000aL

typedef struct _MMTTSHEADER {                /* mmaudioheader   */
   ULONG           ulHeaderLength;           /* Length in Bytes */
   ULONG           ulContentType;            /* Image content   */
   ULONG           ulMediaType;              /* Media Type      */
//   MMTTS_HEADER   mmTTSHeader;             /* header          */
   } MMTTSHEADER;

typedef MMTTSHEADER *PMMTTSHEADER;


// jph end ----------------------------------------------------------------

#define _FILTER_
#define MMIOM_FILTER_BASE                0
#define MMIOM_FILTER_OPEN                1
#define MMIOM_FILTER_SET                 2
#define MMIOM_FILTER                     3
#define MMIOM_FILTER_CLOSE               4
#define MMIOM_FILTER_RUN                 5
#define MMIOM_FILTER_FLUSH               6
#define MMIOM_FILTER_QUERYNAME           7
#define MMIOM_FILTER_QUERYNAMELENGTH     8
#define MMIOM_FILTER_RESTORE             9
#define MMIOM_FILTER_SAVE               10
#define MMIOM_FILTER_QUERYBITMAP        11
#define MMIOM_FILTER_QUERYBITMAPLENGTH  12

#define MMIOM_FILTER_USER               MMIOM_FILTER_BASE + 1000

//***************************************************************
// ulFlag parameter for mmioIniFileFilter and mmioLoadFilter APIs
//***************************************************************
#define MMIO_INSTALLFILTER              0x00000001L
#define MMIO_FINDFILTER                 0x00000002L
#define MMIO_REMOVEFILTER               0x00000004L
#define MMIO_MATCHCONNECTORS            0x00020000L
#define MMIO_MATCHMEDIATYPE             0x00040000L
#define MMIO_MATCHCONNECTORTYPE         0x00080000L
// #define MMIO_MATCHMCIDEVICETYPE         0x00100000L
#define MMIO_FILTER                     0x00000100L
#define MMIO_CODEC                      0x00000200L

//***************************************************************
// used by AUDIO_CONNECTOR_TYPE structure
//***************************************************************
#define MAXFORMATTAGS         16
#define MAXCHANNELS            8
#define MAXBITSPERSAMPLE      32
#define MAXSAMPLERATERANGES   32

#define FILTER_SIMPLE_QUERY_SETTINGS       0x00000001
#define FILTER_SIMPLE_QUERY                0x00000002
#define FILTER_SIMPLE_MODIFY               0x00000004

#define MAX_FILTER_NAME           256

//typedef PFN PFNFILTER;


//******************************************************
// Errorcodes
//******************************************************

#define MMIOERR_FILTER_ALREADY_ACTIVE          1
#define MMIOERR_FILTER_ALREADY_DEACTIVE        2
#define MMIOERR_INVALID_CONNTYPE               3
#define MMIOERR_INVALID_CONNECTOR              4
#define MMIOERR_INACTIVE_CONNECTOR             5
#define MMIOERR_FILTER_INACTIVE                6
#define MMIOERR_FILTER_INVALID_MEDIATYPE       7
#define MMIOERR_OUT_OF_RANGE                   8
#define MMIOERR_INVALID_ATTRIBUTE              9


//******************************************************
// Flags for Connectors
//******************************************************
#define CONNECTOR_ACTIVE     0x00000001
#define INIT_CONNECTOR       0x00000002    // jph addition

//******************************************************
// Flags for ulSetFlags in FILTER_SETUP
//******************************************************
#define CONNECTOR_ACTIVATE   0x00000001
#define CONNECTOR_DEACTIVATE 0x00000002
#define CONNECTOR_SET_SOURCE 0x00000004
#define CONNECTOR_SET_TARGET 0x00000008

//******************************************************
// Flag for ulStateFlag in FILTER_CONNECTION
//******************************************************
#define STATE_DEFAULT_ACTIVE 0x00000010

#define MAX_CONNECTIONS       256

typedef ULONG HFILTER;
typedef HFILTER* PHFILTER;

typedef LONG (* APIENTRY PFNFILTER)( PHFILTER phFilter ,
                                     USHORT   usMsg    ,
                                     ULONG ulParam1    ,
                                     ULONG ulParam2    );

#pragma pack(4)

//**************************************************
// CONNTABLE
//**************************************************
typedef struct _CONNTABLE
{
   ULONG  ulStructLength       ; // Structure length
   ULONG  ulNumInputConns      ; // Number of Input Connectors
   ULONG  ulNumOutputConns     ; // Number of Output Connectors
   PVOID  pInputConnectorData  ; // Pointer to connector information (CONNMAP or FILTER_SETUP)
   PVOID  pOutputConnectorData ; // Pointer to connector information (CONNMAP or FILTER_SETUP)
} CONNTABLE;

typedef CONNTABLE  *PCONNTABLE;  // Pointer to Conntable

/* ulNumInputConns determines number of elements in array
    of ?_CONNECTOR_TYPE structures pointed to by pInputConnectorData  */

/* ulNumOutputConns determines number of elements in array
    of ?_CONNECTOR_TYPE structures pointed to by pOutputConnectorData */


//**************************************************
// FILTERINIFILEINFO
//**************************************************
typedef struct _FILTERINIFILEINFO
{
   ULONG               ulStructLen;
   ULONG               ulFilterSize;
   CHAR                szDLLName[DLLNAME_SIZE];
   CHAR                szProcName[PROCNAME_SIZE];
   CONNTABLE           ConnectorTable;
} FILTERINIFILEINFO;

typedef FILTERINIFILEINFO  *PFILTERINIFILEINFO;


//**************************************************
// FILTERCMDFIELDS
//**************************************************
typedef struct _FILTERCMDFIELDS
{
   ULONG               ulStructLen;
   ULONG               ulCmdFlags;
   ULONG               ulMediaType;
   FOURCC              fcc;
   ULONG               ulInternalFilterIndex;
   ULONG               ulCapsFlags;
   ULONG               ulCompressType;
   ULONG               ulCompressSubType;
   CHAR                szDLLName[DLLNAME_SIZE];
   CHAR                szProcName[PROCNAME_SIZE];
   CHAR                szHWID[MAX_FILTER_NAME];
   CONNTABLE           ConnectorTable;
} FILTERCMDFIELDS;

typedef FILTERCMDFIELDS  *PFILTERCMDFIELDS;


//**************************************************
// BUFTAB
//**************************************************
typedef struct _BUFTAB
{
   PVOID       pBuffer;          // ptr to buffer
   ULONG       ulReserved1;      // reserved for system
   ULONG       ulLength;         // length of buffer
   ULONG       ulMessageParm;    // message for use with event
   ULONG       ulMMTimeOffset;   // offset to generate an event
   PVOID       pFilterSpecific;  // Defined by individual filter
   ULONG       pFilterSpecific2; // Defined by individual filter
} BUFTAB;

typedef BUFTAB  *PBUFTAB;        // Ptr to a buffer entry


//**************************************************
// FILTER_SETUP - this structure is used on MMIOM_FILTER_SET
//**************************************************
typedef struct _FILTER_SETUP
{
   ULONG    ulStructLength ;     // length of structure
   ULONG    ulConnType;          // connector Type - input
   ULONG    ulConnIndex;         // connector Index - input
   ULONG    ulSetFlags;          // Input/Output set flags for particular port
   ULONG    ulNumEntries;        // Number of available buftab entries - input
   HFILTER  hFilter;             // Filter handle of the filter that this  connector is connected to
   ULONG    ulConnection;        // Connector number of filter that this connector is connected to
   ULONG    ulFlags        ;     // filter specific flags
   ULONG    ulBufferSize   ;     // suggested buffer size for the filter to process
   ULONG    ulNumBuffers   ;     // suggested number of buffers.  This is used by SPI
   ULONG    ulBlockAlignment;    // internal block alignment for filter
   PVOID    pMediaHeader   ;     // pointer to media specific header PMMAUDIOHEADER, PMMVIDEOHEADER
   PVOID    pControlInformation; // Control info. for a filter.
   PVOID    pFilterDescription;  // Filter specific information.
} FILTER_SETUP;

typedef FILTER_SETUP  *PFILTER_SETUP;      // Ptr to a FILTER_SETUP


//**************************************************
// CONNMAP - this structure is used on MMIOM_FILTER_RUN
//**************************************************
typedef struct _CONNMAP
{
   ULONG    ulStructLength;      // length of structure
   ULONG    ulConnType;          // connector type  - input
   ULONG    ulConnIndex;         // connector index - input
   ULONG    ulNumEntries;        // Number of available buftab entries - input
   PBUFTAB  pBufTabList;         // Ptr to a buftab array
   ULONG    ulFlags;             // Input/Output flags for particular port
} CONNMAP;

typedef CONNMAP  *PCONNMAP;      // Ptr to a connector map table entry

#define CONNECTOR_EOS    0x00000001   // EOS seen for that connector

#pragma pack()


//**************************************************
// FILTER_CONNECTION
//**************************************************
typedef struct _FILTER_CONNECTION
{
   ULONG      ulMediaType;
   FOURCC     fcc;
   ULONG      ulCapsFlags;
   ULONG      ulStateFlag;
   ULONG      ulNumIndexes;
   ULONG      ulMCIConnectorType;
   ULONG      ulMCIConnectorIndex;
   CHAR       szHWID[MAX_FILTER_NAME];
   CHAR       szMCIAlias[MAX_DEVICE_NAME];
} FILTER_CONNECTION;

typedef FILTER_CONNECTION  *PFILTER_CONNECTION;


//**************************************************
// SAMPLE_RANGES
//**************************************************
typedef struct _SAMPLE_RANGES
{
   ULONG      ulLowRate;
   ULONG      ulHighRate;
} SAMPLE_RANGES;

typedef SAMPLE_RANGES  *PSAMPLE_RANGES;


//**************************************************
// AUDIO_CONNECTOR_TYPE
//**************************************************
typedef struct _AUDIO_CONNECTOR_TYPE
{
   ULONG              ulStructLengthAudio;
   FILTER_CONNECTION  FilterConnection;
// jph addition
   ULONG              ulDefaultFormatTag;
   ULONG              ulDefaultChannel;
   ULONG              ulDefaultBitsPerSample;
   ULONG              ulDefaultSampleRate;
// end jph
   ULONG              ulNumFormatTags;
   ULONG              ulNumChannels;
   ULONG              ulNumBitsPerSample;
   ULONG              ulNumSampleRateRanges;
   ULONG              aFormatTags[MAXFORMATTAGS];
   ULONG              aChannels[MAXCHANNELS];
   ULONG              aBitsPerSample[MAXBITSPERSAMPLE];
   SAMPLE_RANGES      aSampleRateRanges[MAXSAMPLERATERANGES];
} AUDIO_CONNECTOR_TYPE;

typedef AUDIO_CONNECTOR_TYPE  *PAUDIO_CONNECTOR_TYPE;


//**************************************************
// VIDEO_CONNECTOR_TYPE
//**************************************************
typedef struct _VIDEO_CONNECTOR_TYPE
{
   ULONG               ulStructLengthVideo;
   FILTER_CONNECTION   FilterConnection;
   FOURCC              fccColor;
   ULONG               ulSyncMethod;
   ULONG               ulXClipGranularity;
   ULONG               ulYClipGranularity;
   ULONG               ulXAlignment;
   ULONG               ulYAlignment;
   ULONG               ulCompressType;
   ULONG               ulCompressSubType;
   FOURCC              fccPreferredFormat;
} VIDEO_CONNECTOR_TYPE;

typedef VIDEO_CONNECTOR_TYPE  *PVIDEO_CONNECTOR_TYPE;


//**************************************************
// COMMON_CONNECTOR_TYPE
//**************************************************
typedef struct _COMMON_CONNECTOR_TYPE
{
   ULONG               ulStructLength;
   FILTER_CONNECTION   FilterConnection;
} COMMON_CONNECTOR_TYPE;

typedef COMMON_CONNECTOR_TYPE  *PCOMMON_CONNECTOR_TYPE;


//**************************************************
// MIDI_CONNECTOR_TYPE
//**************************************************
typedef struct _MIDI_CONNECTOR_TYPE
{
   ULONG               ulStructLengthMidi;
   FILTER_CONNECTION   FilterConnection;
   ULONG               ulFormat;
   ULONG               ulNumTracks;
   ULONG               ulDivision;
} MIDI_CONNECTOR_TYPE;

typedef MIDI_CONNECTOR_TYPE  *PMIDI_CONNECTOR_TYPE;

// defines for ulFlags field of AUDIO_DESCRIPTOR_TYPE
#define LINEAR_FILTER        0x00000001
#define INIT_CONNECTOR       0x00000002
#define NONLINEAR_FILTER     0x00000004

//**************************************************
// AUDIO_DESCRIPTOR_TYPE
//**************************************************
typedef struct _AUDIO_DESCRIPTOR_TYPE
{
   ULONG   ulStructLen;         /* Length of struct */
   ULONG   ulSamplesPerBlock;   /* Samples in each block of compressed data */
   ULONG   ulBytesPerBlock;     /* uncompressed bytes in each block */
   ULONG   ulFlags;             /* Compression flags */
   ULONG   ulBestGuess;         /* Guess at avg. compression ratio */
   ULONG   ulBlockAlignment;    /* Block alignment of codec */
} AUDIO_DESCRIPTOR_TYPE;

typedef AUDIO_DESCRIPTOR_TYPE  *PAUDIO_DESCRIPTOR_TYPE;


//**************************************************
// FILTER_PARMS  //dwkConnection
//**************************************************
typedef struct _FILTER_PARMS
{
   HWND          hwndCallBack;
   ULONG         ulReturn;
   ULONG         ulRetSize;
   ULONG         ulFlags;
   ULONG         ulValue;
   ULONG         ulActiveSetting;
   ULONG         ulStructLength;
   ULONG         ulCommandLength;
   ULONG         ulSuggestedIncrements;
   ULONG         ulMinValue;
   ULONG         ulMaxValue;
   CHAR          szSettingName[40];
   ULONG         ulCommand[ 1 ];
} FILTER_PARMS;

typedef FILTER_PARMS  *PFILTER_PARMS;


// streaming defines and structures

/******************************************************
 * FTSH - Filter Stream Handler Object ACB
 ******************************************************/
#define ACBTYPE_FTSH_CONNECTOR    0x000AL  /* FTSH connector object        */

                                  /* acbftsh  - FTSH Assoc. Control Block  */
typedef struct _ACB_FTSH_CONNECTOR
{
   // Taken from MTSH
   ULONG        ulACBLen;         /* length of structure                   */
   ULONG        ulObjType;        /* ACBTYPE_FTSH_CONNECTOR                */
   ULONG        ulFlags;          /* flags                                 */
   ULONG        ulConnectorType;  /* connector type to associate           */
   ULONG        ulConnectorIndex; /* connector index within connector type */
   ULONG        ulFilterIndex;    /* Filter index in chain.                */
} ACB_FTSH_CONNECTOR;

typedef ACB_FTSH_CONNECTOR  FAR  *PACB_FTSH_CONNECTOR;   /* Ptr to an ACB  */

#define ACBTYPE_FTSH_FILTER       0x0010L        /* FTSH FILTER object     */

                                  /* acbftsh  - FTSH Assoc. Control Block  */
typedef struct _ACB_FTSH_FILTER
{
   ULONG        ulACBLen;         /* length of structure                   */
   ULONG        ulObjType;        /* ACBTYPE_FTSH_FILTER                   */
   ULONG        numSourceStreams;
   ULONG        numTargetStreams;
   HSTREAM      *pSourceStreams;
   HSTREAM      *pTargetStreams;
   HFILTER      hfilter;
   PFNFILTER    pfnFilter;
   ULONG        ulFilterIndex;    /* Filter index in chain.                */
} ACB_FTSH_FILTER;

typedef ACB_FTSH_FILTER  FAR  *PACB_FTSH_FILTER;         /* Ptr to an ACB  */
// end new filter sh stuff



//       ***********************
//   *****    MCI defines      *****
//       ***********************


#define MCI_NOAUTOCONNECT                   0x00800000L


typedef FILTER_PARMS    MCI_FILTER_PARMS;
typedef FILTER_PARMS  *PMCI_FILTER_PARMS;


// flags for MCI_FILTER message

#define   MCI_FILTER_QUERY          0x00010000L

// flags for use with MCI_FILTER_QUERY

#define   MCI_FILTER_VALUE          0x00000010L
#define   MCI_FILTER_NAME           0x00000020L
#define   MCI_FILTER_MIN            0x00000040L
#define   MCI_FILTER_MAX            0x00000080L
#define   MCI_FILTER_INCREMENT      0x00000100L
#define   MCI_FILTER_NUM            0x00000200L
///////////////////////////////////////////////

#define   MCI_FILTER_SET            0x00020000L

// flags for use with MCI_FILTER_SET
#define   MCI_SET_VALUE            0x00000001L

#define   MCI_FILTER_REMOVE        0x00000004L
#define   MCI_FILTER_ADD           0x00000008L
#define   MCI_FILTER_ACTIVATE      0x00000010L
//////////////////////////////////////////////
#define   MCI_FILTER_SPECIFIC      0x00040000L

// MCI_OPEN additions
#define   MCI_OPEN_FILTER          0x01000000L  // allows direct opens of a filter
#define   MCI_OPEN_MUTIPLE         0x02000000L  // allows multiple filters to be opened


#define MCIDRV_GETDEVICETYPE_ID     914


/*********************************************************************/
/*                                                                   */
/*  MCIDRV_GETDEVICETYPE_ID message flags                            */
/*                                                                   */
/*********************************************************************/

typedef struct _MCIDRV_GETDEVICETYPE_ID_PARMS {
    ULONG      ulDeviceType;    /* Input: Device type to search for  */
    ULONG      ulDeviceID;      /* Output: Device id of device type  */
   } MCIDRV_GETDEVICETYPE_ID_PARMS;

typedef MCIDRV_GETDEVICETYPE_ID_PARMS *PMCIDRV_GETDEVICETYPE_ID_PARMS;



/*********************************************************************/
/*                                                                   */
/*  MCIDRV_GETDEVICETYPE_ID message flags                            */
/*                                                                   */
/*********************************************************************/

typedef struct _PMCI_FILTER_OPEN_PARMS {
    HFILTER            hFilter;  /* Input: Handle to a filter device. */
    PFILTERINIFILEINFO pFiltIni; /* Output: Device id of device type  */
   } MCI_FILTER_OPEN_PARMS;

typedef MCI_FILTER_OPEN_PARMS *PMCI_FILTER_OPEN_PARMS;



// MCI_INFO defines

#define MCI_INFO_BITMAP                     0x00000400L


#define MCIDRV_TEST                         0x00040000L


// MCI connectors
#define MCI_MIDI_STREAM_OUT_CONNECTOR       0x00000001L
#define MCI_WAVE_STREAM_OUT_CONNECTOR       0x00000003L

#define MCI_MIDI_STREAM_IN_CONNECTOR        0x00000016L
#define MCI_WAVE_STREAM_IN_CONNECTOR        0x00000017L


// end MCI defines

//******************************************************
// Function Prototypes
//******************************************************


ULONG APIENTRY mmioIniFileFILTER ( PVOID pFilterIni,
                                   PVOID pFiltCmds,
                                   ULONG ulFlag );

ULONG APIENTRY mmioLoadFilter ( PFNFILTER *pfnFilter,
                                PVOID     pFilterIni,
                                PHMODULE  phModule,
                                PVOID     pFiltCmds,
                                ULONG     ulFlag );

ULONG APIENTRY mmioQueryFilterName ( PVOID  pFilterIni,
                                     PVOID  pFiltCmds,
                                     PSZ    pszFilterName,
                                     PULONG pulBytesRead,
                                     ULONG  ulFlag );

ULONG APIENTRY mmioQueryFilterNameLength ( PVOID  pFilterIni,
                                           PVOID  pFiltCmds,
                                           PULONG pulNameLength,
                                           ULONG  ulFlag );

ULONG APIENTRY mmioQueryFilterBitmap ( PVOID  pFilterIni,
                                       PVOID  pFiltCmds,
                                       PULONG pulBytesRead,
                                       PVOID  pBitmap,
                                       ULONG  ulFlag );

ULONG APIENTRY mmioQueryFilterBitmapLength ( PVOID  pFilterIni,
                                             PVOID  pFiltCmds,
                                             PULONG pulBitmapLength,
                                             ULONG  ulFlag );

ULONG GetFilterINIFile(VOID);

ULONG ValidateFilterParms ( PFILTERINIFILEINFO pFilterIni,
                            PFILTERCMDFIELDS pFiltCmds );

ULONG FilterInstall ( PFILTERINIFILEINFO pFilterIni,
                      PFILTERCMDFIELDS pFiltCmds,
                      PBYTE pFilterList,
                      ULONG ulFilterCount );

ULONG FilterRemove ( PBYTE pFilterList,
                     PFILTERINIFILEINFO pFilterData,
                     ULONG ulAdjustedFilterCount);

ULONG FilterLoad ( PFILTERINIFILEINFO pFilterIni,
                   PFILTERCMDFIELDS pFiltCmds,
                   PFNFILTER *pfnFilter,
                   PHMODULE phModule );

ULONG FilterFind ( PFILTERINIFILEINFO pFilterIni,
                   PFILTERCMDFIELDS pFiltCmds,
                   PBYTE pFilterList,
                   PFILTERINIFILEINFO *pFilterData,
                   ULONG ulFilterCount,
                   ULONG *ulAdjustedFilterCount );

ULONG RestorePointers ( PBYTE pFilterList, ULONG ulFilterCount );

ULONG FilterIniWrite ( ULONG ulFilterCount,
                       PBYTE pFilterList,
                       ULONG ulFileSize );

ULONG CompareAudioConnector ( PAUDIO_CONNECTOR_TYPE pCurrConnType,
                              PAUDIO_CONNECTOR_TYPE pMatchConnTypeList );

ULONG CompareVideoConnector ( PVIDEO_CONNECTOR_TYPE pCurrConnType,
                              PVIDEO_CONNECTOR_TYPE pMatchConnTypeList );

ULONG CompareMidiConnector ( PMIDI_CONNECTOR_TYPE pCurrConnType,
                             PMIDI_CONNECTOR_TYPE pMatchConnTypeList );

#ifdef INCL_MMIO_CODEC
PCODECPROC CodecLoad ( PCODECINIFILEINFO pFilterIni,
                       ULONG pFiltCmds,
                       PCODECPROC pfnFilter,
                       PHMODULE phModule );


ULONG ValidateCodecParms ( PCODECINIFILEINFO pFilterIni,
                           ULONG pFiltCmds );

#endif

#endif
