#==============================================================================
#
#  AVCINST Sample Makefile
#
#  Copyright (C) 1995 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#==============================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

include ..\..\ibmsamp.inc

HEADERS =  avcinst.h

#===================================================================
#
#   A list of all of the object files
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
OBJECTS = avcinst.obj
!else
!if "$(TARGET_PROC)"=="PPC"
OBJECTS = avcinst.obj avcrcout.obj
!if "$(CSETPPC)" == "1"
ICCFLAGS         = /c /Gd- /Se /Re /ss /Ms /Gm+
CC             = icc $(ICCFLAGS)
.c.obj:
   $(CC) -Fo$*.obj $*.c
!endif
!endif
!endif

#===================================================================
#
#   A list of all of the Help files
#
#===================================================================
IPFS = avcinst.ipf

#===================================================================
#
#   Dependencies
#
#===================================================================

all: avcinst.exe avcinst.hlp

!if "$(TARGET_PROC)"=="386"
avcinst.res: avcinst.rc avcinst.dlg avcinst.h avcinst.ico prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC"
avcrcout.obj: avcinst.rc avcinst.dlg avcinst.h avcinst.ico prodinfo.bmp
        $(RC) -As,avcinst.rc -- $@
        del prodinfo.bmp
!endif
!endif

prodinfo.bmp :
                copy ..\..\prodinfo.bmp prodinfo.bmp

avcinst.obj: avcinst.c $(HEADERS)

avcinst.hlp: $(IPFS)

!if "$(TARGET_PROC)"=="386"
avcinst.exe: $(OBJECTS) avcinst.def avcinst.res
    $(LINK) @<<avcinst.lnk
$(OBJECTS: =+^
)
$@
$(@B).map
$(MTLIBS) + mmpm2
$(@B).def
<<keep
    rc -p -x avcinst.res avcinst.exe
!else
!if "$(TARGET_PROC)"=="PPC"
avcinst.exe : $(OBJECTS) avcinst.def
        $(LINK) $(MMFLAGS) $(LFLAGS) $@ $(DEFOPTS)avcinst.def $(OBJECTS)
!endif
!endif

clean :
        if exist *.exe del *.exe
        if exist *.obj del *.obj
        if exist *.dll del *.dll
