#==============================================================================
#
#  CAPSAMP Sample Makefile
#
#  Copyright (C) 1995 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#==============================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

include ..\..\ibmsamp.inc

HEADERS =  capsamp.h captions.h

#===================================================================
#
#   A list of all of the object files
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
OBJECTS = capsamp.obj
!else
!if "$(TARGET_PROC)"=="PPC"
OBJECTS = capsamp.obj caprcout.obj
!endif
!endif

#===================================================================
#
#   A list of all of the Help files
#
#===================================================================
IPFS = capsamp.ipf

#===================================================================
#
#   Dependencies
#
#===================================================================

all: capsamp.exe capsamp.hlp

!if "$(TARGET_PROC)"=="386"
capsamp.res: capsamp.rc capsamp.dlg capsamp.h capsamp.ico
!else
!if "$(TARGET_PROC)"=="PPC"
caprcout.obj: capsamp.rc capsamp.dlg capsamp.h capsamp.ico
        $(RC) -As,capsamp.rc -- $@
!endif
!endif

capsamp.obj: capsamp.c $(HEADERS)

capsamp.hlp: $(IPFS)

!if "$(TARGET_PROC)"=="386"
capsamp.exe: $(OBJECTS) capsamp.def capsamp.res
    $(LINK) @<<capsamp.lnk
$(OBJECTS: =+^
)
$@
$(@B).map
$(MTLIBS) + mmpm2
$(@B).def
<<keep

    rc -p -x capsamp.res capsamp.exe
!else
!if "$(TARGET_PROC)"=="PPC"
capsamp.exe : $(OBJECTS) capsamp.def
        $(LINK) $(MMFLAGS) $(LFLAGS) $@ $(DEFOPTS)capsamp.def $(OBJECTS)
!endif
!endif

clean :
        if exist *.exe del *.exe
        if exist *.obj del *.obj
        if exist *.dll del *.dll
