#==============================================================================
#
#  CAPTION Sample Makefile
#
#  Copyright (C) 1995 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#==============================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

include ..\..\ibmsamp.inc

HEADERS =  caption.h

#===================================================================
#
#   A list of all of the object files
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
OBJECTS = caption.obj
!else
!if "$(TARGET_PROC)"=="PPC"
OBJECTS = caption.obj caprcout.obj
!endif
!endif

#===================================================================
#
#   A list of all of the Help files
#
#===================================================================
IPFS = caption.ipf

#===================================================================
#
#   Dependencies
#
#===================================================================

all: caption.exe caption.hlp

!if "$(TARGET_PROC)"=="386"
caption.res: caption.rc caption.dlg caption.h
!else
!if "$(TARGET_PROC)"=="PPC"
caprcout.obj: caption.rc caption.dlg caption.h
        $(RC) -As,caption.rc -- $@
!endif
!endif

caption.obj: caption.c $(HEADERS)

caption.hlp: $(IPFS)

!if "$(TARGET_PROC)"=="386"
caption.exe: $(OBJECTS) caption.def caption.res
    $(LINK) @<<caption.lnk
$(OBJECTS: =+^
)
$@
$(@B).map
$(MTLIBS) + mmpm2
$(@B).def
<<keep
    rc -p -x caption.res caption.exe
!else
!if "$(TARGET_PROC)"=="PPC"
caption.exe : $(OBJECTS) caption.def
        $(LINK) $(MMFLAGS) $(LFLAGS) $@ $(DEFOPTS)caption.def $(OBJECTS)
!endif
!endif

clean :
        if exist *.exe del *.exe
        if exist *.obj del *.obj
        if exist *.dll del *.dll
